#ifndef FUNCTIONCALCULATE_H
#define FUNCTIONCALCULATE_H

#include "../LispFunctionBase.h"
#include "../miscellaneous.h"
#include "../Options.h"

class FunctionCalculate : public LispFunctionBase
{
public:
    FunctionCalculate() : LispFunctionBase(Options::instance().application) {}
    const dsString groupName() const { return Options::instance().ApiUuid; }
    const dsString functionName() const { return L"calculate"; }
    const dsString description() const { return
        L"<p>Usage example: (calculate \"+\" 1 2 3 4) returns 10.</p>"
        L"<p>Supported operators are \"+\", \"-\" and \"*\".</p>";
    }
    bool ExecuteFunctionNotify();
};

#endif // FUNCTIONCALCULATE_H
