#include "dsCommandMessage_c.h"
#include "CommandUnregister.h"
#include <sstream>

bool CommandUnregister::ExecuteNotify(void)
{
    // Get DraftSight command line interface
    dsCommandMessage_ptr commandline;
    application->GetCommandMessage( &commandline );

    // Show all available lisp functions
    commandline->PrintLine(L"<b>Available lisp functions:</b>");
    std::map<dsString,LispFunctionBase*>::iterator i;
    for (i = lisp->begin(); i != lisp->end(); ++i)
	{
		std::wostringstream prompt;
		prompt << L"<i>"
               << (wchar_t*)i->second->functionName()
			   << L"<i>";
        commandline->PrintLine( prompt.str().c_str() );
	}

    // Untranslated global keywords
    dsStringArray global_keywords;
    global_keywords.add(L"_All");

    // Translated local keywords
    dsStringArray local_keywords;
    local_keywords.add(L"All");

    // Specify function to register
    dsPromptResultType_e result;
    dsString keyword, function_name;
    commandline->PromptForStringOrKeyword(
        true,
        L"Specify function name",
        L"",
        global_keywords,
        local_keywords,
        0,
        L"",
        &keyword,
        &function_name,
        &result);

    if (result == dsPromptResultType_Keyword)
        return unregister_all_lisp_functions();
    else if (result != dsPromptResultType_Value)
        return false;

    // Register the function, if it is in the list
    i = lisp->find(function_name);
    if (i != lisp->end())
    {
        // Get the active document
        dsDocument_ptr doc;
        application->GetActiveDocument(&doc);

        // Unregister lisp function
        i->second->unregisterFunction();
        if (i->second->removeFunction(doc) == DSRESULT_True)
        {
            i->second->registerFunction();
			std::wostringstream prompt;
			prompt << L"Successfully unregistered "
				   << (wchar_t*)i->second->functionName();
			commandline->PrintLine( prompt.str().c_str() );
        } 
        else
        {
			std::wostringstream prompt;
			prompt << L"Could not unregister "
				   << (wchar_t*)i->second->functionName();
			commandline->PrintLine( prompt.str().c_str() );
        }
    } 
    else // function name is not in the list
    {
		std::wostringstream prompt;
		prompt << L"Could not find function "
			   << (wchar_t*)function_name;
		commandline->PrintLine( prompt.str().c_str() );
    }

    return true; 
}

bool CommandUnregister::unregister_all_lisp_functions()
{
    bool result = true;

    // Get DraftSight command line interface
    dsCommandMessage_ptr commandline;
    application->GetCommandMessage( &commandline );

    std::map<dsString,LispFunctionBase*>::iterator i;
    for (i = lisp->begin(); i != lisp->end(); ++i)
    {
        // Get the active document
        dsDocument_ptr doc;
        application->GetActiveDocument(&doc);

        // Register lisp function
        i->second->unregisterFunction();
        if (i->second->removeFunction(doc) == DSRESULT_True)
        {
            i->second->unregisterFunction();
			std::wostringstream prompt;
			prompt << L"Successfully unregister "
				   << (wchar_t*)i->second->functionName();
			commandline->PrintLine( prompt.str().c_str() );
        } 
        else
        {
			std::wostringstream prompt;
			prompt << L"Could not unregister "
				   << (wchar_t*)i->second->functionName();
			commandline->PrintLine( prompt.str().c_str() );
            result = false;
        }
    }
    return result;
}
