#ifndef COMMANDREGISTER_H
#define COMMANDREGISTER_H

#include <map>

#include "../LispFunctionBase.h"
#include "../Options.h"
#include "../miscellaneous.h"
#include "../CommandBase.h"

class CommandRegister : public CommandBase
{
public:
    CommandRegister(std::map<dsString,LispFunctionBase*> *lisp)
        : CommandBase(Options::instance().application)
        , lisp(lisp)
    {}

    const dsString groupName() const { return Options::instance().ApiUuid; }
    const dsString globalName() const { return L"_LSREGISTER"; }
    const dsString localName() const { return L"LSREGISTER"; }
    const dsString Description() const { return L"Registers one or all of this sample's Lisp functions"; }
    const dsString ItemName() const { return L"Register Lisp function"; }

    bool ExecuteNotify();

protected:
    bool register_all_lisp_functions();
    std::map<dsString,LispFunctionBase*> *lisp;
};

#endif // COMMANDREGISTER_H
