#ifndef COMMANDDIALOG_H
#define COMMANDDIALOG_H

#include "../Options.h"
#include "../CommandBase.h"
#include "dsColorPicker_c.h"
#include "ui/dsColorPickerButton.h"

class CommandDialog : public CommandBase
{
public:
    CommandDialog() : CommandBase(Options::instance().application) {}
    const dsString groupName() const { return Options::instance().ApiUuid; }
    const dsString globalName() const { return L"_OPENCOLORPICKER"; }
    const dsString localName() const { return L"OPENCOLORPICKER"; }
    const dsString Description() const { return L"Opens the Color Picker"; }
    const dsString ItemName() const { return L"Open Color Picker"; }

    bool ExecuteNotify();

private:
	dsColorPicker m_colorPicker;
};

#endif // COMMANDDIALOG_H
