#ifndef DS_ADDIN_CONNECTION_H
#define DS_ADDIN_CONNECTION_H

/*
Sample Name: BlockTrackerDemo

Sample Description:
    This sample demonstrates the usage of block trackers. It simply creates
    a block and inserts it into the drawing showing trackers for insertion,
    scale and rotation.

Usage:
    This example has one command, which can be invoked using either the
    command line or by using the menu "BlockTrackerDemo".

    _BLOCKTRACKERDEMO
        Creates a block and prompts the user to insert, scale and rotate it
        using trackers.

Overview:
    Put in a few words, this add-in consists of the following parts:

    Functionality:
        The actual job is done by the _BLOCKTRACKERDEMO command.

    Command classes:
        _BLOCKTRACKERDEMO derive from CommandBase. This base class provides
        an interface for both, registering a command to be used from the
        command line via CommandBase::registerCommand() as well as putting
        a command into a menu item via CommandBase::createUserCommand(), so
        done in BlockCustomDataApplication::CreateUserInterfaceAndCommands().

    Globally available options:
        This singleton Options class holds a globally accessible pointer
        to the dsApplication_c instance and to this add-in's ID.
        Furthermore, there is the miscellaneous.h, a collection of useful
        functions for converting between dsAPI and Qt classes. These
        functions are used throughout the add-in.

Interface used:
    dsBlockDefinition_c
    dsBlockInstance_c
    dsTracker_c
    dsMathPoint_c
*/

#include "dsApplication_c.h"
#include "dsInterfacePtr.h"

#include "BlockTrackerDemo_global.h"

// You can append new commands like this:
// 1 - Append the header file here.
// 2 - Add the command as a private member of BlockTrackerDemoApplication.
// 3 - Go to bool BlockTrackerDemoApplication::CreateUserInterfaceAndCommands() and:
//     1 - Register your command using the registerCommand()
//         (then the command can be invoked from the command line).
//     2 - If it makes sense, add it to the user menu
//         (then the command can be invoked from the user menu as well).
#include "commands/CommandBlockTrackerDemo.h"

class BlockTrackerDemo_EXPORT BlockTrackerDemoApplication 
{
public:
    BlockTrackerDemoApplication(dsApplication_c *dsApp) : application(dsApp){}

    dsApplication_c* getDsApp() { return application; } 
    void CreateUserInterfaceAndCommands();
    static const dsString appID;

private:
    dsApplication_ptr application;
    CommandBlockTrackerDemo m_CommandBlockTrackerDemo;
};

#endif // DS_ADDIN_CONNECTION_H
