#pragma once

#include "../Options.h"
#include "../miscellaneous.h"
#include "../CommandBase.h"

#include "dsTracker_c.h"
#include "dsBlockDefinition_c.h"
#include "dsBlockInstance_c.h"

class CommandBlockTrackerDemo : public CommandBase
{
public:
    CommandBlockTrackerDemo();
    virtual ~CommandBlockTrackerDemo();
    const dsString groupName() const { return Options::instance().ApiUuid; }
    const dsString globalName() const { return L"_BLOCKTRACKERDEMO"; }
    const dsString localName() const { return L"BLOCKTRACKERDEMO"; }
    const dsString Description() const { return L"Insert, scale and rotate a given block"; }
    const dsString ItemName() const { return L"BlockTrackerDemo"; }

    bool ExecuteNotify();

    DeclareTrackerUpdateNotifyHook
    bool UpdateNotify(dsMathPoint_c *CursorPosition);
    double GetAngle(double x1, double y1, double x2, double y2);

private:
    dsTracker_ptr m_InsertionTracker;
    dsTracker_ptr m_ScaleTracker;
    dsTracker_ptr m_RotationTracker;
    int m_TrackerType;
    dsBlockInstance_ptr m_BlockInstance;
    dsMathPoint_ptr m_point;
};