#include "../stdafx.h"
#include <cmath>
#include "CommandBlockTrackerDemo.h"
#include "dsCommandMessage_c.h"

CommandBlockTrackerDemo::CommandBlockTrackerDemo()
: CommandBase(Options::instance().application)
, m_InsertionTracker(0)
, m_ScaleTracker(0)
, m_RotationTracker(0)
, m_TrackerType(0)
{
    application->CreateTracker(&m_InsertionTracker);
    application->CreateTracker(&m_ScaleTracker);
    application->CreateTracker(&m_RotationTracker);

    RegisterTrackerUpdateNotifyHook(m_InsertionTracker);
    RegisterTrackerUpdateNotifyHook(m_ScaleTracker);
    RegisterTrackerUpdateNotifyHook(m_RotationTracker);
}

CommandBlockTrackerDemo::~CommandBlockTrackerDemo()
{
    UnRegisterTrackerUpdateNotifyHook(m_InsertionTracker);
    UnRegisterTrackerUpdateNotifyHook(m_ScaleTracker);
    UnRegisterTrackerUpdateNotifyHook(m_RotationTracker);
}

ImplementTrackerUpdateNotifyHook(CommandBlockTrackerDemo)
bool CommandBlockTrackerDemo::ExecuteNotify()
{
    // Get the command line interface.
    dsCommandMessage_ptr commandline;
    application->GetCommandMessage( &commandline );

    // Get Active document
    dsDocument_ptr doc;
    application->GetActiveDocument(&doc);

    // Get Model
    dsModel_ptr model;
    doc->GetModel(&model);

    // Get Sketch Manager
    dsSketchManager_ptr sketch_manager;
    model->GetSketchManager(&sketch_manager);

    // Turn On TemporaryEntityMode
    application->put_TemporaryEntityMode( true );

    dsPolyLine_ptr PolyLine;
    dsLine_ptr dsLine;
    dsBlockDefinition_ptr dsBlkDef;

    //Draw a rectangle
    dsDoubleArray Coordinates;
    Coordinates.add(0);Coordinates.add(0);
    Coordinates.add(10);Coordinates.add(0);
    Coordinates.add(10);Coordinates.add(10);
    Coordinates.add(0);Coordinates.add(10);
    sketch_manager->InsertPolyline2D( Coordinates, true, &PolyLine );
    sketch_manager->InsertLine(0, 0, 0, 10, 10, 0, &dsLine);

    dsObjectPtrArray dsEntities;
    dsLongArray dsEntityTypes; 
    doc->CreateBlockDefinition(
        L"SampleBlock",
        L"Sample block definition",
        0, 0, 0,
        dsEntityTypes,
        dsEntities,
        dsBlockDefinitionEntities_PreserveAsSeparateEntities,
        &dsBlkDef);

    dsBlkDef->AddTemporaryEntity( dsLine );
    dsBlkDef->AddTemporaryEntity( PolyLine );
    sketch_manager->InsertBlock(L"SampleBlock", 0, 0, 0, 1, 0, &m_BlockInstance);

    // Turn Off TemporaryEntityMode
    application->put_TemporaryEntityMode( false ); 
    double pickX = 0, pickY = 0, pickZ = 0;
    bool result;

    dsMathUtility_ptr pMathUtil;
    application->GetMathUtility( &pMathUtil );
    dsMathPlane_ptr plane;
    pMathUtil->CreateXYPlane( &plane );

    m_TrackerType = 1; // Tracker for Insertion point
    m_InsertionTracker->AddTemporaryEntity( m_BlockInstance );
    commandline->AddTracker( m_InsertionTracker );	
    commandline->PromptForPoint2(
        L"Specify insertion point",
        false,
        0, 0, 0,
        &pickX, &pickY, &pickZ,
        plane,
        &result );
    m_InsertionTracker->RemoveTemporaryEntity( m_BlockInstance );
    commandline->RemoveTracker( m_InsertionTracker );
    if (!result)
        return false;

    m_BlockInstance->SetPosition(pickX, pickY, pickZ);

    m_TrackerType = 2; // Tracker for Scale rectangle
    m_ScaleTracker->AddTemporaryEntity( m_BlockInstance );
    commandline->AddTracker( m_ScaleTracker );
    commandline->PromptForPoint2(
        L"Specify opposite corner",
        false,
        0, 0, 0,
        &pickX, &pickY, &pickZ,
        plane,
        &result );
    m_ScaleTracker->RemoveTemporaryEntity( m_BlockInstance );
    commandline->RemoveTracker( m_ScaleTracker );
    if (!result)
        return false;

    double x = 0.0, y = 0.0, z = 0.0;
    m_BlockInstance->GetPosition(&x, &y, &z);
    double distX = pickX - x;
    double distY = pickY - y;
    if ( distX != 0.0 || distY != 0.0 )
    {
        m_BlockInstance->SetScales( distX, distY, distX );
    }

    pMathUtil->CreatePoint( x, y, 0.0, &m_point );

    m_TrackerType = 3; // Tracker for Rotate rectangle
    m_RotationTracker->AddTemporaryEntity( m_BlockInstance );
    commandline->AddTracker( m_RotationTracker );
    commandline->PromptForPoint2(
        L"Specify rotation point",
        false,
        0, 0, 0,
        &pickX, &pickY, &pickZ,
        plane,
        &result );
    m_RotationTracker->RemoveTemporaryEntity( m_BlockInstance );
    commandline->RemoveTracker( m_RotationTracker );
    if (!result)
        return false;

    m_point->GetPosition( &x, &y, &z );

    //get rotation angle
    double rotationAngle = GetAngle( x, y, pickX, pickY );
    m_BlockInstance->put_Rotation(rotationAngle);
    sketch_manager->AddTemporaryEntity(m_BlockInstance);
    return true; 
}

bool CommandBlockTrackerDemo::UpdateNotify(dsMathPoint_c *CursorPosition)
{
    double cursorX = 0, cursorY = 0, cursorZ = 0;
    CursorPosition->GetPosition( &cursorX, &cursorY, &cursorZ );
    switch( m_TrackerType )
    {
    case 1: // Tracker for Insertion
        m_BlockInstance->SetPosition(cursorX, cursorY, cursorZ);
        break;
    case 2: // Tracker for Scale
        {
            double x = 0.0, y = 0.0, z = 0.0;
            m_BlockInstance->GetPosition(&x, &y, &z);
            double distX = cursorX - x;
            double distY = cursorY - y;
            if ( distX == 0.0 || distY == 0.0 )
                break;

            m_BlockInstance->SetScales( distX, distY, distX );
        }
        break;
    case 3: // Tracker for Rotation
        {
            double x = 0.0, y = 0.0, z = 0.0;
            m_point->GetPosition( &x, &y, &z );
            dsMathUtility_ptr dsMathUtility;
            application->GetMathUtility(&dsMathUtility);

            //get rotation angle
            double rotationAngle = GetAngle( x, y, cursorX, cursorY );
            m_BlockInstance->put_Rotation(rotationAngle);
        }
        break;
    default: break;
    }
    return true;
}

double CommandBlockTrackerDemo::GetAngle(double x1, double y1, double x2, double y2)
{
    double dirX = x2 - x1;
    double dirY = y2 - y1;
    double ang;
    ang = std::atan2(dirY, dirX);
    return ang;
}
