#ifndef COMMANDSETLIBRARYROOTPATH_H
#define COMMANDSETLIBRARYROOTPATH_H

#include <QCoreApplication>
#include "../ui/BlockLibraryWidget.h"
#include "../Options.h"
#include "../miscellaneous.h"
#include "../CommandBase.h"

class CommandSetLibraryRootPath : public CommandBase
{
    Q_DECLARE_TR_FUNCTIONS(CommandSetLibraryRootPath)
public:
    CommandSetLibraryRootPath()
        : CommandBase(Options::instance().application)
        , block_library_widget(0)
    {}
    const dsString groupName() const { return Options::instance().ApiUuid; }
    const dsString globalName() const { return L"_BLMSETLIBRARYROOTPATH"; }
    const dsString localName() const { return q2d(tr("BLMSETLIBRARYROOTPATH")); }
    const dsString Description() const { return q2d(tr("Sets a new library root path")); }
    const dsString ItemName() const { return q2d(tr("Set library root path")); }

    bool ExecuteNotify();
    void setBlockLibraryWidget(BlockLibraryWidget *w) { block_library_widget = w; }

protected:
    BlockLibraryWidget *block_library_widget;
};

#endif // COMMANDSETLIBRARYROOTPATH_H
