#include <QDir>

#include "dsDocument_c.h"
#include "dsCommandMessage_c.h"
#include "dsInterfacePtr.h"

#include "../Options.h"
#include "CommandSetLibraryRootPath.h"

bool CommandSetLibraryRootPath::ExecuteNotify()
{
    bool result;
    dsString s;
    dsCommandMessage_ptr commandline;
    application->GetCommandMessage(&commandline);

    commandline->PromptForString(
        true,
        q2d(tr("Specify library root path")),
        q2d(Options::instance().library_root_path),
        &s,
        &result);
    if (!result || s.getSize() <= 1) // i.e. s is empty containing only \0
        return false;
    Options::instance().library_root_path = d2q(s);

    if (!QDir(Options::instance().library_root_path).exists())
    {
        commandline->PrintLine(q2d(tr(
            "<p style=\"color:#999900;font-weight:bold\">"
            "\"%1\" does not exist."
            "</p>")
            .arg(Options::instance().library_root_path)));
    }
    else if (block_library_widget)
    {
        block_library_widget->setLibraryRoot(Options::instance().library_root_path);
    }

    return true; 
}
