#include "dsCommandMessage_c.h"
#include "dsDocument_c.h"
#include "dsModel_c.h"
#include "dsSketchManager_c.h"
#include "dsInterfacePtr.h"

#include "miscellaneous.h"
#include "BlockLibraryManager.h"

bool BlockLibraryManager::insert()
{
    if (m_drawings.size() == 0)
        return false;

    // Get DraftSight command line interface
    dsCommandMessage_ptr commandline;
    application->GetCommandMessage(&commandline);

    // Get the active document to get the model to get the
    // sketch manager in order to insert blocks.
    dsDocument_ptr doc;
    application->GetActiveDocument(&doc);
    dsModel_ptr model;
    doc->GetModel(&model);
    dsSketchManager_ptr sketchmanager;
    model->GetSketchManager(&sketchmanager);

    // Iterate over all drawings
    foreach (QString filename, m_drawings)
    {
        commandline->PrintLine(q2d(tr(
            "<p style=\"color:#0033cc;font-weight:bold\">"
            "Inserting \"%1\":"
            "</p>")
            .arg(filename)));

        // Prompt for block insertion
        dsPromptResultType_e result;
        double x = 0, y = 0, z = 0;
        double scale_x = m_scale_x, scale_y = m_scale_y, scale_z = m_scale_z;
        double rotation = m_rotation / 180 * 3.1415926535897932384626433832795;
        commandline->PromptForBlockInsertion(
            q2d(filename),
            m_specify_scale,
            m_scale_x, m_scale_y, m_scale_z,
            m_specify_rotation,
            m_rotation,
            &x, &y, &z,
            &scale_x, &scale_y, &scale_z,
            &rotation,
            &result);
        if (result != dsPromptResultType_Value)
            return false;

        // Insert the block
        dsBlockInstance_ptr block;
        sketchmanager->InsertBlock2(
            q2d(filename),
            x, y, z,
            scale_x, scale_y, scale_z,
            rotation,
            &block); 
    }
    commandline->PrintLine(q2d(tr(
        "<p style=\"color:#99cc00;font-weight:bold\">"
        "%1 block(s) inserted."
        "</p>")
        .arg(m_drawings.size())));

    return true;
}
