#include "dsCommandMessage_c.h"
#include "CommandCreateNewBlock.h"
#include <sstream>

bool CommandCreateNewBlock::ExecuteNotify(void)
{
    // Get the command line interface.
    dsCommandMessage_ptr commandline;
    application->GetCommandMessage( &commandline );

    // Get the active document to get the model to get the sketch manager.
    dsDocument_ptr doc;
    application->GetActiveDocument(&doc);
    dsModel_ptr model;
    doc->GetModel(&model);
    dsSketchManager_ptr sketchmanager;
    model->GetSketchManager(&sketchmanager);
    dsLayerManager_ptr layermanager;
    doc->GetLayerManager(&layermanager);

    // Create a layer "two_circles_layer".
    dsCreateObjectResult_e create_result;
    dsLayer_c *old_active_layer;
    layermanager->GetActiveLayer(&old_active_layer);
    dsLayer_c *layer;
    layermanager->CreateLayer(L"two_circles_layer", &layer, &create_result);
    switch (create_result)
    {
    case dsCreateObjectResult_Error:
        commandline->PrintLine(L"Could not create layer.");
        return false;
    case dsCreateObjectResult_AlreadyExists:
        commandline->PrintLine(L"This layer already exists.");
        return false;
    default: break;
    }

    // Activate "two_circles_layer".
    bool activated;
    layer->Activate(&activated);

    // Draw two circles on "two_circles_layer"
    dsCircle_ptr circle1;
    sketchmanager->InsertCircle(0.0, 0.0, 0.0, 2.0, &circle1);
    dsCircle_ptr circle2;
    sketchmanager->InsertCircle(0.0, 1.0, 0.0, 2.0, &circle2);

    // Reactivate the previously active layer.
    old_active_layer->Activate(&activated);

    // Make a block out of the two circles and remove them
    // from the drawing again.
    dsObjectPtrArray objects;
    objects.add(circle1);
    objects.add(circle2);
    dsLongArray objecttypes;
    objecttypes.add(dsCircleType);
    objecttypes.add(dsCircleType);
    dsBlockDefinition_ptr block;
    doc->CreateBlockDefinition(
        L"*U",
        L"Two circles",
        0.0, 0.0, 0.0,
        objecttypes,
        objects,
        dsBlockDefinitionEntities_RemoveFromDrawing,
        &block);

    // Memorize the block's name.
    block->GetName(&Options::instance().LastBlockName);
	std::wostringstream prompt;
	prompt << L"Block "
    << (wchar_t*)Options::instance().LastBlockName
	<< L" with two circles created.";
    commandline->PrintLine( prompt.str().c_str() );

    return true; 
}
