/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class ExecRunner {
    private ArrayList<ProcessBuilder> procBuilders = new ArrayList();
    private OutputStream outputStream = null;

    public ExecRunner(OutputStream outStream) {
        this.outputStream = outStream;
    }

    protected OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void addExecCommand(ArrayList<String> commandArgs) {
        this.addExecCommand(commandArgs.toArray(new String[commandArgs.size()]));
    }

    public void addExecCommand(String ... commandString) {
        this.procBuilders.add(new ProcessBuilder(commandString));
    }

    public boolean execCommands() {
        boolean returnVal = false;
        if (!this.procBuilders.isEmpty()) {
            try {
                Process proc = null;
                for (ProcessBuilder procBuilder : this.procBuilders) {
                    if (this.outputStream != null) {
                        procBuilder.redirectErrorStream(true);
                        proc = procBuilder.start();
                        this.pipeProcOutputToOutputStream(proc.getInputStream());
                        continue;
                    }
                    proc = procBuilder.start();
                }
                if (proc != null) {
                    proc.waitFor();
                    returnVal = proc.exitValue() == 0;
                } else {
                    returnVal = false;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return returnVal;
    }

    private void pipeProcOutputToOutputStream(InputStream inStream) throws IOException {
        int inputChar = 0;
        do {
            try {
                inputChar = inStream.read();
                if (inputChar == -1) continue;
                this.outputStream.write(inputChar);
                this.outputStream.flush();
            }
            catch (IOException ioex) {
                if (inputChar != -1) continue;
                this.outputStream.flush();
                return;
            }
        } while (inputChar != -1);
        this.outputStream.flush();
    }
}

