/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.jsa.sequencer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.base.MidiSequencer;
import org.herac.tuxguitar.player.base.MidiSequencerProvider;
import org.herac.tuxguitar.player.impl.jsa.sequencer.MidiSequencerImpl;

public class MidiSequencerProviderImpl
implements MidiSequencerProvider {
    public List<MidiSequencer> listSequencers() throws MidiPlayerException {
        try {
            ArrayList<MidiSequencer> sequencers = new ArrayList<MidiSequencer>();
            MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
            for (int i = 0; i < infos.length; ++i) {
                try {
                    MidiDevice device;
                    Iterator it = sequencers.iterator();
                    boolean exists = false;
                    while (it.hasNext()) {
                        if (!((MidiSequencer)it.next()).getKey().equals(infos[i].getName())) continue;
                        exists = true;
                        break;
                    }
                    if (exists || !((device = MidiSystem.getMidiDevice(infos[i])) instanceof Sequencer)) continue;
                    sequencers.add(new MidiSequencerImpl((Sequencer)device));
                    continue;
                }
                catch (MidiUnavailableException e) {
                    throw new MidiPlayerException(TuxGuitar.getProperty((String)"jsa.error.midi.unavailable"), (Throwable)e);
                }
            }
            return sequencers;
        }
        catch (Throwable t) {
            throw new MidiPlayerException(TuxGuitar.getProperty((String)"jsa.error.unknown"), t);
        }
    }

    public void closeAll() throws MidiPlayerException {
    }
}

