/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.jsa.sequencer;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;
import org.herac.tuxguitar.player.base.MidiSequenceHandler;
import org.herac.tuxguitar.player.impl.jsa.message.MidiMessageFactory;
import org.herac.tuxguitar.player.impl.jsa.sequencer.MidiSequenceLoader;
import org.herac.tuxguitar.song.models.TGTimeSignature;

public class MidiSequenceHandlerImpl
extends MidiSequenceHandler {
    private MidiSequenceLoader loader;
    private Sequence sequence;
    private Track[] midiTracks;

    public MidiSequenceHandlerImpl(MidiSequenceLoader loader, int tracks) {
        super(tracks);
        this.loader = loader;
        this.init();
    }

    private void init() {
        try {
            this.sequence = new Sequence(0.0f, 960);
            this.midiTracks = new Track[this.getTracks()];
            for (int i = 0; i < this.midiTracks.length; ++i) {
                this.midiTracks[i] = this.sequence.createTrack();
            }
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void addEvent(int track, MidiEvent event) {
        if (track >= 0 && track < this.midiTracks.length) {
            this.midiTracks[track].add(event);
        }
    }

    public void addNoteOff(long tick, int track, int channel, int note, int velocity, int voice, boolean bendMode) {
        this.addEvent(track, new MidiEvent(MidiMessageFactory.noteOff(channel, note, velocity, voice, bendMode), tick));
    }

    public void addNoteOn(long tick, int track, int channel, int note, int velocity, int voice, boolean bendMode) {
        this.addEvent(track, new MidiEvent(MidiMessageFactory.noteOn(channel, note, velocity, voice, bendMode), tick));
    }

    public void addPitchBend(long tick, int track, int channel, int value, int voice, boolean bendMode) {
        this.addEvent(track, new MidiEvent(MidiMessageFactory.pitchBend(channel, value, voice, bendMode), tick));
    }

    public void addControlChange(long tick, int track, int channel, int controller, int value) {
        this.addEvent(track, new MidiEvent(MidiMessageFactory.controlChange(channel, controller, value), tick));
    }

    public void addProgramChange(long tick, int track, int channel, int instrument) {
        this.addEvent(track, new MidiEvent(MidiMessageFactory.programChange(channel, instrument), tick));
    }

    public void addTempoInUSQ(long tick, int track, int usq) {
        this.addEvent(track, new MidiEvent(MidiMessageFactory.tempoInUSQ(usq), tick));
    }

    public void addTimeSignature(long tick, int track, TGTimeSignature ts) {
        this.addEvent(track, new MidiEvent(MidiMessageFactory.timeSignature(ts), tick));
    }

    public void notifyFinish() {
        this.loader.setSequence(this.getSequence());
    }
}

