/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.action.note;

import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.action.TGActionManager;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionBase;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.util.TGContext;

public class TGSetNoteFretNumberAction
extends TGActionBase {
    public static final String NAME_PREFIX = "action.note.general.set-fret-number-";
    private static final int DELAY = 1000;
    private static int lastAddedFret;
    private static int lastAddedString;
    private static long lastAddedStart;
    private static long lastAddedTime;
    private int number;

    public TGSetNoteFretNumberAction(TGContext context, int number) {
        super(context, TGSetNoteFretNumberAction.getActionName(number));
        this.number = number;
    }

    @Override
    protected void processAction(TGActionContext context) {
        TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        TGTrack track = (TGTrack)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
        TGString string = (TGString)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING);
        Long start = (Long)context.getAttribute("position");
        int fret = this.number;
        long time = System.currentTimeMillis();
        if (this.number < 10) {
            int newFret;
            if (lastAddedStart == start && lastAddedString == string.getNumber() && lastAddedFret > 0 && lastAddedFret < 10 && time < lastAddedTime + 1000L && ((newFret = lastAddedFret * 10 + fret) < 30 || this.getSongManager(context).isPercussionChannel(song, track.getChannelId()))) {
                fret = newFret;
            }
            lastAddedTime = time;
            lastAddedFret = fret;
            lastAddedStart = start;
            lastAddedString = string.getNumber();
        }
        context.setAttribute("fret", (Object)fret);
        TGActionManager tgActionManager = TGActionManager.getInstance((TGContext)this.getContext());
        tgActionManager.execute("action.note.general.change", context);
    }

    public static final String getActionName(int number) {
        return NAME_PREFIX + number;
    }
}

