/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.tools.custom.tuner;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.tools.custom.tuner.TGTuner;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.error.TGErrorManager;

public class TGTunerSettings {
    protected int sampleSize;
    protected float sampleRate;
    protected String deviceName;
    protected double threshold;
    protected int bufferSize;
    protected int fftSize;
    protected int waitPeriod;
    static final int DEFAULT_BUFFER_SIZE = 4096;
    static final int DEFAULT_FFT_SIZE = 16384;
    static final int CHANNELS_NUMBER = 1;

    public static TGTunerSettings getDefaults() {
        TGTunerSettings retValue = new TGTunerSettings();
        retValue.setSampleRate(11025.0f);
        retValue.setSampleSize(8);
        retValue.setBufferSize(4096);
        retValue.setFFTSize(16384);
        retValue.setThreshold(0.03);
        retValue.setWaitPeriod(100);
        return retValue;
    }

    protected static TargetDataLine getDataLine(TGTunerSettings settings) throws TGTuner.TGTunerException {
        TargetDataLine targetDataLine = null;
        if (settings != null) {
            DataLine.Info info = settings.getDataLineInfo();
            try {
                targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
            }
            catch (Exception ex) {
                TGErrorManager.getInstance((TGContext)TuxGuitar.getInstance().getContext()).handleError((Throwable)ex);
            }
        } else {
            throw new TGTuner.TGTunerException("Could not retrieve data from the input. Check your system device settings.");
        }
        return targetDataLine;
    }

    protected DataLine.Info getDataLineInfo() {
        return new DataLine.Info(TargetDataLine.class, this.getAudioFormat(), this.getBufferSize());
    }

    public AudioFormat getAudioFormat() {
        return new AudioFormat(this.getSampleRate(), this.getSampleSize(), 1, true, false);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getFFTSize() {
        return this.fftSize;
    }

    public void setFFTSize(int size) {
        this.fftSize = size;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double nt) {
        this.threshold = nt;
    }

    public void setSampleRate(float sampleRate) {
        this.sampleRate = sampleRate;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    public int getWaitPeriod() {
        return this.waitPeriod;
    }

    public void setWaitPeriod(int time) {
        this.waitPeriod = time;
    }

    public static TGTunerSettings loadTuxGuitarSettings() throws TGTuner.TGTunerException {
        return TGTunerSettings.getDefaults();
    }
}

