/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.community.startup;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.community.TGCommunitySingleton;
import org.herac.tuxguitar.community.utils.TGCommunityWeb;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UILinkEvent;
import org.herac.tuxguitar.ui.event.UILinkListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIFont;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UICheckBox;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIImageView;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;
import org.herac.tuxguitar.ui.widget.UILinkLabel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGException;
import org.herac.tuxguitar.util.TGSynchronizer;

public class TGCommunityStartupScreen {
    private static final float WRAP_WIDTH = 450.0f;
    private TGContext context;

    public TGCommunityStartupScreen(TGContext context) {
        this.context = context;
    }

    public void open() {
        try {
            final UIWindow parent = TGWindow.getInstance((TGContext)this.context).getWindow();
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

                @Override
                public void run() throws TGException {
                    TGCommunityStartupScreen.this.open(parent);
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void open(UIWindow parent) {
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(parent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        dialog.setText(TuxGuitar.getProperty((String)"tuxguitar-community.welcome-dialog.title"));
        UITableLayout topLayout = new UITableLayout();
        UIPanel top = uiFactory.createPanel((UIContainer)dialog, false);
        top.setLayout((UILayout)topLayout);
        dialogLayout.set((UIControl)top, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIImageView image = uiFactory.createImageView((UIContainer)top);
        image.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        topLayout.set((UIControl)image, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_TOP, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(3), Integer.valueOf(1));
        this.addTitle(uiFactory, (UILayoutContainer)top, 1, 2, TuxGuitar.getProperty((String)"tuxguitar-community.welcome-dialog.title"));
        this.addTipComment(uiFactory, (UIContainer)top, 2, 2, TuxGuitar.getProperty((String)"tuxguitar-community.welcome-dialog.tip-1"), Float.valueOf(450.0f));
        this.addTipComment(uiFactory, (UIContainer)top, 3, 2, TuxGuitar.getProperty((String)"tuxguitar-community.welcome-dialog.tip-2"), Float.valueOf(450.0f));
        top.computePackedSize();
        UITableLayout bottomLayout = new UITableLayout();
        UIPanel bottom = uiFactory.createPanel((UIContainer)dialog, false);
        bottom.setLayout((UILayout)bottomLayout);
        dialogLayout.set((UIControl)bottom, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.addComment(uiFactory, (UIContainer)bottom, 1, 1, TuxGuitar.getProperty((String)"tuxguitar-community.welcome-dialog.tip-bottom"), Float.valueOf(top.getPackedContentSize().getWidth()));
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
        final UICheckBox buttonDisabled = uiFactory.createCheckBox((UIContainer)buttons);
        buttonDisabled.setText(TuxGuitar.getProperty((String)"tuxguitar-community.welcome-dialog.disable"));
        buttonDisabled.setSelected(this.isDisabled());
        buttonsLayout.set((UIControl)buttonDisabled, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setDefaultButton();
        buttonOK.setFocus();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGCommunityStartupScreen.this.setDisabled(buttonDisabled.isSelected());
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonOK, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog((UIWindow)dialog, (int)5);
    }

    private void addTitle(UIFactory factory, UILayoutContainer parent, Integer row, Integer col, String text) {
        UILabel uiLabel = factory.createLabel((UIContainer)parent);
        uiLabel.setText(text);
        this.addLayout((UIControl)uiLabel, row, col, UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, false, false);
        UIFont defaultFont = uiLabel.getFont();
        if (defaultFont != null) {
            final UIFont font = factory.createFont(defaultFont.getName(), defaultFont.getHeight() + 2.0f, true, false);
            uiLabel.setFont(font);
            uiLabel.addDisposeListener(new UIDisposeListener(){

                public void onDispose(UIDisposeEvent event) {
                    font.dispose();
                }
            });
        }
    }

    private void addTipItem(UIFactory factory, UIContainer parent, Integer row, Integer col) {
        UILabel uiLabel = factory.createLabel(parent);
        uiLabel.setText("\u066d");
        this.addLayout((UIControl)uiLabel, row, col, UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, false, false);
    }

    private void addComment(UIFactory factory, UIContainer parent, Integer row, Integer col, String text, Float wrapWidth) {
        UILinkLabel uiLink = factory.createLinkLabel(parent);
        uiLink.setText(text);
        uiLink.setWrapWidth(wrapWidth);
        uiLink.addLinkListener(new UILinkListener(){

            public void onLinkSelect(final UILinkEvent event) {
                new Thread(new Runnable(){

                    @Override
                    public void run() throws TGException {
                        TGCommunityWeb.open(TGCommunityStartupScreen.this.getContext(), event.getLink());
                    }
                }).start();
            }
        });
        this.addLayout((UIControl)uiLink, row, col, UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, false, false);
    }

    private void addTipComment(UIFactory factory, UIContainer parent, Integer row, Integer col, String text, Float wrapWidth) {
        UIPanel uiPanel = factory.createPanel(parent, false);
        uiPanel.setLayout((UILayout)new UITableLayout(Float.valueOf(0.0f)));
        this.addLayout((UIControl)uiPanel, row, col, UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, false, false);
        this.addTipItem(factory, (UIContainer)uiPanel, 1, 1);
        this.addComment(factory, (UIContainer)uiPanel, 1, 2, text, wrapWidth);
    }

    private void addLayout(UIControl control, Integer row, Integer col, Integer alignX, Integer alignY, Boolean fillX, Boolean fillY) {
        UILayoutContainer uiParent = (UILayoutContainer)control.getParent();
        UITableLayout uiLayout = (UITableLayout)uiParent.getLayout();
        uiLayout.set(control, row, col, alignX, alignY, fillX, fillY);
    }

    public void setDisabled(boolean enabled) {
        TGCommunitySingleton.getInstance(this.context).getConfig().setValue("community.welcome.disabled", enabled);
    }

    public boolean isDisabled() {
        return TGCommunitySingleton.getInstance(this.context).getConfig().getBooleanValue("community.welcome.disabled");
    }

    public TGContext getContext() {
        return this.context;
    }
}

