/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.fretboard;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.system.icons.TGIconManager;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.util.TGMusicKeyUtils;
import org.herac.tuxguitar.app.view.dialog.fretboard.TGFretBoardConfig;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.app.view.util.TGBufferedPainterListenerLocked;
import org.herac.tuxguitar.app.view.util.TGBufferedPainterLocked;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.TGEditorManager;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIMouseEvent;
import org.herac.tuxguitar.ui.event.UIMouseUpListener;
import org.herac.tuxguitar.ui.event.UIPaintListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIColor;
import org.herac.tuxguitar.ui.resource.UIImage;
import org.herac.tuxguitar.ui.resource.UIPainter;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.resource.UISize;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UICanvas;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIDropDownSelect;
import org.herac.tuxguitar.ui.widget.UIImageView;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UISelectItem;
import org.herac.tuxguitar.ui.widget.UISeparator;
import org.herac.tuxguitar.util.TGContext;

public class TGFretBoard {
    public static final int MAX_FRETS = 24;
    public static final int TOP_SPACING = 10;
    public static final int BOTTOM_SPACING = 10;
    private static final int STRING_SPACING = TuxGuitar.getInstance().getConfig().getIntegerValue("fretboard.string-spacing");
    private static final String[] NOTE_NAMES = TGMusicKeyUtils.getSharpKeyNames("fretboard");
    private TGContext context;
    private TGFretBoardConfig config;
    private UIPanel control;
    private UIPanel toolComposite;
    private UIImageView durationLabel;
    private UILabel scaleName;
    private UIButton scale;
    private UIButton goLeft;
    private UIButton goRight;
    private UIButton increment;
    private UIButton decrement;
    private UIButton settings;
    private UIImage fretBoard;
    private TGBeat beat;
    private TGBeat externalBeat;
    private int[] frets;
    private int[] strings;
    private float fretSpacing;
    private boolean changes;
    private UISize lastSize;
    private int duration;
    protected UIDropDownSelect<Integer> handSelector;
    protected UICanvas fretBoardComposite;

    public TGFretBoard(TGContext context, UIContainer parent) {
        this.context = context;
        this.config = new TGFretBoardConfig(context);
        this.config.load();
        this.control = this.getUIFactory().createPanel(parent, false);
        this.initToolBar();
        this.initEditor();
        this.createControlLayout();
        this.loadIcons();
        this.loadProperties();
        TuxGuitar.getInstance().getKeyBindingManager().appendListenersTo((UIControl)this.toolComposite);
        TuxGuitar.getInstance().getKeyBindingManager().appendListenersTo((UIControl)this.fretBoardComposite);
    }

    public void createControlLayout() {
        UITableLayout uiLayout = new UITableLayout(Float.valueOf(0.0f));
        uiLayout.set((UIControl)this.toolComposite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        uiLayout.set((UIControl)this.fretBoardComposite, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        this.control.setLayout((UILayout)uiLayout);
    }

    private void initToolBar() {
        UIFactory uiFactory = this.getUIFactory();
        int column = 0;
        this.toolComposite = uiFactory.createPanel((UIContainer)this.control, false);
        this.createToolBarLayout();
        this.goLeft = uiFactory.createButton((UIContainer)this.toolComposite);
        this.goLeft.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.caret.go-left"));
        this.createToolItemLayout((UIControl)this.goLeft, ++column);
        this.goRight = uiFactory.createButton((UIContainer)this.toolComposite);
        this.goRight.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.caret.go-right"));
        this.createToolItemLayout((UIControl)this.goRight, ++column);
        this.createToolSeparator(uiFactory, ++column);
        this.decrement = uiFactory.createButton((UIContainer)this.toolComposite);
        this.decrement.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.note.duration.decrement-duration"));
        this.createToolItemLayout((UIControl)this.decrement, ++column);
        this.durationLabel = uiFactory.createImageView((UIContainer)this.toolComposite);
        this.createToolItemLayout((UIControl)this.durationLabel, ++column);
        this.increment = uiFactory.createButton((UIContainer)this.toolComposite);
        this.increment.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.note.duration.increment-duration"));
        this.createToolItemLayout((UIControl)this.increment, ++column);
        this.createToolSeparator(uiFactory, ++column);
        this.handSelector = uiFactory.createDropDownSelect((UIContainer)this.toolComposite);
        this.handSelector.addItem(new UISelectItem(TuxGuitar.getProperty("fretboard.right-mode"), (Object)0));
        this.handSelector.addItem(new UISelectItem(TuxGuitar.getProperty("fretboard.left-mode"), (Object)1));
        this.handSelector.setSelectedItem(new UISelectItem(null, (Object)this.getDirection(this.config.getDirection())));
        this.handSelector.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                Integer direction = (Integer)TGFretBoard.this.handSelector.getSelectedValue();
                if (direction != null) {
                    TGFretBoard.this.updateDirection(direction);
                }
            }
        });
        this.createToolItemLayout((UIControl)this.handSelector, ++column);
        this.createToolSeparator(uiFactory, ++column);
        this.scale = uiFactory.createButton((UIContainer)this.toolComposite);
        this.scale.setText(TuxGuitar.getProperty("scale"));
        this.scale.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.gui.open-scale-dialog"));
        this.createToolItemLayout((UIControl)this.scale, ++column);
        this.scaleName = uiFactory.createLabel((UIContainer)this.toolComposite);
        this.createToolItemLayout((UIControl)this.scaleName, ++column, UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, false, false);
        this.settings = uiFactory.createButton((UIContainer)this.toolComposite);
        this.settings.setImage(TuxGuitar.getInstance().getIconManager().getSettings());
        this.settings.setToolTipText(TuxGuitar.getProperty("settings"));
        this.settings.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGFretBoard.this.configure();
            }
        });
        this.createToolItemLayout((UIControl)this.settings, ++column, UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, true, false);
        this.toolComposite.getLayout().set((UIControl)this.goLeft, "margin_left", (Object)Float.valueOf(0.0f));
        this.toolComposite.getLayout().set((UIControl)this.settings, "margin_right", (Object)Float.valueOf(0.0f));
    }

    private void createToolBarLayout() {
        UITableLayout uiLayout = new UITableLayout();
        uiLayout.set("margin_left", (Object)Float.valueOf(0.0f));
        uiLayout.set("margin_right", (Object)Float.valueOf(0.0f));
        this.toolComposite.setLayout((UILayout)uiLayout);
    }

    private void createToolItemLayout(UIControl uiControl, int column) {
        this.createToolItemLayout(uiControl, column, UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, false, false);
    }

    private void createToolItemLayout(UIControl uiControl, int column, Integer alignX, Integer alignY, Boolean fillX, Boolean fillY) {
        UITableLayout uiLayout = (UITableLayout)this.toolComposite.getLayout();
        uiLayout.set(uiControl, Integer.valueOf(1), Integer.valueOf(column), alignX, alignY, fillX, fillX);
    }

    private void createToolSeparator(UIFactory uiFactory, int column) {
        UISeparator uiSeparator = uiFactory.createVerticalSeparator((UIContainer)this.toolComposite);
        UITableLayout uiLayout = (UITableLayout)this.toolComposite.getLayout();
        uiLayout.set((UIControl)uiSeparator, Integer.valueOf(1), Integer.valueOf(column), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        uiLayout.set((UIControl)uiSeparator, "packed_width", (Object)Float.valueOf(20.0f));
        uiLayout.set((UIControl)uiSeparator, "packed_height", (Object)Float.valueOf(20.0f));
    }

    private void initEditor() {
        this.lastSize = new UISize();
        this.fretBoardComposite = this.getUIFactory().createCanvas((UIContainer)this.control, false);
        this.fretBoardComposite.setBgColor(this.config.getColorBackground());
        this.fretBoardComposite.addMouseUpListener((UIMouseUpListener)new TGFretBoardMouseListener());
        this.fretBoardComposite.addPaintListener((UIPaintListener)new TGBufferedPainterListenerLocked(this.context, new TGFretBoardPainterListener()));
    }

    private void loadDurationImage(boolean force) {
        int duration = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getDuration().getValue();
        if (force || this.duration != duration) {
            this.duration = duration;
            this.durationLabel.setImage(TuxGuitar.getInstance().getIconManager().getDuration(this.duration));
        }
    }

    private void loadScaleName() {
        int scaleKey = TuxGuitar.getInstance().getScaleManager().getSelectionKey();
        int scaleIndex = TuxGuitar.getInstance().getScaleManager().getSelectionIndex();
        String key = TuxGuitar.getInstance().getScaleManager().getKeyName(scaleKey);
        String name = TuxGuitar.getInstance().getScaleManager().getScaleName(scaleIndex);
        this.scaleName.setText(key != null && name != null ? key + " - " + name : "");
    }

    private void calculateFretSpacing(float width) {
        this.fretSpacing = width / 24.0f;
        int aux = 0;
        for (int i = 0; i < 24; ++i) {
            aux += i * 2;
        }
        this.fretSpacing += (float)(aux / 24 + 2);
    }

    private void disposeFretBoardImage() {
        if (this.fretBoard != null && !this.fretBoard.isDisposed()) {
            this.fretBoard.dispose();
        }
    }

    protected void initFrets(int fromX) {
        block3: {
            int direction;
            int nextX;
            block2: {
                this.frets = new int[24];
                nextX = fromX;
                direction = this.getDirection(this.config.getDirection());
                if (direction != 0) break block2;
                for (int i = 0; i < this.frets.length; ++i) {
                    this.frets[i] = nextX;
                    nextX = (int)((float)nextX + (this.fretSpacing - (float)((i + 1) * 2)));
                }
                break block3;
            }
            if (direction != 1) break block3;
            for (int i = this.frets.length - 1; i >= 0; --i) {
                this.frets[i] = nextX;
                nextX = (int)((float)nextX + (this.fretSpacing - (float)(i * 2)));
            }
        }
    }

    private int getDirection(int value) {
        int direction = value;
        if (direction != 0 && direction != 1) {
            direction = 0;
        }
        return direction;
    }

    private void initStrings(int count) {
        int fromY = 10;
        this.strings = new int[count];
        for (int i = 0; i < this.strings.length; ++i) {
            this.strings[i] = fromY + STRING_SPACING * i;
        }
    }

    private void updateEditor() {
        if (this.isVisible()) {
            this.beat = TuxGuitar.getInstance().getPlayer().isRunning() ? TuxGuitar.getInstance().getEditorCache().getPlayBeat() : (this.externalBeat != null ? this.externalBeat : TuxGuitar.getInstance().getEditorCache().getEditBeat());
            if (this.strings.length != this.getStringCount()) {
                this.disposeFretBoardImage();
                this.initStrings(this.getStringCount());
                this.lastSize.setHeight(0.0f);
            }
            UIRectangle childArea = this.control.getChildArea();
            float clientWidth = childArea.getWidth();
            float clientHeight = childArea.getHeight();
            if (this.lastSize.getWidth() != clientWidth || this.hasChanges()) {
                this.layout(clientWidth);
            }
            if (this.lastSize.getHeight() != clientHeight) {
                TuxGuitar.getInstance().getFretBoardEditor().showFretBoard();
            }
            this.lastSize.setWidth(clientWidth);
            this.lastSize.setHeight(clientHeight);
        }
    }

    private void paintFretBoard(UIPainter painter) {
        if (this.fretBoard == null || this.fretBoard.isDisposed()) {
            int i;
            UIFactory factory = this.getUIFactory();
            UIRectangle area = this.control.getChildArea();
            this.fretBoard = factory.createImage(area.getWidth(), (float)(STRING_SPACING * (this.strings.length - 1) + 10 + 10));
            UIPainter painterBuffer = this.fretBoard.createPainter();
            painterBuffer.setBackground(this.config.getColorBackground());
            painterBuffer.initPath(2);
            painterBuffer.addRectangle(area.getX(), area.getY(), area.getWidth(), area.getHeight());
            painterBuffer.closePath();
            TGIconManager iconManager = TGIconManager.getInstance(this.context);
            UIImage fretImage = iconManager.getFretboardFret();
            UIImage firstFretImage = iconManager.getFretboardFirstFret();
            painterBuffer.drawImage(firstFretImage, 0.0f, 0.0f, firstFretImage.getWidth(), firstFretImage.getHeight(), (float)(this.frets[0] - 5), (float)(this.strings[0] - 5), firstFretImage.getWidth(), (float)this.strings[this.strings.length - 1]);
            this.paintFretPoints(painterBuffer, 0);
            for (i = 1; i < this.frets.length; ++i) {
                painterBuffer.drawImage(fretImage, 0.0f, 0.0f, fretImage.getWidth(), fretImage.getHeight(), (float)this.frets[i], (float)(this.strings[0] - 5), fretImage.getWidth(), (float)this.strings[this.strings.length - 1]);
                this.paintFretPoints(painterBuffer, i);
            }
            for (i = 0; i < this.strings.length; ++i) {
                painterBuffer.setForeground(this.config.getColorString());
                if (i > 2) {
                    painterBuffer.setLineWidth(2.0f);
                }
                painterBuffer.initPath();
                painterBuffer.setAntialias(false);
                painterBuffer.moveTo((float)this.frets[0], (float)this.strings[i]);
                painterBuffer.lineTo((float)this.frets[this.frets.length - 1], (float)this.strings[i]);
                painterBuffer.closePath();
            }
            this.paintScale(painterBuffer);
            painterBuffer.dispose();
        }
        painter.drawImage(this.fretBoard, 0.0f, 0.0f);
    }

    private void paintFretPoints(UIPainter painter, int fretIndex) {
        painter.setBackground(this.config.getColorFretPoint());
        if (fretIndex + 1 < this.frets.length) {
            int fret = (fretIndex + 1) % 12;
            painter.setLineWidth(10.0f);
            if (fret == 0) {
                int size = this.getOvalSize();
                int x = this.frets[fretIndex] + (this.frets[fretIndex + 1] - this.frets[fretIndex]) / 2;
                int y1 = this.strings[0] + (this.strings[this.strings.length - 1] - this.strings[0]) / 2 - STRING_SPACING;
                int y2 = this.strings[0] + (this.strings[this.strings.length - 1] - this.strings[0]) / 2 + STRING_SPACING;
                painter.initPath(2);
                painter.addCircle((float)x, (float)y1, (float)size);
                painter.addCircle((float)x, (float)y2, (float)size);
                painter.closePath();
            } else if (fret == 3 || fret == 5 || fret == 7 || fret == 9) {
                int size = this.getOvalSize();
                int x = this.frets[fretIndex] + (this.frets[fretIndex + 1] - this.frets[fretIndex]) / 2;
                int y = this.strings[0] + (this.strings[this.strings.length - 1] - this.strings[0]) / 2;
                painter.initPath(2);
                painter.addCircle((float)x, (float)y, (float)size);
                painter.closePath();
            }
            painter.setLineWidth(1.0f);
        }
    }

    private void paintScale(UIPainter painter) {
        TGTrack track = this.getTrack();
        for (int i = 0; i < this.strings.length; ++i) {
            TGString string = track.getString(i + 1);
            for (int j = 0; j < this.frets.length; ++j) {
                int noteIndex = (string.getValue() + j) % 12;
                if (!TuxGuitar.getInstance().getScaleManager().getScale().getNote(noteIndex)) continue;
                int x = this.frets[j];
                if (j > 0) {
                    x -= (x - this.frets[j - 1]) / 2;
                }
                int y = this.strings[i];
                if ((this.config.getStyle() & 2) != 0) {
                    this.paintKeyText(painter, this.config.getColorScale(), x, y, NOTE_NAMES[noteIndex]);
                    continue;
                }
                this.paintKeyOval(painter, this.config.getColorScale(), x, y);
            }
        }
        painter.setForeground(this.config.getColorBackground());
    }

    private void paintNotes(UIPainter painter) {
        if (this.beat != null) {
            TGTrack track = this.getTrack();
            for (int v = 0; v < this.beat.countVoices(); ++v) {
                TGVoice voice = this.beat.getVoice(v);
                for (TGNote note : voice.getNotes()) {
                    int fretIndex = note.getValue();
                    int stringIndex = note.getString() - 1;
                    if (fretIndex < 0 || fretIndex >= this.frets.length || stringIndex < 0 || stringIndex >= this.strings.length) continue;
                    int x = this.frets[fretIndex];
                    if (fretIndex > 0) {
                        x -= (this.frets[fretIndex] - this.frets[fretIndex - 1]) / 2;
                    }
                    int y = this.strings[stringIndex];
                    if ((this.config.getStyle() & 1) != 0) {
                        int realValue = track.getString(note.getString()).getValue() + note.getValue();
                        this.paintKeyText(painter, this.config.getColorNote(), x, y, NOTE_NAMES[realValue % 12]);
                        continue;
                    }
                    this.paintKeyOval(painter, this.config.getColorNote(), x, y);
                }
            }
            painter.setLineWidth(1.0f);
        }
    }

    private void paintKeyOval(UIPainter painter, UIColor background, int x, int y) {
        int size = this.getOvalSize();
        painter.setBackground(background);
        painter.initPath(2);
        painter.moveTo((float)x, (float)y);
        painter.addCircle((float)x, (float)y, (float)size);
        painter.closePath();
    }

    private void paintKeyText(UIPainter painter, UIColor foreground, int x, int y, String text) {
        painter.setBackground(this.config.getColorKeyTextBackground());
        painter.setForeground(foreground);
        painter.setFont(this.config.getFont());
        float fmWidth = painter.getFMWidth(text);
        float fmHeight = painter.getFMHeight();
        painter.initPath(2);
        painter.addRectangle((float)x - fmWidth / 2.0f, (float)y - fmHeight / 2.0f, fmWidth, fmHeight);
        painter.closePath();
        painter.drawString(text, (float)x - fmWidth / 2.0f, (float)y + painter.getFMMiddleLine());
    }

    protected void paintEditor(UIPainter painter) {
        this.updateEditor();
        if (this.frets.length > 0 && this.strings.length > 0) {
            this.paintFretBoard(painter);
            this.paintNotes(painter);
        }
    }

    protected void hit(float x, float y) {
        int fretIndex = this.getFretIndex(x);
        int stringIndex = this.getStringIndex(y);
        int stringNumber = stringIndex + 1;
        this.selectString(stringNumber);
        if (!this.removeNote(fretIndex, stringNumber)) {
            this.addNote(fretIndex, stringNumber);
        }
    }

    private void selectString(int number) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.caret.move-to");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)this.getTrack().getString(number));
        tgActionProcessor.process();
    }

    private int getStringIndex(float y) {
        int index = -1;
        for (int i = 0; i < this.strings.length; ++i) {
            if (index < 0) {
                index = i;
                continue;
            }
            float distanceY = Math.abs(y - (float)this.strings[index]);
            float currDistanceY = Math.abs(y - (float)this.strings[i]);
            if (!(currDistanceY < distanceY)) continue;
            index = i;
        }
        return index;
    }

    private int getFretIndex(float x) {
        int length = this.frets.length;
        if (x - 10.0f <= (float)this.frets[0] && this.frets[0] < this.frets[length - 1]) {
            return 0;
        }
        if (x + 10.0f >= (float)this.frets[0] && this.frets[0] > this.frets[length - 1]) {
            return 0;
        }
        for (int i = 0; i < length; ++i) {
            if (i + 1 >= length || !(x > (float)this.frets[i] && x <= (float)this.frets[i + 1]) && (!(x > (float)this.frets[i + 1]) || !(x <= (float)this.frets[i]))) continue;
            return i + 1;
        }
        return length - 1;
    }

    private boolean removeNote(int fret, int string) {
        if (this.beat != null) {
            for (int v = 0; v < this.beat.countVoices(); ++v) {
                TGVoice voice = this.beat.getVoice(v);
                for (TGNote note : voice.getNotes()) {
                    if (note.getValue() != fret || note.getString() != string) continue;
                    TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.beat.general.delete-note");
                    tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_NOTE, (Object)note);
                    tgActionProcessor.process();
                    return true;
                }
            }
        }
        return false;
    }

    private TGTrack getTrack() {
        TGTrack track;
        TGMeasure measure;
        if (this.beat != null && (measure = this.beat.getMeasure()) != null && (track = measure.getTrack()) != null) {
            return track;
        }
        return TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack();
    }

    private int getStringCount() {
        TGTrack track = this.getTrack();
        if (track != null) {
            return track.stringCount();
        }
        return 0;
    }

    private int getOvalSize() {
        return STRING_SPACING / 2 + STRING_SPACING / 10;
    }

    private void addNote(int fret, int string) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.note.general.change");
        tgActionProcessor.setAttribute("fret", (Object)fret);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)this.getTrack().getString(string));
        tgActionProcessor.process();
    }

    protected void updateDirection(int direction) {
        this.config.saveDirection(this.getDirection(direction));
        this.initFrets(10);
        this.setChanges(true);
        this.fretBoardComposite.redraw();
    }

    public boolean hasChanges() {
        return this.changes;
    }

    public void setChanges(boolean changes) {
        this.changes = changes;
    }

    public void setExternalBeat(TGBeat externalBeat) {
        this.externalBeat = externalBeat;
    }

    public TGBeat getExternalBeat() {
        return this.externalBeat;
    }

    public void redraw() {
        if (!this.isDisposed()) {
            this.control.redraw();
            this.fretBoardComposite.redraw();
            this.loadDurationImage(false);
        }
    }

    public void redrawPlayingMode() {
        if (!this.isDisposed()) {
            this.fretBoardComposite.redraw();
        }
    }

    public void setVisible(boolean visible) {
        this.control.setVisible(visible);
    }

    public boolean isVisible() {
        return this.control.isVisible();
    }

    public boolean isDisposed() {
        return this.control.isDisposed();
    }

    public void dispose() {
        this.control.dispose();
        this.disposeFretBoardImage();
        this.config.dispose();
    }

    public void loadProperties() {
        int selection = (Integer)this.handSelector.getSelectedItem().getValue();
        this.handSelector.removeItems();
        this.handSelector.addItem(new UISelectItem(TuxGuitar.getProperty("fretboard.right-mode"), (Object)0));
        this.handSelector.addItem(new UISelectItem(TuxGuitar.getProperty("fretboard.left-mode"), (Object)1));
        this.handSelector.setSelectedItem(new UISelectItem(null, (Object)selection));
        this.settings.setToolTipText(TuxGuitar.getProperty("settings"));
        this.scale.setText(TuxGuitar.getProperty("scale"));
        this.loadScaleName();
        this.setChanges(true);
        this.control.layout();
    }

    public void loadIcons() {
        this.goLeft.setImage(TuxGuitar.getInstance().getIconManager().getArrowLeft());
        this.goRight.setImage(TuxGuitar.getInstance().getIconManager().getArrowRight());
        this.decrement.setImage(TuxGuitar.getInstance().getIconManager().getArrowUp());
        this.increment.setImage(TuxGuitar.getInstance().getIconManager().getArrowDown());
        this.settings.setImage(TuxGuitar.getInstance().getIconManager().getSettings());
        this.loadDurationImage(true);
        this.control.layout();
        this.layout(this.control.getChildArea().getWidth());
    }

    public void loadScale() {
        this.loadScaleName();
        this.setChanges(true);
        this.control.layout();
    }

    public int getWidth() {
        return this.frets[this.frets.length - 1];
    }

    public void computePackedSize() {
        this.control.getLayout().set((UIControl)this.fretBoardComposite, "packed_height", (Object)Float.valueOf(STRING_SPACING * (this.strings.length - 1) + 10 + 10));
        this.control.computePackedSize();
    }

    public void layout(float width) {
        this.disposeFretBoardImage();
        this.calculateFretSpacing(width);
        this.initFrets(10);
        this.initStrings(this.getStringCount());
        this.setChanges(false);
    }

    public void configure() {
        this.config.configure(TGWindow.getInstance(this.context).getWindow());
    }

    public void reloadFromConfig() {
        this.handSelector.setSelectedItem(new UISelectItem(null, (Object)this.getDirection(this.config.getDirection())));
        this.setChanges(true);
        this.redraw();
    }

    public UIPanel getControl() {
        return this.control;
    }

    public UICanvas getFretBoardComposite() {
        return this.fretBoardComposite;
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.context).getFactory();
    }

    private class TGFretBoardPainterListener
    implements TGBufferedPainterLocked.TGBufferedPainterHandle {
        @Override
        public void paintControl(UIPainter painter) {
            TGFretBoard.this.paintEditor(painter);
        }

        @Override
        public UICanvas getPaintableControl() {
            return TGFretBoard.this.fretBoardComposite;
        }
    }

    private class TGFretBoardMouseListener
    implements UIMouseUpListener {
        public void onMouseUp(UIMouseEvent event) {
            TGFretBoard.this.getFretBoardComposite().setFocus();
            if (event.getButton() == 1) {
                if (!TuxGuitar.getInstance().getPlayer().isRunning() && !TGEditorManager.getInstance((TGContext)TGFretBoard.this.context).isLocked()) {
                    if (TGFretBoard.this.getExternalBeat() == null) {
                        TGFretBoard.this.hit(event.getPosition().getX(), event.getPosition().getY());
                    } else {
                        TGFretBoard.this.setExternalBeat(null);
                        TuxGuitar.getInstance().updateCache(true);
                    }
                }
            } else {
                new TGActionProcessor(TGFretBoard.this.context, "action.caret.go-right").process();
            }
        }
    }
}

