/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.chord;

import java.io.File;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.TGFileUtils;
import org.herac.tuxguitar.app.view.dialog.chord.xml.TGChordXMLReader;
import org.herac.tuxguitar.app.view.dialog.chord.xml.TGChordXMLWriter;
import org.herac.tuxguitar.song.models.TGChord;

public class TGCustomChordManager {
    private long lastEdit;
    private List<TGChord> chords = TGChordXMLReader.getChords(TGCustomChordManager.getUserFileName());

    public TGCustomChordManager() {
        this.setLastEdit();
    }

    public int countChords() {
        return this.chords.size();
    }

    public TGChord getChord(int index) {
        if (index >= 0 && index < this.countChords()) {
            return this.chords.get(index).clone(TuxGuitar.getInstance().getSongManager().getFactory());
        }
        return null;
    }

    public void addChord(TGChord chord) {
        this.chords.add(chord);
        this.setLastEdit();
    }

    public void removeChord(int index) {
        if (index >= 0 && index < this.countChords()) {
            this.chords.remove(index);
            this.setLastEdit();
        }
    }

    public void renameChord(int index, String name) {
        if (index >= 0 && index < this.countChords()) {
            this.chords.get(index).setName(name);
            this.setLastEdit();
        }
    }

    public boolean existOtherEqualCustomChord(String name, int index) {
        for (int i = 0; i < this.countChords(); ++i) {
            TGChord chord = this.getChord(i);
            if (!chord.getName().equals(name) || index == i) continue;
            return true;
        }
        return false;
    }

    public void write() {
        TGChordXMLWriter.setChords(this.chords, TGCustomChordManager.getUserFileName());
    }

    private static String getUserFileName() {
        return TGFileUtils.PATH_USER_CONFIG + File.separator + "customchords.xml";
    }

    private void setLastEdit() {
        this.lastEdit = System.currentTimeMillis();
    }

    public long getLastEdit() {
        return this.lastEdit;
    }
}

