/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.system.icons;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.herac.tuxguitar.app.system.icons.TGIconEvent;
import org.herac.tuxguitar.app.system.icons.TGIconTheme;
import org.herac.tuxguitar.app.system.icons.TGSkinManager;
import org.herac.tuxguitar.app.util.TGFileUtils;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.event.TGEventManager;
import org.herac.tuxguitar.ui.resource.UIImage;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGIconManager {
    private TGContext context;
    private TGIconTheme theme;
    private Map<String, TGIconTheme> themeCache;
    private UIImage[] durations;
    private UIImage editUndo;
    private UIImage editRedo;
    private UIImage editVoice1;
    private UIImage editVoice2;
    private UIImage editModeSelection;
    private UIImage editModeEdition;
    private UIImage editModeEditionNotNatural;
    private UIImage layoutPage;
    private UIImage layoutLinear;
    private UIImage layoutMultitrack;
    private UIImage layoutScore;
    private UIImage layoutCompact;
    private UIImage transport;
    private UIImage transportFirst1;
    private UIImage transportFirst2;
    private UIImage transportLast1;
    private UIImage transportLast2;
    private UIImage transportPrevious1;
    private UIImage transportPrevious2;
    private UIImage transportNext1;
    private UIImage transportNext2;
    private UIImage transportStop1;
    private UIImage transportStop2;
    private UIImage transportPlay1;
    private UIImage transportPlay2;
    private UIImage transportPause;
    private UIImage transportIconFirst1;
    private UIImage transportIconFirst2;
    private UIImage transportIconLast1;
    private UIImage transportIconLast2;
    private UIImage transportIconPrevious1;
    private UIImage transportIconPrevious2;
    private UIImage transportIconNext1;
    private UIImage transportIconNext2;
    private UIImage transportIconStop1;
    private UIImage transportIconStop2;
    private UIImage transportIconPlay1;
    private UIImage transportIconPlay2;
    private UIImage transportIconPause;
    private UIImage transportMetronome;
    private UIImage transportMode;
    private UIImage markerList;
    private UIImage markerAdd;
    private UIImage markerRemove;
    private UIImage markerFirst;
    private UIImage markerLast;
    private UIImage markerPrevious;
    private UIImage markerNext;
    private UIImage aboutDescription;
    private UIImage aboutLicense;
    private UIImage aboutAuthors;
    private UIImage appIcon;
    private UIImage appIcon16;
    private UIImage appIcon24;
    private UIImage appIcon32;
    private UIImage appIcon48;
    private UIImage appIcon64;
    private UIImage appIcon96;
    private UIImage appSplash;
    private UIImage optionMain;
    private UIImage optionStyle;
    private UIImage optionSound;
    private UIImage optionLanguage;
    private UIImage optionToolbars;
    private UIImage optionSkin;
    private UIImage trackAdd;
    private UIImage trackRemove;
    private UIImage fretboard;
    private UIImage fretboardFirstFret;
    private UIImage fretboardFret;
    private UIImage compositionTimeSignature;
    private UIImage compositionTempo;
    private UIImage compositionRepeatOpen;
    private UIImage compositionRepeatClose;
    private UIImage compositionRepeatAlternative;
    private UIImage songProperties;
    private UIImage durationDotted;
    private UIImage durationDoubleDotted;
    private UIImage divisionType;
    private UIImage fileNew;
    private UIImage fileOpen;
    private UIImage fileSave;
    private UIImage fileSaveAs;
    private UIImage filePrint;
    private UIImage filePrintPreview;
    private UIImage chord;
    private UIImage text;
    private UIImage noteTied;
    private UIImage instruments;
    private UIImage dynamicPPP;
    private UIImage dynamicPP;
    private UIImage dynamicP;
    private UIImage dynamicMP;
    private UIImage dynamicMF;
    private UIImage dynamicF;
    private UIImage dynamicFF;
    private UIImage dynamicFFF;
    private UIImage effectDead;
    private UIImage effectGhost;
    private UIImage effectAccentuated;
    private UIImage effectHeavyAccentuated;
    private UIImage effectHarmonic;
    private UIImage effectGrace;
    private UIImage effectBend;
    private UIImage effectTremoloBar;
    private UIImage effectSlide;
    private UIImage effectHammer;
    private UIImage effectVibrato;
    private UIImage effectTrill;
    private UIImage effectTremoloPicking;
    private UIImage effectPalmMute;
    private UIImage effectStaccato;
    private UIImage effectTapping;
    private UIImage effectSlapping;
    private UIImage effectPopping;
    private UIImage effectFadeIn;
    private UIImage browserNew;
    private UIImage browserFile;
    private UIImage browserFolder;
    private UIImage browserRoot;
    private UIImage browserBack;
    private UIImage browserRefresh;
    private UIImage arrowUp;
    private UIImage arrowDown;
    private UIImage arrowLeft;
    private UIImage arrowRight;
    private UIImage statusQuestion;
    private UIImage statusError;
    private UIImage statusWarning;
    private UIImage statusInfo;
    private UIImage strokeUp;
    private UIImage strokeDown;
    private UIImage settings;
    private UIImage toolbarEdit;
    private UIImage listAdd;
    private UIImage listEdit;
    private UIImage listRemove;

    private TGIconManager(TGContext context) {
        this.context = context;
        this.themeCache = new HashMap<String, TGIconTheme>();
        this.loadIcons();
    }

    public void addLoader(TGEventListener listener) {
        TGEventManager.getInstance((TGContext)this.context).addListener("ui-icon", listener);
    }

    public void removeLoader(TGEventListener listener) {
        TGEventManager.getInstance((TGContext)this.context).removeListener("ui-icon", listener);
    }

    private void fireChanges() {
        TGEventManager.getInstance((TGContext)this.context).fireEvent((TGEvent)new TGIconEvent());
    }

    public TGIconTheme findIconTheme(String theme) {
        if (this.themeCache.containsKey(theme)) {
            return this.themeCache.get(theme);
        }
        this.themeCache.put(theme, new TGIconTheme(theme));
        return this.findIconTheme(theme);
    }

    public String findConfiguredThemeName() {
        return TGSkinManager.getInstance(this.context).getCurrentSkin();
    }

    public boolean shouldReload() {
        return this.theme == null || !this.theme.getName().equals(this.findConfiguredThemeName());
    }

    public void reloadIcons() {
        this.loadIcons();
        this.fireChanges();
    }

    public void loadIcons() {
        this.theme = this.findIconTheme(this.findConfiguredThemeName());
        this.durations = new UIImage[]{this.loadIcon("1.png"), this.loadIcon("2.png"), this.loadIcon("4.png"), this.loadIcon("8.png"), this.loadIcon("16.png"), this.loadIcon("32.png"), this.loadIcon("64.png")};
        this.layoutPage = this.loadIcon("layout_page.png");
        this.layoutLinear = this.loadIcon("layout_linear.png");
        this.layoutMultitrack = this.loadIcon("layout_multitrack.png");
        this.layoutScore = this.loadIcon("layout_score.png");
        this.layoutCompact = this.loadIcon("layout_compact.png");
        this.fileNew = this.loadIcon("new.png");
        this.fileOpen = this.loadIcon("open.png");
        this.fileSave = this.loadIcon("save.png");
        this.fileSaveAs = this.loadIcon("save-as.png");
        this.filePrint = this.loadIcon("print.png");
        this.filePrintPreview = this.loadIcon("print-preview.png");
        this.editUndo = this.loadIcon("edit_undo.png");
        this.editRedo = this.loadIcon("edit_redo.png");
        this.editVoice1 = this.loadIcon("edit_voice_1.png");
        this.editVoice2 = this.loadIcon("edit_voice_2.png");
        this.editModeSelection = this.loadIcon("edit_mode_selection.png");
        this.editModeEdition = this.loadIcon("edit_mode_edition.png");
        this.editModeEditionNotNatural = this.loadIcon("edit_mode_edition_no_natural.png");
        this.appIcon = this.loadIcon("icon.png");
        this.appIcon16 = this.loadIcon("icon-16x16.png");
        this.appIcon24 = this.loadIcon("icon-24x24.png");
        this.appIcon32 = this.loadIcon("icon-32x32.png");
        this.appIcon48 = this.loadIcon("icon-48x48.png");
        this.appIcon64 = this.loadIcon("icon-64x64.png");
        this.appIcon96 = this.loadIcon("icon-96x96.png");
        this.appSplash = this.loadIcon("splash.png");
        this.aboutDescription = this.loadIcon("about_description.png");
        this.aboutLicense = this.loadIcon("about_license.png");
        this.aboutAuthors = this.loadIcon("about_authors.png");
        this.optionMain = this.loadIcon("option_view.png");
        this.optionStyle = this.loadIcon("option_style.png");
        this.optionSound = this.loadIcon("option_sound.png");
        this.optionSkin = this.loadIcon("option_skin.png");
        this.optionLanguage = this.loadIcon("option_language.png");
        this.optionToolbars = this.loadIcon("option_toolbars.png");
        this.compositionTimeSignature = this.loadIcon("timesignature.png");
        this.compositionTempo = this.loadIcon("tempoicon.png");
        this.compositionRepeatOpen = this.loadIcon("openrepeat.png");
        this.compositionRepeatClose = this.loadIcon("closerepeat.png");
        this.compositionRepeatAlternative = this.loadIcon("repeat_alternative.png");
        this.songProperties = this.loadIcon("song_properties.png");
        this.trackAdd = this.loadIcon("track_add.png");
        this.trackRemove = this.loadIcon("track_remove.png");
        this.durationDotted = this.loadIcon("dotted.png");
        this.durationDoubleDotted = this.loadIcon("doubledotted.png");
        this.divisionType = this.loadIcon("division-type.png");
        this.fretboard = this.loadIcon("fretboard.png");
        this.fretboardFirstFret = this.loadIcon("firstfret.png");
        this.fretboardFret = this.loadIcon("fret.png");
        this.chord = this.loadIcon("chord.png");
        this.text = this.loadIcon("text.png");
        this.noteTied = this.loadIcon("tiednote.png");
        this.transport = this.loadIcon("transport.png");
        this.transportFirst1 = this.loadIcon("transport_first_1.png");
        this.transportFirst2 = this.loadIcon("transport_first_2.png");
        this.transportLast1 = this.loadIcon("transport_last_1.png");
        this.transportLast2 = this.loadIcon("transport_last_2.png");
        this.transportPrevious1 = this.loadIcon("transport_previous_1.png");
        this.transportPrevious2 = this.loadIcon("transport_previous_2.png");
        this.transportNext1 = this.loadIcon("transport_next_1.png");
        this.transportNext2 = this.loadIcon("transport_next_2.png");
        this.transportStop1 = this.loadIcon("transport_stop_1.png");
        this.transportStop2 = this.loadIcon("transport_stop_2.png");
        this.transportPlay1 = this.loadIcon("transport_play_1.png");
        this.transportPlay2 = this.loadIcon("transport_play_2.png");
        this.transportPause = this.loadIcon("transport_pause.png");
        this.transportIconFirst1 = this.loadIcon("transport_icon_first_1.png");
        this.transportIconFirst2 = this.loadIcon("transport_icon_first_2.png");
        this.transportIconLast1 = this.loadIcon("transport_icon_last_1.png");
        this.transportIconLast2 = this.loadIcon("transport_icon_last_2.png");
        this.transportIconPrevious1 = this.loadIcon("transport_icon_previous_1.png");
        this.transportIconPrevious2 = this.loadIcon("transport_icon_previous_2.png");
        this.transportIconNext1 = this.loadIcon("transport_icon_next_1.png");
        this.transportIconNext2 = this.loadIcon("transport_icon_next_2.png");
        this.transportIconStop1 = this.loadIcon("transport_icon_stop_1.png");
        this.transportIconStop2 = this.loadIcon("transport_icon_stop_2.png");
        this.transportIconPlay1 = this.loadIcon("transport_icon_play_1.png");
        this.transportIconPlay2 = this.loadIcon("transport_icon_play_2.png");
        this.transportIconPause = this.loadIcon("transport_icon_pause.png");
        this.transportMetronome = this.loadIcon("transport_metronome.png");
        this.transportMode = this.loadIcon("transport_mode.png");
        this.markerList = this.loadIcon("marker_list.png");
        this.markerAdd = this.loadIcon("marker_add.png");
        this.markerRemove = this.loadIcon("marker_remove.png");
        this.markerFirst = this.loadIcon("marker_first.png");
        this.markerLast = this.loadIcon("marker_last.png");
        this.markerPrevious = this.loadIcon("marker_previous.png");
        this.markerNext = this.loadIcon("marker_next.png");
        this.instruments = this.loadIcon("mixer.png");
        this.dynamicPPP = this.loadIcon("dynamic_ppp.png");
        this.dynamicPP = this.loadIcon("dynamic_pp.png");
        this.dynamicP = this.loadIcon("dynamic_p.png");
        this.dynamicMP = this.loadIcon("dynamic_mp.png");
        this.dynamicMF = this.loadIcon("dynamic_mf.png");
        this.dynamicF = this.loadIcon("dynamic_f.png");
        this.dynamicFF = this.loadIcon("dynamic_ff.png");
        this.dynamicFFF = this.loadIcon("dynamic_fff.png");
        this.effectDead = this.loadIcon("effect_dead.png");
        this.effectGhost = this.loadIcon("effect_ghost.png");
        this.effectAccentuated = this.loadIcon("effect_accentuated.png");
        this.effectHeavyAccentuated = this.loadIcon("effect_heavy_accentuated.png");
        this.effectHarmonic = this.loadIcon("effect_harmonic.png");
        this.effectGrace = this.loadIcon("effect_grace.png");
        this.effectBend = this.loadIcon("effect_bend.png");
        this.effectTremoloBar = this.loadIcon("effect_tremolo_bar.png");
        this.effectSlide = this.loadIcon("effect_slide.png");
        this.effectHammer = this.loadIcon("effect_hammer.png");
        this.effectVibrato = this.loadIcon("effect_vibrato.png");
        this.effectTrill = this.loadIcon("effect_trill.png");
        this.effectTremoloPicking = this.loadIcon("effect_tremolo_picking.png");
        this.effectPalmMute = this.loadIcon("effect_palm_mute.png");
        this.effectStaccato = this.loadIcon("effect_staccato.png");
        this.effectTapping = this.loadIcon("effect_tapping.png");
        this.effectSlapping = this.loadIcon("effect_slapping.png");
        this.effectPopping = this.loadIcon("effect_popping.png");
        this.effectFadeIn = this.loadIcon("effect_fade_in.png");
        this.browserNew = this.loadIcon("browser_new.png");
        this.browserFile = this.loadIcon("browser_file.png");
        this.browserFolder = this.loadIcon("browser_folder.png");
        this.browserRoot = this.loadIcon("browser_root.png");
        this.browserBack = this.loadIcon("browser_back.png");
        this.browserRefresh = this.loadIcon("browser_refresh.png");
        this.arrowUp = this.loadIcon("arrow_up.png");
        this.arrowDown = this.loadIcon("arrow_down.png");
        this.arrowLeft = this.loadIcon("arrow_left.png");
        this.arrowRight = this.loadIcon("arrow_right.png");
        this.statusQuestion = this.loadIcon("status_question.png");
        this.statusError = this.loadIcon("status_error.png");
        this.statusWarning = this.loadIcon("status_warning.png");
        this.statusInfo = this.loadIcon("status_info.png");
        this.strokeUp = this.loadIcon("stroke_up.png");
        this.strokeDown = this.loadIcon("stroke_down.png");
        this.settings = this.loadIcon("settings.png");
        this.toolbarEdit = this.loadIcon("toolbar_edit.png");
        this.listAdd = this.loadIcon("list_add.png");
        this.listEdit = this.loadIcon("list_edit.png");
        this.listRemove = this.loadIcon("list_remove.png");
    }

    private UIImage loadIcon(String name) {
        UIImage image = this.theme.getResource(name);
        if (image == null) {
            image = TGFileUtils.loadImage(this.context, this.theme.getName(), name);
            this.theme.setResource(name, image);
        }
        return image;
    }

    public void disposeThemes() {
        ArrayList<String> themes = new ArrayList<String>(this.themeCache.keySet());
        for (String theme : themes) {
            this.disposeTheme(this.themeCache.remove(theme));
        }
    }

    public void disposeTheme(TGIconTheme theme) {
        ArrayList<UIImage> uiImages = new ArrayList<UIImage>(theme.getResources().values());
        for (UIImage uiImage : uiImages) {
            uiImage.dispose();
        }
    }

    public void disposeIcons() {
        this.disposeThemes();
    }

    public UIImage getDuration(int value) {
        switch (value) {
            case 1: {
                return this.durations[0];
            }
            case 2: {
                return this.durations[1];
            }
            case 4: {
                return this.durations[2];
            }
            case 8: {
                return this.durations[3];
            }
            case 16: {
                return this.durations[4];
            }
            case 32: {
                return this.durations[5];
            }
            case 64: {
                return this.durations[6];
            }
        }
        return null;
    }

    public UIImage getAboutAuthors() {
        return this.aboutAuthors;
    }

    public UIImage getAboutDescription() {
        return this.aboutDescription;
    }

    public UIImage getAboutLicense() {
        return this.aboutLicense;
    }

    public UIImage getAppIcon() {
        return this.appIcon;
    }

    public UIImage getAppIcon16() {
        return this.appIcon16;
    }

    public UIImage getAppIcon24() {
        return this.appIcon24;
    }

    public UIImage getAppIcon32() {
        return this.appIcon32;
    }

    public UIImage getAppIcon48() {
        return this.appIcon48;
    }

    public UIImage getAppIcon64() {
        return this.appIcon64;
    }

    public UIImage getAppIcon96() {
        return this.appIcon96;
    }

    public UIImage getAppSplash() {
        return this.appSplash;
    }

    public UIImage getChord() {
        return this.chord;
    }

    public UIImage getText() {
        return this.text;
    }

    public UIImage getCompositionRepeatClose() {
        return this.compositionRepeatClose;
    }

    public UIImage getCompositionRepeatAlternative() {
        return this.compositionRepeatAlternative;
    }

    public UIImage getCompositionRepeatOpen() {
        return this.compositionRepeatOpen;
    }

    public UIImage getCompositionTempo() {
        return this.compositionTempo;
    }

    public UIImage getCompositionTimeSignature() {
        return this.compositionTimeSignature;
    }

    public UIImage getDurationDotted() {
        return this.durationDotted;
    }

    public UIImage getDurationDoubleDotted() {
        return this.durationDoubleDotted;
    }

    public UIImage getDivisionType() {
        return this.divisionType;
    }

    public UIImage getDynamicF() {
        return this.dynamicF;
    }

    public UIImage getDynamicFF() {
        return this.dynamicFF;
    }

    public UIImage getDynamicFFF() {
        return this.dynamicFFF;
    }

    public UIImage getDynamicMF() {
        return this.dynamicMF;
    }

    public UIImage getDynamicMP() {
        return this.dynamicMP;
    }

    public UIImage getDynamicP() {
        return this.dynamicP;
    }

    public UIImage getDynamicPP() {
        return this.dynamicPP;
    }

    public UIImage getDynamicPPP() {
        return this.dynamicPPP;
    }

    public UIImage getEditModeEdition() {
        return this.editModeEdition;
    }

    public UIImage getEditModeEditionNotNatural() {
        return this.editModeEditionNotNatural;
    }

    public UIImage getEditModeSelection() {
        return this.editModeSelection;
    }

    public UIImage getEditRedo() {
        return this.editRedo;
    }

    public UIImage getEditUndo() {
        return this.editUndo;
    }

    public UIImage getEditVoice1() {
        return this.editVoice1;
    }

    public UIImage getEditVoice2() {
        return this.editVoice2;
    }

    public UIImage getEffectAccentuated() {
        return this.effectAccentuated;
    }

    public UIImage getEffectBend() {
        return this.effectBend;
    }

    public UIImage getEffectDead() {
        return this.effectDead;
    }

    public UIImage getEffectFadeIn() {
        return this.effectFadeIn;
    }

    public UIImage getEffectGhost() {
        return this.effectGhost;
    }

    public UIImage getEffectGrace() {
        return this.effectGrace;
    }

    public UIImage getEffectHammer() {
        return this.effectHammer;
    }

    public UIImage getEffectHarmonic() {
        return this.effectHarmonic;
    }

    public UIImage getEffectHeavyAccentuated() {
        return this.effectHeavyAccentuated;
    }

    public UIImage getEffectPalmMute() {
        return this.effectPalmMute;
    }

    public UIImage getEffectPopping() {
        return this.effectPopping;
    }

    public UIImage getEffectSlapping() {
        return this.effectSlapping;
    }

    public UIImage getEffectSlide() {
        return this.effectSlide;
    }

    public UIImage getEffectStaccato() {
        return this.effectStaccato;
    }

    public UIImage getEffectTapping() {
        return this.effectTapping;
    }

    public UIImage getEffectTremoloBar() {
        return this.effectTremoloBar;
    }

    public UIImage getEffectTremoloPicking() {
        return this.effectTremoloPicking;
    }

    public UIImage getEffectTrill() {
        return this.effectTrill;
    }

    public UIImage getEffectVibrato() {
        return this.effectVibrato;
    }

    public UIImage getFileNew() {
        return this.fileNew;
    }

    public UIImage getFileOpen() {
        return this.fileOpen;
    }

    public UIImage getFilePrint() {
        return this.filePrint;
    }

    public UIImage getFilePrintPreview() {
        return this.filePrintPreview;
    }

    public UIImage getFileSave() {
        return this.fileSave;
    }

    public UIImage getFileSaveAs() {
        return this.fileSaveAs;
    }

    public UIImage getFretboard() {
        return this.fretboard;
    }

    public UIImage getFretboardFirstFret() {
        return this.fretboardFirstFret;
    }

    public UIImage getFretboardFret() {
        return this.fretboardFret;
    }

    public UIImage getLayoutLinear() {
        return this.layoutLinear;
    }

    public UIImage getLayoutMultitrack() {
        return this.layoutMultitrack;
    }

    public UIImage getLayoutPage() {
        return this.layoutPage;
    }

    public UIImage getLayoutScore() {
        return this.layoutScore;
    }

    public UIImage getLayoutCompact() {
        return this.layoutCompact;
    }

    public UIImage getMarkerAdd() {
        return this.markerAdd;
    }

    public UIImage getMarkerFirst() {
        return this.markerFirst;
    }

    public UIImage getMarkerLast() {
        return this.markerLast;
    }

    public UIImage getMarkerList() {
        return this.markerList;
    }

    public UIImage getMarkerNext() {
        return this.markerNext;
    }

    public UIImage getMarkerPrevious() {
        return this.markerPrevious;
    }

    public UIImage getMarkerRemove() {
        return this.markerRemove;
    }

    public UIImage getInstruments() {
        return this.instruments;
    }

    public UIImage getNoteTied() {
        return this.noteTied;
    }

    public UIImage getOptionLanguage() {
        return this.optionLanguage;
    }

    public UIImage getOptionMain() {
        return this.optionMain;
    }

    public UIImage getOptionSound() {
        return this.optionSound;
    }

    public UIImage getOptionStyle() {
        return this.optionStyle;
    }

    public UIImage getOptionToolbars() {
        return this.optionToolbars;
    }

    public UIImage getOptionSkin() {
        return this.optionSkin;
    }

    public UIImage getSongProperties() {
        return this.songProperties;
    }

    public UIImage getTrackAdd() {
        return this.trackAdd;
    }

    public UIImage getTrackRemove() {
        return this.trackRemove;
    }

    public UIImage getTransport() {
        return this.transport;
    }

    public UIImage getTransportFirst1() {
        return this.transportFirst1;
    }

    public UIImage getTransportFirst2() {
        return this.transportFirst2;
    }

    public UIImage getTransportIconFirst1() {
        return this.transportIconFirst1;
    }

    public UIImage getTransportIconFirst2() {
        return this.transportIconFirst2;
    }

    public UIImage getTransportIconLast1() {
        return this.transportIconLast1;
    }

    public UIImage getTransportIconLast2() {
        return this.transportIconLast2;
    }

    public UIImage getTransportIconNext1() {
        return this.transportIconNext1;
    }

    public UIImage getTransportIconNext2() {
        return this.transportIconNext2;
    }

    public UIImage getTransportIconPause() {
        return this.transportIconPause;
    }

    public UIImage getTransportIconPlay1() {
        return this.transportIconPlay1;
    }

    public UIImage getTransportIconPlay2() {
        return this.transportIconPlay2;
    }

    public UIImage getTransportIconPrevious1() {
        return this.transportIconPrevious1;
    }

    public UIImage getTransportIconPrevious2() {
        return this.transportIconPrevious2;
    }

    public UIImage getTransportIconStop1() {
        return this.transportIconStop1;
    }

    public UIImage getTransportIconStop2() {
        return this.transportIconStop2;
    }

    public UIImage getTransportLast1() {
        return this.transportLast1;
    }

    public UIImage getTransportLast2() {
        return this.transportLast2;
    }

    public UIImage getTransportNext1() {
        return this.transportNext1;
    }

    public UIImage getTransportNext2() {
        return this.transportNext2;
    }

    public UIImage getTransportPause() {
        return this.transportPause;
    }

    public UIImage getTransportPlay1() {
        return this.transportPlay1;
    }

    public UIImage getTransportPlay2() {
        return this.transportPlay2;
    }

    public UIImage getTransportPrevious1() {
        return this.transportPrevious1;
    }

    public UIImage getTransportPrevious2() {
        return this.transportPrevious2;
    }

    public UIImage getTransportStop1() {
        return this.transportStop1;
    }

    public UIImage getTransportStop2() {
        return this.transportStop2;
    }

    public UIImage getTransportMetronome() {
        return this.transportMetronome;
    }

    public UIImage getTransportMode() {
        return this.transportMode;
    }

    public UIImage getBrowserBack() {
        return this.browserBack;
    }

    public UIImage getBrowserFile() {
        return this.browserFile;
    }

    public UIImage getBrowserFolder() {
        return this.browserFolder;
    }

    public UIImage getBrowserRefresh() {
        return this.browserRefresh;
    }

    public UIImage getBrowserRoot() {
        return this.browserRoot;
    }

    public UIImage getBrowserNew() {
        return this.browserNew;
    }

    public UIImage getStrokeUp() {
        return this.strokeUp;
    }

    public UIImage getStrokeDown() {
        return this.strokeDown;
    }

    public UIImage getSettings() {
        return this.settings;
    }

    public UIImage getToolbarEdit() {
        return this.toolbarEdit;
    }

    public UIImage getArrowUp() {
        return this.arrowUp;
    }

    public UIImage getArrowDown() {
        return this.arrowDown;
    }

    public UIImage getArrowLeft() {
        return this.arrowLeft;
    }

    public UIImage getArrowRight() {
        return this.arrowRight;
    }

    public UIImage getStatusQuestion() {
        return this.statusQuestion;
    }

    public UIImage getStatusError() {
        return this.statusError;
    }

    public UIImage getStatusWarning() {
        return this.statusWarning;
    }

    public UIImage getStatusInfo() {
        return this.statusInfo;
    }

    public UIImage getListAdd() {
        return this.listAdd;
    }

    public UIImage getListEdit() {
        return this.listEdit;
    }

    public UIImage getListRemove() {
        return this.listRemove;
    }

    public static TGIconManager getInstance(TGContext context) {
        return (TGIconManager)TGSingletonUtil.getInstance((TGContext)context, (String)TGIconManager.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGIconManager>(){

            public TGIconManager createInstance(TGContext context) {
                return new TGIconManager(context);
            }
        });
    }
}

