/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.printer;

import org.herac.tuxguitar.app.system.config.TGConfigManager;
import org.herac.tuxguitar.graphics.control.TGLayoutStyles;
import org.herac.tuxguitar.ui.resource.UIColorModel;

public class PrintLayoutStyles
extends TGLayoutStyles {
    private static final UIColorModel DEFAULT_BACKGROUND_COLOR = new UIColorModel(255, 255, 255);
    private static final int DEFAULT_SCORE_LINE_SPACING = 7;
    private static final int DEFAULT_STRING_SPACING = 8;
    private static final int DEFAULT_HORIZONTAL_SPACING = 15;
    private static final int DEFAULT_MIN_SCORE_TAB_SPACING = 15;
    private static final int DEFAULT_TRACK_SPACING = 5;
    private static final int DEFAULT_FIRST_TRACK_SPACING = 5;
    private static final int DEFAULT_FIRST_NOTE_SPACING = 10;
    private static final int DEFAULT_CLEF_SPACING = 30;
    private static final int DEFAULT_MIN_BUFFER_SEPARATOR = 15;
    private static final int DEFAULT_MIN_TOP_SPACING = 20;
    private static final int DEFAULT_CHORD_FRET_INDEX_SPACING = 8;
    private static final int DEFAULT_CHORD_STRING_SPACING = 4;
    private static final int DEFAULT_CHORD_FRET_SPACING = 5;
    private static final int DEFAULT_CHORD_LINE_WIDTH = 0;
    private static final int DEFAULT_CHORD_NOTE_SIZE = 3;
    private static final int DEFAULT_EFFECT_SPACING = 8;
    private static final int DEFAULT_DIVISION_TYPE_SPACING = 10;
    private static final int DEFAULT_MARKER_SPACING = 15;
    private static final int DEFAULT_TEXT_SPACING = 15;
    private static final int DEFAULT_REPEAT_ENDING_SPACING = 20;
    private static final float[] DEFAULT_LINE_WIDTHS = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
    private static final float[] DEFAULT_DURATION_WIDTHS = new float[]{25.0f, 22.0f, 20.0f, 18.0f, 16.0f};

    public PrintLayoutStyles(TGConfigManager config) {
        this.setBufferEnabled(false);
        this.setFirstMeasureSpacing(15.0f);
        this.setMinBufferSeparator(15.0f);
        this.setMinTopSpacing(20.0f);
        this.setMinScoreTabSpacing(15.0f);
        this.setScoreLineSpacing(7.0f);
        this.setFirstTrackSpacing(5.0f);
        this.setTrackSpacing(5.0f);
        this.setStringSpacing(8.0f);
        this.setFirstNoteSpacing(10.0f);
        this.setMeasureLeftSpacing(15.0f);
        this.setMeasureRightSpacing(15.0f);
        this.setClefSpacing(30.0f);
        this.setKeySignatureSpacing(15.0f);
        this.setTimeSignatureSpacing(15.0f);
        this.setChordFretIndexSpacing(8.0f);
        this.setChordStringSpacing(4.0f);
        this.setChordFretSpacing(5.0f);
        this.setChordNoteSize(3.0f);
        this.setChordLineWidth(0.0f);
        this.setRepeatEndingSpacing(20.0f);
        this.setTextSpacing(15.0f);
        this.setMarkerSpacing(15.0f);
        this.setDivisionTypeSpacing(10.0f);
        this.setEffectSpacing(8.0f);
        this.setLineWidths(DEFAULT_LINE_WIDTHS);
        this.setDurationWidths(DEFAULT_DURATION_WIDTHS);
        this.setDefaultFont(config.getFontModelConfigValue("font.printer.default"));
        this.setNoteFont(config.getFontModelConfigValue("font.printer.note"));
        this.setLyricFont(config.getFontModelConfigValue("font.printer.lyric"));
        this.setTextFont(config.getFontModelConfigValue("font.printer.text"));
        this.setGraceFont(config.getFontModelConfigValue("font.printer.grace"));
        this.setChordFont(config.getFontModelConfigValue("font.printer.chord"));
        this.setChordFretFont(config.getFontModelConfigValue("font.chord-fret"));
        this.setMarkerFont(config.getFontModelConfigValue("font.marker"));
        this.setLineColor(config.getColorModelConfigValue("color.line"));
        this.setScoreNoteColor(config.getColorModelConfigValue("color.score.note"));
        this.setTabNoteColor(config.getColorModelConfigValue("color.tab.note"));
        this.setPlayNoteColor(config.getColorModelConfigValue("color.play.note"));
        this.setLoopSMarkerColor(config.getColorModelConfigValue("color.loop.s.marker"));
        this.setLoopEMarkerColor(config.getColorModelConfigValue("color.loop.e.marker"));
        this.setMeasureNumberColor(config.getColorModelConfigValue("color.measure.number"));
        this.setBackgroundColor(DEFAULT_BACKGROUND_COLOR);
    }
}

