/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gervill;

import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.util.TGFileChooser;
import org.herac.tuxguitar.app.view.dialog.file.TGFileChooserDialog;
import org.herac.tuxguitar.app.view.dialog.file.TGFileChooserHandler;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.gervill.MidiToAudioSettings;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIDropDownSelect;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIRadioButton;
import org.herac.tuxguitar.ui.widget.UISelectItem;
import org.herac.tuxguitar.ui.widget.UITextField;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;

public class MidiToAudioSettingsDialog {
    private TGContext context;

    public MidiToAudioSettingsDialog(TGContext context) {
        this.context = context;
    }

    public void open(final MidiToAudioSettings settings, final Runnable onSuccess) {
        final List<MidiToAudioFormat> formats = this.getAvailableFormats();
        final List<TGFileFormat> soundbankFormats = this.getSupportedSoundbankFormats();
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UIWindow uiParent = TGWindow.getInstance((TGContext)this.context).getWindow();
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty((String)"gervill.options"));
        UITableLayout audioFormatLayout = new UITableLayout();
        UILegendPanel audioFormatGroup = uiFactory.createLegendPanel((UIContainer)dialog);
        audioFormatGroup.setLayout((UILayout)audioFormatLayout);
        audioFormatGroup.setText(TuxGuitar.getProperty((String)"gervill.options.audio-format"));
        dialogLayout.set((UIControl)audioFormatGroup, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(400.0f), null, null);
        UILabel eLabel = uiFactory.createLabel((UIContainer)audioFormatGroup);
        eLabel.setText(TuxGuitar.getProperty((String)"gervill.options.file-encoding") + ":");
        audioFormatLayout.set((UIControl)eLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UIDropDownSelect eCombo = uiFactory.createDropDownSelect((UIContainer)audioFormatGroup);
        audioFormatLayout.set((UIControl)eCombo, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UILabel tLabel = uiFactory.createLabel((UIContainer)audioFormatGroup);
        tLabel.setText(TuxGuitar.getProperty((String)"gervill.options.file-type") + ":");
        audioFormatLayout.set((UIControl)tLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UIDropDownSelect tCombo = uiFactory.createDropDownSelect((UIContainer)audioFormatGroup);
        audioFormatLayout.set((UIControl)tCombo, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        MidiToAudioFormat selectedFormat = null;
        for (MidiToAudioFormat format : formats) {
            eCombo.addItem(new UISelectItem(format.getFormat().getEncoding().toString(), (Object)format));
            if (!this.isSameEncoding(settings.getFormat(), format.getFormat())) continue;
            selectedFormat = format;
        }
        if (selectedFormat != null) {
            eCombo.setSelectedValue(selectedFormat);
            this.updateTypesCombo(settings, formats, (UIDropDownSelect<MidiToAudioFormat>)eCombo, (UIDropDownSelect<AudioFileFormat.Type>)tCombo);
        }
        eCombo.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                MidiToAudioSettingsDialog.this.updateTypesCombo(settings, formats, (UIDropDownSelect<MidiToAudioFormat>)eCombo, (UIDropDownSelect<AudioFileFormat.Type>)tCombo);
            }
        });
        UITableLayout soundbankLayout = new UITableLayout();
        UILegendPanel soundbankGroup = uiFactory.createLegendPanel((UIContainer)dialog);
        soundbankGroup.setLayout((UILayout)soundbankLayout);
        soundbankGroup.setText(TuxGuitar.getProperty((String)"gervill.options.soundbank.tip"));
        dialogLayout.set((UIControl)soundbankGroup, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(400.0f), null, null);
        UIRadioButton sbDefault = uiFactory.createRadioButton((UIContainer)soundbankGroup);
        sbDefault.setText(TuxGuitar.getProperty((String)"gervill.options.soundbank.default"));
        sbDefault.setSelected(settings.getSoundbankPath() == null);
        soundbankLayout.set((UIControl)sbDefault, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(2));
        soundbankLayout.set((UIControl)sbDefault, "packed_width", (Object)Float.valueOf(0.0f));
        final UIRadioButton sbCustom = uiFactory.createRadioButton((UIContainer)soundbankGroup);
        sbCustom.setText(TuxGuitar.getProperty((String)"gervill.options.soundbank.custom"));
        sbCustom.setSelected(settings.getSoundbankPath() != null);
        soundbankLayout.set((UIControl)sbCustom, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(2));
        soundbankLayout.set((UIControl)sbCustom, "packed_width", (Object)Float.valueOf(0.0f));
        final UITextField sbCustomPath = uiFactory.createTextField((UIContainer)soundbankGroup);
        sbCustomPath.setText(settings.getSoundbankPath() == null ? new String() : settings.getSoundbankPath());
        sbCustomPath.setEnabled(settings.getSoundbankPath() != null);
        soundbankLayout.set((UIControl)sbCustomPath, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
        final UIButton sbCustomChooser = uiFactory.createButton((UIContainer)soundbankGroup);
        sbCustomChooser.setImage(TuxGuitar.getInstance().getIconManager().getFileOpen());
        sbCustomChooser.setEnabled(settings.getSoundbankPath() != null);
        sbCustomChooser.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGFileChooser.getInstance((TGContext)MidiToAudioSettingsDialog.this.context).openChooser(new TGFileChooserHandler(){

                    public void updateFileName(String fileName) {
                        sbCustomPath.setText(fileName);
                    }
                }, soundbankFormats, TGFileChooserDialog.STYLE_OPEN);
            }
        });
        soundbankLayout.set((UIControl)sbCustomChooser, Integer.valueOf(3), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        UISelectionListener sbRadioSelectionListener = new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                sbCustomPath.setEnabled(sbCustom.isSelected());
                sbCustomChooser.setEnabled(sbCustom.isSelected());
            }
        };
        sbDefault.addSelectionListener(sbRadioSelectionListener);
        sbCustom.addSelectionListener(sbRadioSelectionListener);
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                String soundbankPath = sbCustom.isSelected() ? sbCustomPath.getText() : null;
                AudioFileFormat.Type type = (AudioFileFormat.Type)tCombo.getSelectedValue();
                MidiToAudioFormat format = (MidiToAudioFormat)eCombo.getSelectedValue();
                dialog.dispose();
                if (format != null && type != null) {
                    settings.setType(type);
                    settings.setFormat(format.getFormat());
                    settings.setSoundbankPath(soundbankPath);
                    onSuccess.run();
                }
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog((UIWindow)dialog, (int)5);
    }

    private void updateTypesCombo(MidiToAudioSettings settings, List<MidiToAudioFormat> encodings, UIDropDownSelect<MidiToAudioFormat> eCombo, UIDropDownSelect<AudioFileFormat.Type> tCombo) {
        tCombo.removeItems();
        MidiToAudioFormat encoding = (MidiToAudioFormat)eCombo.getSelectedValue();
        if (encoding != null) {
            for (AudioFileFormat.Type type : encoding.getTypes()) {
                tCombo.addItem(new UISelectItem(type.toString() + " (*." + type.getExtension() + ")", (Object)type));
            }
            tCombo.setSelectedValue((Object)settings.getType());
        }
    }

    public List<MidiToAudioFormat> getAvailableFormats() {
        ArrayList<MidiToAudioFormat> list = new ArrayList<MidiToAudioFormat>();
        AudioFormat srcFormat = MidiToAudioSettings.DEFAULT_FORMAT;
        AudioFormat.Encoding[] encodings = AudioSystem.getTargetEncodings(srcFormat);
        for (int i = 0; i < encodings.length; ++i) {
            AudioFormat dstFormat = new AudioFormat(encodings[i], srcFormat.getSampleRate(), srcFormat.getSampleSizeInBits(), srcFormat.getChannels(), srcFormat.getFrameSize(), srcFormat.getFrameRate(), srcFormat.isBigEndian());
            AudioInputStream dstStream = new AudioInputStream(null, dstFormat, 0L);
            AudioFileFormat.Type[] dstTypes = AudioSystem.getAudioFileTypes(dstStream);
            if (dstTypes.length <= 0) continue;
            list.add(new MidiToAudioFormat(dstFormat, dstTypes));
        }
        return list;
    }

    private List<TGFileFormat> getSupportedSoundbankFormats() {
        ArrayList<TGFileFormat> list = new ArrayList<TGFileFormat>();
        list.add(new TGFileFormat("SF2 files", "*/*", new String[]{"sf2"}));
        list.add(new TGFileFormat("DLS files", "*/*", new String[]{"dls"}));
        return list;
    }

    public boolean isSameEncoding(AudioFormat f1, AudioFormat f2) {
        if (f1 == null || f2 == null || f1.getEncoding() == null || f2.getEncoding() == null) {
            return false;
        }
        return f1.getEncoding().toString().equals(f2.getEncoding().toString());
    }

    private class MidiToAudioFormat {
        private AudioFormat format;
        private AudioFileFormat.Type[] types;

        public MidiToAudioFormat(AudioFormat format, AudioFileFormat.Type[] types) {
            this.format = format;
            this.types = types;
        }

        public AudioFormat getFormat() {
            return this.format;
        }

        public AudioFileFormat.Type[] getTypes() {
            return this.types;
        }
    }
}

