/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.ptb;

import java.io.IOException;
import java.io.InputStream;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.base.TGSongReader;
import org.herac.tuxguitar.io.base.TGSongReaderHandle;
import org.herac.tuxguitar.io.ptb.PTFileFormatDetector;
import org.herac.tuxguitar.io.ptb.PTSongParser;
import org.herac.tuxguitar.io.ptb.base.PTBar;
import org.herac.tuxguitar.io.ptb.base.PTBeat;
import org.herac.tuxguitar.io.ptb.base.PTDirection;
import org.herac.tuxguitar.io.ptb.base.PTGuitarIn;
import org.herac.tuxguitar.io.ptb.base.PTNote;
import org.herac.tuxguitar.io.ptb.base.PTSection;
import org.herac.tuxguitar.io.ptb.base.PTSong;
import org.herac.tuxguitar.io.ptb.base.PTSymbol;
import org.herac.tuxguitar.io.ptb.base.PTTempo;
import org.herac.tuxguitar.io.ptb.base.PTTrack;
import org.herac.tuxguitar.io.ptb.base.PTTrackInfo;

public class PTInputStream
implements TGSongReader {
    public static final TGFileFormat FILE_FORMAT = new TGFileFormat("PowerTab", "audio/x-ptb", new String[]{"ptb"});
    private InputStream stream;
    private PTSong song;
    private PTSongParser parser;

    public TGFileFormat getFileFormat() {
        return FILE_FORMAT;
    }

    public void read(TGSongReaderHandle handle) throws TGFileFormatException {
        try {
            this.stream = handle.getInputStream();
            this.parser = new PTSongParser(handle.getFactory());
            TGFileFormat fileFormat = new PTFileFormatDetector().getFileFormat(this.stream);
            if (fileFormat == null || !fileFormat.equals((Object)this.getFileFormat())) {
                throw new IOException("Unsupported Version");
            }
            this.song = new PTSong();
            this.readSongInfo();
            this.readDataInstruments(this.song.getTrack1());
            this.readDataInstruments(this.song.getTrack2());
            this.close();
            handle.setSong(this.parser.parseSong(this.song));
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable);
        }
    }

    private void readSongInfo() {
        this.song.getInfo().setClassification(this.readByte());
        if (this.song.getInfo().getClassification() == 0) {
            this.skip(1);
            this.song.getInfo().setName(this.readString());
            this.song.getInfo().setInterpret(this.readString());
            this.song.getInfo().setReleaseType(this.readByte());
            if (this.song.getInfo().getReleaseType() == 0) {
                this.song.getInfo().setAlbumType(this.readByte());
                this.song.getInfo().setAlbum(this.readString());
                this.song.getInfo().setYear(this.readShort());
                this.song.getInfo().setLiveRecording(this.readBoolean());
            } else if (this.song.getInfo().getReleaseType() == 1) {
                this.song.getInfo().setAlbum(this.readString());
                this.song.getInfo().setLiveRecording(this.readBoolean());
            } else if (this.song.getInfo().getReleaseType() == 2) {
                this.song.getInfo().setAlbum(this.readString());
                this.song.getInfo().setDay(this.readShort());
                this.song.getInfo().setMonth(this.readShort());
                this.song.getInfo().setYear(this.readShort());
            }
            if (this.readByte() == 0) {
                this.song.getInfo().setAuthor(this.readString());
                this.song.getInfo().setLyricist(this.readString());
            }
            this.song.getInfo().setArrenger(this.readString());
            this.song.getInfo().setGuitarTranscriber(this.readString());
            this.song.getInfo().setBassTranscriber(this.readString());
            this.song.getInfo().setCopyright(this.readString());
            this.song.getInfo().setLyrics(this.readString());
            this.song.getInfo().setGuitarInstructions(this.readString());
            this.song.getInfo().setBassInstructions(this.readString());
        } else if (this.song.getInfo().getClassification() == 1) {
            this.song.getInfo().setName(this.readString());
            this.song.getInfo().setAlbum(this.readString());
            this.song.getInfo().setStyle(this.readShort());
            this.song.getInfo().setLevel(this.readByte());
            this.song.getInfo().setAuthor(this.readString());
            this.song.getInfo().setInstructions(this.readString());
            this.song.getInfo().setCopyright(this.readString());
        }
    }

    private void readDataInstruments(PTTrack track) {
        int j;
        int itemCount = this.readHeaderItems();
        for (j = 0; j < itemCount; ++j) {
            this.readTrackInfo(track);
            if (j >= itemCount - 1) continue;
            this.readShort();
        }
        itemCount = this.readHeaderItems();
        for (j = 0; j < itemCount; ++j) {
            this.readChord();
            if (j >= itemCount - 1) continue;
            this.readShort();
        }
        itemCount = this.readHeaderItems();
        for (j = 0; j < itemCount; ++j) {
            this.readFloattingText();
            if (j >= itemCount - 1) continue;
            this.readShort();
        }
        itemCount = this.readHeaderItems();
        for (j = 0; j < itemCount; ++j) {
            this.readGuitarIn(track);
            if (j >= itemCount - 1) continue;
            this.readShort();
        }
        itemCount = this.readHeaderItems();
        for (j = 0; j < itemCount; ++j) {
            this.readTempoMarker(track);
            if (j >= itemCount - 1) continue;
            this.readShort();
        }
        itemCount = this.readHeaderItems();
        for (j = 0; j < itemCount; ++j) {
            this.readDynamic();
            if (j >= itemCount - 1) continue;
            this.readShort();
        }
        itemCount = this.readHeaderItems();
        for (j = 0; j < itemCount; ++j) {
            this.readSectionSymbol(track);
            if (j >= itemCount - 1) continue;
            this.readShort();
        }
        itemCount = this.readHeaderItems();
        for (j = 0; j < itemCount; ++j) {
            this.readSection(track.getSection(j));
            if (j >= itemCount - 1) continue;
            this.readShort();
        }
    }

    private void readTrackInfo(PTTrack track) {
        PTTrackInfo info = new PTTrackInfo();
        info.setNumber(this.readByte());
        info.setName(this.readString());
        info.setInstrument((short)this.readByte());
        info.setVolume((short)this.readByte());
        info.setBalance((short)this.readByte());
        info.setReverb((short)this.readByte());
        info.setChorus((short)this.readByte());
        info.setTremolo((short)this.readByte());
        info.setPhaser((short)this.readByte());
        this.readByte();
        this.readString();
        this.readByte();
        int[] strings = new int[this.readByte() & 0xFF];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = this.readByte();
        }
        info.setStrings(strings);
        track.getInfos().add(info);
    }

    private void readSection(PTSection section) {
        int j;
        this.readInt();
        this.readInt();
        this.readInt();
        this.readInt();
        int lastBarData = this.readByte();
        this.readByte();
        this.readByte();
        this.readByte();
        this.readByte();
        this.readBarLine(section);
        int itemCount = this.readHeaderItems();
        for (j = 0; j < itemCount; ++j) {
            this.readDirection(section);
            if (j >= itemCount - 1) continue;
            this.readShort();
        }
        itemCount = this.readHeaderItems();
        for (j = 0; j < itemCount; ++j) {
            this.readChordText();
            if (j >= itemCount - 1) continue;
            this.readShort();
        }
        itemCount = this.readHeaderItems();
        for (j = 0; j < itemCount; ++j) {
            this.readRhythmSlash();
            if (j >= itemCount - 1) continue;
            this.readShort();
        }
        section.setStaffs(this.readHeaderItems());
        for (int staff = 0; staff < section.getStaffs(); ++staff) {
            this.readStaff(staff, section);
            if (staff >= section.getStaffs() - 1) continue;
            this.readShort();
        }
        itemCount = this.readHeaderItems();
        for (j = 0; j < itemCount; ++j) {
            this.readBarLine(section);
            if (j >= itemCount - 1) continue;
            this.readShort();
        }
        PTBar bar = new PTBar();
        bar.setRepeatClose(lastBarData >>> 5 == 4 ? lastBarData - 128 : 0);
        section.getPosition(section.getNextPositionNumber()).addComponent(bar);
    }

    private void readStaff(int staff, PTSection section) {
        this.readByte();
        this.readByte();
        this.readByte();
        this.readByte();
        this.readByte();
        for (int voice = 0; voice < 2; ++voice) {
            int itemCount = this.readHeaderItems();
            for (int j = 0; j < itemCount; ++j) {
                this.readPosition(staff, voice, section);
                if (j >= itemCount - 1) continue;
                this.readShort();
            }
        }
    }

    private void readPosition(int staff, int voice, PTSection section) {
        PTBeat beat = new PTBeat(staff, voice);
        int position = this.readByte();
        int beaming = this.readByte();
        beaming = beaming - 128 < 0 ? beaming : beaming - 128;
        this.readByte();
        int data1 = this.readByte();
        this.readByte();
        int data3 = this.readByte();
        int durationValue = this.readByte();
        int multiBarRest = 1;
        int complexCount = this.readByte();
        for (int i = 0; i < complexCount; ++i) {
            int count = this.readShort();
            this.readByte();
            int type = this.readByte();
            if ((type & 8) == 0) continue;
            multiBarRest = count;
        }
        int itemCount = this.readHeaderItems();
        for (int j = 0; j < itemCount; ++j) {
            this.readNote(beat);
            if (j >= itemCount - 1) continue;
            this.readShort();
        }
        beat.setMultiBarRest(itemCount == 0 ? multiBarRest : 1);
        beat.setVibrato((data1 & 8) != 0 || (data1 & 0x10) != 0);
        beat.setGrace((data3 & 1) != 0);
        beat.setDuration(durationValue);
        beat.setDotted((data1 & 1) != 0);
        beat.setDoubleDotted((data1 & 2) != 0);
        beat.setArpeggioUp((data1 & 0x20) != 0);
        beat.setArpeggioDown((data1 & 0x40) != 0);
        beat.setEnters((beaming - beaming % 8) / 8 + 1);
        beat.setTimes(beaming % 8 + 1);
        section.getPosition(position).addComponent(beat);
    }

    private void readNote(PTBeat beat) {
        PTNote note = new PTNote();
        int position = this.readByte();
        int simpleData = this.readShort();
        int symbolCount = this.readByte();
        for (int i = 0; i < symbolCount; ++i) {
            this.readByte();
            this.readByte();
            int data3 = this.readByte();
            int data4 = this.readByte();
            note.setBend(data4 == 101 ? data3 / 16 + 1 : 0);
            note.setSlide(data4 == 100);
        }
        note.setValue(position & 0x1F);
        note.setString(((position & 0xE0) >> 5) + 1);
        note.setTied((simpleData & 1) != 0);
        note.setDead((simpleData & 2) != 0);
        beat.addNote(note);
    }

    private void readTimeSignature(PTBar bar) {
        int data = this.readInt();
        this.readByte();
        bar.setNumerator(((data >> 24) - (data >> 24) % 8) / 8 + 1);
        bar.setDenominator((int)Math.pow(2.0, (data >> 24) % 8));
    }

    private void readKeySignature() {
        this.readByte();
    }

    private void readBarLine(PTSection section) {
        PTBar bar = new PTBar();
        int position = this.readByte();
        int type = this.readByte();
        bar.setRepeatStart(type >>> 5 == 3);
        bar.setRepeatClose(type >>> 5 == 4 ? type - 128 : 0);
        this.readKeySignature();
        this.readTimeSignature(bar);
        this.readRehearsalSign();
        section.getPosition(position).addComponent(bar);
    }

    private void readChord() {
        this.readShort();
        this.readByte();
        this.readShort();
        this.readByte();
        this.readByte();
        int stringCount = this.readByte();
        for (int j = 0; j < stringCount; ++j) {
            this.readByte();
        }
    }

    private void readFloattingText() {
        this.readString();
        this.readInt();
        this.readInt();
        this.readInt();
        this.readInt();
        this.readByte();
        this.readFontSetting();
    }

    private void readFontSetting() {
        this.readString();
        this.readInt();
        this.readInt();
        this.readBoolean();
        this.readBoolean();
        this.readBoolean();
        this.readInt();
    }

    private void readGuitarIn(PTTrack track) {
        int section = this.readShort();
        int staff = this.readByte();
        int position = this.readByte();
        this.skip(1);
        int info = this.readByte() & 0xFF;
        track.getSection(section).getPosition(position).addComponent(new PTGuitarIn(staff, info));
    }

    private void readTempoMarker(PTTrack track) {
        int section = this.readShort();
        int position = this.readByte();
        int tempo = this.readShort();
        int data = this.readShort();
        this.readString();
        int tripletFeel = 1;
        if ((data & 1) != 0) {
            tripletFeel = 2;
        } else if ((data & 2) != 0) {
            tripletFeel = 3;
        }
        if (tempo > 0) {
            track.getSection(section).getPosition(position).addComponent(new PTTempo(tempo, tripletFeel));
        }
    }

    private void readSectionSymbol(PTTrack track) {
        int section = this.readShort();
        int position = this.readByte();
        int data = this.readInt();
        PTSymbol symbol = new PTSymbol();
        symbol.setEndNumber(data >> 16);
        track.getSection(section).getPosition(position).addComponent(symbol);
    }

    private void readDynamic() {
        this.readShort();
        this.readByte();
        this.readByte();
        this.readShort();
    }

    private void readRehearsalSign() {
        this.readByte();
        this.readString();
    }

    private void readDirection(PTSection section) {
        int position = this.readByte();
        int symboleCount = this.readByte();
        for (int i = 0; i < symboleCount; ++i) {
            int data = this.readShort();
            section.getPosition(position).addComponent(new PTDirection(data >> 8, (data & 0xC0) >> 6, data & 0x1F));
        }
    }

    private void readChordText() {
        this.readByte();
        this.readShort();
        this.readByte();
        this.readShort();
        this.readByte();
    }

    private void readRhythmSlash() {
        this.readByte();
        this.readByte();
        this.readInt();
    }

    private int readHeaderItems() {
        int header;
        int nbItems = this.readShort();
        if (nbItems != 0 && (header = this.readShort()) == 65535) {
            if (this.readShort() != 1) {
                return -1;
            }
            this.readString(this.readShort());
        }
        return nbItems;
    }

    private String readString() {
        try {
            int length = this.stream.read() & 0xFF;
            return this.readString(length < 255 ? length : this.readShort());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String readString(int length) {
        try {
            byte[] bytes = new byte[length];
            this.stream.read(bytes);
            return new String(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private int readInt() {
        try {
            byte[] b = new byte[4];
            this.stream.read(b);
            return (b[3] & 0xFF) << 24 | (b[2] & 0xFF) << 16 | (b[1] & 0xFF) << 8 | b[0] & 0xFF;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private int readShort() {
        try {
            byte[] b = new byte[]{0, 0};
            this.stream.read(b);
            return (b[1] & 0xFF) << 8 | b[0] & 0xFF;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private boolean readBoolean() {
        try {
            return this.stream.read() > 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private int readByte() {
        try {
            return this.stream.read();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private void skip(int bytes) {
        try {
            this.stream.read(new byte[bytes]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void close() {
        try {
            this.stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

