// -*- C++ -*-
/**
 * Code generated by the The ACE ORB (TAO) IDL Compiler v2.4.0
 * TAO and the TAO IDL Compiler have been developed by:
 *       Center for Distributed Object Computing
 *       Washington University
 *       St. Louis, MO
 *       USA
 *       http://www.cs.wustl.edu/~schmidt/doc-center.html
 * and
 *       Distributed Object Computing Laboratory
 *       University of California at Irvine
 *       Irvine, CA
 *       USA
 * and
 *       Institute for Software Integrated Systems
 *       Vanderbilt University
 *       Nashville, TN
 *       USA
 *       http://www.isis.vanderbilt.edu/
 *
 * Information about TAO is available at:
 *     http://www.dre.vanderbilt.edu/~schmidt/TAO.html
 **/

// TAO_IDL - Generated from
// be/be_codegen.cpp:149

#ifndef _TAO_IDL_AVSTREAMSC_4JZM0V_H_
#define _TAO_IDL_AVSTREAMSC_4JZM0V_H_

#include /**/ "ace/pre.h"


#include /**/ "ace/config-all.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */


#include /**/ "orbsvcs/AV/AV_export.h"
#include "tao/AnyTypeCode/AnyTypeCode_methods.h"
#include "tao/AnyTypeCode/Any.h"
#include "tao/ORB.h"
#include "tao/SystemException.h"
#include "tao/UserException.h"
#include "tao/Basic_Types.h"
#include "tao/ORB_Constants.h"
#include "tao/Object.h"
#include "tao/AnyTypeCode/TypeCode.h"
#include "tao/AnyTypeCode/TypeCode_Constants.h"
#include "tao/AnyTypeCode/Any.h"
#include "tao/String_Manager_T.h"
#include "tao/Sequence_T.h"
#include "tao/Objref_VarOut_T.h"
#include "tao/Seq_Var_T.h"
#include "tao/Seq_Out_T.h"
#include "tao/VarOut_T.h"
#include "tao/Arg_Traits_T.h"
#include "tao/Basic_Arguments.h"
#include "tao/Special_Basic_Arguments.h"
#include "tao/Any_Insert_Policy_T.h"
#include "tao/Basic_Argument_T.h"
#include "tao/Fixed_Size_Argument_T.h"
#include "tao/Var_Size_Argument_T.h"
#include "tao/Object_Argument_T.h"
#include "tao/Special_Basic_Arguments.h"
#include "tao/UB_String_Arguments.h"
#include "tao/AnyTypeCode/Any_Arg_Traits.h"
#include /**/ "tao/Version.h"
#include /**/ "tao/Versioned_Namespace.h"

#include "CosPropertyC.h"

#if TAO_MAJOR_VERSION != 2 || TAO_MINOR_VERSION != 4 || TAO_MICRO_VERSION != 0
#error This file should be regenerated with TAO_IDL
#endif

#if defined (TAO_EXPORT_MACRO)
#undef TAO_EXPORT_MACRO
#endif
#define TAO_EXPORT_MACRO TAO_AV_Export

TAO_BEGIN_VERSIONED_NAMESPACE_DECL



// TAO_IDL - Generated from
// be/be_visitor_root/root_ch.cpp:157

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



namespace TAO
{
  template<typename T> class Narrow_Utils;
}
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_module/module_ch.cpp:35

namespace AVStreams
{

  // TAO_IDL - Generated from
  // be/be_type.cpp:258

  struct QoS;

  typedef
    ::TAO_Var_Var_T<
        QoS
      >
    QoS_var;

  typedef
    ::TAO_Out_T<
        QoS
      >
    QoS_out;

  // TAO_IDL - Generated from
  // be/be_visitor_structure/structure_ch.cpp:48

  struct TAO_AV_Export QoS
  {

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    
    typedef QoS_var _var_type;
    typedef QoS_out _out_type;

    static void _tao_any_destructor (void *);
    
    ::TAO::String_Manager QoSType;
    CosPropertyService::Properties QoSParams;
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_QoS;

  // TAO_IDL - Generated from
  // be/be_visitor_sequence/sequence_ch.cpp:99

#if !defined (_AVSTREAMS_STREAMQOS_CH_)
#define _AVSTREAMS_STREAMQOS_CH_

  class streamQoS;

  typedef
    ::TAO_VarSeq_Var_T<
        streamQoS
      >
    streamQoS_var;

  typedef
    ::TAO_Seq_Out_T<
        streamQoS
      >
    streamQoS_out;

  class TAO_AV_Export streamQoS
    : public
        ::TAO::unbounded_value_sequence<
            QoS
          >
  {
  public:
    streamQoS (void);
    streamQoS ( ::CORBA::ULong max);
    streamQoS (
      ::CORBA::ULong max,
      ::CORBA::ULong length,
      QoS* buffer,
      ::CORBA::Boolean release = false);
    streamQoS (const streamQoS &);
    virtual ~streamQoS (void);
    

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    
    typedef streamQoS_var _var_type;
    typedef streamQoS_out _out_type;

    static void _tao_any_destructor (void *);
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_streamQoS;

  // TAO_IDL - Generated from
  // be/be_visitor_sequence/sequence_ch.cpp:99

#if !defined (_AVSTREAMS_FLOWSPEC_CH_)
#define _AVSTREAMS_FLOWSPEC_CH_

  class flowSpec;

  typedef
    ::TAO_VarSeq_Var_T<
        flowSpec
      >
    flowSpec_var;

  typedef
    ::TAO_Seq_Out_T<
        flowSpec
      >
    flowSpec_out;

  class TAO_AV_Export flowSpec
    : public
        ::TAO::unbounded_basic_string_sequence<char>
  {
  public:
    flowSpec (void);
    flowSpec ( ::CORBA::ULong max);
    flowSpec (
      ::CORBA::ULong max,
      ::CORBA::ULong length,
      ::CORBA::Char ** buffer,
      ::CORBA::Boolean release = false);
    flowSpec (const flowSpec &);
    virtual ~flowSpec (void);
    

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    
    typedef flowSpec_var _var_type;
    typedef flowSpec_out _out_type;

    static void _tao_any_destructor (void *);
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_flowSpec;

  // TAO_IDL - Generated from
  // be/be_visitor_sequence/sequence_ch.cpp:99

#if !defined (_AVSTREAMS_PROTOCOLSPEC_CH_)
#define _AVSTREAMS_PROTOCOLSPEC_CH_

  class protocolSpec;

  typedef
    ::TAO_VarSeq_Var_T<
        protocolSpec
      >
    protocolSpec_var;

  typedef
    ::TAO_Seq_Out_T<
        protocolSpec
      >
    protocolSpec_out;

  class TAO_AV_Export protocolSpec
    : public
        ::TAO::unbounded_basic_string_sequence<char>
  {
  public:
    protocolSpec (void);
    protocolSpec ( ::CORBA::ULong max);
    protocolSpec (
      ::CORBA::ULong max,
      ::CORBA::ULong length,
      ::CORBA::Char ** buffer,
      ::CORBA::Boolean release = false);
    protocolSpec (const protocolSpec &);
    virtual ~protocolSpec (void);
    

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    
    typedef protocolSpec_var _var_type;
    typedef protocolSpec_out _out_type;

    static void _tao_any_destructor (void *);
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_protocolSpec;

  // TAO_IDL - Generated from
  // be/be_visitor_sequence/sequence_ch.cpp:99

#if !defined (_AVSTREAMS_KEY_CH_)
#define _AVSTREAMS_KEY_CH_

  class key;

  typedef
    ::TAO_FixedSeq_Var_T<
        key
      >
    key_var;

  typedef
    ::TAO_Seq_Out_T<
        key
      >
    key_out;

  class TAO_AV_Export key
    : public
        ::TAO::unbounded_value_sequence<
            ::CORBA::Octet
          >
  {
  public:
    key (void);
    key ( ::CORBA::ULong max);
    key (
      ::CORBA::ULong max,
      ::CORBA::ULong length,
      ::CORBA::Octet* buffer,
      ::CORBA::Boolean release = false);
    key (const key &);
    virtual ~key (void);
    

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    
    typedef key_var _var_type;
    typedef key_out _out_type;

    static void _tao_any_destructor (void *);

    

#if (TAO_NO_COPY_OCTET_SEQUENCES == 1)
    key (
        ::CORBA::ULong length,
        const ACE_Message_Block* mb
      )
      : ::TAO::unbounded_value_sequence< ::CORBA::Octet> (length, mb) {}
#endif /* TAO_NO_COPY_OCTET_SEQUENCE == 1 */
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_key;

  // TAO_IDL - Generated from
  // be/be_type.cpp:258

  struct SFPStatus;

  typedef
    ::TAO_Fixed_Var_T<
        SFPStatus
      >
    SFPStatus_var;

  typedef
    SFPStatus &
    SFPStatus_out;

  // TAO_IDL - Generated from
  // be/be_visitor_structure/structure_ch.cpp:48

  struct TAO_AV_Export SFPStatus
  {

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    
    typedef SFPStatus_var _var_type;
    typedef SFPStatus_out _out_type;

    static void _tao_any_destructor (void *);
    
    ::CORBA::Boolean isFormatted;
    ::CORBA::Boolean isSpecialFormat;
    ::CORBA::Boolean seqNums;
    ::CORBA::Boolean timestamps;
    ::CORBA::Boolean sourceIndicators;
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_SFPStatus;

  // TAO_IDL - Generated from
  // be/be_visitor_enum/enum_ch.cpp:44

  enum flowState
  {
    stopped,
    started,
    dead
  };

  typedef flowState &flowState_out;

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_flowState;

  // TAO_IDL - Generated from
  // be/be_visitor_enum/enum_ch.cpp:44

  enum dirType
  {
    dir_in,
    dir_out
  };

  typedef dirType &dirType_out;

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_dirType;

  // TAO_IDL - Generated from
  // be/be_type.cpp:258

  struct flowStatus;

  typedef
    ::TAO_Var_Var_T<
        flowStatus
      >
    flowStatus_var;

  typedef
    ::TAO_Out_T<
        flowStatus
      >
    flowStatus_out;

  // TAO_IDL - Generated from
  // be/be_visitor_structure/structure_ch.cpp:48

  struct TAO_AV_Export flowStatus
  {

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    
    typedef flowStatus_var _var_type;
    typedef flowStatus_out _out_type;

    static void _tao_any_destructor (void *);
    
    ::TAO::String_Manager flowName;
    AVStreams::dirType directionality;
    AVStreams::flowState status;
    AVStreams::SFPStatus theFormat;
    AVStreams::QoS theQoS;
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_flowStatus;

  // TAO_IDL - Generated from
  // be/be_visitor_typedef/typedef_ch.cpp:510

  typedef CosPropertyService::Property streamEvent;
  typedef CosPropertyService::Property_var streamEvent_var;
  typedef CosPropertyService::Property_out streamEvent_out;

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_streamEvent;

  // TAO_IDL - Generated from
  // be/be_visitor_exception/exception_ch.cpp:41

  class TAO_AV_Export notSupported : public ::CORBA::UserException
  {
  public:

    notSupported (void);
    notSupported (const notSupported &);
    ~notSupported (void);

    notSupported &operator= (const notSupported &);

    static void _tao_any_destructor (void *);

    static notSupported *_downcast ( ::CORBA::Exception *);
    static const notSupported *_downcast ( ::CORBA::Exception const *);

    static ::CORBA::Exception *_alloc (void);

    virtual ::CORBA::Exception *_tao_duplicate (void) const;

    virtual void _raise (void) const;

    virtual void _tao_encode (TAO_OutputCDR &cdr) const;
    virtual void _tao_decode (TAO_InputCDR &cdr);

    virtual ::CORBA::TypeCode_ptr _tao_type (void) const;
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_notSupported;

  // TAO_IDL - Generated from
  // be/be_visitor_exception/exception_ch.cpp:41

  class TAO_AV_Export PropertyException : public ::CORBA::UserException
  {
  public:

    PropertyException (void);
    PropertyException (const PropertyException &);
    ~PropertyException (void);

    PropertyException &operator= (const PropertyException &);

    static void _tao_any_destructor (void *);

    static PropertyException *_downcast ( ::CORBA::Exception *);
    static const PropertyException *_downcast ( ::CORBA::Exception const *);

    static ::CORBA::Exception *_alloc (void);

    virtual ::CORBA::Exception *_tao_duplicate (void) const;

    virtual void _raise (void) const;

    virtual void _tao_encode (TAO_OutputCDR &cdr) const;
    virtual void _tao_decode (TAO_InputCDR &cdr);

    virtual ::CORBA::TypeCode_ptr _tao_type (void) const;
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_PropertyException;

  // TAO_IDL - Generated from
  // be/be_visitor_exception/exception_ch.cpp:41

  class TAO_AV_Export FPError : public ::CORBA::UserException
  {
  public:
    ::TAO::String_Manager flow_name;

    FPError (void);
    FPError (const FPError &);
    ~FPError (void);

    FPError &operator= (const FPError &);

    static void _tao_any_destructor (void *);

    static FPError *_downcast ( ::CORBA::Exception *);
    static const FPError *_downcast ( ::CORBA::Exception const *);

    static ::CORBA::Exception *_alloc (void);

    virtual ::CORBA::Exception *_tao_duplicate (void) const;

    virtual void _raise (void) const;

    virtual void _tao_encode (TAO_OutputCDR &cdr) const;
    virtual void _tao_decode (TAO_InputCDR &cdr);

    // TAO_IDL - Generated from
    // be/be_visitor_exception/exception_ctor.cpp:51

    FPError (
        const char * _tao_flow_name);

    virtual ::CORBA::TypeCode_ptr _tao_type (void) const;
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_FPError;

  // TAO_IDL - Generated from
  // be/be_visitor_exception/exception_ch.cpp:41

  class TAO_AV_Export streamOpFailed : public ::CORBA::UserException
  {
  public:
    ::TAO::String_Manager reason;

    streamOpFailed (void);
    streamOpFailed (const streamOpFailed &);
    ~streamOpFailed (void);

    streamOpFailed &operator= (const streamOpFailed &);

    static void _tao_any_destructor (void *);

    static streamOpFailed *_downcast ( ::CORBA::Exception *);
    static const streamOpFailed *_downcast ( ::CORBA::Exception const *);

    static ::CORBA::Exception *_alloc (void);

    virtual ::CORBA::Exception *_tao_duplicate (void) const;

    virtual void _raise (void) const;

    virtual void _tao_encode (TAO_OutputCDR &cdr) const;
    virtual void _tao_decode (TAO_InputCDR &cdr);

    // TAO_IDL - Generated from
    // be/be_visitor_exception/exception_ctor.cpp:51

    streamOpFailed (
        const char * _tao_reason);

    virtual ::CORBA::TypeCode_ptr _tao_type (void) const;
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_streamOpFailed;

  // TAO_IDL - Generated from
  // be/be_visitor_exception/exception_ch.cpp:41

  class TAO_AV_Export streamOpDenied : public ::CORBA::UserException
  {
  public:
    ::TAO::String_Manager reason;

    streamOpDenied (void);
    streamOpDenied (const streamOpDenied &);
    ~streamOpDenied (void);

    streamOpDenied &operator= (const streamOpDenied &);

    static void _tao_any_destructor (void *);

    static streamOpDenied *_downcast ( ::CORBA::Exception *);
    static const streamOpDenied *_downcast ( ::CORBA::Exception const *);

    static ::CORBA::Exception *_alloc (void);

    virtual ::CORBA::Exception *_tao_duplicate (void) const;

    virtual void _raise (void) const;

    virtual void _tao_encode (TAO_OutputCDR &cdr) const;
    virtual void _tao_decode (TAO_InputCDR &cdr);

    // TAO_IDL - Generated from
    // be/be_visitor_exception/exception_ctor.cpp:51

    streamOpDenied (
        const char * _tao_reason);

    virtual ::CORBA::TypeCode_ptr _tao_type (void) const;
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_streamOpDenied;

  // TAO_IDL - Generated from
  // be/be_visitor_exception/exception_ch.cpp:41

  class TAO_AV_Export noSuchFlow : public ::CORBA::UserException
  {
  public:

    noSuchFlow (void);
    noSuchFlow (const noSuchFlow &);
    ~noSuchFlow (void);

    noSuchFlow &operator= (const noSuchFlow &);

    static void _tao_any_destructor (void *);

    static noSuchFlow *_downcast ( ::CORBA::Exception *);
    static const noSuchFlow *_downcast ( ::CORBA::Exception const *);

    static ::CORBA::Exception *_alloc (void);

    virtual ::CORBA::Exception *_tao_duplicate (void) const;

    virtual void _raise (void) const;

    virtual void _tao_encode (TAO_OutputCDR &cdr) const;
    virtual void _tao_decode (TAO_InputCDR &cdr);

    virtual ::CORBA::TypeCode_ptr _tao_type (void) const;
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_noSuchFlow;

  // TAO_IDL - Generated from
  // be/be_visitor_exception/exception_ch.cpp:41

  class TAO_AV_Export QoSRequestFailed : public ::CORBA::UserException
  {
  public:
    ::TAO::String_Manager reason;

    QoSRequestFailed (void);
    QoSRequestFailed (const QoSRequestFailed &);
    ~QoSRequestFailed (void);

    QoSRequestFailed &operator= (const QoSRequestFailed &);

    static void _tao_any_destructor (void *);

    static QoSRequestFailed *_downcast ( ::CORBA::Exception *);
    static const QoSRequestFailed *_downcast ( ::CORBA::Exception const *);

    static ::CORBA::Exception *_alloc (void);

    virtual ::CORBA::Exception *_tao_duplicate (void) const;

    virtual void _raise (void) const;

    virtual void _tao_encode (TAO_OutputCDR &cdr) const;
    virtual void _tao_decode (TAO_InputCDR &cdr);

    // TAO_IDL - Generated from
    // be/be_visitor_exception/exception_ctor.cpp:51

    QoSRequestFailed (
        const char * _tao_reason);

    virtual ::CORBA::TypeCode_ptr _tao_type (void) const;
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_QoSRequestFailed;

  // TAO_IDL - Generated from
  // be/be_interface.cpp:748

#if !defined (_AVSTREAMS_BASIC_STREAMCTRL__VAR_OUT_CH_)
#define _AVSTREAMS_BASIC_STREAMCTRL__VAR_OUT_CH_

  class Basic_StreamCtrl;
  typedef Basic_StreamCtrl *Basic_StreamCtrl_ptr;

  typedef
    TAO_Objref_Var_T<
        Basic_StreamCtrl
      >
    Basic_StreamCtrl_var;
  
  typedef
    TAO_Objref_Out_T<
        Basic_StreamCtrl
      >
    Basic_StreamCtrl_out;

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_interface/interface_ch.cpp:40

  class TAO_AV_Export Basic_StreamCtrl
    : public virtual ::CosPropertyService::PropertySet
  
  {
  public:
    friend class TAO::Narrow_Utils<Basic_StreamCtrl>;

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    typedef Basic_StreamCtrl_ptr _ptr_type;
    typedef Basic_StreamCtrl_var _var_type;
    typedef Basic_StreamCtrl_out _out_type;

    static void _tao_any_destructor (void *);

    // The static operations.
    static Basic_StreamCtrl_ptr _duplicate (Basic_StreamCtrl_ptr obj);

    static void _tao_release (Basic_StreamCtrl_ptr obj);

    static Basic_StreamCtrl_ptr _narrow (::CORBA::Object_ptr obj);
    static Basic_StreamCtrl_ptr _unchecked_narrow (::CORBA::Object_ptr obj);
    static Basic_StreamCtrl_ptr _nil (void);

    virtual void stop (
      const ::AVStreams::flowSpec & the_spec);

    virtual void start (
      const ::AVStreams::flowSpec & the_spec);

    virtual void destroy (
      const ::AVStreams::flowSpec & the_spec);

    virtual ::CORBA::Boolean modify_QoS (
      ::AVStreams::streamQoS & new_qos,
      const ::AVStreams::flowSpec & the_spec);

    virtual void push_event (
      const ::AVStreams::streamEvent & the_event);

    virtual void set_FPStatus (
      const ::AVStreams::flowSpec & the_spec,
      const char * fp_name,
      const ::CORBA::Any & fp_settings);

    virtual ::CORBA::Object_ptr get_flow_connection (
      const char * flow_name);

    virtual void set_flow_connection (
      const char * flow_name,
      ::CORBA::Object_ptr flow_connection);

    // TAO_IDL - Generated from
    // be/be_visitor_interface/interface_ch.cpp:137

    virtual ::CORBA::Boolean _is_a (const char *type_id);
    virtual const char* _interface_repository_id (void) const;
    virtual ::CORBA::Boolean marshal (TAO_OutputCDR &cdr);
  
  protected:
    // Concrete interface only.
    Basic_StreamCtrl (void);

    // Concrete non-local interface only.
    Basic_StreamCtrl (
        ::IOP::IOR *ior,
        TAO_ORB_Core *orb_core);
    
    // Non-local interface only.
    Basic_StreamCtrl (
        TAO_Stub *objref,
        ::CORBA::Boolean _tao_collocated = false,
        TAO_Abstract_ServantBase *servant = 0,
        TAO_ORB_Core *orb_core = 0);

    virtual ~Basic_StreamCtrl (void);
  
  private:
    // Private and unimplemented for concrete interfaces.
    Basic_StreamCtrl (const Basic_StreamCtrl &);

    void operator= (const Basic_StreamCtrl &);
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_Basic_StreamCtrl;

  // TAO_IDL - Generated from
  // be/be_interface.cpp:748

#if !defined (_AVSTREAMS_NEGOTIATOR__VAR_OUT_CH_)
#define _AVSTREAMS_NEGOTIATOR__VAR_OUT_CH_

  class Negotiator;
  typedef Negotiator *Negotiator_ptr;

  typedef
    TAO_Objref_Var_T<
        Negotiator
      >
    Negotiator_var;
  
  typedef
    TAO_Objref_Out_T<
        Negotiator
      >
    Negotiator_out;

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_interface/interface_ch.cpp:40

  class TAO_AV_Export Negotiator
    : public virtual ::CORBA::Object
  {
  public:
    friend class TAO::Narrow_Utils<Negotiator>;

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    typedef Negotiator_ptr _ptr_type;
    typedef Negotiator_var _var_type;
    typedef Negotiator_out _out_type;

    static void _tao_any_destructor (void *);

    // The static operations.
    static Negotiator_ptr _duplicate (Negotiator_ptr obj);

    static void _tao_release (Negotiator_ptr obj);

    static Negotiator_ptr _narrow (::CORBA::Object_ptr obj);
    static Negotiator_ptr _unchecked_narrow (::CORBA::Object_ptr obj);
    static Negotiator_ptr _nil (void);

    virtual ::CORBA::Boolean negotiate (
      ::AVStreams::Negotiator_ptr remote_negotiator,
      const ::AVStreams::streamQoS & qos_spec);

    // TAO_IDL - Generated from
    // be/be_visitor_interface/interface_ch.cpp:137

    virtual ::CORBA::Boolean _is_a (const char *type_id);
    virtual const char* _interface_repository_id (void) const;
    virtual ::CORBA::Boolean marshal (TAO_OutputCDR &cdr);
  
  protected:
    // Concrete interface only.
    Negotiator (void);

    // Concrete non-local interface only.
    Negotiator (
        ::IOP::IOR *ior,
        TAO_ORB_Core *orb_core);
    
    // Non-local interface only.
    Negotiator (
        TAO_Stub *objref,
        ::CORBA::Boolean _tao_collocated = false,
        TAO_Abstract_ServantBase *servant = 0,
        TAO_ORB_Core *orb_core = 0);

    virtual ~Negotiator (void);
  
  private:
    // Private and unimplemented for concrete interfaces.
    Negotiator (const Negotiator &);

    void operator= (const Negotiator &);
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_Negotiator;

  // TAO_IDL - Generated from
  // be/be_interface.cpp:748

#if !defined (_AVSTREAMS_VDEV__VAR_OUT_CH_)
#define _AVSTREAMS_VDEV__VAR_OUT_CH_

  class VDev;
  typedef VDev *VDev_ptr;

  typedef
    TAO_Objref_Var_T<
        VDev
      >
    VDev_var;
  
  typedef
    TAO_Objref_Out_T<
        VDev
      >
    VDev_out;

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_interface.cpp:748

#if !defined (_AVSTREAMS_MMDEVICE__VAR_OUT_CH_)
#define _AVSTREAMS_MMDEVICE__VAR_OUT_CH_

  class MMDevice;
  typedef MMDevice *MMDevice_ptr;

  typedef
    TAO_Objref_Var_T<
        MMDevice
      >
    MMDevice_var;
  
  typedef
    TAO_Objref_Out_T<
        MMDevice
      >
    MMDevice_out;

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_interface.cpp:748

#if !defined (_AVSTREAMS_STREAMENDPOINT__VAR_OUT_CH_)
#define _AVSTREAMS_STREAMENDPOINT__VAR_OUT_CH_

  class StreamEndPoint;
  typedef StreamEndPoint *StreamEndPoint_ptr;

  typedef
    TAO_Objref_Var_T<
        StreamEndPoint
      >
    StreamEndPoint_var;
  
  typedef
    TAO_Objref_Out_T<
        StreamEndPoint
      >
    StreamEndPoint_out;

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_interface.cpp:748

#if !defined (_AVSTREAMS_STREAMENDPOINT_A__VAR_OUT_CH_)
#define _AVSTREAMS_STREAMENDPOINT_A__VAR_OUT_CH_

  class StreamEndPoint_A;
  typedef StreamEndPoint_A *StreamEndPoint_A_ptr;

  typedef
    TAO_Objref_Var_T<
        StreamEndPoint_A
      >
    StreamEndPoint_A_var;
  
  typedef
    TAO_Objref_Out_T<
        StreamEndPoint_A
      >
    StreamEndPoint_A_out;

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_interface.cpp:748

#if !defined (_AVSTREAMS_STREAMENDPOINT_B__VAR_OUT_CH_)
#define _AVSTREAMS_STREAMENDPOINT_B__VAR_OUT_CH_

  class StreamEndPoint_B;
  typedef StreamEndPoint_B *StreamEndPoint_B_ptr;

  typedef
    TAO_Objref_Var_T<
        StreamEndPoint_B
      >
    StreamEndPoint_B_var;
  
  typedef
    TAO_Objref_Out_T<
        StreamEndPoint_B
      >
    StreamEndPoint_B_out;

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_interface.cpp:748

#if !defined (_AVSTREAMS_STREAMCTRL__VAR_OUT_CH_)
#define _AVSTREAMS_STREAMCTRL__VAR_OUT_CH_

  class StreamCtrl;
  typedef StreamCtrl *StreamCtrl_ptr;

  typedef
    TAO_Objref_Var_T<
        StreamCtrl
      >
    StreamCtrl_var;
  
  typedef
    TAO_Objref_Out_T<
        StreamCtrl
      >
    StreamCtrl_out;

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_interface/interface_ch.cpp:40

  class TAO_AV_Export StreamCtrl
    : public virtual ::AVStreams::Basic_StreamCtrl
  
  {
  public:
    friend class TAO::Narrow_Utils<StreamCtrl>;

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    typedef StreamCtrl_ptr _ptr_type;
    typedef StreamCtrl_var _var_type;
    typedef StreamCtrl_out _out_type;

    static void _tao_any_destructor (void *);

    // The static operations.
    static StreamCtrl_ptr _duplicate (StreamCtrl_ptr obj);

    static void _tao_release (StreamCtrl_ptr obj);

    static StreamCtrl_ptr _narrow (::CORBA::Object_ptr obj);
    static StreamCtrl_ptr _unchecked_narrow (::CORBA::Object_ptr obj);
    static StreamCtrl_ptr _nil (void);

    virtual ::CORBA::Boolean bind_devs (
      ::AVStreams::MMDevice_ptr a_party,
      ::AVStreams::MMDevice_ptr b_party,
      ::AVStreams::streamQoS & the_qos,
      const ::AVStreams::flowSpec & the_flows);

    virtual ::CORBA::Boolean bind (
      ::AVStreams::StreamEndPoint_A_ptr a_party,
      ::AVStreams::StreamEndPoint_B_ptr b_party,
      ::AVStreams::streamQoS & the_qos,
      const ::AVStreams::flowSpec & the_flows);

    virtual void unbind_dev (
      ::AVStreams::MMDevice_ptr dev,
      const ::AVStreams::flowSpec & the_spec);

    virtual void unbind_party (
      ::AVStreams::StreamEndPoint_ptr the_ep,
      const ::AVStreams::flowSpec & the_spec);

    virtual void unbind (
      void);

    virtual ::AVStreams::VDev_ptr get_related_vdev (
      ::AVStreams::MMDevice_ptr adev,
      ::AVStreams::StreamEndPoint_out sep);

    // TAO_IDL - Generated from
    // be/be_visitor_interface/interface_ch.cpp:137

    virtual ::CORBA::Boolean _is_a (const char *type_id);
    virtual const char* _interface_repository_id (void) const;
    virtual ::CORBA::Boolean marshal (TAO_OutputCDR &cdr);
  
  protected:
    // Concrete interface only.
    StreamCtrl (void);

    // Concrete non-local interface only.
    StreamCtrl (
        ::IOP::IOR *ior,
        TAO_ORB_Core *orb_core);
    
    // Non-local interface only.
    StreamCtrl (
        TAO_Stub *objref,
        ::CORBA::Boolean _tao_collocated = false,
        TAO_Abstract_ServantBase *servant = 0,
        TAO_ORB_Core *orb_core = 0);

    virtual ~StreamCtrl (void);
  
  private:
    // Private and unimplemented for concrete interfaces.
    StreamCtrl (const StreamCtrl &);

    void operator= (const StreamCtrl &);
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_StreamCtrl;

  // TAO_IDL - Generated from
  // be/be_interface.cpp:748

#if !defined (_AVSTREAMS_MCASTCONFIGIF__VAR_OUT_CH_)
#define _AVSTREAMS_MCASTCONFIGIF__VAR_OUT_CH_

  class MCastConfigIf;
  typedef MCastConfigIf *MCastConfigIf_ptr;

  typedef
    TAO_Objref_Var_T<
        MCastConfigIf
      >
    MCastConfigIf_var;
  
  typedef
    TAO_Objref_Out_T<
        MCastConfigIf
      >
    MCastConfigIf_out;

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_interface/interface_ch.cpp:40

  class TAO_AV_Export MCastConfigIf
    : public virtual ::CosPropertyService::PropertySet
  
  {
  public:
    friend class TAO::Narrow_Utils<MCastConfigIf>;

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    typedef MCastConfigIf_ptr _ptr_type;
    typedef MCastConfigIf_var _var_type;
    typedef MCastConfigIf_out _out_type;

    static void _tao_any_destructor (void *);

    // The static operations.
    static MCastConfigIf_ptr _duplicate (MCastConfigIf_ptr obj);

    static void _tao_release (MCastConfigIf_ptr obj);

    static MCastConfigIf_ptr _narrow (::CORBA::Object_ptr obj);
    static MCastConfigIf_ptr _unchecked_narrow (::CORBA::Object_ptr obj);
    static MCastConfigIf_ptr _nil (void);

    virtual ::CORBA::Boolean set_peer (
      ::CORBA::Object_ptr peer,
      ::AVStreams::streamQoS & the_qos,
      const ::AVStreams::flowSpec & the_spec);

    virtual void configure (
      const ::CosPropertyService::Property & a_configuration);

    virtual void set_initial_configuration (
      const ::CosPropertyService::Properties & initial);

    virtual void set_format (
      const char * flowName,
      const char * format_name);

    virtual void set_dev_params (
      const char * flowName,
      const ::CosPropertyService::Properties & new_params);

    // TAO_IDL - Generated from
    // be/be_visitor_interface/interface_ch.cpp:137

    virtual ::CORBA::Boolean _is_a (const char *type_id);
    virtual const char* _interface_repository_id (void) const;
    virtual ::CORBA::Boolean marshal (TAO_OutputCDR &cdr);
  
  protected:
    // Concrete interface only.
    MCastConfigIf (void);

    // Concrete non-local interface only.
    MCastConfigIf (
        ::IOP::IOR *ior,
        TAO_ORB_Core *orb_core);
    
    // Non-local interface only.
    MCastConfigIf (
        TAO_Stub *objref,
        ::CORBA::Boolean _tao_collocated = false,
        TAO_Abstract_ServantBase *servant = 0,
        TAO_ORB_Core *orb_core = 0);

    virtual ~MCastConfigIf (void);
  
  private:
    // Private and unimplemented for concrete interfaces.
    MCastConfigIf (const MCastConfigIf &);

    void operator= (const MCastConfigIf &);
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_MCastConfigIf;

  // TAO_IDL - Generated from
  // be/be_visitor_interface/interface_ch.cpp:40

  class TAO_AV_Export StreamEndPoint
    : public virtual ::CosPropertyService::PropertySet
  
  {
  public:
    friend class TAO::Narrow_Utils<StreamEndPoint>;

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    typedef StreamEndPoint_ptr _ptr_type;
    typedef StreamEndPoint_var _var_type;
    typedef StreamEndPoint_out _out_type;

    static void _tao_any_destructor (void *);

    // The static operations.
    static StreamEndPoint_ptr _duplicate (StreamEndPoint_ptr obj);

    static void _tao_release (StreamEndPoint_ptr obj);

    static StreamEndPoint_ptr _narrow (::CORBA::Object_ptr obj);
    static StreamEndPoint_ptr _unchecked_narrow (::CORBA::Object_ptr obj);
    static StreamEndPoint_ptr _nil (void);

    virtual void stop (
      const ::AVStreams::flowSpec & the_spec);

    virtual void start (
      const ::AVStreams::flowSpec & the_spec);

    virtual void destroy (
      const ::AVStreams::flowSpec & the_spec);

    virtual ::CORBA::Boolean connect (
      ::AVStreams::StreamEndPoint_ptr responder,
      ::AVStreams::streamQoS & qos_spec,
      const ::AVStreams::flowSpec & the_spec);

    virtual ::CORBA::Boolean request_connection (
      ::AVStreams::StreamEndPoint_ptr initiator,
      ::CORBA::Boolean is_mcast,
      ::AVStreams::streamQoS & qos,
      ::AVStreams::flowSpec & the_spec);

    virtual ::CORBA::Boolean modify_QoS (
      ::AVStreams::streamQoS & new_qos,
      const ::AVStreams::flowSpec & the_flows);

    virtual ::CORBA::Boolean set_protocol_restriction (
      const ::AVStreams::protocolSpec & the_pspec);

    virtual void disconnect (
      const ::AVStreams::flowSpec & the_spec);

    virtual void set_FPStatus (
      const ::AVStreams::flowSpec & the_spec,
      const char * fp_name,
      const ::CORBA::Any & fp_settings);

    virtual ::CORBA::Object_ptr get_fep (
      const char * flow_name);

    virtual char * add_fep (
      ::CORBA::Object_ptr the_fep);

    virtual void remove_fep (
      const char * fep_name);

    virtual void set_negotiator (
      ::AVStreams::Negotiator_ptr new_negotiator);

    virtual void set_key (
      const char * flow_name,
      const ::AVStreams::key & the_key);

    virtual void set_source_id (
      ::CORBA::Long source_id);

    // TAO_IDL - Generated from
    // be/be_visitor_interface/interface_ch.cpp:137

    virtual ::CORBA::Boolean _is_a (const char *type_id);
    virtual const char* _interface_repository_id (void) const;
    virtual ::CORBA::Boolean marshal (TAO_OutputCDR &cdr);
  
  protected:
    // Concrete interface only.
    StreamEndPoint (void);

    // Concrete non-local interface only.
    StreamEndPoint (
        ::IOP::IOR *ior,
        TAO_ORB_Core *orb_core);
    
    // Non-local interface only.
    StreamEndPoint (
        TAO_Stub *objref,
        ::CORBA::Boolean _tao_collocated = false,
        TAO_Abstract_ServantBase *servant = 0,
        TAO_ORB_Core *orb_core = 0);

    virtual ~StreamEndPoint (void);
  
  private:
    // Private and unimplemented for concrete interfaces.
    StreamEndPoint (const StreamEndPoint &);

    void operator= (const StreamEndPoint &);
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_StreamEndPoint;

  // TAO_IDL - Generated from
  // be/be_visitor_interface/interface_ch.cpp:40

  class TAO_AV_Export StreamEndPoint_A
    : public virtual ::AVStreams::StreamEndPoint
  
  {
  public:
    friend class TAO::Narrow_Utils<StreamEndPoint_A>;

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    typedef StreamEndPoint_A_ptr _ptr_type;
    typedef StreamEndPoint_A_var _var_type;
    typedef StreamEndPoint_A_out _out_type;

    static void _tao_any_destructor (void *);

    // The static operations.
    static StreamEndPoint_A_ptr _duplicate (StreamEndPoint_A_ptr obj);

    static void _tao_release (StreamEndPoint_A_ptr obj);

    static StreamEndPoint_A_ptr _narrow (::CORBA::Object_ptr obj);
    static StreamEndPoint_A_ptr _unchecked_narrow (::CORBA::Object_ptr obj);
    static StreamEndPoint_A_ptr _nil (void);

    virtual ::CORBA::Boolean multiconnect (
      ::AVStreams::streamQoS & the_qos,
      ::AVStreams::flowSpec & the_spec);

    virtual ::CORBA::Boolean connect_leaf (
      ::AVStreams::StreamEndPoint_B_ptr the_ep,
      ::AVStreams::streamQoS & the_qos,
      const ::AVStreams::flowSpec & the_flows);

    virtual void disconnect_leaf (
      ::AVStreams::StreamEndPoint_B_ptr the_ep,
      const ::AVStreams::flowSpec & theSpec);

    // TAO_IDL - Generated from
    // be/be_visitor_interface/interface_ch.cpp:137

    virtual ::CORBA::Boolean _is_a (const char *type_id);
    virtual const char* _interface_repository_id (void) const;
    virtual ::CORBA::Boolean marshal (TAO_OutputCDR &cdr);
  
  protected:
    // Concrete interface only.
    StreamEndPoint_A (void);

    // Concrete non-local interface only.
    StreamEndPoint_A (
        ::IOP::IOR *ior,
        TAO_ORB_Core *orb_core);
    
    // Non-local interface only.
    StreamEndPoint_A (
        TAO_Stub *objref,
        ::CORBA::Boolean _tao_collocated = false,
        TAO_Abstract_ServantBase *servant = 0,
        TAO_ORB_Core *orb_core = 0);

    virtual ~StreamEndPoint_A (void);
  
  private:
    // Private and unimplemented for concrete interfaces.
    StreamEndPoint_A (const StreamEndPoint_A &);

    void operator= (const StreamEndPoint_A &);
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_StreamEndPoint_A;

  // TAO_IDL - Generated from
  // be/be_visitor_interface/interface_ch.cpp:40

  class TAO_AV_Export StreamEndPoint_B
    : public virtual ::AVStreams::StreamEndPoint
  
  {
  public:
    friend class TAO::Narrow_Utils<StreamEndPoint_B>;

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    typedef StreamEndPoint_B_ptr _ptr_type;
    typedef StreamEndPoint_B_var _var_type;
    typedef StreamEndPoint_B_out _out_type;

    static void _tao_any_destructor (void *);

    // The static operations.
    static StreamEndPoint_B_ptr _duplicate (StreamEndPoint_B_ptr obj);

    static void _tao_release (StreamEndPoint_B_ptr obj);

    static StreamEndPoint_B_ptr _narrow (::CORBA::Object_ptr obj);
    static StreamEndPoint_B_ptr _unchecked_narrow (::CORBA::Object_ptr obj);
    static StreamEndPoint_B_ptr _nil (void);

    virtual ::CORBA::Boolean multiconnect (
      ::AVStreams::streamQoS & the_qos,
      ::AVStreams::flowSpec & the_spec);

    // TAO_IDL - Generated from
    // be/be_visitor_interface/interface_ch.cpp:137

    virtual ::CORBA::Boolean _is_a (const char *type_id);
    virtual const char* _interface_repository_id (void) const;
    virtual ::CORBA::Boolean marshal (TAO_OutputCDR &cdr);
  
  protected:
    // Concrete interface only.
    StreamEndPoint_B (void);

    // Concrete non-local interface only.
    StreamEndPoint_B (
        ::IOP::IOR *ior,
        TAO_ORB_Core *orb_core);
    
    // Non-local interface only.
    StreamEndPoint_B (
        TAO_Stub *objref,
        ::CORBA::Boolean _tao_collocated = false,
        TAO_Abstract_ServantBase *servant = 0,
        TAO_ORB_Core *orb_core = 0);

    virtual ~StreamEndPoint_B (void);
  
  private:
    // Private and unimplemented for concrete interfaces.
    StreamEndPoint_B (const StreamEndPoint_B &);

    void operator= (const StreamEndPoint_B &);
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_StreamEndPoint_B;

  // TAO_IDL - Generated from
  // be/be_visitor_interface/interface_ch.cpp:40

  class TAO_AV_Export VDev
    : public virtual ::CosPropertyService::PropertySet
  
  {
  public:
    friend class TAO::Narrow_Utils<VDev>;

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    typedef VDev_ptr _ptr_type;
    typedef VDev_var _var_type;
    typedef VDev_out _out_type;

    static void _tao_any_destructor (void *);

    // The static operations.
    static VDev_ptr _duplicate (VDev_ptr obj);

    static void _tao_release (VDev_ptr obj);

    static VDev_ptr _narrow (::CORBA::Object_ptr obj);
    static VDev_ptr _unchecked_narrow (::CORBA::Object_ptr obj);
    static VDev_ptr _nil (void);

    virtual ::CORBA::Boolean set_peer (
      ::AVStreams::StreamCtrl_ptr the_ctrl,
      ::AVStreams::VDev_ptr the_peer_dev,
      ::AVStreams::streamQoS & the_qos,
      const ::AVStreams::flowSpec & the_spec);

    virtual ::CORBA::Boolean set_Mcast_peer (
      ::AVStreams::StreamCtrl_ptr the_ctrl,
      ::AVStreams::MCastConfigIf_ptr a_mcastconfigif,
      ::AVStreams::streamQoS & the_qos,
      const ::AVStreams::flowSpec & the_spec);

    virtual void configure (
      const ::CosPropertyService::Property & the_config_mesg);

    virtual void set_format (
      const char * flowName,
      const char * format_name);

    virtual void set_dev_params (
      const char * flowName,
      const ::CosPropertyService::Properties & new_params);

    virtual ::CORBA::Boolean modify_QoS (
      ::AVStreams::streamQoS & the_qos,
      const ::AVStreams::flowSpec & the_spec);

    // TAO_IDL - Generated from
    // be/be_visitor_interface/interface_ch.cpp:137

    virtual ::CORBA::Boolean _is_a (const char *type_id);
    virtual const char* _interface_repository_id (void) const;
    virtual ::CORBA::Boolean marshal (TAO_OutputCDR &cdr);
  
  protected:
    // Concrete interface only.
    VDev (void);

    // Concrete non-local interface only.
    VDev (
        ::IOP::IOR *ior,
        TAO_ORB_Core *orb_core);
    
    // Non-local interface only.
    VDev (
        TAO_Stub *objref,
        ::CORBA::Boolean _tao_collocated = false,
        TAO_Abstract_ServantBase *servant = 0,
        TAO_ORB_Core *orb_core = 0);

    virtual ~VDev (void);
  
  private:
    // Private and unimplemented for concrete interfaces.
    VDev (const VDev &);

    void operator= (const VDev &);
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_VDev;

  // TAO_IDL - Generated from
  // be/be_visitor_interface/interface_ch.cpp:40

  class TAO_AV_Export MMDevice
    : public virtual ::CosPropertyService::PropertySet
  
  {
  public:
    friend class TAO::Narrow_Utils<MMDevice>;

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    typedef MMDevice_ptr _ptr_type;
    typedef MMDevice_var _var_type;
    typedef MMDevice_out _out_type;

    static void _tao_any_destructor (void *);

    // The static operations.
    static MMDevice_ptr _duplicate (MMDevice_ptr obj);

    static void _tao_release (MMDevice_ptr obj);

    static MMDevice_ptr _narrow (::CORBA::Object_ptr obj);
    static MMDevice_ptr _unchecked_narrow (::CORBA::Object_ptr obj);
    static MMDevice_ptr _nil (void);

    virtual ::AVStreams::StreamEndPoint_A_ptr create_A (
      ::AVStreams::StreamCtrl_ptr the_requester,
      ::AVStreams::VDev_out the_vdev,
      ::AVStreams::streamQoS & the_qos,
      ::CORBA::Boolean_out met_qos,
      char *& named_vdev,
      const ::AVStreams::flowSpec & the_spec);

    virtual ::AVStreams::StreamEndPoint_B_ptr create_B (
      ::AVStreams::StreamCtrl_ptr the_requester,
      ::AVStreams::VDev_out the_vdev,
      ::AVStreams::streamQoS & the_qos,
      ::CORBA::Boolean_out met_qos,
      char *& named_vdev,
      const ::AVStreams::flowSpec & the_spec);

    virtual ::AVStreams::StreamCtrl_ptr bind (
      ::AVStreams::MMDevice_ptr peer_device,
      ::AVStreams::streamQoS & the_qos,
      ::CORBA::Boolean_out is_met,
      const ::AVStreams::flowSpec & the_spec);

    virtual ::AVStreams::StreamCtrl_ptr bind_mcast (
      ::AVStreams::MMDevice_ptr first_peer,
      ::AVStreams::streamQoS & the_qos,
      ::CORBA::Boolean_out is_met,
      const ::AVStreams::flowSpec & the_spec);

    virtual void destroy (
      ::AVStreams::StreamEndPoint_ptr the_ep,
      const char * vdev_name);

    virtual char * add_fdev (
      ::CORBA::Object_ptr the_fdev);

    virtual ::CORBA::Object_ptr get_fdev (
      const char * flow_name);

    virtual void remove_fdev (
      const char * flow_name);

    // TAO_IDL - Generated from
    // be/be_visitor_interface/interface_ch.cpp:137

    virtual ::CORBA::Boolean _is_a (const char *type_id);
    virtual const char* _interface_repository_id (void) const;
    virtual ::CORBA::Boolean marshal (TAO_OutputCDR &cdr);
  
  protected:
    // Concrete interface only.
    MMDevice (void);

    // Concrete non-local interface only.
    MMDevice (
        ::IOP::IOR *ior,
        TAO_ORB_Core *orb_core);
    
    // Non-local interface only.
    MMDevice (
        TAO_Stub *objref,
        ::CORBA::Boolean _tao_collocated = false,
        TAO_Abstract_ServantBase *servant = 0,
        TAO_ORB_Core *orb_core = 0);

    virtual ~MMDevice (void);
  
  private:
    // Private and unimplemented for concrete interfaces.
    MMDevice (const MMDevice &);

    void operator= (const MMDevice &);
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_MMDevice;

  // TAO_IDL - Generated from
  // be/be_visitor_exception/exception_ch.cpp:41

  class TAO_AV_Export protocolNotSupported : public ::CORBA::UserException
  {
  public:

    protocolNotSupported (void);
    protocolNotSupported (const protocolNotSupported &);
    ~protocolNotSupported (void);

    protocolNotSupported &operator= (const protocolNotSupported &);

    static void _tao_any_destructor (void *);

    static protocolNotSupported *_downcast ( ::CORBA::Exception *);
    static const protocolNotSupported *_downcast ( ::CORBA::Exception const *);

    static ::CORBA::Exception *_alloc (void);

    virtual ::CORBA::Exception *_tao_duplicate (void) const;

    virtual void _raise (void) const;

    virtual void _tao_encode (TAO_OutputCDR &cdr) const;
    virtual void _tao_decode (TAO_InputCDR &cdr);

    virtual ::CORBA::TypeCode_ptr _tao_type (void) const;
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_protocolNotSupported;

  // TAO_IDL - Generated from
  // be/be_visitor_exception/exception_ch.cpp:41

  class TAO_AV_Export formatNotSupported : public ::CORBA::UserException
  {
  public:

    formatNotSupported (void);
    formatNotSupported (const formatNotSupported &);
    ~formatNotSupported (void);

    formatNotSupported &operator= (const formatNotSupported &);

    static void _tao_any_destructor (void *);

    static formatNotSupported *_downcast ( ::CORBA::Exception *);
    static const formatNotSupported *_downcast ( ::CORBA::Exception const *);

    static ::CORBA::Exception *_alloc (void);

    virtual ::CORBA::Exception *_tao_duplicate (void) const;

    virtual void _raise (void) const;

    virtual void _tao_encode (TAO_OutputCDR &cdr) const;
    virtual void _tao_decode (TAO_InputCDR &cdr);

    virtual ::CORBA::TypeCode_ptr _tao_type (void) const;
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_formatNotSupported;

  // TAO_IDL - Generated from
  // be/be_visitor_exception/exception_ch.cpp:41

  class TAO_AV_Export formatMismatch : public ::CORBA::UserException
  {
  public:

    formatMismatch (void);
    formatMismatch (const formatMismatch &);
    ~formatMismatch (void);

    formatMismatch &operator= (const formatMismatch &);

    static void _tao_any_destructor (void *);

    static formatMismatch *_downcast ( ::CORBA::Exception *);
    static const formatMismatch *_downcast ( ::CORBA::Exception const *);

    static ::CORBA::Exception *_alloc (void);

    virtual ::CORBA::Exception *_tao_duplicate (void) const;

    virtual void _raise (void) const;

    virtual void _tao_encode (TAO_OutputCDR &cdr) const;
    virtual void _tao_decode (TAO_InputCDR &cdr);

    virtual ::CORBA::TypeCode_ptr _tao_type (void) const;
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_formatMismatch;

  // TAO_IDL - Generated from
  // be/be_visitor_exception/exception_ch.cpp:41

  class TAO_AV_Export FEPMismatch : public ::CORBA::UserException
  {
  public:

    FEPMismatch (void);
    FEPMismatch (const FEPMismatch &);
    ~FEPMismatch (void);

    FEPMismatch &operator= (const FEPMismatch &);

    static void _tao_any_destructor (void *);

    static FEPMismatch *_downcast ( ::CORBA::Exception *);
    static const FEPMismatch *_downcast ( ::CORBA::Exception const *);

    static ::CORBA::Exception *_alloc (void);

    virtual ::CORBA::Exception *_tao_duplicate (void) const;

    virtual void _raise (void) const;

    virtual void _tao_encode (TAO_OutputCDR &cdr) const;
    virtual void _tao_decode (TAO_InputCDR &cdr);

    virtual ::CORBA::TypeCode_ptr _tao_type (void) const;
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_FEPMismatch;

  // TAO_IDL - Generated from
  // be/be_visitor_exception/exception_ch.cpp:41

  class TAO_AV_Export alreadyConnected : public ::CORBA::UserException
  {
  public:

    alreadyConnected (void);
    alreadyConnected (const alreadyConnected &);
    ~alreadyConnected (void);

    alreadyConnected &operator= (const alreadyConnected &);

    static void _tao_any_destructor (void *);

    static alreadyConnected *_downcast ( ::CORBA::Exception *);
    static const alreadyConnected *_downcast ( ::CORBA::Exception const *);

    static ::CORBA::Exception *_alloc (void);

    virtual ::CORBA::Exception *_tao_duplicate (void) const;

    virtual void _raise (void) const;

    virtual void _tao_encode (TAO_OutputCDR &cdr) const;
    virtual void _tao_decode (TAO_InputCDR &cdr);

    virtual ::CORBA::TypeCode_ptr _tao_type (void) const;
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_alreadyConnected;

  // TAO_IDL - Generated from
  // be/be_visitor_exception/exception_ch.cpp:41

  class TAO_AV_Export invalidSettings : public ::CORBA::UserException
  {
  public:
    ::TAO::String_Manager settings;

    invalidSettings (void);
    invalidSettings (const invalidSettings &);
    ~invalidSettings (void);

    invalidSettings &operator= (const invalidSettings &);

    static void _tao_any_destructor (void *);

    static invalidSettings *_downcast ( ::CORBA::Exception *);
    static const invalidSettings *_downcast ( ::CORBA::Exception const *);

    static ::CORBA::Exception *_alloc (void);

    virtual ::CORBA::Exception *_tao_duplicate (void) const;

    virtual void _raise (void) const;

    virtual void _tao_encode (TAO_OutputCDR &cdr) const;
    virtual void _tao_decode (TAO_InputCDR &cdr);

    // TAO_IDL - Generated from
    // be/be_visitor_exception/exception_ctor.cpp:51

    invalidSettings (
        const char * _tao_settings);

    virtual ::CORBA::TypeCode_ptr _tao_type (void) const;
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_invalidSettings;

  // TAO_IDL - Generated from
  // be/be_visitor_exception/exception_ch.cpp:41

  class TAO_AV_Export notConnected : public ::CORBA::UserException
  {
  public:

    notConnected (void);
    notConnected (const notConnected &);
    ~notConnected (void);

    notConnected &operator= (const notConnected &);

    static void _tao_any_destructor (void *);

    static notConnected *_downcast ( ::CORBA::Exception *);
    static const notConnected *_downcast ( ::CORBA::Exception const *);

    static ::CORBA::Exception *_alloc (void);

    virtual ::CORBA::Exception *_tao_duplicate (void) const;

    virtual void _raise (void) const;

    virtual void _tao_encode (TAO_OutputCDR &cdr) const;
    virtual void _tao_decode (TAO_InputCDR &cdr);

    virtual ::CORBA::TypeCode_ptr _tao_type (void) const;
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_notConnected;

  // TAO_IDL - Generated from
  // be/be_visitor_exception/exception_ch.cpp:41

  class TAO_AV_Export deviceQosMismatch : public ::CORBA::UserException
  {
  public:

    deviceQosMismatch (void);
    deviceQosMismatch (const deviceQosMismatch &);
    ~deviceQosMismatch (void);

    deviceQosMismatch &operator= (const deviceQosMismatch &);

    static void _tao_any_destructor (void *);

    static deviceQosMismatch *_downcast ( ::CORBA::Exception *);
    static const deviceQosMismatch *_downcast ( ::CORBA::Exception const *);

    static ::CORBA::Exception *_alloc (void);

    virtual ::CORBA::Exception *_tao_duplicate (void) const;

    virtual void _raise (void) const;

    virtual void _tao_encode (TAO_OutputCDR &cdr) const;
    virtual void _tao_decode (TAO_InputCDR &cdr);

    virtual ::CORBA::TypeCode_ptr _tao_type (void) const;
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_deviceQosMismatch;

  // TAO_IDL - Generated from
  // be/be_visitor_exception/exception_ch.cpp:41

  class TAO_AV_Export failedToConnect : public ::CORBA::UserException
  {
  public:
    ::TAO::String_Manager reason;

    failedToConnect (void);
    failedToConnect (const failedToConnect &);
    ~failedToConnect (void);

    failedToConnect &operator= (const failedToConnect &);

    static void _tao_any_destructor (void *);

    static failedToConnect *_downcast ( ::CORBA::Exception *);
    static const failedToConnect *_downcast ( ::CORBA::Exception const *);

    static ::CORBA::Exception *_alloc (void);

    virtual ::CORBA::Exception *_tao_duplicate (void) const;

    virtual void _raise (void) const;

    virtual void _tao_encode (TAO_OutputCDR &cdr) const;
    virtual void _tao_decode (TAO_InputCDR &cdr);

    // TAO_IDL - Generated from
    // be/be_visitor_exception/exception_ctor.cpp:51

    failedToConnect (
        const char * _tao_reason);

    virtual ::CORBA::TypeCode_ptr _tao_type (void) const;
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_failedToConnect;

  // TAO_IDL - Generated from
  // be/be_visitor_exception/exception_ch.cpp:41

  class TAO_AV_Export failedToListen : public ::CORBA::UserException
  {
  public:
    ::TAO::String_Manager reason;

    failedToListen (void);
    failedToListen (const failedToListen &);
    ~failedToListen (void);

    failedToListen &operator= (const failedToListen &);

    static void _tao_any_destructor (void *);

    static failedToListen *_downcast ( ::CORBA::Exception *);
    static const failedToListen *_downcast ( ::CORBA::Exception const *);

    static ::CORBA::Exception *_alloc (void);

    virtual ::CORBA::Exception *_tao_duplicate (void) const;

    virtual void _raise (void) const;

    virtual void _tao_encode (TAO_OutputCDR &cdr) const;
    virtual void _tao_decode (TAO_InputCDR &cdr);

    // TAO_IDL - Generated from
    // be/be_visitor_exception/exception_ctor.cpp:51

    failedToListen (
        const char * _tao_reason);

    virtual ::CORBA::TypeCode_ptr _tao_type (void) const;
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_failedToListen;

  // TAO_IDL - Generated from
  // be/be_interface.cpp:748

#if !defined (_AVSTREAMS_FLOWPRODUCER__VAR_OUT_CH_)
#define _AVSTREAMS_FLOWPRODUCER__VAR_OUT_CH_

  class FlowProducer;
  typedef FlowProducer *FlowProducer_ptr;

  typedef
    TAO_Objref_Var_T<
        FlowProducer
      >
    FlowProducer_var;
  
  typedef
    TAO_Objref_Out_T<
        FlowProducer
      >
    FlowProducer_out;

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_interface.cpp:748

#if !defined (_AVSTREAMS_FLOWCONSUMER__VAR_OUT_CH_)
#define _AVSTREAMS_FLOWCONSUMER__VAR_OUT_CH_

  class FlowConsumer;
  typedef FlowConsumer *FlowConsumer_ptr;

  typedef
    TAO_Objref_Var_T<
        FlowConsumer
      >
    FlowConsumer_var;
  
  typedef
    TAO_Objref_Out_T<
        FlowConsumer
      >
    FlowConsumer_out;

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_interface.cpp:748

#if !defined (_AVSTREAMS_FLOWENDPOINT__VAR_OUT_CH_)
#define _AVSTREAMS_FLOWENDPOINT__VAR_OUT_CH_

  class FlowEndPoint;
  typedef FlowEndPoint *FlowEndPoint_ptr;

  typedef
    TAO_Objref_Var_T<
        FlowEndPoint
      >
    FlowEndPoint_var;
  
  typedef
    TAO_Objref_Out_T<
        FlowEndPoint
      >
    FlowEndPoint_out;

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_interface.cpp:748

#if !defined (_AVSTREAMS_FDEV__VAR_OUT_CH_)
#define _AVSTREAMS_FDEV__VAR_OUT_CH_

  class FDev;
  typedef FDev *FDev_ptr;

  typedef
    TAO_Objref_Var_T<
        FDev
      >
    FDev_var;
  
  typedef
    TAO_Objref_Out_T<
        FDev
      >
    FDev_out;

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_interface.cpp:748

#if !defined (_AVSTREAMS_FLOWCONNECTION__VAR_OUT_CH_)
#define _AVSTREAMS_FLOWCONNECTION__VAR_OUT_CH_

  class FlowConnection;
  typedef FlowConnection *FlowConnection_ptr;

  typedef
    TAO_Objref_Var_T<
        FlowConnection
      >
    FlowConnection_var;
  
  typedef
    TAO_Objref_Out_T<
        FlowConnection
      >
    FlowConnection_out;

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_interface/interface_ch.cpp:40

  class TAO_AV_Export FlowConnection
    : public virtual ::CosPropertyService::PropertySet
  
  {
  public:
    friend class TAO::Narrow_Utils<FlowConnection>;

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    typedef FlowConnection_ptr _ptr_type;
    typedef FlowConnection_var _var_type;
    typedef FlowConnection_out _out_type;

    static void _tao_any_destructor (void *);

    // The static operations.
    static FlowConnection_ptr _duplicate (FlowConnection_ptr obj);

    static void _tao_release (FlowConnection_ptr obj);

    static FlowConnection_ptr _narrow (::CORBA::Object_ptr obj);
    static FlowConnection_ptr _unchecked_narrow (::CORBA::Object_ptr obj);
    static FlowConnection_ptr _nil (void);

    virtual void stop (
      void);

    virtual void start (
      void);

    virtual void destroy (
      void);

    virtual ::CORBA::Boolean modify_QoS (
      ::AVStreams::QoS & new_qos);

    virtual ::CORBA::Boolean use_flow_protocol (
      const char * fp_name,
      const ::CORBA::Any & fp_settings);

    virtual void push_event (
      const ::AVStreams::streamEvent & the_event);

    virtual ::CORBA::Boolean connect_devs (
      ::AVStreams::FDev_ptr a_party,
      ::AVStreams::FDev_ptr b_party,
      ::AVStreams::QoS & the_qos);

    virtual ::CORBA::Boolean connect (
      ::AVStreams::FlowProducer_ptr flow_producer,
      ::AVStreams::FlowConsumer_ptr flow_consumer,
      ::AVStreams::QoS & the_qos);

    virtual ::CORBA::Boolean disconnect (
      void);

    virtual ::CORBA::Boolean add_producer (
      ::AVStreams::FlowProducer_ptr flow_producer,
      ::AVStreams::QoS & the_qos);

    virtual ::CORBA::Boolean add_consumer (
      ::AVStreams::FlowConsumer_ptr flow_consumer,
      ::AVStreams::QoS & the_qos);

    virtual ::CORBA::Boolean drop (
      ::AVStreams::FlowEndPoint_ptr target);

    // TAO_IDL - Generated from
    // be/be_visitor_interface/interface_ch.cpp:137

    virtual ::CORBA::Boolean _is_a (const char *type_id);
    virtual const char* _interface_repository_id (void) const;
    virtual ::CORBA::Boolean marshal (TAO_OutputCDR &cdr);
  
  protected:
    // Concrete interface only.
    FlowConnection (void);

    // Concrete non-local interface only.
    FlowConnection (
        ::IOP::IOR *ior,
        TAO_ORB_Core *orb_core);
    
    // Non-local interface only.
    FlowConnection (
        TAO_Stub *objref,
        ::CORBA::Boolean _tao_collocated = false,
        TAO_Abstract_ServantBase *servant = 0,
        TAO_ORB_Core *orb_core = 0);

    virtual ~FlowConnection (void);
  
  private:
    // Private and unimplemented for concrete interfaces.
    FlowConnection (const FlowConnection &);

    void operator= (const FlowConnection &);
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_FlowConnection;

  // TAO_IDL - Generated from
  // be/be_visitor_interface/interface_ch.cpp:40

  class TAO_AV_Export FlowEndPoint
    : public virtual ::CosPropertyService::PropertySet
  
  {
  public:
    friend class TAO::Narrow_Utils<FlowEndPoint>;

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    typedef FlowEndPoint_ptr _ptr_type;
    typedef FlowEndPoint_var _var_type;
    typedef FlowEndPoint_out _out_type;

    static void _tao_any_destructor (void *);

    // The static operations.
    static FlowEndPoint_ptr _duplicate (FlowEndPoint_ptr obj);

    static void _tao_release (FlowEndPoint_ptr obj);

    static FlowEndPoint_ptr _narrow (::CORBA::Object_ptr obj);
    static FlowEndPoint_ptr _unchecked_narrow (::CORBA::Object_ptr obj);
    static FlowEndPoint_ptr _nil (void);

    virtual ::CORBA::Boolean lock (
      void);

    virtual void unlock (
      void);

    virtual void stop (
      void);

    virtual void start (
      void);

    virtual void destroy (
      void);

    virtual ::AVStreams::StreamEndPoint_ptr related_sep (
      void);

    virtual void related_sep (
      ::AVStreams::StreamEndPoint_ptr related_sep);

    virtual ::AVStreams::FlowConnection_ptr related_flow_connection (
      void);

    virtual void related_flow_connection (
      ::AVStreams::FlowConnection_ptr related_flow_connection);

    virtual ::AVStreams::FlowEndPoint_ptr get_connected_fep (
      void);

    virtual ::CORBA::Boolean use_flow_protocol (
      const char * fp_name,
      const ::CORBA::Any & fp_settings);

    virtual void set_format (
      const char * format);

    virtual void set_dev_params (
      const ::CosPropertyService::Properties & new_settings);

    virtual void set_protocol_restriction (
      const ::AVStreams::protocolSpec & the_spec);

    virtual ::CORBA::Boolean is_fep_compatible (
      ::AVStreams::FlowEndPoint_ptr fep);

    virtual ::CORBA::Boolean set_peer (
      ::AVStreams::FlowConnection_ptr the_fc,
      ::AVStreams::FlowEndPoint_ptr the_peer_fep,
      ::AVStreams::QoS & the_qos);

    virtual ::CORBA::Boolean set_Mcast_peer (
      ::AVStreams::FlowConnection_ptr the_fc,
      ::AVStreams::MCastConfigIf_ptr a_mcastconfigif,
      ::AVStreams::QoS & the_qos);

    virtual ::CORBA::Boolean connect_to_peer (
      ::AVStreams::QoS & the_qos,
      const char * address,
      const char * use_flow_protocol);

    virtual char * go_to_listen (
      ::AVStreams::QoS & the_qos,
      ::CORBA::Boolean is_mcast,
      ::AVStreams::FlowEndPoint_ptr peer,
      char *& flowProtocol);

    // TAO_IDL - Generated from
    // be/be_visitor_interface/interface_ch.cpp:137

    virtual ::CORBA::Boolean _is_a (const char *type_id);
    virtual const char* _interface_repository_id (void) const;
    virtual ::CORBA::Boolean marshal (TAO_OutputCDR &cdr);
  
  protected:
    // Concrete interface only.
    FlowEndPoint (void);

    // Concrete non-local interface only.
    FlowEndPoint (
        ::IOP::IOR *ior,
        TAO_ORB_Core *orb_core);
    
    // Non-local interface only.
    FlowEndPoint (
        TAO_Stub *objref,
        ::CORBA::Boolean _tao_collocated = false,
        TAO_Abstract_ServantBase *servant = 0,
        TAO_ORB_Core *orb_core = 0);

    virtual ~FlowEndPoint (void);
  
  private:
    // Private and unimplemented for concrete interfaces.
    FlowEndPoint (const FlowEndPoint &);

    void operator= (const FlowEndPoint &);
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_FlowEndPoint;

  // TAO_IDL - Generated from
  // be/be_visitor_interface/interface_ch.cpp:40

  class TAO_AV_Export FlowProducer
    : public virtual ::AVStreams::FlowEndPoint
  
  {
  public:
    friend class TAO::Narrow_Utils<FlowProducer>;

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    typedef FlowProducer_ptr _ptr_type;
    typedef FlowProducer_var _var_type;
    typedef FlowProducer_out _out_type;

    static void _tao_any_destructor (void *);

    // The static operations.
    static FlowProducer_ptr _duplicate (FlowProducer_ptr obj);

    static void _tao_release (FlowProducer_ptr obj);

    static FlowProducer_ptr _narrow (::CORBA::Object_ptr obj);
    static FlowProducer_ptr _unchecked_narrow (::CORBA::Object_ptr obj);
    static FlowProducer_ptr _nil (void);

    virtual char * connect_mcast (
      ::AVStreams::QoS & the_qos,
      ::CORBA::Boolean_out is_met,
      const char * address,
      const char * use_flow_protocol);

    virtual char * get_rev_channel (
      const char * pcol_name);

    virtual void set_key (
      const ::AVStreams::key & the_key);

    virtual void set_source_id (
      ::CORBA::Long source_id);

    // TAO_IDL - Generated from
    // be/be_visitor_interface/interface_ch.cpp:137

    virtual ::CORBA::Boolean _is_a (const char *type_id);
    virtual const char* _interface_repository_id (void) const;
    virtual ::CORBA::Boolean marshal (TAO_OutputCDR &cdr);
  
  protected:
    // Concrete interface only.
    FlowProducer (void);

    // Concrete non-local interface only.
    FlowProducer (
        ::IOP::IOR *ior,
        TAO_ORB_Core *orb_core);
    
    // Non-local interface only.
    FlowProducer (
        TAO_Stub *objref,
        ::CORBA::Boolean _tao_collocated = false,
        TAO_Abstract_ServantBase *servant = 0,
        TAO_ORB_Core *orb_core = 0);

    virtual ~FlowProducer (void);
  
  private:
    // Private and unimplemented for concrete interfaces.
    FlowProducer (const FlowProducer &);

    void operator= (const FlowProducer &);
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_FlowProducer;

  // TAO_IDL - Generated from
  // be/be_visitor_interface/interface_ch.cpp:40

  class TAO_AV_Export FlowConsumer
    : public virtual ::AVStreams::FlowEndPoint
  
  {
  public:
    friend class TAO::Narrow_Utils<FlowConsumer>;

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    typedef FlowConsumer_ptr _ptr_type;
    typedef FlowConsumer_var _var_type;
    typedef FlowConsumer_out _out_type;

    static void _tao_any_destructor (void *);

    // The static operations.
    static FlowConsumer_ptr _duplicate (FlowConsumer_ptr obj);

    static void _tao_release (FlowConsumer_ptr obj);

    static FlowConsumer_ptr _narrow (::CORBA::Object_ptr obj);
    static FlowConsumer_ptr _unchecked_narrow (::CORBA::Object_ptr obj);
    static FlowConsumer_ptr _nil (void);

    // TAO_IDL - Generated from
    // be/be_visitor_interface/interface_ch.cpp:137

    virtual ::CORBA::Boolean _is_a (const char *type_id);
    virtual const char* _interface_repository_id (void) const;
    virtual ::CORBA::Boolean marshal (TAO_OutputCDR &cdr);
  
  protected:
    // Concrete interface only.
    FlowConsumer (void);

    // Concrete non-local interface only.
    FlowConsumer (
        ::IOP::IOR *ior,
        TAO_ORB_Core *orb_core);
    
    // Non-local interface only.
    FlowConsumer (
        TAO_Stub *objref,
        ::CORBA::Boolean _tao_collocated = false,
        TAO_Abstract_ServantBase *servant = 0,
        TAO_ORB_Core *orb_core = 0);

    virtual ~FlowConsumer (void);
  
  private:
    // Private and unimplemented for concrete interfaces.
    FlowConsumer (const FlowConsumer &);

    void operator= (const FlowConsumer &);
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_FlowConsumer;

  // TAO_IDL - Generated from
  // be/be_visitor_interface/interface_ch.cpp:40

  class TAO_AV_Export FDev
    : public virtual ::CosPropertyService::PropertySet
  
  {
  public:
    friend class TAO::Narrow_Utils<FDev>;

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    typedef FDev_ptr _ptr_type;
    typedef FDev_var _var_type;
    typedef FDev_out _out_type;

    static void _tao_any_destructor (void *);

    // The static operations.
    static FDev_ptr _duplicate (FDev_ptr obj);

    static void _tao_release (FDev_ptr obj);

    static FDev_ptr _narrow (::CORBA::Object_ptr obj);
    static FDev_ptr _unchecked_narrow (::CORBA::Object_ptr obj);
    static FDev_ptr _nil (void);

    virtual ::AVStreams::FlowProducer_ptr create_producer (
      ::AVStreams::FlowConnection_ptr the_requester,
      ::AVStreams::QoS & the_qos,
      ::CORBA::Boolean_out met_qos,
      char *& named_fdev);

    virtual ::AVStreams::FlowConsumer_ptr create_consumer (
      ::AVStreams::FlowConnection_ptr the_requester,
      ::AVStreams::QoS & the_qos,
      ::CORBA::Boolean_out met_qos,
      char *& named_fdev);

    virtual ::AVStreams::FlowConnection_ptr bind (
      ::AVStreams::FDev_ptr peer_device,
      ::AVStreams::QoS & the_qos,
      ::CORBA::Boolean_out is_met);

    virtual ::AVStreams::FlowConnection_ptr bind_mcast (
      ::AVStreams::FDev_ptr first_peer,
      ::AVStreams::QoS & the_qos,
      ::CORBA::Boolean_out is_met);

    virtual void destroy (
      ::AVStreams::FlowEndPoint_ptr the_ep,
      const char * fdev_name);

    // TAO_IDL - Generated from
    // be/be_visitor_interface/interface_ch.cpp:137

    virtual ::CORBA::Boolean _is_a (const char *type_id);
    virtual const char* _interface_repository_id (void) const;
    virtual ::CORBA::Boolean marshal (TAO_OutputCDR &cdr);
  
  protected:
    // Concrete interface only.
    FDev (void);

    // Concrete non-local interface only.
    FDev (
        ::IOP::IOR *ior,
        TAO_ORB_Core *orb_core);
    
    // Non-local interface only.
    FDev (
        TAO_Stub *objref,
        ::CORBA::Boolean _tao_collocated = false,
        TAO_Abstract_ServantBase *servant = 0,
        TAO_ORB_Core *orb_core = 0);

    virtual ~FDev (void);
  
  private:
    // Private and unimplemented for concrete interfaces.
    FDev (const FDev &);

    void operator= (const FDev &);
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_FDev;

  // TAO_IDL - Generated from
  // be/be_visitor_enum/enum_ch.cpp:44

  enum PositionOrigin
  {
    AbsolutePosition,
    RelativePosition,
    ModuloPosition
  };

  typedef PositionOrigin &PositionOrigin_out;

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_PositionOrigin;

  // TAO_IDL - Generated from
  // be/be_visitor_enum/enum_ch.cpp:44

  enum PositionKey
  {
    ByteCount,
    SampleCount,
    MediaTime
  };

  typedef PositionKey &PositionKey_out;

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_PositionKey;

  // TAO_IDL - Generated from
  // be/be_type.cpp:258

  struct Position;

  typedef
    ::TAO_Fixed_Var_T<
        Position
      >
    Position_var;

  typedef
    Position &
    Position_out;

  // TAO_IDL - Generated from
  // be/be_visitor_structure/structure_ch.cpp:48

  struct TAO_AV_Export Position
  {

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    
    typedef Position_var _var_type;
    typedef Position_out _out_type;

    static void _tao_any_destructor (void *);
    
    AVStreams::PositionOrigin origin;
    AVStreams::PositionKey key;
    ::CORBA::Long value;
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_Position;

  // TAO_IDL - Generated from
  // be/be_visitor_exception/exception_ch.cpp:41

  class TAO_AV_Export PostionKeyNotSupported : public ::CORBA::UserException
  {
  public:
    AVStreams::PositionKey key;

    PostionKeyNotSupported (void);
    PostionKeyNotSupported (const PostionKeyNotSupported &);
    ~PostionKeyNotSupported (void);

    PostionKeyNotSupported &operator= (const PostionKeyNotSupported &);

    static void _tao_any_destructor (void *);

    static PostionKeyNotSupported *_downcast ( ::CORBA::Exception *);
    static const PostionKeyNotSupported *_downcast ( ::CORBA::Exception const *);

    static ::CORBA::Exception *_alloc (void);

    virtual ::CORBA::Exception *_tao_duplicate (void) const;

    virtual void _raise (void) const;

    virtual void _tao_encode (TAO_OutputCDR &cdr) const;
    virtual void _tao_decode (TAO_InputCDR &cdr);

    // TAO_IDL - Generated from
    // be/be_visitor_exception/exception_ctor.cpp:51

    PostionKeyNotSupported (
        AVStreams::PositionKey _tao_key);

    virtual ::CORBA::TypeCode_ptr _tao_type (void) const;
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_PostionKeyNotSupported;

  // TAO_IDL - Generated from
  // be/be_visitor_exception/exception_ch.cpp:41

  class TAO_AV_Export InvalidPosition : public ::CORBA::UserException
  {
  public:
    AVStreams::PositionKey key;

    InvalidPosition (void);
    InvalidPosition (const InvalidPosition &);
    ~InvalidPosition (void);

    InvalidPosition &operator= (const InvalidPosition &);

    static void _tao_any_destructor (void *);

    static InvalidPosition *_downcast ( ::CORBA::Exception *);
    static const InvalidPosition *_downcast ( ::CORBA::Exception const *);

    static ::CORBA::Exception *_alloc (void);

    virtual ::CORBA::Exception *_tao_duplicate (void) const;

    virtual void _raise (void) const;

    virtual void _tao_encode (TAO_OutputCDR &cdr) const;
    virtual void _tao_decode (TAO_InputCDR &cdr);

    // TAO_IDL - Generated from
    // be/be_visitor_exception/exception_ctor.cpp:51

    InvalidPosition (
        AVStreams::PositionKey _tao_key);

    virtual ::CORBA::TypeCode_ptr _tao_type (void) const;
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_InvalidPosition;

  // TAO_IDL - Generated from
  // be/be_interface.cpp:748

#if !defined (_AVSTREAMS_MEDIACONTROL__VAR_OUT_CH_)
#define _AVSTREAMS_MEDIACONTROL__VAR_OUT_CH_

  class MediaControl;
  typedef MediaControl *MediaControl_ptr;

  typedef
    TAO_Objref_Var_T<
        MediaControl
      >
    MediaControl_var;
  
  typedef
    TAO_Objref_Out_T<
        MediaControl
      >
    MediaControl_out;

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_interface/interface_ch.cpp:40

  class TAO_AV_Export MediaControl
    : public virtual ::CORBA::Object
  {
  public:
    friend class TAO::Narrow_Utils<MediaControl>;

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    typedef MediaControl_ptr _ptr_type;
    typedef MediaControl_var _var_type;
    typedef MediaControl_out _out_type;

    static void _tao_any_destructor (void *);

    // The static operations.
    static MediaControl_ptr _duplicate (MediaControl_ptr obj);

    static void _tao_release (MediaControl_ptr obj);

    static MediaControl_ptr _narrow (::CORBA::Object_ptr obj);
    static MediaControl_ptr _unchecked_narrow (::CORBA::Object_ptr obj);
    static MediaControl_ptr _nil (void);

    // TAO_IDL - Generated from
    // be/be_visitor_exception/exception_ch.cpp:41

    class TAO_AV_Export PostionKeyNotSupported : public ::CORBA::UserException
    {
    public:
      AVStreams::PositionKey key;

      PostionKeyNotSupported (void);
      PostionKeyNotSupported (const PostionKeyNotSupported &);
      ~PostionKeyNotSupported (void);

      PostionKeyNotSupported &operator= (const PostionKeyNotSupported &);

      static void _tao_any_destructor (void *);

      static PostionKeyNotSupported *_downcast ( ::CORBA::Exception *);
      static const PostionKeyNotSupported *_downcast ( ::CORBA::Exception const *);

      static ::CORBA::Exception *_alloc (void);

      virtual ::CORBA::Exception *_tao_duplicate (void) const;

      virtual void _raise (void) const;

      virtual void _tao_encode (TAO_OutputCDR &cdr) const;
      virtual void _tao_decode (TAO_InputCDR &cdr);

      // TAO_IDL - Generated from
      // be/be_visitor_exception/exception_ctor.cpp:51

      PostionKeyNotSupported (
          AVStreams::PositionKey _tao_key);

      virtual ::CORBA::TypeCode_ptr _tao_type (void) const;
    };

    // TAO_IDL - Generated from
    // be/be_visitor_typecode/typecode_decl.cpp:34

    static ::CORBA::TypeCode_ptr const _tc_PostionKeyNotSupported;

    virtual ::AVStreams::Position get_media_position (
      ::AVStreams::PositionOrigin an_origin,
      ::AVStreams::PositionKey a_key);

    virtual void set_media_position (
      const ::AVStreams::Position & a_position);

    virtual void start (
      const ::AVStreams::Position & a_position);

    virtual void pause (
      const ::AVStreams::Position & a_position);

    virtual void resume (
      const ::AVStreams::Position & a_position);

    virtual void stop (
      const ::AVStreams::Position & a_position);

    // TAO_IDL - Generated from
    // be/be_visitor_interface/interface_ch.cpp:137

    virtual ::CORBA::Boolean _is_a (const char *type_id);
    virtual const char* _interface_repository_id (void) const;
    virtual ::CORBA::Boolean marshal (TAO_OutputCDR &cdr);
  
  protected:
    // Concrete interface only.
    MediaControl (void);

    // Concrete non-local interface only.
    MediaControl (
        ::IOP::IOR *ior,
        TAO_ORB_Core *orb_core);
    
    // Non-local interface only.
    MediaControl (
        TAO_Stub *objref,
        ::CORBA::Boolean _tao_collocated = false,
        TAO_Abstract_ServantBase *servant = 0,
        TAO_ORB_Core *orb_core = 0);

    virtual ~MediaControl (void);
  
  private:
    // Private and unimplemented for concrete interfaces.
    MediaControl (const MediaControl &);

    void operator= (const MediaControl &);
  };

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_MediaControl;

  // TAO_IDL - Generated from
  // be/be_visitor_sequence/sequence_ch.cpp:99

#if !defined (_AVSTREAMS_FLOWCONNECTION_SEQ_CH_)
#define _AVSTREAMS_FLOWCONNECTION_SEQ_CH_

  class FlowConnection_seq;

  typedef
    ::TAO_VarSeq_Var_T<
        FlowConnection_seq
      >
    FlowConnection_seq_var;

  typedef
    ::TAO_Seq_Out_T<
        FlowConnection_seq
      >
    FlowConnection_seq_out;

  class TAO_AV_Export FlowConnection_seq
    : public
        ::TAO::unbounded_object_reference_sequence<
            FlowConnection,
            FlowConnection_var
          >
  {
  public:
    FlowConnection_seq (void);
    FlowConnection_seq ( ::CORBA::ULong max);
    FlowConnection_seq (
      ::CORBA::ULong max,
      ::CORBA::ULong length,
      FlowConnection_ptr* buffer,
      ::CORBA::Boolean release = false);
    FlowConnection_seq (const FlowConnection_seq &);
    virtual ~FlowConnection_seq (void);
    

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    
    typedef FlowConnection_seq_var _var_type;
    typedef FlowConnection_seq_out _out_type;

    static void _tao_any_destructor (void *);
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_FlowConnection_seq;

  // TAO_IDL - Generated from
  // be/be_visitor_sequence/sequence_ch.cpp:99

#if !defined (_AVSTREAMS_STREAMENDPOINT_A_SEQ_CH_)
#define _AVSTREAMS_STREAMENDPOINT_A_SEQ_CH_

  class StreamEndPoint_A_seq;

  typedef
    ::TAO_VarSeq_Var_T<
        StreamEndPoint_A_seq
      >
    StreamEndPoint_A_seq_var;

  typedef
    ::TAO_Seq_Out_T<
        StreamEndPoint_A_seq
      >
    StreamEndPoint_A_seq_out;

  class TAO_AV_Export StreamEndPoint_A_seq
    : public
        ::TAO::unbounded_object_reference_sequence<
            StreamEndPoint_A,
            StreamEndPoint_A_var
          >
  {
  public:
    StreamEndPoint_A_seq (void);
    StreamEndPoint_A_seq ( ::CORBA::ULong max);
    StreamEndPoint_A_seq (
      ::CORBA::ULong max,
      ::CORBA::ULong length,
      StreamEndPoint_A_ptr* buffer,
      ::CORBA::Boolean release = false);
    StreamEndPoint_A_seq (const StreamEndPoint_A_seq &);
    virtual ~StreamEndPoint_A_seq (void);
    

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    
    typedef StreamEndPoint_A_seq_var _var_type;
    typedef StreamEndPoint_A_seq_out _out_type;

    static void _tao_any_destructor (void *);
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_StreamEndPoint_A_seq;

  // TAO_IDL - Generated from
  // be/be_visitor_sequence/sequence_ch.cpp:99

#if !defined (_AVSTREAMS_STREAMENDPOINT_B_SEQ_CH_)
#define _AVSTREAMS_STREAMENDPOINT_B_SEQ_CH_

  class StreamEndPoint_B_seq;

  typedef
    ::TAO_VarSeq_Var_T<
        StreamEndPoint_B_seq
      >
    StreamEndPoint_B_seq_var;

  typedef
    ::TAO_Seq_Out_T<
        StreamEndPoint_B_seq
      >
    StreamEndPoint_B_seq_out;

  class TAO_AV_Export StreamEndPoint_B_seq
    : public
        ::TAO::unbounded_object_reference_sequence<
            StreamEndPoint_B,
            StreamEndPoint_B_var
          >
  {
  public:
    StreamEndPoint_B_seq (void);
    StreamEndPoint_B_seq ( ::CORBA::ULong max);
    StreamEndPoint_B_seq (
      ::CORBA::ULong max,
      ::CORBA::ULong length,
      StreamEndPoint_B_ptr* buffer,
      ::CORBA::Boolean release = false);
    StreamEndPoint_B_seq (const StreamEndPoint_B_seq &);
    virtual ~StreamEndPoint_B_seq (void);
    

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    
    typedef StreamEndPoint_B_seq_var _var_type;
    typedef StreamEndPoint_B_seq_out _out_type;

    static void _tao_any_destructor (void *);
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_StreamEndPoint_B_seq;

  // TAO_IDL - Generated from
  // be/be_visitor_sequence/sequence_ch.cpp:99

#if !defined (_AVSTREAMS_FLOWENDPOINT_SEQ_CH_)
#define _AVSTREAMS_FLOWENDPOINT_SEQ_CH_

  class FlowEndPoint_seq;

  typedef
    ::TAO_VarSeq_Var_T<
        FlowEndPoint_seq
      >
    FlowEndPoint_seq_var;

  typedef
    ::TAO_Seq_Out_T<
        FlowEndPoint_seq
      >
    FlowEndPoint_seq_out;

  class TAO_AV_Export FlowEndPoint_seq
    : public
        ::TAO::unbounded_object_reference_sequence<
            FlowEndPoint,
            FlowEndPoint_var
          >
  {
  public:
    FlowEndPoint_seq (void);
    FlowEndPoint_seq ( ::CORBA::ULong max);
    FlowEndPoint_seq (
      ::CORBA::ULong max,
      ::CORBA::ULong length,
      FlowEndPoint_ptr* buffer,
      ::CORBA::Boolean release = false);
    FlowEndPoint_seq (const FlowEndPoint_seq &);
    virtual ~FlowEndPoint_seq (void);
    

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    
    typedef FlowEndPoint_seq_var _var_type;
    typedef FlowEndPoint_seq_out _out_type;

    static void _tao_any_destructor (void *);
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_FlowEndPoint_seq;

  // TAO_IDL - Generated from
  // be/be_visitor_sequence/sequence_ch.cpp:99

#if !defined (_AVSTREAMS_OBJECT_SEQ_CH_)
#define _AVSTREAMS_OBJECT_SEQ_CH_

  class Object_seq;

  typedef
    ::TAO_VarSeq_Var_T<
        Object_seq
      >
    Object_seq_var;

  typedef
    ::TAO_Seq_Out_T<
        Object_seq
      >
    Object_seq_out;

  class TAO_AV_Export Object_seq
    : public
        ::TAO::unbounded_object_reference_sequence<
            ::CORBA::Object,
            ::CORBA::Object_var
          >
  {
  public:
    Object_seq (void);
    Object_seq ( ::CORBA::ULong max);
    Object_seq (
      ::CORBA::ULong max,
      ::CORBA::ULong length,
      ::CORBA::Object_ptr* buffer,
      ::CORBA::Boolean release = false);
    Object_seq (const Object_seq &);
    virtual ~Object_seq (void);
    

    // TAO_IDL - Generated from
    // be/be_type.cpp:304

    
    typedef Object_seq_var _var_type;
    typedef Object_seq_out _out_type;

    static void _tao_any_destructor (void *);
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_typecode/typecode_decl.cpp:34

  extern TAO_AV_Export ::CORBA::TypeCode_ptr const _tc_Object_seq;

// TAO_IDL - Generated from
// be/be_visitor_module/module_ch.cpp:64

} // module AVStreams

// TAO_IDL - Generated from
// be/be_visitor_arg_traits.cpp:66


TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL


// Arg traits specializations.
namespace TAO
{

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:945

  template<>
  class Arg_Traits< ::AVStreams::QoS>
    : public
        Var_Size_Arg_Traits_T<
            ::AVStreams::QoS,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:683

  template<>
  class Arg_Traits< ::AVStreams::streamQoS>
    : public
        Var_Size_Arg_Traits_T<
            ::AVStreams::streamQoS,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:683

  template<>
  class Arg_Traits< ::AVStreams::flowSpec>
    : public
        Var_Size_Arg_Traits_T<
            ::AVStreams::flowSpec,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:683

  template<>
  class Arg_Traits< ::AVStreams::protocolSpec>
    : public
        Var_Size_Arg_Traits_T<
            ::AVStreams::protocolSpec,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:683

  template<>
  class Arg_Traits< ::AVStreams::key>
    : public
        Var_Size_Arg_Traits_T<
            ::AVStreams::key,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:945

  template<>
  class Arg_Traits< ::AVStreams::SFPStatus>
    : public
        Fixed_Size_Arg_Traits_T<
            ::AVStreams::SFPStatus,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:902

  template<>
  class Arg_Traits< ::AVStreams::flowState>
    : public
        Basic_Arg_Traits_T<
            ::AVStreams::flowState,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:902

  template<>
  class Arg_Traits< ::AVStreams::dirType>
    : public
        Basic_Arg_Traits_T<
            ::AVStreams::dirType,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:945

  template<>
  class Arg_Traits< ::AVStreams::flowStatus>
    : public
        Var_Size_Arg_Traits_T<
            ::AVStreams::flowStatus,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:145

#if !defined (_AVSTREAMS_BASIC_STREAMCTRL__ARG_TRAITS_)
#define _AVSTREAMS_BASIC_STREAMCTRL__ARG_TRAITS_

  template<>
  class  Arg_Traits< ::AVStreams::Basic_StreamCtrl>
    : public
        Object_Arg_Traits_T<
            ::AVStreams::Basic_StreamCtrl_ptr,
            ::AVStreams::Basic_StreamCtrl_var,
            ::AVStreams::Basic_StreamCtrl_out,
            TAO::Objref_Traits<AVStreams::Basic_StreamCtrl>,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:145

#if !defined (_AVSTREAMS_NEGOTIATOR__ARG_TRAITS_)
#define _AVSTREAMS_NEGOTIATOR__ARG_TRAITS_

  template<>
  class  Arg_Traits< ::AVStreams::Negotiator>
    : public
        Object_Arg_Traits_T<
            ::AVStreams::Negotiator_ptr,
            ::AVStreams::Negotiator_var,
            ::AVStreams::Negotiator_out,
            TAO::Objref_Traits<AVStreams::Negotiator>,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:145

#if !defined (_AVSTREAMS_VDEV__ARG_TRAITS_)
#define _AVSTREAMS_VDEV__ARG_TRAITS_

  template<>
  class  Arg_Traits< ::AVStreams::VDev>
    : public
        Object_Arg_Traits_T<
            ::AVStreams::VDev_ptr,
            ::AVStreams::VDev_var,
            ::AVStreams::VDev_out,
            TAO::Objref_Traits<AVStreams::VDev>,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:145

#if !defined (_AVSTREAMS_MMDEVICE__ARG_TRAITS_)
#define _AVSTREAMS_MMDEVICE__ARG_TRAITS_

  template<>
  class  Arg_Traits< ::AVStreams::MMDevice>
    : public
        Object_Arg_Traits_T<
            ::AVStreams::MMDevice_ptr,
            ::AVStreams::MMDevice_var,
            ::AVStreams::MMDevice_out,
            TAO::Objref_Traits<AVStreams::MMDevice>,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:145

#if !defined (_AVSTREAMS_STREAMENDPOINT__ARG_TRAITS_)
#define _AVSTREAMS_STREAMENDPOINT__ARG_TRAITS_

  template<>
  class  Arg_Traits< ::AVStreams::StreamEndPoint>
    : public
        Object_Arg_Traits_T<
            ::AVStreams::StreamEndPoint_ptr,
            ::AVStreams::StreamEndPoint_var,
            ::AVStreams::StreamEndPoint_out,
            TAO::Objref_Traits<AVStreams::StreamEndPoint>,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:145

#if !defined (_AVSTREAMS_STREAMENDPOINT_A__ARG_TRAITS_)
#define _AVSTREAMS_STREAMENDPOINT_A__ARG_TRAITS_

  template<>
  class  Arg_Traits< ::AVStreams::StreamEndPoint_A>
    : public
        Object_Arg_Traits_T<
            ::AVStreams::StreamEndPoint_A_ptr,
            ::AVStreams::StreamEndPoint_A_var,
            ::AVStreams::StreamEndPoint_A_out,
            TAO::Objref_Traits<AVStreams::StreamEndPoint_A>,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:145

#if !defined (_AVSTREAMS_STREAMENDPOINT_B__ARG_TRAITS_)
#define _AVSTREAMS_STREAMENDPOINT_B__ARG_TRAITS_

  template<>
  class  Arg_Traits< ::AVStreams::StreamEndPoint_B>
    : public
        Object_Arg_Traits_T<
            ::AVStreams::StreamEndPoint_B_ptr,
            ::AVStreams::StreamEndPoint_B_var,
            ::AVStreams::StreamEndPoint_B_out,
            TAO::Objref_Traits<AVStreams::StreamEndPoint_B>,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:145

#if !defined (_AVSTREAMS_STREAMCTRL__ARG_TRAITS_)
#define _AVSTREAMS_STREAMCTRL__ARG_TRAITS_

  template<>
  class  Arg_Traits< ::AVStreams::StreamCtrl>
    : public
        Object_Arg_Traits_T<
            ::AVStreams::StreamCtrl_ptr,
            ::AVStreams::StreamCtrl_var,
            ::AVStreams::StreamCtrl_out,
            TAO::Objref_Traits<AVStreams::StreamCtrl>,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:145

#if !defined (_AVSTREAMS_MCASTCONFIGIF__ARG_TRAITS_)
#define _AVSTREAMS_MCASTCONFIGIF__ARG_TRAITS_

  template<>
  class  Arg_Traits< ::AVStreams::MCastConfigIf>
    : public
        Object_Arg_Traits_T<
            ::AVStreams::MCastConfigIf_ptr,
            ::AVStreams::MCastConfigIf_var,
            ::AVStreams::MCastConfigIf_out,
            TAO::Objref_Traits<AVStreams::MCastConfigIf>,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:145

#if !defined (_AVSTREAMS_FLOWPRODUCER__ARG_TRAITS_)
#define _AVSTREAMS_FLOWPRODUCER__ARG_TRAITS_

  template<>
  class  Arg_Traits< ::AVStreams::FlowProducer>
    : public
        Object_Arg_Traits_T<
            ::AVStreams::FlowProducer_ptr,
            ::AVStreams::FlowProducer_var,
            ::AVStreams::FlowProducer_out,
            TAO::Objref_Traits<AVStreams::FlowProducer>,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:145

#if !defined (_AVSTREAMS_FLOWCONSUMER__ARG_TRAITS_)
#define _AVSTREAMS_FLOWCONSUMER__ARG_TRAITS_

  template<>
  class  Arg_Traits< ::AVStreams::FlowConsumer>
    : public
        Object_Arg_Traits_T<
            ::AVStreams::FlowConsumer_ptr,
            ::AVStreams::FlowConsumer_var,
            ::AVStreams::FlowConsumer_out,
            TAO::Objref_Traits<AVStreams::FlowConsumer>,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:145

#if !defined (_AVSTREAMS_FLOWENDPOINT__ARG_TRAITS_)
#define _AVSTREAMS_FLOWENDPOINT__ARG_TRAITS_

  template<>
  class  Arg_Traits< ::AVStreams::FlowEndPoint>
    : public
        Object_Arg_Traits_T<
            ::AVStreams::FlowEndPoint_ptr,
            ::AVStreams::FlowEndPoint_var,
            ::AVStreams::FlowEndPoint_out,
            TAO::Objref_Traits<AVStreams::FlowEndPoint>,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:145

#if !defined (_AVSTREAMS_FDEV__ARG_TRAITS_)
#define _AVSTREAMS_FDEV__ARG_TRAITS_

  template<>
  class  Arg_Traits< ::AVStreams::FDev>
    : public
        Object_Arg_Traits_T<
            ::AVStreams::FDev_ptr,
            ::AVStreams::FDev_var,
            ::AVStreams::FDev_out,
            TAO::Objref_Traits<AVStreams::FDev>,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:145

#if !defined (_AVSTREAMS_FLOWCONNECTION__ARG_TRAITS_)
#define _AVSTREAMS_FLOWCONNECTION__ARG_TRAITS_

  template<>
  class  Arg_Traits< ::AVStreams::FlowConnection>
    : public
        Object_Arg_Traits_T<
            ::AVStreams::FlowConnection_ptr,
            ::AVStreams::FlowConnection_var,
            ::AVStreams::FlowConnection_out,
            TAO::Objref_Traits<AVStreams::FlowConnection>,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:902

  template<>
  class Arg_Traits< ::AVStreams::PositionOrigin>
    : public
        Basic_Arg_Traits_T<
            ::AVStreams::PositionOrigin,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:902

  template<>
  class Arg_Traits< ::AVStreams::PositionKey>
    : public
        Basic_Arg_Traits_T<
            ::AVStreams::PositionKey,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:945

  template<>
  class Arg_Traits< ::AVStreams::Position>
    : public
        Fixed_Size_Arg_Traits_T<
            ::AVStreams::Position,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:145

#if !defined (_AVSTREAMS_MEDIACONTROL__ARG_TRAITS_)
#define _AVSTREAMS_MEDIACONTROL__ARG_TRAITS_

  template<>
  class  Arg_Traits< ::AVStreams::MediaControl>
    : public
        Object_Arg_Traits_T<
            ::AVStreams::MediaControl_ptr,
            ::AVStreams::MediaControl_var,
            ::AVStreams::MediaControl_out,
            TAO::Objref_Traits<AVStreams::MediaControl>,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

#endif /* end #if !defined */

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:683

  template<>
  class Arg_Traits< ::AVStreams::FlowConnection_seq>
    : public
        Var_Size_Arg_Traits_T<
            ::AVStreams::FlowConnection_seq,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:683

  template<>
  class Arg_Traits< ::AVStreams::StreamEndPoint_A_seq>
    : public
        Var_Size_Arg_Traits_T<
            ::AVStreams::StreamEndPoint_A_seq,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:683

  template<>
  class Arg_Traits< ::AVStreams::StreamEndPoint_B_seq>
    : public
        Var_Size_Arg_Traits_T<
            ::AVStreams::StreamEndPoint_B_seq,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:683

  template<>
  class Arg_Traits< ::AVStreams::FlowEndPoint_seq>
    : public
        Var_Size_Arg_Traits_T<
            ::AVStreams::FlowEndPoint_seq,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };

  // TAO_IDL - Generated from
  // be/be_visitor_arg_traits.cpp:683

  template<>
  class Arg_Traits< ::AVStreams::Object_seq>
    : public
        Var_Size_Arg_Traits_T<
            ::AVStreams::Object_seq,
            TAO::Any_Insert_Policy_Stream
          >
  {
  };
}

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_traits.cpp:60


TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

// Traits specializations.
namespace TAO
{

#if !defined (_AVSTREAMS_BASIC_STREAMCTRL__TRAITS_)
#define _AVSTREAMS_BASIC_STREAMCTRL__TRAITS_

  template<>
  struct TAO_AV_Export Objref_Traits< ::AVStreams::Basic_StreamCtrl>
  {
    static ::AVStreams::Basic_StreamCtrl_ptr duplicate (
        ::AVStreams::Basic_StreamCtrl_ptr p);
    static void release (
        ::AVStreams::Basic_StreamCtrl_ptr p);
    static ::AVStreams::Basic_StreamCtrl_ptr nil (void);
    static ::CORBA::Boolean marshal (
        const ::AVStreams::Basic_StreamCtrl_ptr p,
        TAO_OutputCDR & cdr);
  };

#endif /* end #if !defined */

#if !defined (_AVSTREAMS_NEGOTIATOR__TRAITS_)
#define _AVSTREAMS_NEGOTIATOR__TRAITS_

  template<>
  struct TAO_AV_Export Objref_Traits< ::AVStreams::Negotiator>
  {
    static ::AVStreams::Negotiator_ptr duplicate (
        ::AVStreams::Negotiator_ptr p);
    static void release (
        ::AVStreams::Negotiator_ptr p);
    static ::AVStreams::Negotiator_ptr nil (void);
    static ::CORBA::Boolean marshal (
        const ::AVStreams::Negotiator_ptr p,
        TAO_OutputCDR & cdr);
  };

#endif /* end #if !defined */

#if !defined (_AVSTREAMS_STREAMCTRL__TRAITS_)
#define _AVSTREAMS_STREAMCTRL__TRAITS_

  template<>
  struct TAO_AV_Export Objref_Traits< ::AVStreams::StreamCtrl>
  {
    static ::AVStreams::StreamCtrl_ptr duplicate (
        ::AVStreams::StreamCtrl_ptr p);
    static void release (
        ::AVStreams::StreamCtrl_ptr p);
    static ::AVStreams::StreamCtrl_ptr nil (void);
    static ::CORBA::Boolean marshal (
        const ::AVStreams::StreamCtrl_ptr p,
        TAO_OutputCDR & cdr);
  };

#endif /* end #if !defined */

#if !defined (_AVSTREAMS_MCASTCONFIGIF__TRAITS_)
#define _AVSTREAMS_MCASTCONFIGIF__TRAITS_

  template<>
  struct TAO_AV_Export Objref_Traits< ::AVStreams::MCastConfigIf>
  {
    static ::AVStreams::MCastConfigIf_ptr duplicate (
        ::AVStreams::MCastConfigIf_ptr p);
    static void release (
        ::AVStreams::MCastConfigIf_ptr p);
    static ::AVStreams::MCastConfigIf_ptr nil (void);
    static ::CORBA::Boolean marshal (
        const ::AVStreams::MCastConfigIf_ptr p,
        TAO_OutputCDR & cdr);
  };

#endif /* end #if !defined */

#if !defined (_AVSTREAMS_STREAMENDPOINT__TRAITS_)
#define _AVSTREAMS_STREAMENDPOINT__TRAITS_

  template<>
  struct TAO_AV_Export Objref_Traits< ::AVStreams::StreamEndPoint>
  {
    static ::AVStreams::StreamEndPoint_ptr duplicate (
        ::AVStreams::StreamEndPoint_ptr p);
    static void release (
        ::AVStreams::StreamEndPoint_ptr p);
    static ::AVStreams::StreamEndPoint_ptr nil (void);
    static ::CORBA::Boolean marshal (
        const ::AVStreams::StreamEndPoint_ptr p,
        TAO_OutputCDR & cdr);
  };

#endif /* end #if !defined */

#if !defined (_AVSTREAMS_STREAMENDPOINT_A__TRAITS_)
#define _AVSTREAMS_STREAMENDPOINT_A__TRAITS_

  template<>
  struct TAO_AV_Export Objref_Traits< ::AVStreams::StreamEndPoint_A>
  {
    static ::AVStreams::StreamEndPoint_A_ptr duplicate (
        ::AVStreams::StreamEndPoint_A_ptr p);
    static void release (
        ::AVStreams::StreamEndPoint_A_ptr p);
    static ::AVStreams::StreamEndPoint_A_ptr nil (void);
    static ::CORBA::Boolean marshal (
        const ::AVStreams::StreamEndPoint_A_ptr p,
        TAO_OutputCDR & cdr);
  };

#endif /* end #if !defined */

#if !defined (_AVSTREAMS_STREAMENDPOINT_B__TRAITS_)
#define _AVSTREAMS_STREAMENDPOINT_B__TRAITS_

  template<>
  struct TAO_AV_Export Objref_Traits< ::AVStreams::StreamEndPoint_B>
  {
    static ::AVStreams::StreamEndPoint_B_ptr duplicate (
        ::AVStreams::StreamEndPoint_B_ptr p);
    static void release (
        ::AVStreams::StreamEndPoint_B_ptr p);
    static ::AVStreams::StreamEndPoint_B_ptr nil (void);
    static ::CORBA::Boolean marshal (
        const ::AVStreams::StreamEndPoint_B_ptr p,
        TAO_OutputCDR & cdr);
  };

#endif /* end #if !defined */

#if !defined (_AVSTREAMS_VDEV__TRAITS_)
#define _AVSTREAMS_VDEV__TRAITS_

  template<>
  struct TAO_AV_Export Objref_Traits< ::AVStreams::VDev>
  {
    static ::AVStreams::VDev_ptr duplicate (
        ::AVStreams::VDev_ptr p);
    static void release (
        ::AVStreams::VDev_ptr p);
    static ::AVStreams::VDev_ptr nil (void);
    static ::CORBA::Boolean marshal (
        const ::AVStreams::VDev_ptr p,
        TAO_OutputCDR & cdr);
  };

#endif /* end #if !defined */

#if !defined (_AVSTREAMS_MMDEVICE__TRAITS_)
#define _AVSTREAMS_MMDEVICE__TRAITS_

  template<>
  struct TAO_AV_Export Objref_Traits< ::AVStreams::MMDevice>
  {
    static ::AVStreams::MMDevice_ptr duplicate (
        ::AVStreams::MMDevice_ptr p);
    static void release (
        ::AVStreams::MMDevice_ptr p);
    static ::AVStreams::MMDevice_ptr nil (void);
    static ::CORBA::Boolean marshal (
        const ::AVStreams::MMDevice_ptr p,
        TAO_OutputCDR & cdr);
  };

#endif /* end #if !defined */

#if !defined (_AVSTREAMS_FLOWCONNECTION__TRAITS_)
#define _AVSTREAMS_FLOWCONNECTION__TRAITS_

  template<>
  struct TAO_AV_Export Objref_Traits< ::AVStreams::FlowConnection>
  {
    static ::AVStreams::FlowConnection_ptr duplicate (
        ::AVStreams::FlowConnection_ptr p);
    static void release (
        ::AVStreams::FlowConnection_ptr p);
    static ::AVStreams::FlowConnection_ptr nil (void);
    static ::CORBA::Boolean marshal (
        const ::AVStreams::FlowConnection_ptr p,
        TAO_OutputCDR & cdr);
  };

#endif /* end #if !defined */

#if !defined (_AVSTREAMS_FLOWENDPOINT__TRAITS_)
#define _AVSTREAMS_FLOWENDPOINT__TRAITS_

  template<>
  struct TAO_AV_Export Objref_Traits< ::AVStreams::FlowEndPoint>
  {
    static ::AVStreams::FlowEndPoint_ptr duplicate (
        ::AVStreams::FlowEndPoint_ptr p);
    static void release (
        ::AVStreams::FlowEndPoint_ptr p);
    static ::AVStreams::FlowEndPoint_ptr nil (void);
    static ::CORBA::Boolean marshal (
        const ::AVStreams::FlowEndPoint_ptr p,
        TAO_OutputCDR & cdr);
  };

#endif /* end #if !defined */

#if !defined (_AVSTREAMS_FLOWPRODUCER__TRAITS_)
#define _AVSTREAMS_FLOWPRODUCER__TRAITS_

  template<>
  struct TAO_AV_Export Objref_Traits< ::AVStreams::FlowProducer>
  {
    static ::AVStreams::FlowProducer_ptr duplicate (
        ::AVStreams::FlowProducer_ptr p);
    static void release (
        ::AVStreams::FlowProducer_ptr p);
    static ::AVStreams::FlowProducer_ptr nil (void);
    static ::CORBA::Boolean marshal (
        const ::AVStreams::FlowProducer_ptr p,
        TAO_OutputCDR & cdr);
  };

#endif /* end #if !defined */

#if !defined (_AVSTREAMS_FLOWCONSUMER__TRAITS_)
#define _AVSTREAMS_FLOWCONSUMER__TRAITS_

  template<>
  struct TAO_AV_Export Objref_Traits< ::AVStreams::FlowConsumer>
  {
    static ::AVStreams::FlowConsumer_ptr duplicate (
        ::AVStreams::FlowConsumer_ptr p);
    static void release (
        ::AVStreams::FlowConsumer_ptr p);
    static ::AVStreams::FlowConsumer_ptr nil (void);
    static ::CORBA::Boolean marshal (
        const ::AVStreams::FlowConsumer_ptr p,
        TAO_OutputCDR & cdr);
  };

#endif /* end #if !defined */

#if !defined (_AVSTREAMS_FDEV__TRAITS_)
#define _AVSTREAMS_FDEV__TRAITS_

  template<>
  struct TAO_AV_Export Objref_Traits< ::AVStreams::FDev>
  {
    static ::AVStreams::FDev_ptr duplicate (
        ::AVStreams::FDev_ptr p);
    static void release (
        ::AVStreams::FDev_ptr p);
    static ::AVStreams::FDev_ptr nil (void);
    static ::CORBA::Boolean marshal (
        const ::AVStreams::FDev_ptr p,
        TAO_OutputCDR & cdr);
  };

#endif /* end #if !defined */

#if !defined (_AVSTREAMS_MEDIACONTROL__TRAITS_)
#define _AVSTREAMS_MEDIACONTROL__TRAITS_

  template<>
  struct TAO_AV_Export Objref_Traits< ::AVStreams::MediaControl>
  {
    static ::AVStreams::MediaControl_ptr duplicate (
        ::AVStreams::MediaControl_ptr p);
    static void release (
        ::AVStreams::MediaControl_ptr p);
    static ::AVStreams::MediaControl_ptr nil (void);
    static ::CORBA::Boolean marshal (
        const ::AVStreams::MediaControl_ptr p,
        TAO_OutputCDR & cdr);
  };

#endif /* end #if !defined */
}
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_structure/any_op_ch.cpp:42



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::QoS &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::QoS*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::QoS *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::QoS *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::QoS &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::QoS*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::QoS *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::QoS *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_sequence/any_op_ch.cpp:47



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, const ::AVStreams::streamQoS &); // copying version
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, ::AVStreams::streamQoS*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::streamQoS *&); // deprecated
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::streamQoS *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= ( ::CORBA::Any &, const AVStreams::streamQoS &); // copying version
TAO_AV_Export void operator<<= ( ::CORBA::Any &, AVStreams::streamQoS*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::streamQoS *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::streamQoS *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_sequence/any_op_ch.cpp:47



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, const ::AVStreams::flowSpec &); // copying version
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, ::AVStreams::flowSpec*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::flowSpec *&); // deprecated
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::flowSpec *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= ( ::CORBA::Any &, const AVStreams::flowSpec &); // copying version
TAO_AV_Export void operator<<= ( ::CORBA::Any &, AVStreams::flowSpec*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::flowSpec *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::flowSpec *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_sequence/any_op_ch.cpp:47



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, const ::AVStreams::protocolSpec &); // copying version
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, ::AVStreams::protocolSpec*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::protocolSpec *&); // deprecated
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::protocolSpec *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= ( ::CORBA::Any &, const AVStreams::protocolSpec &); // copying version
TAO_AV_Export void operator<<= ( ::CORBA::Any &, AVStreams::protocolSpec*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::protocolSpec *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::protocolSpec *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_sequence/any_op_ch.cpp:47



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, const ::AVStreams::key &); // copying version
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, ::AVStreams::key*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::key *&); // deprecated
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::key *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= ( ::CORBA::Any &, const AVStreams::key &); // copying version
TAO_AV_Export void operator<<= ( ::CORBA::Any &, AVStreams::key*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::key *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::key *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_structure/any_op_ch.cpp:42



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::SFPStatus &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::SFPStatus*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::SFPStatus *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::SFPStatus *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::SFPStatus &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::SFPStatus*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::SFPStatus *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::SFPStatus *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_enum/any_op_ch.cpp:36

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::flowState);
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::flowState &);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::flowState);
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::flowState &);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_enum/any_op_ch.cpp:36

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::dirType);
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::dirType &);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::dirType);
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::dirType &);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_structure/any_op_ch.cpp:42



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::flowStatus &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::flowStatus*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::flowStatus *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::flowStatus *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::flowStatus &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::flowStatus*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::flowStatus *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::flowStatus *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_exception/any_op_ch.cpp:38

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::notSupported &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::notSupported*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::notSupported *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::notSupported *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::notSupported &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::notSupported*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::notSupported *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::notSupported *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_exception/any_op_ch.cpp:38

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::PropertyException &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::PropertyException*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::PropertyException *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::PropertyException *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::PropertyException &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::PropertyException*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::PropertyException *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::PropertyException *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_exception/any_op_ch.cpp:38

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::FPError &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::FPError*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::FPError *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::FPError *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::FPError &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::FPError*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::FPError *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::FPError *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_exception/any_op_ch.cpp:38

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::streamOpFailed &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::streamOpFailed*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::streamOpFailed *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::streamOpFailed *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::streamOpFailed &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::streamOpFailed*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::streamOpFailed *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::streamOpFailed *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_exception/any_op_ch.cpp:38

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::streamOpDenied &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::streamOpDenied*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::streamOpDenied *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::streamOpDenied *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::streamOpDenied &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::streamOpDenied*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::streamOpDenied *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::streamOpDenied *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_exception/any_op_ch.cpp:38

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::noSuchFlow &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::noSuchFlow*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::noSuchFlow *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::noSuchFlow *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::noSuchFlow &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::noSuchFlow*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::noSuchFlow *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::noSuchFlow *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_exception/any_op_ch.cpp:38

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::QoSRequestFailed &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::QoSRequestFailed*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::QoSRequestFailed *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::QoSRequestFailed *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::QoSRequestFailed &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::QoSRequestFailed*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::QoSRequestFailed *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::QoSRequestFailed *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_interface/any_op_ch.cpp:41



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, Basic_StreamCtrl_ptr); // copying
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, Basic_StreamCtrl_ptr *); // non-copying
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, Basic_StreamCtrl_ptr &);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::Basic_StreamCtrl_ptr); // copying
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::Basic_StreamCtrl_ptr *); // non-copying
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::Basic_StreamCtrl_ptr &);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_interface/any_op_ch.cpp:41



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, Negotiator_ptr); // copying
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, Negotiator_ptr *); // non-copying
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, Negotiator_ptr &);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::Negotiator_ptr); // copying
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::Negotiator_ptr *); // non-copying
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::Negotiator_ptr &);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_interface/any_op_ch.cpp:41



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, StreamCtrl_ptr); // copying
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, StreamCtrl_ptr *); // non-copying
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, StreamCtrl_ptr &);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::StreamCtrl_ptr); // copying
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::StreamCtrl_ptr *); // non-copying
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::StreamCtrl_ptr &);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_interface/any_op_ch.cpp:41



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, MCastConfigIf_ptr); // copying
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, MCastConfigIf_ptr *); // non-copying
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, MCastConfigIf_ptr &);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::MCastConfigIf_ptr); // copying
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::MCastConfigIf_ptr *); // non-copying
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::MCastConfigIf_ptr &);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_interface/any_op_ch.cpp:41



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, StreamEndPoint_ptr); // copying
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, StreamEndPoint_ptr *); // non-copying
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, StreamEndPoint_ptr &);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::StreamEndPoint_ptr); // copying
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::StreamEndPoint_ptr *); // non-copying
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::StreamEndPoint_ptr &);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_interface/any_op_ch.cpp:41



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, StreamEndPoint_A_ptr); // copying
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, StreamEndPoint_A_ptr *); // non-copying
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, StreamEndPoint_A_ptr &);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::StreamEndPoint_A_ptr); // copying
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::StreamEndPoint_A_ptr *); // non-copying
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::StreamEndPoint_A_ptr &);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_interface/any_op_ch.cpp:41



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, StreamEndPoint_B_ptr); // copying
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, StreamEndPoint_B_ptr *); // non-copying
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, StreamEndPoint_B_ptr &);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::StreamEndPoint_B_ptr); // copying
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::StreamEndPoint_B_ptr *); // non-copying
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::StreamEndPoint_B_ptr &);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_interface/any_op_ch.cpp:41



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, VDev_ptr); // copying
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, VDev_ptr *); // non-copying
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, VDev_ptr &);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::VDev_ptr); // copying
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::VDev_ptr *); // non-copying
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::VDev_ptr &);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_interface/any_op_ch.cpp:41



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, MMDevice_ptr); // copying
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, MMDevice_ptr *); // non-copying
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, MMDevice_ptr &);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::MMDevice_ptr); // copying
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::MMDevice_ptr *); // non-copying
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::MMDevice_ptr &);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_exception/any_op_ch.cpp:38

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::protocolNotSupported &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::protocolNotSupported*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::protocolNotSupported *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::protocolNotSupported *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::protocolNotSupported &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::protocolNotSupported*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::protocolNotSupported *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::protocolNotSupported *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_exception/any_op_ch.cpp:38

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::formatNotSupported &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::formatNotSupported*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::formatNotSupported *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::formatNotSupported *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::formatNotSupported &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::formatNotSupported*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::formatNotSupported *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::formatNotSupported *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_exception/any_op_ch.cpp:38

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::formatMismatch &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::formatMismatch*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::formatMismatch *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::formatMismatch *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::formatMismatch &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::formatMismatch*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::formatMismatch *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::formatMismatch *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_exception/any_op_ch.cpp:38

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::FEPMismatch &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::FEPMismatch*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::FEPMismatch *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::FEPMismatch *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::FEPMismatch &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::FEPMismatch*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::FEPMismatch *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::FEPMismatch *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_exception/any_op_ch.cpp:38

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::alreadyConnected &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::alreadyConnected*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::alreadyConnected *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::alreadyConnected *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::alreadyConnected &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::alreadyConnected*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::alreadyConnected *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::alreadyConnected *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_exception/any_op_ch.cpp:38

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::invalidSettings &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::invalidSettings*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::invalidSettings *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::invalidSettings *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::invalidSettings &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::invalidSettings*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::invalidSettings *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::invalidSettings *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_exception/any_op_ch.cpp:38

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::notConnected &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::notConnected*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::notConnected *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::notConnected *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::notConnected &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::notConnected*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::notConnected *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::notConnected *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_exception/any_op_ch.cpp:38

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::deviceQosMismatch &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::deviceQosMismatch*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::deviceQosMismatch *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::deviceQosMismatch *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::deviceQosMismatch &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::deviceQosMismatch*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::deviceQosMismatch *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::deviceQosMismatch *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_exception/any_op_ch.cpp:38

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::failedToConnect &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::failedToConnect*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::failedToConnect *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::failedToConnect *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::failedToConnect &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::failedToConnect*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::failedToConnect *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::failedToConnect *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_exception/any_op_ch.cpp:38

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::failedToListen &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::failedToListen*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::failedToListen *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::failedToListen *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::failedToListen &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::failedToListen*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::failedToListen *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::failedToListen *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_interface/any_op_ch.cpp:41



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, FlowConnection_ptr); // copying
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, FlowConnection_ptr *); // non-copying
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, FlowConnection_ptr &);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::FlowConnection_ptr); // copying
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::FlowConnection_ptr *); // non-copying
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::FlowConnection_ptr &);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_interface/any_op_ch.cpp:41



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, FlowEndPoint_ptr); // copying
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, FlowEndPoint_ptr *); // non-copying
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, FlowEndPoint_ptr &);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::FlowEndPoint_ptr); // copying
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::FlowEndPoint_ptr *); // non-copying
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::FlowEndPoint_ptr &);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_interface/any_op_ch.cpp:41



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, FlowProducer_ptr); // copying
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, FlowProducer_ptr *); // non-copying
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, FlowProducer_ptr &);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::FlowProducer_ptr); // copying
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::FlowProducer_ptr *); // non-copying
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::FlowProducer_ptr &);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_interface/any_op_ch.cpp:41



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, FlowConsumer_ptr); // copying
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, FlowConsumer_ptr *); // non-copying
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, FlowConsumer_ptr &);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::FlowConsumer_ptr); // copying
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::FlowConsumer_ptr *); // non-copying
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::FlowConsumer_ptr &);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_interface/any_op_ch.cpp:41



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, FDev_ptr); // copying
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, FDev_ptr *); // non-copying
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, FDev_ptr &);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::FDev_ptr); // copying
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::FDev_ptr *); // non-copying
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::FDev_ptr &);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_enum/any_op_ch.cpp:36

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::PositionOrigin);
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::PositionOrigin &);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::PositionOrigin);
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::PositionOrigin &);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_enum/any_op_ch.cpp:36

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::PositionKey);
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::PositionKey &);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::PositionKey);
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::PositionKey &);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_structure/any_op_ch.cpp:42



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::Position &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::Position*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::Position *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::Position *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::Position &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::Position*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::Position *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::Position *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_exception/any_op_ch.cpp:38

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::PostionKeyNotSupported &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::PostionKeyNotSupported*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::PostionKeyNotSupported *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::PostionKeyNotSupported *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::PostionKeyNotSupported &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::PostionKeyNotSupported*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::PostionKeyNotSupported *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::PostionKeyNotSupported *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_exception/any_op_ch.cpp:38

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::InvalidPosition &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::InvalidPosition*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::InvalidPosition *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::InvalidPosition *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::InvalidPosition &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::InvalidPosition*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::InvalidPosition *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::InvalidPosition *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_interface/any_op_ch.cpp:41



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, MediaControl_ptr); // copying
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, MediaControl_ptr *); // non-copying
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, MediaControl_ptr &);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::MediaControl_ptr); // copying
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::MediaControl_ptr *); // non-copying
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::MediaControl_ptr &);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_exception/any_op_ch.cpp:38

#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  

  TAO_AV_Export void operator<<= (::CORBA::Any &, const ::AVStreams::MediaControl::PostionKeyNotSupported &); // copying version
  TAO_AV_Export void operator<<= (::CORBA::Any &, ::AVStreams::MediaControl::PostionKeyNotSupported*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::MediaControl::PostionKeyNotSupported *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::MediaControl::PostionKeyNotSupported *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export void operator<<= (::CORBA::Any &, const AVStreams::MediaControl::PostionKeyNotSupported &); // copying version
TAO_AV_Export void operator<<= (::CORBA::Any &, AVStreams::MediaControl::PostionKeyNotSupported*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::MediaControl::PostionKeyNotSupported *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::MediaControl::PostionKeyNotSupported *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_sequence/any_op_ch.cpp:47



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, const ::AVStreams::FlowConnection_seq &); // copying version
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, ::AVStreams::FlowConnection_seq*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::FlowConnection_seq *&); // deprecated
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::FlowConnection_seq *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= ( ::CORBA::Any &, const AVStreams::FlowConnection_seq &); // copying version
TAO_AV_Export void operator<<= ( ::CORBA::Any &, AVStreams::FlowConnection_seq*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::FlowConnection_seq *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::FlowConnection_seq *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_sequence/any_op_ch.cpp:47



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, const ::AVStreams::StreamEndPoint_A_seq &); // copying version
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, ::AVStreams::StreamEndPoint_A_seq*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::StreamEndPoint_A_seq *&); // deprecated
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::StreamEndPoint_A_seq *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= ( ::CORBA::Any &, const AVStreams::StreamEndPoint_A_seq &); // copying version
TAO_AV_Export void operator<<= ( ::CORBA::Any &, AVStreams::StreamEndPoint_A_seq*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::StreamEndPoint_A_seq *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::StreamEndPoint_A_seq *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_sequence/any_op_ch.cpp:47



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, const ::AVStreams::StreamEndPoint_B_seq &); // copying version
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, ::AVStreams::StreamEndPoint_B_seq*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::StreamEndPoint_B_seq *&); // deprecated
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::StreamEndPoint_B_seq *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= ( ::CORBA::Any &, const AVStreams::StreamEndPoint_B_seq &); // copying version
TAO_AV_Export void operator<<= ( ::CORBA::Any &, AVStreams::StreamEndPoint_B_seq*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::StreamEndPoint_B_seq *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::StreamEndPoint_B_seq *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_sequence/any_op_ch.cpp:47



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, const ::AVStreams::FlowEndPoint_seq &); // copying version
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, ::AVStreams::FlowEndPoint_seq*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::FlowEndPoint_seq *&); // deprecated
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::FlowEndPoint_seq *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= ( ::CORBA::Any &, const AVStreams::FlowEndPoint_seq &); // copying version
TAO_AV_Export void operator<<= ( ::CORBA::Any &, AVStreams::FlowEndPoint_seq*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::FlowEndPoint_seq *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::FlowEndPoint_seq *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_sequence/any_op_ch.cpp:47



#if defined (ACE_ANY_OPS_USE_NAMESPACE)

namespace AVStreams
{
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, const ::AVStreams::Object_seq &); // copying version
  TAO_AV_Export void operator<<= ( ::CORBA::Any &, ::AVStreams::Object_seq*); // noncopying version
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, ::AVStreams::Object_seq *&); // deprecated
  TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const ::AVStreams::Object_seq *&);
}

#else



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export void operator<<= ( ::CORBA::Any &, const AVStreams::Object_seq &); // copying version
TAO_AV_Export void operator<<= ( ::CORBA::Any &, AVStreams::Object_seq*); // noncopying version
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, AVStreams::Object_seq *&); // deprecated
TAO_AV_Export ::CORBA::Boolean operator>>= (const ::CORBA::Any &, const AVStreams::Object_seq *&);
TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif

// TAO_IDL - Generated from
// be/be_visitor_structure/cdr_op_ch.cpp:43



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::QoS &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::QoS &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_sequence/cdr_op_ch.cpp:65

#if !defined _TAO_CDR_OP_AVStreams_streamQoS_H_
#define _TAO_CDR_OP_AVStreams_streamQoS_H_

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL


TAO_AV_Export ::CORBA::Boolean operator<< (
    TAO_OutputCDR &strm,
    const AVStreams::streamQoS &_tao_sequence);
TAO_AV_Export ::CORBA::Boolean operator>> (
    TAO_InputCDR &strm,
    AVStreams::streamQoS &_tao_sequence);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif /* _TAO_CDR_OP_AVStreams_streamQoS_H_ */

// TAO_IDL - Generated from
// be/be_visitor_sequence/cdr_op_ch.cpp:65

#if !defined _TAO_CDR_OP_AVStreams_flowSpec_H_
#define _TAO_CDR_OP_AVStreams_flowSpec_H_

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL


TAO_AV_Export ::CORBA::Boolean operator<< (
    TAO_OutputCDR &strm,
    const AVStreams::flowSpec &_tao_sequence);
TAO_AV_Export ::CORBA::Boolean operator>> (
    TAO_InputCDR &strm,
    AVStreams::flowSpec &_tao_sequence);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif /* _TAO_CDR_OP_AVStreams_flowSpec_H_ */

// TAO_IDL - Generated from
// be/be_visitor_sequence/cdr_op_ch.cpp:65

#if !defined _TAO_CDR_OP_AVStreams_protocolSpec_H_
#define _TAO_CDR_OP_AVStreams_protocolSpec_H_

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL


TAO_AV_Export ::CORBA::Boolean operator<< (
    TAO_OutputCDR &strm,
    const AVStreams::protocolSpec &_tao_sequence);
TAO_AV_Export ::CORBA::Boolean operator>> (
    TAO_InputCDR &strm,
    AVStreams::protocolSpec &_tao_sequence);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif /* _TAO_CDR_OP_AVStreams_protocolSpec_H_ */

// TAO_IDL - Generated from
// be/be_visitor_sequence/cdr_op_ch.cpp:65

#if !defined _TAO_CDR_OP_AVStreams_key_H_
#define _TAO_CDR_OP_AVStreams_key_H_

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL


TAO_AV_Export ::CORBA::Boolean operator<< (
    TAO_OutputCDR &strm,
    const AVStreams::key &_tao_sequence);
TAO_AV_Export ::CORBA::Boolean operator>> (
    TAO_InputCDR &strm,
    AVStreams::key &_tao_sequence);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif /* _TAO_CDR_OP_AVStreams_key_H_ */

// TAO_IDL - Generated from
// be/be_visitor_structure/cdr_op_ch.cpp:43



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::SFPStatus &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::SFPStatus &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_enum/cdr_op_ch.cpp:34



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &strm, AVStreams::flowState _tao_enumerator);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &strm, AVStreams::flowState &_tao_enumerator);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_enum/cdr_op_ch.cpp:34



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &strm, AVStreams::dirType _tao_enumerator);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &strm, AVStreams::dirType &_tao_enumerator);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_structure/cdr_op_ch.cpp:43



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::flowStatus &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::flowStatus &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_exception/cdr_op_ch.cpp:37

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::notSupported &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::notSupported &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_exception/cdr_op_ch.cpp:37

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::PropertyException &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::PropertyException &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_exception/cdr_op_ch.cpp:37

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::FPError &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::FPError &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_exception/cdr_op_ch.cpp:37

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::streamOpFailed &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::streamOpFailed &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_exception/cdr_op_ch.cpp:37

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::streamOpDenied &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::streamOpDenied &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_exception/cdr_op_ch.cpp:37

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::noSuchFlow &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::noSuchFlow &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_exception/cdr_op_ch.cpp:37

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::QoSRequestFailed &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::QoSRequestFailed &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_interface/cdr_op_ch.cpp:41


TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::Basic_StreamCtrl_ptr );
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::Basic_StreamCtrl_ptr &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_interface/cdr_op_ch.cpp:41


TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::Negotiator_ptr );
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::Negotiator_ptr &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_interface/cdr_op_ch.cpp:41


TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::StreamCtrl_ptr );
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::StreamCtrl_ptr &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_interface/cdr_op_ch.cpp:41


TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::MCastConfigIf_ptr );
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::MCastConfigIf_ptr &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_interface/cdr_op_ch.cpp:41


TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::StreamEndPoint_ptr );
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::StreamEndPoint_ptr &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_interface/cdr_op_ch.cpp:41


TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::StreamEndPoint_A_ptr );
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::StreamEndPoint_A_ptr &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_interface/cdr_op_ch.cpp:41


TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::StreamEndPoint_B_ptr );
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::StreamEndPoint_B_ptr &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_interface/cdr_op_ch.cpp:41


TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::VDev_ptr );
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::VDev_ptr &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_interface/cdr_op_ch.cpp:41


TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::MMDevice_ptr );
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::MMDevice_ptr &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_exception/cdr_op_ch.cpp:37

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::protocolNotSupported &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::protocolNotSupported &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_exception/cdr_op_ch.cpp:37

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::formatNotSupported &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::formatNotSupported &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_exception/cdr_op_ch.cpp:37

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::formatMismatch &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::formatMismatch &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_exception/cdr_op_ch.cpp:37

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::FEPMismatch &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::FEPMismatch &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_exception/cdr_op_ch.cpp:37

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::alreadyConnected &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::alreadyConnected &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_exception/cdr_op_ch.cpp:37

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::invalidSettings &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::invalidSettings &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_exception/cdr_op_ch.cpp:37

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::notConnected &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::notConnected &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_exception/cdr_op_ch.cpp:37

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::deviceQosMismatch &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::deviceQosMismatch &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_exception/cdr_op_ch.cpp:37

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::failedToConnect &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::failedToConnect &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_exception/cdr_op_ch.cpp:37

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::failedToListen &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::failedToListen &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_interface/cdr_op_ch.cpp:41


TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::FlowConnection_ptr );
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::FlowConnection_ptr &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_interface/cdr_op_ch.cpp:41


TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::FlowEndPoint_ptr );
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::FlowEndPoint_ptr &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_interface/cdr_op_ch.cpp:41


TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::FlowProducer_ptr );
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::FlowProducer_ptr &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_interface/cdr_op_ch.cpp:41


TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::FlowConsumer_ptr );
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::FlowConsumer_ptr &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_interface/cdr_op_ch.cpp:41


TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::FDev_ptr );
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::FDev_ptr &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_enum/cdr_op_ch.cpp:34



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &strm, AVStreams::PositionOrigin _tao_enumerator);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &strm, AVStreams::PositionOrigin &_tao_enumerator);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_enum/cdr_op_ch.cpp:34



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &strm, AVStreams::PositionKey _tao_enumerator);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &strm, AVStreams::PositionKey &_tao_enumerator);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_structure/cdr_op_ch.cpp:43



TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::Position &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::Position &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_exception/cdr_op_ch.cpp:37

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::PostionKeyNotSupported &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::PostionKeyNotSupported &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_exception/cdr_op_ch.cpp:37

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::InvalidPosition &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::InvalidPosition &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_interface/cdr_op_ch.cpp:41


TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::MediaControl_ptr );
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::MediaControl_ptr &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_exception/cdr_op_ch.cpp:37

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL



TAO_AV_Export ::CORBA::Boolean operator<< (TAO_OutputCDR &, const AVStreams::MediaControl::PostionKeyNotSupported &);
TAO_AV_Export ::CORBA::Boolean operator>> (TAO_InputCDR &, AVStreams::MediaControl::PostionKeyNotSupported &);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




// TAO_IDL - Generated from
// be/be_visitor_sequence/cdr_op_ch.cpp:65

#if !defined _TAO_CDR_OP_AVStreams_FlowConnection_seq_H_
#define _TAO_CDR_OP_AVStreams_FlowConnection_seq_H_

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL


TAO_AV_Export ::CORBA::Boolean operator<< (
    TAO_OutputCDR &strm,
    const AVStreams::FlowConnection_seq &_tao_sequence);
TAO_AV_Export ::CORBA::Boolean operator>> (
    TAO_InputCDR &strm,
    AVStreams::FlowConnection_seq &_tao_sequence);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif /* _TAO_CDR_OP_AVStreams_FlowConnection_seq_H_ */

// TAO_IDL - Generated from
// be/be_visitor_sequence/cdr_op_ch.cpp:65

#if !defined _TAO_CDR_OP_AVStreams_StreamEndPoint_A_seq_H_
#define _TAO_CDR_OP_AVStreams_StreamEndPoint_A_seq_H_

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL


TAO_AV_Export ::CORBA::Boolean operator<< (
    TAO_OutputCDR &strm,
    const AVStreams::StreamEndPoint_A_seq &_tao_sequence);
TAO_AV_Export ::CORBA::Boolean operator>> (
    TAO_InputCDR &strm,
    AVStreams::StreamEndPoint_A_seq &_tao_sequence);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif /* _TAO_CDR_OP_AVStreams_StreamEndPoint_A_seq_H_ */

// TAO_IDL - Generated from
// be/be_visitor_sequence/cdr_op_ch.cpp:65

#if !defined _TAO_CDR_OP_AVStreams_StreamEndPoint_B_seq_H_
#define _TAO_CDR_OP_AVStreams_StreamEndPoint_B_seq_H_

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL


TAO_AV_Export ::CORBA::Boolean operator<< (
    TAO_OutputCDR &strm,
    const AVStreams::StreamEndPoint_B_seq &_tao_sequence);
TAO_AV_Export ::CORBA::Boolean operator>> (
    TAO_InputCDR &strm,
    AVStreams::StreamEndPoint_B_seq &_tao_sequence);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif /* _TAO_CDR_OP_AVStreams_StreamEndPoint_B_seq_H_ */

// TAO_IDL - Generated from
// be/be_visitor_sequence/cdr_op_ch.cpp:65

#if !defined _TAO_CDR_OP_AVStreams_FlowEndPoint_seq_H_
#define _TAO_CDR_OP_AVStreams_FlowEndPoint_seq_H_

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL


TAO_AV_Export ::CORBA::Boolean operator<< (
    TAO_OutputCDR &strm,
    const AVStreams::FlowEndPoint_seq &_tao_sequence);
TAO_AV_Export ::CORBA::Boolean operator>> (
    TAO_InputCDR &strm,
    AVStreams::FlowEndPoint_seq &_tao_sequence);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif /* _TAO_CDR_OP_AVStreams_FlowEndPoint_seq_H_ */

// TAO_IDL - Generated from
// be/be_visitor_sequence/cdr_op_ch.cpp:65

#if !defined _TAO_CDR_OP_AVStreams_Object_seq_H_
#define _TAO_CDR_OP_AVStreams_Object_seq_H_

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL


TAO_AV_Export ::CORBA::Boolean operator<< (
    TAO_OutputCDR &strm,
    const AVStreams::Object_seq &_tao_sequence);
TAO_AV_Export ::CORBA::Boolean operator>> (
    TAO_InputCDR &strm,
    AVStreams::Object_seq &_tao_sequence);

TAO_END_VERSIONED_NAMESPACE_DECL


TAO_BEGIN_VERSIONED_NAMESPACE_DECL




#endif /* _TAO_CDR_OP_AVStreams_Object_seq_H_ */

// TAO_IDL - Generated from
// be/be_codegen.cpp:1700


TAO_END_VERSIONED_NAMESPACE_DECL

#if defined (__ACE_INLINE__)
#include "AVStreamsC.inl"
#endif /* defined INLINE */

#include /**/ "ace/post.h"

#endif /* ifndef */

