/*
 * Decompiled with CFR 0.152.
 */
package installerui;

import installerui.MainWindow;
import installerui.StatusBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import registry.LanguagePackItem;
import utilities.PackageDependencies;
import utilities.PackageInstaller;
import utilities.PackageStatusChecker;
import utilities.PackageTool;
import utilities.PackageUninstaller;
import utilities.ProgressStatusWorker;
import utilities.Utilities;

public class LanguagePackPanel
extends JPanel
implements ActionListener,
ItemListener {
    private JPanel selectPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private StatusBar statusBar;
    private JButton installButton;
    private JButton uninstallButton;
    private MainWindow mainWindow;
    private ArrayList<String> installPackageList = new ArrayList();
    private ArrayList<String> uninstallPackageList = new ArrayList();
    private LanguagePackItem registryItem;
    private HashMap<String, PackageStatusCheckboxPair> packageState = new HashMap();

    public LanguagePackPanel(MainWindow mainFrame, LanguagePackItem regItem) {
        this.mainWindow = mainFrame;
        this.registryItem = regItem;
        this.setStatusBar(this.mainWindow.getStatusBar());
        this.drawPackageInstallationPanel(this.registryItem);
        this.setLayout(new BoxLayout(this, 3));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(this.selectPanel);
        this.add(this.buttonPanel);
        this.add("South", this.getStatusBar());
        this.mainWindow.setContentPane(this);
        this.mainWindow.pack();
    }

    private void setStatusBar(StatusBar statusbar) {
        this.statusBar = statusbar;
    }

    private StatusBar getStatusBar() {
        return this.statusBar;
    }

    private void drawPackageInstallationPanel(LanguagePackItem registryItem) {
        this.selectPanel.setLayout(new BoxLayout(this.selectPanel, 3));
        this.buttonPanel.setLayout(new GridLayout(0, 2));
        this.selectPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Select Packages"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ProgressStatusWorker progressStatus = this.getStatusBar().getProgressStatusWorker();
        int progressIncrement = 100 / registryItem.getPackageCount();
        int updateCount = 0;
        this.getStatusBar().setStatus("PkgChk");
        String[] pkgRegions = registryItem.getPackageRegions();
        for (int ix = 0; ix < pkgRegions.length; ++ix) {
            String regionStr = pkgRegions[ix];
            if (regionStr.isEmpty()) {
                regionStr = "All Regions";
            }
            JPanel tmpPanel = new JPanel();
            tmpPanel.setLayout(new GridLayout(0, 2));
            tmpPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(regionStr), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            String[] pkgItems = registryItem.getPackageNames(pkgRegions[ix]);
            for (int i = 0; i < pkgItems.length; ++i) {
                JCheckBox tmpCheckBox = new JCheckBox(pkgItems[i]);
                PackageStatusChecker pkgChecker = new PackageStatusChecker(pkgItems[i], this.mainWindow.getInstallationRootDir(), progressStatus);
                PackageStatusChecker.PACKAGE_STATUS pkgStatus = pkgChecker.getPackageStatus();
                boolean pkgInstallable = this.isPackageInstallable(pkgItems[i], pkgChecker.getPackageVersion());
                boolean packageAvailable = false;
                this.packageState.put(pkgItems[i], new PackageStatusCheckboxPair(pkgStatus, tmpCheckBox));
                switch (pkgStatus) {
                    case PKG_INSTALLED: {
                        tmpCheckBox.setForeground(Color.RED);
                        packageAvailable = true;
                        break;
                    }
                    case PKG_NOTINSTALLED: {
                        packageAvailable = pkgInstallable;
                        break;
                    }
                    case PKG_UNAVAILABLE: {
                        packageAvailable = false;
                    }
                }
                tmpCheckBox.setEnabled(packageAvailable);
                tmpCheckBox.addItemListener(this);
                tmpPanel.add(tmpCheckBox);
                progressStatus.updateIndicator(++updateCount * progressIncrement);
            }
            this.selectPanel.add(tmpPanel);
        }
        progressStatus.progressComplete();
        this.getStatusBar().setStatus("");
        this.buttonPanel.add(new JPanel());
        JPanel realButtonPanel = new JPanel();
        realButtonPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.installButton = new JButton("Install");
        this.installButton.setEnabled(false);
        this.installButton.addActionListener(this);
        c.anchor = 13;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        realButtonPanel.add((Component)this.installButton, c);
        this.uninstallButton = new JButton("Uninstall");
        this.uninstallButton.setEnabled(false);
        this.uninstallButton.addActionListener(this);
        c.gridx = 1;
        realButtonPanel.add((Component)this.uninstallButton, c);
        this.buttonPanel.add(realButtonPanel);
    }

    private boolean isPackageInstallable(String pkgName, String pkgVersion) {
        HashMap<String, String> packageDatabase = this.mainWindow.getPackageDatabase();
        PackageDependencies pkgDependencies = new PackageDependencies(pkgName, this.mainWindow.getInstallationRootDir(), this.getStatusBar().getProgressStatusWorker());
        ArrayList<String> pkgDeps = pkgDependencies.getPackageDependencies();
        for (int i = 0; i < pkgDeps.size(); ++i) {
            String depItem = pkgDeps.get(i);
            if (depItem.equals("None")) {
                return true;
            }
            if (depItem.contains(">=")) {
                StringTokenizer strTok = new StringTokenizer(depItem, ">=");
                while (strTok.hasMoreElements()) {
                    String installedVers;
                    String depName = strTok.nextElement().toString();
                    String depVers = strTok.nextElement().toString();
                    if (!packageDatabase.containsKey(depName) || Utilities.compareVersionStrings(depVers, installedVers = packageDatabase.get(depName)) < 0) continue;
                    return true;
                }
                continue;
            }
            if (!packageDatabase.containsKey(depItem)) continue;
            return true;
        }
        return false;
    }

    private void updatePackageStatus(LanguagePackItem registryItem) {
        ProgressStatusWorker progressStatus = this.getStatusBar().getProgressStatusWorker();
        int progressIncrement = 100 / registryItem.getPackageCount();
        int updateCount = 0;
        this.getStatusBar().setStatus("PkgChk");
        String[] pkgRegions = registryItem.getPackageRegions();
        for (int ix = 0; ix < pkgRegions.length; ++ix) {
            String[] pkgItems = registryItem.getPackageNames(pkgRegions[ix]);
            for (int i = 0; i < pkgItems.length; ++i) {
                PackageStatusChecker.PACKAGE_STATUS oldStatus;
                PackageStatusChecker pkgChecker = new PackageStatusChecker(pkgItems[i], this.mainWindow.getInstallationRootDir(), progressStatus);
                PackageStatusChecker.PACKAGE_STATUS pkgStatus = pkgChecker.getPackageStatus();
                if (pkgStatus != (oldStatus = this.packageState.get(pkgItems[i]).getPackageStatus())) {
                    JCheckBox tmpCheckBox = this.packageState.get(pkgItems[i]).getPackageCheckBox();
                    this.packageState.put(pkgItems[i], new PackageStatusCheckboxPair(pkgStatus, tmpCheckBox));
                    boolean packageAvailable = false;
                    switch (pkgStatus) {
                        case PKG_INSTALLED: {
                            tmpCheckBox.setForeground(Color.RED);
                            packageAvailable = true;
                            break;
                        }
                        case PKG_NOTINSTALLED: {
                            tmpCheckBox.setForeground(Color.DARK_GRAY);
                            packageAvailable = true;
                            break;
                        }
                        case PKG_UNAVAILABLE: {
                            packageAvailable = false;
                        }
                    }
                    tmpCheckBox.setEnabled(packageAvailable);
                }
                progressStatus.updateIndicator(++updateCount * progressIncrement);
            }
        }
        progressStatus.progressComplete();
        this.getStatusBar().setStatus("");
    }

    private void handleButtonEvent(PackageStatusChecker.PACKAGE_STATUS pkgStatus) {
        PackageTool packageHandler;
        Color checkBoxColor;
        JButton windowButton;
        ArrayList<String> packageList;
        ProgressStatusWorker statusWorker = this.getStatusBar().getProgressStatusWorker();
        switch (pkgStatus) {
            case PKG_INSTALLED: {
                packageList = this.installPackageList;
                windowButton = this.installButton;
                checkBoxColor = Color.RED;
                packageHandler = new PackageInstaller(packageList, this.mainWindow.getInstallationRootDir(), statusWorker);
                statusWorker.setString("Installing...");
                this.getStatusBar().setStatus("PkgInst");
                break;
            }
            default: {
                packageList = this.uninstallPackageList;
                windowButton = this.uninstallButton;
                checkBoxColor = Color.DARK_GRAY;
                packageHandler = new PackageUninstaller(packageList, this.mainWindow.getInstallationRootDir(), statusWorker);
                statusWorker.setString("Removing...");
                this.getStatusBar().setStatus("PkgRm");
            }
        }
        packageHandler.run();
        this.getStatusBar().setStatus("");
        this.updatePackageStatus(this.registryItem);
        for (String pkgName : packageList) {
            JCheckBox pkgCheckBox = this.packageState.get(pkgName).getPackageCheckBox();
            pkgCheckBox.removeItemListener(this);
            pkgCheckBox.setForeground(checkBoxColor);
            pkgCheckBox.setSelected(false);
            this.packageState.put(pkgName, new PackageStatusCheckboxPair(pkgStatus, pkgCheckBox));
            pkgCheckBox.addItemListener(this);
        }
        windowButton.setEnabled(false);
        packageList.clear();
    }

    private void handleCheckBoxEvent(JCheckBox chkBox, boolean isSelected) {
        JButton windowButton;
        PackageStatusChecker.PACKAGE_STATUS pkgStatus = this.packageState.get(chkBox.getText()).getPackageStatus();
        ArrayList<String> packageList = pkgStatus == PackageStatusChecker.PACKAGE_STATUS.PKG_NOTINSTALLED ? this.installPackageList : this.uninstallPackageList;
        JButton jButton = windowButton = pkgStatus == PackageStatusChecker.PACKAGE_STATUS.PKG_NOTINSTALLED ? this.installButton : this.uninstallButton;
        if (isSelected) {
            packageList.add(chkBox.getActionCommand());
            windowButton.setEnabled(isSelected);
        } else {
            packageList.remove(chkBox.getActionCommand());
            if (packageList.isEmpty()) {
                windowButton.setEnabled(isSelected);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        switch (actionEvent.getActionCommand()) {
            case "Install": {
                this.handleButtonEvent(PackageStatusChecker.PACKAGE_STATUS.PKG_INSTALLED);
                break;
            }
            case "Uninstall": {
                this.handleButtonEvent(PackageStatusChecker.PACKAGE_STATUS.PKG_NOTINSTALLED);
                break;
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() instanceof JCheckBox) {
            this.handleCheckBoxEvent((JCheckBox)e.getSource(), e.getStateChange() == 1);
        }
    }

    private class PackageStatusCheckboxPair {
        private PackageStatusChecker.PACKAGE_STATUS packageStatus;
        private JCheckBox packageCheckBox;

        public PackageStatusCheckboxPair(PackageStatusChecker.PACKAGE_STATUS pkgStatus, JCheckBox checkBox) {
            this.packageStatus = pkgStatus;
            this.packageCheckBox = checkBox;
        }

        public PackageStatusChecker.PACKAGE_STATUS getPackageStatus() {
            return this.packageStatus;
        }

        public JCheckBox getPackageCheckBox() {
            return this.packageCheckBox;
        }
    }
}

