/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.morfologik.MorfologikMultiSpeller;

public abstract class MorfologikSpellerRule
extends SpellingCheckRule {
    protected MorfologikMultiSpeller speller1;
    protected MorfologikMultiSpeller speller2;
    protected MorfologikMultiSpeller speller3;
    protected Locale conversionLocale;
    private boolean ignoreTaggedWords = false;
    private boolean checkCompound = false;
    private Pattern compoundRegex = Pattern.compile("-");

    public abstract String getFileName();

    @Override
    public abstract String getId();

    public MorfologikSpellerRule(ResourceBundle messages, Language language) throws IOException {
        super(messages, language);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.conversionLocale = this.conversionLocale != null ? this.conversionLocale : Locale.getDefault();
        this.init();
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
    }

    @Override
    public String getDescription() {
        return this.messages.getString("desc_spelling");
    }

    public void setLocale(Locale locale) {
        this.conversionLocale = locale;
    }

    public void setIgnoreTaggedWords() {
        this.ignoreTaggedWords = true;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        if (this.speller1 == null) {
            String binaryDict = null;
            if (JLanguageTool.getDataBroker().resourceExists(this.getFileName())) {
                binaryDict = this.getFileName();
            }
            if (binaryDict != null) {
                this.initSpeller(binaryDict);
            } else {
                return this.toRuleMatchArray(ruleMatches);
            }
        }
        int idx = -1;
        for (AnalyzedTokenReadings token : tokens) {
            if (this.canBeIgnored(tokens, ++idx, token)) continue;
            String word = token.getAnalyzedToken(0).getToken();
            if (this.tokenizingPattern() == null) {
                ruleMatches.addAll(this.getRuleMatches(word, token.getStartPos(), sentence));
                continue;
            }
            int index = 0;
            Matcher m = this.tokenizingPattern().matcher(word);
            while (m.find()) {
                String match = word.subSequence(index, m.start()).toString();
                ruleMatches.addAll(this.getRuleMatches(match, token.getStartPos() + index, sentence));
                index = m.end();
            }
            if (index == 0) {
                ruleMatches.addAll(this.getRuleMatches(word, token.getStartPos(), sentence));
                continue;
            }
            ruleMatches.addAll(this.getRuleMatches(word.subSequence(index, word.length()).toString(), token.getStartPos() + index, sentence));
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private void initSpeller(String binaryDict) throws IOException {
        String plainTextDict = null;
        if (JLanguageTool.getDataBroker().resourceExists(this.getSpellingFileName())) {
            plainTextDict = this.getSpellingFileName();
        }
        if (plainTextDict == null) {
            throw new RuntimeException("Could not find ignore spell file in path: " + this.getSpellingFileName());
        }
        this.speller1 = new MorfologikMultiSpeller(binaryDict, plainTextDict, 1);
        this.speller2 = new MorfologikMultiSpeller(binaryDict, plainTextDict, 2);
        this.speller3 = new MorfologikMultiSpeller(binaryDict, plainTextDict, 3);
        this.setConvertsCase(this.speller1.convertsCase());
    }

    private boolean canBeIgnored(AnalyzedTokenReadings[] tokens, int idx, AnalyzedTokenReadings token) throws IOException {
        return token.isSentenceStart() || token.isImmunized() || token.isIgnoredBySpeller() || this.isUrl(token.getToken()) || this.isEMail(token.getToken()) || this.ignoreTaggedWords && token.isTagged() || this.ignoreToken(tokens, idx);
    }

    protected boolean isMisspelled(MorfologikMultiSpeller speller, String word) {
        if (!speller.isMisspelled(word)) {
            return false;
        }
        if (this.checkCompound && this.compoundRegex.matcher(word).find()) {
            String[] words;
            for (String singleWord : words = this.compoundRegex.split(word)) {
                if (!speller.isMisspelled(singleWord)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected List<RuleMatch> getRuleMatches(String word, int startPos, AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        if (this.isMisspelled(this.speller1, word) || this.isProhibited(word)) {
            RuleMatch ruleMatch = new RuleMatch(this, sentence, startPos, startPos + word.length(), this.messages.getString("spelling"), this.messages.getString("desc_spelling_short"));
            List<String> suggestions = this.speller1.getSuggestions(word);
            if (suggestions.isEmpty() && word.length() >= 5) {
                suggestions.addAll(this.speller2.getSuggestions(word));
                if (suggestions.isEmpty()) {
                    suggestions.addAll(this.speller3.getSuggestions(word));
                }
            }
            suggestions.addAll(0, this.getAdditionalTopSuggestions(suggestions, word));
            suggestions.addAll(this.getAdditionalSuggestions(suggestions, word));
            if (!suggestions.isEmpty()) {
                this.filterSuggestions(suggestions);
                ruleMatch.setSuggestedReplacements(this.orderSuggestions(suggestions, word));
            }
            ruleMatches.add(ruleMatch);
        }
        return ruleMatches;
    }

    @Nullable
    public Pattern tokenizingPattern() {
        return null;
    }

    protected List<String> orderSuggestions(List<String> suggestions, String word) {
        return suggestions;
    }

    protected void setCheckCompound(boolean checkCompound) {
        this.checkCompound = checkCompound;
    }

    protected void setCompoundRegex(String compoundRegex) {
        this.compoundRegex = Pattern.compile(compoundRegex);
    }
}

