/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Language;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.CaseConversionHelper;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.RuleMatcher;
import org.languagetool.tools.StringTools;

class RegexPatternRule
extends AbstractPatternRule
implements RuleMatcher {
    private static final Pattern suggestionPattern = Pattern.compile("<suggestion>(.*?)</suggestion>");
    private final Pattern pattern;
    private final int markGroup;

    RegexPatternRule(String id, String description, String message, String suggestionsOutMsg, Language language, Pattern regex, int regexpMark) {
        super(id, description, language, regex, regexpMark);
        this.message = message;
        this.pattern = regex;
        this.suggestionsOutMsg = suggestionsOutMsg;
        this.markGroup = regexpMark;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentenceObj) throws IOException {
        String sentence = sentenceObj.getText();
        Matcher matcher = this.pattern.matcher(sentence);
        int startPos = 0;
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        while (matcher.find(startPos)) {
            String msg = this.replaceBackRefs(matcher, this.message);
            boolean sentenceStart = matcher.start(0) == 0;
            List<String> suggestions = this.extractSuggestions(matcher, msg);
            List<String> matchSuggestions = this.getMatchSuggestions(sentence, matcher);
            msg = this.replaceMatchElements(msg, matchSuggestions);
            int markStart = matcher.start(this.markGroup);
            int markEnd = matcher.end(this.markGroup);
            RuleMatch ruleMatch = new RuleMatch(this, sentenceObj, markStart, markEnd, msg, null, sentenceStart, null);
            ArrayList<String> allSuggestions = new ArrayList<String>();
            if (matchSuggestions.size() > 0) {
                allSuggestions.addAll(matchSuggestions);
            } else {
                allSuggestions.addAll(suggestions);
                List<String> extendedSuggestions = this.extractSuggestions(matcher, this.getSuggestionsOutMsg());
                allSuggestions.addAll(extendedSuggestions);
            }
            ruleMatch.setSuggestedReplacements(allSuggestions);
            matches.add(ruleMatch);
            startPos = matcher.end();
        }
        return matches.toArray(new RuleMatch[matches.size()]);
    }

    @NotNull
    private List<String> getMatchSuggestions(String sentence, Matcher matcher) {
        ArrayList<String> matchSuggestions = new ArrayList<String>();
        for (Match match : this.getSuggestionMatches()) {
            String errorText = sentence.substring(matcher.start(), matcher.end());
            String regexReplace = match.getRegexReplace();
            if (regexReplace == null) continue;
            String suggestion = match.getRegexMatch().matcher(errorText).replaceFirst(regexReplace);
            suggestion = CaseConversionHelper.convertCase(match.getCaseConversionType(), suggestion, errorText, this.getLanguage());
            matchSuggestions.add(suggestion);
        }
        return matchSuggestions;
    }

    private String replaceMatchElements(String msg, List<String> suggestions) {
        Matcher sMatcher = suggestionPattern.matcher(msg);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        try {
            while (sMatcher.find()) {
                if (i >= suggestions.size()) continue;
                sMatcher.appendReplacement(sb, "<suggestion>" + suggestions.get(i++).replace("$", "\\$") + "</suggestion>");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception running regex of rule " + this.getFullId() + " with matcher " + sMatcher + " on: '" + msg + "'", e);
        }
        sMatcher.appendTail(sb);
        return sb.toString();
    }

    private List<String> extractSuggestions(Matcher matcher, String msg) {
        Matcher sMatcher = suggestionPattern.matcher(msg);
        int startPos = 0;
        ArrayList<String> result = new ArrayList<String>();
        while (sMatcher.find(startPos)) {
            String suggestion = sMatcher.group(1);
            if (matcher.start() == 0) {
                result.add(this.replaceBackRefs(matcher, StringTools.uppercaseFirstChar(suggestion)));
            } else {
                result.add(this.replaceBackRefs(matcher, suggestion));
            }
            startPos = sMatcher.end();
        }
        return result;
    }

    private String replaceBackRefs(Matcher matcher, String msg) {
        String replacedMsg = msg;
        for (int i = 0; i <= matcher.groupCount(); ++i) {
            String replacement = matcher.group(i);
            if (replacement == null) continue;
            replacedMsg = replacedMsg.replace("\\" + i, replacement);
        }
        replacedMsg = replacedMsg.replaceAll("\\\\[0-9]", "");
        return replacedMsg;
    }

    @Override
    public String toString() {
        return this.pattern.toString() + "/flags:" + this.pattern.flags();
    }
}

