/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import org.jacorb.idl.CharType;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Environment;
import org.jacorb.idl.IDLTreeVisitor;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.IntType;
import org.jacorb.idl.LongType;
import org.jacorb.idl.NoHelperException;
import org.jacorb.idl.StringType;
import org.jacorb.idl.TypeDeclaration;
import org.jacorb.idl.parser;

public class TypeSpec
extends IdlSymbol {
    protected String alias = null;
    public TypeSpec type_spec;
    private static final HashMap<String, String> typeMap = new HashMap();

    protected static String getIDLType(TypeSpec ts) {
        String key = ts.typeName();
        if (ts instanceof CharType && ((CharType)ts).isWide()) {
            return "wchar";
        }
        if (ts instanceof StringType && ((StringType)ts).isWide()) {
            return "wstring";
        }
        if (ts instanceof IntType && ((IntType)ts).unsigned) {
            return "unsigned " + typeMap.get(key);
        }
        if (ts instanceof LongType && ((LongType)ts).unsigned) {
            if (((LongType)ts).unsigned) {
                return "unsigned long";
            }
            return "long";
        }
        if (!typeMap.containsKey(key)) {
            parser.error("TypeSpec typeMap does not contain mapping for " + key + " - please report this bug");
            return key;
        }
        return typeMap.get(key);
    }

    public TypeSpec(int num) {
        super(num);
    }

    public Object clone() {
        TypeSpec ts = new TypeSpec(TypeSpec.new_num());
        ts.type_spec = (TypeSpec)this.type_spec.clone();
        return ts;
    }

    public String typeName() {
        return this.type_spec.typeName();
    }

    public TypeSpec typeSpec() {
        return this.type_spec.typeSpec();
    }

    public int getTCKind() {
        return this.type_spec.getTCKind();
    }

    @Override
    public void accept(IDLTreeVisitor visitor) {
        this.type_spec.accept(visitor);
    }

    @Override
    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.type_spec.setPackage(s);
    }

    @Override
    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
        this.type_spec.setEnclosingSymbol(s);
    }

    public boolean basic() {
        if (this.type_spec == null) {
            parser.logger.log(Level.WARNING, "Typespec null " + this.getClass().getName());
        }
        return this.type_spec.basic();
    }

    public void set_constr(TypeDeclaration td) {
        ConstrTypeSpec c = new ConstrTypeSpec(TypeSpec.new_num());
        c.c_type_spec = td;
        this.type_spec = c;
    }

    @Override
    public void parse() {
        this.type_spec.parse();
    }

    public String toString() {
        try {
            return this.type_spec.toString();
        }
        catch (NullPointerException np) {
            parser.fatal_error("Compiler Error for " + this.type_spec + " " + this.typeName() + " " + np.getMessage(), null);
            return null;
        }
    }

    public String getTypeCodeExpression(Set knownTypes) {
        System.out.println("Add TypeSpec.GetTypeCodeExpression for " + this.getClass());
        return this.type_spec.getTypeCodeExpression(knownTypes);
    }

    public String getTypeCodeExpression() {
        return this.type_spec.getTypeCodeExpression();
    }

    @Override
    public void print(PrintWriter ps) {
        if (!this.included) {
            this.type_spec.print(ps);
        }
    }

    public String holderName() {
        return this.type_spec.holderName();
    }

    public String helperName() throws NoHelperException {
        throw new NoHelperException();
    }

    public String printReadExpression(String streamname) {
        return this.type_spec.printReadExpression(streamname);
    }

    public String printReadStatement(String var_name, String streamname) {
        return var_name + "=" + this.printReadExpression(streamname) + ";";
    }

    public String printWriteStatement(String var_name, String streamname) {
        return this.type_spec.printWriteStatement(var_name, streamname);
    }

    public String printInsertExpression() {
        return this.type_spec.printInsertExpression();
    }

    public String printExtractExpression() {
        return this.type_spec.printExtractExpression();
    }

    static void printHelperClassMethods(PrintWriter ps, String type) {
        TypeSpec.printInsertExtractMethods(ps, type);
        ps.println("\tpublic static org.omg.CORBA.TypeCode type()");
        ps.println("\t{");
        ps.println("\t\treturn _type;");
        ps.println("\t}");
    }

    static void printInsertExtractMethods(PrintWriter ps, String type) {
        ps.println("\tpublic static void insert (final org.omg.CORBA.Any any, final " + type + " s)");
        ps.println("\t{");
        ps.println("\t\tany.type(type());");
        ps.println("\t\twrite( any.create_output_stream(),s);");
        ps.println("\t}" + Environment.NL);
        ps.println("\tpublic static " + type + " extract (final org.omg.CORBA.Any any)");
        ps.println("\t{");
        ps.println("\t\torg.omg.CORBA.portable.InputStream in = any.create_input_stream();");
        ps.println("\t\ttry");
        ps.println("\t\t{");
        ps.println("\t\t\treturn read (in);");
        ps.println("\t\t}");
        ps.println("\t\tfinally");
        ps.println("\t\t{");
        ps.println("\t\t\ttry");
        ps.println("\t\t\t{");
        ps.println("\t\t\t\tin.close();");
        ps.println("\t\t\t}");
        ps.println("\t\t\tcatch (java.io.IOException e)");
        ps.println("\t\t\t{");
        ps.println("\t\t\tthrow new RuntimeException(\"Unexpected exception \" + e.toString() );");
        ps.println("\t\t\t}");
        ps.println("\t\t}");
        ps.println("\t}" + Environment.NL);
    }

    public void printInsertIntoAny(PrintWriter ps, String anyname, String varname) {
        this.type_spec.printInsertIntoAny(ps, anyname, varname);
    }

    public void printExtractResult(PrintWriter ps, String resultname, String anyname, String resulttype) {
        this.type_spec.printExtractResult(ps, resultname, anyname, resulttype);
    }

    static {
        typeMap.put("byte", "byte");
        typeMap.put("org.omg.CORBA.Any", "any");
        typeMap.put("char", "char");
        typeMap.put("string", "string");
        typeMap.put("java.math.BigDecimal", "fixed");
        typeMap.put("float", "float");
        typeMap.put("long", "long long");
        typeMap.put("int", "int");
        typeMap.put("byte", "byte");
        typeMap.put("short", "short");
    }
}

