/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import org.jacorb.util.ObjectUtil;

public class KeyStoreUtil {
    static KeyStore getKeyStore(String file_name, char[] storepass, String keystoreType) throws IOException, GeneralSecurityException {
        return KeyStoreUtil.getKeyStore(file_name, storepass, keystoreType, null);
    }

    static KeyStore getKeyStore(String file_name, char[] storepass, String keystoreType, String keystoreProvider) throws IOException, GeneralSecurityException {
        KeyStore ks = KeyStore.getInstance(keystoreType);
        ks = "PKCS11".equalsIgnoreCase(keystoreType) ? KeyStore.getInstance(keystoreType, keystoreProvider) : KeyStore.getInstance(keystoreType);
        InputStream in = null;
        if ("JKS".equalsIgnoreCase(keystoreType)) {
            URL url = ObjectUtil.getResource(file_name);
            if (url != null) {
                in = url.openStream();
            } else {
                File f = new File(file_name);
                if (!f.exists()) {
                    String name = System.getProperty("user.home") + System.getProperty("file.separator") + file_name;
                    f = new File(name);
                    if (f.exists()) {
                        in = new FileInputStream(f);
                    }
                } else {
                    in = new FileInputStream(f);
                }
            }
            if (in == null) {
                throw new IOException("Unable to find keystore file " + file_name);
            }
        }
        if ("WINDOWS-MY".equalsIgnoreCase(keystoreType)) {
            storepass = null;
        }
        ks.load(in, storepass);
        if (in != null) {
            in.close();
        }
        return ks;
    }
}

