/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa.gui.beans;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ConsolePanel
extends Panel
implements ActionListener {
    private static int ROW_BUFFER = 256;
    private int rowCount = 0;
    private Panel ivjButtonPanel = null;
    private FlowLayout ivjButtonPanelFlowLayout = null;
    private Button ivjClearButton = null;
    private TextArea ivjConsole = null;
    private Button ivjHideButton = null;
    private Button ivjShowButton = null;
    private BorderLayout ivjConsolePanelBorderLayout = null;
    private Panel ivjLeftPanel = null;
    private Panel ivjRightPanel = null;

    public ConsolePanel() {
        this.initialize();
    }

    public ConsolePanel(LayoutManager layout) {
        super(layout);
    }

    private void _actionHideConsole() {
        int height = this.getBounds().height;
        this.remove(this.getConsole());
        this.getButtonPanel().remove(this.getHideButton());
        this.getButtonPanel().remove(this.getClearButton());
        this.getButtonPanel().add((Component)this.getShowButton(), this.getShowButton().getName());
        Container c = this;
        while ((c = c.getParent()) != null && !(c instanceof Frame)) {
        }
        c.setSize(c.getBounds().width, c.getBounds().height - height + 33);
        ((Component)c).validate();
    }

    private void _actionShowConsole() {
        this.add((Component)this.getConsole(), "Center");
        this.getButtonPanel().remove(this.getShowButton());
        this.getButtonPanel().add((Component)this.getHideButton(), this.getHideButton().getName());
        this.getButtonPanel().add((Component)this.getClearButton(), this.getClearButton().getName());
        Container c = this;
        while ((c = c.getParent()) != null && !(c instanceof Frame)) {
        }
        c.setSize(c.getBounds().width, c.getBounds().height + 100);
        ((Component)c).validate();
    }

    public synchronized void _printMessage(String text) {
        if (this.rowCount++ > ROW_BUFFER) {
            this.getConsole().setText("");
            this.rowCount = 1;
        }
        this.getConsole().append(text + "\n");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getClearButton()) {
            this.connEtoM1(e);
        }
        if (e.getSource() == this.getHideButton()) {
            this.connEtoC1(e);
        }
        if (e.getSource() == this.getShowButton()) {
            this.connEtoC2(e);
        }
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this._actionHideConsole();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this._actionShowConsole();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM1(ActionEvent arg1) {
        try {
            this.getConsole().setText("");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private Panel getButtonPanel() {
        if (this.ivjButtonPanel == null) {
            try {
                this.ivjButtonPanel = new Panel();
                this.ivjButtonPanel.setName("ButtonPanel");
                this.ivjButtonPanel.setLayout(this.getButtonPanelFlowLayout());
                this.getButtonPanel().add((Component)this.getHideButton(), this.getHideButton().getName());
                this.getButtonPanel().add((Component)this.getClearButton(), this.getClearButton().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonPanel;
    }

    private FlowLayout getButtonPanelFlowLayout() {
        FlowLayout ivjButtonPanelFlowLayout = null;
        try {
            ivjButtonPanelFlowLayout = new FlowLayout();
            ivjButtonPanelFlowLayout.setAlignment(0);
            ivjButtonPanelFlowLayout.setVgap(5);
            ivjButtonPanelFlowLayout.setHgap(10);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjButtonPanelFlowLayout;
    }

    private Button getClearButton() {
        if (this.ivjClearButton == null) {
            try {
                this.ivjClearButton = new Button();
                this.ivjClearButton.setName("ClearButton");
                this.ivjClearButton.setLabel("        Clear        ");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjClearButton;
    }

    private TextArea getConsole() {
        if (this.ivjConsole == null) {
            try {
                this.ivjConsole = new TextArea();
                this.ivjConsole.setName("Console");
                this.ivjConsole.setFont(new Font("dialog", 0, 10));
                this.ivjConsole.setBackground(SystemColor.window);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjConsole;
    }

    private BorderLayout getConsolePanelBorderLayout() {
        BorderLayout ivjConsolePanelBorderLayout = null;
        try {
            ivjConsolePanelBorderLayout = new BorderLayout();
            ivjConsolePanelBorderLayout.setVgap(0);
            ivjConsolePanelBorderLayout.setHgap(10);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjConsolePanelBorderLayout;
    }

    private Button getHideButton() {
        if (this.ivjHideButton == null) {
            try {
                this.ivjHideButton = new Button();
                this.ivjHideButton.setName("HideButton");
                this.ivjHideButton.setLabel("Hide Console");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjHideButton;
    }

    private Panel getLeftPanel() {
        if (this.ivjLeftPanel == null) {
            try {
                this.ivjLeftPanel = new Panel();
                this.ivjLeftPanel.setName("LeftPanel");
                this.ivjLeftPanel.setLayout(null);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLeftPanel;
    }

    private Panel getRightPanel() {
        if (this.ivjRightPanel == null) {
            try {
                this.ivjRightPanel = new Panel();
                this.ivjRightPanel.setName("RightPanel");
                this.ivjRightPanel.setLayout(null);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjRightPanel;
    }

    private Button getShowButton() {
        if (this.ivjShowButton == null) {
            try {
                this.ivjShowButton = new Button();
                this.ivjShowButton.setName("ShowButton");
                this.ivjShowButton.setBounds(27, 384, 90, 23);
                this.ivjShowButton.setLabel("Show Console");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjShowButton;
    }

    private void handleException(Throwable exception) {
    }

    private void initConnections() {
        this.getClearButton().addActionListener(this);
        this.getHideButton().addActionListener(this);
        this.getShowButton().addActionListener(this);
    }

    private void initialize() {
        this.setName("ConsolePanel");
        this.setLayout(this.getConsolePanelBorderLayout());
        this.setBackground(SystemColor.control);
        this.setSize(426, 240);
        this.add((Component)this.getButtonPanel(), "South");
        this.add((Component)this.getConsole(), "Center");
        this.add((Component)this.getLeftPanel(), "West");
        this.add((Component)this.getRightPanel(), "East");
        this.initConnections();
        this.remove(this.getConsole());
        this.getButtonPanel().remove(this.getHideButton());
        this.getButtonPanel().remove(this.getClearButton());
        this.getButtonPanel().add((Component)this.getShowButton(), this.getShowButton().getName());
    }

    public static void main(String[] args) {
        try {
            Frame frame;
            try {
                Class<?> aFrameClass = Class.forName("com.ibm.uvm.abt.edit.TestFrame");
                frame = (Frame)aFrameClass.newInstance();
            }
            catch (Throwable ivjExc) {
                frame = new Frame();
            }
            ConsolePanel aConsolePanel = new ConsolePanel();
            frame.add("Center", aConsolePanel);
            frame.setSize(aConsolePanel.getSize());
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of java.awt.Panel");
            exception.printStackTrace(System.out);
        }
    }
}

