/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.rmi.CORBA.ClassDesc;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CodeSet;
import org.jacorb.orb.DataOutputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.EncapsInfo;
import org.jacorb.orb.IBufferManager;
import org.jacorb.orb.IORMutator;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ORBSingleton;
import org.jacorb.orb.TypeCode;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.typecode.DelegatingTypeCodeWriter;
import org.jacorb.orb.typecode.TypeCodeCompactor;
import org.jacorb.util.ObjectUtil;
import org.jacorb.util.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.StringValueHelper;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.WStringValueHelper;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueOutputStream;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedProfile;

public class CDROutputStream
extends org.omg.CORBA_2_3.portable.OutputStream
implements CodeSet.OutputBuffer,
ValueOutputStream {
    private static final IOR null_ior = new IOR("", new TaggedProfile[0]);
    private int index;
    private int pos;
    private final IBufferManager bufMgr;
    protected byte[] buffer;
    private boolean closed;
    private CodeSet codeSet;
    private CodeSet codeSetW;
    private int encaps_start = -1;
    private ArrayDeque<EncapsInfo> encaps_stack;
    private Map valueMap;
    private Map repIdMap;
    private Map codebaseMap;
    private Map repeatedTCMap;
    private Map recursiveTCMap;
    private int chunk_size_tag_pos = -1;
    private int chunk_size_tag_index;
    private int chunk_octets_pos;
    private int valueNestingLevel = 0;
    private int writeValueNestingLevel = 0;
    private boolean writeReplaceCalled = false;
    protected final ORBSingleton orb;
    protected int giop_minor = 2;
    private int chunkingFlag = 0;
    private IORMutator mutator;
    private boolean isMutatorEnabled;
    private boolean codesetEnabled;
    private boolean useBOM = false;
    private boolean chunkCustomRmiValuetypes = false;
    private boolean useIndirection = true;
    private boolean nullStringEncoding;
    private byte maxStreamFormatVersion = 1;
    private final TypeCodeCompactor typeCodeCompactor;
    private static final DelegatingTypeCodeWriter typeCodeWriter = new DelegatingTypeCodeWriter();

    public CDROutputStream(org.omg.CORBA.ORB orb, int bufferSize) {
        if (!(orb instanceof ORBSingleton)) {
            throw new BAD_PARAM("don't pass in a non JacORB ORB");
        }
        this.orb = (ORBSingleton)orb;
        this.bufMgr = this.orb.getBufferManager();
        this.typeCodeCompactor = this.orb.getTypeCodeCompactor();
        try {
            this.configure(((ORBSingleton)orb).getConfiguration());
        }
        catch (ConfigurationException e) {
            throw new INTERNAL(e.getMessage());
        }
        this.buffer = bufferSize == -1 ? this.bufMgr.getPreferredMemoryBuffer() : this.bufMgr.getBuffer(bufferSize);
    }

    public CDROutputStream(org.omg.CORBA.ORB orb) {
        this(orb, -1);
    }

    public CDROutputStream() {
        this(org.omg.CORBA.ORBSingleton.init());
    }

    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    private void configure(Configuration configuration) throws ConfigurationException {
        this.codesetEnabled = configuration.getAttributeAsBoolean("jacorb.codeset", true);
        this.useBOM = configuration.getAttributeAsBoolean("jacorb.use_bom", false);
        this.chunkCustomRmiValuetypes = configuration.getAttributeAsBoolean("jacorb.interop.chunk_custom_rmi_valuetypes", false);
        this.useIndirection = !configuration.getAttributeAsBoolean("jacorb.interop.indirection_encoding_disable", false);
        this.nullStringEncoding = configuration.getAttributeAsBoolean("jacorb.interop.null_string_encoding", false);
        this.mutator = (IORMutator)configuration.getAttributeAsObject("jacorb.iormutator");
        this.isMutatorEnabled = this.mutator != null;
        this.maxStreamFormatVersion = (byte)configuration.getAttributeAsInteger("jacorb.interop.maximum_stream_format_version", 1);
        this.codeSet = this.orb.getTCSDefault();
        this.codeSetW = this.orb.getTCSWDefault();
    }

    private ArrayDeque<EncapsInfo> getEncapsStack() {
        if (this.encaps_stack == null) {
            this.encaps_stack = new ArrayDeque();
        }
        return this.encaps_stack;
    }

    private Map<Serializable, Integer> getValueMap() {
        if (this.valueMap == null) {
            this.valueMap = new IdentityHashMap();
        }
        return this.valueMap;
    }

    private Map<String, Integer> getRepIdMap() {
        if (this.repIdMap == null) {
            this.repIdMap = new HashMap();
        }
        return this.repIdMap;
    }

    private Map<String, Integer> getCodebaseMap() {
        if (this.codebaseMap == null) {
            this.codebaseMap = new HashMap();
        }
        return this.codebaseMap;
    }

    public void write(OutputStream out, int start, int length) throws IOException {
        if (start < start + length) {
            out.write(this.buffer, start, length);
        }
    }

    public void setCodeSets(CodeSet codeSet, CodeSet codeSetWide) {
        this.codeSet = codeSet;
        this.codeSetW = codeSetWide;
    }

    public void setGIOPMinor(int giop_minor) {
        this.giop_minor = giop_minor;
    }

    public int getGIOPMinor() {
        return this.giop_minor;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.bufMgr.returnBuffer(this.buffer, true);
        this.buffer = null;
        this.closed = true;
    }

    public final void check(int i, int align) {
        int remainder = align - this.index % align;
        this.check(i + remainder);
        if (remainder != align) {
            int blp = this.buffer.length - this.pos;
            int topad = blp <= 8 ? blp : 8;
            Arrays.fill(this.buffer, this.pos, this.pos + topad, (byte)0);
            this.index += remainder;
            this.pos += remainder;
        }
    }

    private final void check(int i) {
        int requiredSize = this.pos + i + 2;
        if (this.buffer == null || requiredSize > this.buffer.length) {
            byte[] new_buf = this.bufMgr.getExpandedBuffer(requiredSize);
            if (this.buffer != null) {
                System.arraycopy(this.buffer, 0, new_buf, 0, this.pos);
            }
            this.bufMgr.returnBuffer(this.buffer, true);
            this.buffer = new_buf;
        }
    }

    private static final void _write4int(byte[] buf, int _pos, int value) {
        buf[_pos] = (byte)(value >> 24 & 0xFF);
        buf[_pos + 1] = (byte)(value >> 16 & 0xFF);
        buf[_pos + 2] = (byte)(value >> 8 & 0xFF);
        buf[_pos + 3] = (byte)(value & 0xFF);
    }

    public final void beginEncapsulation() {
        this.check(8, 4);
        this.pos += 4;
        this.index += 4;
        this.getEncapsStack().push(new EncapsInfo(this.index, this.encaps_start, this.getValueMap(), this.getRepIdMap(), this.getCodebaseMap()));
        this.valueMap = new IdentityHashMap();
        this.repIdMap = new HashMap();
        this.codebaseMap = new HashMap();
        this.encaps_start = this.pos;
        this.beginEncapsulatedArray();
    }

    public final void beginEncapsulatedArray() {
        this.index = 0;
        this.buffer[this.pos++] = 0;
        ++this.index;
    }

    public final void endEncapsulation() {
        if (this.encaps_start == -1) {
            throw new MARSHAL("Too many end-of-encapsulations");
        }
        if (this.encaps_stack == null) {
            throw new MARSHAL("Internal Error - closeEncapsulation failed");
        }
        int encaps_size = this.pos - this.encaps_start;
        this.buffer[this.encaps_start - 4] = (byte)(encaps_size >>> 24 & 0xFF);
        this.buffer[this.encaps_start - 3] = (byte)(encaps_size >>> 16 & 0xFF);
        this.buffer[this.encaps_start - 2] = (byte)(encaps_size >>> 8 & 0xFF);
        this.buffer[this.encaps_start - 1] = (byte)(encaps_size & 0xFF);
        EncapsInfo ei = this.getEncapsStack().pop();
        this.encaps_start = ei.start;
        this.index = ei.index + encaps_size;
        this.valueMap = ei.valueMap;
        this.repIdMap = ei.repIdMap;
        this.codebaseMap = ei.codebaseMap;
    }

    public byte[] getBufferCopy() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(this.size());
        try {
            this.write(bos, 0, this.size());
        }
        catch (IOException e) {
            throw new INTERNAL("should not happen: " + e.toString());
        }
        return bos.toByteArray();
    }

    public int size() {
        return this.pos;
    }

    public final void skip(int step) {
        this.pos += step;
        this.index += step;
    }

    public final void reduceSize(int amount) {
        this.pos -= amount;
    }

    public final void increaseSize(int amount) {
        this.check(amount);
        this.pos += amount;
    }

    public void setBuffer(byte[] b) {
        this.bufMgr.returnBuffer(this.buffer, true);
        this.buffer = b;
        this.pos = 0;
        this.index = 0;
    }

    public byte[] releaseBuffer() {
        byte[] retn = this.buffer;
        this.buffer = null;
        this.close();
        return retn;
    }

    public org.omg.CORBA.portable.InputStream create_input_stream() {
        byte[] result = new byte[this.index];
        System.arraycopy(this.buffer, 0, result, 0, result.length);
        return new CDRInputStream((org.omg.CORBA.ORB)this.orb, result);
    }

    public final void write_any(Any value) {
        if (value == null) {
            throw new MARSHAL("Cannot marshall null value.");
        }
        this.write_TypeCode(value.type());
        value.write_value((org.omg.CORBA.portable.OutputStream)this);
    }

    public final void write_boolean(boolean value) {
        this.check(1);
        this.buffer[this.pos++] = value ? (byte)1 : 0;
        ++this.index;
    }

    public final void write_boolean_array(boolean[] value, int offset, int length) {
        if (value != null) {
            this.check(length);
            for (int i = offset; i < offset + length; ++i) {
                this.buffer[this.pos++] = value[i] ? (byte)1 : 0;
            }
            this.index += length;
        }
    }

    public final void write_char(char c) {
        if (c > '\u00ff') {
            throw new DATA_CONVERSION("Char " + c + " out of range");
        }
        this.check(1);
        this.buffer[this.pos++] = (byte)c;
        ++this.index;
    }

    public final void write_char_array(char[] value, int offset, int length) {
        if (value == null) {
            throw new MARSHAL("Cannot marshall null array.");
        }
        if (offset + length > value.length || length < 0 || offset < 0) {
            throw new MARSHAL("Cannot marshall as indices for array are out bounds.");
        }
        this.check(length);
        for (int i = offset; i < length + offset; ++i) {
            if (value[i] > '\u00ff') {
                throw new DATA_CONVERSION("Char " + value[i] + " out of range");
            }
            this.buffer[this.pos++] = (byte)value[i];
        }
        this.index += length;
    }

    public final void write_string(String value) {
        if (value == null) {
            if (this.nullStringEncoding) {
                this.write_long(0);
                return;
            }
            throw new MARSHAL("Cannot marshall null string.");
        }
        int valueLength = value.length();
        if (valueLength == 0) {
            this.write_long(1);
            this.write_octet((byte)0);
        } else {
            int size = this.codesetEnabled ? 4 + 4 * valueLength + 1 : 4 + valueLength + 1;
            this.check(size, 4);
            int sizePosition = this.pos;
            this.pos += 4;
            this.index += 4;
            if (this.codesetEnabled) {
                this.codeSet.write_string(this, value, false, false, this.giop_minor);
            } else {
                value.getBytes(0, valueLength, this.buffer, this.pos);
                this.index += valueLength;
                this.pos += valueLength;
            }
            this.buffer[this.pos++] = 0;
            ++this.index;
            size = this.pos - (sizePosition + 4);
            CDROutputStream._write4int(this.buffer, sizePosition, size);
        }
    }

    public final void write_wchar(char c) {
        this.check(6);
        this.codeSetW.write_char(this, c, this.codeSetW.write_bom(this.useBOM), true, this.giop_minor);
    }

    @Override
    public void write_byte(byte b) {
        this.buffer[this.pos++] = b;
        ++this.index;
    }

    public final void write_wchar_array(char[] value, int offset, int length) {
        if (value == null) {
            throw new MARSHAL("Null References");
        }
        this.check(length * 3);
        for (int i = offset; i < offset + length; ++i) {
            this.write_wchar(value[i]);
        }
    }

    public final void write_wstring(String s) {
        int str_size;
        if (s == null) {
            throw new MARSHAL("Null References");
        }
        this.check(4 + s.length() * 3 + 3, 4);
        int startPos = this.pos;
        this.pos += 4;
        this.index += 4;
        if (this.giop_minor == 2 && this.codeSetW.write_bom(this.useBOM) && s.length() > 0) {
            this.buffer[this.pos++] = -2;
            this.buffer[this.pos++] = -1;
            this.index += 2;
        }
        for (int i = 0; i < s.length(); ++i) {
            this.codeSetW.write_char(this, s.charAt(i), false, false, this.giop_minor);
        }
        if (this.giop_minor >= 2) {
            str_size = this.pos - startPos - 4;
        } else {
            this.codeSetW.write_char(this, '\u0000', false, false, this.giop_minor);
            str_size = this.codeSetW.get_wstring_size(s, startPos, this.pos);
        }
        CDROutputStream._write4int(this.buffer, startPos, str_size);
    }

    public final void write_double(double value) {
        this.write_longlong(Double.doubleToLongBits(value));
    }

    public final void write_double_array(double[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.check(7 + length * 8, 8);
        if (value != null) {
            for (int i = offset; i < offset + length; ++i) {
                long d = Double.doubleToLongBits(value[i]);
                this.buffer[this.pos] = (byte)(d >>> 56 & 0xFFL);
                this.buffer[this.pos + 1] = (byte)(d >>> 48 & 0xFFL);
                this.buffer[this.pos + 2] = (byte)(d >>> 40 & 0xFFL);
                this.buffer[this.pos + 3] = (byte)(d >>> 32 & 0xFFL);
                this.buffer[this.pos + 4] = (byte)(d >>> 24 & 0xFFL);
                this.buffer[this.pos + 5] = (byte)(d >>> 16 & 0xFFL);
                this.buffer[this.pos + 6] = (byte)(d >>> 8 & 0xFFL);
                this.buffer[this.pos + 7] = (byte)(d & 0xFFL);
                this.pos += 8;
            }
            this.index += 8 * length;
        }
    }

    public void write_fixed(BigDecimal value, short digits, short scale) {
        int b;
        byte[] representation;
        String v = value.unscaledValue().toString();
        if (v.startsWith("-")) {
            v = v.substring(1);
        }
        if (v.length() % 2 == 0) {
            representation = new byte[v.length() / 2 + 1];
            representation[0] = 0;
            for (int i = 0; i < v.length(); ++i) {
                int c = Character.digit(v.charAt(i), 10);
                b = representation[(1 + i) / 2] << 4;
                representation[(1 + i) / 2] = (byte)(b |= c);
            }
        } else {
            representation = new byte[(v.length() + 1) / 2];
            for (int i = 0; i < v.length(); ++i) {
                int c = Character.digit(v.charAt(i), 10);
                b = representation[i / 2] << 4;
                representation[i / 2] = (byte)(b |= c);
            }
        }
        b = representation[representation.length - 1] << 4;
        representation[representation.length - 1] = (byte)(value.signum() < 0 ? b | 0xD : b | 0xC);
        this.check(representation.length);
        System.arraycopy(representation, 0, this.buffer, this.pos, representation.length);
        this.index += representation.length;
        this.pos += representation.length;
    }

    @Deprecated
    public void write_fixed(BigDecimal value) {
        this.write_fixed(value, (short)-1, (short)-1);
    }

    public final void write_float(float value) {
        this.write_long(Float.floatToIntBits(value));
    }

    public final void write_float_array(float[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.check(3 + length * 4, 4);
        if (value != null) {
            for (int i = offset; i < offset + length; ++i) {
                CDROutputStream._write4int(this.buffer, this.pos, Float.floatToIntBits(value[i]));
                this.pos += 4;
            }
            this.index += 4 * length;
        }
    }

    public final void write_long(int value) {
        this.check(7, 4);
        CDROutputStream._write4int(this.buffer, this.pos, value);
        this.pos += 4;
        this.index += 4;
    }

    public final void write_long_array(int[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.check(3 + length * 4, 4);
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        if (value != null) {
            for (int i = offset; i < offset + length; ++i) {
                CDROutputStream._write4int(this.buffer, this.pos, value[i]);
                this.pos += 4;
            }
            this.index += 4 * length;
        }
    }

    public final void write_longlong(long value) {
        this.check(15, 8);
        this.buffer[this.pos] = (byte)(value >>> 56 & 0xFFL);
        this.buffer[this.pos + 1] = (byte)(value >>> 48 & 0xFFL);
        this.buffer[this.pos + 2] = (byte)(value >>> 40 & 0xFFL);
        this.buffer[this.pos + 3] = (byte)(value >>> 32 & 0xFFL);
        this.buffer[this.pos + 4] = (byte)(value >>> 24 & 0xFFL);
        this.buffer[this.pos + 5] = (byte)(value >>> 16 & 0xFFL);
        this.buffer[this.pos + 6] = (byte)(value >>> 8 & 0xFFL);
        this.buffer[this.pos + 7] = (byte)(value & 0xFFL);
        this.index += 8;
        this.pos += 8;
    }

    public final void write_longlong_array(long[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.check(7 + length * 8, 8);
        if (value != null) {
            for (int i = offset; i < offset + length; ++i) {
                this.buffer[this.pos] = (byte)(value[i] >>> 56 & 0xFFL);
                this.buffer[this.pos + 1] = (byte)(value[i] >>> 48 & 0xFFL);
                this.buffer[this.pos + 2] = (byte)(value[i] >>> 40 & 0xFFL);
                this.buffer[this.pos + 3] = (byte)(value[i] >>> 32 & 0xFFL);
                this.buffer[this.pos + 4] = (byte)(value[i] >>> 24 & 0xFFL);
                this.buffer[this.pos + 5] = (byte)(value[i] >>> 16 & 0xFFL);
                this.buffer[this.pos + 6] = (byte)(value[i] >>> 8 & 0xFFL);
                this.buffer[this.pos + 7] = (byte)(value[i] & 0xFFL);
                this.pos += 8;
            }
            this.index += 8 * length;
        }
    }

    public void write_Object(Object value) {
        if (value == null) {
            IORHelper.write((org.omg.CORBA.portable.OutputStream)this, (IOR)null_ior);
        } else {
            if (value instanceof LocalObject) {
                throw new MARSHAL("Attempt to serialize a locality-constrained object.");
            }
            ObjectImpl obj = (ObjectImpl)value;
            IOR intermediary = ((Delegate)obj._get_delegate()).getIOR();
            if (this.isMutatorEnabled) {
                intermediary = this.mutator.mutateOutgoing(intermediary);
            }
            IORHelper.write((org.omg.CORBA.portable.OutputStream)this, (IOR)intermediary);
        }
    }

    public void write_IOR(IOR ior) {
        if (ior == null) {
            IORHelper.write((org.omg.CORBA.portable.OutputStream)this, (IOR)null_ior);
        } else {
            IORHelper.write((org.omg.CORBA.portable.OutputStream)this, (IOR)ior);
        }
    }

    public final void write_octet(byte value) {
        this.check(1);
        ++this.index;
        this.buffer[this.pos++] = value;
    }

    @Override
    public final void write_octet_array(byte[] value, int offset, int length) {
        if (value != null) {
            this.check(length);
            System.arraycopy(value, offset, this.buffer, this.pos, length);
            this.index += length;
            this.pos += length;
        }
    }

    public final void write_Principal(Principal value) {
        throw new NO_IMPLEMENT("Principal deprecated");
    }

    @Override
    public final void write_short(short value) {
        this.check(3, 2);
        this.buffer[this.pos++] = (byte)(value >> 8 & 0xFF);
        this.buffer[this.pos++] = (byte)(value & 0xFF);
        this.index += 2;
    }

    public final void write_short_array(short[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.check(2 * length + 3);
        int remainder = 2 - this.index % 2;
        if (remainder != 2) {
            this.index += remainder;
            this.pos += remainder;
        }
        if (value != null) {
            for (int i = offset; i < offset + length; ++i) {
                this.buffer[this.pos++] = (byte)(value[i] >> 8 & 0xFF);
                this.buffer[this.pos++] = (byte)(value[i] & 0xFF);
            }
            this.index += 2 * length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write_TypeCode(org.omg.CORBA.TypeCode typeCode) {
        if (typeCode == null) {
            throw new BAD_PARAM("TypeCode is null");
        }
        typeCode = this.typeCodeCompactor.getCompactTypeCode(typeCode);
        if (this.repeatedTCMap == null) {
            this.repeatedTCMap = new HashMap();
        }
        if (this.recursiveTCMap == null) {
            this.recursiveTCMap = new HashMap();
        }
        try {
            this.write_TypeCode(typeCode, this.recursiveTCMap, this.repeatedTCMap);
        }
        finally {
            this.repeatedTCMap.clear();
            this.recursiveTCMap.clear();
        }
    }

    public final void write_TypeCode(org.omg.CORBA.TypeCode typeCode, Map recursiveTCMap, Map repeatedTCMap) {
        typeCodeWriter.writeTypeCode(typeCode, this, recursiveTCMap, repeatedTCMap);
    }

    public final void write_ulong(int value) {
        this.write_long(value);
    }

    public final void write_ulong_array(int[] value, int offset, int length) {
        this.write_long_array(value, offset, length);
    }

    public final void write_ulonglong(long value) {
        this.write_longlong(value);
    }

    public final void write_ulonglong_array(long[] value, int offset, int length) {
        this.write_longlong_array(value, offset, length);
    }

    public final void write_ushort(short value) {
        this.write_short(value);
    }

    public final void write_ushort_array(short[] value, int offset, int length) {
        this.write_short_array(value, offset, length);
    }

    public final void write_value(org.omg.CORBA.TypeCode typeCode, org.omg.CORBA.portable.InputStream input) {
        if (typeCode == null) {
            throw new BAD_PARAM("TypeCode is null");
        }
        int kind = typeCode.kind().value();
        try {
            switch (kind) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    this.write_short(input.read_short());
                    break;
                }
                case 3: {
                    this.write_long(input.read_long());
                    break;
                }
                case 4: {
                    this.write_ushort(input.read_ushort());
                    break;
                }
                case 5: {
                    this.write_ulong(input.read_ulong());
                    break;
                }
                case 6: {
                    this.write_float(input.read_float());
                    break;
                }
                case 7: {
                    this.write_double(input.read_double());
                    break;
                }
                case 8: {
                    this.write_boolean(input.read_boolean());
                    break;
                }
                case 9: {
                    this.write_char(input.read_char());
                    break;
                }
                case 10: {
                    this.write_octet(input.read_octet());
                    break;
                }
                case 11: {
                    this.write_any(input.read_any());
                    break;
                }
                case 12: {
                    this.write_TypeCode(input.read_TypeCode());
                    break;
                }
                case 13: {
                    throw new NO_IMPLEMENT("Principal deprecated");
                }
                case 14: {
                    this.write_Object(input.read_Object());
                    break;
                }
                case 15: {
                    for (int i = 0; i < typeCode.member_count(); ++i) {
                        this.write_value(typeCode.member_type(i), input);
                    }
                    break;
                }
                case 16: {
                    org.omg.CORBA.TypeCode disc = typeCode.discriminator_type();
                    disc = TypeCode.originalType(disc);
                    int def_idx = typeCode.default_index();
                    int member_idx = -1;
                    block33 : switch (disc.kind().value()) {
                        case 2: {
                            short s = input.read_short();
                            this.write_short(s);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == def_idx || s != typeCode.member_label(i).extract_short()) continue;
                                member_idx = i;
                                break block33;
                            }
                            break;
                        }
                        case 3: {
                            int s = input.read_long();
                            this.write_long(s);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == def_idx || s != typeCode.member_label(i).extract_long()) continue;
                                member_idx = i;
                                break block33;
                            }
                            break;
                        }
                        case 4: {
                            short s = input.read_ushort();
                            this.write_ushort(s);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == def_idx || s != typeCode.member_label(i).extract_ushort()) continue;
                                member_idx = i;
                                break block33;
                            }
                            break;
                        }
                        case 5: {
                            int s = input.read_ulong();
                            this.write_ulong(s);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == def_idx || s != typeCode.member_label(i).extract_ulong()) continue;
                                member_idx = i;
                                break block33;
                            }
                            break;
                        }
                        case 6: 
                        case 7: {
                            throw new MARSHAL("Invalid union discriminator type: " + disc);
                        }
                        case 8: {
                            boolean s = input.read_boolean();
                            this.write_boolean(s);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == def_idx || s != typeCode.member_label(i).extract_boolean()) continue;
                                member_idx = i;
                                break block33;
                            }
                            break;
                        }
                        case 9: {
                            char s = input.read_char();
                            this.write_char(s);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == def_idx || s != typeCode.member_label(i).extract_char()) continue;
                                member_idx = i;
                                break block33;
                            }
                            break;
                        }
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: {
                            throw new MARSHAL("Invalid union discriminator type: " + disc);
                        }
                        case 17: {
                            int s = input.read_long();
                            this.write_long(s);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                int label;
                                if (i == def_idx || s != (label = typeCode.member_label(i).create_input_stream().read_long())) continue;
                                member_idx = i;
                                break block33;
                            }
                            break;
                        }
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: {
                            throw new MARSHAL("Invalid union discriminator type: " + disc);
                        }
                        case 23: {
                            long s = input.read_longlong();
                            this.write_longlong(s);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == def_idx || s != typeCode.member_label(i).extract_longlong()) continue;
                                member_idx = i;
                                break block33;
                            }
                            break;
                        }
                        case 24: {
                            long s = input.read_ulonglong();
                            this.write_ulonglong(s);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == def_idx || s != typeCode.member_label(i).extract_ulonglong()) continue;
                                member_idx = i;
                                break block33;
                            }
                            break;
                        }
                        default: {
                            throw new MARSHAL("Invalid union discriminator type: " + disc);
                        }
                    }
                    if (member_idx != -1) {
                        this.write_value(typeCode.member_type(member_idx), input);
                        break;
                    }
                    if (def_idx != -1) {
                        this.write_value(typeCode.member_type(def_idx), input);
                    }
                    break;
                }
                case 17: {
                    this.write_long(input.read_long());
                    break;
                }
                case 18: {
                    this.write_string(input.read_string());
                    break;
                }
                case 19: {
                    int len = input.read_long();
                    this.write_long(len);
                    org.omg.CORBA.TypeCode content_tc = typeCode.content_type();
                    for (int i = 0; i < len; ++i) {
                        this.write_value(content_tc, input);
                    }
                    break;
                }
                case 20: {
                    int length = typeCode.length();
                    if (typeCode.content_type().kind().value() == 10) {
                        this.check(length);
                        input.read_octet_array(this.buffer, this.pos, length);
                        this.index += length;
                        this.pos += length;
                        break;
                    }
                    for (int i = 0; i < length; ++i) {
                        this.write_value(typeCode.content_type(), input);
                    }
                    break;
                }
                case 21: {
                    this.write_value(typeCode.content_type(), input);
                    break;
                }
                case 22: {
                    this.write_string(input.read_string());
                    for (int i = 0; i < typeCode.member_count(); ++i) {
                        this.write_value(typeCode.member_type(i), input);
                    }
                    break;
                }
                case 23: {
                    this.write_longlong(input.read_longlong());
                    break;
                }
                case 24: {
                    this.write_ulonglong(input.read_ulonglong());
                    break;
                }
                case 25: {
                    throw new BAD_TYPECODE("type longdouble not supported in java");
                }
                case 26: {
                    this.write_wchar(input.read_wchar());
                    break;
                }
                case 27: {
                    this.write_wstring(input.read_wstring());
                    break;
                }
                case 28: {
                    short digits = typeCode.fixed_digits();
                    short scale = typeCode.fixed_scale();
                    BigDecimal value = input instanceof CDRInputStream ? ((CDRInputStream)input).read_fixed(digits, scale) : input.read_fixed();
                    this.write_fixed(value, digits, scale);
                    break;
                }
                case 29: {
                    Serializable val = ((InputStream)input).read_value();
                    this.write_value(val, typeCode.id());
                    break;
                }
                case 30: {
                    String id = typeCode.id();
                    BoxedValueHelper helper = ((ORB)this.orb()).getBoxedValueHelper(id);
                    if (helper == null) {
                        throw new MARSHAL("No BoxedValueHelper for id " + id);
                    }
                    Serializable value = ((InputStream)input).read_value(helper);
                    this.write_value(value, helper);
                    break;
                }
                default: {
                    throw new MARSHAL("Cannot handle TypeCode with kind " + kind);
                }
            }
        }
        catch (BadKind ex) {
            throw new MARSHAL("When processing TypeCode with kind: " + kind + " caught " + (java.lang.Object)((java.lang.Object)ex));
        }
        catch (Bounds ex) {
            throw new MARSHAL("When processing TypeCode with kind: " + kind + " caught " + (java.lang.Object)((java.lang.Object)ex));
        }
    }

    public void write_value(Serializable value) {
        if (!this.write_special_value(value)) {
            this.write_value_internal(value, ValueHandler.getRMIRepositoryID(value.getClass()));
        }
    }

    public void write_value(Serializable value, BoxedValueHelper factory) {
        if (!this.write_special_value(value)) {
            this.write_previous_chunk_size();
            this.check(7, 4);
            this.getValueMap().put(value, this.size());
            if (value instanceof IDLEntity || this.isSimpleString(value, factory)) {
                this.write_long(0x7FFFFF00 | this.chunkingFlag);
            } else {
                this.write_long(0x7FFFFF02 | this.chunkingFlag);
                String repId = factory.get_id();
                this.write_repository_id(repId);
            }
            this.start_chunk();
            factory.write_value((org.omg.CORBA.portable.OutputStream)this, value);
            this.end_chunk();
        }
    }

    private boolean isSimpleString(Serializable value, BoxedValueHelper factory) {
        if (!(value instanceof String)) {
            return false;
        }
        if (factory.get_id().equals(StringValueHelper.id())) {
            return false;
        }
        return !factory.get_id().equals(WStringValueHelper.id());
    }

    public void write_value(Serializable value, Class clazz) {
        if (!this.write_special_value(value)) {
            Class<?> _clazz = value.getClass();
            String repId = ValueHandler.getRMIRepositoryID(_clazz);
            if (_clazz == clazz && !repId.startsWith("RMI:")) {
                this.write_value_internal(value, null);
            } else if (clazz.isInstance(value)) {
                this.write_value_internal(value, repId);
            } else {
                throw new BAD_PARAM();
            }
        }
    }

    public void write_value(Serializable value, String repository_id) {
        if (!this.write_special_value(value)) {
            this.write_value_internal(value, repository_id);
        }
    }

    private boolean write_special_value(Serializable value) {
        if (value == null) {
            this.write_long(0);
            return true;
        }
        Integer index = this.getValueMap().get(value);
        if (index != null) {
            this.write_long(-1);
            this.write_long(index - this.size());
            return true;
        }
        return false;
    }

    private void write_repository_id(String repository_id) {
        Integer _index = this.getRepIdMap().get(repository_id);
        if (_index == null) {
            int remainder = 4 - this.index % 4;
            if (remainder != 4) {
                this.index += remainder;
                this.pos += remainder;
            }
            this.getRepIdMap().put(repository_id, this.size());
            this.write_string(repository_id);
        } else {
            this.write_long(-1);
            this.write_long(_index - this.size());
        }
    }

    private void write_codebase(String codebase) {
        Integer _index = null;
        if (this.codebaseMap == null) {
            this.codebaseMap = new HashMap();
        } else {
            _index = this.getCodebaseMap().get(codebase);
        }
        if (_index == null) {
            int remainder = 4 - this.index % 4;
            if (remainder != 4) {
                this.index += remainder;
                this.pos += remainder;
            }
            this.getCodebaseMap().put(codebase, this.size());
            this.write_string(codebase);
        } else {
            this.write_long(-1);
            this.write_long(_index - this.size());
        }
    }

    private void write_value_header(String[] repository_ids) {
        if (repository_ids != null) {
            if (repository_ids.length > 1) {
                this.chunkingFlag = 8;
                this.write_long(0x7FFFFF06 | this.chunkingFlag);
                this.write_long(repository_ids.length);
                for (int i = 0; i < repository_ids.length; ++i) {
                    this.write_repository_id(repository_ids[i]);
                }
            } else {
                this.write_long(0x7FFFFF02 | this.chunkingFlag);
                this.write_repository_id(repository_ids[0]);
            }
        } else {
            this.write_long(0x7FFFFF00 | this.chunkingFlag);
        }
    }

    private void write_value_header(String[] repository_ids, String codebase) {
        if (codebase != null) {
            if (repository_ids != null) {
                if (repository_ids.length > 1) {
                    this.chunkingFlag = 8;
                    this.write_long(0x7FFFFF07 | this.chunkingFlag);
                    this.write_codebase(codebase);
                    this.write_long(repository_ids.length);
                    for (int i = 0; i < repository_ids.length; ++i) {
                        this.write_repository_id(repository_ids[i]);
                    }
                } else {
                    this.write_long(0x7FFFFF03 | this.chunkingFlag);
                    this.write_codebase(codebase);
                    this.write_repository_id(repository_ids[0]);
                }
            } else {
                this.write_long(0x7FFFFF01 | this.chunkingFlag);
                this.write_codebase(codebase);
            }
        } else {
            this.write_value_header(repository_ids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write_value_internal(Serializable value, String repository_id) {
        this.write_previous_chunk_size();
        this.check(7, 4);
        this.getValueMap().put(value, this.size());
        if (value.getClass() == String.class) {
            String[] stringArray;
            if (repository_id == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = repository_id;
            }
            String[] repository_ids = stringArray;
            this.write_value_header(repository_ids);
            this.start_chunk();
            this.write_wstring((String)((java.lang.Object)value));
            this.end_chunk();
        } else if (value.getClass() == Class.class) {
            String[] repository_ids = new String[]{ValueHandler.getRMIRepositoryID(ClassDesc.class)};
            this.write_value_header(repository_ids);
            this.start_chunk();
            this.write_value((Serializable)((java.lang.Object)ValueHandler.getCodebase((Class)value)));
            this.write_value((Serializable)((java.lang.Object)ValueHandler.getRMIRepositoryID((Class)value)));
            this.end_chunk();
        } else if (value instanceof StreamableValue) {
            StreamableValue streamable = (StreamableValue)value;
            this.write_value_header(streamable._truncatable_ids());
            this.start_chunk();
            ((StreamableValue)value)._write((org.omg.CORBA.portable.OutputStream)this);
            this.end_chunk();
        } else if (value instanceof CustomValue) {
            DataOutputStream outputStream = new DataOutputStream((org.omg.CORBA.portable.OutputStream)this);
            this.write_value_header(((CustomValue)value)._truncatable_ids());
            ((CustomValue)value).marshal((org.omg.CORBA.DataOutputStream)outputStream);
        } else {
            String[] stringArray;
            if (repository_id == null) {
                stringArray = null;
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = repository_id;
            }
            String[] repository_ids = stringArray;
            Class<?> clazz = value.getClass();
            String codebase = ValueHandler.getCodebase(clazz);
            if (value instanceof IDLEntity) {
                Method writeMethod = null;
                if (clazz != Any.class) {
                    String helperClassName = clazz.getName() + "Helper";
                    try {
                        Class<?> helperClass = clazz.getClassLoader() != null ? clazz.getClassLoader().loadClass(helperClassName) : ObjectUtil.classForName(helperClassName);
                        Class[] paramTypes = new Class[]{org.omg.CORBA.portable.OutputStream.class, clazz};
                        writeMethod = helperClass.getMethod("write", paramTypes);
                    }
                    catch (ClassNotFoundException e) {
                        throw new MARSHAL("Error loading class " + helperClassName + ": " + e);
                    }
                    catch (NoSuchMethodException e) {
                        throw new MARSHAL("No write method in helper class " + helperClassName + ": " + e);
                    }
                }
                this.write_value_header(repository_ids, codebase);
                this.start_chunk();
                if (writeMethod == null) {
                    this.write_any((Any)value);
                } else {
                    try {
                        writeMethod.invoke(null, this, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new MARSHAL("Internal error: " + e);
                    }
                    catch (InvocationTargetException e) {
                        throw new MARSHAL("Exception marshaling IDLEntity: " + e.getTargetException());
                    }
                }
                this.end_chunk();
            } else {
                try {
                    ++this.writeValueNestingLevel;
                    if (this.chunkCustomRmiValuetypes && ValueHandler.isCustomMarshaled(clazz)) {
                        this.chunkingFlag = 8;
                    }
                    Serializable newValue = value;
                    if (!this.writeReplaceCalled) {
                        newValue = ValueHandler.writeReplace(value);
                        this.writeReplaceCalled = true;
                    }
                    if (newValue != value) {
                        String[] stringArray4;
                        String new_rep_id = ValueHandler.getRMIRepositoryID(newValue.getClass());
                        if (new_rep_id == null) {
                            stringArray4 = null;
                        } else {
                            String[] stringArray5 = new String[1];
                            stringArray4 = stringArray5;
                            stringArray5[0] = new_rep_id;
                        }
                        repository_ids = stringArray4;
                        clazz = newValue.getClass();
                        codebase = ValueHandler.getCodebase(clazz);
                    }
                    this.write_value_header(repository_ids, codebase);
                    this.start_chunk();
                    if (newValue != value) {
                        Integer index = this.getValueMap().get(newValue);
                        if (index != null) {
                            this.write_long(-1);
                            this.write_long(index - this.size());
                        } else if (newValue instanceof Object) {
                            this.write_Object((Object)newValue);
                        } else {
                            ValueHandler.writeValue((org.omg.CORBA.portable.OutputStream)this, newValue);
                        }
                    } else {
                        ValueHandler.writeValue((org.omg.CORBA.portable.OutputStream)this, value);
                    }
                    this.end_chunk();
                }
                finally {
                    if (--this.writeValueNestingLevel == 0) {
                        this.writeReplaceCalled = false;
                    }
                }
            }
        }
    }

    private void start_chunk() {
        if (this.chunkingFlag > 0) {
            this.write_previous_chunk_size();
            ++this.valueNestingLevel;
            this.skip_chunk_size_tag();
        }
    }

    private void end_chunk() {
        if (this.chunkingFlag > 0) {
            this.write_previous_chunk_size();
            this.write_long(-this.valueNestingLevel);
            if (--this.valueNestingLevel == 0) {
                this.chunkingFlag = 0;
            } else {
                this.skip_chunk_size_tag();
            }
        }
    }

    private void write_previous_chunk_size() {
        if (this.chunk_size_tag_pos != -1) {
            if (this.pos == this.chunk_octets_pos) {
                this.pos = this.chunk_size_tag_pos;
                this.index = this.chunk_size_tag_index;
            } else {
                this.rewrite_long(this.chunk_size_tag_pos, this.chunk_size_tag_index, this.pos - this.chunk_octets_pos);
            }
            this.chunk_size_tag_pos = -1;
        }
    }

    private void skip_chunk_size_tag() {
        this.chunk_size_tag_pos = this.pos;
        this.chunk_size_tag_index = this.index;
        this.write_long(0);
        this.chunk_octets_pos = this.pos;
    }

    private final void rewrite_long(int write_pos, int write_index, int value) {
        int align = 4;
        int remainder = 4 - write_index % 4;
        if (remainder != 4) {
            write_pos += remainder;
        }
        CDROutputStream._write4int(this.buffer, write_pos, value);
    }

    public void write_abstract_interface(java.lang.Object object) {
        if (object instanceof Object) {
            this.write_boolean(true);
            this.write_Object((Object)object);
        } else {
            this.write_boolean(false);
            this.write_value((Serializable)object);
        }
    }

    public void start_value(String rep_id) {
        this.write_value_header(new String[]{rep_id});
        this.start_chunk();
    }

    public void end_value() {
        this.end_chunk();
    }

    public byte getMaximumStreamFormatVersion() {
        return this.maxStreamFormatVersion;
    }

    public void updateMutatorConnection(GIOPConnection connection) {
        if (this.isMutatorEnabled) {
            this.mutator.updateConnection(connection.getTransport());
        }
    }

    public int get_pos() {
        return this.pos;
    }

    public boolean isIndirectionEnabled() {
        return this.useIndirection;
    }
}

