/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jacorb.notification.servant.MessageSupplierDelegate;
import org.omg.CosEventComm.Disconnected;

public class PullMessagesOperation {
    private int pullCounter_;
    private long timeSpentInPull_;
    private int successfulPullCounter_;
    private final MessageSupplierDelegate delegate_;
    private final Semaphore pullSync_ = new Semaphore(1);

    public PullMessagesOperation(MessageSupplierDelegate delegate) {
        this.delegate_ = delegate;
    }

    public void runPull() throws Disconnected {
        if (!this.delegate_.getConnected()) {
            throw new Disconnected();
        }
        if (this.delegate_.isSuspended()) {
            return;
        }
        this.runPullInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPullInternal() throws Disconnected {
        block6: {
            try {
                MessageSupplierDelegate.PullResult _data;
                boolean _acquired = this.pullSync_.tryAcquire(1000L, TimeUnit.MILLISECONDS);
                if (!_acquired) break block6;
                long _now = System.currentTimeMillis();
                try {
                    _data = this.delegate_.pullMessages();
                }
                finally {
                    this.pullSync_.release();
                    this.timeSpentInPull_ += System.currentTimeMillis() - _now;
                }
                ++this.pullCounter_;
                if (_data.success_) {
                    ++this.successfulPullCounter_;
                    this.delegate_.queueMessages(_data);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public int getPullCounter() {
        return this.pullCounter_;
    }

    public int getSuccessfulPullCounter() {
        return this.successfulPullCounter_;
    }

    public long getTimeSpentInPull() {
        return this.timeSpentInPull_;
    }
}

