/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.MessagePushOperation;
import org.jacorb.notification.engine.PushTaskExecutorFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.servant.AbstractProxyPushSupplier;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.notification.servant.ProxyPushSupplierImplMBean;
import org.omg.CORBA.ORB;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosEventComm.PushConsumer;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.ProxyPushSupplierOperations;
import org.omg.CosNotifyChannelAdmin.ProxyPushSupplierPOATie;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class ProxyPushSupplierImpl
extends AbstractProxyPushSupplier
implements ProxyPushSupplierOperations,
ProxyPushSupplierImplMBean {
    private PushConsumer pushConsumer_;
    private long timeSpent_;

    public ProxyPushSupplierImpl(IAdmin admin, ORB orb, POA poa, Configuration conf, TaskProcessor taskProcessor, PushTaskExecutorFactory pushTaskExecutorFactory, OfferManager offerManager, SubscriptionManager subscriptionManager, ConsumerAdmin consumerAdmin) throws ConfigurationException {
        super(admin, orb, poa, conf, taskProcessor, pushTaskExecutorFactory, offerManager, subscriptionManager, consumerAdmin);
    }

    @Override
    public ProxyType MyType() {
        return ProxyType.PUSH_ANY;
    }

    @Override
    public void disconnect_push_supplier() {
        this.destroy();
    }

    @Override
    protected void disconnectClient() {
        this.pushConsumer_.disconnect_push_consumer();
        this.pushConsumer_ = null;
    }

    private boolean deliverMessageWithRetry(Message message) {
        try {
            this.deliverMessageInternal(message);
            return true;
        }
        catch (Exception e) {
            PushAnyOperation _failedOperation = new PushAnyOperation(message);
            this.handleFailedPushOperation(_failedOperation, e);
            return false;
        }
    }

    private void deliverMessageInternal(Message message) throws Disconnected {
        long now = System.currentTimeMillis();
        this.pushConsumer_.push(message.toAny());
        this.timeSpent_ += System.currentTimeMillis() - now;
        this.resetErrorCounter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pushEvent() {
        Message _message = this.getMessageNoBlock();
        if (_message != null) {
            try {
                boolean bl = this.deliverMessageWithRetry(_message);
                return bl;
            }
            finally {
                _message.dispose();
            }
        }
        return false;
    }

    @Override
    public void connect_any_push_consumer(PushConsumer pushConsumer) throws AlreadyConnected {
        this.checkIsNotConnected();
        this.pushConsumer_ = pushConsumer;
        this.connectClient(pushConsumer);
    }

    @Override
    protected void connectionResumed() {
        this.scheduleFlush();
    }

    @Override
    public Servant newServant() {
        return new ProxyPushSupplierPOATie(this);
    }

    @Override
    public long getCost() {
        return this.timeSpent_;
    }

    private class PushAnyOperation
    extends MessagePushOperation {
        public PushAnyOperation(Message message) {
            super(message);
        }

        @Override
        public void invokePush() throws Disconnected {
            ProxyPushSupplierImpl.this.deliverMessageInternal(this.message_);
        }
    }
}

