/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.notification.queue.AbstractBoundedEventQueue;
import org.jacorb.notification.queue.BoundedDeadlineEventQueue;
import org.jacorb.notification.queue.BoundedFifoEventQueue;
import org.jacorb.notification.queue.BoundedPriorityEventQueue;
import org.jacorb.notification.queue.DefaultMessageQueueAdapter;
import org.jacorb.notification.queue.EventQueueOverflowStrategy;
import org.jacorb.notification.queue.MessageQueueAdapter;
import org.jacorb.notification.util.QoSPropertySet;

public class EventQueueFactory
implements Configurable {
    private static final short UNKNOWN_POLICY = Short.MIN_VALUE;
    private static final Map mapOrderPolicyNameToValue;
    private static final Map mapDiscardPolicyNameToValue;
    private String orderPolicy_;
    private String discardPolicy_;

    public EventQueueFactory(Configuration config) throws ConfigurationException {
        this.configure(config);
    }

    public void configure(Configuration conf) throws ConfigurationException {
        try {
            this.setOrderPolicy(conf.getAttribute("jacorb.notification.order_policy", "PriorityOrder"));
            this.setDiscardPolicy(conf.getAttribute("jacorb.notification.discard_policy", "PriorityOrder"));
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Invalid Policy", (Throwable)e);
        }
    }

    private void setDiscardPolicy(String s) {
        String policy = s.toLowerCase().trim();
        if (!mapDiscardPolicyNameToValue.containsKey(policy)) {
            throw new IllegalArgumentException("Invalid DiscardPolicy: " + s);
        }
        this.discardPolicy_ = policy;
    }

    private void setOrderPolicy(String s) {
        String policy = s.toLowerCase().trim();
        if (!mapOrderPolicyNameToValue.containsKey(policy)) {
            throw new IllegalArgumentException("Invalid OrderPolicy: " + s);
        }
        this.orderPolicy_ = policy;
    }

    public MessageQueueAdapter newMessageQueue(QoSPropertySet qosProperties) {
        AbstractBoundedEventQueue queue;
        EventQueueOverflowStrategy _overflowStrategy;
        int maxEventsPerConsumer;
        short shortOrderPolicy = EventQueueFactory.orderPolicyNameToValue(this.orderPolicy_);
        short shortDiscardPolicy = EventQueueFactory.discardPolicyNameToValue(this.discardPolicy_);
        try {
            maxEventsPerConsumer = qosProperties.get("MaxEventsPerConsumer").extract_long();
        }
        catch (Exception e) {
            maxEventsPerConsumer = 100;
        }
        if (qosProperties.containsKey("OrderPolicy")) {
            shortOrderPolicy = qosProperties.get("OrderPolicy").extract_short();
        }
        if (qosProperties.containsKey("DiscardPolicy")) {
            shortDiscardPolicy = qosProperties.get("DiscardPolicy").extract_short();
        }
        switch (shortDiscardPolicy) {
            case 0: 
            case 1: {
                _overflowStrategy = EventQueueOverflowStrategy.FIFO;
                break;
            }
            case 4: {
                _overflowStrategy = EventQueueOverflowStrategy.LIFO;
                break;
            }
            case 2: {
                _overflowStrategy = EventQueueOverflowStrategy.LEAST_PRIORITY;
                break;
            }
            case 3: {
                _overflowStrategy = EventQueueOverflowStrategy.EARLIEST_TIMEOUT;
                break;
            }
            default: {
                throw new IllegalArgumentException("Discardpolicy: " + this.discardPolicy_ + "DiscardPolicyValue: " + shortDiscardPolicy + " unknown");
            }
        }
        switch (shortOrderPolicy) {
            case 0: 
            case 1: {
                queue = new BoundedFifoEventQueue(maxEventsPerConsumer, _overflowStrategy);
                break;
            }
            case 2: {
                queue = new BoundedPriorityEventQueue(maxEventsPerConsumer, _overflowStrategy);
                break;
            }
            case 3: {
                queue = new BoundedDeadlineEventQueue(maxEventsPerConsumer, _overflowStrategy);
                break;
            }
            default: {
                throw new IllegalArgumentException("Orderpolicy: " + this.orderPolicy_ + " OrderPolicyValue: " + shortOrderPolicy + " unknown");
            }
        }
        return new DefaultMessageQueueAdapter(queue);
    }

    private static short orderPolicyNameToValue(String orderPolicyName) {
        if (mapOrderPolicyNameToValue.containsKey(orderPolicyName.toLowerCase())) {
            return (Short)mapOrderPolicyNameToValue.get(orderPolicyName);
        }
        return Short.MIN_VALUE;
    }

    private static short discardPolicyNameToValue(String discardPolicyName) {
        if (mapDiscardPolicyNameToValue.containsKey(discardPolicyName.toLowerCase())) {
            return (Short)mapDiscardPolicyNameToValue.get(discardPolicyName);
        }
        return Short.MIN_VALUE;
    }

    static {
        HashMap<String, Short> orderMap = new HashMap<String, Short>();
        orderMap.put("anyorder", new Short(0));
        orderMap.put("fifoorder", new Short(1));
        orderMap.put("priorityorder", new Short(2));
        orderMap.put("deadlineorder", new Short(3));
        mapOrderPolicyNameToValue = Collections.unmodifiableMap(orderMap);
        HashMap<String, Short> discardMap = new HashMap<String, Short>();
        discardMap.put("anyorder", new Short(0));
        discardMap.put("fifoorder", new Short(1));
        discardMap.put("lifoorder", new Short(4));
        discardMap.put("priorityorder", new Short(2));
        discardMap.put("deadlineorder", new Short(3));
        mapDiscardPolicyNameToValue = Collections.unmodifiableMap(discardMap);
    }
}

