/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.jmx;

import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ReflectionException;
import javax.management.StandardMBean;
import org.jacorb.notification.interfaces.JMXManageable;
import org.jacorb.util.ObjectUtil;

public class BroadcastSupportMBeanDecorator
implements DynamicMBean,
NotificationEmitter {
    private final NotificationBroadcasterSupport broadCaster_ = new NotificationBroadcasterSupport();
    private final DynamicMBean delegate_;
    private final String[] types_;
    private int notificationSequence_ = 0;

    public BroadcastSupportMBeanDecorator(JMXManageable manageable) throws NotCompliantMBeanException, ClassNotFoundException {
        this.types_ = manageable.getJMXNotificationTypes();
        this.delegate_ = new StandardMBean(manageable, this.getManagementInterface(manageable.getClass()));
        manageable.setJMXCallback(new JMXManageable.JMXCallback(){

            @Override
            public void sendJMXNotification(String type, String message) {
                BroadcastSupportMBeanDecorator.this.sendNotification(type, message);
            }

            @Override
            public void sendJMXAttributeChanged(String name, Object oldValue, Object newValue) {
                BroadcastSupportMBeanDecorator.this.sendAttributeChanged(name, oldValue, newValue);
            }

            @Override
            public void sendJMXNotification(String type, String message, Object payload) {
                BroadcastSupportMBeanDecorator.this.sendNotification(type, message, payload);
            }
        });
    }

    private Class getManagementInterface(Class clazz) throws IllegalArgumentException, ClassNotFoundException {
        String managementInterfaceName = clazz.getName() + "MBean";
        if (clazz.getClassLoader() != null) {
            return clazz.getClassLoader().loadClass(managementInterfaceName);
        }
        return ObjectUtil.classForName((String)managementInterfaceName);
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.delegate_.getAttribute(attribute);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        return this.delegate_.getAttributes(attributes);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo _info = this.delegate_.getMBeanInfo();
        if (this.types_ != null && this.types_.length > 0) {
            return new MBeanInfo(_info.getClassName(), _info.getDescription(), _info.getAttributes(), _info.getConstructors(), _info.getOperations(), this.getNotificationInfo());
        }
        return _info;
    }

    @Override
    public Object invoke(String method, Object[] arguments, String[] params) throws MBeanException, ReflectionException {
        return this.delegate_.invoke(method, arguments, params);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.delegate_.setAttribute(attribute);
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return this.delegate_.setAttributes(attributes);
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.broadCaster_.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadCaster_.removeNotificationListener(listener);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(this.types_, Notification.class.getName(), "User Notifications"), new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), "User attribute change notification")};
    }

    public void sendNotification(String type, String message, Object payload) {
        Notification _jmxNotification = new Notification(type, (Object)this, (long)(++this.notificationSequence_), message);
        if (payload != null) {
            _jmxNotification.setUserData(payload);
        }
        this.broadCaster_.sendNotification(_jmxNotification);
    }

    public void sendNotification(String type, String message) {
        Notification _jmxNotification = new Notification(type, (Object)this, (long)(++this.notificationSequence_), message);
        this.broadCaster_.sendNotification(_jmxNotification);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.broadCaster_.removeNotificationListener(listener, filter, handback);
    }

    public void sendAttributeChanged(String name, Object oldValue, Object newValue) {
        this.broadCaster_.sendNotification(new AttributeChangeNotification(this.delegate_, ++this.notificationSequence_, System.currentTimeMillis(), "Attribute value changed", name, oldValue == null ? null : oldValue.getClass().getName(), oldValue, newValue));
    }
}

