/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.collection.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.jacorb.collection.util.ArrayFactory;
import org.jacorb.collection.util.DynArray;

final class DynArrayEnumerator
implements Enumeration {
    Object[] data;
    int count;
    int elementCount;

    DynArrayEnumerator(DynArray da) {
        this.data = ArrayFactory.get_array(da.elementCount);
        this.elementCount = da.elementCount;
        System.arraycopy(da.elementData, 0, this.data, 0, da.elementCount);
        this.count = 0;
    }

    @Override
    public boolean hasMoreElements() {
        return this.count < this.elementCount;
    }

    public Object nextElement() {
        if (this.count < this.elementCount) {
            return this.data[this.count++];
        }
        if (this.data != null) {
            ArrayFactory.free_array(this.data);
        }
        throw new NoSuchElementException("DynArrayEnumerator");
    }

    protected void finalize() {
        if (this.data != null) {
            ArrayFactory.free_array(this.data);
        }
    }
}

