/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.MainPanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultCaret;

public class MainWindow
extends JFrame
implements ActionListener {
    private JTextArea textArea;
    private JButton closeButton;
    private JScrollPane scrollPane;
    private MainWindow mainFrame = this;
    private int execReturnValue = 0;

    public MainWindow(final ArrayList<String> commandList) {
        super("Stdout");
        boolean bTitle = commandList.contains("-t");
        if (bTitle) {
            int titleIndex = commandList.indexOf("-t");
            String windowTitle = commandList.get(titleIndex + 1);
            this.mainFrame.setTitle(windowTitle);
            commandList.remove("-t");
            commandList.remove(windowTitle);
        }
        this.setMinimumSize(new Dimension(400, 375));
        this.setLocation(50, 50);
        URL imgURL = this.getClass().getResource("/resources/bslx-icon.png");
        if (imgURL != null) {
            ImageIcon appIcon = new ImageIcon(imgURL);
            this.setIconImage(appIcon.getImage());
        }
        this.closeButton = new JButton("Close");
        this.closeButton.setEnabled(false);
        this.closeButton.addActionListener(this);
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        DefaultCaret caret = (DefaultCaret)this.textArea.getCaret();
        caret.setUpdatePolicy(2);
        this.scrollPane = new JScrollPane(this.getTextArea());
        this.setDefaultCloseOperation(0);
        Terminator terminator = new Terminator();
        this.addWindowListener(terminator);
        this.addWindowStateListener(terminator);
        while (!this.checkInternetConnection()) {
            int option = JOptionPane.showConfirmDialog(null, "OK to try again. Cancel to exit.", "Networking Issue", 2);
            if (option != 2) continue;
            this.close(1);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainPanel(MainWindow.this.mainFrame, commandList);
            }
        });
        this.setVisible(true);
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public JButton getCloseButton() {
        return this.closeButton;
    }

    protected int getExecReturnValue() {
        return this.execReturnValue;
    }

    public void setExecReturnValue(int rval) {
        this.execReturnValue = rval;
    }

    private boolean checkInternetConnection() {
        boolean bIsConnected = false;
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                if (iface.isLoopback() || !iface.isUp()) continue;
                bIsConnected = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bIsConnected) {
            JOptionPane.showMessageDialog(this, "Unable to establish network connection.", "Error", 0);
        }
        return bIsConnected;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.close(this.getExecReturnValue());
    }

    public void close(int returnval) {
        this.dispose();
        System.exit(returnval);
    }

    private class Terminator
    extends WindowAdapter {
        private Terminator() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            MainWindow.this.close(1);
        }
    }
}

