#!/bin/bash 

# This is a part of the external applet Calendar for Cairo-Dock 
# 
# Copyright : (C) 2009 by Royohboy & Matttbe 
# Edited by Jesuisbenjamin as to fit the Tiheum's Faenza icon theme. 
# E-mail : werbungfuerroy@googlemail.com, matttbe@gmail.com and jesuisbenjamin@gmail.com 
# 
# 
# This program is free software; you can redistribute it and/or 
# modify it under the terms of the GNU General Public License 
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version. 
# 
# This program is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
# GNU General Public License for more details. 
# http://www.gnu.org/licenses/licenses.html#GPL 

ICON_DIR=$1
FORCE=$2
date_TODAY=`date '+%Y%m%d'` 
# get current day and month 
MONTH=$(date +%^b) 
DAY=$(date +%d) 
WDAY=$(date +%A) 

# generate calendar-icon showing current day and month 
make_icon() { 
printf "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?> 
<!-- Created with Inkscape (http://www.inkscape.org/) --> 

<svg 
xmlns:dc=\"http://purl.org/dc/elements/1.1/\" 
xmlns:cc=\"http://creativecommons.org/ns#\" 
xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" 
xmlns:svg=\"http://www.w3.org/2000/svg\" 
xmlns=\"http://www.w3.org/2000/svg\" 
xmlns:xlink=\"http://www.w3.org/1999/xlink\" 
xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\" 
xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" 
version=\"1.0\" 
width=\"96\" 
height=\"96\" 
id=\"svg2408\" 
inkscape:version=\"0.48.0 r9654\" 
sodipodi:docname=\"icon (original).svg\"> 
<sodipodi:namedview 
pagecolor=\"#ffffff\" 
bordercolor=\"#666666\" 
borderopacity=\"1\" 
objecttolerance=\"10\" 
gridtolerance=\"10\" 
guidetolerance=\"10\" 
inkscape:pageopacity=\"0\" 
inkscape:pageshadow=\"2\" 
inkscape:window-width=\"1280\" 
inkscape:window-height=\"752\" 
id=\"namedview96\" 
showgrid=\"false\" 
inkscape:zoom=\"3.2083333\" 
inkscape:cx=\"48\" 
inkscape:cy=\"48\" 
inkscape:window-x=\"0\" 
inkscape:window-y=\"25\" 
inkscape:window-maximized=\"1\" 
inkscape:current-layer=\"svg2408\" /> 
<defs 
id=\"defs2410\"> 
<linearGradient 
id=\"linearGradient3757\"> 
<stop 
id=\"stop3759\" 
style=\"stop-color:#c53636;stop-opacity:1\" 
offset=\"0\" /> 
<stop 
id=\"stop3761\" 
style=\"stop-color:#d42b2b;stop-opacity:1\" 
offset=\"1\" /> 
</linearGradient> 
<linearGradient 
id=\"linearGradient3777\"> 
<stop 
id=\"stop3779\" 
style=\"stop-color:#ffffff;stop-opacity:0\" 
offset=\"0\" /> 
<stop 
id=\"stop3785\" 
style=\"stop-color:#d7d7d7;stop-opacity:1\" 
offset=\"0.50290233\" /> 
<stop 
id=\"stop3781\" 
style=\"stop-color:#cccccc;stop-opacity:1\" 
offset=\"0.76460928\" /> 
<stop 
id=\"stop3787\" 
style=\"stop-color:#d7d7d7;stop-opacity:1\" 
offset=\"0.9122979\" /> 
<stop 
id=\"stop3783\" 
style=\"stop-color:#ffffff;stop-opacity:1\" 
offset=\"1\" /> 
</linearGradient> 
<linearGradient 
x1=\"45.447727\" 
y1=\"92.539597\" 
x2=\"45.447727\" 
y2=\"7.0165396\" 
id=\"ButtonShadow\" 
gradientUnits=\"userSpaceOnUse\" 
gradientTransform=\"scale(1.0058652,0.994169)\"> 
<stop 
id=\"stop3750\" 
style=\"stop-color:#000000;stop-opacity:1\" 
offset=\"0\" /> 
<stop 
id=\"stop3752\" 
style=\"stop-color:#000000;stop-opacity:0.58823532\" 
offset=\"1\" /> 
</linearGradient> 
<linearGradient 
id=\"linearGradient3737\"> 
<stop 
id=\"stop3739\" 
style=\"stop-color:#ffffff;stop-opacity:1\" 
offset=\"0\" /> 
<stop 
id=\"stop3741\" 
style=\"stop-color:#ffffff;stop-opacity:0\" 
offset=\"1\" /> 
</linearGradient> 
<filter 
color-interpolation-filters=\"sRGB\" 
id=\"filter3174\"> 
<feGaussianBlur 
id=\"feGaussianBlur3176\" 
stdDeviation=\"1.71\" /> 
</filter> 
<linearGradient 
x1=\"36.357143\" 
y1=\"6\" 
x2=\"36.357143\" 
y2=\"63.893143\" 
id=\"linearGradient3188\" 
xlink:href=\"#linearGradient3737\" 
gradientUnits=\"userSpaceOnUse\" /> 
<filter 
x=\"-0.192\" 
y=\"-0.192\" 
width=\"1.3839999\" 
height=\"1.3839999\" 
color-interpolation-filters=\"sRGB\" 
id=\"filter3794\"> 
<feGaussianBlur 
id=\"feGaussianBlur3796\" 
stdDeviation=\"5.28\" /> 
</filter> 
<linearGradient 
x1=\"48\" 
y1=\"20.220806\" 
x2=\"48\" 
y2=\"138.66119\" 
id=\"linearGradient3613\" 
xlink:href=\"#linearGradient3737\" 
gradientUnits=\"userSpaceOnUse\" /> 
<radialGradient 
cx=\"48\" 
cy=\"90.171875\" 
r=\"42\" 
fx=\"48\" 
fy=\"90.171875\" 
id=\"radialGradient3619\" 
xlink:href=\"#linearGradient3737\" 
gradientUnits=\"userSpaceOnUse\" 
gradientTransform=\"matrix(1.1573129,0,0,0.99590774,-17.551021,0.19713193)\" /> 
<clipPath 
id=\"clipPath3613\"> 
<rect 
width=\"84\" 
height=\"84\" 
rx=\"6\" 
ry=\"6\" 
x=\"6\" 
y=\"6\" 
id=\"rect3615\" 
style=\"fill:#ffffff;fill-opacity:1;fill-rule:nonzero;stroke:none\" /> 
</clipPath> 
<linearGradient 
x1=\"48\" 
y1=\"90\" 
x2=\"48\" 
y2=\"5.9877172\" 
id=\"linearGradient3617\" 
xlink:href=\"#ButtonColor-0\" 
gradientUnits=\"userSpaceOnUse\" /> 
<linearGradient 
x1=\"38.410439\" 
y1=\"39.834473\" 
x2=\"110.98586\" 
y2=\"112.4099\" 
id=\"linearGradient3185\" 
xlink:href=\"#linearGradient3777\" 
gradientUnits=\"userSpaceOnUse\" 
gradientTransform=\"matrix(0.71186441,0,0,0.71186441,2.44068,2.440678)\" /> 
<linearGradient 
x1=\"58.650177\" 
y1=\"122\" 
x2=\"58.650177\" 
y2=\"5.4252338\" 
id=\"ButtonColor\" 
gradientUnits=\"userSpaceOnUse\" 
gradientTransform=\"matrix(1.0172414,0,0,1.0172414,-1.1034483,-1.1034483)\"> 
<stop 
id=\"stop3189\" 
style=\"stop-color:#e4b31e;stop-opacity:1\" 
offset=\"0\" /> 
<stop 
id=\"stop3191\" 
style=\"stop-color:#ffef64;stop-opacity:1\" 
offset=\"1\" /> 
</linearGradient> 
<clipPath 
id=\"clipPath3800\"> 
<path 
d=\"m 62,6 c -3.324,0 -6,2.676 -6,6 l 0,0.53125 C 56,8.9207 58.9207,6 62.53125,6 L 62,6 z m 71.46875,0 C 137.0793,6 140,8.9207 140,12.53125 L 140,12 c 0,-3.324 -2.676,-6 -6,-6 l -0.53125,0 z M 140,12.53125 c 0,36.73465 -3.54263,60.10471 -7.84375,69.9375 C 121.33994,87.4996 96.479512,90 62.53125,90 L 134,90 c 3.324,0 6,-2.676 6,-6 l 0,-71.46875 z M 62.53125,90 C 58.9207,89.9945 56,87.0793 56,83.46875 L 56,84 c 0,3.324 2.676,6 6,6 l 0.53125,0 z\" 
inkscape:connector-curvature=\"0\" 
id=\"path3802\" 
style=\"fill:url(#linearGradient3804);fill-opacity:1;fill-rule:nonzero;stroke:none\" /> 
</clipPath> 
<linearGradient 
x1=\"48\" 
y1=\"90\" 
x2=\"48\" 
y2=\"5.9877172\" 
id=\"linearGradient3804\" 
xlink:href=\"#ButtonColor\" 
gradientUnits=\"userSpaceOnUse\" 
gradientTransform=\"translate(50,0)\" /> 
<filter 
color-interpolation-filters=\"sRGB\" 
id=\"filter3810\"> 
<feGaussianBlur 
id=\"feGaussianBlur3812\" 
stdDeviation=\"1.2600071\" /> 
</filter> 
<linearGradient 
x1=\"82.08036\" 
y1=\"82.290176\" 
x2=\"59.611588\" 
y2=\"59.821404\" 
id=\"linearGradient3825\" 
xlink:href=\"#linearGradient3737\" 
gradientUnits=\"userSpaceOnUse\" /> 
<linearGradient 
x1=\"58.650177\" 
y1=\"122\" 
x2=\"58.650177\" 
y2=\"5.4252338\" 
id=\"ButtonColor-0\" 
gradientUnits=\"userSpaceOnUse\" 
gradientTransform=\"matrix(1.0172414,0,0,1.0172414,-1.1034483,-1.1034483)\"> 
<stop 
id=\"stop3189-4\" 
style=\"stop-color:#f0f0f0;stop-opacity:1\" 
offset=\"0\" /> 
<stop 
id=\"stop3191-8\" 
style=\"stop-color:#ffffff;stop-opacity:1\" 
offset=\"1\" /> 
</linearGradient> 
<linearGradient 
x1=\"49.057751\" 
y1=\"36.02602\" 
x2=\"49.057751\" 
y2=\"6.0722966\" 
id=\"linearGradient3763\" 
xlink:href=\"#linearGradient3757\" 
gradientUnits=\"userSpaceOnUse\" /> 
<linearGradient 
x1=\"46.784908\" 
y1=\"32.026962\" 
x2=\"46.784908\" 
y2=\"68.028786\" 
id=\"linearGradient3699\" 
xlink:href=\"#linearGradient3737\" 
gradientUnits=\"userSpaceOnUse\" /> 
<linearGradient 
x1=\"47.868935\" 
y1=\"91.174545\" 
x2=\"47.868935\" 
y2=\"5.8992176\" 
id=\"linearGradient3707\" 
xlink:href=\"#ButtonShadow\" 
gradientUnits=\"userSpaceOnUse\" /> 
<linearGradient 
x1=\"46.965103\" 
y1=\"93.415817\" 
x2=\"46.965103\" 
y2=\"8.3638449\" 
id=\"linearGradient3722\" 
xlink:href=\"#ButtonShadow\" 
gradientUnits=\"userSpaceOnUse\" 
gradientTransform=\"translate(-1,-1)\" /> 
<linearGradient 
x1=\"46.965103\" 
y1=\"93.415817\" 
x2=\"46.965103\" 
y2=\"8.3638449\" 
id=\"linearGradient3736\" 
xlink:href=\"#ButtonShadow\" 
gradientUnits=\"userSpaceOnUse\" 
gradientTransform=\"translate(-1,-1)\" /> 
<linearGradient 
x1=\"46.965103\" 
y1=\"93.415817\" 
x2=\"46.965103\" 
y2=\"8.3638449\" 
id=\"linearGradient3752\" 
xlink:href=\"#ButtonShadow\" 
gradientUnits=\"userSpaceOnUse\" 
gradientTransform=\"translate(-1,-1)\" /> 
<linearGradient 
x1=\"46.965103\" 
y1=\"93.415817\" 
x2=\"46.965103\" 
y2=\"8.3638449\" 
id=\"linearGradient3760\" 
xlink:href=\"#ButtonShadow\" 
gradientUnits=\"userSpaceOnUse\" 
gradientTransform=\"translate(-1,-1)\" /> 
</defs> 
<metadata 
id=\"metadata2413\"> 
<rdf:RDF> 
<cc:Work 
rdf:about=\"\"> 
<dc:format>image/svg+xml</dc:format> 
<dc:type 
rdf:resource=\"http://purl.org/dc/dcmitype/StillImage\" /> 
</cc:Work> 
</rdf:RDF> 
</metadata> 
<g 
id=\"layer2\" 
style=\"display:none\"> 
<path 
d=\"M 11,7 C 7.676,7 5,9.676 5,13 l 0,73 c 0,3.324 2.676,6 6,6 l 74,0 c 3.324,0 6,-2.676 6,-6 L 91,13 C 91,9.676 88.324,7 85,7 l -15,0 0,2.5625 c 1.19379,0.692085 2,1.958291 2,3.4375 0,2.209139 -1.79086,4 -4,4 -2.20914,0 -4,-1.790861 -4,-4 0,-1.479209 0.80621,-2.745415 2,-3.4375 L 66,7 30,7 30,9.5625 c 1.19379,0.692085 2,1.958291 2,3.4375 0,2.209139 -1.79086,4 -4,4 -2.20914,0 -4,-1.790861 -4,-4 0,-1.479209 0.80621,-2.745415 2,-3.4375 L 26,7 11,7 z\" 
inkscape:connector-curvature=\"0\" 
id=\"rect3745\" 
style=\"opacity:0.9;fill:url(#ButtonShadow);fill-opacity:1;fill-rule:nonzero;stroke:none;filter:url(#filter3174)\" /> 
</g> 
<g 
id=\"layer3\" 
style=\"display:inline\"> 
<path 
d=\"M 12,4.09375 C 5.958559,3.9197191 1.4013336,9.7548505 2.125,15.53125 l -0.03125,0 c 0.0309,23.462972 -0.077155,46.904914 0.03125,70.375 a 0.89898646,0.89898646 0 0 0 0,0.0625 c 0.4135931,5.805998 6.1890583,9.610267 11.65625,8.9375 0.04186,-0.0052 0.08318,0.0057 0.125,0 23.670234,-0.03037 47.322706,0.07697 71,-0.03125 a 0.89898646,0.89898646 0 0 0 0.0625,0 c 5.805997,-0.413599 9.610267,-6.189058 8.9375,-11.65625 -0.0052,-0.04186 0.0057,-0.08318 0,-0.125 -0.03035,-23.336851 0.07696,-46.655962 -0.03125,-70 a 0.89898646,0.89898646 0 0 0 0,-0.0625 C 93.461407,7.2252516 87.685942,3.4209829 82.21875,4.09375 c -0.04121,6.156e-4 -0.08378,-5.689e-4 -0.125,0 C 77.816605,4.1527751 73.471998,3.9644816 69.125,4.1875 A 0.89898646,0.89898646 0 0 0 68.5,4.5 C 68.258195,4.7716239 68.114165,4.8160828 68.125,4.8125 67.945266,4.7390723 67.326189,4.2742446 66.375,4.125 A 0.89898646,0.89898646 0 0 0 66.25,4.09375 C 53.952869,4.1146989 41.647271,4.0518794 29.34375,4.125 a 0.89898646,0.89898646 0 0 0 -0.5625,0.21875 C 28.488372,4.5801621 28.293078,4.7029151 28.1875,4.75 28.081922,4.7970849 28.092979,4.7854347 28.0625,4.78125 28.001543,4.7728806 27.606489,4.5517268 26.875,4.1875 A 0.89898646,0.89898646 0 0 0 26.46875,4.09375 l -14.4375,0 -0.03125,0 z m 16.09375,8.6875 c 0.226923,0.244044 0.358574,0.498158 0.375,0.75 0.02604,0.39918 -0.161138,0.861966 -0.40625,1.125 -0.114331,0.12269 -0.223886,0.196155 -0.28125,0.21875 0.02231,0.0073 -0.27871,-0.3392 -0.3125,-1.40625 0.01928,-0.126056 0.06772,-0.162919 0.3125,-0.375 0.07441,-0.06447 0.212783,-0.230306 0.3125,-0.3125 z m 40,0 c 0.226923,0.244044 0.358574,0.498158 0.375,0.75 0.02604,0.39918 -0.161138,0.861966 -0.40625,1.125 -0.114331,0.12269 -0.223886,0.196155 -0.28125,0.21875 0.02232,0.0073 -0.27871,-0.3392 -0.3125,-1.40625 0.01928,-0.126056 0.06772,-0.162919 0.3125,-0.375 0.07441,-0.06447 0.212783,-0.230306 0.3125,-0.3125 z\" 
id=\"path3758\" 
style=\"opacity:0.07999998;fill:url(#linearGradient3760);fill-opacity:1;fill-rule:nonzero;stroke:none\" /> 
<path 
d=\"M 12,5 C 6.5057413,4.8226625 2.2688151,10.242553 3,15.51889 3.0309044,38.985409 2.9381256,62.455054 3.0465048,85.919616 3.4221938,91.193519 8.7597,94.680368 13.772038,94 37.487508,93.96909 61.206104,94.06189 84.919616,93.9535 90.193519,93.577806 93.680368,88.2403 93,83.227962 92.969096,59.845825 93.061873,36.460563 92.953495,13.080384 92.577806,7.806481 87.2403,4.3196317 82.227962,5 77.875336,5.0650149 73.487523,4.8715384 69.15625,5.09375 67.963875,6.4331658 67.682915,5.2248289 66.25,5 53.948789,5.0209559 41.640647,4.9581688 29.34375,5.03125 28.049941,6.0756153 27.841446,5.6834995 26.46875,5 21.645833,5 16.822917,5 12,5 z m 16,6.5625 c 3.752455,2.026235 -1.381779,7.249395 -1.430983,1.851426 C 26.677832,12.5193 27.639226,12.271287 28,11.5625 z m 40,0 c 3.752455,2.026235 -1.381779,7.249395 -1.430983,1.851426 C 66.677832,12.5193 67.639226,12.271287 68,11.5625 z\" 
inkscape:connector-curvature=\"0\" 
id=\"path3744\" 
style=\"opacity:0.1;fill:url(#linearGradient3752);fill-opacity:1;fill-rule:nonzero;stroke:none\" /> 
<path 
d=\"M 12,5.96875 C 7.5628051,5.96875 3.96875,9.5628051 3.96875,14 l 0,71 c 0,4.437195 3.5940551,8.03125 8.03125,8.03125 l 72,0 c 4.437195,0 8.03125,-3.594055 8.03125,-8.03125 l 0,-71 C 92.03125,9.5628051 88.437195,5.96875 84,5.96875 l -14.25,0 A 1.0420122,1.0420122 0 0 0 68.71875,7 l 0,3.5625 a 1.0420122,1.0420122 0 0 0 0.46875,0.875 c 0.737994,0.488062 1.28125,1.413642 1.28125,2.5625 0,1.717559 -1.174525,2.96875 -2.46875,2.96875 -1.294225,0 -2.46875,-1.251191 -2.46875,-2.96875 0,-1.148858 0.543256,-2.074438 1.28125,-2.5625 a 1.0420122,1.0420122 0 0 0 0.46875,-0.875 l 0,-3.5625 A 1.0420122,1.0420122 0 0 0 66.25,5.96875 l -36.5,0 A 1.0420122,1.0420122 0 0 0 28.71875,7 l 0,3.5625 a 1.0420122,1.0420122 0 0 0 0.46875,0.875 c 0.737994,0.488062 1.28125,1.413642 1.28125,2.5625 0,1.717559 -1.174525,2.96875 -2.46875,2.96875 -1.294225,0 -2.46875,-1.251191 -2.46875,-2.96875 0,-1.148858 0.543256,-2.074438 1.28125,-2.5625 a 1.0420122,1.0420122 0 0 0 0.46875,-0.875 l 0,-3.5625 A 1.0420122,1.0420122 0 0 0 26.25,5.96875 l -14.25,0 z\" 
inkscape:connector-curvature=\"0\" 
id=\"path3734\" 
style=\"opacity:0.2;fill:url(#linearGradient3736);fill-opacity:1;fill-rule:nonzero;stroke:none\" /> 
<path 
d=\"M 12,7 C 8.122,7 5,10.122 5,14 l 0,71 c 0,3.878 3.122,7 7,7 l 72,0 c 3.878,0 7,-3.122 7,-7 L 91,14 C 91,10.122 87.878,7 84,7 l -14.25,0 0,3.5625 c 1.046496,0.692085 1.75,1.958291 1.75,3.4375 0,2.209139 -1.563432,4 -3.5,4 -1.936568,0 -3.5,-1.790861 -3.5,-4 0,-1.479209 0.703504,-2.745415 1.75,-3.4375 l 0,-3.5625 -36.5,0 0,3.5625 c 1.046496,0.692085 1.75,1.958291 1.75,3.4375 0,2.209139 -1.563432,4 -3.5,4 -1.936568,0 -3.5,-1.790861 -3.5,-4 0,-1.479209 0.703504,-2.745415 1.75,-3.4375 L 26.25,7 12,7 z\" 
inkscape:connector-curvature=\"0\" 
id=\"rect3713\" 
style=\"opacity:0.3;fill:url(#linearGradient3722);fill-opacity:1;fill-rule:nonzero;stroke:none\" /> 
<path 
d=\"M 12,7 C 8.676,7 6,9.676 6,13 l 0,72 c 0,3.324 2.676,6 6,6 l 72,0 c 3.324,0 6,-2.676 6,-6 L 90,13 C 90,9.676 87.324,7 84,7 l -14,0 0,2.5625 c 1.193791,0.692085 2,1.958291 2,3.4375 0,2.209139 -1.790861,4 -4,4 -2.209139,0 -4,-1.790861 -4,-4 0,-1.479209 0.806209,-2.745415 2,-3.4375 L 66,7 30,7 30,9.5625 c 1.193791,0.692085 2,1.958291 2,3.4375 0,2.209139 -1.790861,4 -4,4 -2.209139,0 -4,-1.790861 -4,-4 0,-1.479209 0.806209,-2.745415 2,-3.4375 L 26,7 12,7 z\" 
inkscape:connector-curvature=\"0\" 
id=\"path3693\" 
style=\"opacity:0.45;fill:url(#linearGradient3707);fill-opacity:1;fill-rule:nonzero;stroke:none\" /> 
</g> 
<g 
id=\"layer1\"> 
<path 
d=\"M 12,6 C 8.676,6 6,8.676 6,12 l 0,72 c 0,3.324 2.676,6 6,6 l 72,0 c 3.324,0 6,-2.676 6,-6 L 90,12 C 90,8.676 87.324,6 84,6 l -14,0 0,2.5625 c 1.193791,0.6920851 2,1.958291 2,3.4375 0,2.209139 -1.790861,4 -4,4 -2.209139,0 -4,-1.790861 -4,-4 0,-1.479209 0.806209,-2.7454149 2,-3.4375 L 66,6 30,6 30,8.5625 c 1.193791,0.6920851 2,1.958291 2,3.4375 0,2.209139 -1.790861,4 -4,4 -2.209139,0 -4,-1.790861 -4,-4 0,-1.479209 0.806209,-2.7454149 2,-3.4375 L 26,6 12,6 z\" 
inkscape:connector-curvature=\"0\" 
id=\"rect2419\" 
style=\"fill:url(#linearGradient3617);fill-opacity:1;fill-rule:nonzero;stroke:none\" /> 
<path 
d=\"m 2,90 c -3.324,0 -6,-2.676 -6,-6 l 0,-2 0,-68 0,-2 c 0,-0.334721 0.04135,-0.6507 0.09375,-0.96875 0.0487,-0.295596 0.09704,-0.596915 0.1875,-0.875 0.00988,-0.03038 0.020892,-0.0636 0.03125,-0.09375 0.098865,-0.287771 0.2348802,-0.547452 0.375,-0.8125 0.1445918,-0.273507 0.3156161,-0.535615 0.5,-0.78125 0.1843839,-0.245635 0.3737765,-0.473472 0.59375,-0.6875 0.439947,-0.428056 0.94291,-0.814526 1.5,-1.09375 0.278545,-0.139612 0.5734731,-0.246947 0.875,-0.34375 -0.2562018,0.100222 -0.4867109,0.236272 -0.71875,0.375 -0.00741,0.0044 -0.023866,-0.0045 -0.03125,0 -0.031933,0.0193 -0.062293,0.04251 -0.09375,0.0625 -0.120395,0.0767 -0.2310226,0.163513 -0.34375,0.25 -0.1061728,0.0808 -0.2132809,0.161112 -0.3125,0.25 -0.1779299,0.161433 -0.3474596,0.345388 -0.5,0.53125 -0.1075789,0.130255 -0.2183939,0.265285 -0.3125,0.40625 -0.025089,0.03838 -0.038446,0.08587 -0.0625,0.125 -0.064763,0.103032 -0.1302275,0.204517 -0.1875,0.3125 -0.1010083,0.194706 -0.2056748,0.415701 -0.28125,0.625 C -2.69546,9.30306 -2.711089,9.3218 -2.71875,9.34375 -2.7505751,9.4357 -2.7545545,9.530581 -2.78125,9.625 -2.8115823,9.731618 -2.8516394,9.828031 -2.875,9.9375 -2.9478786,10.279012 -3,10.635705 -3,11 l 0,2 0,68 0,2 c 0,2.781848 2.2181517,5 5,5 l 2,0 68,0 2,0 c 2.781848,0 5,-2.218152 5,-5 l 0,-2 0,-68 0,-2 C 79,10.635705 78.94788,10.279012 78.875,9.9375 78.83085,9.730607 78.78662,9.539842 78.71875,9.34375 78.71105,9.3218 78.69545,9.30306 78.6875,9.28125 78.62476,9.107511 78.549117,8.913801 78.46875,8.75 78.42717,8.6672 78.38971,8.580046 78.34375,8.5 78.28915,8.40279 78.216976,8.31165 78.15625,8.21875 78.06214,8.077785 77.951329,7.942755 77.84375,7.8125 77.700576,7.63805 77.540609,7.465502 77.375,7.3125 77.36383,7.3023 77.35502,7.29135 77.34375,7.28125 77.205364,7.155694 77.058659,7.046814 76.90625,6.9375 76.803679,6.86435 76.701932,6.784136 76.59375,6.71875 c -0.0074,-0.0045 -0.02384,0.0044 -0.03125,0 -0.232039,-0.138728 -0.462548,-0.274778 -0.71875,-0.375 0.301527,0.0968 0.596455,0.204138 0.875,0.34375 0.55709,0.279224 1.060053,0.665694 1.5,1.09375 0.219973,0.214028 0.409366,0.441865 0.59375,0.6875 0.184384,0.245635 0.355408,0.507743 0.5,0.78125 0.14012,0.265048 0.276135,0.524729 0.375,0.8125 0.01041,0.03078 0.02133,0.06274 0.03125,0.09375 0.09046,0.278085 0.1388,0.579404 0.1875,0.875 C 79.95865,11.3493 80,11.665279 80,12 l 0,2 0,68 0,2 c 0,3.324 -2.676,6 -6,6 L 2,90 z\" 
inkscape:connector-curvature=\"0\" 
id=\"path3615\" 
style=\"opacity:0.2;fill:url(#radialGradient3619);fill-opacity:1;fill-rule:nonzero;stroke:none\" /> 
<path 
d=\"M 62.51724,6 C 58.90669,6 56,8.90669 56,12.517241 l 0,70.965519 c 0,3.610548 2.90669,6.511737 6.51724,6.51724 33.948262,0 61.15737,0.163148 73.40225,-3.796268 C 139.14918,76.192373 140,49.251888 140,12.517241 140,8.90669 137.09331,6 133.48276,6 L 62.51724,6 z\" 
inkscape:connector-curvature=\"0\" 
transform=\"translate(-50,0)\" 
clip-path=\"url(#clipPath3800)\" 
id=\"path3785\" 
style=\"opacity:0.5;fill:#4d4d4d;fill-opacity:1;stroke:none;display:inline;filter:url(#filter3810)\" /> 
<path 
d=\"M 12.53125,6 C 8.9207,6 6,8.920699 6,12.53125 l 0,70.9375 C 6,87.079298 8.9207,89.994497 12.53125,90 46.479512,90 71.339935,87.499595 82.15625,82.46875 86.457363,72.635962 90,49.265897 90,12.53125 90,8.920699 87.079298,6 83.46875,6 L 70,6 70,8.5625 c 1.193791,0.6920851 2,1.958291 2,3.4375 0,2.209139 -1.790861,4 -4,4 -2.209139,0 -4,-1.790861 -4,-4 0,-1.479209 0.806209,-2.7454149 2,-3.4375 L 66,6 30,6 30,8.5625 c 1.193791,0.6920851 2,1.958291 2,3.4375 0,2.209139 -1.790861,4 -4,4 -2.209139,0 -4,-1.790861 -4,-4 0,-1.479209 0.806209,-2.7454149 2,-3.4375 L 26,6 12.53125,6 z\" 
inkscape:connector-curvature=\"0\" 
id=\"path3177\" 
style=\"opacity:0.8;fill:url(#linearGradient3185);fill-opacity:1;stroke:none;display:inline\" /> 
<path 
d=\"m 6,28 84,0 c 0,0 -0.505076,19.039335 -4.04061,40.126269 L 6,68 6,28 z\" 
inkscape:connector-curvature=\"0\" 
id=\"rect2918\" 
style=\"opacity:0.8;fill:url(#linearGradient3699);fill-opacity:1;stroke:none\" /> 
<path 
d=\"M 12,6 C 8.676,6 6,8.676 6,12 l 0,24 84,0 0,-24 C 90,8.676 87.324,6 84,6 l -14,0 0,2.5625 c 1.193791,0.6920851 2,1.958291 2,3.4375 0,2.209139 -1.790861,4 -4,4 -2.209139,0 -4,-1.790861 -4,-4 0,-1.479209 0.806209,-2.7454149 2,-3.4375 L 66,6 30,6 30,8.5625 c 1.193791,0.6920851 2,1.958291 2,3.4375 0,2.209139 -1.790861,4 -4,4 -2.209139,0 -4,-1.790861 -4,-4 0,-1.479209 0.806209,-2.7454149 2,-3.4375 L 26,6 12,6 z\" 
inkscape:connector-curvature=\"0\" 
id=\"rect3839\" 
style=\"fill:url(#linearGradient3763);fill-opacity:1;fill-rule:nonzero;stroke:none\" /> 
<path 
d=\"M 87.5625,7.4375 C 88.457536,8.5531297 89,9.9832263 89,11.53125 89,48.265897 85.457363,71.635962 81.15625,81.46875 70.339935,86.499595 45.479512,89 11.53125,89 9.9832267,88.997641 8.5531295,88.457151 7.4375,87.5625 8.6300118,89.04796 10.468723,89.996856 12.53125,90 46.479512,90 71.339935,87.499595 82.15625,82.46875 86.457363,72.635962 90,49.265897 90,12.53125 90,10.468723 89.048922,8.6300119 87.5625,7.4375 z\" 
inkscape:connector-curvature=\"0\" 
id=\"path3814\" 
style=\"opacity:0.5;fill:url(#linearGradient3825);fill-opacity:1;stroke:none;display:inline\" /> 
<path 
d=\"m 89.96875,19.28125 c -0.40529,32.853499 -3.78151,53.972258 -7.8125,63.1875 -10.14029,4.716417 -32.62864,7.205224 -63.375,7.5 30.86516,-0.09992 54.68077,-1.006315 64.8125,-5.71875 4.0323,-9.218239 6.12845,-31.900739 6.375,-64.96875 z\" 
inkscape:connector-curvature=\"0\" 
id=\"path3831\" 
style=\"opacity:0.1;fill:#000000;fill-opacity:1;stroke:none;display:inline\" /> 
<path 
d=\"M 12,6 C 8.676,6 6,8.676 6,12 l 0,2 0,68 0,2 c 0,0.334721 0.04135,0.6507 0.09375,0.96875 0.0487,0.295596 0.09704,0.596915 0.1875,0.875 0.0099,0.03038 0.02089,0.0636 0.03125,0.09375 0.09886,0.287771 0.23488,0.547452 0.375,0.8125 0.144592,0.273507 0.315616,0.535615 0.5,0.78125 0.184384,0.245635 0.373776,0.473472 0.59375,0.6875 0.439947,0.428056 0.94291,0.814526 1.5,1.09375 0.278545,0.139612 0.573473,0.246947 0.875,0.34375 -0.256202,-0.100222 -0.486711,-0.236272 -0.71875,-0.375 -0.0074,-0.0044 -0.02387,0.0045 -0.03125,0 -0.03193,-0.0193 -0.06229,-0.04251 -0.09375,-0.0625 -0.120395,-0.0767 -0.231023,-0.163513 -0.34375,-0.25 -0.106173,-0.0808 -0.213281,-0.161112 -0.3125,-0.25 C 8.47832,88.557317 8.30879,88.373362 8.15625,88.1875 8.048671,88.057245 7.937856,87.922215 7.84375,87.78125 7.81866,87.74287 7.8053,87.69538 7.78125,87.65625 7.71649,87.553218 7.651022,87.451733 7.59375,87.34375 7.492742,87.149044 7.388075,86.928049 7.3125,86.71875 7.3045,86.69694 7.28891,86.6782 7.28125,86.65625 7.24942,86.5643 7.24545,86.469419 7.21875,86.375 7.188418,86.268382 7.148361,86.171969 7.125,86.0625 7.052121,85.720988 7,85.364295 7,85 L 7,83 7,15 7,13 C 7,10.218152 9.218152,8 12,8 l 2,0 12,0 0,-2 -14,0 z m 18,0 0,2 36,0 0,-2 -36,0 z m 40,0 0,2 12,0 2,0 c 2.781848,0 5,2.218152 5,5 l 0,2 0,68 0,2 c 0,0.364295 -0.05212,0.720988 -0.125,1.0625 -0.04415,0.206893 -0.08838,0.397658 -0.15625,0.59375 -0.0077,0.02195 -0.0233,0.04069 -0.03125,0.0625 -0.06274,0.173739 -0.138383,0.367449 -0.21875,0.53125 -0.04158,0.0828 -0.07904,0.169954 -0.125,0.25 -0.0546,0.09721 -0.126774,0.18835 -0.1875,0.28125 -0.09411,0.140965 -0.204921,0.275995 -0.3125,0.40625 -0.143174,0.17445 -0.303141,0.346998 -0.46875,0.5 -0.01117,0.0102 -0.01998,0.02115 -0.03125,0.03125 -0.138386,0.125556 -0.285091,0.234436 -0.4375,0.34375 -0.102571,0.07315 -0.204318,0.153364 -0.3125,0.21875 -0.0074,0.0045 -0.02384,-0.0044 -0.03125,0 -0.232039,0.138728 -0.462548,0.274778 -0.71875,0.375 0.301527,-0.0968 0.596455,-0.204138 0.875,-0.34375 0.55709,-0.279224 1.060053,-0.665694 1.5,-1.09375 0.219973,-0.214028 0.409366,-0.441865 0.59375,-0.6875 0.184384,-0.245635 0.355408,-0.507743 0.5,-0.78125 0.14012,-0.265048 0.276135,-0.524729 0.375,-0.8125 0.01041,-0.03078 0.02133,-0.06274 0.03125,-0.09375 0.09046,-0.278085 0.1388,-0.579404 0.1875,-0.875 C 89.95865,84.6507 90,84.334721 90,84 l 0,-2 0,-68 0,-2 C 90,8.676 87.324,6 84,6 L 70,6 z\" 
inkscape:connector-curvature=\"0\" 
id=\"rect3728\" 
style=\"opacity:0.4;fill:url(#linearGradient3188);fill-opacity:1;fill-rule:nonzero;stroke:none\" /> 
<g 
transform=\"matrix(0.35049316,0,0,0.3538302,42.738451,15.822022)\" 
id=\"g2751\" 
style=\"display:inline\"> 
<path 
d=\"m 64.127514,24.097733 c 0.1888,0.04037 0.335935,0.124351 0.441406,0.251954 0.106769,0.127605 0.160154,0.285157 0.160156,0.472656 -2e-6,0.287761 -0.09896,0.510417 -0.296875,0.667969 -0.197918,0.157552 -0.479168,0.236328 -0.84375,0.236328 -0.122396,0 -0.248698,-0.01237 -0.378906,-0.03711 -0.128907,-0.02344 -0.26237,-0.05924 -0.40039,-0.107422 l 0,-0.380859 c 0.109374,0.0638 0.229166,0.11198 0.359375,0.144531 0.130207,0.03255 0.266275,0.04883 0.408203,0.04883 0.247394,1e-6 0.435545,-0.04883 0.564453,-0.146484 0.130206,-0.09766 0.19531,-0.239583 0.195312,-0.425781 -2e-6,-0.171874 -0.06055,-0.305989 -0.18164,-0.402344 -0.119794,-0.09765 -0.287111,-0.146483 -0.501953,-0.146484 l -0.339844,0 0,-0.324219 0.355469,0 c 0.194009,2e-6 0.342446,-0.03841 0.445312,-0.115234 0.102863,-0.07812 0.154295,-0.190103 0.154297,-0.335938 -2e-6,-0.149737 -0.05339,-0.26432 -0.160156,-0.34375 -0.105471,-0.08073 -0.257163,-0.121091 -0.455078,-0.121094 -0.108074,3e-6 -0.22396,0.01172 -0.347657,0.03516 -0.123698,0.02344 -0.259766,0.0599 -0.408203,0.109375 l 0,-0.351563 c 0.149739,-0.04166 0.289713,-0.07291 0.419922,-0.09375 0.131509,-0.02083 0.255207,-0.03125 0.371094,-0.03125 0.299477,3e-6 0.536456,0.06836 0.710937,0.205078 0.174477,0.13542 0.261717,0.319013 0.261719,0.550781 -2e-6,0.161461 -0.04623,0.298179 -0.138672,0.410157 -0.09245,0.110679 -0.22396,0.187501 -0.394531,0.230468 m -2.400391,6.040235 0.644532,0 0,-2.224609 -0.701172,0.140625 0,-0.359375 0.697265,-0.140625 0.394532,0 0,2.583984 0.644531,0 0,0.332031 -1.679688,0 0,-0.332031 m 3.322266,-2.324219 c -0.203126,3e-6 -0.356121,0.100263 -0.458984,0.300782 -0.101564,0.19922 -0.152345,0.49935 -0.152344,0.90039 -1e-6,0.399741 0.05078,0.699871 0.152344,0.900391 0.102863,0.199219 0.255858,0.298828 0.458984,0.298828 0.204425,0 0.35742,-0.09961 0.458984,-0.298828 0.102863,-0.20052 0.154295,-0.50065 0.154297,-0.900391 -2e-6,-0.40104 -0.05143,-0.70117 -0.154297,-0.90039 -0.101564,-0.200519 -0.254559,-0.300779 -0.458984,-0.300782 m 0,-0.3125 c 0.326821,3e-6 0.57617,0.12956 0.748047,0.388672 0.173175,0.257815 0.259763,0.632815 0.259765,1.125 -2e-6,0.490887 -0.08659,0.865886 -0.259765,1.125 -0.171877,0.257813 -0.421226,0.386719 -0.748047,0.386719 -0.326824,0 -0.576824,-0.128906 -0.75,-0.386719 -0.171875,-0.259114 -0.257813,-0.634113 -0.257813,-1.125 0,-0.492185 0.08594,-0.867185 0.257813,-1.125 0.173176,-0.259112 0.423176,-0.388669 0.75,-0.388672 m -3.322266,7.436719 0.644532,0 0,-2.224609 -0.701172,0.140625 0,-0.359375 0.697265,-0.140625 0.394532,0 0,2.583984 0.644531,0 0,0.332032 -1.679688,0 0,-0.332032 m 2.378907,-2.583984 1.875,0 0,0.167969 -1.058594,2.748047 -0.41211,0 0.996094,-2.583985 -1.40039,0 0,-0.332031 m -2.107422,7.383984 1.376953,0 0,0.332032 -1.851563,0 0,-0.332032 c 0.149739,-0.154947 0.353515,-0.362629 0.611328,-0.623046 0.259114,-0.261718 0.421874,-0.430338 0.488282,-0.50586 0.1263,-0.141925 0.214191,-0.261717 0.263672,-0.359375 0.05078,-0.09896 0.07617,-0.195961 0.07617,-0.291015 -1e-6,-0.154946 -0.05469,-0.281248 -0.164062,-0.378907 -0.108074,-0.09765 -0.24935,-0.146481 -0.423828,-0.146484 -0.123699,3e-6 -0.254558,0.02149 -0.392578,0.06445 -0.13672,0.04297 -0.283204,0.108075 -0.439453,0.195313 l 0,-0.398438 c 0.158853,-0.0638 0.307291,-0.111976 0.445312,-0.144531 0.13802,-0.03255 0.264322,-0.04883 0.378906,-0.04883 0.302082,3e-6 0.542967,0.07552 0.722657,0.226562 0.179685,0.151044 0.269529,0.352867 0.269531,0.605469 -2e-6,0.119794 -0.02279,0.233726 -0.06836,0.341797 -0.04427,0.106772 -0.125653,0.233074 -0.24414,0.378906 -0.03255,0.03776 -0.13607,0.147137 -0.310547,0.328125 -0.174481,0.179688 -0.420574,0.431641 -0.738281,0.755859 m 3.291015,-2.240234 -0.996093,1.556641 0.996093,0 0,-1.556641 m -0.103515,-0.34375 0.496093,0 0,1.900391 0.416016,0 0,0.328125 -0.416016,0 0,0.6875 -0.392578,0 0,-0.6875 -1.316406,0 0,-0.38086 1.212891,-1.847656\" 
inkscape:connector-curvature=\"0\" 
id=\"text2434\" 
style=\"font-size:4px;font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;text-align:center;line-height:120.00000477%%;writing-mode:lr-tb;text-anchor:middle;fill:#ffffff;fill-opacity:1;stroke:none;font-family:Sans;-inkscape-font-specification:Sans\" /> 
<path 
d=\"m 71.694389,23.041094 -0.996093,1.55664 0.996093,0 0,-1.55664 m -0.103515,-0.34375 0.496093,0 0,1.90039 0.416016,0 0,0.328125 -0.416016,0 0,0.6875 -0.392578,0 0,-0.6875 -1.316406,0 0,-0.380859 1.212891,-1.847656 m -2.185547,7.383984 0.644531,0 0,-2.224609 -0.701172,0.140625 0,-0.359375 0.697266,-0.140625 0.394531,0 0,2.583984 0.644531,0 0,0.332032 -1.679687,0 0,-0.332032 m 2.546875,0 0.644531,0 0,-2.224609 -0.701172,0.140625 0,-0.359375 0.697266,-0.140625 0.394531,0 0,2.583984 0.644531,0 0,0.332032 -1.679687,0 0,-0.332032 m -2.546875,4.800001 0.644531,0 0,-2.22461 -0.701172,0.140625 0,-0.359375 0.697266,-0.140625 0.394531,0 0,2.583985 0.644531,0 0,0.332031 -1.679687,0 0,-0.332031 m 3.322265,-1.052735 c -0.187501,2e-6 -0.335287,0.05013 -0.443359,0.150391 -0.106771,0.100261 -0.160157,0.238282 -0.160156,0.414062 -10e-7,0.175782 0.05339,0.313803 0.160156,0.414063 0.108072,0.100261 0.255858,0.150391 0.443359,0.15039 0.187499,10e-7 0.335285,-0.05013 0.44336,-0.15039 0.108071,-0.101562 0.162107,-0.239583 0.162109,-0.414063 -2e-6,-0.17578 -0.05404,-0.313801 -0.162109,-0.414062 -0.106773,-0.100259 -0.254559,-0.150389 -0.44336,-0.150391 m -0.394531,-0.167969 c -0.169271,-0.04167 -0.301433,-0.120441 -0.396484,-0.236328 -0.09375,-0.115883 -0.140625,-0.257159 -0.140625,-0.423828 0,-0.23307 0.08268,-0.417315 0.248047,-0.552734 0.166666,-0.135414 0.39453,-0.203122 0.683593,-0.203125 0.290363,3e-6 0.518228,0.06771 0.683594,0.203125 0.165363,0.135419 0.248045,0.319664 0.248047,0.552734 -2e-6,0.166669 -0.04753,0.307945 -0.142578,0.423828 -0.09375,0.115887 -0.224611,0.194663 -0.392578,0.236328 0.190102,0.04427 0.337888,0.130861 0.443359,0.259766 0.106769,0.128907 0.160154,0.286459 0.160156,0.472656 -2e-6,0.282553 -0.08659,0.49935 -0.259765,0.650391 C 73.29595,35.19448 73.049205,35.27 72.727592,35.27 c -0.321615,0 -0.569011,-0.07552 -0.742187,-0.226562 -0.171875,-0.151041 -0.257813,-0.367838 -0.257813,-0.650391 0,-0.186197 0.05339,-0.343749 0.160157,-0.472656 0.10677,-0.128905 0.255207,-0.215493 0.445312,-0.259766 M 72.18853,33.037579 c -10e-7,0.151043 0.04687,0.268882 0.140625,0.353515 0.09505,0.08464 0.227863,0.126955 0.398437,0.126953 0.16927,2e-6 0.301431,-0.04232 0.396485,-0.126953 0.09635,-0.08463 0.144529,-0.202472 0.144531,-0.353515 -2e-6,-0.15104 -0.04818,-0.268878 -0.144531,-0.353516 -0.09505,-0.08463 -0.227215,-0.126951 -0.396485,-0.126953 -0.170574,2e-6 -0.303386,0.04232 -0.398437,0.126953 -0.09375,0.08464 -0.140626,0.202476 -0.140625,0.353516 m -2.511719,6.64375 1.376953,0 0,0.332031 -1.851562,0 0,-0.332031 c 0.149739,-0.154948 0.353515,-0.36263 0.611328,-0.623047 0.259113,-0.261718 0.421874,-0.430337 0.488281,-0.505859 0.126301,-0.141926 0.214191,-0.261718 0.263672,-0.359375 0.05078,-0.09896 0.07617,-0.195962 0.07617,-0.291016 -2e-6,-0.154946 -0.05469,-0.281248 -0.164063,-0.378906 -0.108074,-0.09765 -0.24935,-0.146482 -0.423828,-0.146485 -0.123699,3e-6 -0.254558,0.02149 -0.392578,0.06445 -0.136719,0.04297 -0.283203,0.108076 -0.439453,0.195313 l 0,-0.398438 c 0.158854,-0.0638 0.307291,-0.111976 0.445313,-0.144531 0.13802,-0.03255 0.264321,-0.04883 0.378906,-0.04883 0.302082,3e-6 0.542967,0.07552 0.722656,0.226563 0.179686,0.151044 0.269529,0.352866 0.269531,0.605468 -2e-6,0.119794 -0.02279,0.233726 -0.06836,0.341797 -0.04427,0.106773 -0.125653,0.233075 -0.244141,0.378906 -0.03255,0.03776 -0.136069,0.147137 -0.310547,0.328125 -0.17448,0.179689 -0.420574,0.431642 -0.738281,0.75586 m 2.210938,-2.583985 1.548828,0 0,0.332032 -1.1875,0 0,0.714843 c 0.05729,-0.01953 0.114582,-0.03385 0.171875,-0.04297 0.05729,-0.01041 0.114582,-0.01562 0.171875,-0.01563 0.325519,2e-6 0.583331,0.08919 0.773437,0.267578 0.190102,0.178387 0.285154,0.419923 0.285157,0.724609 -3e-6,0.313803 -0.09766,0.557943 -0.292969,0.732422 -0.195314,0.173177 -0.470705,0.259766 -0.826172,0.259766 -0.122397,0 -0.247397,-0.01042 -0.375,-0.03125 -0.126303,-0.02083 -0.257162,-0.05208 -0.392578,-0.09375 l 0,-0.396485 c 0.117187,0.0638 0.238281,0.111329 0.363281,0.142578 0.124999,0.03125 0.257161,0.04688 0.396484,0.04687 0.22526,10e-7 0.403645,-0.05924 0.535157,-0.177734 0.131508,-0.118489 0.197264,-0.279296 0.197265,-0.482422 -10e-7,-0.203124 -0.06576,-0.363931 -0.197265,-0.482422 -0.131512,-0.118488 -0.309897,-0.177733 -0.535157,-0.177734 -0.105469,1e-6 -0.210938,0.01172 -0.316406,0.03516 -0.104167,0.02344 -0.210938,0.0599 -0.320312,0.109375 l 0,-1.464844\" 
inkscape:connector-curvature=\"0\" 
id=\"text2446\" 
style=\"font-size:4px;font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;text-align:center;line-height:120.00000477%%;writing-mode:lr-tb;text-anchor:middle;fill:#ffffff;fill-opacity:1;stroke:none;font-family:Sans;-inkscape-font-specification:Sans\" /> 
<path 
d=\"m 78.257362,22.697344 1.548828,0 0,0.332031 -1.1875,0 0,0.714844 c 0.05729,-0.01953 0.114583,-0.03385 0.171875,-0.04297 0.05729,-0.01042 0.114583,-0.01562 0.171875,-0.01563 0.32552,2e-6 0.583332,0.08919 0.773438,0.267578 0.190102,0.178387 0.285154,0.419923 0.285156,0.72461 -2e-6,0.313802 -0.09766,0.557943 -0.292969,0.732421 C 79.532751,25.583412 79.257361,25.67 78.901894,25.67 c -0.122397,0 -0.247397,-0.01042 -0.375,-0.03125 -0.126303,-0.02083 -0.257162,-0.05208 -0.392579,-0.09375 l 0,-0.396484 c 0.117188,0.0638 0.238281,0.111328 0.363282,0.142578 0.124999,0.03125 0.25716,0.04687 0.396484,0.04687 0.225259,0 0.403644,-0.05925 0.535156,-0.177735 0.131509,-0.118489 0.197264,-0.279296 0.197266,-0.482421 -2e-6,-0.203124 -0.06576,-0.363931 -0.197266,-0.482422 -0.131512,-0.118488 -0.309897,-0.177733 -0.535156,-0.177735 -0.10547,2e-6 -0.210938,0.01172 -0.316406,0.03516 -0.104167,0.02344 -0.210938,0.0599 -0.320313,0.109375 l 0,-1.464844 m -1.208984,7.383984 0.644531,0 0,-2.224609 -0.701172,0.140625 0,-0.359375 0.697266,-0.140625 0.394531,0 0,2.583984 0.644531,0 0,0.332032 -1.679687,0 0,-0.332032 m 2.818359,0 1.376953,0 0,0.332032 -1.851562,0 0,-0.332032 c 0.149739,-0.154947 0.353515,-0.362629 0.611328,-0.623046 0.259114,-0.261718 0.421874,-0.430338 0.488281,-0.50586 0.126301,-0.141925 0.214191,-0.261717 0.263672,-0.359375 0.05078,-0.09896 0.07617,-0.195961 0.07617,-0.291015 -2e-6,-0.154946 -0.05469,-0.281248 -0.164062,-0.378907 -0.108075,-0.09765 -0.249351,-0.146481 -0.423829,-0.146484 -0.123698,3e-6 -0.254558,0.02149 -0.392578,0.06445 -0.136719,0.04297 -0.283203,0.108075 -0.439453,0.195313 l 0,-0.398438 c 0.158854,-0.0638 0.307291,-0.111976 0.445313,-0.144531 0.13802,-0.03255 0.264322,-0.04883 0.378906,-0.04883 0.302082,3e-6 0.542967,0.07552 0.722656,0.226562 0.179686,0.151044 0.269529,0.352867 0.269531,0.605469 -2e-6,0.119794 -0.02279,0.233726 -0.06836,0.341797 -0.04427,0.106772 -0.125653,0.233074 -0.244141,0.378906 -0.03255,0.03776 -0.136069,0.147137 -0.310546,0.328125 -0.174481,0.179688 -0.420574,0.431641 -0.738282,0.755859 m -2.818359,4.800001 0.644531,0 0,-2.22461 -0.701172,0.140625 0,-0.359375 0.697266,-0.140625 0.394531,0 0,2.583985 0.644531,0 0,0.332031 -1.679687,0 0,-0.332031 m 2.490234,0.271484 0,-0.359375 c 0.09896,0.04687 0.199218,0.08268 0.300782,0.107422 0.101561,0.02474 0.201171,0.03711 0.298828,0.03711 0.260415,0 0.458983,-0.08724 0.595703,-0.261719 0.138019,-0.17578 0.216795,-0.442056 0.236328,-0.798828 -0.07552,0.111981 -0.171226,0.197918 -0.287109,0.257813 -0.115887,0.0599 -0.244142,0.08984 -0.384766,0.08984 -0.291668,1e-6 -0.522787,-0.08789 -0.693359,-0.263672 -0.169272,-0.177082 -0.253907,-0.418618 -0.253907,-0.72461 0,-0.299477 0.08854,-0.539711 0.265625,-0.720703 0.177083,-0.180986 0.41276,-0.271481 0.707032,-0.271484 0.337238,3e-6 0.594399,0.12956 0.771484,0.388672 0.178383,0.257815 0.267576,0.632814 0.267578,1.125 -2e-6,0.459636 -0.109377,0.826823 -0.328125,1.101562 C 80.817256,35.133282 80.524288,35.27 80.1558,35.27 c -0.09896,0 -0.19922,-0.0098 -0.300781,-0.0293 -0.101564,-0.01953 -0.207032,-0.04883 -0.316407,-0.08789 m 0.785157,-1.236328 c 0.177082,10e-7 0.317055,-0.06055 0.419921,-0.181641 0.104165,-0.121092 0.156249,-0.287107 0.15625,-0.498047 -10e-7,-0.209633 -0.05209,-0.374997 -0.15625,-0.496093 -0.102866,-0.122394 -0.242839,-0.183592 -0.419921,-0.183594 -0.177085,2e-6 -0.31771,0.0612 -0.421875,0.183594 -0.102866,0.121096 -0.154298,0.28646 -0.154297,0.496093 -10e-7,0.21094 0.05143,0.376955 0.154297,0.498047 0.104165,0.121095 0.24479,0.181642 0.421875,0.181641 m -3.003907,5.764844 1.376953,0 0,0.332031 -1.851562,0 0,-0.332031 c 0.149739,-0.154948 0.353515,-0.36263 0.611328,-0.623047 0.259114,-0.261718 0.421874,-0.430337 0.488281,-0.505859 0.126301,-0.141926 0.214191,-0.261718 0.263672,-0.359375 0.05078,-0.09896 0.07617,-0.195962 0.07617,-0.291016 -2e-6,-0.154946 -0.05469,-0.281248 -0.164062,-0.378906 -0.108075,-0.09765 -0.249351,-0.146482 -0.423829,-0.146485 -0.123698,3e-6 -0.254558,0.02149 -0.392578,0.06445 -0.136719,0.04297 -0.283203,0.108076 -0.439453,0.195313 l 0,-0.398438 c 0.158854,-0.0638 0.307291,-0.111976 0.445313,-0.144531 0.13802,-0.03255 0.264322,-0.04883 0.378906,-0.04883 0.302082,3e-6 0.542967,0.07552 0.722656,0.226563 0.179686,0.151044 0.269529,0.352866 0.269531,0.605468 -2e-6,0.119794 -0.02279,0.233726 -0.06836,0.341797 -0.04427,0.106773 -0.125653,0.233075 -0.244141,0.378906 -0.03255,0.03776 -0.136069,0.147137 -0.310546,0.328125 -0.174481,0.179689 -0.420574,0.431642 -0.738282,0.75586 m 3.09961,-1.283203 c -0.177085,1e-6 -0.31771,0.06055 -0.421875,0.18164 -0.102866,0.121095 -0.154298,0.287111 -0.154297,0.498047 -1e-6,0.209636 0.05143,0.375652 0.154297,0.498047 0.104165,0.121094 0.24479,0.181641 0.421875,0.181641 0.177082,0 0.317055,-0.06055 0.419922,-0.181641 0.104164,-0.122395 0.156248,-0.288411 0.15625,-0.498047 -2e-6,-0.210936 -0.05209,-0.376952 -0.15625,-0.498047 -0.102867,-0.121092 -0.24284,-0.181639 -0.419922,-0.18164 m 0.783203,-1.236328 0,0.359375 c -0.09896,-0.04687 -0.199221,-0.08268 -0.300781,-0.107422 -0.100263,-0.02474 -0.199872,-0.03711 -0.298829,-0.03711 -0.260417,3e-6 -0.459636,0.08789 -0.597656,0.263672 -0.136719,0.175784 -0.214844,0.441408 -0.234375,0.796875 0.07682,-0.113279 0.173176,-0.199868 0.289063,-0.259765 0.115884,-0.0612 0.243488,-0.09179 0.382812,-0.0918 0.292967,2e-6 0.524087,0.08919 0.69336,0.267578 0.17057,0.177085 0.255857,0.418621 0.255859,0.724609 -2e-6,0.29948 -0.08854,0.539714 -0.265625,0.720703 -0.177085,0.18099 -0.412762,0.271485 -0.707031,0.271485 -0.337241,0 -0.595053,-0.128907 -0.773438,-0.386719 -0.178386,-0.259114 -0.267578,-0.634114 -0.267578,-1.125 0,-0.460936 0.109375,-0.828123 0.328125,-1.101563 0.218749,-0.274736 0.512369,-0.412106 0.880859,-0.412109 0.09896,3e-6 0.198567,0.0098 0.298829,0.0293 0.10156,0.01953 0.207029,0.04883 0.316406,0.08789\" 
inkscape:connector-curvature=\"0\" 
id=\"text2456\" 
style=\"font-size:4px;font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;text-align:center;line-height:120.00000477%%;writing-mode:lr-tb;text-anchor:middle;fill:#ffffff;fill-opacity:1;stroke:none;font-family:Sans;-inkscape-font-specification:Sans\" /> 
<path 
d=\"m 86.806656,24.054766 c -0.177085,10e-7 -0.317709,0.06055 -0.421875,0.18164 -0.102865,0.121095 -0.154298,0.287111 -0.154297,0.498047 -10e-7,0.209636 0.05143,0.375652 0.154297,0.498047 0.104166,0.121094 0.24479,0.181641 0.421875,0.181641 0.177082,0 0.317056,-0.06055 0.419922,-0.181641 0.104165,-0.122395 0.156248,-0.288411 0.15625,-0.498047 -2e-6,-0.210936 -0.05209,-0.376952 -0.15625,-0.498047 -0.102866,-0.121092 -0.24284,-0.181639 -0.419922,-0.18164 m 0.783203,-1.236328 0,0.359375 c -0.09896,-0.04687 -0.199221,-0.08268 -0.300781,-0.107422 -0.100262,-0.02474 -0.199872,-0.03711 -0.298828,-0.03711 -0.260418,3e-6 -0.459637,0.08789 -0.597657,0.263672 -0.136719,0.175784 -0.214844,0.441408 -0.234375,0.796875 0.07682,-0.113279 0.173177,-0.199868 0.289063,-0.259765 0.115884,-0.0612 0.243488,-0.0918 0.382812,-0.0918 0.292967,2e-6 0.524087,0.08919 0.69336,0.267578 0.17057,0.177085 0.255857,0.418621 0.255859,0.724609 -2e-6,0.29948 -0.08854,0.539714 -0.265625,0.720703 -0.177085,0.18099 -0.412762,0.271485 -0.707031,0.271485 -0.337241,0 -0.595053,-0.128906 -0.773438,-0.386719 -0.178385,-0.259114 -0.267578,-0.634114 -0.267578,-1.125 0,-0.460936 0.109375,-0.828123 0.328125,-1.101563 0.218749,-0.274736 0.512369,-0.412106 0.88086,-0.412109 0.09896,3e-6 0.198566,0.0098 0.298828,0.0293 0.10156,0.01953 0.207029,0.04883 0.316406,0.08789 m -2.880859,7.319531 0.644531,0 0,-2.224609 -0.701172,0.140625 0,-0.359375 0.697266,-0.140625 0.394531,0 0,2.583984 0.644531,0 0,0.332031 -1.679687,0 0,-0.332031 m 3.673828,-1.240234 c 0.1888,0.04037 0.335935,0.12435 0.441406,0.251953 0.106769,0.127605 0.160154,0.285157 0.160156,0.472656 -2e-6,0.287761 -0.09896,0.510417 -0.296875,0.667969 -0.197918,0.157552 -0.479168,0.236328 -0.84375,0.236328 -0.122397,0 -0.248698,-0.01237 -0.378906,-0.03711 -0.128907,-0.02344 -0.26237,-0.05925 -0.400391,-0.107422 l 0,-0.38086 c 0.109375,0.0638 0.229167,0.11198 0.359375,0.144532 0.130208,0.03255 0.266275,0.04883 0.408204,0.04883 0.247394,0 0.435545,-0.04883 0.564453,-0.146485 0.130206,-0.09765 0.19531,-0.239582 0.195312,-0.425781 -2e-6,-0.171874 -0.06055,-0.305988 -0.18164,-0.402344 -0.119794,-0.09765 -0.287111,-0.146483 -0.501954,-0.146484 l -0.339843,0 0,-0.324219 0.355468,0 c 0.194009,2e-6 0.342447,-0.03841 0.445313,-0.115234 0.102863,-0.07812 0.154295,-0.190102 0.154297,-0.335938 -2e-6,-0.149737 -0.05339,-0.26432 -0.160156,-0.34375 -0.105471,-0.08073 -0.257163,-0.121091 -0.455079,-0.121093 -0.108074,2e-6 -0.223959,0.01172 -0.347656,0.03516 -0.123698,0.02344 -0.259766,0.0599 -0.408203,0.109375 l 0,-0.351563 c 0.149739,-0.04166 0.289713,-0.07291 0.419922,-0.09375 0.131509,-0.02083 0.255207,-0.03125 0.371094,-0.03125 0.299477,3e-6 0.536456,0.06836 0.710937,0.205078 0.174477,0.13542 0.261717,0.319013 0.261719,0.550782 -2e-6,0.16146 -0.04623,0.298179 -0.138672,0.410156 -0.09245,0.110679 -0.22396,0.187502 -0.394531,0.230469 m -3.402344,6.040234 1.376953,0 0,0.332031 -1.851562,0 0,-0.332031 c 0.149739,-0.154947 0.353515,-0.362629 0.611328,-0.623047 0.259113,-0.261717 0.421873,-0.430337 0.488281,-0.505859 0.126301,-0.141926 0.214191,-0.261717 0.263672,-0.359375 0.05078,-0.09896 0.07617,-0.195962 0.07617,-0.291016 -2e-6,-0.154945 -0.05469,-0.281247 -0.164063,-0.378906 -0.108074,-0.09765 -0.24935,-0.146482 -0.423828,-0.146484 -0.123699,2e-6 -0.254558,0.02149 -0.392578,0.06445 -0.136719,0.04297 -0.283204,0.108075 -0.439453,0.195312 l 0,-0.398437 c 0.158854,-0.0638 0.307291,-0.111976 0.445312,-0.144531 0.13802,-0.03255 0.264322,-0.04883 0.378907,-0.04883 0.302082,3e-6 0.542967,0.07552 0.722656,0.226563 0.179685,0.151044 0.269529,0.352867 0.269531,0.605469 -2e-6,0.119793 -0.02279,0.233726 -0.06836,0.341797 -0.04427,0.106772 -0.125653,0.233074 -0.244141,0.378906 -0.03255,0.03776 -0.136069,0.147137 -0.310547,0.328125 -0.17448,0.179688 -0.420574,0.431641 -0.738281,0.755859 m 3.050781,-2.324219 c -0.203126,3e-6 -0.35612,0.100263 -0.458984,0.300782 -0.101563,0.199221 -0.152345,0.499351 -0.152344,0.90039 -10e-7,0.399741 0.05078,0.699871 0.152344,0.900391 0.102864,0.199219 0.255858,0.298828 0.458984,0.298828 0.204426,0 0.357421,-0.09961 0.458985,-0.298828 0.102862,-0.20052 0.154295,-0.50065 0.154297,-0.900391 -2e-6,-0.401039 -0.05143,-0.701169 -0.154297,-0.90039 -0.101564,-0.200519 -0.254559,-0.300779 -0.458985,-0.300782 m 0,-0.3125 c 0.326822,3e-6 0.57617,0.129561 0.748047,0.388672 0.173175,0.257815 0.259763,0.632815 0.259766,1.125 -3e-6,0.490887 -0.08659,0.865886 -0.259766,1.125 -0.171877,0.257813 -0.421225,0.386719 -0.748047,0.386719 -0.326824,0 -0.576823,-0.128906 -0.75,-0.386719 -0.171875,-0.259114 -0.257813,-0.634113 -0.257812,-1.125 -10e-7,-0.492185 0.08594,-0.867185 0.257812,-1.125 0.173177,-0.259111 0.423176,-0.388669 0.75,-0.388672 m -3.050781,7.436719 1.376953,0 0,0.332032 -1.851562,0 0,-0.332032 c 0.149739,-0.154947 0.353515,-0.362629 0.611328,-0.623046 0.259113,-0.261718 0.421873,-0.430338 0.488281,-0.50586 0.126301,-0.141925 0.214191,-0.261717 0.263672,-0.359375 0.05078,-0.09896 0.07617,-0.195961 0.07617,-0.291015 -2e-6,-0.154946 -0.05469,-0.281248 -0.164063,-0.378907 -0.108074,-0.09765 -0.24935,-0.146481 -0.423828,-0.146484 -0.123699,3e-6 -0.254558,0.02149 -0.392578,0.06445 -0.136719,0.04297 -0.283204,0.108075 -0.439453,0.195313 l 0,-0.398438 c 0.158854,-0.0638 0.307291,-0.111976 0.445312,-0.144531 0.13802,-0.03255 0.264322,-0.04883 0.378907,-0.04883 0.302082,3e-6 0.542967,0.07552 0.722656,0.226562 0.179685,0.151044 0.269529,0.352867 0.269531,0.605469 -2e-6,0.119794 -0.02279,0.233726 -0.06836,0.341797 -0.04427,0.106772 -0.125653,0.233074 -0.244141,0.378906 -0.03255,0.03776 -0.136069,0.147137 -0.310547,0.328125 -0.17448,0.179688 -0.420574,0.431641 -0.738281,0.755859 m 2.107422,-2.583984 1.875,0 0,0.167969 -1.058594,2.748047 -0.412109,0 0.996094,-2.583985 -1.400391,0 0,-0.332031\" 
inkscape:connector-curvature=\"0\" 
id=\"text2466\" 
style=\"font-size:4px;font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;text-align:center;line-height:120.00000477%%;writing-mode:lr-tb;text-anchor:middle;fill:#ffffff;fill-opacity:1;stroke:none;font-family:Sans;-inkscape-font-specification:Sans\" /> 
<path 
d=\"m 93.447746,22.697344 1.875,0 0,0.167969 -1.058593,2.748046 -0.41211,0 0.996094,-2.583984 -1.400391,0 0,-0.332031 m -1.105468,7.383984 0.644531,0 0,-2.224609 -0.701172,0.140625 0,-0.359375 0.697266,-0.140625 0.394531,0 0,2.583984 0.644531,0 0,0.332032 -1.679687,0 0,-0.332032 m 3.5625,-2.240234 -0.996094,1.556641 0.996094,0 0,-1.556641 m -0.103516,-0.34375 0.496094,0 0,1.900391 0.416015,0 0,0.328125 -0.416015,0 0,0.6875 -0.392578,0 0,-0.6875 -1.316407,0 0,-0.38086 1.212891,-1.847656 m -3.1875,7.383985 1.376953,0 0,0.332031 -1.851562,0 0,-0.332031 c 0.149739,-0.154948 0.353515,-0.36263 0.611328,-0.623047 0.259113,-0.261718 0.421873,-0.430337 0.488281,-0.50586 0.1263,-0.141925 0.214191,-0.261717 0.263672,-0.359375 0.05078,-0.09896 0.07617,-0.195961 0.07617,-0.291015 -2e-6,-0.154946 -0.05469,-0.281248 -0.164063,-0.378907 -0.108074,-0.09765 -0.24935,-0.146481 -0.423828,-0.146484 -0.123699,3e-6 -0.254558,0.02149 -0.392578,0.06445 -0.136719,0.04297 -0.283204,0.108076 -0.439453,0.195313 l 0,-0.398438 c 0.158853,-0.0638 0.307291,-0.111976 0.445312,-0.144531 0.13802,-0.03255 0.264322,-0.04883 0.378907,-0.04883 0.302081,3e-6 0.542967,0.07552 0.722656,0.226562 0.179685,0.151045 0.269529,0.352867 0.269531,0.605469 -2e-6,0.119794 -0.02279,0.233726 -0.06836,0.341797 -0.04427,0.106772 -0.125653,0.233074 -0.244141,0.378906 -0.03255,0.03776 -0.136069,0.147137 -0.310547,0.328125 -0.17448,0.179689 -0.420574,0.431641 -0.738281,0.75586 m 2.275391,0 0.644531,0 0,-2.22461 -0.701172,0.140625 0,-0.359375 0.697266,-0.140625 0.394531,0 0,2.583985 0.644531,0 0,0.332031 -1.679687,0 0,-0.332031 m -2.275391,4.8 1.376953,0 0,0.332031 -1.851562,0 0,-0.332031 c 0.149739,-0.154948 0.353515,-0.36263 0.611328,-0.623047 0.259113,-0.261718 0.421873,-0.430337 0.488281,-0.505859 0.1263,-0.141926 0.214191,-0.261718 0.263672,-0.359375 0.05078,-0.09896 0.07617,-0.195962 0.07617,-0.291016 -2e-6,-0.154946 -0.05469,-0.281248 -0.164063,-0.378906 -0.108074,-0.09765 -0.24935,-0.146482 -0.423828,-0.146485 -0.123699,3e-6 -0.254558,0.02149 -0.392578,0.06445 -0.136719,0.04297 -0.283204,0.108076 -0.439453,0.195313 l 0,-0.398438 c 0.158853,-0.0638 0.307291,-0.111976 0.445312,-0.144531 0.13802,-0.03255 0.264322,-0.04883 0.378907,-0.04883 0.302081,3e-6 0.542967,0.07552 0.722656,0.226563 0.179685,0.151044 0.269529,0.352866 0.269531,0.605468 -2e-6,0.119794 -0.02279,0.233726 -0.06836,0.341797 -0.04427,0.106773 -0.125653,0.233075 -0.244141,0.378906 -0.03255,0.03776 -0.136069,0.147137 -0.310547,0.328125 -0.17448,0.179689 -0.420574,0.431642 -0.738281,0.75586 m 3.050781,-1.052735 c -0.187501,2e-6 -0.335287,0.05013 -0.443359,0.150391 -0.106772,0.100262 -0.160157,0.238282 -0.160156,0.414063 -10e-7,0.175781 0.05338,0.313802 0.160156,0.414062 0.108072,0.100261 0.255858,0.150391 0.443359,0.150391 0.187499,0 0.335285,-0.05013 0.44336,-0.150391 0.108071,-0.101562 0.162107,-0.239583 0.162109,-0.414062 -2e-6,-0.175781 -0.05404,-0.313801 -0.162109,-0.414063 -0.106773,-0.100259 -0.254559,-0.150389 -0.44336,-0.150391 m -0.394531,-0.167968 c -0.169272,-0.04166 -0.301433,-0.120441 -0.396484,-0.236328 -0.09375,-0.115884 -0.140626,-0.25716 -0.140625,-0.423829 -10e-7,-0.23307 0.08268,-0.417315 0.248046,-0.552734 0.166666,-0.135414 0.394531,-0.203122 0.683594,-0.203125 0.290363,3e-6 0.518228,0.06771 0.683594,0.203125 0.165362,0.135419 0.248045,0.319664 0.248047,0.552734 -2e-6,0.166669 -0.04753,0.307945 -0.142578,0.423829 -0.09375,0.115887 -0.224612,0.194663 -0.392578,0.236328 0.190102,0.04427 0.337888,0.13086 0.443359,0.259765 0.106769,0.128908 0.160154,0.28646 0.160156,0.472657 -2e-6,0.282552 -0.08659,0.499349 -0.259765,0.65039 -0.171877,0.151042 -0.418622,0.226563 -0.740235,0.226563 -0.321615,0 -0.569011,-0.07552 -0.742187,-0.226563 -0.171876,-0.151041 -0.257813,-0.367838 -0.257813,-0.65039 0,-0.186197 0.05339,-0.343749 0.160156,-0.472657 0.106771,-0.128905 0.255208,-0.215493 0.445313,-0.259765 m -0.144531,-0.623047 c -10e-7,0.151043 0.04687,0.268882 0.140625,0.353515 0.09505,0.08464 0.227863,0.126955 0.398437,0.126954 0.16927,10e-7 0.301431,-0.04232 0.396485,-0.126954 0.09635,-0.08463 0.144529,-0.202472 0.144531,-0.353515 -2e-6,-0.15104 -0.04818,-0.268878 -0.144531,-0.353516 -0.09505,-0.08463 -0.227215,-0.12695 -0.396485,-0.126953 -0.170574,3e-6 -0.303386,0.04232 -0.398437,0.126953 -0.09375,0.08464 -0.140626,0.202476 -0.140625,0.353516\" 
inkscape:connector-curvature=\"0\" 
id=\"text2476\" 
style=\"font-size:4px;font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;text-align:center;line-height:120.00000477%%;writing-mode:lr-tb;text-anchor:middle;fill:#ffffff;fill-opacity:1;stroke:none;font-family:Sans;-inkscape-font-specification:Sans\" /> 
<path 
d=\"m 101.29781,20.481327 0.64453,0 0,-2.224609 -0.70117,0.140625 0,-0.359375 0.69727,-0.140625 0.39453,0 0,2.583984 0.64453,0 0,0.332031 -1.67969,0 0,-0.332031 m 0.77539,3.747266 c -0.1875,1e-6 -0.33528,0.05013 -0.44336,0.15039 -0.10677,0.100262 -0.16015,0.238283 -0.16015,0.414063 0,0.175782 0.0534,0.313803 0.16015,0.414062 0.10808,0.100261 0.25586,0.150391 0.44336,0.150391 0.1875,0 0.33529,-0.05013 0.44336,-0.150391 0.10807,-0.101561 0.16211,-0.239582 0.16211,-0.414062 0,-0.17578 -0.054,-0.313801 -0.16211,-0.414063 -0.10677,-0.100259 -0.25456,-0.150389 -0.44336,-0.15039 m -0.39453,-0.167969 c -0.16927,-0.04167 -0.30143,-0.120441 -0.39648,-0.236328 -0.0937,-0.115884 -0.14063,-0.257159 -0.14063,-0.423828 0,-0.233071 0.0827,-0.417315 0.24805,-0.552735 0.16667,-0.135413 0.39453,-0.203122 0.68359,-0.203125 0.29037,3e-6 0.51823,0.06771 0.6836,0.203125 0.16536,0.13542 0.24804,0.319664 0.24804,0.552735 0,0.166669 -0.0475,0.307944 -0.14257,0.423828 -0.0938,0.115887 -0.22461,0.194663 -0.39258,0.236328 0.1901,0.04427 0.33789,0.130861 0.44336,0.259766 0.10677,0.128907 0.16015,0.286459 0.16015,0.472656 0,0.282553 -0.0866,0.499349 -0.25976,0.650391 -0.17188,0.151041 -0.41862,0.226562 -0.74024,0.226562 -0.32161,0 -0.56901,-0.07552 -0.74218,-0.226562 -0.17188,-0.151042 -0.25782,-0.367838 -0.25782,-0.650391 0,-0.186197 0.0534,-0.343749 0.16016,-0.472656 0.10677,-0.128905 0.25521,-0.215494 0.44531,-0.259766 m -0.14453,-0.623047 c 0,0.151044 0.0469,0.268882 0.14063,0.353516 0.0951,0.08464 0.22786,0.126955 0.39843,0.126953 0.16927,2e-6 0.30143,-0.04232 0.39649,-0.126953 0.0964,-0.08463 0.14453,-0.202472 0.14453,-0.353516 0,-0.151039 -0.0482,-0.268878 -0.14453,-0.353515 -0.0951,-0.08463 -0.22722,-0.126951 -0.39649,-0.126954 -0.17057,3e-6 -0.30338,0.04232 -0.39843,0.126954 -0.0937,0.08464 -0.14063,0.202476 -0.14063,0.353515 m -1.50976,6.64375 0.64453,0 0,-2.224609 -0.701175,0.140625 0,-0.359375 0.697265,-0.140625 0.39453,0 0,2.583984 0.64453,0 0,0.332032 -1.67968,0 0,-0.332032 m 2.48242,-2.583984 1.54883,0 0,0.332031 -1.1875,0 0,0.714844 c 0.0573,-0.01953 0.11458,-0.03385 0.17187,-0.04297 0.0573,-0.01041 0.11458,-0.01562 0.17188,-0.01563 0.32552,2e-6 0.58333,0.0892 0.77343,0.267578 0.19011,0.178387 0.28516,0.419924 0.28516,0.72461 0,0.313803 -0.0977,0.557943 -0.29297,0.732422 -0.19531,0.173177 -0.4707,0.259765 -0.82617,0.259765 -0.1224,0 -0.2474,-0.01042 -0.375,-0.03125 -0.1263,-0.02083 -0.25716,-0.05208 -0.39258,-0.09375 l 0,-0.396484 c 0.11719,0.0638 0.23828,0.111328 0.36328,0.142578 0.125,0.03125 0.25716,0.04687 0.39649,0.04687 0.22526,0 0.40364,-0.05924 0.53515,-0.177734 0.13151,-0.118489 0.19727,-0.279296 0.19727,-0.482422 0,-0.203124 -0.0658,-0.363931 -0.19727,-0.482422 -0.13151,-0.118488 -0.30989,-0.177733 -0.53515,-0.177734 -0.10547,1e-6 -0.21094,0.01172 -0.31641,0.03516 -0.10417,0.02344 -0.21094,0.0599 -0.32031,0.109375 l 0,-1.464844 m -2.21094,7.383985 1.37695,0 0,0.332031 -1.851559,0 0,-0.332031 c 0.149739,-0.154948 0.353519,-0.36263 0.611329,-0.623047 0.25911,-0.261718 0.42187,-0.430337 0.48828,-0.50586 0.1263,-0.141925 0.21419,-0.261717 0.26367,-0.359375 0.0508,-0.09896 0.0762,-0.195961 0.0762,-0.291015 0,-0.154946 -0.0547,-0.281248 -0.16406,-0.378906 -0.10807,-0.09765 -0.24935,-0.146482 -0.42383,-0.146485 -0.1237,3e-6 -0.25455,0.02149 -0.39257,0.06445 -0.13672,0.04297 -0.283208,0.108076 -0.439458,0.195313 l 0,-0.398438 c 0.158854,-0.0638 0.307288,-0.111976 0.445308,-0.144531 0.13802,-0.03255 0.26433,-0.04883 0.37891,-0.04883 0.30208,3e-6 0.54297,0.07552 0.72266,0.226562 0.17968,0.151045 0.26953,0.352867 0.26953,0.605469 0,0.119794 -0.0228,0.233726 -0.0684,0.341797 -0.0443,0.106773 -0.12565,0.233074 -0.24414,0.378906 -0.0326,0.03776 -0.13607,0.147137 -0.31055,0.328125 -0.17448,0.179689 -0.42057,0.431642 -0.73828,0.75586 m 2.54688,0 1.37695,0 0,0.332031 -1.85156,0 0,-0.332031 c 0.14974,-0.154948 0.35351,-0.36263 0.61132,-0.623047 0.25912,-0.261718 0.42188,-0.430337 0.48829,-0.50586 0.1263,-0.141925 0.21419,-0.261717 0.26367,-0.359375 0.0508,-0.09896 0.0762,-0.195961 0.0762,-0.291015 0,-0.154946 -0.0547,-0.281248 -0.16406,-0.378906 -0.10808,-0.09765 -0.24935,-0.146482 -0.42383,-0.146485 -0.1237,3e-6 -0.25456,0.02149 -0.39258,0.06445 -0.13672,0.04297 -0.2832,0.108076 -0.43945,0.195313 l 0,-0.398438 c 0.15885,-0.0638 0.30729,-0.111976 0.44531,-0.144531 0.13802,-0.03255 0.26432,-0.04883 0.37891,-0.04883 0.30208,3e-6 0.54296,0.07552 0.72265,0.226562 0.17969,0.151045 0.26953,0.352867 0.26953,0.605469 0,0.119794 -0.0228,0.233726 -0.0684,0.341797 -0.0443,0.106773 -0.12565,0.233074 -0.24414,0.378906 -0.0326,0.03776 -0.13607,0.147137 -0.31054,0.328125 -0.17448,0.179689 -0.42058,0.431642 -0.73828,0.75586 m -2.54688,4.8 1.37695,0 0,0.332031 -1.851559,0 0,-0.332031 c 0.149739,-0.154948 0.353519,-0.36263 0.611329,-0.623047 0.25911,-0.261718 0.42187,-0.430337 0.48828,-0.505859 0.1263,-0.141926 0.21419,-0.261717 0.26367,-0.359375 0.0508,-0.09896 0.0762,-0.195962 0.0762,-0.291016 0,-0.154946 -0.0547,-0.281248 -0.16406,-0.378906 -0.10807,-0.09765 -0.24935,-0.146482 -0.42383,-0.146485 -0.1237,3e-6 -0.25455,0.02149 -0.39257,0.06445 -0.13672,0.04297 -0.283208,0.108076 -0.439458,0.195313 l 0,-0.398438 c 0.158854,-0.0638 0.307288,-0.111976 0.445308,-0.144531 0.13802,-0.03255 0.26433,-0.04883 0.37891,-0.04883 0.30208,3e-6 0.54297,0.07552 0.72266,0.226563 0.17968,0.151044 0.26953,0.352867 0.26953,0.605468 0,0.119794 -0.0228,0.233726 -0.0684,0.341797 -0.0443,0.106773 -0.12565,0.233075 -0.24414,0.378906 -0.0326,0.03776 -0.13607,0.147137 -0.31055,0.328125 -0.17448,0.179689 -0.42057,0.431642 -0.73828,0.75586 m 2.21875,0.271484 0,-0.359375 c 0.099,0.04688 0.19922,0.08268 0.30078,0.107422 0.10156,0.02474 0.20117,0.03711 0.29883,0.03711 0.26042,1e-6 0.45898,-0.08724 0.5957,-0.261718 0.13802,-0.175781 0.2168,-0.442057 0.23633,-0.798828 -0.0755,0.11198 -0.17122,0.197917 -0.28711,0.257812 -0.11589,0.0599 -0.24414,0.08984 -0.38476,0.08984 -0.29167,10e-7 -0.52279,-0.08789 -0.69336,-0.263672 -0.16927,-0.177082 -0.25391,-0.418618 -0.25391,-0.724609 0,-0.299477 0.0885,-0.539711 0.26563,-0.720704 0.17708,-0.180986 0.41275,-0.271481 0.70703,-0.271484 0.33723,3e-6 0.5944,0.12956 0.77148,0.388672 0.17838,0.257815 0.26758,0.632814 0.26758,1.125 0,0.459636 -0.10938,0.826823 -0.32813,1.101562 -0.21745,0.273438 -0.51041,0.410157 -0.8789,0.410157 -0.099,0 -0.19922,-0.0098 -0.30078,-0.0293 -0.10157,-0.01953 -0.20704,-0.04883 -0.31641,-0.08789 m 0.78516,-1.236328 c 0.17708,1e-6 0.31705,-0.06055 0.41992,-0.181641 0.10416,-0.121092 0.15625,-0.287107 0.15625,-0.498046 0,-0.209634 -0.0521,-0.374998 -0.15625,-0.496094 -0.10287,-0.122393 -0.24284,-0.183591 -0.41992,-0.183594 -0.17709,3e-6 -0.31771,0.0612 -0.42188,0.183594 -0.10286,0.121096 -0.1543,0.28646 -0.1543,0.496094 0,0.210939 0.0514,0.376954 0.1543,0.498046 0.10417,0.121096 0.24479,0.181642 0.42188,0.181641\" 
inkscape:connector-curvature=\"0\" 
id=\"text2486\" 
style=\"font-size:4px;font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;text-align:center;line-height:120.00000477%%;writing-mode:lr-tb;text-anchor:middle;fill:#ffffff;fill-opacity:1;stroke:none;font-family:Sans;-inkscape-font-specification:Sans\" /> 
<path 
d=\"m 109.20845,20.481327 1.37695,0 0,0.332031 -1.85156,0 0,-0.332031 c 0.14974,-0.154947 0.35352,-0.362629 0.61133,-0.623047 0.25911,-0.261717 0.42187,-0.430337 0.48828,-0.505859 0.1263,-0.141926 0.21419,-0.261717 0.26367,-0.359375 0.0508,-0.09896 0.0762,-0.195962 0.0762,-0.291016 0,-0.154945 -0.0547,-0.281247 -0.16406,-0.378906 -0.10807,-0.09765 -0.24935,-0.146482 -0.42383,-0.146484 -0.1237,2e-6 -0.25455,0.02149 -0.39257,0.06445 -0.13672,0.04297 -0.28321,0.108075 -0.43946,0.195312 l 0,-0.398437 c 0.15886,-0.0638 0.30729,-0.111977 0.44531,-0.144532 0.13802,-0.03255 0.26433,-0.04883 0.37891,-0.04883 0.30208,3e-6 0.54297,0.07552 0.72266,0.226563 0.17968,0.151044 0.26953,0.352867 0.26953,0.605469 0,0.119793 -0.0228,0.233725 -0.0684,0.341796 -0.0443,0.106773 -0.12565,0.233075 -0.24414,0.378907 -0.0326,0.03776 -0.13607,0.147136 -0.31055,0.328125 -0.17448,0.179688 -0.42057,0.431641 -0.73828,0.755859 m -0.32812,5.071485 0,-0.359375 c 0.099,0.04687 0.19921,0.08268 0.30078,0.107421 0.10156,0.02474 0.20117,0.03711 0.29882,0.03711 0.26042,0 0.45899,-0.08724 0.59571,-0.261719 0.13802,-0.17578 0.21679,-0.442056 0.23633,-0.798828 -0.0755,0.11198 -0.17123,0.197918 -0.28711,0.257812 -0.11589,0.0599 -0.24415,0.08984 -0.38477,0.08984 -0.29167,1e-6 -0.52279,-0.08789 -0.69336,-0.263672 -0.16927,-0.177082 -0.2539,-0.418618 -0.2539,-0.724609 0,-0.299477 0.0885,-0.539711 0.26562,-0.720703 0.17708,-0.180987 0.41276,-0.271482 0.70703,-0.271485 0.33724,3e-6 0.5944,0.129561 0.77149,0.388672 0.17838,0.257815 0.26757,0.632815 0.26757,1.125 0,0.459637 -0.10937,0.826824 -0.32812,1.101563 -0.21745,0.273437 -0.51042,0.410156 -0.87891,0.410156 -0.099,0 -0.19922,-0.0098 -0.30078,-0.0293 -0.10156,-0.01953 -0.20703,-0.04883 -0.3164,-0.08789 m 0.78515,-1.236329 c 0.17708,2e-6 0.31706,-0.06055 0.41992,-0.18164 0.10417,-0.121092 0.15625,-0.287108 0.15625,-0.498047 0,-0.209633 -0.0521,-0.374998 -0.15625,-0.496094 -0.10286,-0.122393 -0.24284,-0.183591 -0.41992,-0.183594 -0.17708,3e-6 -0.31771,0.0612 -0.42187,0.183594 -0.10287,0.121096 -0.1543,0.286461 -0.1543,0.496094 0,0.210939 0.0514,0.376955 0.1543,0.498047 0.10416,0.121095 0.24479,0.181642 0.42187,0.18164 m -2.00195,5.764844 0.64453,0 0,-2.224609 -0.70117,0.140625 0,-0.359375 0.69726,-0.140625 0.39453,0 0,2.583984 0.64454,0 0,0.332032 -1.67969,0 0,-0.332032 m 3.37109,-1.283203 c -0.17708,2e-6 -0.31771,0.06055 -0.42187,0.181641 -0.10287,0.121095 -0.1543,0.28711 -0.1543,0.498047 0,0.209636 0.0514,0.375651 0.1543,0.498047 0.10416,0.121094 0.24479,0.181641 0.42187,0.18164 0.17708,1e-6 0.31706,-0.06055 0.41992,-0.18164 0.10417,-0.122396 0.15625,-0.288411 0.15625,-0.498047 0,-0.210937 -0.0521,-0.376952 -0.15625,-0.498047 -0.10286,-0.121092 -0.24284,-0.181639 -0.41992,-0.181641 m 0.78321,-1.236328 0,0.359375 c -0.099,-0.04687 -0.19923,-0.08268 -0.30079,-0.107422 -0.10026,-0.02474 -0.19987,-0.03711 -0.29882,-0.03711 -0.26042,3e-6 -0.45964,0.08789 -0.59766,0.263672 -0.13672,0.175783 -0.21484,0.441408 -0.23438,0.796875 0.0768,-0.11328 0.17318,-0.199868 0.28907,-0.259766 0.11588,-0.0612 0.24349,-0.0918 0.38281,-0.0918 0.29297,2e-6 0.52409,0.0892 0.69336,0.267578 0.17057,0.177085 0.25586,0.418621 0.25586,0.72461 0,0.29948 -0.0885,0.539714 -0.26563,0.720703 -0.17708,0.18099 -0.41276,0.271484 -0.70703,0.271484 -0.33724,0 -0.59505,-0.128906 -0.77344,-0.386718 -0.17838,-0.259114 -0.26757,-0.634114 -0.26757,-1.125 0,-0.460936 0.10937,-0.828123 0.32812,-1.101563 0.21875,-0.274737 0.51237,-0.412106 0.88086,-0.412109 0.099,3e-6 0.19857,0.0098 0.29883,0.0293 0.10156,0.01953 0.20703,0.04883 0.31641,0.08789 m -3.88282,7.319532 1.37696,0 0,0.332031 -1.85157,0 0,-0.332031 c 0.14974,-0.154948 0.35352,-0.36263 0.61133,-0.623047 0.25911,-0.261718 0.42188,-0.430337 0.48828,-0.50586 0.1263,-0.141925 0.21419,-0.261717 0.26367,-0.359375 0.0508,-0.09896 0.0762,-0.195961 0.0762,-0.291015 -1e-5,-0.154946 -0.0547,-0.281248 -0.16407,-0.378906 -0.10807,-0.09765 -0.24935,-0.146482 -0.42382,-0.146485 -0.1237,3e-6 -0.25456,0.02149 -0.39258,0.06445 -0.13672,0.04297 -0.28321,0.108076 -0.43946,0.195313 l 0,-0.398438 c 0.15886,-0.0638 0.3073,-0.111976 0.44532,-0.144531 0.13802,-0.03255 0.26432,-0.04883 0.3789,-0.04883 0.30209,3e-6 0.54297,0.07552 0.72266,0.226562 0.17969,0.151045 0.26953,0.352867 0.26953,0.605469 0,0.119794 -0.0228,0.233726 -0.0684,0.341797 -0.0443,0.106773 -0.12565,0.233074 -0.24414,0.378906 -0.0326,0.03776 -0.13607,0.147137 -0.31055,0.328125 -0.17448,0.179689 -0.42057,0.431642 -0.73828,0.75586 m 3.40235,-1.240235 c 0.1888,0.04037 0.33593,0.124351 0.4414,0.251953 0.10677,0.127606 0.16016,0.285158 0.16016,0.472657 0,0.287761 -0.099,0.510417 -0.29688,0.667968 -0.19791,0.157552 -0.47916,0.236328 -0.84375,0.236329 -0.12239,-10e-7 -0.24869,-0.01237 -0.3789,-0.03711 -0.12891,-0.02344 -0.26237,-0.05924 -0.40039,-0.107422 l 0,-0.380859 c 0.10937,0.0638 0.22916,0.111979 0.35937,0.144531 0.13021,0.03255 0.26628,0.04883 0.40821,0.04883 0.24739,10e-7 0.43554,-0.04883 0.56445,-0.146484 0.13021,-0.09766 0.19531,-0.239583 0.19531,-0.425781 0,-0.171874 -0.0606,-0.305989 -0.18164,-0.402344 -0.11979,-0.09765 -0.28711,-0.146483 -0.50195,-0.146484 l -0.33985,0 0,-0.324219 0.35547,0 c 0.19401,10e-7 0.34245,-0.03841 0.44531,-0.115235 0.10287,-0.07812 0.1543,-0.190102 0.1543,-0.335937 0,-0.149737 -0.0534,-0.264321 -0.16015,-0.34375 -0.10547,-0.08073 -0.25717,-0.121091 -0.45508,-0.121094 -0.10808,3e-6 -0.22396,0.01172 -0.34766,0.03516 -0.1237,0.02344 -0.25977,0.0599 -0.4082,0.109375 l 0,-0.351562 c 0.14974,-0.04166 0.28971,-0.07291 0.41992,-0.09375 0.13151,-0.02083 0.25521,-0.03125 0.37109,-0.03125 0.29948,3e-6 0.53646,0.06836 0.71094,0.205078 0.17448,0.135419 0.26172,0.319013 0.26172,0.550781 0,0.161461 -0.0462,0.298179 -0.13867,0.410157 -0.0925,0.110678 -0.22396,0.187501 -0.39453,0.230468 m -2.54688,4.8 c 0.1888,0.04037 0.33594,0.124351 0.44141,0.251954 0.10677,0.127605 0.16015,0.285157 0.16015,0.472656 0,0.287761 -0.099,0.510417 -0.29687,0.667969 -0.19792,0.157552 -0.47917,0.236328 -0.84375,0.236328 -0.1224,0 -0.2487,-0.01237 -0.37891,-0.03711 -0.1289,-0.02344 -0.26237,-0.05924 -0.40039,-0.107422 l 0,-0.380859 c 0.10938,0.0638 0.22917,0.11198 0.35938,0.144531 0.1302,0.03255 0.26627,0.04883 0.4082,0.04883 0.24739,10e-7 0.43555,-0.04883 0.56445,-0.146484 0.13021,-0.09766 0.19531,-0.239583 0.19532,-0.425781 -1e-5,-0.171874 -0.0606,-0.305989 -0.18164,-0.402344 -0.1198,-0.09766 -0.28712,-0.146483 -0.50196,-0.146484 l -0.33984,0 0,-0.324219 0.35547,0 c 0.19401,2e-6 0.34244,-0.03841 0.44531,-0.115234 0.10286,-0.07812 0.15429,-0.190103 0.1543,-0.335938 -10e-6,-0.149737 -0.0534,-0.26432 -0.16016,-0.34375 -0.10547,-0.08073 -0.25716,-0.121091 -0.45508,-0.121094 -0.10807,3e-6 -0.22396,0.01172 -0.34765,0.03516 -0.1237,0.02344 -0.25977,0.0599 -0.40821,0.109375 l 0,-0.351563 c 0.14974,-0.04166 0.28972,-0.07291 0.41992,-0.09375 0.13151,-0.02083 0.25521,-0.03125 0.3711,-0.03125 0.29948,3e-6 0.53646,0.06836 0.71094,0.205078 0.17447,0.135419 0.26171,0.319013 0.26171,0.550781 0,0.161461 -0.0462,0.298179 -0.13867,0.410157 -0.0924,0.110678 -0.22396,0.187501 -0.39453,0.230468 m 2.19531,-1.083984 c -0.20312,3e-6 -0.35612,0.100263 -0.45898,0.300781 -0.10156,0.199221 -0.15234,0.499351 -0.15234,0.900391 0,0.399741 0.0508,0.69987 0.15234,0.900391 0.10286,0.199219 0.25586,0.298828 0.45898,0.298828 0.20443,0 0.35742,-0.09961 0.45899,-0.298828 0.10286,-0.200521 0.15429,-0.50065 0.1543,-0.900391 -1e-5,-0.40104 -0.0514,-0.70117 -0.1543,-0.900391 -0.10157,-0.200518 -0.25456,-0.300778 -0.45899,-0.300781 m 0,-0.3125 c 0.32683,3e-6 0.57617,0.12956 0.74805,0.388672 0.17318,0.257815 0.25976,0.632814 0.25977,1.125 -10e-6,0.490886 -0.0866,0.865886 -0.25977,1.125 -0.17188,0.257813 -0.42122,0.386719 -0.74805,0.386719 -0.32682,0 -0.57682,-0.128906 -0.75,-0.386719 -0.17187,-0.259114 -0.25781,-0.634114 -0.25781,-1.125 0,-0.492186 0.0859,-0.867185 0.25781,-1.125 0.17318,-0.259112 0.42318,-0.388669 0.75,-0.388672\" 
inkscape:connector-curvature=\"0\" 
id=\"text2498\" 
style=\"font-size:4px;font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;text-align:center;line-height:120.00000477%%;writing-mode:lr-tb;text-anchor:middle;fill:#ffffff;fill-opacity:1;stroke:none;font-family:Sans;-inkscape-font-specification:Sans\" /> 
</g> 
<path 
d=\"M 24.03125,12.40625 C 24.001249,12.602572 24,12.794487 24,13 c 0,2.209139 1.79086,4 4,4 2.20914,0 4,-1.790861 4,-4 0,-0.205513 -0.0012,-0.397428 -0.03125,-0.59375 C 31.764726,14.424122 30.071673,16 28,16 25.928327,16 24.235274,14.424122 24.03125,12.40625 z m 40,0 C 64.001249,12.602572 64,12.794487 64,13 c 0,2.209139 1.79086,4 4,4 2.20914,0 4,-1.790861 4,-4 0,-0.205513 -0.0012,-0.397428 -0.03125,-0.59375 C 71.764726,14.424122 70.071673,16 68,16 65.928327,16 64.235274,14.424122 64.03125,12.40625 z\" 
inkscape:connector-curvature=\"0\" 
id=\"path3739\" 
style=\"opacity:0.3;fill:#ffffff;fill-opacity:1;stroke:none\" /> 
</g> 
<g 
id=\"layer5\"> 
<rect 
width=\"66\" 
height=\"66\" 
rx=\"12\" 
ry=\"12\" 
x=\"15\" 
y=\"15\" 
clip-path=\"url(#clipPath3613)\" 
id=\"rect3171\" 
style=\"opacity:0.1;fill:url(#linearGradient3613);fill-opacity:1;fill-rule:nonzero;stroke:#ffffff;stroke-width:0.5;stroke-linecap:round;stroke-linejoin:miter;stroke-miterlimit:4;stroke-opacity:1;stroke-dasharray:none;stroke-dashoffset:0;filter:url(#filter3794)\" /> 
</g> 
<text 
xml:space=\"preserve\" 
style=\"font-size:40px;font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;line-height:125%%;letter-spacing:0px;word-spacing:0px;fill:#4d4d4d;fill-opacity:1;stroke:none;font-family:FreeSerif;-inkscape-font-specification:Sans\" 
x=\"19.948051\" 
y=\"76.36364\" 
id=\"text3073\" 
sodipodi:linespacing=\"125%%\"><tspan 
sodipodi:role=\"line\" 
id=\"tspan3075\" 
x=\"19.948051\" 
y=\"76.36364\" 
style=\"font-style:normal;font-variant:normal;font-weight:bold;font-stretch:normal;fill:#4d4d4d;font-family:Sans;-inkscape-font-specification:Sans Bold\">$DAY</tspan></text> 
<text 
xml:space=\"preserve\" 
style=\"font-size:41.79811478px;font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;line-height:125%%;letter-spacing:0px;word-spacing:0px;fill:#000000;fill-opacity:1;stroke:none;font-family:FreeSerif;-inkscape-font-specification:Sans\" 
x=\"14.193411\" 
y=\"45.137703\" 
id=\"text3079\" 
sodipodi:linespacing=\"125%%\" 
transform=\"scale(1.0449529,0.95698095)\"><tspan 
sodipodi:role=\"line\" 
id=\"tspan3081\" 
x=\"14.193411\" 
y=\"45.137703\" 
style=\"font-size:6.26971722000000042px;font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;fill:#4d4d4d;font-family:DejaVu Sans Mono;-inkscape-font-specification:DejaVu Sans Mono;letter-spacing:1.72999998px\">$WDAY</tspan></text> 
<text 
xml:space=\"preserve\" 
style=\"font-size:48.08001709px;font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;line-height:125%%;letter-spacing:0px;word-spacing:0px;fill:#ffffff;fill-opacity:1;stroke:none;font-family:FreeSerif;-inkscape-font-specification:Sans\" 
x=\"11.070971\" 
y=\"36.297848\" 
id=\"text3139\" 
sodipodi:linespacing=\"125%%\" 
transform=\"scale(1.153617,0.86683883)\"><tspan 
sodipodi:role=\"line\" 
id=\"tspan3141\" 
x=\"11.070971\" 
y=\"36.297848\" 
style=\"font-size:12.02000427px;font-style:normal;font-variant:normal;font-weight:bold;font-stretch:normal;fill:#ffffff;font-family:DejaVu Sans Mono;-inkscape-font-specification:DejaVu Sans Mono Bold\">$MONTH</tspan></text> 
</svg>" > "$ICON_DIR/icon"

    dbus-send --session --dest=org.cairodock.CairoDock /org/cairodock/CairoDock org.cairodock.CairoDock.SetIcon string:"$ICON_DIR/icon" string:"module=Calendar"
    echo "$date_TODAY" > "$ICON_DIR/.day"
} 

if test ! -e "$ICON_DIR/.day"; then 
    # this file doesn't exist 
    make_icon
elif [ `cat "$ICON_DIR/.day"` -lt $date_TODAY ];then 
    # this file exists and the date is older 
    make_icon 
elif [ "$FORCE" = "1" ]; then
    make_icon
fi 

exit
