/*
 * BitDefender-scanner Konqueror plugin
 *
 * Copyright (C) 2008 BitDefender SRL <unices@bitdefender.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; version 2
 * of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <kapplication.h>
#include <kaction.h>
#include <kgenericfactory.h>
#include <kurl.h>
#include <kstandarddirs.h>
#include "bitdefender_scanner_konqueror_plugin.h"
#include "bitdefender_scanner_konqueror_plugin.moc"

class BitDefenderScannerPluginFactory: public KGenericFactory<BitDefenderScannerPlugin, KonqPopupMenu>
{
	KSimpleConfig *m_pConfig;

	public:
		BitDefenderScannerPluginFactory(const char *instanceName = 0)
			:KGenericFactory<BitDefenderScannerPlugin, KonqPopupMenu>(instanceName)
		{
		}

		~BitDefenderScannerPluginFactory()
		{
		}
};

K_EXPORT_COMPONENT_FACTORY(libbitdefender_scanner_konqueror_plugin, BitDefenderScannerPluginFactory("bitdefender_scanner_konqueror_plugin"));

BitDefenderScannerPlugin::BitDefenderScannerPlugin(KonqPopupMenu *pPopupMenu, const char *name, const QStringList &)
	:KonqPopupMenuPlugin(pPopupMenu, name)
{
	if (QCString(kapp->name()) == "kdesktop" && !kapp->authorize("editable_desktop_icons"))
		return;

	if (KStandardDirs::findExe("bdgui").isNull())
		return;

	KFileItemList itemList = pPopupMenu->fileItemList();
	for (KFileItem *item = itemList.first(); item; item = itemList.next())
		if (item->url().isLocalFile())
			m_fileList.append(item->url().path());

	if (m_fileList.count()) {
		KAction *pAction = new KAction(i18n("Scan with BitDefender"), "bitdefender", this, SLOT(slotScanFiles()), actionCollection(), "bitdefender_menu");
		pAction->setEnabled(true);
		pAction->setIcon("bitdefender");
		addAction(pAction);
		addSeparator();
	}
}

BitDefenderScannerPlugin::~BitDefenderScannerPlugin()
{
}

void BitDefenderScannerPlugin::slotScanFiles()
{
	QStringList args;

	if (!m_fileList.count())
		return;

	args << m_fileList.front();
	kapp->kdeinitExec("bdgui", args);
}
