#!/bin/sh

#
# BitDefender-scanner xfce4 Thunar scan action
#
# Copyright (C) 2008 BitDefender SRL <unices@bitdefender.com>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
#

# The action configuration file for Thunar
THUNARCFG="$HOME/.config/Thunar/uca.xml"
BACKUP="$THUNARCFG.BD.backup"

# Check if the actions configuration file exists
if ! [ -f $THUNARCFG ]
then
	echo "Error: could not find $THUNARCFG" >&2
	echo "If you know where it is located, the please edit this script's" >&2
	echo "\$THUNARCFG variable." >&2
	exit 1
fi

# Check if the backup file exists
if ! [ -f $BACKUP ]
then
	echo "Error: the backup file was not found ($BACKUP)" >&2
	exit 2
fi

# Restore the Thunar action configuration file from the backup
if ! mv -f $BACKUP $THUNARCFG >/dev/null 2>uninstall.log
then
	echo "Error: failed to restore $THUNARCFG from backup ($BACKUP)" >&2
	echo "Please check the 'uninstall.log' file" >&2
	exit 3
fi

echo "Success!"
rm -f uninstall.log
exit 0
