#!/bin/sh

#
# BitDefender-scanner xfce4 Thunar scan action
#
# Copyright (C) 2008 BitDefender SRL <unices@bitdefender.com>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
#

# The action configuration file for Thunar
THUNARCFG=${THUNARCFG-$HOME/.config/Thunar/uca.xml}
THUNARCFGDIR="$(dirname $THUNARCFG)"
BACKUP="$THUNARCFG.BD.backup"
FILEEXISTS=1

# Our action
ACTION="<action><icon>bitdefender<\/icon><name>Scan with BitDefender<\/name><command>exo-open--working-directory %F --launch bdgui<\/command><description>Scan with BitDefender for possible malware<\/description><patterns>\*<\/patterns><directories\/><audio-files\/><image-files\/><other-files\/><text-files\/><video-files\/><\/action><\/actions>"

# Check if the actions configuration file exists
if ! [ -f $THUNARCFG ]
then
	if ! mkdir -p "$THUNARCFGDIR" >/dev/null 2>install.log
	then
		echo "Error: could not create the directory '$THUNARCFGDIR'" >&2
		exit 1
	fi
	if ! echo '<?xml encoding="UTF-8" version="1.0"?>' > $THUNARCFG >/dev/null 2>install.log
	then
		echo "Error: could not create the file '`basename $THUNARCFG`'" >&2
		exit 1
	fi
	cat >> "$THUNARCFG" <<EOSKEL
<actions>
</actions>
EOSKEL

fi

# Make sure we are not already installed
if grep "bdgui" $THUNARCFG >/dev/null 2>&1
then
	echo "Warning: it seems that you have already installed the xfce4" >&2
	echo "         Thunar scan action. Aborting." >&2
	exit 2
fi

# Create a backup
if ! cp -f $THUNARCFG $BACKUP >/dev/null 2>install.log
then
	echo "Error: failed to backup $THUNARCFG" >&2
	echo "Please check the 'install.log' file" >&2
	exit 3
fi

echo "Created a backup of $THUNARCFG in $BACKUP ..."

# Write the new action
if ! sed "s/<\/actions>/$ACTION/" "$THUNARCFG" > "$THUNARCFGDIR"/.uca.xml.BD.tmp 2>install.log
then
	echo "Error: failed to write $THUNARCFG". >&2
	echo "Please check the 'install.log' file" >&2
	exit 4
fi

# Install the new configuration file
if ! mv -f "$THUNARCFGDIR"/.uca.xml.BD.tmp $THUNARCFG >/dev/null 2>install.log
then
	echo "Error: failed to write $THUNARCFG" >&2
	echo "Please check the 'install.log' file" >&2
	exit 5
fi

echo "Success!"
rm -f install.log
exit 0
