/*
 * BitDefender-scanner Nautilus plugin
 *
 * Copyright (C) 2008 BitDefender SRL <unices@bitdefender.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; version 2
 * of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifdef __FreeBSD__
#define BITDEFENDER_CMD         "/usr/local/bin/bdgui"
#else
#define BITDEFENDER_CMD		"/usr/bin/bdgui"
#endif
#define BITDEFENDER_ICON	"bitdefender"
#define BITDEFENDER_MENU_ITEM	"Scan with BitDefender"
#define BITDEFENDER_TOOLTIP	"Scan with BitDefender"

/*#include <config.h>*/
#include <string.h>
#include <glib.h>
#include <libgnomevfs/gnome-vfs.h>
#include <libgnomevfs/gnome-vfs-utils.h>
#include <libgnomevfs/gnome-vfs-file-info.h>
#include <libgnomevfs/gnome-vfs-ops.h>
#include <libnautilus-extension/nautilus-extension-types.h>
#include <libnautilus-extension/nautilus-file-info.h>
#include <libnautilus-extension/nautilus-menu-provider.h>
#include "nautilus-bitdefender.h"

static GObjectClass *parent_class = NULL;
static GType bitdefender_type = 0;

GType nautilus_bitdefender_get_type (void)
{
	return bitdefender_type;
}

gchar* nautilus_bitdefender_parse_parameter (GList* files)
{
	gchar* retv = NULL;
	
	if (files != NULL)
	{
		GString* tmp_string = g_string_new ("");
		gchar* uri = nautilus_file_info_get_uri ((NautilusFileInfo*)files->data);
		GnomeVFSURI* gvfs_uri = gnome_vfs_uri_new (uri);
		gchar* dirname;
		gchar* scheme = nautilus_file_info_get_uri_scheme ((NautilusFileInfo*)files->data);
		gchar* path_file_list;
		GList* file_iter = NULL;
		GString* tmp_path_file_list;
		gchar* tmp;
		gchar* tmp2;
		
		tmp = gnome_vfs_uri_extract_dirname (gvfs_uri);
		dirname = (gchar*)gnome_vfs_unescape_string ((const gchar*)tmp, "");
		g_free (tmp);

		tmp = nautilus_file_info_get_name ((NautilusFileInfo*)files->data);
		if (!tmp)
		{
			tmp = g_strdup ("");
		}

		tmp2 = g_build_path ("/", dirname, tmp, NULL);
		g_free (tmp);
		tmp = g_shell_quote (tmp2);
		tmp_path_file_list = g_string_new (tmp);
		g_free (tmp2);
		g_free (tmp);
		
		// We already have the first item, so we start with the next one if any
		for (file_iter = files->next; file_iter; file_iter = file_iter->next)
		{
			gchar* tmp_filename = nautilus_file_info_get_name ((NautilusFileInfo*)file_iter->data);
			gchar* tmp_uri = nautilus_file_info_get_uri ((NautilusFileInfo*)file_iter->data);
			GnomeVFSURI* tmp_gvfs_uri = gnome_vfs_uri_new (tmp_uri);
			tmp = gnome_vfs_uri_extract_dirname (tmp_gvfs_uri);
			gchar* tmp_dirname = (gchar*)gnome_vfs_unescape_string ((const gchar*)tmp, "");
			g_free (tmp);
			
			if (!tmp_filename)
			{
				tmp_filename = g_strdup ("");
			}

			tmp = g_build_path ("/", tmp_dirname, tmp_filename, NULL);
			tmp2 = g_shell_quote (tmp);
			g_string_append_printf (tmp_path_file_list, " %s", tmp2);
			
			g_free (tmp2);
			g_free (tmp);
			g_free (tmp_filename);
			g_free (tmp_dirname);
			g_free (tmp_uri);
			gnome_vfs_uri_unref (tmp_gvfs_uri);
		}
		path_file_list = g_string_free (tmp_path_file_list, FALSE);

		
		tmp_string = g_string_append (tmp_string, path_file_list);
		g_free (uri);
		g_free (dirname);
		g_free (path_file_list);
		g_free (scheme);
		gnome_vfs_uri_unref (gvfs_uri);

		retv = g_string_free (tmp_string, FALSE); // return the content of the GString
	}

	return retv;
}

static void nautilus_bitdefender_execute (NautilusMenuItem *item)
{
	GList *files;
	GString *cmd;
	gchar* param = NULL;

	files = (GList*)g_object_get_data (G_OBJECT (item), "files");

	cmd = g_string_new (BITDEFENDER_CMD);

	param = nautilus_bitdefender_parse_parameter (files);
	
	if (param != NULL)
	{
		g_string_append_printf (cmd, " %s", param);
		g_free (param);
	}

	g_spawn_command_line_async (cmd->str, NULL);
	
	g_string_free (cmd, TRUE);

}

static NautilusMenuItem *nautilus_bitdefender_create_menu_item (GList *files)
{
	NautilusMenuItem *item;

	item = nautilus_menu_item_new ("NautilusBitDefender::BitDefender",
				BITDEFENDER_MENU_ITEM, 
				BITDEFENDER_TOOLTIP,
				BITDEFENDER_ICON);

	g_signal_connect_data (item, 
				"activate", 
				G_CALLBACK (nautilus_bitdefender_execute),
				NULL, 
				NULL, 
				0);

	g_object_set_data_full (G_OBJECT (item),
			"files",
			nautilus_file_info_list_copy (files),
			(GDestroyNotify) nautilus_file_info_list_free);
	
	
	return item;
}

static GList *nautilus_bitdefender_get_file_items (NautilusMenuProvider *provider, GtkWidget *window, GList *files)
{
	GList *items = NULL;
	GSList *iter;
	NautilusMenuItem *item;
	NautilusBitDefender* self = NAUTILUS_BITDEFENDER (provider);

	g_return_val_if_fail (NAUTILUS_IS_BITDEFENDER (self), NULL);

	if (!self->dispose_has_run)
	{
		item = nautilus_bitdefender_create_menu_item (files);
		items = g_list_append (items, item);
	}
	
	return items;
}

static GList *nautilus_bitdefender_get_background_items (NautilusMenuProvider *provider, GtkWidget *window, NautilusFileInfo *current_folder)
{
	GList *items = NULL;
	GList *files = NULL;

	files = g_list_append (files, current_folder);
	items = nautilus_bitdefender_get_file_items (provider, window, files);
	g_list_free (files);
	
	return items;
}

static void nautilus_bitdefender_instance_dispose (GObject *obj)
{
	NautilusBitDefender* self = NAUTILUS_BITDEFENDER (obj);
	
	if (!self->dispose_has_run)
	{
		self->dispose_has_run = TRUE;

		/* Chain up to the parent class */
		G_OBJECT_CLASS (parent_class)->dispose (obj);
	}
}

static void nautilus_bitdefender_instance_finalize (GObject* obj)
{
	NautilusBitDefender* self = NAUTILUS_BITDEFENDER (obj);

	/* Chain up to the parent class */
	G_OBJECT_CLASS (parent_class)->finalize (obj);
}

static void nautilus_bitdefender_class_init (NautilusBitDefenderClass *bitdefender_class)
{
	GObjectClass *gobject_class = G_OBJECT_CLASS (bitdefender_class);

	gobject_class->dispose = nautilus_bitdefender_instance_dispose;
	gobject_class->finalize = nautilus_bitdefender_instance_finalize;
}

static void nautilus_bitdefender_instance_init (GTypeInstance *instance, gpointer klass)
{
	NautilusBitDefender* self = NAUTILUS_BITDEFENDER (instance);
}

static void nautilus_bitdefender_menu_provider_iface_init (NautilusMenuProviderIface *iface)
{
	iface->get_file_items = nautilus_bitdefender_get_file_items;
	iface->get_background_items = nautilus_bitdefender_get_background_items;
}

void nautilus_bitdefender_register_type (GTypeModule *module)
{
	static const GTypeInfo info = {
		sizeof (NautilusBitDefenderClass),
		(GBaseInitFunc) NULL,
		(GBaseFinalizeFunc) NULL,
		(GClassInitFunc) nautilus_bitdefender_class_init,
		NULL,
		NULL,
		sizeof (NautilusBitDefender),
		0,
		(GInstanceInitFunc)nautilus_bitdefender_instance_init,
	};

	static const GInterfaceInfo menu_provider_iface_info = {
		(GInterfaceInitFunc) nautilus_bitdefender_menu_provider_iface_init,
		NULL,
		NULL
	};

	bitdefender_type = g_type_module_register_type (module,
								G_TYPE_OBJECT,
								"NautilusBitDefender",
								&info, 0);

	g_type_module_add_interface (module,
								bitdefender_type,
								NAUTILUS_TYPE_MENU_PROVIDER,
								&menu_provider_iface_info);
}

