const constants = {};

constants.ELECTRON_MAIN_EVENT = 'runnerScenarioManager';

/**
 * The name of the event bus that the load testing process will use to receive
 * commands from the main process OR load generator system.
 */
constants.WORKLOAD_MANAGER_EVENT_BUS = 'workload_manager_event_bus';
constants.SEQUENCE_EVENT_BUS = 'sequence_event_bus';

/**
 * The name of events received from individual runtime instances/scenarios.
 * @type {{STARTED: string, FINISHED: string}}
 */
constants.SCENARIO_EXECUTION_EVENTS = {
  FINISHED: 'done',
  STARTED: 'start',
};

/**
 * The name of the events that will be sent from the execution control process to the main process via event stream.
 */
constants.EXECUTION_STATES = {
  STARTING: 'scenario-starting',
  STARTED: 'scenario-started',
  START_ERROR: 'scenario-start-error',
  STOPPING: 'scenario-stopping',
  STOPPED: 'scenario-stopped',
  PAUSING: 'scenario-pausing',
  PAUSED: 'scenario-paused',
  FINISHING: 'scenario-finishing',
  FINISHED: 'scenario-finished',
  ERROR: 'scenario-execution-error' // @TODO: Figure out how error/finished/finishing emit w.r.t. each other.
};


constants.WORKLOAD_STATES = {
  IDLE: 'idle',
  WARMING_UP: 'warming-up',
  READY: 'ready',
  STARTING: 'starting',
  RUNNING: 'running',
  STOPPING: 'stopping',
  STOPPED: 'stopped',
  PAUSING: 'pausing',
  PAUSED: 'paused',
  FINISHING: 'finishing',
  FINISHED: 'finished',
  ERROR: 'error',
  TERMINATED: 'terminated',
};

constants.WORKLOAD_ACTIONS = {
  INIT: 'init',
  START: 'start',
  STOP: 'stop',
};

constants.WORKLOAD_ALLOWED_ACTIONS = {
  [constants.WORKLOAD_STATES.IDLE]: [constants.WORKLOAD_ACTIONS.INIT],
  [constants.WORKLOAD_STATES.WARMING_UP]: [],
  [constants.WORKLOAD_STATES.READY]: [constants.WORKLOAD_ACTIONS.START],
  [constants.WORKLOAD_STATES.STARTING]: [],
  [constants.WORKLOAD_STATES.STARTED]: [constants.WORKLOAD_ACTIONS.STOP],
  [constants.WORKLOAD_STATES.STOPPING]: [],
  [constants.WORKLOAD_STATES.STOPPED]: [],
  [constants.WORKLOAD_STATES.PAUSING]: [],
  [constants.WORKLOAD_STATES.PAUSED]: [constants.WORKLOAD_ACTIONS.STOP],
  [constants.WORKLOAD_STATES.FINISHING]: [],
  [constants.WORKLOAD_STATES.FINISHED]: [],
};

constants.SUB_SYSTEM_REQUESTS = {
  ACTION: {
    PREVENT_SLEEP: 'preventPowerSaver',
    ALLOW_SLEEP: 'releasePowerSaver',
  }
};

module.exports = constants;
