"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const client_1 = require("../src/client");
const grpc_js_1 = require("@grpc/grpc-js");
// eslint-disable-next-line node/no-unpublished-import
const chai_1 = require("chai");
const sinon = __importStar(require("sinon"));
const reflection_pb_1 = require("../src/reflection_pb");
// eslint-disable-next-line no-undef
describe('listServices', () => {
    // eslint-disable-next-line no-undef
    it('should return services', async () => {
        const reflectionClient = new client_1.Client('localhost:4770', grpc_js_1.credentials.createInsecure());
        const grpcCall = {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            on: function (_event, listener) {
                const res = new reflection_pb_1.ServerReflectionResponse();
                const service1 = new reflection_pb_1.ServiceResponse();
                service1.setName('grpc.reflection.v1alpha.ServerReflection');
                const service2 = new reflection_pb_1.ServiceResponse();
                service2.setName('phone.Messenger');
                const serviceList = [service1, service2];
                const listService = new reflection_pb_1.ListServiceResponse();
                listService.setServiceList(serviceList);
                res.setListServicesResponse(listService);
                listener(res);
            },
            write: function () { },
            end: function () { },
        };
        const mock = sinon.mock(reflectionClient.grpcClient);
        mock.expects('serverReflectionInfo').once().returns(grpcCall);
        const expectedServices = [
            'grpc.reflection.v1alpha.ServerReflection',
            'phone.Messenger',
        ];
        chai_1.assert.sameMembers(await reflectionClient.listServices(), expectedServices);
    });
});
// eslint-disable-next-line no-undef
describe('fileContainingSymbol', () => {
    // eslint-disable-next-line no-undef
    it('should return Root', async () => {
        const reflectionClient = new client_1.Client('localhost:4770', grpc_js_1.credentials.createInsecure());
        const grpcCallPhone = {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            on: function (_event, listener) {
                if (_event === 'error') {
                    return;
                }
                const res = new reflection_pb_1.ServerReflectionResponse();
                const fileDescriptorResponse = new reflection_pb_1.FileDescriptorResponse();
                // eslint-disable-next-line prettier/prettier
                const protoBytes = Buffer.from([10, 11, 112, 104, 111, 110, 101, 46, 112, 114, 111, 116, 111, 18, 5, 112, 104, 111, 110, 101, 26, 13, 99, 111, 110, 116, 97, 99, 116, 46, 112, 114, 111, 116, 111, 34, 97, 10, 11, 84, 101, 120, 116, 82, 101, 113, 117, 101, 115, 116, 18, 14, 10, 2, 105, 100, 24, 1, 32, 1, 40, 9, 82, 2, 105, 100, 18, 24, 10, 7, 109, 101, 115, 115, 97, 103, 101, 24, 2, 32, 1, 40, 9, 82, 7, 109, 101, 115, 115, 97, 103, 101, 18, 40, 10, 7, 99, 111, 110, 116, 97, 99, 116, 24, 3, 32, 1, 40, 11, 50, 14, 46, 112, 104, 111, 110, 101, 46, 67, 111, 110, 116, 97, 99, 116, 82, 7, 99, 111, 110, 116, 97, 99, 116, 34, 40, 10, 12, 84, 101, 120, 116, 82, 101, 115, 112, 111, 110, 115, 101, 18, 24, 10, 7, 115, 117, 99, 99, 101, 115, 115, 24, 1, 32, 1, 40, 8, 82, 7, 115, 117, 99, 99, 101, 115, 115, 50, 63, 10, 9, 77, 101, 115, 115, 101, 110, 103, 101, 114, 18, 50, 10, 7, 77, 101, 115, 115, 97, 103, 101, 18, 18, 46, 112, 104, 111, 110, 101, 46, 84, 101, 120, 116, 82, 101, 113, 117, 101, 115, 116, 26, 19, 46, 112, 104, 111, 110, 101, 46, 84, 101, 120, 116, 82, 101, 115, 112, 111, 110, 115, 101, 98, 6, 112, 114, 111, 116, 111, 51]);
                fileDescriptorResponse.addFileDescriptorProto(protoBytes);
                res.setFileDescriptorResponse(fileDescriptorResponse);
                listener(res);
            },
            write: function () { },
            end: function () { },
        };
        const grpcCallContact = {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            on: function (_event, listener) {
                if (_event === 'error') {
                    return;
                }
                const res = new reflection_pb_1.ServerReflectionResponse();
                const fileDescriptorResponse = new reflection_pb_1.FileDescriptorResponse();
                // eslint-disable-next-line prettier/prettier
                const protoBytes = Buffer.from([10, 13, 99, 111, 110, 116, 97, 99, 116, 46, 112, 114, 111, 116, 111, 18, 5, 112, 104, 111, 110, 101, 34, 53, 10, 7, 67, 111, 110, 116, 97, 99, 116, 18, 18, 10, 4, 110, 97, 109, 101, 24, 1, 32, 1, 40, 9, 82, 4, 110, 97, 109, 101, 18, 22, 10, 6, 110, 117, 109, 98, 101, 114, 24, 2, 32, 1, 40, 9, 82, 6, 110, 117, 109, 98, 101, 114, 98, 6, 112, 114, 111, 116, 111, 51]);
                fileDescriptorResponse.addFileDescriptorProto(protoBytes);
                res.setFileDescriptorResponse(fileDescriptorResponse);
                listener(res);
            },
            write: function () { },
            end: function () { },
        };
        const mock = sinon.mock(reflectionClient.grpcClient);
        mock.expects('serverReflectionInfo').once().returns(grpcCallPhone);
        mock.expects('serverReflectionInfo').once().returns(grpcCallContact);
        const root = await reflectionClient.fileContainingSymbol('phone.Messenger');
        chai_1.assert.sameDeepMembers(root.files, ['contact.proto', 'phone.proto']);
    });
});
// eslint-disable-next-line no-undef
describe('fileByFilename', () => {
    // eslint-disable-next-line no-undef
    it('should return Root', async () => {
        const reflectionClient = new client_1.Client('localhost:4770', grpc_js_1.credentials.createInsecure());
        const grpcCallContact = {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            on: function (_event, listener) {
                if (_event === 'error') {
                    return;
                }
                const res = new reflection_pb_1.ServerReflectionResponse();
                const fileDescriptorResponse = new reflection_pb_1.FileDescriptorResponse();
                // eslint-disable-next-line prettier/prettier
                const protoBytes = Buffer.from([10, 13, 99, 111, 110, 116, 97, 99, 116, 46, 112, 114, 111, 116, 111, 18, 5, 112, 104, 111, 110, 101, 34, 53, 10, 7, 67, 111, 110, 116, 97, 99, 116, 18, 18, 10, 4, 110, 97, 109, 101, 24, 1, 32, 1, 40, 9, 82, 4, 110, 97, 109, 101, 18, 22, 10, 6, 110, 117, 109, 98, 101, 114, 24, 2, 32, 1, 40, 9, 82, 6, 110, 117, 109, 98, 101, 114, 98, 6, 112, 114, 111, 116, 111, 51]);
                fileDescriptorResponse.addFileDescriptorProto(protoBytes);
                res.setFileDescriptorResponse(fileDescriptorResponse);
                listener(res);
            },
            write: function () { },
            end: function () { },
        };
        const mock = sinon.mock(reflectionClient.grpcClient);
        mock.expects('serverReflectionInfo').once().returns(grpcCallContact);
        const root = await reflectionClient.fileByFilename('contact.proto');
        chai_1.assert.deepEqual(root.files, ['contact.proto']);
    });
});
//# sourceMappingURL=client.test.js.map