const { expect } = require('chai'),
    { file } = require('../format');

describe('File Format', () => {
    it('should not fail for undefined', () => {
        expect(file()).to.equal('[undefined][undefined][undefined][undefined][undefined]');
    });

    it('should not fail for missing of all property', () => {
        expect(file({})).to.equal('[undefined][undefined][undefined][undefined][undefined]');
    });

    it('should not fail for missing of single property(level)', () => {
        let expectedMessage = '[123][12345][origin][undefined]["foo"]';
        // eslint-disable-next-line max-len
        expect(file({ origin: 'origin', sessionId: 123, timestamp: 12345, messages: 'foo' })).to.equal(expectedMessage);
    });

    it('should stringify message object', () => {
        let expectedMessage = '[123][12345][origin][error][{"foo":"bar"}]';
        // eslint-disable-next-line max-len
        expect(file({ level: 'error', sessionId: 123, origin: 'origin', timestamp: 12345, messages: { foo: 'bar' } })).to.equal(expectedMessage);
    });

    it('should stringify message array', () => {
        let expectedMessage = '[123][12345][origin][error]["foo","bar"]';
        // eslint-disable-next-line max-len
        expect(file({ level: 'error', sessionId: 123, origin: 'origin', timestamp: 12345, messages: ['foo', 'bar'] })).to.equal(expectedMessage);
    });

    it('should stringify circular JSON', () => {
        let expectedMessage = '[123][12345][origin][error][{"a":["~","~a"]},[{"a":"~"},"~"]]',
            message = [{}];

        message[0].a = message;
        message.push(message);

        // eslint-disable-next-line max-len
        expect(file({ level: 'error', sessionId: 123, origin: 'origin', timestamp: 12345, messages: message })).to.equal(expectedMessage);
    });
});
