/*! For license information please see index.js.LICENSE.txt */
(()=>{var e={963:(e,t,n)=>{"use strict";n.d(t,{Z:()=>l});var r=n(81),a=n.n(r),o=n(645),i=n.n(o)()(a());i.push([e.id,'/* Intro */\n\n@keyframes appear {\n  from {\n    opacity: 0;\n  }\n  to {\n    opacity: 1;\n  }\n}\n\n@keyframes disappear {\n  from {\n    opacity: 1;\n  }\n  to {\n    opacity: 0;\n  }\n}\n\n@keyframes zoom-out {\n  from {\n    transform: scale(1.5);\n  }\n  to {\n    transform: scale(1);\n  }\n}\n\nmain.welcome .masthead {\n  animation: appear 0.5s ease-out forwards;\n}\n\n.contents {\n  clip-path: var(--from-clip-path);\n}\n\n@keyframes enter-portal {\n  from {\n    clip-path: var(--from-clip-path);\n  }\n  99% {\n    clip-path: var(--to-clip-path);\n  }\n  to {\n    clip-path: none;\n  }\n}\n\nmain.setup .masthead,\nmain.setup .get-started {\n  opacity: 1;\n  animation: disappear 0.5s cubic-bezier(0.33, 1, 0.68, 1) forwards;\n}\n\nmain.setup .contents {\n  clip-path: var(--from-clip-path);\n  animation: enter-portal 1.4s cubic-bezier(0.3, 0, 0.35, 1) forwards;\n}\n\nmain.setup .container {\n  pointer-events: none;\n}\n\nmain.setup .contents .wallpaper {\n  animation: disappear 2.2s cubic-bezier(0.33, 1, 0.68, 1) forwards,\n    zoom-out 2s cubic-bezier(0.2, 0, 0.17, 1) forwards;\n}\n\n/* Transitions between pages */\n\n.page {\n  --animation-delay: 0s;\n  --slide-out-timing: cubic-bezier(0.64, 0, 0.78, 0);\n  --slide-in-timing: cubic-bezier(0.22, 1, 0.36, 1);\n}\n\n.active .page .buttons {\n  visibility: visible;\n}\n\n@keyframes slide-in-right {\n  from {\n    left: 100vw;\n  }\n  to {\n    left: 0;\n  }\n}\n\n.forward .active .page {\n  animation: appear 0.1s linear forwards;\n}\n\n.forward .active .page .title {\n  animation: slide-in-right 0.4s var(--animation-delay) var(--slide-in-timing) forwards;\n  left: 100vw;\n}\n\n.forward .active .page .subtitle {\n  animation: slide-in-right 0.5s var(--animation-delay) var(--slide-in-timing) forwards;\n  left: 100vw;\n}\n\n.forward .active .page .preview {\n  animation: slide-in-right 0.6s var(--animation-delay) var(--slide-in-timing) forwards;\n  left: 100vw;\n}\n\n.forward .active .page .controls {\n  animation: slide-in-right 0.7s var(--animation-delay) var(--slide-in-timing) forwards;\n  left: 100vw;\n}\n\n@keyframes slide-in-left {\n  from {\n    left: -100vw;\n  }\n  to {\n    left: 0;\n  }\n}\n\n.backward .active .page .title {\n  animation: slide-in-left 0.7s var(--animation-delay) var(--slide-in-timing) forwards;\n  left: -100vw;\n}\n\n.backward .active .page .subtitle {\n  animation: slide-in-left 0.6s var(--animation-delay) var(--slide-in-timing) forwards;\n  left: -100vw;\n}\n\n.backward .active .page .preview {\n  animation: slide-in-left 0.5s var(--animation-delay) var(--slide-in-timing) forwards;\n  left: -100vw;\n}\n\n.backward .active .page .controls {\n  animation: slide-in-left 0.4s var(--animation-delay) var(--slide-in-timing) forwards;\n  left: -100vw;\n}\n\n.active .page .buttons {\n  animation: appear 0.6s linear 0.5s forwards;\n  opacity: 0;\n}\n\n.dismissed .page {\n  opacity: 1;\n  pointer-events: none;\n}\n\n.dismissed .page .content {\n  animation: disappear 0.7s linear forwards;\n  opacity: 1;\n}\n\n@keyframes slide-out {\n  from {\n    left: 0;\n  }\n  to {\n    left: -100vw;\n  }\n}\n\n.forward .dismissed ~ .active .page,\n.backward .active .page {\n  --animation-delay: 0.7s;\n}\n\n.forward .dismissed .page .title {\n  animation: slide-out 0.4s var(--slide-out-timing) forwards;\n  left: 0;\n}\n\n.forward .dismissed .page .subtitle {\n  animation: slide-out 0.5s var(--slide-out-timing) forwards;\n  left: 0;\n}\n\n.forward .dismissed .page .preview {\n  animation: slide-out 0.6s var(--slide-out-timing) forwards;\n  left: 0;\n}\n\n.forward .dismissed .page .controls {\n  animation: slide-out 0.7s var(--slide-out-timing) forwards;\n  left: 0;\n}\n\n@keyframes slide-out-right {\n  from {\n    left: 0;\n  }\n  to {\n    left: 100vw;\n  }\n}\n\n.backward .dismissed .page .title {\n  animation: slide-out-right 0.7s var(--slide-out-timing) forwards;\n  left: 0;\n}\n\n.backward .dismissed .page .subtitle {\n  animation: slide-out-right 0.6s var(--slide-out-timing) forwards;\n  left: 0;\n}\n\n.backward .dismissed .page .preview {\n  animation: slide-out-right 0.5s var(--slide-out-timing) forwards;\n  left: 0;\n}\n\n.backward .dismissed .page .controls {\n  animation: slide-out-right 0.4s var(--slide-out-timing) forwards;\n  left: 0;\n}\n\n.dismissed .page .buttons {\n  animation: disappear 0.3s linear forwards;\n  opacity: 1;\n  pointer-events: none;\n}\n\n/* Outro */\n\nmain.ready .contents {\n  clip-path: none;\n}\n\nmain.ready .wallpaper {\n  display: none;\n}\n\nmain.ready .background {\n  animation: disappear 0.6s linear 0.7s forwards;\n}\n\n.active #summary.page {\n  --animation-delay: 1.1s;\n}\n\n.active #summary.page h3 {\n  animation: slide-in-right 0.6s var(--animation-delay) var(--slide-in-timing) forwards;\n  left: 100vw;\n}\n\n@keyframes slide-in-bottom {\n  from {\n    top: 60vh;\n  }\n  to {\n    top: 0;\n  }\n}\n\n@keyframes whizz {\n  from {\n    top: 0;\n    opacity: 1;\n  }\n  to {\n    top: -100px;\n    opacity: 0;\n  }\n}\n\n.active #summary.page .preview {\n  animation: slide-in-bottom 1s var(--animation-delay) var(--slide-in-timing) forwards;\n  left: 0;\n  top: 60vh;\n}\n\n.active #summary.page .start-browsing {\n  animation: appear 0.5s linear 2.9s forwards;\n  opacity: 0;\n}\n\n@keyframes scale {\n  from {\n    transform: scale(0);\n  }\n  to {\n    transform: scale(1);\n  }\n}\n\n.active #summary.page .browser-preview .aria-icon {\n  animation: scale 0.4s 1.9s cubic-bezier(0.6, 0, 0.4, 1.6) forwards;\n}\n\n.active #summary .fireworks {\n  opacity: 0;\n  animation: appear 0.1s linear 2s forwards;\n}\n\n/* Other */\n\n.with-ad-blocker .active #adblocker.page .popup {\n  animation: appear 0.6s 0.2s var(--slide-in-timing) forwards;\n}\n\nhtml[data-last-import="Chrome"] .active #import.page .chrome-data-imported.popup {\n  animation: appear 0.6s 0.2s var(--slide-in-timing) forwards;\n}\n\nhtml[data-last-import="Microsoft Edge"] .active #import.page .edge-data-imported.popup {\n  animation: appear 0.6s 0.2s var(--slide-in-timing) forwards;\n}\n\nhtml[data-last-import="Safari"] .active #import.page .safari-data-imported.popup {\n  animation: appear 0.6s 0.2s var(--slide-in-timing) forwards;\n}\n\nhtml[data-last-import="Mozilla Firefox"] .active #import.page .firefox-data-imported.popup {\n  animation: appear 0.6s 0.2s var(--slide-in-timing) forwards;\n}\n\n@keyframes spin {\n  0% {\n    transform: rotate(0deg);\n  }\n  100% {\n    transform: rotate(360deg);\n  }\n}\n\n.spinner {\n  opacity: 0;\n  animation: spin 0.8s linear infinite, appear 0.4s 0.2s ease-in forwards;\n}\n\n@keyframes press {\n  0% {\n    transform: scale(1);\n  }\n  20% {\n    transform: scale(0.9);\n  }\n  100% {\n    transform: scale(1);\n  }\n}\n\nbutton:active {\n  animation: press 0.5s cubic-bezier(0.65, 0, 0.35, 1) forwards;\n}\n',""]);const l=i},580:(e,t,n)=>{"use strict";n.d(t,{Z:()=>w});var r=n(81),a=n.n(r),o=n(645),i=n.n(o),l=n(667),s=n.n(l),u=new URL(n(856),n.b),c=new URL(n(272),n.b),d=new URL(n(311),n.b),f=new URL(n(699),n.b),p=new URL(n(426),n.b),h=new URL(n(630),n.b),m=i()(a()),g=s()(u),v=s()(c),b=s()(d),y=s()(f),C=s()(p),k=s()(h);m.push([e.id,'body {\n  --spacing: 32px;\n  --max-content-width: 1000px;\n  --max-content-height: 800px;\n  --min-content-height: 440px;\n  --min-content-width: 600px;\n  --min-page-width: calc(var(--min-content-width) + 2 * var(--spacing));\n  --min-page-height: calc(var(--min-content-height) + 2 * var(--spacing));\n  --accent-color: #5021ff;\n  --light-font-color: #ffffff;\n  --dark-font-color: #000000;\n  --secondary-dark-font-color: #000000a4;\n  --highlight-color: #ffffff22;\n  --shadow-color: #00000033;\n  background-position: center;\n  background-repeat: no-repeat;\n  background-size: cover;\n  box-sizing: border-box;\n  height: 100%;\n  margin: 0;\n  padding: 0;\n  width: 100%;\n}\n\n.opera-intro {\n  --tabs-background-color: #d0dbe3;\n  --tab-background-color: #e8ecf0;\n  --plus-background-color: #ffffff;\n  --plus-icon-color: rgb(29, 16, 16);\n  --favicon-background-color: #bfc2c5;\n  --sidebar-icon-color: #d3dbe3;\n  --popup-background-color: #ffffff;\n  --icon-color: #000000;\n  --panel-background-color: #ffffff;\n  --start-page-background-color: #eeeeee;\n  --tile-background-color: #f7f7f7;\n  --banner-background-color: #4d3ab8;\n}\n\n@media (prefers-color-scheme: dark) {\n  .opera-intro {\n    --tabs-background-color: #040716;\n    --tab-background-color: #1c1e2a;\n    --plus-background-color: #252836;\n    --plus-icon-color: #ffffff;\n    --favicon-background-color: #c4caec;\n    --sidebar-icon-color: #494d65;\n    --popup-background-color: #404459;\n    --icon-color: #ffffff;\n    --panel-background-color: #252836;\n    --start-page-background-color: #3d4053;\n    --tile-background-color: #b1b1b2;\n    --banner-background-color: #907ff0;\n  }\n}\n\n* {\n  overscroll-behavior: contain;\n}\n\n@font-face {\n  font-display: swap;\n  font-family: "Space Mono";\n  font-style: normal;\n  font-weight: 400;\n  src: url('+g+') format("truetype");\n}\n\n@font-face {\n  font-display: swap;\n  font-family: "Space Mono";\n  font-style: normal;\n  font-weight: 700;\n  src: url('+v+') format("truetype");\n}\n\n@font-face {\n  font-display: swap;\n  font-family: Averta;\n  font-style: normal;\n  font-weight: 500;\n  src: url('+b+') format("opentype");\n}\n\nh1,\nh2,\nh3 {\n  font-family: "Space Mono";\n  margin: 0;\n}\n\nh1 {\n  font-size: 52px;\n  font-weight: 700;\n  max-width: 340px;\n  text-transform: uppercase;\n}\n\nh2 {\n  font-size: 24px;\n  font-weight: 400;\n  line-height: 32px;\n  max-width: 340px;\n  text-transform: uppercase;\n}\n\nh3 {\n  font-size: 15px;\n  font-weight: 500;\n  line-height: 18px;\n  opacity: 0.5;\n  text-transform: none;\n}\n\nmain {\n  font-family: "Space Mono";\n}\n\nbody,\n#root,\n.overlay,\n.contents,\n.gallery,\n.opera-intro,\n.wallpaper,\n.background {\n  position: fixed;\n  top: 0;\n  left: 0;\n  bottom: 0;\n  right: 0;\n}\n\n.overlay {\n  background: black;\n  font-family: "Space Mono";\n}\n\n.overlay .container {\n  box-sizing: border-box;\n  min-height: var(--min-page-height);\n  padding: var(--spacing);\n}\n\n.hidden > * {\n  visibility: hidden;\n}\n\n.overlay .container {\n  height: 100%;\n  position: relative;\n  width: 100%;\n}\n\n.overlay .masthead {\n  color: var(--light-font-color);\n  display: flex;\n  flex-direction: column;\n  gap: 32px;\n  left: var(--spacing);\n  margin: var(--spacing);\n  position: absolute;\n  text-transform: uppercase;\n  top: var(--spacing);\n}\n\n.overlay .masthead h1 {\n  font-size: 72px;\n  font-weight: bold;\n  line-height: 80px;\n}\n\n.header {\n  color: var(--dark-font-color);\n  display: flex;\n  flex-direction: column;\n  gap: 32px;\n  text-transform: uppercase;\n}\n\nmain.ready h1 {\n  font-size: 48px;\n  line-height: 52px;\n  max-width: 500px;\n}\n\nmain.ready h2 {\n  font-size: 16px;\n}\n\n.wallpaper {\n  background: url('+y+");\n  background-position: center;\n  background-size: cover;\n  transform: scale(1.5);\n}\n\n.background {\n  background: url("+C+');\n  background-position: center;\n  background-size: cover;\n}\n\nbutton.singular {\n  background: var(--light-font-color);\n  border-radius: 8px;\n  border: 0;\n  color: black;\n  cursor: pointer;\n  font-family: "Space Mono";\n  font-size: 15px;\n  font-weight: bold;\n  padding: 12px 16px;\n  text-transform: uppercase;\n}\n\nbutton.get-started {\n  bottom: var(--spacing);\n  margin: var(--spacing);\n  position: absolute;\n  right: var(--spacing);\n}\n\nbutton.start-browsing {\n  font-size: 12px;\n  position: absolute;\n  right: 0;\n  top: var(--spacing);\n}\n\n.active button.start-browsing {\n  pointer-events: all;\n}\n\n.page {\n  box-sizing: border-box;\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n  justify-content: center;\n  margin: auto;\n  max-height: var(--max-content-height);\n  opacity: 0;\n  padding: var(--spacing);\n  pointer-events: none;\n  position: relative;\n  width: fit-content;\n}\n\n.active .page {\n  opacity: 1;\n  pointer-events: all;\n}\n\n.content {\n  display: flex;\n  flex-direction: column;\n  justify-content: space-evenly;\n  height: fit-content;\n  min-height: var(--min-content-height);\n  max-height: var(--max-content-height);\n  position: relative;\n  width: clamp(var(--min-content-width), 60vw, var(--max-content-width));\n}\n\n@media (min-height: 600px) {\n  .content {\n    height: 80vh;\n  }\n}\n\n.opera-intro {\n  display: flex;\n  flex-direction: column;\n}\n\n.feature {\n  display: flex;\n  flex-direction: row;\n  justify-content: center;\n  gap: 40px;\n  margin: var(--spacing) auto;\n  min-width: var(--min-content-width);\n  position: relative;\n  width: 100%;\n}\n\n.preview {\n  width: 360px;\n  height: 234px;\n  box-shadow: 0px 12px 24px 0px var(--shadow-color);\n}\n\n.preview .sidebar-pages {\n  transform: translateY(15px);\n}\n\n.title,\n.subtitle,\n.preview,\n.controls,\n.buttons {\n  position: relative;\n}\n\n.title {\n  display: block;\n  font-size: 52px;\n  font-weight: 700;\n  line-height: 52px;\n  text-transform: uppercase;\n  width: 500px;\n}\n\n.wide.title {\n  width: clamp(600px, 70%, var(--max-content-width));\n}\n\n.widest.title {\n  font-size: 44px;\n  line-height: 48px;\n  width: clamp(600px, 80%, var(--max-content-width));\n}\n\n.subtitle {\n  font-size: 24px;\n  font-weight: 400;\n  line-height: 24px;\n  text-transform: uppercase;\n}\n\n.with-wallpaper #wallpaper .preview {\n  --tile-background-color: #f7f7f7;\n}\n\n.controls {\n  --inactive-background-color: #00000080;\n  --active-background-color: #5021ff;\n  --switch-background-color: #fff;\n  align-items: center;\n  backdrop-filter: blur(40px);\n  background-color: #0000001a;\n  border-radius: 8px;\n  display: flex;\n  font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;\n  font-weight: normal;\n  flex-direction: column;\n  gap: 18px;\n  height: 234px;\n  justify-content: center;\n  width: 200px;\n}\n\n.buttons {\n  display: flex;\n  justify-content: space-between;\n  min-width: var(--min-content-width);\n  user-select: none;\n  z-index: 1;\n}\n\nbutton:disabled {\n  display: none;\n  pointer-events: none;\n}\n\n.buttons .left,\n.buttons .right {\n  display: flex;\n  flex-direction: row;\n  gap: 12px;\n}\n\n.transparent {\n  align-items: center;\n  background-color: transparent;\n  border: 0;\n  bottom: var(--spacing);\n  cursor: pointer;\n  display: flex;\n  font-family: "Space Mono";\n  font-size: 12px;\n  height: 20px;\n  height: 40px;\n  justify-content: center;\n  left: var(--spacing);\n  text-transform: uppercase;\n}\n\nbutton.primary,\nbutton.secondary {\n  border-radius: 8px;\n  cursor: pointer;\n  font-family: "Space Mono";\n  font-size: 12px;\n  height: auto;\n  min-height: 40px;\n  min-width: 64px;\n  padding: 8px 16px;\n  text-transform: uppercase;\n  width: auto;\n}\n\nbutton.primary {\n  background-color: var(--accent-color);\n  border: 0;\n  color: var(--light-font-color);\n}\n\nbutton.secondary {\n  background-color: transparent;\n  border: 1px solid var(--dark-font-color);\n  color: var(--dark-font-color);\n}\n\nbutton.transparent {\n  background-color: transparent;\n  border: 0;\n  color: var(--dark-font-color);\n}\n\n.opera-logo {\n  background-position: center;\n  background-repeat: no-repeat;\n  background-size: cover;\n  background: url('+k+');\n  height: 26px;\n  position: fixed;\n  right: 40px;\n  top: 32px;\n  width: 26px;\n}\n\n.popup {\n  align-items: center;\n  display: flex;\n  filter: drop-shadow(0px 4px 4px var(--shadow-color));\n  flex-direction: column;\n  user-select: none;\n  width: 1px;\n  z-index: 1;\n}\n\n.popup-top {\n  height: 17px;\n  width: 32px;\n}\n\n.popup-content {\n  align-items: center;\n  background: var(--light-font-color);\n  border-radius: 8px;\n  color: rgb(72, 34, 238);\n  display: flex;\n  flex-direction: column;\n  font-family: Averta;\n  font-size: 10px;\n  gap: 4px;\n  padding: 10px 16px;\n  position: relative;\n  top: -12px;\n  white-space: nowrap;\n}\n\n.spinner {\n  align-items: center;\n  display: flex;\n  justify-content: center;\n}\n\n.spinner svg {\n  width: 24px;\n  height: 24px;\n}\n\n/* Theme */\n\n.theme {\n  --font-color: var(--secondary-dark-font-color);\n  align-items: center;\n  border-radius: 20px;\n  box-sizing: border-box;\n  color: var(--font-color);\n  cursor: pointer;\n  display: flex;\n  font-family: Averta;\n  font-size: 16px;\n  font-weight: 600;\n  height: auto;\n  justify-content: center;\n  line-height: 24px;\n  min-height: 40px;\n  min-width: 80px;\n  padding: 8px 20px;\n  width: auto;\n}\n\n.selected.theme {\n  --font-color: var(--light-font-color);\n  background-color: var(--highlight-color);\n}\n\n/* Wallpapers */\n\n.thumbnails {\n  align-items: center;\n  display: grid;\n  gap: 14px;\n  grid-template-columns: 74px 74px;\n}\n\n.thumbnail {\n  box-sizing: border-box;\n  border: 2px solid transparent;\n  border-radius: 10px;\n  cursor: pointer;\n  height: 48px;\n  position: relative;\n  user-select: none;\n  width: 74px;\n}\n\n.thumbnail .image {\n  background-position: center;\n  background-size: 120%;\n  border-radius: 8px;\n  display: inline-block;\n  opacity: 0.6;\n}\n\n.thumbnail .image,\n.thumbnail .spinner {\n  bottom: 0;\n  left: 0;\n  position: absolute;\n  right: 0;\n  top: 0;\n}\n\n.selected.thumbnail {\n  border-color: var(--light-font-color);\n}\n\n.selected.thumbnail .image {\n  opacity: 1;\n}\n\n/* Ad blocker */\n\n#adblocker .label {\n  color: var(--icon-background-color);\n  font-family: Averta;\n  font-size: 15px;\n  font-weight: 500;\n  padding: 0 24px;\n  position: relative;\n  text-align: center;\n  top: -10px;\n  user-select: none;\n}\n\n#adblocker :is(.label, .logo) {\n  --icon-background-color: var(--inactive-background-color);\n}\n\n.with-ad-blocker #adblocker :is(.label, .logo) {\n  --icon-background-color: var(--switch-background-color);\n}\n\n#adblocker .adblocker-enabled.popup {\n  left: 343px;\n  opacity: 0;\n  position: absolute;\n  top: 36px;\n}\n\n.adblocker-badge {\n  display: none;\n}\n\n.with-ad-blocker .adblocker-badge {\n  display: block;\n}\n\ninput[type="checkbox"] {\n  appearance: none;\n  background-color: var(--inactive-background-color);\n  border-radius: 6px;\n  cursor: pointer;\n  height: 22px;\n  position: relative;\n  width: 40px;\n}\n\ninput[type="checkbox"]::after {\n  background-color: var(--switch-background-color);\n  border-radius: 3px;\n  content: "";\n  display: block;\n  height: 14px;\n  left: 4px;\n  position: absolute;\n  top: 4px;\n  transition: all 0.2s cubic-bezier(0.175, 0.885, 0.32, 1.275);\n  width: 7px;\n}\n\ninput[type="checkbox"]:checked {\n  background-color: var(--active-background-color);\n}\n\ninput[type="checkbox"]:checked::after {\n  left: 22px;\n  width: 14px;\n}\n\n/* Messengers */\n\n.messengers {\n  align-items: center;\n  display: grid;\n  gap: 6px 24px;\n  grid-template-columns: 64px 64px;\n}\n\n.messenger {\n  --icon-color: #0009;\n  cursor: pointer;\n  text-align: center;\n  user-select: none;\n}\n\n.messenger .inactive {\n  display: block;\n}\n\n.messenger .active {\n  display: none;\n}\n\n.messenger .hover {\n  display: none;\n}\n\n.messenger:hover .inactive.hover {\n  display: block;\n}\n\n.active.messenger {\n  --icon-color: var(--light-font-color);\n}\n\n.active.messenger .inactive {\n  display: none;\n}\n\n.active.messenger .active:not(.hover) {\n  display: block;\n}\n\n.active.messenger:hover .active.hover {\n  display: block;\n}\n\n/* Import */\n\n#import .popup {\n  opacity: 0;\n  position: absolute;\n  top: 36px;\n}\n\n#import .popup i {\n  background-position: center;\n  background-size: contain;\n  height: 32px;\n  width: 32px;\n}\n\n#import .chrome-data-imported.popup {\n  left: 293px;\n}\n\n#import .edge-data-imported.popup {\n  left: 309px;\n}\n\n#import .safari-data-imported.popup {\n  left: 325px;\n}\n\n#import .firefox-data-imported.popup {\n  left: 341px;\n}\n\n.browsers {\n  align-items: center;\n  display: grid;\n  gap: 16px;\n  grid-template-columns: 70px 70px;\n}\n\n.browser {\n  align-items: center;\n  border-radius: 10px;\n  display: flex;\n  flex-direction: column;\n  position: relative;\n  user-select: none;\n  width: 70px;\n}\n\n.browser .spinner {\n  bottom: 24px;\n  left: 0;\n  position: absolute;\n  right: 0;\n  top: 0;\n}\n\n.browser .tick {\n  position: absolute;\n  right: 11px;\n  top: -4px;\n  visibility: hidden;\n}\n\n.available.browser {\n  cursor: pointer;\n  filter: url(#cobalt-blue);\n  opacity: 0.75;\n}\n\n.disabled.browser {\n  filter: url(#cobalt-blue);\n  opacity: 0.2;\n  pointer-events: none;\n}\n\n.imported.browser {\n  filter: none;\n  opacity: 1;\n  pointer-events: none;\n}\n\n.imported.browser .tick,\n.browser:hover .tick {\n  visibility: visible;\n}\n\n.browser i {\n  background-position: center;\n  background-size: contain;\n  height: 48px;\n  width: 48px;\n}\n\n.browser .browser-name {\n  font-family: Averta;\n  font-size: 12px;\n  font-style: normal;\n  font-weight: 600;\n  line-height: 24px;\n  text-align: center;\n}\n\n.available.browser .browser-name {\n  opacity: 0.6;\n}\n\n.available.browser:hover {\n  opacity: 1;\n}\n\n.imported.browser .browser-name {\n  color: var(--light-font-color);\n}\n\n/* Summary */\n\n#summary {\n  height: fit-content;\n  pointer-events: none;\n  position: fixed;\n  top: calc(2 * var(--spacing));\n}\n\n.active #summary {\n  pointer-events: all;\n}\n\n#summary .content {\n  height: fit-content;\n  margin: var(--spacing) auto 0 auto;\n  max-height: unset;\n  width: 680px;\n}\n\n#summary .header {\n  color: var(--light-font-color);\n  filter: drop-shadow(0px 4px 4px var(--shadow-color));\n  margin-top: calc(2 * var(--spacing));\n  pointer-events: none;\n  z-index: 1;\n}\n\n#summary h3 {\n  color: var(--light-font-color);\n  position: relative;\n}\n\n#summary .title {\n  line-height: 56px;\n  width: 600px;\n}\n\n#summary .subtitle {\n  line-height: 32px;\n}\n\n#summary .feature {\n  flex-direction: column;\n  justify-content: flex-start;\n}\n\n#summary .preview {\n  box-shadow: none;\n  padding-top: calc(3 * var(--spacing));\n  pointer-events: none;\n}\n\n#summary .fireworks {\n  bottom: 0;\n  cursor: s-resize;\n  display: none;\n  left: 0;\n  pointer-events: none;\n  position: fixed;\n  right: 0;\n  top: 0;\n}\n\n.active #summary .fireworks {\n  display: block;\n  pointer-events: all;\n}\n\n#summary .fireworks .tab {\n  height: 28px;\n  position: absolute;\n  width: 7px;\n}\n\n#summary .fireworks .tab .handle {\n  border-radius: 3.5px;\n  display: inline-block;\n  height: 28px;\n  opacity: 0;\n  position: relative;\n  width: 7px;\n}\n\n#summary .browser-preview {\n  pointer-events: none;\n  position: relative;\n}\n\n@media (prefers-color-scheme: dark) {\n  #summary .browser-preview .preview {\n    --tile-background-color: var(--highlight-color);\n  }\n}\n\n#summary .browser-preview .aria-icon {\n  left: -42px;\n  pointer-events: none;\n  position: absolute;\n  top: 178px;\n  transform: scale(0);\n}\n\n.gallery {\n  display: grid;\n  grid-template-columns: repeat(6, 100vw);\n  height: fit-content;\n  max-height: 100vh;\n  overflow-x: hidden;\n  overflow-y: auto;\n  width: 100vw;\n  z-index: 666;\n}\n\n.gallery .screen {\n  align-items: center;\n  box-sizing: border-box;\n  display: flex;\n  height: fit-content;\n  min-height: 100vh;\n  justify-content: center;\n  min-width: var(--min-page-width);\n  pointer-events: none;\n  position: relative;\n}\n\n.gallery .screen:nth-child(2) {\n  left: -100vw;\n}\n\n.gallery .screen:nth-child(3) {\n  left: -200vw;\n}\n\n.gallery .screen:nth-child(4) {\n  left: -300vw;\n}\n\n.gallery .screen:nth-child(5) {\n  left: -400vw;\n}\n\n.gallery .screen:nth-child(6) {\n  left: -500vw;\n}\n',""]);const w=m},645:e=>{"use strict";e.exports=function(e){var t=[];return t.toString=function(){return this.map((function(t){var n="",r=void 0!==t[5];return t[4]&&(n+="@supports (".concat(t[4],") {")),t[2]&&(n+="@media ".concat(t[2]," {")),r&&(n+="@layer".concat(t[5].length>0?" ".concat(t[5]):""," {")),n+=e(t),r&&(n+="}"),t[2]&&(n+="}"),t[4]&&(n+="}"),n})).join("")},t.i=function(e,n,r,a,o){"string"==typeof e&&(e=[[null,e,void 0]]);var i={};if(r)for(var l=0;l<this.length;l++){var s=this[l][0];null!=s&&(i[s]=!0)}for(var u=0;u<e.length;u++){var c=[].concat(e[u]);r&&i[c[0]]||(void 0!==o&&(void 0===c[5]||(c[1]="@layer".concat(c[5].length>0?" ".concat(c[5]):""," {").concat(c[1],"}")),c[5]=o),n&&(c[2]?(c[1]="@media ".concat(c[2]," {").concat(c[1],"}"),c[2]=n):c[2]=n),a&&(c[4]?(c[1]="@supports (".concat(c[4],") {").concat(c[1],"}"),c[4]=a):c[4]="".concat(a)),t.push(c))}},t}},667:e=>{"use strict";e.exports=function(e,t){return t||(t={}),e?(e=String(e.__esModule?e.default:e),/^['"].*['"]$/.test(e)&&(e=e.slice(1,-1)),t.hash&&(e+=t.hash),/["'() \t\n]|(%20)/.test(e)||t.needQuotes?'"'.concat(e.replace(/"/g,'\\"').replace(/\n/g,"\\n"),'"'):e):e}},81:e=>{"use strict";e.exports=function(e){return e[1]}},448:(e,t,n)=>{"use strict";var r=n(294),a=n(840);function o(e){for(var t="https://reactjs.org/docs/error-decoder.html?invariant="+e,n=1;n<arguments.length;n++)t+="&args[]="+encodeURIComponent(arguments[n]);return"Minified React error #"+e+"; visit "+t+" for the full message or use the non-minified dev environment for full errors and additional helpful warnings."}var i=new Set,l={};function s(e,t){u(e,t),u(e+"Capture",t)}function u(e,t){for(l[e]=t,e=0;e<t.length;e++)i.add(t[e])}var c=!("undefined"==typeof window||void 0===window.document||void 0===window.document.createElement),d=Object.prototype.hasOwnProperty,f=/^[:A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD][:A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\-.0-9\u00B7\u0300-\u036F\u203F-\u2040]*$/,p={},h={};function m(e,t,n,r,a,o,i){this.acceptsBooleans=2===t||3===t||4===t,this.attributeName=r,this.attributeNamespace=a,this.mustUseProperty=n,this.propertyName=e,this.type=t,this.sanitizeURL=o,this.removeEmptyString=i}var g={};"children dangerouslySetInnerHTML defaultValue defaultChecked innerHTML suppressContentEditableWarning suppressHydrationWarning style".split(" ").forEach((function(e){g[e]=new m(e,0,!1,e,null,!1,!1)})),[["acceptCharset","accept-charset"],["className","class"],["htmlFor","for"],["httpEquiv","http-equiv"]].forEach((function(e){var t=e[0];g[t]=new m(t,1,!1,e[1],null,!1,!1)})),["contentEditable","draggable","spellCheck","value"].forEach((function(e){g[e]=new m(e,2,!1,e.toLowerCase(),null,!1,!1)})),["autoReverse","externalResourcesRequired","focusable","preserveAlpha"].forEach((function(e){g[e]=new m(e,2,!1,e,null,!1,!1)})),"allowFullScreen async autoFocus autoPlay controls default defer disabled disablePictureInPicture disableRemotePlayback formNoValidate hidden loop noModule noValidate open playsInline readOnly required reversed scoped seamless itemScope".split(" ").forEach((function(e){g[e]=new m(e,3,!1,e.toLowerCase(),null,!1,!1)})),["checked","multiple","muted","selected"].forEach((function(e){g[e]=new m(e,3,!0,e,null,!1,!1)})),["capture","download"].forEach((function(e){g[e]=new m(e,4,!1,e,null,!1,!1)})),["cols","rows","size","span"].forEach((function(e){g[e]=new m(e,6,!1,e,null,!1,!1)})),["rowSpan","start"].forEach((function(e){g[e]=new m(e,5,!1,e.toLowerCase(),null,!1,!1)}));var v=/[\-:]([a-z])/g;function b(e){return e[1].toUpperCase()}function y(e,t,n,r){var a=g.hasOwnProperty(t)?g[t]:null;(null!==a?0!==a.type:r||!(2<t.length)||"o"!==t[0]&&"O"!==t[0]||"n"!==t[1]&&"N"!==t[1])&&(function(e,t,n,r){if(null==t||function(e,t,n,r){if(null!==n&&0===n.type)return!1;switch(typeof t){case"function":case"symbol":return!0;case"boolean":return!r&&(null!==n?!n.acceptsBooleans:"data-"!==(e=e.toLowerCase().slice(0,5))&&"aria-"!==e);default:return!1}}(e,t,n,r))return!0;if(r)return!1;if(null!==n)switch(n.type){case 3:return!t;case 4:return!1===t;case 5:return isNaN(t);case 6:return isNaN(t)||1>t}return!1}(t,n,a,r)&&(n=null),r||null===a?function(e){return!!d.call(h,e)||!d.call(p,e)&&(f.test(e)?h[e]=!0:(p[e]=!0,!1))}(t)&&(null===n?e.removeAttribute(t):e.setAttribute(t,""+n)):a.mustUseProperty?e[a.propertyName]=null===n?3!==a.type&&"":n:(t=a.attributeName,r=a.attributeNamespace,null===n?e.removeAttribute(t):(n=3===(a=a.type)||4===a&&!0===n?"":""+n,r?e.setAttributeNS(r,t,n):e.setAttribute(t,n))))}"accent-height alignment-baseline arabic-form baseline-shift cap-height clip-path clip-rule color-interpolation color-interpolation-filters color-profile color-rendering dominant-baseline enable-background fill-opacity fill-rule flood-color flood-opacity font-family font-size font-size-adjust font-stretch font-style font-variant font-weight glyph-name glyph-orientation-horizontal glyph-orientation-vertical horiz-adv-x horiz-origin-x image-rendering letter-spacing lighting-color marker-end marker-mid marker-start overline-position overline-thickness paint-order panose-1 pointer-events rendering-intent shape-rendering stop-color stop-opacity strikethrough-position strikethrough-thickness stroke-dasharray stroke-dashoffset stroke-linecap stroke-linejoin stroke-miterlimit stroke-opacity stroke-width text-anchor text-decoration text-rendering underline-position underline-thickness unicode-bidi unicode-range units-per-em v-alphabetic v-hanging v-ideographic v-mathematical vector-effect vert-adv-y vert-origin-x vert-origin-y word-spacing writing-mode xmlns:xlink x-height".split(" ").forEach((function(e){var t=e.replace(v,b);g[t]=new m(t,1,!1,e,null,!1,!1)})),"xlink:actuate xlink:arcrole xlink:role xlink:show xlink:title xlink:type".split(" ").forEach((function(e){var t=e.replace(v,b);g[t]=new m(t,1,!1,e,"http://www.w3.org/1999/xlink",!1,!1)})),["xml:base","xml:lang","xml:space"].forEach((function(e){var t=e.replace(v,b);g[t]=new m(t,1,!1,e,"http://www.w3.org/XML/1998/namespace",!1,!1)})),["tabIndex","crossOrigin"].forEach((function(e){g[e]=new m(e,1,!1,e.toLowerCase(),null,!1,!1)})),g.xlinkHref=new m("xlinkHref",1,!1,"xlink:href","http://www.w3.org/1999/xlink",!0,!1),["src","href","action","formAction"].forEach((function(e){g[e]=new m(e,1,!1,e.toLowerCase(),null,!0,!0)}));var C=r.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED,k=Symbol.for("react.element"),w=Symbol.for("react.portal"),E=Symbol.for("react.fragment"),x=Symbol.for("react.strict_mode"),S=Symbol.for("react.profiler"),O=Symbol.for("react.provider"),L=Symbol.for("react.context"),_=Symbol.for("react.forward_ref"),P=Symbol.for("react.suspense"),N=Symbol.for("react.suspense_list"),M=Symbol.for("react.memo"),A=Symbol.for("react.lazy");Symbol.for("react.scope"),Symbol.for("react.debug_trace_mode");var I=Symbol.for("react.offscreen");Symbol.for("react.legacy_hidden"),Symbol.for("react.cache"),Symbol.for("react.tracing_marker");var F=Symbol.iterator;function R(e){return null===e||"object"!=typeof e?null:"function"==typeof(e=F&&e[F]||e["@@iterator"])?e:null}var V,j=Object.assign;function z(e){if(void 0===V)try{throw Error()}catch(e){var t=e.stack.trim().match(/\n( *(at )?)/);V=t&&t[1]||""}return"\n"+V+e}var T=!1;function H(e,t){if(!e||T)return"";T=!0;var n=Error.prepareStackTrace;Error.prepareStackTrace=void 0;try{if(t)if(t=function(){throw Error()},Object.defineProperty(t.prototype,"props",{set:function(){throw Error()}}),"object"==typeof Reflect&&Reflect.construct){try{Reflect.construct(t,[])}catch(e){var r=e}Reflect.construct(e,[],t)}else{try{t.call()}catch(e){r=e}e.call(t.prototype)}else{try{throw Error()}catch(e){r=e}e()}}catch(t){if(t&&r&&"string"==typeof t.stack){for(var a=t.stack.split("\n"),o=r.stack.split("\n"),i=a.length-1,l=o.length-1;1<=i&&0<=l&&a[i]!==o[l];)l--;for(;1<=i&&0<=l;i--,l--)if(a[i]!==o[l]){if(1!==i||1!==l)do{if(i--,0>--l||a[i]!==o[l]){var s="\n"+a[i].replace(" at new "," at ");return e.displayName&&s.includes("<anonymous>")&&(s=s.replace("<anonymous>",e.displayName)),s}}while(1<=i&&0<=l);break}}}finally{T=!1,Error.prepareStackTrace=n}return(e=e?e.displayName||e.name:"")?z(e):""}function D(e){switch(e.tag){case 5:return z(e.type);case 16:return z("Lazy");case 13:return z("Suspense");case 19:return z("SuspenseList");case 0:case 2:case 15:return e=H(e.type,!1);case 11:return e=H(e.type.render,!1);case 1:return e=H(e.type,!0);default:return""}}function B(e){if(null==e)return null;if("function"==typeof e)return e.displayName||e.name||null;if("string"==typeof e)return e;switch(e){case E:return"Fragment";case w:return"Portal";case S:return"Profiler";case x:return"StrictMode";case P:return"Suspense";case N:return"SuspenseList"}if("object"==typeof e)switch(e.$$typeof){case L:return(e.displayName||"Context")+".Consumer";case O:return(e._context.displayName||"Context")+".Provider";case _:var t=e.render;return(e=e.displayName)||(e=""!==(e=t.displayName||t.name||"")?"ForwardRef("+e+")":"ForwardRef"),e;case M:return null!==(t=e.displayName||null)?t:B(e.type)||"Memo";case A:t=e._payload,e=e._init;try{return B(e(t))}catch(e){}}return null}function U(e){var t=e.type;switch(e.tag){case 24:return"Cache";case 9:return(t.displayName||"Context")+".Consumer";case 10:return(t._context.displayName||"Context")+".Provider";case 18:return"DehydratedFragment";case 11:return e=(e=t.render).displayName||e.name||"",t.displayName||(""!==e?"ForwardRef("+e+")":"ForwardRef");case 7:return"Fragment";case 5:return t;case 4:return"Portal";case 3:return"Root";case 6:return"Text";case 16:return B(t);case 8:return t===x?"StrictMode":"Mode";case 22:return"Offscreen";case 12:return"Profiler";case 21:return"Scope";case 13:return"Suspense";case 19:return"SuspenseList";case 25:return"TracingMarker";case 1:case 0:case 17:case 2:case 14:case 15:if("function"==typeof t)return t.displayName||t.name||null;if("string"==typeof t)return t}return null}function Z(e){switch(typeof e){case"boolean":case"number":case"string":case"undefined":case"object":return e;default:return""}}function W(e){var t=e.type;return(e=e.nodeName)&&"input"===e.toLowerCase()&&("checkbox"===t||"radio"===t)}function G(e){e._valueTracker||(e._valueTracker=function(e){var t=W(e)?"checked":"value",n=Object.getOwnPropertyDescriptor(e.constructor.prototype,t),r=""+e[t];if(!e.hasOwnProperty(t)&&void 0!==n&&"function"==typeof n.get&&"function"==typeof n.set){var a=n.get,o=n.set;return Object.defineProperty(e,t,{configurable:!0,get:function(){return a.call(this)},set:function(e){r=""+e,o.call(this,e)}}),Object.defineProperty(e,t,{enumerable:n.enumerable}),{getValue:function(){return r},setValue:function(e){r=""+e},stopTracking:function(){e._valueTracker=null,delete e[t]}}}}(e))}function K(e){if(!e)return!1;var t=e._valueTracker;if(!t)return!0;var n=t.getValue(),r="";return e&&(r=W(e)?e.checked?"true":"false":e.value),(e=r)!==n&&(t.setValue(e),!0)}function $(e){if(void 0===(e=e||("undefined"!=typeof document?document:void 0)))return null;try{return e.activeElement||e.body}catch(t){return e.body}}function J(e,t){var n=t.checked;return j({},t,{defaultChecked:void 0,defaultValue:void 0,value:void 0,checked:null!=n?n:e._wrapperState.initialChecked})}function Q(e,t){var n=null==t.defaultValue?"":t.defaultValue,r=null!=t.checked?t.checked:t.defaultChecked;n=Z(null!=t.value?t.value:n),e._wrapperState={initialChecked:r,initialValue:n,controlled:"checkbox"===t.type||"radio"===t.type?null!=t.checked:null!=t.value}}function q(e,t){null!=(t=t.checked)&&y(e,"checked",t,!1)}function Y(e,t){q(e,t);var n=Z(t.value),r=t.type;if(null!=n)"number"===r?(0===n&&""===e.value||e.value!=n)&&(e.value=""+n):e.value!==""+n&&(e.value=""+n);else if("submit"===r||"reset"===r)return void e.removeAttribute("value");t.hasOwnProperty("value")?ee(e,t.type,n):t.hasOwnProperty("defaultValue")&&ee(e,t.type,Z(t.defaultValue)),null==t.checked&&null!=t.defaultChecked&&(e.defaultChecked=!!t.defaultChecked)}function X(e,t,n){if(t.hasOwnProperty("value")||t.hasOwnProperty("defaultValue")){var r=t.type;if(!("submit"!==r&&"reset"!==r||void 0!==t.value&&null!==t.value))return;t=""+e._wrapperState.initialValue,n||t===e.value||(e.value=t),e.defaultValue=t}""!==(n=e.name)&&(e.name=""),e.defaultChecked=!!e._wrapperState.initialChecked,""!==n&&(e.name=n)}function ee(e,t,n){"number"===t&&$(e.ownerDocument)===e||(null==n?e.defaultValue=""+e._wrapperState.initialValue:e.defaultValue!==""+n&&(e.defaultValue=""+n))}var te=Array.isArray;function ne(e,t,n,r){if(e=e.options,t){t={};for(var a=0;a<n.length;a++)t["$"+n[a]]=!0;for(n=0;n<e.length;n++)a=t.hasOwnProperty("$"+e[n].value),e[n].selected!==a&&(e[n].selected=a),a&&r&&(e[n].defaultSelected=!0)}else{for(n=""+Z(n),t=null,a=0;a<e.length;a++){if(e[a].value===n)return e[a].selected=!0,void(r&&(e[a].defaultSelected=!0));null!==t||e[a].disabled||(t=e[a])}null!==t&&(t.selected=!0)}}function re(e,t){if(null!=t.dangerouslySetInnerHTML)throw Error(o(91));return j({},t,{value:void 0,defaultValue:void 0,children:""+e._wrapperState.initialValue})}function ae(e,t){var n=t.value;if(null==n){if(n=t.children,t=t.defaultValue,null!=n){if(null!=t)throw Error(o(92));if(te(n)){if(1<n.length)throw Error(o(93));n=n[0]}t=n}null==t&&(t=""),n=t}e._wrapperState={initialValue:Z(n)}}function oe(e,t){var n=Z(t.value),r=Z(t.defaultValue);null!=n&&((n=""+n)!==e.value&&(e.value=n),null==t.defaultValue&&e.defaultValue!==n&&(e.defaultValue=n)),null!=r&&(e.defaultValue=""+r)}function ie(e){var t=e.textContent;t===e._wrapperState.initialValue&&""!==t&&null!==t&&(e.value=t)}function le(e){switch(e){case"svg":return"http://www.w3.org/2000/svg";case"math":return"http://www.w3.org/1998/Math/MathML";default:return"http://www.w3.org/1999/xhtml"}}function se(e,t){return null==e||"http://www.w3.org/1999/xhtml"===e?le(t):"http://www.w3.org/2000/svg"===e&&"foreignObject"===t?"http://www.w3.org/1999/xhtml":e}var ue,ce,de=(ce=function(e,t){if("http://www.w3.org/2000/svg"!==e.namespaceURI||"innerHTML"in e)e.innerHTML=t;else{for((ue=ue||document.createElement("div")).innerHTML="<svg>"+t.valueOf().toString()+"</svg>",t=ue.firstChild;e.firstChild;)e.removeChild(e.firstChild);for(;t.firstChild;)e.appendChild(t.firstChild)}},"undefined"!=typeof MSApp&&MSApp.execUnsafeLocalFunction?function(e,t,n,r){MSApp.execUnsafeLocalFunction((function(){return ce(e,t)}))}:ce);function fe(e,t){if(t){var n=e.firstChild;if(n&&n===e.lastChild&&3===n.nodeType)return void(n.nodeValue=t)}e.textContent=t}var pe={animationIterationCount:!0,aspectRatio:!0,borderImageOutset:!0,borderImageSlice:!0,borderImageWidth:!0,boxFlex:!0,boxFlexGroup:!0,boxOrdinalGroup:!0,columnCount:!0,columns:!0,flex:!0,flexGrow:!0,flexPositive:!0,flexShrink:!0,flexNegative:!0,flexOrder:!0,gridArea:!0,gridRow:!0,gridRowEnd:!0,gridRowSpan:!0,gridRowStart:!0,gridColumn:!0,gridColumnEnd:!0,gridColumnSpan:!0,gridColumnStart:!0,fontWeight:!0,lineClamp:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,tabSize:!0,widows:!0,zIndex:!0,zoom:!0,fillOpacity:!0,floodOpacity:!0,stopOpacity:!0,strokeDasharray:!0,strokeDashoffset:!0,strokeMiterlimit:!0,strokeOpacity:!0,strokeWidth:!0},he=["Webkit","ms","Moz","O"];function me(e,t,n){return null==t||"boolean"==typeof t||""===t?"":n||"number"!=typeof t||0===t||pe.hasOwnProperty(e)&&pe[e]?(""+t).trim():t+"px"}function ge(e,t){for(var n in e=e.style,t)if(t.hasOwnProperty(n)){var r=0===n.indexOf("--"),a=me(n,t[n],r);"float"===n&&(n="cssFloat"),r?e.setProperty(n,a):e[n]=a}}Object.keys(pe).forEach((function(e){he.forEach((function(t){t=t+e.charAt(0).toUpperCase()+e.substring(1),pe[t]=pe[e]}))}));var ve=j({menuitem:!0},{area:!0,base:!0,br:!0,col:!0,embed:!0,hr:!0,img:!0,input:!0,keygen:!0,link:!0,meta:!0,param:!0,source:!0,track:!0,wbr:!0});function be(e,t){if(t){if(ve[e]&&(null!=t.children||null!=t.dangerouslySetInnerHTML))throw Error(o(137,e));if(null!=t.dangerouslySetInnerHTML){if(null!=t.children)throw Error(o(60));if("object"!=typeof t.dangerouslySetInnerHTML||!("__html"in t.dangerouslySetInnerHTML))throw Error(o(61))}if(null!=t.style&&"object"!=typeof t.style)throw Error(o(62))}}function ye(e,t){if(-1===e.indexOf("-"))return"string"==typeof t.is;switch(e){case"annotation-xml":case"color-profile":case"font-face":case"font-face-src":case"font-face-uri":case"font-face-format":case"font-face-name":case"missing-glyph":return!1;default:return!0}}var Ce=null;function ke(e){return(e=e.target||e.srcElement||window).correspondingUseElement&&(e=e.correspondingUseElement),3===e.nodeType?e.parentNode:e}var we=null,Ee=null,xe=null;function Se(e){if(e=ya(e)){if("function"!=typeof we)throw Error(o(280));var t=e.stateNode;t&&(t=ka(t),we(e.stateNode,e.type,t))}}function Oe(e){Ee?xe?xe.push(e):xe=[e]:Ee=e}function Le(){if(Ee){var e=Ee,t=xe;if(xe=Ee=null,Se(e),t)for(e=0;e<t.length;e++)Se(t[e])}}function _e(e,t){return e(t)}function Pe(){}var Ne=!1;function Me(e,t,n){if(Ne)return e(t,n);Ne=!0;try{return _e(e,t,n)}finally{Ne=!1,(null!==Ee||null!==xe)&&(Pe(),Le())}}function Ae(e,t){var n=e.stateNode;if(null===n)return null;var r=ka(n);if(null===r)return null;n=r[t];e:switch(t){case"onClick":case"onClickCapture":case"onDoubleClick":case"onDoubleClickCapture":case"onMouseDown":case"onMouseDownCapture":case"onMouseMove":case"onMouseMoveCapture":case"onMouseUp":case"onMouseUpCapture":case"onMouseEnter":(r=!r.disabled)||(r=!("button"===(e=e.type)||"input"===e||"select"===e||"textarea"===e)),e=!r;break e;default:e=!1}if(e)return null;if(n&&"function"!=typeof n)throw Error(o(231,t,typeof n));return n}var Ie=!1;if(c)try{var Fe={};Object.defineProperty(Fe,"passive",{get:function(){Ie=!0}}),window.addEventListener("test",Fe,Fe),window.removeEventListener("test",Fe,Fe)}catch(ce){Ie=!1}function Re(e,t,n,r,a,o,i,l,s){var u=Array.prototype.slice.call(arguments,3);try{t.apply(n,u)}catch(e){this.onError(e)}}var Ve=!1,je=null,ze=!1,Te=null,He={onError:function(e){Ve=!0,je=e}};function De(e,t,n,r,a,o,i,l,s){Ve=!1,je=null,Re.apply(He,arguments)}function Be(e){var t=e,n=e;if(e.alternate)for(;t.return;)t=t.return;else{e=t;do{0!=(4098&(t=e).flags)&&(n=t.return),e=t.return}while(e)}return 3===t.tag?n:null}function Ue(e){if(13===e.tag){var t=e.memoizedState;if(null===t&&(null!==(e=e.alternate)&&(t=e.memoizedState)),null!==t)return t.dehydrated}return null}function Ze(e){if(Be(e)!==e)throw Error(o(188))}function We(e){return null!==(e=function(e){var t=e.alternate;if(!t){if(null===(t=Be(e)))throw Error(o(188));return t!==e?null:e}for(var n=e,r=t;;){var a=n.return;if(null===a)break;var i=a.alternate;if(null===i){if(null!==(r=a.return)){n=r;continue}break}if(a.child===i.child){for(i=a.child;i;){if(i===n)return Ze(a),e;if(i===r)return Ze(a),t;i=i.sibling}throw Error(o(188))}if(n.return!==r.return)n=a,r=i;else{for(var l=!1,s=a.child;s;){if(s===n){l=!0,n=a,r=i;break}if(s===r){l=!0,r=a,n=i;break}s=s.sibling}if(!l){for(s=i.child;s;){if(s===n){l=!0,n=i,r=a;break}if(s===r){l=!0,r=i,n=a;break}s=s.sibling}if(!l)throw Error(o(189))}}if(n.alternate!==r)throw Error(o(190))}if(3!==n.tag)throw Error(o(188));return n.stateNode.current===n?e:t}(e))?Ge(e):null}function Ge(e){if(5===e.tag||6===e.tag)return e;for(e=e.child;null!==e;){var t=Ge(e);if(null!==t)return t;e=e.sibling}return null}var Ke=a.unstable_scheduleCallback,$e=a.unstable_cancelCallback,Je=a.unstable_shouldYield,Qe=a.unstable_requestPaint,qe=a.unstable_now,Ye=a.unstable_getCurrentPriorityLevel,Xe=a.unstable_ImmediatePriority,et=a.unstable_UserBlockingPriority,tt=a.unstable_NormalPriority,nt=a.unstable_LowPriority,rt=a.unstable_IdlePriority,at=null,ot=null;var it=Math.clz32?Math.clz32:function(e){return e>>>=0,0===e?32:31-(lt(e)/st|0)|0},lt=Math.log,st=Math.LN2;var ut=64,ct=4194304;function dt(e){switch(e&-e){case 1:return 1;case 2:return 2;case 4:return 4;case 8:return 8;case 16:return 16;case 32:return 32;case 64:case 128:case 256:case 512:case 1024:case 2048:case 4096:case 8192:case 16384:case 32768:case 65536:case 131072:case 262144:case 524288:case 1048576:case 2097152:return 4194240&e;case 4194304:case 8388608:case 16777216:case 33554432:case 67108864:return 130023424&e;case 134217728:return 134217728;case 268435456:return 268435456;case 536870912:return 536870912;case 1073741824:return 1073741824;default:return e}}function ft(e,t){var n=e.pendingLanes;if(0===n)return 0;var r=0,a=e.suspendedLanes,o=e.pingedLanes,i=268435455&n;if(0!==i){var l=i&~a;0!==l?r=dt(l):0!==(o&=i)&&(r=dt(o))}else 0!==(i=n&~a)?r=dt(i):0!==o&&(r=dt(o));if(0===r)return 0;if(0!==t&&t!==r&&0==(t&a)&&((a=r&-r)>=(o=t&-t)||16===a&&0!=(4194240&o)))return t;if(0!=(4&r)&&(r|=16&n),0!==(t=e.entangledLanes))for(e=e.entanglements,t&=r;0<t;)a=1<<(n=31-it(t)),r|=e[n],t&=~a;return r}function pt(e,t){switch(e){case 1:case 2:case 4:return t+250;case 8:case 16:case 32:case 64:case 128:case 256:case 512:case 1024:case 2048:case 4096:case 8192:case 16384:case 32768:case 65536:case 131072:case 262144:case 524288:case 1048576:case 2097152:return t+5e3;default:return-1}}function ht(e){return 0!==(e=-1073741825&e.pendingLanes)?e:1073741824&e?1073741824:0}function mt(){var e=ut;return 0==(4194240&(ut<<=1))&&(ut=64),e}function gt(e){for(var t=[],n=0;31>n;n++)t.push(e);return t}function vt(e,t,n){e.pendingLanes|=t,536870912!==t&&(e.suspendedLanes=0,e.pingedLanes=0),(e=e.eventTimes)[t=31-it(t)]=n}function bt(e,t){var n=e.entangledLanes|=t;for(e=e.entanglements;n;){var r=31-it(n),a=1<<r;a&t|e[r]&t&&(e[r]|=t),n&=~a}}var yt=0;function Ct(e){return 1<(e&=-e)?4<e?0!=(268435455&e)?16:536870912:4:1}var kt,wt,Et,xt,St,Ot=!1,Lt=[],_t=null,Pt=null,Nt=null,Mt=new Map,At=new Map,It=[],Ft="mousedown mouseup touchcancel touchend touchstart auxclick dblclick pointercancel pointerdown pointerup dragend dragstart drop compositionend compositionstart keydown keypress keyup input textInput copy cut paste click change contextmenu reset submit".split(" ");function Rt(e,t){switch(e){case"focusin":case"focusout":_t=null;break;case"dragenter":case"dragleave":Pt=null;break;case"mouseover":case"mouseout":Nt=null;break;case"pointerover":case"pointerout":Mt.delete(t.pointerId);break;case"gotpointercapture":case"lostpointercapture":At.delete(t.pointerId)}}function Vt(e,t,n,r,a,o){return null===e||e.nativeEvent!==o?(e={blockedOn:t,domEventName:n,eventSystemFlags:r,nativeEvent:o,targetContainers:[a]},null!==t&&(null!==(t=ya(t))&&wt(t)),e):(e.eventSystemFlags|=r,t=e.targetContainers,null!==a&&-1===t.indexOf(a)&&t.push(a),e)}function jt(e){var t=ba(e.target);if(null!==t){var n=Be(t);if(null!==n)if(13===(t=n.tag)){if(null!==(t=Ue(n)))return e.blockedOn=t,void St(e.priority,(function(){Et(n)}))}else if(3===t&&n.stateNode.current.memoizedState.isDehydrated)return void(e.blockedOn=3===n.tag?n.stateNode.containerInfo:null)}e.blockedOn=null}function zt(e){if(null!==e.blockedOn)return!1;for(var t=e.targetContainers;0<t.length;){var n=Jt(e.domEventName,e.eventSystemFlags,t[0],e.nativeEvent);if(null!==n)return null!==(t=ya(n))&&wt(t),e.blockedOn=n,!1;var r=new(n=e.nativeEvent).constructor(n.type,n);Ce=r,n.target.dispatchEvent(r),Ce=null,t.shift()}return!0}function Tt(e,t,n){zt(e)&&n.delete(t)}function Ht(){Ot=!1,null!==_t&&zt(_t)&&(_t=null),null!==Pt&&zt(Pt)&&(Pt=null),null!==Nt&&zt(Nt)&&(Nt=null),Mt.forEach(Tt),At.forEach(Tt)}function Dt(e,t){e.blockedOn===t&&(e.blockedOn=null,Ot||(Ot=!0,a.unstable_scheduleCallback(a.unstable_NormalPriority,Ht)))}function Bt(e){function t(t){return Dt(t,e)}if(0<Lt.length){Dt(Lt[0],e);for(var n=1;n<Lt.length;n++){var r=Lt[n];r.blockedOn===e&&(r.blockedOn=null)}}for(null!==_t&&Dt(_t,e),null!==Pt&&Dt(Pt,e),null!==Nt&&Dt(Nt,e),Mt.forEach(t),At.forEach(t),n=0;n<It.length;n++)(r=It[n]).blockedOn===e&&(r.blockedOn=null);for(;0<It.length&&null===(n=It[0]).blockedOn;)jt(n),null===n.blockedOn&&It.shift()}var Ut=C.ReactCurrentBatchConfig,Zt=!0;function Wt(e,t,n,r){var a=yt,o=Ut.transition;Ut.transition=null;try{yt=1,Kt(e,t,n,r)}finally{yt=a,Ut.transition=o}}function Gt(e,t,n,r){var a=yt,o=Ut.transition;Ut.transition=null;try{yt=4,Kt(e,t,n,r)}finally{yt=a,Ut.transition=o}}function Kt(e,t,n,r){if(Zt){var a=Jt(e,t,n,r);if(null===a)Zr(e,t,r,$t,n),Rt(e,r);else if(function(e,t,n,r,a){switch(t){case"focusin":return _t=Vt(_t,e,t,n,r,a),!0;case"dragenter":return Pt=Vt(Pt,e,t,n,r,a),!0;case"mouseover":return Nt=Vt(Nt,e,t,n,r,a),!0;case"pointerover":var o=a.pointerId;return Mt.set(o,Vt(Mt.get(o)||null,e,t,n,r,a)),!0;case"gotpointercapture":return o=a.pointerId,At.set(o,Vt(At.get(o)||null,e,t,n,r,a)),!0}return!1}(a,e,t,n,r))r.stopPropagation();else if(Rt(e,r),4&t&&-1<Ft.indexOf(e)){for(;null!==a;){var o=ya(a);if(null!==o&&kt(o),null===(o=Jt(e,t,n,r))&&Zr(e,t,r,$t,n),o===a)break;a=o}null!==a&&r.stopPropagation()}else Zr(e,t,r,null,n)}}var $t=null;function Jt(e,t,n,r){if($t=null,null!==(e=ba(e=ke(r))))if(null===(t=Be(e)))e=null;else if(13===(n=t.tag)){if(null!==(e=Ue(t)))return e;e=null}else if(3===n){if(t.stateNode.current.memoizedState.isDehydrated)return 3===t.tag?t.stateNode.containerInfo:null;e=null}else t!==e&&(e=null);return $t=e,null}function Qt(e){switch(e){case"cancel":case"click":case"close":case"contextmenu":case"copy":case"cut":case"auxclick":case"dblclick":case"dragend":case"dragstart":case"drop":case"focusin":case"focusout":case"input":case"invalid":case"keydown":case"keypress":case"keyup":case"mousedown":case"mouseup":case"paste":case"pause":case"play":case"pointercancel":case"pointerdown":case"pointerup":case"ratechange":case"reset":case"resize":case"seeked":case"submit":case"touchcancel":case"touchend":case"touchstart":case"volumechange":case"change":case"selectionchange":case"textInput":case"compositionstart":case"compositionend":case"compositionupdate":case"beforeblur":case"afterblur":case"beforeinput":case"blur":case"fullscreenchange":case"focus":case"hashchange":case"popstate":case"select":case"selectstart":return 1;case"drag":case"dragenter":case"dragexit":case"dragleave":case"dragover":case"mousemove":case"mouseout":case"mouseover":case"pointermove":case"pointerout":case"pointerover":case"scroll":case"toggle":case"touchmove":case"wheel":case"mouseenter":case"mouseleave":case"pointerenter":case"pointerleave":return 4;case"message":switch(Ye()){case Xe:return 1;case et:return 4;case tt:case nt:return 16;case rt:return 536870912;default:return 16}default:return 16}}var qt=null,Yt=null,Xt=null;function en(){if(Xt)return Xt;var e,t,n=Yt,r=n.length,a="value"in qt?qt.value:qt.textContent,o=a.length;for(e=0;e<r&&n[e]===a[e];e++);var i=r-e;for(t=1;t<=i&&n[r-t]===a[o-t];t++);return Xt=a.slice(e,1<t?1-t:void 0)}function tn(e){var t=e.keyCode;return"charCode"in e?0===(e=e.charCode)&&13===t&&(e=13):e=t,10===e&&(e=13),32<=e||13===e?e:0}function nn(){return!0}function rn(){return!1}function an(e){function t(t,n,r,a,o){for(var i in this._reactName=t,this._targetInst=r,this.type=n,this.nativeEvent=a,this.target=o,this.currentTarget=null,e)e.hasOwnProperty(i)&&(t=e[i],this[i]=t?t(a):a[i]);return this.isDefaultPrevented=(null!=a.defaultPrevented?a.defaultPrevented:!1===a.returnValue)?nn:rn,this.isPropagationStopped=rn,this}return j(t.prototype,{preventDefault:function(){this.defaultPrevented=!0;var e=this.nativeEvent;e&&(e.preventDefault?e.preventDefault():"unknown"!=typeof e.returnValue&&(e.returnValue=!1),this.isDefaultPrevented=nn)},stopPropagation:function(){var e=this.nativeEvent;e&&(e.stopPropagation?e.stopPropagation():"unknown"!=typeof e.cancelBubble&&(e.cancelBubble=!0),this.isPropagationStopped=nn)},persist:function(){},isPersistent:nn}),t}var on,ln,sn,un={eventPhase:0,bubbles:0,cancelable:0,timeStamp:function(e){return e.timeStamp||Date.now()},defaultPrevented:0,isTrusted:0},cn=an(un),dn=j({},un,{view:0,detail:0}),fn=an(dn),pn=j({},dn,{screenX:0,screenY:0,clientX:0,clientY:0,pageX:0,pageY:0,ctrlKey:0,shiftKey:0,altKey:0,metaKey:0,getModifierState:Sn,button:0,buttons:0,relatedTarget:function(e){return void 0===e.relatedTarget?e.fromElement===e.srcElement?e.toElement:e.fromElement:e.relatedTarget},movementX:function(e){return"movementX"in e?e.movementX:(e!==sn&&(sn&&"mousemove"===e.type?(on=e.screenX-sn.screenX,ln=e.screenY-sn.screenY):ln=on=0,sn=e),on)},movementY:function(e){return"movementY"in e?e.movementY:ln}}),hn=an(pn),mn=an(j({},pn,{dataTransfer:0})),gn=an(j({},dn,{relatedTarget:0})),vn=an(j({},un,{animationName:0,elapsedTime:0,pseudoElement:0})),bn=j({},un,{clipboardData:function(e){return"clipboardData"in e?e.clipboardData:window.clipboardData}}),yn=an(bn),Cn=an(j({},un,{data:0})),kn={Esc:"Escape",Spacebar:" ",Left:"ArrowLeft",Up:"ArrowUp",Right:"ArrowRight",Down:"ArrowDown",Del:"Delete",Win:"OS",Menu:"ContextMenu",Apps:"ContextMenu",Scroll:"ScrollLock",MozPrintableKey:"Unidentified"},wn={8:"Backspace",9:"Tab",12:"Clear",13:"Enter",16:"Shift",17:"Control",18:"Alt",19:"Pause",20:"CapsLock",27:"Escape",32:" ",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"ArrowLeft",38:"ArrowUp",39:"ArrowRight",40:"ArrowDown",45:"Insert",46:"Delete",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"NumLock",145:"ScrollLock",224:"Meta"},En={Alt:"altKey",Control:"ctrlKey",Meta:"metaKey",Shift:"shiftKey"};function xn(e){var t=this.nativeEvent;return t.getModifierState?t.getModifierState(e):!!(e=En[e])&&!!t[e]}function Sn(){return xn}var On=j({},dn,{key:function(e){if(e.key){var t=kn[e.key]||e.key;if("Unidentified"!==t)return t}return"keypress"===e.type?13===(e=tn(e))?"Enter":String.fromCharCode(e):"keydown"===e.type||"keyup"===e.type?wn[e.keyCode]||"Unidentified":""},code:0,location:0,ctrlKey:0,shiftKey:0,altKey:0,metaKey:0,repeat:0,locale:0,getModifierState:Sn,charCode:function(e){return"keypress"===e.type?tn(e):0},keyCode:function(e){return"keydown"===e.type||"keyup"===e.type?e.keyCode:0},which:function(e){return"keypress"===e.type?tn(e):"keydown"===e.type||"keyup"===e.type?e.keyCode:0}}),Ln=an(On),_n=an(j({},pn,{pointerId:0,width:0,height:0,pressure:0,tangentialPressure:0,tiltX:0,tiltY:0,twist:0,pointerType:0,isPrimary:0})),Pn=an(j({},dn,{touches:0,targetTouches:0,changedTouches:0,altKey:0,metaKey:0,ctrlKey:0,shiftKey:0,getModifierState:Sn})),Nn=an(j({},un,{propertyName:0,elapsedTime:0,pseudoElement:0})),Mn=j({},pn,{deltaX:function(e){return"deltaX"in e?e.deltaX:"wheelDeltaX"in e?-e.wheelDeltaX:0},deltaY:function(e){return"deltaY"in e?e.deltaY:"wheelDeltaY"in e?-e.wheelDeltaY:"wheelDelta"in e?-e.wheelDelta:0},deltaZ:0,deltaMode:0}),An=an(Mn),In=[9,13,27,32],Fn=c&&"CompositionEvent"in window,Rn=null;c&&"documentMode"in document&&(Rn=document.documentMode);var Vn=c&&"TextEvent"in window&&!Rn,jn=c&&(!Fn||Rn&&8<Rn&&11>=Rn),zn=String.fromCharCode(32),Tn=!1;function Hn(e,t){switch(e){case"keyup":return-1!==In.indexOf(t.keyCode);case"keydown":return 229!==t.keyCode;case"keypress":case"mousedown":case"focusout":return!0;default:return!1}}function Dn(e){return"object"==typeof(e=e.detail)&&"data"in e?e.data:null}var Bn=!1;var Un={color:!0,date:!0,datetime:!0,"datetime-local":!0,email:!0,month:!0,number:!0,password:!0,range:!0,search:!0,tel:!0,text:!0,time:!0,url:!0,week:!0};function Zn(e){var t=e&&e.nodeName&&e.nodeName.toLowerCase();return"input"===t?!!Un[e.type]:"textarea"===t}function Wn(e,t,n,r){Oe(r),0<(t=Gr(t,"onChange")).length&&(n=new cn("onChange","change",null,n,r),e.push({event:n,listeners:t}))}var Gn=null,Kn=null;function $n(e){zr(e,0)}function Jn(e){if(K(Ca(e)))return e}function Qn(e,t){if("change"===e)return t}var qn=!1;if(c){var Yn;if(c){var Xn="oninput"in document;if(!Xn){var er=document.createElement("div");er.setAttribute("oninput","return;"),Xn="function"==typeof er.oninput}Yn=Xn}else Yn=!1;qn=Yn&&(!document.documentMode||9<document.documentMode)}function tr(){Gn&&(Gn.detachEvent("onpropertychange",nr),Kn=Gn=null)}function nr(e){if("value"===e.propertyName&&Jn(Kn)){var t=[];Wn(t,Kn,e,ke(e)),Me($n,t)}}function rr(e,t,n){"focusin"===e?(tr(),Kn=n,(Gn=t).attachEvent("onpropertychange",nr)):"focusout"===e&&tr()}function ar(e){if("selectionchange"===e||"keyup"===e||"keydown"===e)return Jn(Kn)}function or(e,t){if("click"===e)return Jn(t)}function ir(e,t){if("input"===e||"change"===e)return Jn(t)}var lr="function"==typeof Object.is?Object.is:function(e,t){return e===t&&(0!==e||1/e==1/t)||e!=e&&t!=t};function sr(e,t){if(lr(e,t))return!0;if("object"!=typeof e||null===e||"object"!=typeof t||null===t)return!1;var n=Object.keys(e),r=Object.keys(t);if(n.length!==r.length)return!1;for(r=0;r<n.length;r++){var a=n[r];if(!d.call(t,a)||!lr(e[a],t[a]))return!1}return!0}function ur(e){for(;e&&e.firstChild;)e=e.firstChild;return e}function cr(e,t){var n,r=ur(e);for(e=0;r;){if(3===r.nodeType){if(n=e+r.textContent.length,e<=t&&n>=t)return{node:r,offset:t-e};e=n}e:{for(;r;){if(r.nextSibling){r=r.nextSibling;break e}r=r.parentNode}r=void 0}r=ur(r)}}function dr(e,t){return!(!e||!t)&&(e===t||(!e||3!==e.nodeType)&&(t&&3===t.nodeType?dr(e,t.parentNode):"contains"in e?e.contains(t):!!e.compareDocumentPosition&&!!(16&e.compareDocumentPosition(t))))}function fr(){for(var e=window,t=$();t instanceof e.HTMLIFrameElement;){try{var n="string"==typeof t.contentWindow.location.href}catch(e){n=!1}if(!n)break;t=$((e=t.contentWindow).document)}return t}function pr(e){var t=e&&e.nodeName&&e.nodeName.toLowerCase();return t&&("input"===t&&("text"===e.type||"search"===e.type||"tel"===e.type||"url"===e.type||"password"===e.type)||"textarea"===t||"true"===e.contentEditable)}function hr(e){var t=fr(),n=e.focusedElem,r=e.selectionRange;if(t!==n&&n&&n.ownerDocument&&dr(n.ownerDocument.documentElement,n)){if(null!==r&&pr(n))if(t=r.start,void 0===(e=r.end)&&(e=t),"selectionStart"in n)n.selectionStart=t,n.selectionEnd=Math.min(e,n.value.length);else if((e=(t=n.ownerDocument||document)&&t.defaultView||window).getSelection){e=e.getSelection();var a=n.textContent.length,o=Math.min(r.start,a);r=void 0===r.end?o:Math.min(r.end,a),!e.extend&&o>r&&(a=r,r=o,o=a),a=cr(n,o);var i=cr(n,r);a&&i&&(1!==e.rangeCount||e.anchorNode!==a.node||e.anchorOffset!==a.offset||e.focusNode!==i.node||e.focusOffset!==i.offset)&&((t=t.createRange()).setStart(a.node,a.offset),e.removeAllRanges(),o>r?(e.addRange(t),e.extend(i.node,i.offset)):(t.setEnd(i.node,i.offset),e.addRange(t)))}for(t=[],e=n;e=e.parentNode;)1===e.nodeType&&t.push({element:e,left:e.scrollLeft,top:e.scrollTop});for("function"==typeof n.focus&&n.focus(),n=0;n<t.length;n++)(e=t[n]).element.scrollLeft=e.left,e.element.scrollTop=e.top}}var mr=c&&"documentMode"in document&&11>=document.documentMode,gr=null,vr=null,br=null,yr=!1;function Cr(e,t,n){var r=n.window===n?n.document:9===n.nodeType?n:n.ownerDocument;yr||null==gr||gr!==$(r)||("selectionStart"in(r=gr)&&pr(r)?r={start:r.selectionStart,end:r.selectionEnd}:r={anchorNode:(r=(r.ownerDocument&&r.ownerDocument.defaultView||window).getSelection()).anchorNode,anchorOffset:r.anchorOffset,focusNode:r.focusNode,focusOffset:r.focusOffset},br&&sr(br,r)||(br=r,0<(r=Gr(vr,"onSelect")).length&&(t=new cn("onSelect","select",null,t,n),e.push({event:t,listeners:r}),t.target=gr)))}function kr(e,t){var n={};return n[e.toLowerCase()]=t.toLowerCase(),n["Webkit"+e]="webkit"+t,n["Moz"+e]="moz"+t,n}var wr={animationend:kr("Animation","AnimationEnd"),animationiteration:kr("Animation","AnimationIteration"),animationstart:kr("Animation","AnimationStart"),transitionend:kr("Transition","TransitionEnd")},Er={},xr={};function Sr(e){if(Er[e])return Er[e];if(!wr[e])return e;var t,n=wr[e];for(t in n)if(n.hasOwnProperty(t)&&t in xr)return Er[e]=n[t];return e}c&&(xr=document.createElement("div").style,"AnimationEvent"in window||(delete wr.animationend.animation,delete wr.animationiteration.animation,delete wr.animationstart.animation),"TransitionEvent"in window||delete wr.transitionend.transition);var Or=Sr("animationend"),Lr=Sr("animationiteration"),_r=Sr("animationstart"),Pr=Sr("transitionend"),Nr=new Map,Mr="abort auxClick cancel canPlay canPlayThrough click close contextMenu copy cut drag dragEnd dragEnter dragExit dragLeave dragOver dragStart drop durationChange emptied encrypted ended error gotPointerCapture input invalid keyDown keyPress keyUp load loadedData loadedMetadata loadStart lostPointerCapture mouseDown mouseMove mouseOut mouseOver mouseUp paste pause play playing pointerCancel pointerDown pointerMove pointerOut pointerOver pointerUp progress rateChange reset resize seeked seeking stalled submit suspend timeUpdate touchCancel touchEnd touchStart volumeChange scroll toggle touchMove waiting wheel".split(" ");function Ar(e,t){Nr.set(e,t),s(t,[e])}for(var Ir=0;Ir<Mr.length;Ir++){var Fr=Mr[Ir];Ar(Fr.toLowerCase(),"on"+(Fr[0].toUpperCase()+Fr.slice(1)))}Ar(Or,"onAnimationEnd"),Ar(Lr,"onAnimationIteration"),Ar(_r,"onAnimationStart"),Ar("dblclick","onDoubleClick"),Ar("focusin","onFocus"),Ar("focusout","onBlur"),Ar(Pr,"onTransitionEnd"),u("onMouseEnter",["mouseout","mouseover"]),u("onMouseLeave",["mouseout","mouseover"]),u("onPointerEnter",["pointerout","pointerover"]),u("onPointerLeave",["pointerout","pointerover"]),s("onChange","change click focusin focusout input keydown keyup selectionchange".split(" ")),s("onSelect","focusout contextmenu dragend focusin keydown keyup mousedown mouseup selectionchange".split(" ")),s("onBeforeInput",["compositionend","keypress","textInput","paste"]),s("onCompositionEnd","compositionend focusout keydown keypress keyup mousedown".split(" ")),s("onCompositionStart","compositionstart focusout keydown keypress keyup mousedown".split(" ")),s("onCompositionUpdate","compositionupdate focusout keydown keypress keyup mousedown".split(" "));var Rr="abort canplay canplaythrough durationchange emptied encrypted ended error loadeddata loadedmetadata loadstart pause play playing progress ratechange resize seeked seeking stalled suspend timeupdate volumechange waiting".split(" "),Vr=new Set("cancel close invalid load scroll toggle".split(" ").concat(Rr));function jr(e,t,n){var r=e.type||"unknown-event";e.currentTarget=n,function(e,t,n,r,a,i,l,s,u){if(De.apply(this,arguments),Ve){if(!Ve)throw Error(o(198));var c=je;Ve=!1,je=null,ze||(ze=!0,Te=c)}}(r,t,void 0,e),e.currentTarget=null}function zr(e,t){t=0!=(4&t);for(var n=0;n<e.length;n++){var r=e[n],a=r.event;r=r.listeners;e:{var o=void 0;if(t)for(var i=r.length-1;0<=i;i--){var l=r[i],s=l.instance,u=l.currentTarget;if(l=l.listener,s!==o&&a.isPropagationStopped())break e;jr(a,l,u),o=s}else for(i=0;i<r.length;i++){if(s=(l=r[i]).instance,u=l.currentTarget,l=l.listener,s!==o&&a.isPropagationStopped())break e;jr(a,l,u),o=s}}}if(ze)throw e=Te,ze=!1,Te=null,e}function Tr(e,t){var n=t[ma];void 0===n&&(n=t[ma]=new Set);var r=e+"__bubble";n.has(r)||(Ur(t,e,2,!1),n.add(r))}function Hr(e,t,n){var r=0;t&&(r|=4),Ur(n,e,r,t)}var Dr="_reactListening"+Math.random().toString(36).slice(2);function Br(e){if(!e[Dr]){e[Dr]=!0,i.forEach((function(t){"selectionchange"!==t&&(Vr.has(t)||Hr(t,!1,e),Hr(t,!0,e))}));var t=9===e.nodeType?e:e.ownerDocument;null===t||t[Dr]||(t[Dr]=!0,Hr("selectionchange",!1,t))}}function Ur(e,t,n,r){switch(Qt(t)){case 1:var a=Wt;break;case 4:a=Gt;break;default:a=Kt}n=a.bind(null,t,n,e),a=void 0,!Ie||"touchstart"!==t&&"touchmove"!==t&&"wheel"!==t||(a=!0),r?void 0!==a?e.addEventListener(t,n,{capture:!0,passive:a}):e.addEventListener(t,n,!0):void 0!==a?e.addEventListener(t,n,{passive:a}):e.addEventListener(t,n,!1)}function Zr(e,t,n,r,a){var o=r;if(0==(1&t)&&0==(2&t)&&null!==r)e:for(;;){if(null===r)return;var i=r.tag;if(3===i||4===i){var l=r.stateNode.containerInfo;if(l===a||8===l.nodeType&&l.parentNode===a)break;if(4===i)for(i=r.return;null!==i;){var s=i.tag;if((3===s||4===s)&&((s=i.stateNode.containerInfo)===a||8===s.nodeType&&s.parentNode===a))return;i=i.return}for(;null!==l;){if(null===(i=ba(l)))return;if(5===(s=i.tag)||6===s){r=o=i;continue e}l=l.parentNode}}r=r.return}Me((function(){var r=o,a=ke(n),i=[];e:{var l=Nr.get(e);if(void 0!==l){var s=cn,u=e;switch(e){case"keypress":if(0===tn(n))break e;case"keydown":case"keyup":s=Ln;break;case"focusin":u="focus",s=gn;break;case"focusout":u="blur",s=gn;break;case"beforeblur":case"afterblur":s=gn;break;case"click":if(2===n.button)break e;case"auxclick":case"dblclick":case"mousedown":case"mousemove":case"mouseup":case"mouseout":case"mouseover":case"contextmenu":s=hn;break;case"drag":case"dragend":case"dragenter":case"dragexit":case"dragleave":case"dragover":case"dragstart":case"drop":s=mn;break;case"touchcancel":case"touchend":case"touchmove":case"touchstart":s=Pn;break;case Or:case Lr:case _r:s=vn;break;case Pr:s=Nn;break;case"scroll":s=fn;break;case"wheel":s=An;break;case"copy":case"cut":case"paste":s=yn;break;case"gotpointercapture":case"lostpointercapture":case"pointercancel":case"pointerdown":case"pointermove":case"pointerout":case"pointerover":case"pointerup":s=_n}var c=0!=(4&t),d=!c&&"scroll"===e,f=c?null!==l?l+"Capture":null:l;c=[];for(var p,h=r;null!==h;){var m=(p=h).stateNode;if(5===p.tag&&null!==m&&(p=m,null!==f&&(null!=(m=Ae(h,f))&&c.push(Wr(h,m,p)))),d)break;h=h.return}0<c.length&&(l=new s(l,u,null,n,a),i.push({event:l,listeners:c}))}}if(0==(7&t)){if(s="mouseout"===e||"pointerout"===e,(!(l="mouseover"===e||"pointerover"===e)||n===Ce||!(u=n.relatedTarget||n.fromElement)||!ba(u)&&!u[ha])&&(s||l)&&(l=a.window===a?a:(l=a.ownerDocument)?l.defaultView||l.parentWindow:window,s?(s=r,null!==(u=(u=n.relatedTarget||n.toElement)?ba(u):null)&&(u!==(d=Be(u))||5!==u.tag&&6!==u.tag)&&(u=null)):(s=null,u=r),s!==u)){if(c=hn,m="onMouseLeave",f="onMouseEnter",h="mouse","pointerout"!==e&&"pointerover"!==e||(c=_n,m="onPointerLeave",f="onPointerEnter",h="pointer"),d=null==s?l:Ca(s),p=null==u?l:Ca(u),(l=new c(m,h+"leave",s,n,a)).target=d,l.relatedTarget=p,m=null,ba(a)===r&&((c=new c(f,h+"enter",u,n,a)).target=p,c.relatedTarget=d,m=c),d=m,s&&u)e:{for(f=u,h=0,p=c=s;p;p=Kr(p))h++;for(p=0,m=f;m;m=Kr(m))p++;for(;0<h-p;)c=Kr(c),h--;for(;0<p-h;)f=Kr(f),p--;for(;h--;){if(c===f||null!==f&&c===f.alternate)break e;c=Kr(c),f=Kr(f)}c=null}else c=null;null!==s&&$r(i,l,s,c,!1),null!==u&&null!==d&&$r(i,d,u,c,!0)}if("select"===(s=(l=r?Ca(r):window).nodeName&&l.nodeName.toLowerCase())||"input"===s&&"file"===l.type)var g=Qn;else if(Zn(l))if(qn)g=ir;else{g=ar;var v=rr}else(s=l.nodeName)&&"input"===s.toLowerCase()&&("checkbox"===l.type||"radio"===l.type)&&(g=or);switch(g&&(g=g(e,r))?Wn(i,g,n,a):(v&&v(e,l,r),"focusout"===e&&(v=l._wrapperState)&&v.controlled&&"number"===l.type&&ee(l,"number",l.value)),v=r?Ca(r):window,e){case"focusin":(Zn(v)||"true"===v.contentEditable)&&(gr=v,vr=r,br=null);break;case"focusout":br=vr=gr=null;break;case"mousedown":yr=!0;break;case"contextmenu":case"mouseup":case"dragend":yr=!1,Cr(i,n,a);break;case"selectionchange":if(mr)break;case"keydown":case"keyup":Cr(i,n,a)}var b;if(Fn)e:{switch(e){case"compositionstart":var y="onCompositionStart";break e;case"compositionend":y="onCompositionEnd";break e;case"compositionupdate":y="onCompositionUpdate";break e}y=void 0}else Bn?Hn(e,n)&&(y="onCompositionEnd"):"keydown"===e&&229===n.keyCode&&(y="onCompositionStart");y&&(jn&&"ko"!==n.locale&&(Bn||"onCompositionStart"!==y?"onCompositionEnd"===y&&Bn&&(b=en()):(Yt="value"in(qt=a)?qt.value:qt.textContent,Bn=!0)),0<(v=Gr(r,y)).length&&(y=new Cn(y,e,null,n,a),i.push({event:y,listeners:v}),b?y.data=b:null!==(b=Dn(n))&&(y.data=b))),(b=Vn?function(e,t){switch(e){case"compositionend":return Dn(t);case"keypress":return 32!==t.which?null:(Tn=!0,zn);case"textInput":return(e=t.data)===zn&&Tn?null:e;default:return null}}(e,n):function(e,t){if(Bn)return"compositionend"===e||!Fn&&Hn(e,t)?(e=en(),Xt=Yt=qt=null,Bn=!1,e):null;switch(e){case"paste":default:return null;case"keypress":if(!(t.ctrlKey||t.altKey||t.metaKey)||t.ctrlKey&&t.altKey){if(t.char&&1<t.char.length)return t.char;if(t.which)return String.fromCharCode(t.which)}return null;case"compositionend":return jn&&"ko"!==t.locale?null:t.data}}(e,n))&&(0<(r=Gr(r,"onBeforeInput")).length&&(a=new Cn("onBeforeInput","beforeinput",null,n,a),i.push({event:a,listeners:r}),a.data=b))}zr(i,t)}))}function Wr(e,t,n){return{instance:e,listener:t,currentTarget:n}}function Gr(e,t){for(var n=t+"Capture",r=[];null!==e;){var a=e,o=a.stateNode;5===a.tag&&null!==o&&(a=o,null!=(o=Ae(e,n))&&r.unshift(Wr(e,o,a)),null!=(o=Ae(e,t))&&r.push(Wr(e,o,a))),e=e.return}return r}function Kr(e){if(null===e)return null;do{e=e.return}while(e&&5!==e.tag);return e||null}function $r(e,t,n,r,a){for(var o=t._reactName,i=[];null!==n&&n!==r;){var l=n,s=l.alternate,u=l.stateNode;if(null!==s&&s===r)break;5===l.tag&&null!==u&&(l=u,a?null!=(s=Ae(n,o))&&i.unshift(Wr(n,s,l)):a||null!=(s=Ae(n,o))&&i.push(Wr(n,s,l))),n=n.return}0!==i.length&&e.push({event:t,listeners:i})}var Jr=/\r\n?/g,Qr=/\u0000|\uFFFD/g;function qr(e){return("string"==typeof e?e:""+e).replace(Jr,"\n").replace(Qr,"")}function Yr(e,t,n){if(t=qr(t),qr(e)!==t&&n)throw Error(o(425))}function Xr(){}var ea=null,ta=null;function na(e,t){return"textarea"===e||"noscript"===e||"string"==typeof t.children||"number"==typeof t.children||"object"==typeof t.dangerouslySetInnerHTML&&null!==t.dangerouslySetInnerHTML&&null!=t.dangerouslySetInnerHTML.__html}var ra="function"==typeof setTimeout?setTimeout:void 0,aa="function"==typeof clearTimeout?clearTimeout:void 0,oa="function"==typeof Promise?Promise:void 0,ia="function"==typeof queueMicrotask?queueMicrotask:void 0!==oa?function(e){return oa.resolve(null).then(e).catch(la)}:ra;function la(e){setTimeout((function(){throw e}))}function sa(e,t){var n=t,r=0;do{var a=n.nextSibling;if(e.removeChild(n),a&&8===a.nodeType)if("/$"===(n=a.data)){if(0===r)return e.removeChild(a),void Bt(t);r--}else"$"!==n&&"$?"!==n&&"$!"!==n||r++;n=a}while(n);Bt(t)}function ua(e){for(;null!=e;e=e.nextSibling){var t=e.nodeType;if(1===t||3===t)break;if(8===t){if("$"===(t=e.data)||"$!"===t||"$?"===t)break;if("/$"===t)return null}}return e}function ca(e){e=e.previousSibling;for(var t=0;e;){if(8===e.nodeType){var n=e.data;if("$"===n||"$!"===n||"$?"===n){if(0===t)return e;t--}else"/$"===n&&t++}e=e.previousSibling}return null}var da=Math.random().toString(36).slice(2),fa="__reactFiber$"+da,pa="__reactProps$"+da,ha="__reactContainer$"+da,ma="__reactEvents$"+da,ga="__reactListeners$"+da,va="__reactHandles$"+da;function ba(e){var t=e[fa];if(t)return t;for(var n=e.parentNode;n;){if(t=n[ha]||n[fa]){if(n=t.alternate,null!==t.child||null!==n&&null!==n.child)for(e=ca(e);null!==e;){if(n=e[fa])return n;e=ca(e)}return t}n=(e=n).parentNode}return null}function ya(e){return!(e=e[fa]||e[ha])||5!==e.tag&&6!==e.tag&&13!==e.tag&&3!==e.tag?null:e}function Ca(e){if(5===e.tag||6===e.tag)return e.stateNode;throw Error(o(33))}function ka(e){return e[pa]||null}var wa=[],Ea=-1;function xa(e){return{current:e}}function Sa(e){0>Ea||(e.current=wa[Ea],wa[Ea]=null,Ea--)}function Oa(e,t){Ea++,wa[Ea]=e.current,e.current=t}var La={},_a=xa(La),Pa=xa(!1),Na=La;function Ma(e,t){var n=e.type.contextTypes;if(!n)return La;var r=e.stateNode;if(r&&r.__reactInternalMemoizedUnmaskedChildContext===t)return r.__reactInternalMemoizedMaskedChildContext;var a,o={};for(a in n)o[a]=t[a];return r&&((e=e.stateNode).__reactInternalMemoizedUnmaskedChildContext=t,e.__reactInternalMemoizedMaskedChildContext=o),o}function Aa(e){return null!=(e=e.childContextTypes)}function Ia(){Sa(Pa),Sa(_a)}function Fa(e,t,n){if(_a.current!==La)throw Error(o(168));Oa(_a,t),Oa(Pa,n)}function Ra(e,t,n){var r=e.stateNode;if(t=t.childContextTypes,"function"!=typeof r.getChildContext)return n;for(var a in r=r.getChildContext())if(!(a in t))throw Error(o(108,U(e)||"Unknown",a));return j({},n,r)}function Va(e){return e=(e=e.stateNode)&&e.__reactInternalMemoizedMergedChildContext||La,Na=_a.current,Oa(_a,e),Oa(Pa,Pa.current),!0}function ja(e,t,n){var r=e.stateNode;if(!r)throw Error(o(169));n?(e=Ra(e,t,Na),r.__reactInternalMemoizedMergedChildContext=e,Sa(Pa),Sa(_a),Oa(_a,e)):Sa(Pa),Oa(Pa,n)}var za=null,Ta=!1,Ha=!1;function Da(e){null===za?za=[e]:za.push(e)}function Ba(){if(!Ha&&null!==za){Ha=!0;var e=0,t=yt;try{var n=za;for(yt=1;e<n.length;e++){var r=n[e];do{r=r(!0)}while(null!==r)}za=null,Ta=!1}catch(t){throw null!==za&&(za=za.slice(e+1)),Ke(Xe,Ba),t}finally{yt=t,Ha=!1}}return null}var Ua=[],Za=0,Wa=null,Ga=0,Ka=[],$a=0,Ja=null,Qa=1,qa="";function Ya(e,t){Ua[Za++]=Ga,Ua[Za++]=Wa,Wa=e,Ga=t}function Xa(e,t,n){Ka[$a++]=Qa,Ka[$a++]=qa,Ka[$a++]=Ja,Ja=e;var r=Qa;e=qa;var a=32-it(r)-1;r&=~(1<<a),n+=1;var o=32-it(t)+a;if(30<o){var i=a-a%5;o=(r&(1<<i)-1).toString(32),r>>=i,a-=i,Qa=1<<32-it(t)+a|n<<a|r,qa=o+e}else Qa=1<<o|n<<a|r,qa=e}function eo(e){null!==e.return&&(Ya(e,1),Xa(e,1,0))}function to(e){for(;e===Wa;)Wa=Ua[--Za],Ua[Za]=null,Ga=Ua[--Za],Ua[Za]=null;for(;e===Ja;)Ja=Ka[--$a],Ka[$a]=null,qa=Ka[--$a],Ka[$a]=null,Qa=Ka[--$a],Ka[$a]=null}var no=null,ro=null,ao=!1,oo=null;function io(e,t){var n=Au(5,null,null,0);n.elementType="DELETED",n.stateNode=t,n.return=e,null===(t=e.deletions)?(e.deletions=[n],e.flags|=16):t.push(n)}function lo(e,t){switch(e.tag){case 5:var n=e.type;return null!==(t=1!==t.nodeType||n.toLowerCase()!==t.nodeName.toLowerCase()?null:t)&&(e.stateNode=t,no=e,ro=ua(t.firstChild),!0);case 6:return null!==(t=""===e.pendingProps||3!==t.nodeType?null:t)&&(e.stateNode=t,no=e,ro=null,!0);case 13:return null!==(t=8!==t.nodeType?null:t)&&(n=null!==Ja?{id:Qa,overflow:qa}:null,e.memoizedState={dehydrated:t,treeContext:n,retryLane:1073741824},(n=Au(18,null,null,0)).stateNode=t,n.return=e,e.child=n,no=e,ro=null,!0);default:return!1}}function so(e){return 0!=(1&e.mode)&&0==(128&e.flags)}function uo(e){if(ao){var t=ro;if(t){var n=t;if(!lo(e,t)){if(so(e))throw Error(o(418));t=ua(n.nextSibling);var r=no;t&&lo(e,t)?io(r,n):(e.flags=-4097&e.flags|2,ao=!1,no=e)}}else{if(so(e))throw Error(o(418));e.flags=-4097&e.flags|2,ao=!1,no=e}}}function co(e){for(e=e.return;null!==e&&5!==e.tag&&3!==e.tag&&13!==e.tag;)e=e.return;no=e}function fo(e){if(e!==no)return!1;if(!ao)return co(e),ao=!0,!1;var t;if((t=3!==e.tag)&&!(t=5!==e.tag)&&(t="head"!==(t=e.type)&&"body"!==t&&!na(e.type,e.memoizedProps)),t&&(t=ro)){if(so(e))throw po(),Error(o(418));for(;t;)io(e,t),t=ua(t.nextSibling)}if(co(e),13===e.tag){if(!(e=null!==(e=e.memoizedState)?e.dehydrated:null))throw Error(o(317));e:{for(e=e.nextSibling,t=0;e;){if(8===e.nodeType){var n=e.data;if("/$"===n){if(0===t){ro=ua(e.nextSibling);break e}t--}else"$"!==n&&"$!"!==n&&"$?"!==n||t++}e=e.nextSibling}ro=null}}else ro=no?ua(e.stateNode.nextSibling):null;return!0}function po(){for(var e=ro;e;)e=ua(e.nextSibling)}function ho(){ro=no=null,ao=!1}function mo(e){null===oo?oo=[e]:oo.push(e)}var go=C.ReactCurrentBatchConfig;function vo(e,t){if(e&&e.defaultProps){for(var n in t=j({},t),e=e.defaultProps)void 0===t[n]&&(t[n]=e[n]);return t}return t}var bo=xa(null),yo=null,Co=null,ko=null;function wo(){ko=Co=yo=null}function Eo(e){var t=bo.current;Sa(bo),e._currentValue=t}function xo(e,t,n){for(;null!==e;){var r=e.alternate;if((e.childLanes&t)!==t?(e.childLanes|=t,null!==r&&(r.childLanes|=t)):null!==r&&(r.childLanes&t)!==t&&(r.childLanes|=t),e===n)break;e=e.return}}function So(e,t){yo=e,ko=Co=null,null!==(e=e.dependencies)&&null!==e.firstContext&&(0!=(e.lanes&t)&&(Cl=!0),e.firstContext=null)}function Oo(e){var t=e._currentValue;if(ko!==e)if(e={context:e,memoizedValue:t,next:null},null===Co){if(null===yo)throw Error(o(308));Co=e,yo.dependencies={lanes:0,firstContext:e}}else Co=Co.next=e;return t}var Lo=null;function _o(e){null===Lo?Lo=[e]:Lo.push(e)}function Po(e,t,n,r){var a=t.interleaved;return null===a?(n.next=n,_o(t)):(n.next=a.next,a.next=n),t.interleaved=n,No(e,r)}function No(e,t){e.lanes|=t;var n=e.alternate;for(null!==n&&(n.lanes|=t),n=e,e=e.return;null!==e;)e.childLanes|=t,null!==(n=e.alternate)&&(n.childLanes|=t),n=e,e=e.return;return 3===n.tag?n.stateNode:null}var Mo=!1;function Ao(e){e.updateQueue={baseState:e.memoizedState,firstBaseUpdate:null,lastBaseUpdate:null,shared:{pending:null,interleaved:null,lanes:0},effects:null}}function Io(e,t){e=e.updateQueue,t.updateQueue===e&&(t.updateQueue={baseState:e.baseState,firstBaseUpdate:e.firstBaseUpdate,lastBaseUpdate:e.lastBaseUpdate,shared:e.shared,effects:e.effects})}function Fo(e,t){return{eventTime:e,lane:t,tag:0,payload:null,callback:null,next:null}}function Ro(e,t,n){var r=e.updateQueue;if(null===r)return null;if(r=r.shared,0!=(2&Ps)){var a=r.pending;return null===a?t.next=t:(t.next=a.next,a.next=t),r.pending=t,No(e,n)}return null===(a=r.interleaved)?(t.next=t,_o(r)):(t.next=a.next,a.next=t),r.interleaved=t,No(e,n)}function Vo(e,t,n){if(null!==(t=t.updateQueue)&&(t=t.shared,0!=(4194240&n))){var r=t.lanes;n|=r&=e.pendingLanes,t.lanes=n,bt(e,n)}}function jo(e,t){var n=e.updateQueue,r=e.alternate;if(null!==r&&n===(r=r.updateQueue)){var a=null,o=null;if(null!==(n=n.firstBaseUpdate)){do{var i={eventTime:n.eventTime,lane:n.lane,tag:n.tag,payload:n.payload,callback:n.callback,next:null};null===o?a=o=i:o=o.next=i,n=n.next}while(null!==n);null===o?a=o=t:o=o.next=t}else a=o=t;return n={baseState:r.baseState,firstBaseUpdate:a,lastBaseUpdate:o,shared:r.shared,effects:r.effects},void(e.updateQueue=n)}null===(e=n.lastBaseUpdate)?n.firstBaseUpdate=t:e.next=t,n.lastBaseUpdate=t}function zo(e,t,n,r){var a=e.updateQueue;Mo=!1;var o=a.firstBaseUpdate,i=a.lastBaseUpdate,l=a.shared.pending;if(null!==l){a.shared.pending=null;var s=l,u=s.next;s.next=null,null===i?o=u:i.next=u,i=s;var c=e.alternate;null!==c&&((l=(c=c.updateQueue).lastBaseUpdate)!==i&&(null===l?c.firstBaseUpdate=u:l.next=u,c.lastBaseUpdate=s))}if(null!==o){var d=a.baseState;for(i=0,c=u=s=null,l=o;;){var f=l.lane,p=l.eventTime;if((r&f)===f){null!==c&&(c=c.next={eventTime:p,lane:0,tag:l.tag,payload:l.payload,callback:l.callback,next:null});e:{var h=e,m=l;switch(f=t,p=n,m.tag){case 1:if("function"==typeof(h=m.payload)){d=h.call(p,d,f);break e}d=h;break e;case 3:h.flags=-65537&h.flags|128;case 0:if(null==(f="function"==typeof(h=m.payload)?h.call(p,d,f):h))break e;d=j({},d,f);break e;case 2:Mo=!0}}null!==l.callback&&0!==l.lane&&(e.flags|=64,null===(f=a.effects)?a.effects=[l]:f.push(l))}else p={eventTime:p,lane:f,tag:l.tag,payload:l.payload,callback:l.callback,next:null},null===c?(u=c=p,s=d):c=c.next=p,i|=f;if(null===(l=l.next)){if(null===(l=a.shared.pending))break;l=(f=l).next,f.next=null,a.lastBaseUpdate=f,a.shared.pending=null}}if(null===c&&(s=d),a.baseState=s,a.firstBaseUpdate=u,a.lastBaseUpdate=c,null!==(t=a.shared.interleaved)){a=t;do{i|=a.lane,a=a.next}while(a!==t)}else null===o&&(a.shared.lanes=0);js|=i,e.lanes=i,e.memoizedState=d}}function To(e,t,n){if(e=t.effects,t.effects=null,null!==e)for(t=0;t<e.length;t++){var r=e[t],a=r.callback;if(null!==a){if(r.callback=null,r=n,"function"!=typeof a)throw Error(o(191,a));a.call(r)}}}var Ho=(new r.Component).refs;function Do(e,t,n,r){n=null==(n=n(r,t=e.memoizedState))?t:j({},t,n),e.memoizedState=n,0===e.lanes&&(e.updateQueue.baseState=n)}var Bo={isMounted:function(e){return!!(e=e._reactInternals)&&Be(e)===e},enqueueSetState:function(e,t,n){e=e._reactInternals;var r=tu(),a=nu(e),o=Fo(r,a);o.payload=t,null!=n&&(o.callback=n),null!==(t=Ro(e,o,a))&&(ru(t,e,a,r),Vo(t,e,a))},enqueueReplaceState:function(e,t,n){e=e._reactInternals;var r=tu(),a=nu(e),o=Fo(r,a);o.tag=1,o.payload=t,null!=n&&(o.callback=n),null!==(t=Ro(e,o,a))&&(ru(t,e,a,r),Vo(t,e,a))},enqueueForceUpdate:function(e,t){e=e._reactInternals;var n=tu(),r=nu(e),a=Fo(n,r);a.tag=2,null!=t&&(a.callback=t),null!==(t=Ro(e,a,r))&&(ru(t,e,r,n),Vo(t,e,r))}};function Uo(e,t,n,r,a,o,i){return"function"==typeof(e=e.stateNode).shouldComponentUpdate?e.shouldComponentUpdate(r,o,i):!t.prototype||!t.prototype.isPureReactComponent||(!sr(n,r)||!sr(a,o))}function Zo(e,t,n){var r=!1,a=La,o=t.contextType;return"object"==typeof o&&null!==o?o=Oo(o):(a=Aa(t)?Na:_a.current,o=(r=null!=(r=t.contextTypes))?Ma(e,a):La),t=new t(n,o),e.memoizedState=null!==t.state&&void 0!==t.state?t.state:null,t.updater=Bo,e.stateNode=t,t._reactInternals=e,r&&((e=e.stateNode).__reactInternalMemoizedUnmaskedChildContext=a,e.__reactInternalMemoizedMaskedChildContext=o),t}function Wo(e,t,n,r){e=t.state,"function"==typeof t.componentWillReceiveProps&&t.componentWillReceiveProps(n,r),"function"==typeof t.UNSAFE_componentWillReceiveProps&&t.UNSAFE_componentWillReceiveProps(n,r),t.state!==e&&Bo.enqueueReplaceState(t,t.state,null)}function Go(e,t,n,r){var a=e.stateNode;a.props=n,a.state=e.memoizedState,a.refs=Ho,Ao(e);var o=t.contextType;"object"==typeof o&&null!==o?a.context=Oo(o):(o=Aa(t)?Na:_a.current,a.context=Ma(e,o)),a.state=e.memoizedState,"function"==typeof(o=t.getDerivedStateFromProps)&&(Do(e,t,o,n),a.state=e.memoizedState),"function"==typeof t.getDerivedStateFromProps||"function"==typeof a.getSnapshotBeforeUpdate||"function"!=typeof a.UNSAFE_componentWillMount&&"function"!=typeof a.componentWillMount||(t=a.state,"function"==typeof a.componentWillMount&&a.componentWillMount(),"function"==typeof a.UNSAFE_componentWillMount&&a.UNSAFE_componentWillMount(),t!==a.state&&Bo.enqueueReplaceState(a,a.state,null),zo(e,n,a,r),a.state=e.memoizedState),"function"==typeof a.componentDidMount&&(e.flags|=4194308)}function Ko(e,t,n){if(null!==(e=n.ref)&&"function"!=typeof e&&"object"!=typeof e){if(n._owner){if(n=n._owner){if(1!==n.tag)throw Error(o(309));var r=n.stateNode}if(!r)throw Error(o(147,e));var a=r,i=""+e;return null!==t&&null!==t.ref&&"function"==typeof t.ref&&t.ref._stringRef===i?t.ref:(t=function(e){var t=a.refs;t===Ho&&(t=a.refs={}),null===e?delete t[i]:t[i]=e},t._stringRef=i,t)}if("string"!=typeof e)throw Error(o(284));if(!n._owner)throw Error(o(290,e))}return e}function $o(e,t){throw e=Object.prototype.toString.call(t),Error(o(31,"[object Object]"===e?"object with keys {"+Object.keys(t).join(", ")+"}":e))}function Jo(e){return(0,e._init)(e._payload)}function Qo(e){function t(t,n){if(e){var r=t.deletions;null===r?(t.deletions=[n],t.flags|=16):r.push(n)}}function n(n,r){if(!e)return null;for(;null!==r;)t(n,r),r=r.sibling;return null}function r(e,t){for(e=new Map;null!==t;)null!==t.key?e.set(t.key,t):e.set(t.index,t),t=t.sibling;return e}function a(e,t){return(e=Fu(e,t)).index=0,e.sibling=null,e}function i(t,n,r){return t.index=r,e?null!==(r=t.alternate)?(r=r.index)<n?(t.flags|=2,n):r:(t.flags|=2,n):(t.flags|=1048576,n)}function l(t){return e&&null===t.alternate&&(t.flags|=2),t}function s(e,t,n,r){return null===t||6!==t.tag?((t=zu(n,e.mode,r)).return=e,t):((t=a(t,n)).return=e,t)}function u(e,t,n,r){var o=n.type;return o===E?d(e,t,n.props.children,r,n.key):null!==t&&(t.elementType===o||"object"==typeof o&&null!==o&&o.$$typeof===A&&Jo(o)===t.type)?((r=a(t,n.props)).ref=Ko(e,t,n),r.return=e,r):((r=Ru(n.type,n.key,n.props,null,e.mode,r)).ref=Ko(e,t,n),r.return=e,r)}function c(e,t,n,r){return null===t||4!==t.tag||t.stateNode.containerInfo!==n.containerInfo||t.stateNode.implementation!==n.implementation?((t=Tu(n,e.mode,r)).return=e,t):((t=a(t,n.children||[])).return=e,t)}function d(e,t,n,r,o){return null===t||7!==t.tag?((t=Vu(n,e.mode,r,o)).return=e,t):((t=a(t,n)).return=e,t)}function f(e,t,n){if("string"==typeof t&&""!==t||"number"==typeof t)return(t=zu(""+t,e.mode,n)).return=e,t;if("object"==typeof t&&null!==t){switch(t.$$typeof){case k:return(n=Ru(t.type,t.key,t.props,null,e.mode,n)).ref=Ko(e,null,t),n.return=e,n;case w:return(t=Tu(t,e.mode,n)).return=e,t;case A:return f(e,(0,t._init)(t._payload),n)}if(te(t)||R(t))return(t=Vu(t,e.mode,n,null)).return=e,t;$o(e,t)}return null}function p(e,t,n,r){var a=null!==t?t.key:null;if("string"==typeof n&&""!==n||"number"==typeof n)return null!==a?null:s(e,t,""+n,r);if("object"==typeof n&&null!==n){switch(n.$$typeof){case k:return n.key===a?u(e,t,n,r):null;case w:return n.key===a?c(e,t,n,r):null;case A:return p(e,t,(a=n._init)(n._payload),r)}if(te(n)||R(n))return null!==a?null:d(e,t,n,r,null);$o(e,n)}return null}function h(e,t,n,r,a){if("string"==typeof r&&""!==r||"number"==typeof r)return s(t,e=e.get(n)||null,""+r,a);if("object"==typeof r&&null!==r){switch(r.$$typeof){case k:return u(t,e=e.get(null===r.key?n:r.key)||null,r,a);case w:return c(t,e=e.get(null===r.key?n:r.key)||null,r,a);case A:return h(e,t,n,(0,r._init)(r._payload),a)}if(te(r)||R(r))return d(t,e=e.get(n)||null,r,a,null);$o(t,r)}return null}function m(a,o,l,s){for(var u=null,c=null,d=o,m=o=0,g=null;null!==d&&m<l.length;m++){d.index>m?(g=d,d=null):g=d.sibling;var v=p(a,d,l[m],s);if(null===v){null===d&&(d=g);break}e&&d&&null===v.alternate&&t(a,d),o=i(v,o,m),null===c?u=v:c.sibling=v,c=v,d=g}if(m===l.length)return n(a,d),ao&&Ya(a,m),u;if(null===d){for(;m<l.length;m++)null!==(d=f(a,l[m],s))&&(o=i(d,o,m),null===c?u=d:c.sibling=d,c=d);return ao&&Ya(a,m),u}for(d=r(a,d);m<l.length;m++)null!==(g=h(d,a,m,l[m],s))&&(e&&null!==g.alternate&&d.delete(null===g.key?m:g.key),o=i(g,o,m),null===c?u=g:c.sibling=g,c=g);return e&&d.forEach((function(e){return t(a,e)})),ao&&Ya(a,m),u}function g(a,l,s,u){var c=R(s);if("function"!=typeof c)throw Error(o(150));if(null==(s=c.call(s)))throw Error(o(151));for(var d=c=null,m=l,g=l=0,v=null,b=s.next();null!==m&&!b.done;g++,b=s.next()){m.index>g?(v=m,m=null):v=m.sibling;var y=p(a,m,b.value,u);if(null===y){null===m&&(m=v);break}e&&m&&null===y.alternate&&t(a,m),l=i(y,l,g),null===d?c=y:d.sibling=y,d=y,m=v}if(b.done)return n(a,m),ao&&Ya(a,g),c;if(null===m){for(;!b.done;g++,b=s.next())null!==(b=f(a,b.value,u))&&(l=i(b,l,g),null===d?c=b:d.sibling=b,d=b);return ao&&Ya(a,g),c}for(m=r(a,m);!b.done;g++,b=s.next())null!==(b=h(m,a,g,b.value,u))&&(e&&null!==b.alternate&&m.delete(null===b.key?g:b.key),l=i(b,l,g),null===d?c=b:d.sibling=b,d=b);return e&&m.forEach((function(e){return t(a,e)})),ao&&Ya(a,g),c}return function e(r,o,i,s){if("object"==typeof i&&null!==i&&i.type===E&&null===i.key&&(i=i.props.children),"object"==typeof i&&null!==i){switch(i.$$typeof){case k:e:{for(var u=i.key,c=o;null!==c;){if(c.key===u){if((u=i.type)===E){if(7===c.tag){n(r,c.sibling),(o=a(c,i.props.children)).return=r,r=o;break e}}else if(c.elementType===u||"object"==typeof u&&null!==u&&u.$$typeof===A&&Jo(u)===c.type){n(r,c.sibling),(o=a(c,i.props)).ref=Ko(r,c,i),o.return=r,r=o;break e}n(r,c);break}t(r,c),c=c.sibling}i.type===E?((o=Vu(i.props.children,r.mode,s,i.key)).return=r,r=o):((s=Ru(i.type,i.key,i.props,null,r.mode,s)).ref=Ko(r,o,i),s.return=r,r=s)}return l(r);case w:e:{for(c=i.key;null!==o;){if(o.key===c){if(4===o.tag&&o.stateNode.containerInfo===i.containerInfo&&o.stateNode.implementation===i.implementation){n(r,o.sibling),(o=a(o,i.children||[])).return=r,r=o;break e}n(r,o);break}t(r,o),o=o.sibling}(o=Tu(i,r.mode,s)).return=r,r=o}return l(r);case A:return e(r,o,(c=i._init)(i._payload),s)}if(te(i))return m(r,o,i,s);if(R(i))return g(r,o,i,s);$o(r,i)}return"string"==typeof i&&""!==i||"number"==typeof i?(i=""+i,null!==o&&6===o.tag?(n(r,o.sibling),(o=a(o,i)).return=r,r=o):(n(r,o),(o=zu(i,r.mode,s)).return=r,r=o),l(r)):n(r,o)}}var qo=Qo(!0),Yo=Qo(!1),Xo={},ei=xa(Xo),ti=xa(Xo),ni=xa(Xo);function ri(e){if(e===Xo)throw Error(o(174));return e}function ai(e,t){switch(Oa(ni,t),Oa(ti,e),Oa(ei,Xo),e=t.nodeType){case 9:case 11:t=(t=t.documentElement)?t.namespaceURI:se(null,"");break;default:t=se(t=(e=8===e?t.parentNode:t).namespaceURI||null,e=e.tagName)}Sa(ei),Oa(ei,t)}function oi(){Sa(ei),Sa(ti),Sa(ni)}function ii(e){ri(ni.current);var t=ri(ei.current),n=se(t,e.type);t!==n&&(Oa(ti,e),Oa(ei,n))}function li(e){ti.current===e&&(Sa(ei),Sa(ti))}var si=xa(0);function ui(e){for(var t=e;null!==t;){if(13===t.tag){var n=t.memoizedState;if(null!==n&&(null===(n=n.dehydrated)||"$?"===n.data||"$!"===n.data))return t}else if(19===t.tag&&void 0!==t.memoizedProps.revealOrder){if(0!=(128&t.flags))return t}else if(null!==t.child){t.child.return=t,t=t.child;continue}if(t===e)break;for(;null===t.sibling;){if(null===t.return||t.return===e)return null;t=t.return}t.sibling.return=t.return,t=t.sibling}return null}var ci=[];function di(){for(var e=0;e<ci.length;e++)ci[e]._workInProgressVersionPrimary=null;ci.length=0}var fi=C.ReactCurrentDispatcher,pi=C.ReactCurrentBatchConfig,hi=0,mi=null,gi=null,vi=null,bi=!1,yi=!1,Ci=0,ki=0;function wi(){throw Error(o(321))}function Ei(e,t){if(null===t)return!1;for(var n=0;n<t.length&&n<e.length;n++)if(!lr(e[n],t[n]))return!1;return!0}function xi(e,t,n,r,a,i){if(hi=i,mi=t,t.memoizedState=null,t.updateQueue=null,t.lanes=0,fi.current=null===e||null===e.memoizedState?ll:sl,e=n(r,a),yi){i=0;do{if(yi=!1,Ci=0,25<=i)throw Error(o(301));i+=1,vi=gi=null,t.updateQueue=null,fi.current=ul,e=n(r,a)}while(yi)}if(fi.current=il,t=null!==gi&&null!==gi.next,hi=0,vi=gi=mi=null,bi=!1,t)throw Error(o(300));return e}function Si(){var e=0!==Ci;return Ci=0,e}function Oi(){var e={memoizedState:null,baseState:null,baseQueue:null,queue:null,next:null};return null===vi?mi.memoizedState=vi=e:vi=vi.next=e,vi}function Li(){if(null===gi){var e=mi.alternate;e=null!==e?e.memoizedState:null}else e=gi.next;var t=null===vi?mi.memoizedState:vi.next;if(null!==t)vi=t,gi=e;else{if(null===e)throw Error(o(310));e={memoizedState:(gi=e).memoizedState,baseState:gi.baseState,baseQueue:gi.baseQueue,queue:gi.queue,next:null},null===vi?mi.memoizedState=vi=e:vi=vi.next=e}return vi}function _i(e,t){return"function"==typeof t?t(e):t}function Pi(e){var t=Li(),n=t.queue;if(null===n)throw Error(o(311));n.lastRenderedReducer=e;var r=gi,a=r.baseQueue,i=n.pending;if(null!==i){if(null!==a){var l=a.next;a.next=i.next,i.next=l}r.baseQueue=a=i,n.pending=null}if(null!==a){i=a.next,r=r.baseState;var s=l=null,u=null,c=i;do{var d=c.lane;if((hi&d)===d)null!==u&&(u=u.next={lane:0,action:c.action,hasEagerState:c.hasEagerState,eagerState:c.eagerState,next:null}),r=c.hasEagerState?c.eagerState:e(r,c.action);else{var f={lane:d,action:c.action,hasEagerState:c.hasEagerState,eagerState:c.eagerState,next:null};null===u?(s=u=f,l=r):u=u.next=f,mi.lanes|=d,js|=d}c=c.next}while(null!==c&&c!==i);null===u?l=r:u.next=s,lr(r,t.memoizedState)||(Cl=!0),t.memoizedState=r,t.baseState=l,t.baseQueue=u,n.lastRenderedState=r}if(null!==(e=n.interleaved)){a=e;do{i=a.lane,mi.lanes|=i,js|=i,a=a.next}while(a!==e)}else null===a&&(n.lanes=0);return[t.memoizedState,n.dispatch]}function Ni(e){var t=Li(),n=t.queue;if(null===n)throw Error(o(311));n.lastRenderedReducer=e;var r=n.dispatch,a=n.pending,i=t.memoizedState;if(null!==a){n.pending=null;var l=a=a.next;do{i=e(i,l.action),l=l.next}while(l!==a);lr(i,t.memoizedState)||(Cl=!0),t.memoizedState=i,null===t.baseQueue&&(t.baseState=i),n.lastRenderedState=i}return[i,r]}function Mi(){}function Ai(e,t){var n=mi,r=Li(),a=t(),i=!lr(r.memoizedState,a);if(i&&(r.memoizedState=a,Cl=!0),r=r.queue,Zi(Ri.bind(null,n,r,e),[e]),r.getSnapshot!==t||i||null!==vi&&1&vi.memoizedState.tag){if(n.flags|=2048,Ti(9,Fi.bind(null,n,r,a,t),void 0,null),null===Ns)throw Error(o(349));0!=(30&hi)||Ii(n,t,a)}return a}function Ii(e,t,n){e.flags|=16384,e={getSnapshot:t,value:n},null===(t=mi.updateQueue)?(t={lastEffect:null,stores:null},mi.updateQueue=t,t.stores=[e]):null===(n=t.stores)?t.stores=[e]:n.push(e)}function Fi(e,t,n,r){t.value=n,t.getSnapshot=r,Vi(t)&&ji(e)}function Ri(e,t,n){return n((function(){Vi(t)&&ji(e)}))}function Vi(e){var t=e.getSnapshot;e=e.value;try{var n=t();return!lr(e,n)}catch(e){return!0}}function ji(e){var t=No(e,1);null!==t&&ru(t,e,1,-1)}function zi(e){var t=Oi();return"function"==typeof e&&(e=e()),t.memoizedState=t.baseState=e,e={pending:null,interleaved:null,lanes:0,dispatch:null,lastRenderedReducer:_i,lastRenderedState:e},t.queue=e,e=e.dispatch=nl.bind(null,mi,e),[t.memoizedState,e]}function Ti(e,t,n,r){return e={tag:e,create:t,destroy:n,deps:r,next:null},null===(t=mi.updateQueue)?(t={lastEffect:null,stores:null},mi.updateQueue=t,t.lastEffect=e.next=e):null===(n=t.lastEffect)?t.lastEffect=e.next=e:(r=n.next,n.next=e,e.next=r,t.lastEffect=e),e}function Hi(){return Li().memoizedState}function Di(e,t,n,r){var a=Oi();mi.flags|=e,a.memoizedState=Ti(1|t,n,void 0,void 0===r?null:r)}function Bi(e,t,n,r){var a=Li();r=void 0===r?null:r;var o=void 0;if(null!==gi){var i=gi.memoizedState;if(o=i.destroy,null!==r&&Ei(r,i.deps))return void(a.memoizedState=Ti(t,n,o,r))}mi.flags|=e,a.memoizedState=Ti(1|t,n,o,r)}function Ui(e,t){return Di(8390656,8,e,t)}function Zi(e,t){return Bi(2048,8,e,t)}function Wi(e,t){return Bi(4,2,e,t)}function Gi(e,t){return Bi(4,4,e,t)}function Ki(e,t){return"function"==typeof t?(e=e(),t(e),function(){t(null)}):null!=t?(e=e(),t.current=e,function(){t.current=null}):void 0}function $i(e,t,n){return n=null!=n?n.concat([e]):null,Bi(4,4,Ki.bind(null,t,e),n)}function Ji(){}function Qi(e,t){var n=Li();t=void 0===t?null:t;var r=n.memoizedState;return null!==r&&null!==t&&Ei(t,r[1])?r[0]:(n.memoizedState=[e,t],e)}function qi(e,t){var n=Li();t=void 0===t?null:t;var r=n.memoizedState;return null!==r&&null!==t&&Ei(t,r[1])?r[0]:(e=e(),n.memoizedState=[e,t],e)}function Yi(e,t,n){return 0==(21&hi)?(e.baseState&&(e.baseState=!1,Cl=!0),e.memoizedState=n):(lr(n,t)||(n=mt(),mi.lanes|=n,js|=n,e.baseState=!0),t)}function Xi(e,t){var n=yt;yt=0!==n&&4>n?n:4,e(!0);var r=pi.transition;pi.transition={};try{e(!1),t()}finally{yt=n,pi.transition=r}}function el(){return Li().memoizedState}function tl(e,t,n){var r=nu(e);if(n={lane:r,action:n,hasEagerState:!1,eagerState:null,next:null},rl(e))al(t,n);else if(null!==(n=Po(e,t,n,r))){ru(n,e,r,tu()),ol(n,t,r)}}function nl(e,t,n){var r=nu(e),a={lane:r,action:n,hasEagerState:!1,eagerState:null,next:null};if(rl(e))al(t,a);else{var o=e.alternate;if(0===e.lanes&&(null===o||0===o.lanes)&&null!==(o=t.lastRenderedReducer))try{var i=t.lastRenderedState,l=o(i,n);if(a.hasEagerState=!0,a.eagerState=l,lr(l,i)){var s=t.interleaved;return null===s?(a.next=a,_o(t)):(a.next=s.next,s.next=a),void(t.interleaved=a)}}catch(e){}null!==(n=Po(e,t,a,r))&&(ru(n,e,r,a=tu()),ol(n,t,r))}}function rl(e){var t=e.alternate;return e===mi||null!==t&&t===mi}function al(e,t){yi=bi=!0;var n=e.pending;null===n?t.next=t:(t.next=n.next,n.next=t),e.pending=t}function ol(e,t,n){if(0!=(4194240&n)){var r=t.lanes;n|=r&=e.pendingLanes,t.lanes=n,bt(e,n)}}var il={readContext:Oo,useCallback:wi,useContext:wi,useEffect:wi,useImperativeHandle:wi,useInsertionEffect:wi,useLayoutEffect:wi,useMemo:wi,useReducer:wi,useRef:wi,useState:wi,useDebugValue:wi,useDeferredValue:wi,useTransition:wi,useMutableSource:wi,useSyncExternalStore:wi,useId:wi,unstable_isNewReconciler:!1},ll={readContext:Oo,useCallback:function(e,t){return Oi().memoizedState=[e,void 0===t?null:t],e},useContext:Oo,useEffect:Ui,useImperativeHandle:function(e,t,n){return n=null!=n?n.concat([e]):null,Di(4194308,4,Ki.bind(null,t,e),n)},useLayoutEffect:function(e,t){return Di(4194308,4,e,t)},useInsertionEffect:function(e,t){return Di(4,2,e,t)},useMemo:function(e,t){var n=Oi();return t=void 0===t?null:t,e=e(),n.memoizedState=[e,t],e},useReducer:function(e,t,n){var r=Oi();return t=void 0!==n?n(t):t,r.memoizedState=r.baseState=t,e={pending:null,interleaved:null,lanes:0,dispatch:null,lastRenderedReducer:e,lastRenderedState:t},r.queue=e,e=e.dispatch=tl.bind(null,mi,e),[r.memoizedState,e]},useRef:function(e){return e={current:e},Oi().memoizedState=e},useState:zi,useDebugValue:Ji,useDeferredValue:function(e){return Oi().memoizedState=e},useTransition:function(){var e=zi(!1),t=e[0];return e=Xi.bind(null,e[1]),Oi().memoizedState=e,[t,e]},useMutableSource:function(){},useSyncExternalStore:function(e,t,n){var r=mi,a=Oi();if(ao){if(void 0===n)throw Error(o(407));n=n()}else{if(n=t(),null===Ns)throw Error(o(349));0!=(30&hi)||Ii(r,t,n)}a.memoizedState=n;var i={value:n,getSnapshot:t};return a.queue=i,Ui(Ri.bind(null,r,i,e),[e]),r.flags|=2048,Ti(9,Fi.bind(null,r,i,n,t),void 0,null),n},useId:function(){var e=Oi(),t=Ns.identifierPrefix;if(ao){var n=qa;t=":"+t+"R"+(n=(Qa&~(1<<32-it(Qa)-1)).toString(32)+n),0<(n=Ci++)&&(t+="H"+n.toString(32)),t+=":"}else t=":"+t+"r"+(n=ki++).toString(32)+":";return e.memoizedState=t},unstable_isNewReconciler:!1},sl={readContext:Oo,useCallback:Qi,useContext:Oo,useEffect:Zi,useImperativeHandle:$i,useInsertionEffect:Wi,useLayoutEffect:Gi,useMemo:qi,useReducer:Pi,useRef:Hi,useState:function(){return Pi(_i)},useDebugValue:Ji,useDeferredValue:function(e){return Yi(Li(),gi.memoizedState,e)},useTransition:function(){return[Pi(_i)[0],Li().memoizedState]},useMutableSource:Mi,useSyncExternalStore:Ai,useId:el,unstable_isNewReconciler:!1},ul={readContext:Oo,useCallback:Qi,useContext:Oo,useEffect:Zi,useImperativeHandle:$i,useInsertionEffect:Wi,useLayoutEffect:Gi,useMemo:qi,useReducer:Ni,useRef:Hi,useState:function(){return Ni(_i)},useDebugValue:Ji,useDeferredValue:function(e){var t=Li();return null===gi?t.memoizedState=e:Yi(t,gi.memoizedState,e)},useTransition:function(){return[Ni(_i)[0],Li().memoizedState]},useMutableSource:Mi,useSyncExternalStore:Ai,useId:el,unstable_isNewReconciler:!1};function cl(e,t){try{var n="",r=t;do{n+=D(r),r=r.return}while(r);var a=n}catch(e){a="\nError generating stack: "+e.message+"\n"+e.stack}return{value:e,source:t,stack:a,digest:null}}function dl(e,t,n){return{value:e,source:null,stack:null!=n?n:null,digest:null!=t?t:null}}function fl(e,t){try{console.error(t.value)}catch(e){setTimeout((function(){throw e}))}}var pl="function"==typeof WeakMap?WeakMap:Map;function hl(e,t,n){(n=Fo(-1,n)).tag=3,n.payload={element:null};var r=t.value;return n.callback=function(){Ws||(Ws=!0,Gs=r),fl(0,t)},n}function ml(e,t,n){(n=Fo(-1,n)).tag=3;var r=e.type.getDerivedStateFromError;if("function"==typeof r){var a=t.value;n.payload=function(){return r(a)},n.callback=function(){fl(0,t)}}var o=e.stateNode;return null!==o&&"function"==typeof o.componentDidCatch&&(n.callback=function(){fl(0,t),"function"!=typeof r&&(null===Ks?Ks=new Set([this]):Ks.add(this));var e=t.stack;this.componentDidCatch(t.value,{componentStack:null!==e?e:""})}),n}function gl(e,t,n){var r=e.pingCache;if(null===r){r=e.pingCache=new pl;var a=new Set;r.set(t,a)}else void 0===(a=r.get(t))&&(a=new Set,r.set(t,a));a.has(n)||(a.add(n),e=Ou.bind(null,e,t,n),t.then(e,e))}function vl(e){do{var t;if((t=13===e.tag)&&(t=null===(t=e.memoizedState)||null!==t.dehydrated),t)return e;e=e.return}while(null!==e);return null}function bl(e,t,n,r,a){return 0==(1&e.mode)?(e===t?e.flags|=65536:(e.flags|=128,n.flags|=131072,n.flags&=-52805,1===n.tag&&(null===n.alternate?n.tag=17:((t=Fo(-1,1)).tag=2,Ro(n,t,1))),n.lanes|=1),e):(e.flags|=65536,e.lanes=a,e)}var yl=C.ReactCurrentOwner,Cl=!1;function kl(e,t,n,r){t.child=null===e?Yo(t,null,n,r):qo(t,e.child,n,r)}function wl(e,t,n,r,a){n=n.render;var o=t.ref;return So(t,a),r=xi(e,t,n,r,o,a),n=Si(),null===e||Cl?(ao&&n&&eo(t),t.flags|=1,kl(e,t,r,a),t.child):(t.updateQueue=e.updateQueue,t.flags&=-2053,e.lanes&=~a,Wl(e,t,a))}function El(e,t,n,r,a){if(null===e){var o=n.type;return"function"!=typeof o||Iu(o)||void 0!==o.defaultProps||null!==n.compare||void 0!==n.defaultProps?((e=Ru(n.type,null,r,t,t.mode,a)).ref=t.ref,e.return=t,t.child=e):(t.tag=15,t.type=o,xl(e,t,o,r,a))}if(o=e.child,0==(e.lanes&a)){var i=o.memoizedProps;if((n=null!==(n=n.compare)?n:sr)(i,r)&&e.ref===t.ref)return Wl(e,t,a)}return t.flags|=1,(e=Fu(o,r)).ref=t.ref,e.return=t,t.child=e}function xl(e,t,n,r,a){if(null!==e){var o=e.memoizedProps;if(sr(o,r)&&e.ref===t.ref){if(Cl=!1,t.pendingProps=r=o,0==(e.lanes&a))return t.lanes=e.lanes,Wl(e,t,a);0!=(131072&e.flags)&&(Cl=!0)}}return Ll(e,t,n,r,a)}function Sl(e,t,n){var r=t.pendingProps,a=r.children,o=null!==e?e.memoizedState:null;if("hidden"===r.mode)if(0==(1&t.mode))t.memoizedState={baseLanes:0,cachePool:null,transitions:null},Oa(Fs,Is),Is|=n;else{if(0==(1073741824&n))return e=null!==o?o.baseLanes|n:n,t.lanes=t.childLanes=1073741824,t.memoizedState={baseLanes:e,cachePool:null,transitions:null},t.updateQueue=null,Oa(Fs,Is),Is|=e,null;t.memoizedState={baseLanes:0,cachePool:null,transitions:null},r=null!==o?o.baseLanes:n,Oa(Fs,Is),Is|=r}else null!==o?(r=o.baseLanes|n,t.memoizedState=null):r=n,Oa(Fs,Is),Is|=r;return kl(e,t,a,n),t.child}function Ol(e,t){var n=t.ref;(null===e&&null!==n||null!==e&&e.ref!==n)&&(t.flags|=512,t.flags|=2097152)}function Ll(e,t,n,r,a){var o=Aa(n)?Na:_a.current;return o=Ma(t,o),So(t,a),n=xi(e,t,n,r,o,a),r=Si(),null===e||Cl?(ao&&r&&eo(t),t.flags|=1,kl(e,t,n,a),t.child):(t.updateQueue=e.updateQueue,t.flags&=-2053,e.lanes&=~a,Wl(e,t,a))}function _l(e,t,n,r,a){if(Aa(n)){var o=!0;Va(t)}else o=!1;if(So(t,a),null===t.stateNode)Zl(e,t),Zo(t,n,r),Go(t,n,r,a),r=!0;else if(null===e){var i=t.stateNode,l=t.memoizedProps;i.props=l;var s=i.context,u=n.contextType;"object"==typeof u&&null!==u?u=Oo(u):u=Ma(t,u=Aa(n)?Na:_a.current);var c=n.getDerivedStateFromProps,d="function"==typeof c||"function"==typeof i.getSnapshotBeforeUpdate;d||"function"!=typeof i.UNSAFE_componentWillReceiveProps&&"function"!=typeof i.componentWillReceiveProps||(l!==r||s!==u)&&Wo(t,i,r,u),Mo=!1;var f=t.memoizedState;i.state=f,zo(t,r,i,a),s=t.memoizedState,l!==r||f!==s||Pa.current||Mo?("function"==typeof c&&(Do(t,n,c,r),s=t.memoizedState),(l=Mo||Uo(t,n,l,r,f,s,u))?(d||"function"!=typeof i.UNSAFE_componentWillMount&&"function"!=typeof i.componentWillMount||("function"==typeof i.componentWillMount&&i.componentWillMount(),"function"==typeof i.UNSAFE_componentWillMount&&i.UNSAFE_componentWillMount()),"function"==typeof i.componentDidMount&&(t.flags|=4194308)):("function"==typeof i.componentDidMount&&(t.flags|=4194308),t.memoizedProps=r,t.memoizedState=s),i.props=r,i.state=s,i.context=u,r=l):("function"==typeof i.componentDidMount&&(t.flags|=4194308),r=!1)}else{i=t.stateNode,Io(e,t),l=t.memoizedProps,u=t.type===t.elementType?l:vo(t.type,l),i.props=u,d=t.pendingProps,f=i.context,"object"==typeof(s=n.contextType)&&null!==s?s=Oo(s):s=Ma(t,s=Aa(n)?Na:_a.current);var p=n.getDerivedStateFromProps;(c="function"==typeof p||"function"==typeof i.getSnapshotBeforeUpdate)||"function"!=typeof i.UNSAFE_componentWillReceiveProps&&"function"!=typeof i.componentWillReceiveProps||(l!==d||f!==s)&&Wo(t,i,r,s),Mo=!1,f=t.memoizedState,i.state=f,zo(t,r,i,a);var h=t.memoizedState;l!==d||f!==h||Pa.current||Mo?("function"==typeof p&&(Do(t,n,p,r),h=t.memoizedState),(u=Mo||Uo(t,n,u,r,f,h,s)||!1)?(c||"function"!=typeof i.UNSAFE_componentWillUpdate&&"function"!=typeof i.componentWillUpdate||("function"==typeof i.componentWillUpdate&&i.componentWillUpdate(r,h,s),"function"==typeof i.UNSAFE_componentWillUpdate&&i.UNSAFE_componentWillUpdate(r,h,s)),"function"==typeof i.componentDidUpdate&&(t.flags|=4),"function"==typeof i.getSnapshotBeforeUpdate&&(t.flags|=1024)):("function"!=typeof i.componentDidUpdate||l===e.memoizedProps&&f===e.memoizedState||(t.flags|=4),"function"!=typeof i.getSnapshotBeforeUpdate||l===e.memoizedProps&&f===e.memoizedState||(t.flags|=1024),t.memoizedProps=r,t.memoizedState=h),i.props=r,i.state=h,i.context=s,r=u):("function"!=typeof i.componentDidUpdate||l===e.memoizedProps&&f===e.memoizedState||(t.flags|=4),"function"!=typeof i.getSnapshotBeforeUpdate||l===e.memoizedProps&&f===e.memoizedState||(t.flags|=1024),r=!1)}return Pl(e,t,n,r,o,a)}function Pl(e,t,n,r,a,o){Ol(e,t);var i=0!=(128&t.flags);if(!r&&!i)return a&&ja(t,n,!1),Wl(e,t,o);r=t.stateNode,yl.current=t;var l=i&&"function"!=typeof n.getDerivedStateFromError?null:r.render();return t.flags|=1,null!==e&&i?(t.child=qo(t,e.child,null,o),t.child=qo(t,null,l,o)):kl(e,t,l,o),t.memoizedState=r.state,a&&ja(t,n,!0),t.child}function Nl(e){var t=e.stateNode;t.pendingContext?Fa(0,t.pendingContext,t.pendingContext!==t.context):t.context&&Fa(0,t.context,!1),ai(e,t.containerInfo)}function Ml(e,t,n,r,a){return ho(),mo(a),t.flags|=256,kl(e,t,n,r),t.child}var Al,Il,Fl,Rl,Vl={dehydrated:null,treeContext:null,retryLane:0};function jl(e){return{baseLanes:e,cachePool:null,transitions:null}}function zl(e,t,n){var r,a=t.pendingProps,i=si.current,l=!1,s=0!=(128&t.flags);if((r=s)||(r=(null===e||null!==e.memoizedState)&&0!=(2&i)),r?(l=!0,t.flags&=-129):null!==e&&null===e.memoizedState||(i|=1),Oa(si,1&i),null===e)return uo(t),null!==(e=t.memoizedState)&&null!==(e=e.dehydrated)?(0==(1&t.mode)?t.lanes=1:"$!"===e.data?t.lanes=8:t.lanes=1073741824,null):(s=a.children,e=a.fallback,l?(a=t.mode,l=t.child,s={mode:"hidden",children:s},0==(1&a)&&null!==l?(l.childLanes=0,l.pendingProps=s):l=ju(s,a,0,null),e=Vu(e,a,n,null),l.return=t,e.return=t,l.sibling=e,t.child=l,t.child.memoizedState=jl(n),t.memoizedState=Vl,e):Tl(t,s));if(null!==(i=e.memoizedState)&&null!==(r=i.dehydrated))return function(e,t,n,r,a,i,l){if(n)return 256&t.flags?(t.flags&=-257,Hl(e,t,l,r=dl(Error(o(422))))):null!==t.memoizedState?(t.child=e.child,t.flags|=128,null):(i=r.fallback,a=t.mode,r=ju({mode:"visible",children:r.children},a,0,null),(i=Vu(i,a,l,null)).flags|=2,r.return=t,i.return=t,r.sibling=i,t.child=r,0!=(1&t.mode)&&qo(t,e.child,null,l),t.child.memoizedState=jl(l),t.memoizedState=Vl,i);if(0==(1&t.mode))return Hl(e,t,l,null);if("$!"===a.data){if(r=a.nextSibling&&a.nextSibling.dataset)var s=r.dgst;return r=s,Hl(e,t,l,r=dl(i=Error(o(419)),r,void 0))}if(s=0!=(l&e.childLanes),Cl||s){if(null!==(r=Ns)){switch(l&-l){case 4:a=2;break;case 16:a=8;break;case 64:case 128:case 256:case 512:case 1024:case 2048:case 4096:case 8192:case 16384:case 32768:case 65536:case 131072:case 262144:case 524288:case 1048576:case 2097152:case 4194304:case 8388608:case 16777216:case 33554432:case 67108864:a=32;break;case 536870912:a=268435456;break;default:a=0}0!==(a=0!=(a&(r.suspendedLanes|l))?0:a)&&a!==i.retryLane&&(i.retryLane=a,No(e,a),ru(r,e,a,-1))}return gu(),Hl(e,t,l,r=dl(Error(o(421))))}return"$?"===a.data?(t.flags|=128,t.child=e.child,t=_u.bind(null,e),a._reactRetry=t,null):(e=i.treeContext,ro=ua(a.nextSibling),no=t,ao=!0,oo=null,null!==e&&(Ka[$a++]=Qa,Ka[$a++]=qa,Ka[$a++]=Ja,Qa=e.id,qa=e.overflow,Ja=t),t=Tl(t,r.children),t.flags|=4096,t)}(e,t,s,a,r,i,n);if(l){l=a.fallback,s=t.mode,r=(i=e.child).sibling;var u={mode:"hidden",children:a.children};return 0==(1&s)&&t.child!==i?((a=t.child).childLanes=0,a.pendingProps=u,t.deletions=null):(a=Fu(i,u)).subtreeFlags=14680064&i.subtreeFlags,null!==r?l=Fu(r,l):(l=Vu(l,s,n,null)).flags|=2,l.return=t,a.return=t,a.sibling=l,t.child=a,a=l,l=t.child,s=null===(s=e.child.memoizedState)?jl(n):{baseLanes:s.baseLanes|n,cachePool:null,transitions:s.transitions},l.memoizedState=s,l.childLanes=e.childLanes&~n,t.memoizedState=Vl,a}return e=(l=e.child).sibling,a=Fu(l,{mode:"visible",children:a.children}),0==(1&t.mode)&&(a.lanes=n),a.return=t,a.sibling=null,null!==e&&(null===(n=t.deletions)?(t.deletions=[e],t.flags|=16):n.push(e)),t.child=a,t.memoizedState=null,a}function Tl(e,t){return(t=ju({mode:"visible",children:t},e.mode,0,null)).return=e,e.child=t}function Hl(e,t,n,r){return null!==r&&mo(r),qo(t,e.child,null,n),(e=Tl(t,t.pendingProps.children)).flags|=2,t.memoizedState=null,e}function Dl(e,t,n){e.lanes|=t;var r=e.alternate;null!==r&&(r.lanes|=t),xo(e.return,t,n)}function Bl(e,t,n,r,a){var o=e.memoizedState;null===o?e.memoizedState={isBackwards:t,rendering:null,renderingStartTime:0,last:r,tail:n,tailMode:a}:(o.isBackwards=t,o.rendering=null,o.renderingStartTime=0,o.last=r,o.tail=n,o.tailMode=a)}function Ul(e,t,n){var r=t.pendingProps,a=r.revealOrder,o=r.tail;if(kl(e,t,r.children,n),0!=(2&(r=si.current)))r=1&r|2,t.flags|=128;else{if(null!==e&&0!=(128&e.flags))e:for(e=t.child;null!==e;){if(13===e.tag)null!==e.memoizedState&&Dl(e,n,t);else if(19===e.tag)Dl(e,n,t);else if(null!==e.child){e.child.return=e,e=e.child;continue}if(e===t)break e;for(;null===e.sibling;){if(null===e.return||e.return===t)break e;e=e.return}e.sibling.return=e.return,e=e.sibling}r&=1}if(Oa(si,r),0==(1&t.mode))t.memoizedState=null;else switch(a){case"forwards":for(n=t.child,a=null;null!==n;)null!==(e=n.alternate)&&null===ui(e)&&(a=n),n=n.sibling;null===(n=a)?(a=t.child,t.child=null):(a=n.sibling,n.sibling=null),Bl(t,!1,a,n,o);break;case"backwards":for(n=null,a=t.child,t.child=null;null!==a;){if(null!==(e=a.alternate)&&null===ui(e)){t.child=a;break}e=a.sibling,a.sibling=n,n=a,a=e}Bl(t,!0,n,null,o);break;case"together":Bl(t,!1,null,null,void 0);break;default:t.memoizedState=null}return t.child}function Zl(e,t){0==(1&t.mode)&&null!==e&&(e.alternate=null,t.alternate=null,t.flags|=2)}function Wl(e,t,n){if(null!==e&&(t.dependencies=e.dependencies),js|=t.lanes,0==(n&t.childLanes))return null;if(null!==e&&t.child!==e.child)throw Error(o(153));if(null!==t.child){for(n=Fu(e=t.child,e.pendingProps),t.child=n,n.return=t;null!==e.sibling;)e=e.sibling,(n=n.sibling=Fu(e,e.pendingProps)).return=t;n.sibling=null}return t.child}function Gl(e,t){if(!ao)switch(e.tailMode){case"hidden":t=e.tail;for(var n=null;null!==t;)null!==t.alternate&&(n=t),t=t.sibling;null===n?e.tail=null:n.sibling=null;break;case"collapsed":n=e.tail;for(var r=null;null!==n;)null!==n.alternate&&(r=n),n=n.sibling;null===r?t||null===e.tail?e.tail=null:e.tail.sibling=null:r.sibling=null}}function Kl(e){var t=null!==e.alternate&&e.alternate.child===e.child,n=0,r=0;if(t)for(var a=e.child;null!==a;)n|=a.lanes|a.childLanes,r|=14680064&a.subtreeFlags,r|=14680064&a.flags,a.return=e,a=a.sibling;else for(a=e.child;null!==a;)n|=a.lanes|a.childLanes,r|=a.subtreeFlags,r|=a.flags,a.return=e,a=a.sibling;return e.subtreeFlags|=r,e.childLanes=n,t}function $l(e,t,n){var r=t.pendingProps;switch(to(t),t.tag){case 2:case 16:case 15:case 0:case 11:case 7:case 8:case 12:case 9:case 14:return Kl(t),null;case 1:case 17:return Aa(t.type)&&Ia(),Kl(t),null;case 3:return r=t.stateNode,oi(),Sa(Pa),Sa(_a),di(),r.pendingContext&&(r.context=r.pendingContext,r.pendingContext=null),null!==e&&null!==e.child||(fo(t)?t.flags|=4:null===e||e.memoizedState.isDehydrated&&0==(256&t.flags)||(t.flags|=1024,null!==oo&&(lu(oo),oo=null))),Il(e,t),Kl(t),null;case 5:li(t);var a=ri(ni.current);if(n=t.type,null!==e&&null!=t.stateNode)Fl(e,t,n,r,a),e.ref!==t.ref&&(t.flags|=512,t.flags|=2097152);else{if(!r){if(null===t.stateNode)throw Error(o(166));return Kl(t),null}if(e=ri(ei.current),fo(t)){r=t.stateNode,n=t.type;var i=t.memoizedProps;switch(r[fa]=t,r[pa]=i,e=0!=(1&t.mode),n){case"dialog":Tr("cancel",r),Tr("close",r);break;case"iframe":case"object":case"embed":Tr("load",r);break;case"video":case"audio":for(a=0;a<Rr.length;a++)Tr(Rr[a],r);break;case"source":Tr("error",r);break;case"img":case"image":case"link":Tr("error",r),Tr("load",r);break;case"details":Tr("toggle",r);break;case"input":Q(r,i),Tr("invalid",r);break;case"select":r._wrapperState={wasMultiple:!!i.multiple},Tr("invalid",r);break;case"textarea":ae(r,i),Tr("invalid",r)}for(var s in be(n,i),a=null,i)if(i.hasOwnProperty(s)){var u=i[s];"children"===s?"string"==typeof u?r.textContent!==u&&(!0!==i.suppressHydrationWarning&&Yr(r.textContent,u,e),a=["children",u]):"number"==typeof u&&r.textContent!==""+u&&(!0!==i.suppressHydrationWarning&&Yr(r.textContent,u,e),a=["children",""+u]):l.hasOwnProperty(s)&&null!=u&&"onScroll"===s&&Tr("scroll",r)}switch(n){case"input":G(r),X(r,i,!0);break;case"textarea":G(r),ie(r);break;case"select":case"option":break;default:"function"==typeof i.onClick&&(r.onclick=Xr)}r=a,t.updateQueue=r,null!==r&&(t.flags|=4)}else{s=9===a.nodeType?a:a.ownerDocument,"http://www.w3.org/1999/xhtml"===e&&(e=le(n)),"http://www.w3.org/1999/xhtml"===e?"script"===n?((e=s.createElement("div")).innerHTML="<script><\/script>",e=e.removeChild(e.firstChild)):"string"==typeof r.is?e=s.createElement(n,{is:r.is}):(e=s.createElement(n),"select"===n&&(s=e,r.multiple?s.multiple=!0:r.size&&(s.size=r.size))):e=s.createElementNS(e,n),e[fa]=t,e[pa]=r,Al(e,t,!1,!1),t.stateNode=e;e:{switch(s=ye(n,r),n){case"dialog":Tr("cancel",e),Tr("close",e),a=r;break;case"iframe":case"object":case"embed":Tr("load",e),a=r;break;case"video":case"audio":for(a=0;a<Rr.length;a++)Tr(Rr[a],e);a=r;break;case"source":Tr("error",e),a=r;break;case"img":case"image":case"link":Tr("error",e),Tr("load",e),a=r;break;case"details":Tr("toggle",e),a=r;break;case"input":Q(e,r),a=J(e,r),Tr("invalid",e);break;case"option":default:a=r;break;case"select":e._wrapperState={wasMultiple:!!r.multiple},a=j({},r,{value:void 0}),Tr("invalid",e);break;case"textarea":ae(e,r),a=re(e,r),Tr("invalid",e)}for(i in be(n,a),u=a)if(u.hasOwnProperty(i)){var c=u[i];"style"===i?ge(e,c):"dangerouslySetInnerHTML"===i?null!=(c=c?c.__html:void 0)&&de(e,c):"children"===i?"string"==typeof c?("textarea"!==n||""!==c)&&fe(e,c):"number"==typeof c&&fe(e,""+c):"suppressContentEditableWarning"!==i&&"suppressHydrationWarning"!==i&&"autoFocus"!==i&&(l.hasOwnProperty(i)?null!=c&&"onScroll"===i&&Tr("scroll",e):null!=c&&y(e,i,c,s))}switch(n){case"input":G(e),X(e,r,!1);break;case"textarea":G(e),ie(e);break;case"option":null!=r.value&&e.setAttribute("value",""+Z(r.value));break;case"select":e.multiple=!!r.multiple,null!=(i=r.value)?ne(e,!!r.multiple,i,!1):null!=r.defaultValue&&ne(e,!!r.multiple,r.defaultValue,!0);break;default:"function"==typeof a.onClick&&(e.onclick=Xr)}switch(n){case"button":case"input":case"select":case"textarea":r=!!r.autoFocus;break e;case"img":r=!0;break e;default:r=!1}}r&&(t.flags|=4)}null!==t.ref&&(t.flags|=512,t.flags|=2097152)}return Kl(t),null;case 6:if(e&&null!=t.stateNode)Rl(e,t,e.memoizedProps,r);else{if("string"!=typeof r&&null===t.stateNode)throw Error(o(166));if(n=ri(ni.current),ri(ei.current),fo(t)){if(r=t.stateNode,n=t.memoizedProps,r[fa]=t,(i=r.nodeValue!==n)&&null!==(e=no))switch(e.tag){case 3:Yr(r.nodeValue,n,0!=(1&e.mode));break;case 5:!0!==e.memoizedProps.suppressHydrationWarning&&Yr(r.nodeValue,n,0!=(1&e.mode))}i&&(t.flags|=4)}else(r=(9===n.nodeType?n:n.ownerDocument).createTextNode(r))[fa]=t,t.stateNode=r}return Kl(t),null;case 13:if(Sa(si),r=t.memoizedState,null===e||null!==e.memoizedState&&null!==e.memoizedState.dehydrated){if(ao&&null!==ro&&0!=(1&t.mode)&&0==(128&t.flags))po(),ho(),t.flags|=98560,i=!1;else if(i=fo(t),null!==r&&null!==r.dehydrated){if(null===e){if(!i)throw Error(o(318));if(!(i=null!==(i=t.memoizedState)?i.dehydrated:null))throw Error(o(317));i[fa]=t}else ho(),0==(128&t.flags)&&(t.memoizedState=null),t.flags|=4;Kl(t),i=!1}else null!==oo&&(lu(oo),oo=null),i=!0;if(!i)return 65536&t.flags?t:null}return 0!=(128&t.flags)?(t.lanes=n,t):((r=null!==r)!==(null!==e&&null!==e.memoizedState)&&r&&(t.child.flags|=8192,0!=(1&t.mode)&&(null===e||0!=(1&si.current)?0===Rs&&(Rs=3):gu())),null!==t.updateQueue&&(t.flags|=4),Kl(t),null);case 4:return oi(),Il(e,t),null===e&&Br(t.stateNode.containerInfo),Kl(t),null;case 10:return Eo(t.type._context),Kl(t),null;case 19:if(Sa(si),null===(i=t.memoizedState))return Kl(t),null;if(r=0!=(128&t.flags),null===(s=i.rendering))if(r)Gl(i,!1);else{if(0!==Rs||null!==e&&0!=(128&e.flags))for(e=t.child;null!==e;){if(null!==(s=ui(e))){for(t.flags|=128,Gl(i,!1),null!==(r=s.updateQueue)&&(t.updateQueue=r,t.flags|=4),t.subtreeFlags=0,r=n,n=t.child;null!==n;)e=r,(i=n).flags&=14680066,null===(s=i.alternate)?(i.childLanes=0,i.lanes=e,i.child=null,i.subtreeFlags=0,i.memoizedProps=null,i.memoizedState=null,i.updateQueue=null,i.dependencies=null,i.stateNode=null):(i.childLanes=s.childLanes,i.lanes=s.lanes,i.child=s.child,i.subtreeFlags=0,i.deletions=null,i.memoizedProps=s.memoizedProps,i.memoizedState=s.memoizedState,i.updateQueue=s.updateQueue,i.type=s.type,e=s.dependencies,i.dependencies=null===e?null:{lanes:e.lanes,firstContext:e.firstContext}),n=n.sibling;return Oa(si,1&si.current|2),t.child}e=e.sibling}null!==i.tail&&qe()>Us&&(t.flags|=128,r=!0,Gl(i,!1),t.lanes=4194304)}else{if(!r)if(null!==(e=ui(s))){if(t.flags|=128,r=!0,null!==(n=e.updateQueue)&&(t.updateQueue=n,t.flags|=4),Gl(i,!0),null===i.tail&&"hidden"===i.tailMode&&!s.alternate&&!ao)return Kl(t),null}else 2*qe()-i.renderingStartTime>Us&&1073741824!==n&&(t.flags|=128,r=!0,Gl(i,!1),t.lanes=4194304);i.isBackwards?(s.sibling=t.child,t.child=s):(null!==(n=i.last)?n.sibling=s:t.child=s,i.last=s)}return null!==i.tail?(t=i.tail,i.rendering=t,i.tail=t.sibling,i.renderingStartTime=qe(),t.sibling=null,n=si.current,Oa(si,r?1&n|2:1&n),t):(Kl(t),null);case 22:case 23:return fu(),r=null!==t.memoizedState,null!==e&&null!==e.memoizedState!==r&&(t.flags|=8192),r&&0!=(1&t.mode)?0!=(1073741824&Is)&&(Kl(t),6&t.subtreeFlags&&(t.flags|=8192)):Kl(t),null;case 24:case 25:return null}throw Error(o(156,t.tag))}function Jl(e,t){switch(to(t),t.tag){case 1:return Aa(t.type)&&Ia(),65536&(e=t.flags)?(t.flags=-65537&e|128,t):null;case 3:return oi(),Sa(Pa),Sa(_a),di(),0!=(65536&(e=t.flags))&&0==(128&e)?(t.flags=-65537&e|128,t):null;case 5:return li(t),null;case 13:if(Sa(si),null!==(e=t.memoizedState)&&null!==e.dehydrated){if(null===t.alternate)throw Error(o(340));ho()}return 65536&(e=t.flags)?(t.flags=-65537&e|128,t):null;case 19:return Sa(si),null;case 4:return oi(),null;case 10:return Eo(t.type._context),null;case 22:case 23:return fu(),null;default:return null}}Al=function(e,t){for(var n=t.child;null!==n;){if(5===n.tag||6===n.tag)e.appendChild(n.stateNode);else if(4!==n.tag&&null!==n.child){n.child.return=n,n=n.child;continue}if(n===t)break;for(;null===n.sibling;){if(null===n.return||n.return===t)return;n=n.return}n.sibling.return=n.return,n=n.sibling}},Il=function(){},Fl=function(e,t,n,r){var a=e.memoizedProps;if(a!==r){e=t.stateNode,ri(ei.current);var o,i=null;switch(n){case"input":a=J(e,a),r=J(e,r),i=[];break;case"select":a=j({},a,{value:void 0}),r=j({},r,{value:void 0}),i=[];break;case"textarea":a=re(e,a),r=re(e,r),i=[];break;default:"function"!=typeof a.onClick&&"function"==typeof r.onClick&&(e.onclick=Xr)}for(c in be(n,r),n=null,a)if(!r.hasOwnProperty(c)&&a.hasOwnProperty(c)&&null!=a[c])if("style"===c){var s=a[c];for(o in s)s.hasOwnProperty(o)&&(n||(n={}),n[o]="")}else"dangerouslySetInnerHTML"!==c&&"children"!==c&&"suppressContentEditableWarning"!==c&&"suppressHydrationWarning"!==c&&"autoFocus"!==c&&(l.hasOwnProperty(c)?i||(i=[]):(i=i||[]).push(c,null));for(c in r){var u=r[c];if(s=null!=a?a[c]:void 0,r.hasOwnProperty(c)&&u!==s&&(null!=u||null!=s))if("style"===c)if(s){for(o in s)!s.hasOwnProperty(o)||u&&u.hasOwnProperty(o)||(n||(n={}),n[o]="");for(o in u)u.hasOwnProperty(o)&&s[o]!==u[o]&&(n||(n={}),n[o]=u[o])}else n||(i||(i=[]),i.push(c,n)),n=u;else"dangerouslySetInnerHTML"===c?(u=u?u.__html:void 0,s=s?s.__html:void 0,null!=u&&s!==u&&(i=i||[]).push(c,u)):"children"===c?"string"!=typeof u&&"number"!=typeof u||(i=i||[]).push(c,""+u):"suppressContentEditableWarning"!==c&&"suppressHydrationWarning"!==c&&(l.hasOwnProperty(c)?(null!=u&&"onScroll"===c&&Tr("scroll",e),i||s===u||(i=[])):(i=i||[]).push(c,u))}n&&(i=i||[]).push("style",n);var c=i;(t.updateQueue=c)&&(t.flags|=4)}},Rl=function(e,t,n,r){n!==r&&(t.flags|=4)};var Ql=!1,ql=!1,Yl="function"==typeof WeakSet?WeakSet:Set,Xl=null;function es(e,t){var n=e.ref;if(null!==n)if("function"==typeof n)try{n(null)}catch(n){Su(e,t,n)}else n.current=null}function ts(e,t,n){try{n()}catch(n){Su(e,t,n)}}var ns=!1;function rs(e,t,n){var r=t.updateQueue;if(null!==(r=null!==r?r.lastEffect:null)){var a=r=r.next;do{if((a.tag&e)===e){var o=a.destroy;a.destroy=void 0,void 0!==o&&ts(t,n,o)}a=a.next}while(a!==r)}}function as(e,t){if(null!==(t=null!==(t=t.updateQueue)?t.lastEffect:null)){var n=t=t.next;do{if((n.tag&e)===e){var r=n.create;n.destroy=r()}n=n.next}while(n!==t)}}function os(e){var t=e.ref;if(null!==t){var n=e.stateNode;e.tag,e=n,"function"==typeof t?t(e):t.current=e}}function is(e){var t=e.alternate;null!==t&&(e.alternate=null,is(t)),e.child=null,e.deletions=null,e.sibling=null,5===e.tag&&(null!==(t=e.stateNode)&&(delete t[fa],delete t[pa],delete t[ma],delete t[ga],delete t[va])),e.stateNode=null,e.return=null,e.dependencies=null,e.memoizedProps=null,e.memoizedState=null,e.pendingProps=null,e.stateNode=null,e.updateQueue=null}function ls(e){return 5===e.tag||3===e.tag||4===e.tag}function ss(e){e:for(;;){for(;null===e.sibling;){if(null===e.return||ls(e.return))return null;e=e.return}for(e.sibling.return=e.return,e=e.sibling;5!==e.tag&&6!==e.tag&&18!==e.tag;){if(2&e.flags)continue e;if(null===e.child||4===e.tag)continue e;e.child.return=e,e=e.child}if(!(2&e.flags))return e.stateNode}}function us(e,t,n){var r=e.tag;if(5===r||6===r)e=e.stateNode,t?8===n.nodeType?n.parentNode.insertBefore(e,t):n.insertBefore(e,t):(8===n.nodeType?(t=n.parentNode).insertBefore(e,n):(t=n).appendChild(e),null!=(n=n._reactRootContainer)||null!==t.onclick||(t.onclick=Xr));else if(4!==r&&null!==(e=e.child))for(us(e,t,n),e=e.sibling;null!==e;)us(e,t,n),e=e.sibling}function cs(e,t,n){var r=e.tag;if(5===r||6===r)e=e.stateNode,t?n.insertBefore(e,t):n.appendChild(e);else if(4!==r&&null!==(e=e.child))for(cs(e,t,n),e=e.sibling;null!==e;)cs(e,t,n),e=e.sibling}var ds=null,fs=!1;function ps(e,t,n){for(n=n.child;null!==n;)hs(e,t,n),n=n.sibling}function hs(e,t,n){if(ot&&"function"==typeof ot.onCommitFiberUnmount)try{ot.onCommitFiberUnmount(at,n)}catch(e){}switch(n.tag){case 5:ql||es(n,t);case 6:var r=ds,a=fs;ds=null,ps(e,t,n),fs=a,null!==(ds=r)&&(fs?(e=ds,n=n.stateNode,8===e.nodeType?e.parentNode.removeChild(n):e.removeChild(n)):ds.removeChild(n.stateNode));break;case 18:null!==ds&&(fs?(e=ds,n=n.stateNode,8===e.nodeType?sa(e.parentNode,n):1===e.nodeType&&sa(e,n),Bt(e)):sa(ds,n.stateNode));break;case 4:r=ds,a=fs,ds=n.stateNode.containerInfo,fs=!0,ps(e,t,n),ds=r,fs=a;break;case 0:case 11:case 14:case 15:if(!ql&&(null!==(r=n.updateQueue)&&null!==(r=r.lastEffect))){a=r=r.next;do{var o=a,i=o.destroy;o=o.tag,void 0!==i&&(0!=(2&o)||0!=(4&o))&&ts(n,t,i),a=a.next}while(a!==r)}ps(e,t,n);break;case 1:if(!ql&&(es(n,t),"function"==typeof(r=n.stateNode).componentWillUnmount))try{r.props=n.memoizedProps,r.state=n.memoizedState,r.componentWillUnmount()}catch(e){Su(n,t,e)}ps(e,t,n);break;case 21:ps(e,t,n);break;case 22:1&n.mode?(ql=(r=ql)||null!==n.memoizedState,ps(e,t,n),ql=r):ps(e,t,n);break;default:ps(e,t,n)}}function ms(e){var t=e.updateQueue;if(null!==t){e.updateQueue=null;var n=e.stateNode;null===n&&(n=e.stateNode=new Yl),t.forEach((function(t){var r=Pu.bind(null,e,t);n.has(t)||(n.add(t),t.then(r,r))}))}}function gs(e,t){var n=t.deletions;if(null!==n)for(var r=0;r<n.length;r++){var a=n[r];try{var i=e,l=t,s=l;e:for(;null!==s;){switch(s.tag){case 5:ds=s.stateNode,fs=!1;break e;case 3:case 4:ds=s.stateNode.containerInfo,fs=!0;break e}s=s.return}if(null===ds)throw Error(o(160));hs(i,l,a),ds=null,fs=!1;var u=a.alternate;null!==u&&(u.return=null),a.return=null}catch(e){Su(a,t,e)}}if(12854&t.subtreeFlags)for(t=t.child;null!==t;)vs(t,e),t=t.sibling}function vs(e,t){var n=e.alternate,r=e.flags;switch(e.tag){case 0:case 11:case 14:case 15:if(gs(t,e),bs(e),4&r){try{rs(3,e,e.return),as(3,e)}catch(t){Su(e,e.return,t)}try{rs(5,e,e.return)}catch(t){Su(e,e.return,t)}}break;case 1:gs(t,e),bs(e),512&r&&null!==n&&es(n,n.return);break;case 5:if(gs(t,e),bs(e),512&r&&null!==n&&es(n,n.return),32&e.flags){var a=e.stateNode;try{fe(a,"")}catch(t){Su(e,e.return,t)}}if(4&r&&null!=(a=e.stateNode)){var i=e.memoizedProps,l=null!==n?n.memoizedProps:i,s=e.type,u=e.updateQueue;if(e.updateQueue=null,null!==u)try{"input"===s&&"radio"===i.type&&null!=i.name&&q(a,i),ye(s,l);var c=ye(s,i);for(l=0;l<u.length;l+=2){var d=u[l],f=u[l+1];"style"===d?ge(a,f):"dangerouslySetInnerHTML"===d?de(a,f):"children"===d?fe(a,f):y(a,d,f,c)}switch(s){case"input":Y(a,i);break;case"textarea":oe(a,i);break;case"select":var p=a._wrapperState.wasMultiple;a._wrapperState.wasMultiple=!!i.multiple;var h=i.value;null!=h?ne(a,!!i.multiple,h,!1):p!==!!i.multiple&&(null!=i.defaultValue?ne(a,!!i.multiple,i.defaultValue,!0):ne(a,!!i.multiple,i.multiple?[]:"",!1))}a[pa]=i}catch(t){Su(e,e.return,t)}}break;case 6:if(gs(t,e),bs(e),4&r){if(null===e.stateNode)throw Error(o(162));a=e.stateNode,i=e.memoizedProps;try{a.nodeValue=i}catch(t){Su(e,e.return,t)}}break;case 3:if(gs(t,e),bs(e),4&r&&null!==n&&n.memoizedState.isDehydrated)try{Bt(t.containerInfo)}catch(t){Su(e,e.return,t)}break;case 4:default:gs(t,e),bs(e);break;case 13:gs(t,e),bs(e),8192&(a=e.child).flags&&(i=null!==a.memoizedState,a.stateNode.isHidden=i,!i||null!==a.alternate&&null!==a.alternate.memoizedState||(Bs=qe())),4&r&&ms(e);break;case 22:if(d=null!==n&&null!==n.memoizedState,1&e.mode?(ql=(c=ql)||d,gs(t,e),ql=c):gs(t,e),bs(e),8192&r){if(c=null!==e.memoizedState,(e.stateNode.isHidden=c)&&!d&&0!=(1&e.mode))for(Xl=e,d=e.child;null!==d;){for(f=Xl=d;null!==Xl;){switch(h=(p=Xl).child,p.tag){case 0:case 11:case 14:case 15:rs(4,p,p.return);break;case 1:es(p,p.return);var m=p.stateNode;if("function"==typeof m.componentWillUnmount){r=p,n=p.return;try{t=r,m.props=t.memoizedProps,m.state=t.memoizedState,m.componentWillUnmount()}catch(e){Su(r,n,e)}}break;case 5:es(p,p.return);break;case 22:if(null!==p.memoizedState){ws(f);continue}}null!==h?(h.return=p,Xl=h):ws(f)}d=d.sibling}e:for(d=null,f=e;;){if(5===f.tag){if(null===d){d=f;try{a=f.stateNode,c?"function"==typeof(i=a.style).setProperty?i.setProperty("display","none","important"):i.display="none":(s=f.stateNode,l=null!=(u=f.memoizedProps.style)&&u.hasOwnProperty("display")?u.display:null,s.style.display=me("display",l))}catch(t){Su(e,e.return,t)}}}else if(6===f.tag){if(null===d)try{f.stateNode.nodeValue=c?"":f.memoizedProps}catch(t){Su(e,e.return,t)}}else if((22!==f.tag&&23!==f.tag||null===f.memoizedState||f===e)&&null!==f.child){f.child.return=f,f=f.child;continue}if(f===e)break e;for(;null===f.sibling;){if(null===f.return||f.return===e)break e;d===f&&(d=null),f=f.return}d===f&&(d=null),f.sibling.return=f.return,f=f.sibling}}break;case 19:gs(t,e),bs(e),4&r&&ms(e);case 21:}}function bs(e){var t=e.flags;if(2&t){try{e:{for(var n=e.return;null!==n;){if(ls(n)){var r=n;break e}n=n.return}throw Error(o(160))}switch(r.tag){case 5:var a=r.stateNode;32&r.flags&&(fe(a,""),r.flags&=-33),cs(e,ss(e),a);break;case 3:case 4:var i=r.stateNode.containerInfo;us(e,ss(e),i);break;default:throw Error(o(161))}}catch(t){Su(e,e.return,t)}e.flags&=-3}4096&t&&(e.flags&=-4097)}function ys(e,t,n){Xl=e,Cs(e,t,n)}function Cs(e,t,n){for(var r=0!=(1&e.mode);null!==Xl;){var a=Xl,o=a.child;if(22===a.tag&&r){var i=null!==a.memoizedState||Ql;if(!i){var l=a.alternate,s=null!==l&&null!==l.memoizedState||ql;l=Ql;var u=ql;if(Ql=i,(ql=s)&&!u)for(Xl=a;null!==Xl;)s=(i=Xl).child,22===i.tag&&null!==i.memoizedState?Es(a):null!==s?(s.return=i,Xl=s):Es(a);for(;null!==o;)Xl=o,Cs(o,t,n),o=o.sibling;Xl=a,Ql=l,ql=u}ks(e)}else 0!=(8772&a.subtreeFlags)&&null!==o?(o.return=a,Xl=o):ks(e)}}function ks(e){for(;null!==Xl;){var t=Xl;if(0!=(8772&t.flags)){var n=t.alternate;try{if(0!=(8772&t.flags))switch(t.tag){case 0:case 11:case 15:ql||as(5,t);break;case 1:var r=t.stateNode;if(4&t.flags&&!ql)if(null===n)r.componentDidMount();else{var a=t.elementType===t.type?n.memoizedProps:vo(t.type,n.memoizedProps);r.componentDidUpdate(a,n.memoizedState,r.__reactInternalSnapshotBeforeUpdate)}var i=t.updateQueue;null!==i&&To(t,i,r);break;case 3:var l=t.updateQueue;if(null!==l){if(n=null,null!==t.child)switch(t.child.tag){case 5:case 1:n=t.child.stateNode}To(t,l,n)}break;case 5:var s=t.stateNode;if(null===n&&4&t.flags){n=s;var u=t.memoizedProps;switch(t.type){case"button":case"input":case"select":case"textarea":u.autoFocus&&n.focus();break;case"img":u.src&&(n.src=u.src)}}break;case 6:case 4:case 12:case 19:case 17:case 21:case 22:case 23:case 25:break;case 13:if(null===t.memoizedState){var c=t.alternate;if(null!==c){var d=c.memoizedState;if(null!==d){var f=d.dehydrated;null!==f&&Bt(f)}}}break;default:throw Error(o(163))}ql||512&t.flags&&os(t)}catch(e){Su(t,t.return,e)}}if(t===e){Xl=null;break}if(null!==(n=t.sibling)){n.return=t.return,Xl=n;break}Xl=t.return}}function ws(e){for(;null!==Xl;){var t=Xl;if(t===e){Xl=null;break}var n=t.sibling;if(null!==n){n.return=t.return,Xl=n;break}Xl=t.return}}function Es(e){for(;null!==Xl;){var t=Xl;try{switch(t.tag){case 0:case 11:case 15:var n=t.return;try{as(4,t)}catch(e){Su(t,n,e)}break;case 1:var r=t.stateNode;if("function"==typeof r.componentDidMount){var a=t.return;try{r.componentDidMount()}catch(e){Su(t,a,e)}}var o=t.return;try{os(t)}catch(e){Su(t,o,e)}break;case 5:var i=t.return;try{os(t)}catch(e){Su(t,i,e)}}}catch(e){Su(t,t.return,e)}if(t===e){Xl=null;break}var l=t.sibling;if(null!==l){l.return=t.return,Xl=l;break}Xl=t.return}}var xs,Ss=Math.ceil,Os=C.ReactCurrentDispatcher,Ls=C.ReactCurrentOwner,_s=C.ReactCurrentBatchConfig,Ps=0,Ns=null,Ms=null,As=0,Is=0,Fs=xa(0),Rs=0,Vs=null,js=0,zs=0,Ts=0,Hs=null,Ds=null,Bs=0,Us=1/0,Zs=null,Ws=!1,Gs=null,Ks=null,$s=!1,Js=null,Qs=0,qs=0,Ys=null,Xs=-1,eu=0;function tu(){return 0!=(6&Ps)?qe():-1!==Xs?Xs:Xs=qe()}function nu(e){return 0==(1&e.mode)?1:0!=(2&Ps)&&0!==As?As&-As:null!==go.transition?(0===eu&&(eu=mt()),eu):0!==(e=yt)?e:e=void 0===(e=window.event)?16:Qt(e.type)}function ru(e,t,n,r){if(50<qs)throw qs=0,Ys=null,Error(o(185));vt(e,n,r),0!=(2&Ps)&&e===Ns||(e===Ns&&(0==(2&Ps)&&(zs|=n),4===Rs&&su(e,As)),au(e,r),1===n&&0===Ps&&0==(1&t.mode)&&(Us=qe()+500,Ta&&Ba()))}function au(e,t){var n=e.callbackNode;!function(e,t){for(var n=e.suspendedLanes,r=e.pingedLanes,a=e.expirationTimes,o=e.pendingLanes;0<o;){var i=31-it(o),l=1<<i,s=a[i];-1===s?0!=(l&n)&&0==(l&r)||(a[i]=pt(l,t)):s<=t&&(e.expiredLanes|=l),o&=~l}}(e,t);var r=ft(e,e===Ns?As:0);if(0===r)null!==n&&$e(n),e.callbackNode=null,e.callbackPriority=0;else if(t=r&-r,e.callbackPriority!==t){if(null!=n&&$e(n),1===t)0===e.tag?function(e){Ta=!0,Da(e)}(uu.bind(null,e)):Da(uu.bind(null,e)),ia((function(){0==(6&Ps)&&Ba()})),n=null;else{switch(Ct(r)){case 1:n=Xe;break;case 4:n=et;break;case 16:default:n=tt;break;case 536870912:n=rt}n=Nu(n,ou.bind(null,e))}e.callbackPriority=t,e.callbackNode=n}}function ou(e,t){if(Xs=-1,eu=0,0!=(6&Ps))throw Error(o(327));var n=e.callbackNode;if(Eu()&&e.callbackNode!==n)return null;var r=ft(e,e===Ns?As:0);if(0===r)return null;if(0!=(30&r)||0!=(r&e.expiredLanes)||t)t=vu(e,r);else{t=r;var a=Ps;Ps|=2;var i=mu();for(Ns===e&&As===t||(Zs=null,Us=qe()+500,pu(e,t));;)try{yu();break}catch(t){hu(e,t)}wo(),Os.current=i,Ps=a,null!==Ms?t=0:(Ns=null,As=0,t=Rs)}if(0!==t){if(2===t&&(0!==(a=ht(e))&&(r=a,t=iu(e,a))),1===t)throw n=Vs,pu(e,0),su(e,r),au(e,qe()),n;if(6===t)su(e,r);else{if(a=e.current.alternate,0==(30&r)&&!function(e){for(var t=e;;){if(16384&t.flags){var n=t.updateQueue;if(null!==n&&null!==(n=n.stores))for(var r=0;r<n.length;r++){var a=n[r],o=a.getSnapshot;a=a.value;try{if(!lr(o(),a))return!1}catch(e){return!1}}}if(n=t.child,16384&t.subtreeFlags&&null!==n)n.return=t,t=n;else{if(t===e)break;for(;null===t.sibling;){if(null===t.return||t.return===e)return!0;t=t.return}t.sibling.return=t.return,t=t.sibling}}return!0}(a)&&(2===(t=vu(e,r))&&(0!==(i=ht(e))&&(r=i,t=iu(e,i))),1===t))throw n=Vs,pu(e,0),su(e,r),au(e,qe()),n;switch(e.finishedWork=a,e.finishedLanes=r,t){case 0:case 1:throw Error(o(345));case 2:case 5:wu(e,Ds,Zs);break;case 3:if(su(e,r),(130023424&r)===r&&10<(t=Bs+500-qe())){if(0!==ft(e,0))break;if(((a=e.suspendedLanes)&r)!==r){tu(),e.pingedLanes|=e.suspendedLanes&a;break}e.timeoutHandle=ra(wu.bind(null,e,Ds,Zs),t);break}wu(e,Ds,Zs);break;case 4:if(su(e,r),(4194240&r)===r)break;for(t=e.eventTimes,a=-1;0<r;){var l=31-it(r);i=1<<l,(l=t[l])>a&&(a=l),r&=~i}if(r=a,10<(r=(120>(r=qe()-r)?120:480>r?480:1080>r?1080:1920>r?1920:3e3>r?3e3:4320>r?4320:1960*Ss(r/1960))-r)){e.timeoutHandle=ra(wu.bind(null,e,Ds,Zs),r);break}wu(e,Ds,Zs);break;default:throw Error(o(329))}}}return au(e,qe()),e.callbackNode===n?ou.bind(null,e):null}function iu(e,t){var n=Hs;return e.current.memoizedState.isDehydrated&&(pu(e,t).flags|=256),2!==(e=vu(e,t))&&(t=Ds,Ds=n,null!==t&&lu(t)),e}function lu(e){null===Ds?Ds=e:Ds.push.apply(Ds,e)}function su(e,t){for(t&=~Ts,t&=~zs,e.suspendedLanes|=t,e.pingedLanes&=~t,e=e.expirationTimes;0<t;){var n=31-it(t),r=1<<n;e[n]=-1,t&=~r}}function uu(e){if(0!=(6&Ps))throw Error(o(327));Eu();var t=ft(e,0);if(0==(1&t))return au(e,qe()),null;var n=vu(e,t);if(0!==e.tag&&2===n){var r=ht(e);0!==r&&(t=r,n=iu(e,r))}if(1===n)throw n=Vs,pu(e,0),su(e,t),au(e,qe()),n;if(6===n)throw Error(o(345));return e.finishedWork=e.current.alternate,e.finishedLanes=t,wu(e,Ds,Zs),au(e,qe()),null}function cu(e,t){var n=Ps;Ps|=1;try{return e(t)}finally{0===(Ps=n)&&(Us=qe()+500,Ta&&Ba())}}function du(e){null!==Js&&0===Js.tag&&0==(6&Ps)&&Eu();var t=Ps;Ps|=1;var n=_s.transition,r=yt;try{if(_s.transition=null,yt=1,e)return e()}finally{yt=r,_s.transition=n,0==(6&(Ps=t))&&Ba()}}function fu(){Is=Fs.current,Sa(Fs)}function pu(e,t){e.finishedWork=null,e.finishedLanes=0;var n=e.timeoutHandle;if(-1!==n&&(e.timeoutHandle=-1,aa(n)),null!==Ms)for(n=Ms.return;null!==n;){var r=n;switch(to(r),r.tag){case 1:null!=(r=r.type.childContextTypes)&&Ia();break;case 3:oi(),Sa(Pa),Sa(_a),di();break;case 5:li(r);break;case 4:oi();break;case 13:case 19:Sa(si);break;case 10:Eo(r.type._context);break;case 22:case 23:fu()}n=n.return}if(Ns=e,Ms=e=Fu(e.current,null),As=Is=t,Rs=0,Vs=null,Ts=zs=js=0,Ds=Hs=null,null!==Lo){for(t=0;t<Lo.length;t++)if(null!==(r=(n=Lo[t]).interleaved)){n.interleaved=null;var a=r.next,o=n.pending;if(null!==o){var i=o.next;o.next=a,r.next=i}n.pending=r}Lo=null}return e}function hu(e,t){for(;;){var n=Ms;try{if(wo(),fi.current=il,bi){for(var r=mi.memoizedState;null!==r;){var a=r.queue;null!==a&&(a.pending=null),r=r.next}bi=!1}if(hi=0,vi=gi=mi=null,yi=!1,Ci=0,Ls.current=null,null===n||null===n.return){Rs=1,Vs=t,Ms=null;break}e:{var i=e,l=n.return,s=n,u=t;if(t=As,s.flags|=32768,null!==u&&"object"==typeof u&&"function"==typeof u.then){var c=u,d=s,f=d.tag;if(0==(1&d.mode)&&(0===f||11===f||15===f)){var p=d.alternate;p?(d.updateQueue=p.updateQueue,d.memoizedState=p.memoizedState,d.lanes=p.lanes):(d.updateQueue=null,d.memoizedState=null)}var h=vl(l);if(null!==h){h.flags&=-257,bl(h,l,s,0,t),1&h.mode&&gl(i,c,t),u=c;var m=(t=h).updateQueue;if(null===m){var g=new Set;g.add(u),t.updateQueue=g}else m.add(u);break e}if(0==(1&t)){gl(i,c,t),gu();break e}u=Error(o(426))}else if(ao&&1&s.mode){var v=vl(l);if(null!==v){0==(65536&v.flags)&&(v.flags|=256),bl(v,l,s,0,t),mo(cl(u,s));break e}}i=u=cl(u,s),4!==Rs&&(Rs=2),null===Hs?Hs=[i]:Hs.push(i),i=l;do{switch(i.tag){case 3:i.flags|=65536,t&=-t,i.lanes|=t,jo(i,hl(0,u,t));break e;case 1:s=u;var b=i.type,y=i.stateNode;if(0==(128&i.flags)&&("function"==typeof b.getDerivedStateFromError||null!==y&&"function"==typeof y.componentDidCatch&&(null===Ks||!Ks.has(y)))){i.flags|=65536,t&=-t,i.lanes|=t,jo(i,ml(i,s,t));break e}}i=i.return}while(null!==i)}ku(n)}catch(e){t=e,Ms===n&&null!==n&&(Ms=n=n.return);continue}break}}function mu(){var e=Os.current;return Os.current=il,null===e?il:e}function gu(){0!==Rs&&3!==Rs&&2!==Rs||(Rs=4),null===Ns||0==(268435455&js)&&0==(268435455&zs)||su(Ns,As)}function vu(e,t){var n=Ps;Ps|=2;var r=mu();for(Ns===e&&As===t||(Zs=null,pu(e,t));;)try{bu();break}catch(t){hu(e,t)}if(wo(),Ps=n,Os.current=r,null!==Ms)throw Error(o(261));return Ns=null,As=0,Rs}function bu(){for(;null!==Ms;)Cu(Ms)}function yu(){for(;null!==Ms&&!Je();)Cu(Ms)}function Cu(e){var t=xs(e.alternate,e,Is);e.memoizedProps=e.pendingProps,null===t?ku(e):Ms=t,Ls.current=null}function ku(e){var t=e;do{var n=t.alternate;if(e=t.return,0==(32768&t.flags)){if(null!==(n=$l(n,t,Is)))return void(Ms=n)}else{if(null!==(n=Jl(n,t)))return n.flags&=32767,void(Ms=n);if(null===e)return Rs=6,void(Ms=null);e.flags|=32768,e.subtreeFlags=0,e.deletions=null}if(null!==(t=t.sibling))return void(Ms=t);Ms=t=e}while(null!==t);0===Rs&&(Rs=5)}function wu(e,t,n){var r=yt,a=_s.transition;try{_s.transition=null,yt=1,function(e,t,n,r){do{Eu()}while(null!==Js);if(0!=(6&Ps))throw Error(o(327));n=e.finishedWork;var a=e.finishedLanes;if(null===n)return null;if(e.finishedWork=null,e.finishedLanes=0,n===e.current)throw Error(o(177));e.callbackNode=null,e.callbackPriority=0;var i=n.lanes|n.childLanes;if(function(e,t){var n=e.pendingLanes&~t;e.pendingLanes=t,e.suspendedLanes=0,e.pingedLanes=0,e.expiredLanes&=t,e.mutableReadLanes&=t,e.entangledLanes&=t,t=e.entanglements;var r=e.eventTimes;for(e=e.expirationTimes;0<n;){var a=31-it(n),o=1<<a;t[a]=0,r[a]=-1,e[a]=-1,n&=~o}}(e,i),e===Ns&&(Ms=Ns=null,As=0),0==(2064&n.subtreeFlags)&&0==(2064&n.flags)||$s||($s=!0,Nu(tt,(function(){return Eu(),null}))),i=0!=(15990&n.flags),0!=(15990&n.subtreeFlags)||i){i=_s.transition,_s.transition=null;var l=yt;yt=1;var s=Ps;Ps|=4,Ls.current=null,function(e,t){if(ea=Zt,pr(e=fr())){if("selectionStart"in e)var n={start:e.selectionStart,end:e.selectionEnd};else e:{var r=(n=(n=e.ownerDocument)&&n.defaultView||window).getSelection&&n.getSelection();if(r&&0!==r.rangeCount){n=r.anchorNode;var a=r.anchorOffset,i=r.focusNode;r=r.focusOffset;try{n.nodeType,i.nodeType}catch(e){n=null;break e}var l=0,s=-1,u=-1,c=0,d=0,f=e,p=null;t:for(;;){for(var h;f!==n||0!==a&&3!==f.nodeType||(s=l+a),f!==i||0!==r&&3!==f.nodeType||(u=l+r),3===f.nodeType&&(l+=f.nodeValue.length),null!==(h=f.firstChild);)p=f,f=h;for(;;){if(f===e)break t;if(p===n&&++c===a&&(s=l),p===i&&++d===r&&(u=l),null!==(h=f.nextSibling))break;p=(f=p).parentNode}f=h}n=-1===s||-1===u?null:{start:s,end:u}}else n=null}n=n||{start:0,end:0}}else n=null;for(ta={focusedElem:e,selectionRange:n},Zt=!1,Xl=t;null!==Xl;)if(e=(t=Xl).child,0!=(1028&t.subtreeFlags)&&null!==e)e.return=t,Xl=e;else for(;null!==Xl;){t=Xl;try{var m=t.alternate;if(0!=(1024&t.flags))switch(t.tag){case 0:case 11:case 15:case 5:case 6:case 4:case 17:break;case 1:if(null!==m){var g=m.memoizedProps,v=m.memoizedState,b=t.stateNode,y=b.getSnapshotBeforeUpdate(t.elementType===t.type?g:vo(t.type,g),v);b.__reactInternalSnapshotBeforeUpdate=y}break;case 3:var C=t.stateNode.containerInfo;1===C.nodeType?C.textContent="":9===C.nodeType&&C.documentElement&&C.removeChild(C.documentElement);break;default:throw Error(o(163))}}catch(e){Su(t,t.return,e)}if(null!==(e=t.sibling)){e.return=t.return,Xl=e;break}Xl=t.return}m=ns,ns=!1}(e,n),vs(n,e),hr(ta),Zt=!!ea,ta=ea=null,e.current=n,ys(n,e,a),Qe(),Ps=s,yt=l,_s.transition=i}else e.current=n;if($s&&($s=!1,Js=e,Qs=a),i=e.pendingLanes,0===i&&(Ks=null),function(e){if(ot&&"function"==typeof ot.onCommitFiberRoot)try{ot.onCommitFiberRoot(at,e,void 0,128==(128&e.current.flags))}catch(e){}}(n.stateNode),au(e,qe()),null!==t)for(r=e.onRecoverableError,n=0;n<t.length;n++)a=t[n],r(a.value,{componentStack:a.stack,digest:a.digest});if(Ws)throw Ws=!1,e=Gs,Gs=null,e;0!=(1&Qs)&&0!==e.tag&&Eu(),i=e.pendingLanes,0!=(1&i)?e===Ys?qs++:(qs=0,Ys=e):qs=0,Ba()}(e,t,n,r)}finally{_s.transition=a,yt=r}return null}function Eu(){if(null!==Js){var e=Ct(Qs),t=_s.transition,n=yt;try{if(_s.transition=null,yt=16>e?16:e,null===Js)var r=!1;else{if(e=Js,Js=null,Qs=0,0!=(6&Ps))throw Error(o(331));var a=Ps;for(Ps|=4,Xl=e.current;null!==Xl;){var i=Xl,l=i.child;if(0!=(16&Xl.flags)){var s=i.deletions;if(null!==s){for(var u=0;u<s.length;u++){var c=s[u];for(Xl=c;null!==Xl;){var d=Xl;switch(d.tag){case 0:case 11:case 15:rs(8,d,i)}var f=d.child;if(null!==f)f.return=d,Xl=f;else for(;null!==Xl;){var p=(d=Xl).sibling,h=d.return;if(is(d),d===c){Xl=null;break}if(null!==p){p.return=h,Xl=p;break}Xl=h}}}var m=i.alternate;if(null!==m){var g=m.child;if(null!==g){m.child=null;do{var v=g.sibling;g.sibling=null,g=v}while(null!==g)}}Xl=i}}if(0!=(2064&i.subtreeFlags)&&null!==l)l.return=i,Xl=l;else e:for(;null!==Xl;){if(0!=(2048&(i=Xl).flags))switch(i.tag){case 0:case 11:case 15:rs(9,i,i.return)}var b=i.sibling;if(null!==b){b.return=i.return,Xl=b;break e}Xl=i.return}}var y=e.current;for(Xl=y;null!==Xl;){var C=(l=Xl).child;if(0!=(2064&l.subtreeFlags)&&null!==C)C.return=l,Xl=C;else e:for(l=y;null!==Xl;){if(0!=(2048&(s=Xl).flags))try{switch(s.tag){case 0:case 11:case 15:as(9,s)}}catch(e){Su(s,s.return,e)}if(s===l){Xl=null;break e}var k=s.sibling;if(null!==k){k.return=s.return,Xl=k;break e}Xl=s.return}}if(Ps=a,Ba(),ot&&"function"==typeof ot.onPostCommitFiberRoot)try{ot.onPostCommitFiberRoot(at,e)}catch(e){}r=!0}return r}finally{yt=n,_s.transition=t}}return!1}function xu(e,t,n){e=Ro(e,t=hl(0,t=cl(n,t),1),1),t=tu(),null!==e&&(vt(e,1,t),au(e,t))}function Su(e,t,n){if(3===e.tag)xu(e,e,n);else for(;null!==t;){if(3===t.tag){xu(t,e,n);break}if(1===t.tag){var r=t.stateNode;if("function"==typeof t.type.getDerivedStateFromError||"function"==typeof r.componentDidCatch&&(null===Ks||!Ks.has(r))){t=Ro(t,e=ml(t,e=cl(n,e),1),1),e=tu(),null!==t&&(vt(t,1,e),au(t,e));break}}t=t.return}}function Ou(e,t,n){var r=e.pingCache;null!==r&&r.delete(t),t=tu(),e.pingedLanes|=e.suspendedLanes&n,Ns===e&&(As&n)===n&&(4===Rs||3===Rs&&(130023424&As)===As&&500>qe()-Bs?pu(e,0):Ts|=n),au(e,t)}function Lu(e,t){0===t&&(0==(1&e.mode)?t=1:(t=ct,0==(130023424&(ct<<=1))&&(ct=4194304)));var n=tu();null!==(e=No(e,t))&&(vt(e,t,n),au(e,n))}function _u(e){var t=e.memoizedState,n=0;null!==t&&(n=t.retryLane),Lu(e,n)}function Pu(e,t){var n=0;switch(e.tag){case 13:var r=e.stateNode,a=e.memoizedState;null!==a&&(n=a.retryLane);break;case 19:r=e.stateNode;break;default:throw Error(o(314))}null!==r&&r.delete(t),Lu(e,n)}function Nu(e,t){return Ke(e,t)}function Mu(e,t,n,r){this.tag=e,this.key=n,this.sibling=this.child=this.return=this.stateNode=this.type=this.elementType=null,this.index=0,this.ref=null,this.pendingProps=t,this.dependencies=this.memoizedState=this.updateQueue=this.memoizedProps=null,this.mode=r,this.subtreeFlags=this.flags=0,this.deletions=null,this.childLanes=this.lanes=0,this.alternate=null}function Au(e,t,n,r){return new Mu(e,t,n,r)}function Iu(e){return!(!(e=e.prototype)||!e.isReactComponent)}function Fu(e,t){var n=e.alternate;return null===n?((n=Au(e.tag,t,e.key,e.mode)).elementType=e.elementType,n.type=e.type,n.stateNode=e.stateNode,n.alternate=e,e.alternate=n):(n.pendingProps=t,n.type=e.type,n.flags=0,n.subtreeFlags=0,n.deletions=null),n.flags=14680064&e.flags,n.childLanes=e.childLanes,n.lanes=e.lanes,n.child=e.child,n.memoizedProps=e.memoizedProps,n.memoizedState=e.memoizedState,n.updateQueue=e.updateQueue,t=e.dependencies,n.dependencies=null===t?null:{lanes:t.lanes,firstContext:t.firstContext},n.sibling=e.sibling,n.index=e.index,n.ref=e.ref,n}function Ru(e,t,n,r,a,i){var l=2;if(r=e,"function"==typeof e)Iu(e)&&(l=1);else if("string"==typeof e)l=5;else e:switch(e){case E:return Vu(n.children,a,i,t);case x:l=8,a|=8;break;case S:return(e=Au(12,n,t,2|a)).elementType=S,e.lanes=i,e;case P:return(e=Au(13,n,t,a)).elementType=P,e.lanes=i,e;case N:return(e=Au(19,n,t,a)).elementType=N,e.lanes=i,e;case I:return ju(n,a,i,t);default:if("object"==typeof e&&null!==e)switch(e.$$typeof){case O:l=10;break e;case L:l=9;break e;case _:l=11;break e;case M:l=14;break e;case A:l=16,r=null;break e}throw Error(o(130,null==e?e:typeof e,""))}return(t=Au(l,n,t,a)).elementType=e,t.type=r,t.lanes=i,t}function Vu(e,t,n,r){return(e=Au(7,e,r,t)).lanes=n,e}function ju(e,t,n,r){return(e=Au(22,e,r,t)).elementType=I,e.lanes=n,e.stateNode={isHidden:!1},e}function zu(e,t,n){return(e=Au(6,e,null,t)).lanes=n,e}function Tu(e,t,n){return(t=Au(4,null!==e.children?e.children:[],e.key,t)).lanes=n,t.stateNode={containerInfo:e.containerInfo,pendingChildren:null,implementation:e.implementation},t}function Hu(e,t,n,r,a){this.tag=t,this.containerInfo=e,this.finishedWork=this.pingCache=this.current=this.pendingChildren=null,this.timeoutHandle=-1,this.callbackNode=this.pendingContext=this.context=null,this.callbackPriority=0,this.eventTimes=gt(0),this.expirationTimes=gt(-1),this.entangledLanes=this.finishedLanes=this.mutableReadLanes=this.expiredLanes=this.pingedLanes=this.suspendedLanes=this.pendingLanes=0,this.entanglements=gt(0),this.identifierPrefix=r,this.onRecoverableError=a,this.mutableSourceEagerHydrationData=null}function Du(e,t,n,r,a,o,i,l,s){return e=new Hu(e,t,n,l,s),1===t?(t=1,!0===o&&(t|=8)):t=0,o=Au(3,null,null,t),e.current=o,o.stateNode=e,o.memoizedState={element:r,isDehydrated:n,cache:null,transitions:null,pendingSuspenseBoundaries:null},Ao(o),e}function Bu(e){if(!e)return La;e:{if(Be(e=e._reactInternals)!==e||1!==e.tag)throw Error(o(170));var t=e;do{switch(t.tag){case 3:t=t.stateNode.context;break e;case 1:if(Aa(t.type)){t=t.stateNode.__reactInternalMemoizedMergedChildContext;break e}}t=t.return}while(null!==t);throw Error(o(171))}if(1===e.tag){var n=e.type;if(Aa(n))return Ra(e,n,t)}return t}function Uu(e,t,n,r,a,o,i,l,s){return(e=Du(n,r,!0,e,0,o,0,l,s)).context=Bu(null),n=e.current,(o=Fo(r=tu(),a=nu(n))).callback=null!=t?t:null,Ro(n,o,a),e.current.lanes=a,vt(e,a,r),au(e,r),e}function Zu(e,t,n,r){var a=t.current,o=tu(),i=nu(a);return n=Bu(n),null===t.context?t.context=n:t.pendingContext=n,(t=Fo(o,i)).payload={element:e},null!==(r=void 0===r?null:r)&&(t.callback=r),null!==(e=Ro(a,t,i))&&(ru(e,a,i,o),Vo(e,a,i)),i}function Wu(e){return(e=e.current).child?(e.child.tag,e.child.stateNode):null}function Gu(e,t){if(null!==(e=e.memoizedState)&&null!==e.dehydrated){var n=e.retryLane;e.retryLane=0!==n&&n<t?n:t}}function Ku(e,t){Gu(e,t),(e=e.alternate)&&Gu(e,t)}xs=function(e,t,n){if(null!==e)if(e.memoizedProps!==t.pendingProps||Pa.current)Cl=!0;else{if(0==(e.lanes&n)&&0==(128&t.flags))return Cl=!1,function(e,t,n){switch(t.tag){case 3:Nl(t),ho();break;case 5:ii(t);break;case 1:Aa(t.type)&&Va(t);break;case 4:ai(t,t.stateNode.containerInfo);break;case 10:var r=t.type._context,a=t.memoizedProps.value;Oa(bo,r._currentValue),r._currentValue=a;break;case 13:if(null!==(r=t.memoizedState))return null!==r.dehydrated?(Oa(si,1&si.current),t.flags|=128,null):0!=(n&t.child.childLanes)?zl(e,t,n):(Oa(si,1&si.current),null!==(e=Wl(e,t,n))?e.sibling:null);Oa(si,1&si.current);break;case 19:if(r=0!=(n&t.childLanes),0!=(128&e.flags)){if(r)return Ul(e,t,n);t.flags|=128}if(null!==(a=t.memoizedState)&&(a.rendering=null,a.tail=null,a.lastEffect=null),Oa(si,si.current),r)break;return null;case 22:case 23:return t.lanes=0,Sl(e,t,n)}return Wl(e,t,n)}(e,t,n);Cl=0!=(131072&e.flags)}else Cl=!1,ao&&0!=(1048576&t.flags)&&Xa(t,Ga,t.index);switch(t.lanes=0,t.tag){case 2:var r=t.type;Zl(e,t),e=t.pendingProps;var a=Ma(t,_a.current);So(t,n),a=xi(null,t,r,e,a,n);var i=Si();return t.flags|=1,"object"==typeof a&&null!==a&&"function"==typeof a.render&&void 0===a.$$typeof?(t.tag=1,t.memoizedState=null,t.updateQueue=null,Aa(r)?(i=!0,Va(t)):i=!1,t.memoizedState=null!==a.state&&void 0!==a.state?a.state:null,Ao(t),a.updater=Bo,t.stateNode=a,a._reactInternals=t,Go(t,r,e,n),t=Pl(null,t,r,!0,i,n)):(t.tag=0,ao&&i&&eo(t),kl(null,t,a,n),t=t.child),t;case 16:r=t.elementType;e:{switch(Zl(e,t),e=t.pendingProps,r=(a=r._init)(r._payload),t.type=r,a=t.tag=function(e){if("function"==typeof e)return Iu(e)?1:0;if(null!=e){if((e=e.$$typeof)===_)return 11;if(e===M)return 14}return 2}(r),e=vo(r,e),a){case 0:t=Ll(null,t,r,e,n);break e;case 1:t=_l(null,t,r,e,n);break e;case 11:t=wl(null,t,r,e,n);break e;case 14:t=El(null,t,r,vo(r.type,e),n);break e}throw Error(o(306,r,""))}return t;case 0:return r=t.type,a=t.pendingProps,Ll(e,t,r,a=t.elementType===r?a:vo(r,a),n);case 1:return r=t.type,a=t.pendingProps,_l(e,t,r,a=t.elementType===r?a:vo(r,a),n);case 3:e:{if(Nl(t),null===e)throw Error(o(387));r=t.pendingProps,a=(i=t.memoizedState).element,Io(e,t),zo(t,r,null,n);var l=t.memoizedState;if(r=l.element,i.isDehydrated){if(i={element:r,isDehydrated:!1,cache:l.cache,pendingSuspenseBoundaries:l.pendingSuspenseBoundaries,transitions:l.transitions},t.updateQueue.baseState=i,t.memoizedState=i,256&t.flags){t=Ml(e,t,r,n,a=cl(Error(o(423)),t));break e}if(r!==a){t=Ml(e,t,r,n,a=cl(Error(o(424)),t));break e}for(ro=ua(t.stateNode.containerInfo.firstChild),no=t,ao=!0,oo=null,n=Yo(t,null,r,n),t.child=n;n;)n.flags=-3&n.flags|4096,n=n.sibling}else{if(ho(),r===a){t=Wl(e,t,n);break e}kl(e,t,r,n)}t=t.child}return t;case 5:return ii(t),null===e&&uo(t),r=t.type,a=t.pendingProps,i=null!==e?e.memoizedProps:null,l=a.children,na(r,a)?l=null:null!==i&&na(r,i)&&(t.flags|=32),Ol(e,t),kl(e,t,l,n),t.child;case 6:return null===e&&uo(t),null;case 13:return zl(e,t,n);case 4:return ai(t,t.stateNode.containerInfo),r=t.pendingProps,null===e?t.child=qo(t,null,r,n):kl(e,t,r,n),t.child;case 11:return r=t.type,a=t.pendingProps,wl(e,t,r,a=t.elementType===r?a:vo(r,a),n);case 7:return kl(e,t,t.pendingProps,n),t.child;case 8:case 12:return kl(e,t,t.pendingProps.children,n),t.child;case 10:e:{if(r=t.type._context,a=t.pendingProps,i=t.memoizedProps,l=a.value,Oa(bo,r._currentValue),r._currentValue=l,null!==i)if(lr(i.value,l)){if(i.children===a.children&&!Pa.current){t=Wl(e,t,n);break e}}else for(null!==(i=t.child)&&(i.return=t);null!==i;){var s=i.dependencies;if(null!==s){l=i.child;for(var u=s.firstContext;null!==u;){if(u.context===r){if(1===i.tag){(u=Fo(-1,n&-n)).tag=2;var c=i.updateQueue;if(null!==c){var d=(c=c.shared).pending;null===d?u.next=u:(u.next=d.next,d.next=u),c.pending=u}}i.lanes|=n,null!==(u=i.alternate)&&(u.lanes|=n),xo(i.return,n,t),s.lanes|=n;break}u=u.next}}else if(10===i.tag)l=i.type===t.type?null:i.child;else if(18===i.tag){if(null===(l=i.return))throw Error(o(341));l.lanes|=n,null!==(s=l.alternate)&&(s.lanes|=n),xo(l,n,t),l=i.sibling}else l=i.child;if(null!==l)l.return=i;else for(l=i;null!==l;){if(l===t){l=null;break}if(null!==(i=l.sibling)){i.return=l.return,l=i;break}l=l.return}i=l}kl(e,t,a.children,n),t=t.child}return t;case 9:return a=t.type,r=t.pendingProps.children,So(t,n),r=r(a=Oo(a)),t.flags|=1,kl(e,t,r,n),t.child;case 14:return a=vo(r=t.type,t.pendingProps),El(e,t,r,a=vo(r.type,a),n);case 15:return xl(e,t,t.type,t.pendingProps,n);case 17:return r=t.type,a=t.pendingProps,a=t.elementType===r?a:vo(r,a),Zl(e,t),t.tag=1,Aa(r)?(e=!0,Va(t)):e=!1,So(t,n),Zo(t,r,a),Go(t,r,a,n),Pl(null,t,r,!0,e,n);case 19:return Ul(e,t,n);case 22:return Sl(e,t,n)}throw Error(o(156,t.tag))};var $u="function"==typeof reportError?reportError:function(e){console.error(e)};function Ju(e){this._internalRoot=e}function Qu(e){this._internalRoot=e}function qu(e){return!(!e||1!==e.nodeType&&9!==e.nodeType&&11!==e.nodeType)}function Yu(e){return!(!e||1!==e.nodeType&&9!==e.nodeType&&11!==e.nodeType&&(8!==e.nodeType||" react-mount-point-unstable "!==e.nodeValue))}function Xu(){}function ec(e,t,n,r,a){var o=n._reactRootContainer;if(o){var i=o;if("function"==typeof a){var l=a;a=function(){var e=Wu(i);l.call(e)}}Zu(t,i,e,a)}else i=function(e,t,n,r,a){if(a){if("function"==typeof r){var o=r;r=function(){var e=Wu(i);o.call(e)}}var i=Uu(t,r,e,0,null,!1,0,"",Xu);return e._reactRootContainer=i,e[ha]=i.current,Br(8===e.nodeType?e.parentNode:e),du(),i}for(;a=e.lastChild;)e.removeChild(a);if("function"==typeof r){var l=r;r=function(){var e=Wu(s);l.call(e)}}var s=Du(e,0,!1,null,0,!1,0,"",Xu);return e._reactRootContainer=s,e[ha]=s.current,Br(8===e.nodeType?e.parentNode:e),du((function(){Zu(t,s,n,r)})),s}(n,t,e,a,r);return Wu(i)}Qu.prototype.render=Ju.prototype.render=function(e){var t=this._internalRoot;if(null===t)throw Error(o(409));Zu(e,t,null,null)},Qu.prototype.unmount=Ju.prototype.unmount=function(){var e=this._internalRoot;if(null!==e){this._internalRoot=null;var t=e.containerInfo;du((function(){Zu(null,e,null,null)})),t[ha]=null}},Qu.prototype.unstable_scheduleHydration=function(e){if(e){var t=xt();e={blockedOn:null,target:e,priority:t};for(var n=0;n<It.length&&0!==t&&t<It[n].priority;n++);It.splice(n,0,e),0===n&&jt(e)}},kt=function(e){switch(e.tag){case 3:var t=e.stateNode;if(t.current.memoizedState.isDehydrated){var n=dt(t.pendingLanes);0!==n&&(bt(t,1|n),au(t,qe()),0==(6&Ps)&&(Us=qe()+500,Ba()))}break;case 13:du((function(){var t=No(e,1);if(null!==t){var n=tu();ru(t,e,1,n)}})),Ku(e,1)}},wt=function(e){if(13===e.tag){var t=No(e,134217728);if(null!==t)ru(t,e,134217728,tu());Ku(e,134217728)}},Et=function(e){if(13===e.tag){var t=nu(e),n=No(e,t);if(null!==n)ru(n,e,t,tu());Ku(e,t)}},xt=function(){return yt},St=function(e,t){var n=yt;try{return yt=e,t()}finally{yt=n}},we=function(e,t,n){switch(t){case"input":if(Y(e,n),t=n.name,"radio"===n.type&&null!=t){for(n=e;n.parentNode;)n=n.parentNode;for(n=n.querySelectorAll("input[name="+JSON.stringify(""+t)+'][type="radio"]'),t=0;t<n.length;t++){var r=n[t];if(r!==e&&r.form===e.form){var a=ka(r);if(!a)throw Error(o(90));K(r),Y(r,a)}}}break;case"textarea":oe(e,n);break;case"select":null!=(t=n.value)&&ne(e,!!n.multiple,t,!1)}},_e=cu,Pe=du;var tc={usingClientEntryPoint:!1,Events:[ya,Ca,ka,Oe,Le,cu]},nc={findFiberByHostInstance:ba,bundleType:0,version:"18.2.0",rendererPackageName:"react-dom"},rc={bundleType:nc.bundleType,version:nc.version,rendererPackageName:nc.rendererPackageName,rendererConfig:nc.rendererConfig,overrideHookState:null,overrideHookStateDeletePath:null,overrideHookStateRenamePath:null,overrideProps:null,overridePropsDeletePath:null,overridePropsRenamePath:null,setErrorHandler:null,setSuspenseHandler:null,scheduleUpdate:null,currentDispatcherRef:C.ReactCurrentDispatcher,findHostInstanceByFiber:function(e){return null===(e=We(e))?null:e.stateNode},findFiberByHostInstance:nc.findFiberByHostInstance||function(){return null},findHostInstancesForRefresh:null,scheduleRefresh:null,scheduleRoot:null,setRefreshHandler:null,getCurrentFiber:null,reconcilerVersion:"18.2.0-next-9e3b772b8-20220608"};if("undefined"!=typeof __REACT_DEVTOOLS_GLOBAL_HOOK__){var ac=__REACT_DEVTOOLS_GLOBAL_HOOK__;if(!ac.isDisabled&&ac.supportsFiber)try{at=ac.inject(rc),ot=ac}catch(ce){}}t.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED=tc,t.createPortal=function(e,t){var n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null;if(!qu(t))throw Error(o(200));return function(e,t,n){var r=3<arguments.length&&void 0!==arguments[3]?arguments[3]:null;return{$$typeof:w,key:null==r?null:""+r,children:e,containerInfo:t,implementation:n}}(e,t,null,n)},t.createRoot=function(e,t){if(!qu(e))throw Error(o(299));var n=!1,r="",a=$u;return null!=t&&(!0===t.unstable_strictMode&&(n=!0),void 0!==t.identifierPrefix&&(r=t.identifierPrefix),void 0!==t.onRecoverableError&&(a=t.onRecoverableError)),t=Du(e,1,!1,null,0,n,0,r,a),e[ha]=t.current,Br(8===e.nodeType?e.parentNode:e),new Ju(t)},t.findDOMNode=function(e){if(null==e)return null;if(1===e.nodeType)return e;var t=e._reactInternals;if(void 0===t){if("function"==typeof e.render)throw Error(o(188));throw e=Object.keys(e).join(","),Error(o(268,e))}return e=null===(e=We(t))?null:e.stateNode},t.flushSync=function(e){return du(e)},t.hydrate=function(e,t,n){if(!Yu(t))throw Error(o(200));return ec(null,e,t,!0,n)},t.hydrateRoot=function(e,t,n){if(!qu(e))throw Error(o(405));var r=null!=n&&n.hydratedSources||null,a=!1,i="",l=$u;if(null!=n&&(!0===n.unstable_strictMode&&(a=!0),void 0!==n.identifierPrefix&&(i=n.identifierPrefix),void 0!==n.onRecoverableError&&(l=n.onRecoverableError)),t=Uu(t,null,e,1,null!=n?n:null,a,0,i,l),e[ha]=t.current,Br(e),r)for(e=0;e<r.length;e++)a=(a=(n=r[e])._getVersion)(n._source),null==t.mutableSourceEagerHydrationData?t.mutableSourceEagerHydrationData=[n,a]:t.mutableSourceEagerHydrationData.push(n,a);return new Qu(t)},t.render=function(e,t,n){if(!Yu(t))throw Error(o(200));return ec(null,e,t,!1,n)},t.unmountComponentAtNode=function(e){if(!Yu(e))throw Error(o(40));return!!e._reactRootContainer&&(du((function(){ec(null,null,e,!1,(function(){e._reactRootContainer=null,e[ha]=null}))})),!0)},t.unstable_batchedUpdates=cu,t.unstable_renderSubtreeIntoContainer=function(e,t,n,r){if(!Yu(n))throw Error(o(200));if(null==e||void 0===e._reactInternals)throw Error(o(38));return ec(e,t,n,!1,r)},t.version="18.2.0-next-9e3b772b8-20220608"},745:(e,t,n)=>{"use strict";var r=n(935);t.s=r.createRoot,r.hydrateRoot},935:(e,t,n)=>{"use strict";!function e(){if("undefined"!=typeof __REACT_DEVTOOLS_GLOBAL_HOOK__&&"function"==typeof __REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE)try{__REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE(e)}catch(e){console.error(e)}}(),e.exports=n(448)},408:(e,t)=>{"use strict";var n=Symbol.for("react.element"),r=Symbol.for("react.portal"),a=Symbol.for("react.fragment"),o=Symbol.for("react.strict_mode"),i=Symbol.for("react.profiler"),l=Symbol.for("react.provider"),s=Symbol.for("react.context"),u=Symbol.for("react.forward_ref"),c=Symbol.for("react.suspense"),d=Symbol.for("react.memo"),f=Symbol.for("react.lazy"),p=Symbol.iterator;var h={isMounted:function(){return!1},enqueueForceUpdate:function(){},enqueueReplaceState:function(){},enqueueSetState:function(){}},m=Object.assign,g={};function v(e,t,n){this.props=e,this.context=t,this.refs=g,this.updater=n||h}function b(){}function y(e,t,n){this.props=e,this.context=t,this.refs=g,this.updater=n||h}v.prototype.isReactComponent={},v.prototype.setState=function(e,t){if("object"!=typeof e&&"function"!=typeof e&&null!=e)throw Error("setState(...): takes an object of state variables to update or a function which returns an object of state variables.");this.updater.enqueueSetState(this,e,t,"setState")},v.prototype.forceUpdate=function(e){this.updater.enqueueForceUpdate(this,e,"forceUpdate")},b.prototype=v.prototype;var C=y.prototype=new b;C.constructor=y,m(C,v.prototype),C.isPureReactComponent=!0;var k=Array.isArray,w=Object.prototype.hasOwnProperty,E={current:null},x={key:!0,ref:!0,__self:!0,__source:!0};function S(e,t,r){var a,o={},i=null,l=null;if(null!=t)for(a in void 0!==t.ref&&(l=t.ref),void 0!==t.key&&(i=""+t.key),t)w.call(t,a)&&!x.hasOwnProperty(a)&&(o[a]=t[a]);var s=arguments.length-2;if(1===s)o.children=r;else if(1<s){for(var u=Array(s),c=0;c<s;c++)u[c]=arguments[c+2];o.children=u}if(e&&e.defaultProps)for(a in s=e.defaultProps)void 0===o[a]&&(o[a]=s[a]);return{$$typeof:n,type:e,key:i,ref:l,props:o,_owner:E.current}}function O(e){return"object"==typeof e&&null!==e&&e.$$typeof===n}var L=/\/+/g;function _(e,t){return"object"==typeof e&&null!==e&&null!=e.key?function(e){var t={"=":"=0",":":"=2"};return"$"+e.replace(/[=:]/g,(function(e){return t[e]}))}(""+e.key):t.toString(36)}function P(e,t,a,o,i){var l=typeof e;"undefined"!==l&&"boolean"!==l||(e=null);var s=!1;if(null===e)s=!0;else switch(l){case"string":case"number":s=!0;break;case"object":switch(e.$$typeof){case n:case r:s=!0}}if(s)return i=i(s=e),e=""===o?"."+_(s,0):o,k(i)?(a="",null!=e&&(a=e.replace(L,"$&/")+"/"),P(i,t,a,"",(function(e){return e}))):null!=i&&(O(i)&&(i=function(e,t){return{$$typeof:n,type:e.type,key:t,ref:e.ref,props:e.props,_owner:e._owner}}(i,a+(!i.key||s&&s.key===i.key?"":(""+i.key).replace(L,"$&/")+"/")+e)),t.push(i)),1;if(s=0,o=""===o?".":o+":",k(e))for(var u=0;u<e.length;u++){var c=o+_(l=e[u],u);s+=P(l,t,a,c,i)}else if(c=function(e){return null===e||"object"!=typeof e?null:"function"==typeof(e=p&&e[p]||e["@@iterator"])?e:null}(e),"function"==typeof c)for(e=c.call(e),u=0;!(l=e.next()).done;)s+=P(l=l.value,t,a,c=o+_(l,u++),i);else if("object"===l)throw t=String(e),Error("Objects are not valid as a React child (found: "+("[object Object]"===t?"object with keys {"+Object.keys(e).join(", ")+"}":t)+"). If you meant to render a collection of children, use an array instead.");return s}function N(e,t,n){if(null==e)return e;var r=[],a=0;return P(e,r,"","",(function(e){return t.call(n,e,a++)})),r}function M(e){if(-1===e._status){var t=e._result;(t=t()).then((function(t){0!==e._status&&-1!==e._status||(e._status=1,e._result=t)}),(function(t){0!==e._status&&-1!==e._status||(e._status=2,e._result=t)})),-1===e._status&&(e._status=0,e._result=t)}if(1===e._status)return e._result.default;throw e._result}var A={current:null},I={transition:null},F={ReactCurrentDispatcher:A,ReactCurrentBatchConfig:I,ReactCurrentOwner:E};t.Children={map:N,forEach:function(e,t,n){N(e,(function(){t.apply(this,arguments)}),n)},count:function(e){var t=0;return N(e,(function(){t++})),t},toArray:function(e){return N(e,(function(e){return e}))||[]},only:function(e){if(!O(e))throw Error("React.Children.only expected to receive a single React element child.");return e}},t.Component=v,t.Fragment=a,t.Profiler=i,t.PureComponent=y,t.StrictMode=o,t.Suspense=c,t.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED=F,t.cloneElement=function(e,t,r){if(null==e)throw Error("React.cloneElement(...): The argument must be a React element, but you passed "+e+".");var a=m({},e.props),o=e.key,i=e.ref,l=e._owner;if(null!=t){if(void 0!==t.ref&&(i=t.ref,l=E.current),void 0!==t.key&&(o=""+t.key),e.type&&e.type.defaultProps)var s=e.type.defaultProps;for(u in t)w.call(t,u)&&!x.hasOwnProperty(u)&&(a[u]=void 0===t[u]&&void 0!==s?s[u]:t[u])}var u=arguments.length-2;if(1===u)a.children=r;else if(1<u){s=Array(u);for(var c=0;c<u;c++)s[c]=arguments[c+2];a.children=s}return{$$typeof:n,type:e.type,key:o,ref:i,props:a,_owner:l}},t.createContext=function(e){return(e={$$typeof:s,_currentValue:e,_currentValue2:e,_threadCount:0,Provider:null,Consumer:null,_defaultValue:null,_globalName:null}).Provider={$$typeof:l,_context:e},e.Consumer=e},t.createElement=S,t.createFactory=function(e){var t=S.bind(null,e);return t.type=e,t},t.createRef=function(){return{current:null}},t.forwardRef=function(e){return{$$typeof:u,render:e}},t.isValidElement=O,t.lazy=function(e){return{$$typeof:f,_payload:{_status:-1,_result:e},_init:M}},t.memo=function(e,t){return{$$typeof:d,type:e,compare:void 0===t?null:t}},t.startTransition=function(e){var t=I.transition;I.transition={};try{e()}finally{I.transition=t}},t.unstable_act=function(){throw Error("act(...) is not supported in production builds of React.")},t.useCallback=function(e,t){return A.current.useCallback(e,t)},t.useContext=function(e){return A.current.useContext(e)},t.useDebugValue=function(){},t.useDeferredValue=function(e){return A.current.useDeferredValue(e)},t.useEffect=function(e,t){return A.current.useEffect(e,t)},t.useId=function(){return A.current.useId()},t.useImperativeHandle=function(e,t,n){return A.current.useImperativeHandle(e,t,n)},t.useInsertionEffect=function(e,t){return A.current.useInsertionEffect(e,t)},t.useLayoutEffect=function(e,t){return A.current.useLayoutEffect(e,t)},t.useMemo=function(e,t){return A.current.useMemo(e,t)},t.useReducer=function(e,t,n){return A.current.useReducer(e,t,n)},t.useRef=function(e){return A.current.useRef(e)},t.useState=function(e){return A.current.useState(e)},t.useSyncExternalStore=function(e,t,n){return A.current.useSyncExternalStore(e,t,n)},t.useTransition=function(){return A.current.useTransition()},t.version="18.2.0"},294:(e,t,n)=>{"use strict";e.exports=n(408)},53:(e,t)=>{"use strict";function n(e,t){var n=e.length;e.push(t);e:for(;0<n;){var r=n-1>>>1,a=e[r];if(!(0<o(a,t)))break e;e[r]=t,e[n]=a,n=r}}function r(e){return 0===e.length?null:e[0]}function a(e){if(0===e.length)return null;var t=e[0],n=e.pop();if(n!==t){e[0]=n;e:for(var r=0,a=e.length,i=a>>>1;r<i;){var l=2*(r+1)-1,s=e[l],u=l+1,c=e[u];if(0>o(s,n))u<a&&0>o(c,s)?(e[r]=c,e[u]=n,r=u):(e[r]=s,e[l]=n,r=l);else{if(!(u<a&&0>o(c,n)))break e;e[r]=c,e[u]=n,r=u}}}return t}function o(e,t){var n=e.sortIndex-t.sortIndex;return 0!==n?n:e.id-t.id}if("object"==typeof performance&&"function"==typeof performance.now){var i=performance;t.unstable_now=function(){return i.now()}}else{var l=Date,s=l.now();t.unstable_now=function(){return l.now()-s}}var u=[],c=[],d=1,f=null,p=3,h=!1,m=!1,g=!1,v="function"==typeof setTimeout?setTimeout:null,b="function"==typeof clearTimeout?clearTimeout:null,y="undefined"!=typeof setImmediate?setImmediate:null;function C(e){for(var t=r(c);null!==t;){if(null===t.callback)a(c);else{if(!(t.startTime<=e))break;a(c),t.sortIndex=t.expirationTime,n(u,t)}t=r(c)}}function k(e){if(g=!1,C(e),!m)if(null!==r(u))m=!0,I(w);else{var t=r(c);null!==t&&F(k,t.startTime-e)}}function w(e,n){m=!1,g&&(g=!1,b(O),O=-1),h=!0;var o=p;try{for(C(n),f=r(u);null!==f&&(!(f.expirationTime>n)||e&&!P());){var i=f.callback;if("function"==typeof i){f.callback=null,p=f.priorityLevel;var l=i(f.expirationTime<=n);n=t.unstable_now(),"function"==typeof l?f.callback=l:f===r(u)&&a(u),C(n)}else a(u);f=r(u)}if(null!==f)var s=!0;else{var d=r(c);null!==d&&F(k,d.startTime-n),s=!1}return s}finally{f=null,p=o,h=!1}}"undefined"!=typeof navigator&&void 0!==navigator.scheduling&&void 0!==navigator.scheduling.isInputPending&&navigator.scheduling.isInputPending.bind(navigator.scheduling);var E,x=!1,S=null,O=-1,L=5,_=-1;function P(){return!(t.unstable_now()-_<L)}function N(){if(null!==S){var e=t.unstable_now();_=e;var n=!0;try{n=S(!0,e)}finally{n?E():(x=!1,S=null)}}else x=!1}if("function"==typeof y)E=function(){y(N)};else if("undefined"!=typeof MessageChannel){var M=new MessageChannel,A=M.port2;M.port1.onmessage=N,E=function(){A.postMessage(null)}}else E=function(){v(N,0)};function I(e){S=e,x||(x=!0,E())}function F(e,n){O=v((function(){e(t.unstable_now())}),n)}t.unstable_IdlePriority=5,t.unstable_ImmediatePriority=1,t.unstable_LowPriority=4,t.unstable_NormalPriority=3,t.unstable_Profiling=null,t.unstable_UserBlockingPriority=2,t.unstable_cancelCallback=function(e){e.callback=null},t.unstable_continueExecution=function(){m||h||(m=!0,I(w))},t.unstable_forceFrameRate=function(e){0>e||125<e?console.error("forceFrameRate takes a positive int between 0 and 125, forcing frame rates higher than 125 fps is not supported"):L=0<e?Math.floor(1e3/e):5},t.unstable_getCurrentPriorityLevel=function(){return p},t.unstable_getFirstCallbackNode=function(){return r(u)},t.unstable_next=function(e){switch(p){case 1:case 2:case 3:var t=3;break;default:t=p}var n=p;p=t;try{return e()}finally{p=n}},t.unstable_pauseExecution=function(){},t.unstable_requestPaint=function(){},t.unstable_runWithPriority=function(e,t){switch(e){case 1:case 2:case 3:case 4:case 5:break;default:e=3}var n=p;p=e;try{return t()}finally{p=n}},t.unstable_scheduleCallback=function(e,a,o){var i=t.unstable_now();switch("object"==typeof o&&null!==o?o="number"==typeof(o=o.delay)&&0<o?i+o:i:o=i,e){case 1:var l=-1;break;case 2:l=250;break;case 5:l=1073741823;break;case 4:l=1e4;break;default:l=5e3}return e={id:d++,callback:a,priorityLevel:e,startTime:o,expirationTime:l=o+l,sortIndex:-1},o>i?(e.sortIndex=o,n(c,e),null===r(u)&&e===r(c)&&(g?(b(O),O=-1):g=!0,F(k,o-i))):(e.sortIndex=l,n(u,e),m||h||(m=!0,I(w))),e},t.unstable_shouldYield=P,t.unstable_wrapCallback=function(e){var t=p;return function(){var n=p;p=t;try{return e.apply(this,arguments)}finally{p=n}}}},840:(e,t,n)=>{"use strict";e.exports=n(53)},379:e=>{"use strict";var t=[];function n(e){for(var n=-1,r=0;r<t.length;r++)if(t[r].identifier===e){n=r;break}return n}function r(e,r){for(var o={},i=[],l=0;l<e.length;l++){var s=e[l],u=r.base?s[0]+r.base:s[0],c=o[u]||0,d="".concat(u," ").concat(c);o[u]=c+1;var f=n(d),p={css:s[1],media:s[2],sourceMap:s[3],supports:s[4],layer:s[5]};if(-1!==f)t[f].references++,t[f].updater(p);else{var h=a(p,r);r.byIndex=l,t.splice(l,0,{identifier:d,updater:h,references:1})}i.push(d)}return i}function a(e,t){var n=t.domAPI(t);n.update(e);return function(t){if(t){if(t.css===e.css&&t.media===e.media&&t.sourceMap===e.sourceMap&&t.supports===e.supports&&t.layer===e.layer)return;n.update(e=t)}else n.remove()}}e.exports=function(e,a){var o=r(e=e||[],a=a||{});return function(e){e=e||[];for(var i=0;i<o.length;i++){var l=n(o[i]);t[l].references--}for(var s=r(e,a),u=0;u<o.length;u++){var c=n(o[u]);0===t[c].references&&(t[c].updater(),t.splice(c,1))}o=s}}},569:e=>{"use strict";var t={};e.exports=function(e,n){var r=function(e){if(void 0===t[e]){var n=document.querySelector(e);if(window.HTMLIFrameElement&&n instanceof window.HTMLIFrameElement)try{n=n.contentDocument.head}catch(e){n=null}t[e]=n}return t[e]}(e);if(!r)throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");r.appendChild(n)}},216:e=>{"use strict";e.exports=function(e){var t=document.createElement("style");return e.setAttributes(t,e.attributes),e.insert(t,e.options),t}},575:e=>{"use strict";e.exports=function(e,t){Object.keys(t).forEach((function(n){e.setAttribute(n,t[n])}))}},795:e=>{"use strict";e.exports=function(e){var t=e.insertStyleElement(e);return{update:function(n){!function(e,t,n){var r="";n.supports&&(r+="@supports (".concat(n.supports,") {")),n.media&&(r+="@media ".concat(n.media," {"));var a=void 0!==n.layer;a&&(r+="@layer".concat(n.layer.length>0?" ".concat(n.layer):""," {")),r+=n.css,a&&(r+="}"),n.media&&(r+="}"),n.supports&&(r+="}");var o=n.sourceMap;o&&"undefined"!=typeof btoa&&(r+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(o))))," */")),t.styleTagTransform(r,e,t.options)}(t,e,n)},remove:function(){!function(e){if(null===e.parentNode)return!1;e.parentNode.removeChild(e)}(t)}}}},589:e=>{"use strict";e.exports=function(e,t){if(t.styleSheet)t.styleSheet.cssText=e;else{for(;t.firstChild;)t.removeChild(t.firstChild);t.appendChild(document.createTextNode(e))}}},739:e=>{e.exports={area:!0,base:!0,br:!0,col:!0,embed:!0,hr:!0,img:!0,input:!0,link:!0,meta:!0,param:!0,source:!0,track:!0,wbr:!0}},426:(e,t,n)=>{"use strict";e.exports=n.p+"83572bda21857cccf821.jpg"},630:(e,t,n)=>{"use strict";e.exports=n.p+"b774f4633fe09bd8bd1f.svg"},699:(e,t,n)=>{"use strict";e.exports=n.p+"72036430436803bb8a27.jpg"},311:(e,t,n)=>{"use strict";e.exports=n.p+"a298a0ac59f09aeb64eb.otf"},272:(e,t,n)=>{"use strict";e.exports=n.p+"2d0dbf42750207f78ffa.ttf"},856:(e,t,n)=>{"use strict";e.exports=n.p+"ba5622550ada9b5ff2cd.ttf"},61:(e,t,n)=>{var r=n(698).default;function a(){"use strict";e.exports=a=function(){return t},e.exports.__esModule=!0,e.exports.default=e.exports;var t={},n=Object.prototype,o=n.hasOwnProperty,i=Object.defineProperty||function(e,t,n){e[t]=n.value},l="function"==typeof Symbol?Symbol:{},s=l.iterator||"@@iterator",u=l.asyncIterator||"@@asyncIterator",c=l.toStringTag||"@@toStringTag";function d(e,t,n){return Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}),e[t]}try{d({},"")}catch(e){d=function(e,t,n){return e[t]=n}}function f(e,t,n,r){var a=t&&t.prototype instanceof m?t:m,o=Object.create(a.prototype),l=new _(r||[]);return i(o,"_invoke",{value:x(e,n,l)}),o}function p(e,t,n){try{return{type:"normal",arg:e.call(t,n)}}catch(e){return{type:"throw",arg:e}}}t.wrap=f;var h={};function m(){}function g(){}function v(){}var b={};d(b,s,(function(){return this}));var y=Object.getPrototypeOf,C=y&&y(y(P([])));C&&C!==n&&o.call(C,s)&&(b=C);var k=v.prototype=m.prototype=Object.create(b);function w(e){["next","throw","return"].forEach((function(t){d(e,t,(function(e){return this._invoke(t,e)}))}))}function E(e,t){function n(a,i,l,s){var u=p(e[a],e,i);if("throw"!==u.type){var c=u.arg,d=c.value;return d&&"object"==r(d)&&o.call(d,"__await")?t.resolve(d.__await).then((function(e){n("next",e,l,s)}),(function(e){n("throw",e,l,s)})):t.resolve(d).then((function(e){c.value=e,l(c)}),(function(e){return n("throw",e,l,s)}))}s(u.arg)}var a;i(this,"_invoke",{value:function(e,r){function o(){return new t((function(t,a){n(e,r,t,a)}))}return a=a?a.then(o,o):o()}})}function x(e,t,n){var r="suspendedStart";return function(a,o){if("executing"===r)throw new Error("Generator is already running");if("completed"===r){if("throw"===a)throw o;return N()}for(n.method=a,n.arg=o;;){var i=n.delegate;if(i){var l=S(i,n);if(l){if(l===h)continue;return l}}if("next"===n.method)n.sent=n._sent=n.arg;else if("throw"===n.method){if("suspendedStart"===r)throw r="completed",n.arg;n.dispatchException(n.arg)}else"return"===n.method&&n.abrupt("return",n.arg);r="executing";var s=p(e,t,n);if("normal"===s.type){if(r=n.done?"completed":"suspendedYield",s.arg===h)continue;return{value:s.arg,done:n.done}}"throw"===s.type&&(r="completed",n.method="throw",n.arg=s.arg)}}}function S(e,t){var n=t.method,r=e.iterator[n];if(void 0===r)return t.delegate=null,"throw"===n&&e.iterator.return&&(t.method="return",t.arg=void 0,S(e,t),"throw"===t.method)||"return"!==n&&(t.method="throw",t.arg=new TypeError("The iterator does not provide a '"+n+"' method")),h;var a=p(r,e.iterator,t.arg);if("throw"===a.type)return t.method="throw",t.arg=a.arg,t.delegate=null,h;var o=a.arg;return o?o.done?(t[e.resultName]=o.value,t.next=e.nextLoc,"return"!==t.method&&(t.method="next",t.arg=void 0),t.delegate=null,h):o:(t.method="throw",t.arg=new TypeError("iterator result is not an object"),t.delegate=null,h)}function O(e){var t={tryLoc:e[0]};1 in e&&(t.catchLoc=e[1]),2 in e&&(t.finallyLoc=e[2],t.afterLoc=e[3]),this.tryEntries.push(t)}function L(e){var t=e.completion||{};t.type="normal",delete t.arg,e.completion=t}function _(e){this.tryEntries=[{tryLoc:"root"}],e.forEach(O,this),this.reset(!0)}function P(e){if(e){var t=e[s];if(t)return t.call(e);if("function"==typeof e.next)return e;if(!isNaN(e.length)){var n=-1,r=function t(){for(;++n<e.length;)if(o.call(e,n))return t.value=e[n],t.done=!1,t;return t.value=void 0,t.done=!0,t};return r.next=r}}return{next:N}}function N(){return{value:void 0,done:!0}}return g.prototype=v,i(k,"constructor",{value:v,configurable:!0}),i(v,"constructor",{value:g,configurable:!0}),g.displayName=d(v,c,"GeneratorFunction"),t.isGeneratorFunction=function(e){var t="function"==typeof e&&e.constructor;return!!t&&(t===g||"GeneratorFunction"===(t.displayName||t.name))},t.mark=function(e){return Object.setPrototypeOf?Object.setPrototypeOf(e,v):(e.__proto__=v,d(e,c,"GeneratorFunction")),e.prototype=Object.create(k),e},t.awrap=function(e){return{__await:e}},w(E.prototype),d(E.prototype,u,(function(){return this})),t.AsyncIterator=E,t.async=function(e,n,r,a,o){void 0===o&&(o=Promise);var i=new E(f(e,n,r,a),o);return t.isGeneratorFunction(n)?i:i.next().then((function(e){return e.done?e.value:i.next()}))},w(k),d(k,c,"Generator"),d(k,s,(function(){return this})),d(k,"toString",(function(){return"[object Generator]"})),t.keys=function(e){var t=Object(e),n=[];for(var r in t)n.push(r);return n.reverse(),function e(){for(;n.length;){var r=n.pop();if(r in t)return e.value=r,e.done=!1,e}return e.done=!0,e}},t.values=P,_.prototype={constructor:_,reset:function(e){if(this.prev=0,this.next=0,this.sent=this._sent=void 0,this.done=!1,this.delegate=null,this.method="next",this.arg=void 0,this.tryEntries.forEach(L),!e)for(var t in this)"t"===t.charAt(0)&&o.call(this,t)&&!isNaN(+t.slice(1))&&(this[t]=void 0)},stop:function(){this.done=!0;var e=this.tryEntries[0].completion;if("throw"===e.type)throw e.arg;return this.rval},dispatchException:function(e){if(this.done)throw e;var t=this;function n(n,r){return i.type="throw",i.arg=e,t.next=n,r&&(t.method="next",t.arg=void 0),!!r}for(var r=this.tryEntries.length-1;r>=0;--r){var a=this.tryEntries[r],i=a.completion;if("root"===a.tryLoc)return n("end");if(a.tryLoc<=this.prev){var l=o.call(a,"catchLoc"),s=o.call(a,"finallyLoc");if(l&&s){if(this.prev<a.catchLoc)return n(a.catchLoc,!0);if(this.prev<a.finallyLoc)return n(a.finallyLoc)}else if(l){if(this.prev<a.catchLoc)return n(a.catchLoc,!0)}else{if(!s)throw new Error("try statement without catch or finally");if(this.prev<a.finallyLoc)return n(a.finallyLoc)}}}},abrupt:function(e,t){for(var n=this.tryEntries.length-1;n>=0;--n){var r=this.tryEntries[n];if(r.tryLoc<=this.prev&&o.call(r,"finallyLoc")&&this.prev<r.finallyLoc){var a=r;break}}a&&("break"===e||"continue"===e)&&a.tryLoc<=t&&t<=a.finallyLoc&&(a=null);var i=a?a.completion:{};return i.type=e,i.arg=t,a?(this.method="next",this.next=a.finallyLoc,h):this.complete(i)},complete:function(e,t){if("throw"===e.type)throw e.arg;return"break"===e.type||"continue"===e.type?this.next=e.arg:"return"===e.type?(this.rval=this.arg=e.arg,this.method="return",this.next="end"):"normal"===e.type&&t&&(this.next=t),h},finish:function(e){for(var t=this.tryEntries.length-1;t>=0;--t){var n=this.tryEntries[t];if(n.finallyLoc===e)return this.complete(n.completion,n.afterLoc),L(n),h}},catch:function(e){for(var t=this.tryEntries.length-1;t>=0;--t){var n=this.tryEntries[t];if(n.tryLoc===e){var r=n.completion;if("throw"===r.type){var a=r.arg;L(n)}return a}}throw new Error("illegal catch attempt")},delegateYield:function(e,t,n){return this.delegate={iterator:P(e),resultName:t,nextLoc:n},"next"===this.method&&(this.arg=void 0),h}},t}e.exports=a,e.exports.__esModule=!0,e.exports.default=e.exports},698:e=>{function t(n){return e.exports=t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},e.exports.__esModule=!0,e.exports.default=e.exports,t(n)}e.exports=t,e.exports.__esModule=!0,e.exports.default=e.exports},687:(e,t,n)=>{var r=n(61)();e.exports=r;try{regeneratorRuntime=r}catch(e){"object"==typeof globalThis?globalThis.regeneratorRuntime=r:Function("r","regeneratorRuntime = r")(r)}}},t={};function n(r){var a=t[r];if(void 0!==a)return a.exports;var o=t[r]={id:r,exports:{}};return e[r](o,o.exports,n),o.exports}n.m=e,n.n=e=>{var t=e&&e.__esModule?()=>e.default:()=>e;return n.d(t,{a:t}),t},n.d=(e,t)=>{for(var r in t)n.o(t,r)&&!n.o(e,r)&&Object.defineProperty(e,r,{enumerable:!0,get:t[r]})},n.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),n.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),(()=>{var e;n.g.importScripts&&(e=n.g.location+"");var t=n.g.document;if(!e&&t&&(t.currentScript&&(e=t.currentScript.src),!e)){var r=t.getElementsByTagName("script");r.length&&(e=r[r.length-1].src)}if(!e)throw new Error("Automatic publicPath is not supported in this browser");e=e.replace(/#.*$/,"").replace(/\?.*$/,"").replace(/\/[^\/]+$/,"/"),n.p=e})(),n.b=document.baseURI||self.location.href;var r={};(()=>{"use strict";function e(e,t,n,r,a,o,i){try{var l=e[o](i),s=l.value}catch(e){return void n(e)}l.done?t(s):Promise.resolve(s).then(r,a)}function t(t){return function(){var n=this,r=arguments;return new Promise((function(a,o){var i=t.apply(n,r);function l(t){e(i,a,o,l,s,"next",t)}function s(t){e(i,a,o,l,s,"throw",t)}l(void 0)}))}}function a(e){if(Array.isArray(e))return e}function o(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}function i(e,t){if(e){if("string"==typeof e)return o(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?o(e,t):void 0}}function l(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function s(e,t){return a(e)||function(e,t){var n=null==e?null:"undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(null!=n){var r,a,o,i,l=[],s=!0,u=!1;try{if(o=(n=n.call(e)).next,0===t){if(Object(n)!==n)return;s=!1}else for(;!(s=(r=o.call(n)).done)&&(l.push(r.value),l.length!==t);s=!0);}catch(e){u=!0,a=e}finally{try{if(!s&&null!=n.return&&(i=n.return(),Object(i)!==i))return}finally{if(u)throw a}}return l}}(e,t)||i(e,t)||l()}n.d(r,{L0:()=>Wa,AW:()=>Za});var u=n(687),c=n.n(u),d=n(294);function f(e){return f="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},f(e)}function p(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function h(e){var t=function(e,t){if("object"!==f(e)||null===e)return e;var n=e[Symbol.toPrimitive];if(void 0!==n){var r=n.call(e,t||"default");if("object"!==f(r))return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"===f(t)?t:String(t)}function m(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,h(r.key),r)}}function g(e,t,n){return t&&m(e.prototype,t),n&&m(e,n),Object.defineProperty(e,"prototype",{writable:!1}),e}function v(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}function b(e,t){return b=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e},b(e,t)}function y(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),Object.defineProperty(e,"prototype",{writable:!1}),t&&b(e,t)}function C(e,t){if(t&&("object"===f(t)||"function"==typeof t))return t;if(void 0!==t)throw new TypeError("Derived constructors may only return object or undefined");return v(e)}function k(e){return k=Object.setPrototypeOf?Object.getPrototypeOf.bind():function(e){return e.__proto__||Object.getPrototypeOf(e)},k(e)}function w(e,t,n){return(t=h(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function E(e){return a(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||i(e)||l()}function x(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,r)}return n}function S(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?x(Object(n),!0).forEach((function(t){w(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):x(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}var O={type:"logger",log:function(e){this.output("log",e)},warn:function(e){this.output("warn",e)},error:function(e){this.output("error",e)},output:function(e,t){console&&console[e]&&console[e].apply(console,t)}},L=function(){function e(t){var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};p(this,e),this.init(t,n)}return g(e,[{key:"init",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};this.prefix=t.prefix||"i18next:",this.logger=e||O,this.options=t,this.debug=t.debug}},{key:"setDebug",value:function(e){this.debug=e}},{key:"log",value:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return this.forward(t,"log","",!0)}},{key:"warn",value:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return this.forward(t,"warn","",!0)}},{key:"error",value:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return this.forward(t,"error","")}},{key:"deprecate",value:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return this.forward(t,"warn","WARNING DEPRECATED: ",!0)}},{key:"forward",value:function(e,t,n,r){return r&&!this.debug?null:("string"==typeof e[0]&&(e[0]="".concat(n).concat(this.prefix," ").concat(e[0])),this.logger[t](e))}},{key:"create",value:function(t){return new e(this.logger,S(S({},{prefix:"".concat(this.prefix,":").concat(t,":")}),this.options))}},{key:"clone",value:function(t){return(t=t||this.options).prefix=t.prefix||this.prefix,new e(this.logger,t)}}]),e}(),_=new L,P=function(){function e(){p(this,e),this.observers={}}return g(e,[{key:"on",value:function(e,t){var n=this;return e.split(" ").forEach((function(e){n.observers[e]=n.observers[e]||[],n.observers[e].push(t)})),this}},{key:"off",value:function(e,t){this.observers[e]&&(t?this.observers[e]=this.observers[e].filter((function(e){return e!==t})):delete this.observers[e])}},{key:"emit",value:function(e){for(var t=arguments.length,n=new Array(t>1?t-1:0),r=1;r<t;r++)n[r-1]=arguments[r];this.observers[e]&&[].concat(this.observers[e]).forEach((function(e){e.apply(void 0,n)}));this.observers["*"]&&[].concat(this.observers["*"]).forEach((function(t){t.apply(t,[e].concat(n))}))}}]),e}();function N(){var e,t,n=new Promise((function(n,r){e=n,t=r}));return n.resolve=e,n.reject=t,n}function M(e){return null==e?"":""+e}function A(e,t,n){function r(e){return e&&e.indexOf("###")>-1?e.replace(/###/g,"."):e}function a(){return!e||"string"==typeof e}for(var o="string"!=typeof t?[].concat(t):t.split(".");o.length>1;){if(a())return{};var i=r(o.shift());!e[i]&&n&&(e[i]=new n),e=Object.prototype.hasOwnProperty.call(e,i)?e[i]:{}}return a()?{}:{obj:e,k:r(o.shift())}}function I(e,t,n){var r=A(e,t,Object);r.obj[r.k]=n}function F(e,t){var n=A(e,t),r=n.obj,a=n.k;if(r)return r[a]}function R(e,t,n){var r=F(e,n);return void 0!==r?r:F(t,n)}function V(e,t,n){for(var r in t)"__proto__"!==r&&"constructor"!==r&&(r in e?"string"==typeof e[r]||e[r]instanceof String||"string"==typeof t[r]||t[r]instanceof String?n&&(e[r]=t[r]):V(e[r],t[r],n):e[r]=t[r]);return e}function j(e){return e.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&")}var z={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;","/":"&#x2F;"};function T(e){return"string"==typeof e?e.replace(/[&<>"'\/]/g,(function(e){return z[e]})):e}var H="undefined"!=typeof window&&window.navigator&&void 0===window.navigator.userAgentData&&window.navigator.userAgent&&window.navigator.userAgent.indexOf("MSIE")>-1,D=[" ",",","?","!",";"];function B(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,r)}return n}function U(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?B(Object(n),!0).forEach((function(t){w(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):B(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}function Z(e){var t=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}();return function(){var n,r=k(e);if(t){var a=k(this).constructor;n=Reflect.construct(r,arguments,a)}else n=r.apply(this,arguments);return C(this,n)}}function W(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:".";if(e){if(e[t])return e[t];for(var r=t.split(n),a=e,o=0;o<r.length;++o){if(!a)return;if("string"==typeof a[r[o]]&&o+1<r.length)return;if(void 0===a[r[o]]){for(var i=2,l=r.slice(o,o+i).join(n),s=a[l];void 0===s&&r.length>o+i;)i++,s=a[l=r.slice(o,o+i).join(n)];if(void 0===s)return;if(null===s)return null;if(t.endsWith(l)){if("string"==typeof s)return s;if(l&&"string"==typeof s[l])return s[l]}var u=r.slice(o+i).join(n);return u?W(s,u,n):void 0}a=a[r[o]]}return a}}var G=function(e){y(n,e);var t=Z(n);function n(e){var r,a=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{ns:["translation"],defaultNS:"translation"};return p(this,n),r=t.call(this),H&&P.call(v(r)),r.data=e||{},r.options=a,void 0===r.options.keySeparator&&(r.options.keySeparator="."),void 0===r.options.ignoreJSONStructure&&(r.options.ignoreJSONStructure=!0),r}return g(n,[{key:"addNamespaces",value:function(e){this.options.ns.indexOf(e)<0&&this.options.ns.push(e)}},{key:"removeNamespaces",value:function(e){var t=this.options.ns.indexOf(e);t>-1&&this.options.ns.splice(t,1)}},{key:"getResource",value:function(e,t,n){var r=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{},a=void 0!==r.keySeparator?r.keySeparator:this.options.keySeparator,o=void 0!==r.ignoreJSONStructure?r.ignoreJSONStructure:this.options.ignoreJSONStructure,i=[e,t];n&&"string"!=typeof n&&(i=i.concat(n)),n&&"string"==typeof n&&(i=i.concat(a?n.split(a):n)),e.indexOf(".")>-1&&(i=e.split("."));var l=F(this.data,i);return l||!o||"string"!=typeof n?l:W(this.data&&this.data[e]&&this.data[e][t],n,a)}},{key:"addResource",value:function(e,t,n,r){var a=arguments.length>4&&void 0!==arguments[4]?arguments[4]:{silent:!1},o=this.options.keySeparator;void 0===o&&(o=".");var i=[e,t];n&&(i=i.concat(o?n.split(o):n)),e.indexOf(".")>-1&&(r=t,t=(i=e.split("."))[1]),this.addNamespaces(t),I(this.data,i,r),a.silent||this.emit("added",e,t,n,r)}},{key:"addResources",value:function(e,t,n){var r=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{silent:!1};for(var a in n)"string"!=typeof n[a]&&"[object Array]"!==Object.prototype.toString.apply(n[a])||this.addResource(e,t,a,n[a],{silent:!0});r.silent||this.emit("added",e,t,n)}},{key:"addResourceBundle",value:function(e,t,n,r,a){var o=arguments.length>5&&void 0!==arguments[5]?arguments[5]:{silent:!1},i=[e,t];e.indexOf(".")>-1&&(r=n,n=t,t=(i=e.split("."))[1]),this.addNamespaces(t);var l=F(this.data,i)||{};r?V(l,n,a):l=U(U({},l),n),I(this.data,i,l),o.silent||this.emit("added",e,t,n)}},{key:"removeResourceBundle",value:function(e,t){this.hasResourceBundle(e,t)&&delete this.data[e][t],this.removeNamespaces(t),this.emit("removed",e,t)}},{key:"hasResourceBundle",value:function(e,t){return void 0!==this.getResource(e,t)}},{key:"getResourceBundle",value:function(e,t){return t||(t=this.options.defaultNS),"v1"===this.options.compatibilityAPI?U(U({},{}),this.getResource(e,t)):this.getResource(e,t)}},{key:"getDataByLanguage",value:function(e){return this.data[e]}},{key:"hasLanguageSomeTranslations",value:function(e){var t=this.getDataByLanguage(e);return!!(t&&Object.keys(t)||[]).find((function(e){return t[e]&&Object.keys(t[e]).length>0}))}},{key:"toJSON",value:function(){return this.data}}]),n}(P),K={processors:{},addPostProcessor:function(e){this.processors[e.name]=e},handle:function(e,t,n,r,a){var o=this;return e.forEach((function(e){o.processors[e]&&(t=o.processors[e].process(t,n,r,a))})),t}};function $(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,r)}return n}function J(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?$(Object(n),!0).forEach((function(t){w(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):$(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}function Q(e){var t=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}();return function(){var n,r=k(e);if(t){var a=k(this).constructor;n=Reflect.construct(r,arguments,a)}else n=r.apply(this,arguments);return C(this,n)}}var q={},Y=function(e){y(n,e);var t=Q(n);function n(e){var r,a=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return p(this,n),r=t.call(this),H&&P.call(v(r)),function(e,t,n){e.forEach((function(e){t[e]&&(n[e]=t[e])}))}(["resourceStore","languageUtils","pluralResolver","interpolator","backendConnector","i18nFormat","utils"],e,v(r)),r.options=a,void 0===r.options.keySeparator&&(r.options.keySeparator="."),r.logger=_.create("translator"),r}return g(n,[{key:"changeLanguage",value:function(e){e&&(this.language=e)}},{key:"exists",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{interpolation:{}};if(null==e)return!1;var n=this.resolve(e,t);return n&&void 0!==n.res}},{key:"extractFromKey",value:function(e,t){var n=void 0!==t.nsSeparator?t.nsSeparator:this.options.nsSeparator;void 0===n&&(n=":");var r=void 0!==t.keySeparator?t.keySeparator:this.options.keySeparator,a=t.ns||this.options.defaultNS||[],o=n&&e.indexOf(n)>-1,i=!(this.options.userDefinedKeySeparator||t.keySeparator||this.options.userDefinedNsSeparator||t.nsSeparator||function(e,t,n){t=t||"",n=n||"";var r=D.filter((function(e){return t.indexOf(e)<0&&n.indexOf(e)<0}));if(0===r.length)return!0;var a=new RegExp("(".concat(r.map((function(e){return"?"===e?"\\?":e})).join("|"),")")),o=!a.test(e);if(!o){var i=e.indexOf(n);i>0&&!a.test(e.substring(0,i))&&(o=!0)}return o}(e,n,r));if(o&&!i){var l=e.match(this.interpolator.nestingRegexp);if(l&&l.length>0)return{key:e,namespaces:a};var s=e.split(n);(n!==r||n===r&&this.options.ns.indexOf(s[0])>-1)&&(a=s.shift()),e=s.join(r)}return"string"==typeof a&&(a=[a]),{key:e,namespaces:a}}},{key:"translate",value:function(e,t,r){var a=this;if("object"!==f(t)&&this.options.overloadTranslationOptionHandler&&(t=this.options.overloadTranslationOptionHandler(arguments)),t||(t={}),null==e)return"";Array.isArray(e)||(e=[String(e)]);var o=void 0!==t.returnDetails?t.returnDetails:this.options.returnDetails,i=void 0!==t.keySeparator?t.keySeparator:this.options.keySeparator,l=this.extractFromKey(e[e.length-1],t),s=l.key,u=l.namespaces,c=u[u.length-1],d=t.lng||this.language,p=t.appendNamespaceToCIMode||this.options.appendNamespaceToCIMode;if(d&&"cimode"===d.toLowerCase()){if(p){var h=t.nsSeparator||this.options.nsSeparator;return o?(m.res="".concat(c).concat(h).concat(s),m):"".concat(c).concat(h).concat(s)}return o?(m.res=s,m):s}var m=this.resolve(e,t),g=m&&m.res,v=m&&m.usedKey||s,b=m&&m.exactUsedKey||s,y=Object.prototype.toString.apply(g),C=void 0!==t.joinArrays?t.joinArrays:this.options.joinArrays,k=!this.i18nFormat||this.i18nFormat.handleAsObject;if(k&&g&&("string"!=typeof g&&"boolean"!=typeof g&&"number"!=typeof g)&&["[object Number]","[object Function]","[object RegExp]"].indexOf(y)<0&&("string"!=typeof C||"[object Array]"!==y)){if(!t.returnObjects&&!this.options.returnObjects){this.options.returnedObjectHandler||this.logger.warn("accessing an object - but returnObjects options is not enabled!");var w=this.options.returnedObjectHandler?this.options.returnedObjectHandler(v,g,J(J({},t),{},{ns:u})):"key '".concat(s," (").concat(this.language,")' returned an object instead of string.");return o?(m.res=w,m):w}if(i){var E="[object Array]"===y,x=E?[]:{},S=E?b:v;for(var O in g)if(Object.prototype.hasOwnProperty.call(g,O)){var L="".concat(S).concat(i).concat(O);x[O]=this.translate(L,J(J({},t),{joinArrays:!1,ns:u})),x[O]===L&&(x[O]=g[O])}g=x}}else if(k&&"string"==typeof C&&"[object Array]"===y)(g=g.join(C))&&(g=this.extendTranslation(g,e,t,r));else{var _=!1,P=!1,N=void 0!==t.count&&"string"!=typeof t.count,M=n.hasDefaultValue(t),A=N?this.pluralResolver.getSuffix(d,t.count,t):"",I=t["defaultValue".concat(A)]||t.defaultValue;!this.isValidLookup(g)&&M&&(_=!0,g=I),this.isValidLookup(g)||(P=!0,g=s);var F=(t.missingKeyNoValueFallbackToKey||this.options.missingKeyNoValueFallbackToKey)&&P?void 0:g,R=M&&I!==g&&this.options.updateMissing;if(P||_||R){if(this.logger.log(R?"updateKey":"missingKey",d,c,s,R?I:g),i){var V=this.resolve(s,J(J({},t),{},{keySeparator:!1}));V&&V.res&&this.logger.warn("Seems the loaded translations were in flat JSON format instead of nested. Either set keySeparator: false on init or make sure your translations are published in nested format.")}var j=[],z=this.languageUtils.getFallbackCodes(this.options.fallbackLng,t.lng||this.language);if("fallback"===this.options.saveMissingTo&&z&&z[0])for(var T=0;T<z.length;T++)j.push(z[T]);else"all"===this.options.saveMissingTo?j=this.languageUtils.toResolveHierarchy(t.lng||this.language):j.push(t.lng||this.language);var H=function(e,n,r){var o=M&&r!==g?r:F;a.options.missingKeyHandler?a.options.missingKeyHandler(e,c,n,o,R,t):a.backendConnector&&a.backendConnector.saveMissing&&a.backendConnector.saveMissing(e,c,n,o,R,t),a.emit("missingKey",e,c,n,g)};this.options.saveMissing&&(this.options.saveMissingPlurals&&N?j.forEach((function(e){a.pluralResolver.getSuffixes(e,t).forEach((function(n){H([e],s+n,t["defaultValue".concat(n)]||I)}))})):H(j,s,I))}g=this.extendTranslation(g,e,t,m,r),P&&g===s&&this.options.appendNamespaceToMissingKey&&(g="".concat(c,":").concat(s)),(P||_)&&this.options.parseMissingKeyHandler&&(g="v1"!==this.options.compatibilityAPI?this.options.parseMissingKeyHandler(this.options.appendNamespaceToMissingKey?"".concat(c,":").concat(s):s,_?g:void 0):this.options.parseMissingKeyHandler(g))}return o?(m.res=g,m):g}},{key:"extendTranslation",value:function(e,t,n,r,a){var o=this;if(this.i18nFormat&&this.i18nFormat.parse)e=this.i18nFormat.parse(e,J(J({},this.options.interpolation.defaultVariables),n),r.usedLng,r.usedNS,r.usedKey,{resolved:r});else if(!n.skipInterpolation){n.interpolation&&this.interpolator.init(J(J({},n),{interpolation:J(J({},this.options.interpolation),n.interpolation)}));var i,l="string"==typeof e&&(n&&n.interpolation&&void 0!==n.interpolation.skipOnVariables?n.interpolation.skipOnVariables:this.options.interpolation.skipOnVariables);if(l){var s=e.match(this.interpolator.nestingRegexp);i=s&&s.length}var u=n.replace&&"string"!=typeof n.replace?n.replace:n;if(this.options.interpolation.defaultVariables&&(u=J(J({},this.options.interpolation.defaultVariables),u)),e=this.interpolator.interpolate(e,u,n.lng||this.language,n),l){var c=e.match(this.interpolator.nestingRegexp);i<(c&&c.length)&&(n.nest=!1)}!1!==n.nest&&(e=this.interpolator.nest(e,(function(){for(var e=arguments.length,r=new Array(e),i=0;i<e;i++)r[i]=arguments[i];return a&&a[0]===r[0]&&!n.context?(o.logger.warn("It seems you are nesting recursively key: ".concat(r[0]," in key: ").concat(t[0])),null):o.translate.apply(o,r.concat([t]))}),n)),n.interpolation&&this.interpolator.reset()}var d=n.postProcess||this.options.postProcess,f="string"==typeof d?[d]:d;return null!=e&&f&&f.length&&!1!==n.applyPostProcessor&&(e=K.handle(f,e,t,this.options&&this.options.postProcessPassResolved?J({i18nResolved:r},n):n,this)),e}},{key:"resolve",value:function(e){var t,n,r,a,o,i=this,l=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return"string"==typeof e&&(e=[e]),e.forEach((function(e){if(!i.isValidLookup(t)){var s=i.extractFromKey(e,l),u=s.key;n=u;var c=s.namespaces;i.options.fallbackNS&&(c=c.concat(i.options.fallbackNS));var d=void 0!==l.count&&"string"!=typeof l.count,f=d&&!l.ordinal&&0===l.count&&i.pluralResolver.shouldUseIntlApi(),p=void 0!==l.context&&("string"==typeof l.context||"number"==typeof l.context)&&""!==l.context,h=l.lngs?l.lngs:i.languageUtils.toResolveHierarchy(l.lng||i.language,l.fallbackLng);c.forEach((function(e){i.isValidLookup(t)||(o=e,!q["".concat(h[0],"-").concat(e)]&&i.utils&&i.utils.hasLoadedNamespace&&!i.utils.hasLoadedNamespace(o)&&(q["".concat(h[0],"-").concat(e)]=!0,i.logger.warn('key "'.concat(n,'" for languages "').concat(h.join(", "),'" won\'t get resolved as namespace "').concat(o,'" was not yet loaded'),"This means something IS WRONG in your setup. You access the t function before i18next.init / i18next.loadNamespace / i18next.changeLanguage was done. Wait for the callback or Promise to resolve before accessing it!!!")),h.forEach((function(n){if(!i.isValidLookup(t)){a=n;var o,s=[u];if(i.i18nFormat&&i.i18nFormat.addLookupKeys)i.i18nFormat.addLookupKeys(s,u,n,e,l);else{var c;d&&(c=i.pluralResolver.getSuffix(n,l.count,l));var h="".concat(i.options.pluralSeparator,"zero");if(d&&(s.push(u+c),f&&s.push(u+h)),p){var m="".concat(u).concat(i.options.contextSeparator).concat(l.context);s.push(m),d&&(s.push(m+c),f&&s.push(m+h))}}for(;o=s.pop();)i.isValidLookup(t)||(r=o,t=i.getResource(n,e,o,l))}})))}))}})),{res:t,usedKey:n,exactUsedKey:r,usedLng:a,usedNS:o}}},{key:"isValidLookup",value:function(e){return!(void 0===e||!this.options.returnNull&&null===e||!this.options.returnEmptyString&&""===e)}},{key:"getResource",value:function(e,t,n){var r=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};return this.i18nFormat&&this.i18nFormat.getResource?this.i18nFormat.getResource(e,t,n,r):this.resourceStore.getResource(e,t,n,r)}}],[{key:"hasDefaultValue",value:function(e){var t="defaultValue";for(var n in e)if(Object.prototype.hasOwnProperty.call(e,n)&&t===n.substring(0,t.length)&&void 0!==e[n])return!0;return!1}}]),n}(P);function X(e){return e.charAt(0).toUpperCase()+e.slice(1)}var ee=function(){function e(t){p(this,e),this.options=t,this.supportedLngs=this.options.supportedLngs||!1,this.logger=_.create("languageUtils")}return g(e,[{key:"getScriptPartFromCode",value:function(e){if(!e||e.indexOf("-")<0)return null;var t=e.split("-");return 2===t.length?null:(t.pop(),"x"===t[t.length-1].toLowerCase()?null:this.formatLanguageCode(t.join("-")))}},{key:"getLanguagePartFromCode",value:function(e){if(!e||e.indexOf("-")<0)return e;var t=e.split("-");return this.formatLanguageCode(t[0])}},{key:"formatLanguageCode",value:function(e){if("string"==typeof e&&e.indexOf("-")>-1){var t=["hans","hant","latn","cyrl","cans","mong","arab"],n=e.split("-");return this.options.lowerCaseLng?n=n.map((function(e){return e.toLowerCase()})):2===n.length?(n[0]=n[0].toLowerCase(),n[1]=n[1].toUpperCase(),t.indexOf(n[1].toLowerCase())>-1&&(n[1]=X(n[1].toLowerCase()))):3===n.length&&(n[0]=n[0].toLowerCase(),2===n[1].length&&(n[1]=n[1].toUpperCase()),"sgn"!==n[0]&&2===n[2].length&&(n[2]=n[2].toUpperCase()),t.indexOf(n[1].toLowerCase())>-1&&(n[1]=X(n[1].toLowerCase())),t.indexOf(n[2].toLowerCase())>-1&&(n[2]=X(n[2].toLowerCase()))),n.join("-")}return this.options.cleanCode||this.options.lowerCaseLng?e.toLowerCase():e}},{key:"isSupportedCode",value:function(e){return("languageOnly"===this.options.load||this.options.nonExplicitSupportedLngs)&&(e=this.getLanguagePartFromCode(e)),!this.supportedLngs||!this.supportedLngs.length||this.supportedLngs.indexOf(e)>-1}},{key:"getBestMatchFromCodes",value:function(e){var t,n=this;return e?(e.forEach((function(e){if(!t){var r=n.formatLanguageCode(e);n.options.supportedLngs&&!n.isSupportedCode(r)||(t=r)}})),!t&&this.options.supportedLngs&&e.forEach((function(e){if(!t){var r=n.getLanguagePartFromCode(e);if(n.isSupportedCode(r))return t=r;t=n.options.supportedLngs.find((function(e){if(0===e.indexOf(r))return e}))}})),t||(t=this.getFallbackCodes(this.options.fallbackLng)[0]),t):null}},{key:"getFallbackCodes",value:function(e,t){if(!e)return[];if("function"==typeof e&&(e=e(t)),"string"==typeof e&&(e=[e]),"[object Array]"===Object.prototype.toString.apply(e))return e;if(!t)return e.default||[];var n=e[t];return n||(n=e[this.getScriptPartFromCode(t)]),n||(n=e[this.formatLanguageCode(t)]),n||(n=e[this.getLanguagePartFromCode(t)]),n||(n=e.default),n||[]}},{key:"toResolveHierarchy",value:function(e,t){var n=this,r=this.getFallbackCodes(t||this.options.fallbackLng||[],e),a=[],o=function(e){e&&(n.isSupportedCode(e)?a.push(e):n.logger.warn("rejecting language code not found in supportedLngs: ".concat(e)))};return"string"==typeof e&&e.indexOf("-")>-1?("languageOnly"!==this.options.load&&o(this.formatLanguageCode(e)),"languageOnly"!==this.options.load&&"currentOnly"!==this.options.load&&o(this.getScriptPartFromCode(e)),"currentOnly"!==this.options.load&&o(this.getLanguagePartFromCode(e))):"string"==typeof e&&o(this.formatLanguageCode(e)),r.forEach((function(e){a.indexOf(e)<0&&o(n.formatLanguageCode(e))})),a}}]),e}(),te=[{lngs:["ach","ak","am","arn","br","fil","gun","ln","mfe","mg","mi","oc","pt","pt-BR","tg","tl","ti","tr","uz","wa"],nr:[1,2],fc:1},{lngs:["af","an","ast","az","bg","bn","ca","da","de","dev","el","en","eo","es","et","eu","fi","fo","fur","fy","gl","gu","ha","hi","hu","hy","ia","it","kk","kn","ku","lb","mai","ml","mn","mr","nah","nap","nb","ne","nl","nn","no","nso","pa","pap","pms","ps","pt-PT","rm","sco","se","si","so","son","sq","sv","sw","ta","te","tk","ur","yo"],nr:[1,2],fc:2},{lngs:["ay","bo","cgg","fa","ht","id","ja","jbo","ka","km","ko","ky","lo","ms","sah","su","th","tt","ug","vi","wo","zh"],nr:[1],fc:3},{lngs:["be","bs","cnr","dz","hr","ru","sr","uk"],nr:[1,2,5],fc:4},{lngs:["ar"],nr:[0,1,2,3,11,100],fc:5},{lngs:["cs","sk"],nr:[1,2,5],fc:6},{lngs:["csb","pl"],nr:[1,2,5],fc:7},{lngs:["cy"],nr:[1,2,3,8],fc:8},{lngs:["fr"],nr:[1,2],fc:9},{lngs:["ga"],nr:[1,2,3,7,11],fc:10},{lngs:["gd"],nr:[1,2,3,20],fc:11},{lngs:["is"],nr:[1,2],fc:12},{lngs:["jv"],nr:[0,1],fc:13},{lngs:["kw"],nr:[1,2,3,4],fc:14},{lngs:["lt"],nr:[1,2,10],fc:15},{lngs:["lv"],nr:[1,2,0],fc:16},{lngs:["mk"],nr:[1,2],fc:17},{lngs:["mnk"],nr:[0,1,2],fc:18},{lngs:["mt"],nr:[1,2,11,20],fc:19},{lngs:["or"],nr:[2,1],fc:2},{lngs:["ro"],nr:[1,2,20],fc:20},{lngs:["sl"],nr:[5,1,2,3],fc:21},{lngs:["he","iw"],nr:[1,2,20,21],fc:22}],ne={1:function(e){return Number(e>1)},2:function(e){return Number(1!=e)},3:function(e){return 0},4:function(e){return Number(e%10==1&&e%100!=11?0:e%10>=2&&e%10<=4&&(e%100<10||e%100>=20)?1:2)},5:function(e){return Number(0==e?0:1==e?1:2==e?2:e%100>=3&&e%100<=10?3:e%100>=11?4:5)},6:function(e){return Number(1==e?0:e>=2&&e<=4?1:2)},7:function(e){return Number(1==e?0:e%10>=2&&e%10<=4&&(e%100<10||e%100>=20)?1:2)},8:function(e){return Number(1==e?0:2==e?1:8!=e&&11!=e?2:3)},9:function(e){return Number(e>=2)},10:function(e){return Number(1==e?0:2==e?1:e<7?2:e<11?3:4)},11:function(e){return Number(1==e||11==e?0:2==e||12==e?1:e>2&&e<20?2:3)},12:function(e){return Number(e%10!=1||e%100==11)},13:function(e){return Number(0!==e)},14:function(e){return Number(1==e?0:2==e?1:3==e?2:3)},15:function(e){return Number(e%10==1&&e%100!=11?0:e%10>=2&&(e%100<10||e%100>=20)?1:2)},16:function(e){return Number(e%10==1&&e%100!=11?0:0!==e?1:2)},17:function(e){return Number(1==e||e%10==1&&e%100!=11?0:1)},18:function(e){return Number(0==e?0:1==e?1:2)},19:function(e){return Number(1==e?0:0==e||e%100>1&&e%100<11?1:e%100>10&&e%100<20?2:3)},20:function(e){return Number(1==e?0:0==e||e%100>0&&e%100<20?1:2)},21:function(e){return Number(e%100==1?1:e%100==2?2:e%100==3||e%100==4?3:0)},22:function(e){return Number(1==e?0:2==e?1:(e<0||e>10)&&e%10==0?2:3)}},re=["v1","v2","v3"],ae={zero:0,one:1,two:2,few:3,many:4,other:5};var oe=function(){function e(t){var n,r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};p(this,e),this.languageUtils=t,this.options=r,this.logger=_.create("pluralResolver"),this.options.compatibilityJSON&&"v4"!==this.options.compatibilityJSON||"undefined"!=typeof Intl&&Intl.PluralRules||(this.options.compatibilityJSON="v3",this.logger.error("Your environment seems not to be Intl API compatible, use an Intl.PluralRules polyfill. Will fallback to the compatibilityJSON v3 format handling.")),this.rules=(n={},te.forEach((function(e){e.lngs.forEach((function(t){n[t]={numbers:e.nr,plurals:ne[e.fc]}}))})),n)}return g(e,[{key:"addRule",value:function(e,t){this.rules[e]=t}},{key:"getRule",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(this.shouldUseIntlApi())try{return new Intl.PluralRules(e,{type:t.ordinal?"ordinal":"cardinal"})}catch(e){return}return this.rules[e]||this.rules[this.languageUtils.getLanguagePartFromCode(e)]}},{key:"needsPlural",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=this.getRule(e,t);return this.shouldUseIntlApi()?n&&n.resolvedOptions().pluralCategories.length>1:n&&n.numbers.length>1}},{key:"getPluralFormsOfKey",value:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};return this.getSuffixes(e,n).map((function(e){return"".concat(t).concat(e)}))}},{key:"getSuffixes",value:function(e){var t=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=this.getRule(e,n);return r?this.shouldUseIntlApi()?r.resolvedOptions().pluralCategories.sort((function(e,t){return ae[e]-ae[t]})).map((function(e){return"".concat(t.options.prepend).concat(e)})):r.numbers.map((function(r){return t.getSuffix(e,r,n)})):[]}},{key:"getSuffix",value:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=this.getRule(e,n);return r?this.shouldUseIntlApi()?"".concat(this.options.prepend).concat(r.select(t)):this.getSuffixRetroCompatible(r,t):(this.logger.warn("no plural rule found for: ".concat(e)),"")}},{key:"getSuffixRetroCompatible",value:function(e,t){var n=this,r=e.noAbs?e.plurals(t):e.plurals(Math.abs(t)),a=e.numbers[r];this.options.simplifyPluralSuffix&&2===e.numbers.length&&1===e.numbers[0]&&(2===a?a="plural":1===a&&(a=""));var o=function(){return n.options.prepend&&a.toString()?n.options.prepend+a.toString():a.toString()};return"v1"===this.options.compatibilityJSON?1===a?"":"number"==typeof a?"_plural_".concat(a.toString()):o():"v2"===this.options.compatibilityJSON||this.options.simplifyPluralSuffix&&2===e.numbers.length&&1===e.numbers[0]?o():this.options.prepend&&r.toString()?this.options.prepend+r.toString():r.toString()}},{key:"shouldUseIntlApi",value:function(){return!re.includes(this.options.compatibilityJSON)}}]),e}();function ie(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,r)}return n}function le(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?ie(Object(n),!0).forEach((function(t){w(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):ie(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}var se=function(){function e(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};p(this,e),this.logger=_.create("interpolator"),this.options=t,this.format=t.interpolation&&t.interpolation.format||function(e){return e},this.init(t)}return g(e,[{key:"init",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};e.interpolation||(e.interpolation={escapeValue:!0});var t=e.interpolation;this.escape=void 0!==t.escape?t.escape:T,this.escapeValue=void 0===t.escapeValue||t.escapeValue,this.useRawValueToEscape=void 0!==t.useRawValueToEscape&&t.useRawValueToEscape,this.prefix=t.prefix?j(t.prefix):t.prefixEscaped||"{{",this.suffix=t.suffix?j(t.suffix):t.suffixEscaped||"}}",this.formatSeparator=t.formatSeparator?t.formatSeparator:t.formatSeparator||",",this.unescapePrefix=t.unescapeSuffix?"":t.unescapePrefix||"-",this.unescapeSuffix=this.unescapePrefix?"":t.unescapeSuffix||"",this.nestingPrefix=t.nestingPrefix?j(t.nestingPrefix):t.nestingPrefixEscaped||j("$t("),this.nestingSuffix=t.nestingSuffix?j(t.nestingSuffix):t.nestingSuffixEscaped||j(")"),this.nestingOptionsSeparator=t.nestingOptionsSeparator?t.nestingOptionsSeparator:t.nestingOptionsSeparator||",",this.maxReplaces=t.maxReplaces?t.maxReplaces:1e3,this.alwaysFormat=void 0!==t.alwaysFormat&&t.alwaysFormat,this.resetRegExp()}},{key:"reset",value:function(){this.options&&this.init(this.options)}},{key:"resetRegExp",value:function(){var e="".concat(this.prefix,"(.+?)").concat(this.suffix);this.regexp=new RegExp(e,"g");var t="".concat(this.prefix).concat(this.unescapePrefix,"(.+?)").concat(this.unescapeSuffix).concat(this.suffix);this.regexpUnescape=new RegExp(t,"g");var n="".concat(this.nestingPrefix,"(.+?)").concat(this.nestingSuffix);this.nestingRegexp=new RegExp(n,"g")}},{key:"interpolate",value:function(e,t,n,r){var a,o,i,l=this,s=this.options&&this.options.interpolation&&this.options.interpolation.defaultVariables||{};function u(e){return e.replace(/\$/g,"$$$$")}var c=function(e){if(e.indexOf(l.formatSeparator)<0){var a=R(t,s,e);return l.alwaysFormat?l.format(a,void 0,n,le(le(le({},r),t),{},{interpolationkey:e})):a}var o=e.split(l.formatSeparator),i=o.shift().trim(),u=o.join(l.formatSeparator).trim();return l.format(R(t,s,i),u,n,le(le(le({},r),t),{},{interpolationkey:i}))};this.resetRegExp();var d=r&&r.missingInterpolationHandler||this.options.missingInterpolationHandler,f=r&&r.interpolation&&void 0!==r.interpolation.skipOnVariables?r.interpolation.skipOnVariables:this.options.interpolation.skipOnVariables;return[{regex:this.regexpUnescape,safeValue:function(e){return u(e)}},{regex:this.regexp,safeValue:function(e){return l.escapeValue?u(l.escape(e)):u(e)}}].forEach((function(t){for(i=0;a=t.regex.exec(e);){var n=a[1].trim();if(void 0===(o=c(n)))if("function"==typeof d){var s=d(e,a,r);o="string"==typeof s?s:""}else if(r&&r.hasOwnProperty(n))o="";else{if(f){o=a[0];continue}l.logger.warn("missed to pass in variable ".concat(n," for interpolating ").concat(e)),o=""}else"string"==typeof o||l.useRawValueToEscape||(o=M(o));var u=t.safeValue(o);if(e=e.replace(a[0],u),f?(t.regex.lastIndex+=o.length,t.regex.lastIndex-=a[0].length):t.regex.lastIndex=0,++i>=l.maxReplaces)break}})),e}},{key:"nest",value:function(e,t){var n,r,a,o=this,i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};function l(e,t){var n=this.nestingOptionsSeparator;if(e.indexOf(n)<0)return e;var r=e.split(new RegExp("".concat(n,"[ ]*{"))),o="{".concat(r[1]);e=r[0];var i=(o=this.interpolate(o,a)).match(/'/g),l=o.match(/"/g);(i&&i.length%2==0&&!l||l.length%2!=0)&&(o=o.replace(/'/g,'"'));try{a=JSON.parse(o),t&&(a=le(le({},t),a))}catch(t){return this.logger.warn("failed parsing options string in nesting for key ".concat(e),t),"".concat(e).concat(n).concat(o)}return delete a.defaultValue,e}for(;n=this.nestingRegexp.exec(e);){var s=[];(a=(a=le({},i)).replace&&"string"!=typeof a.replace?a.replace:a).applyPostProcessor=!1,delete a.defaultValue;var u=!1;if(-1!==n[0].indexOf(this.formatSeparator)&&!/{.*}/.test(n[1])){var c=n[1].split(this.formatSeparator).map((function(e){return e.trim()}));n[1]=c.shift(),s=c,u=!0}if((r=t(l.call(this,n[1].trim(),a),a))&&n[0]===e&&"string"!=typeof r)return r;"string"!=typeof r&&(r=M(r)),r||(this.logger.warn("missed to resolve ".concat(n[1]," for nesting ").concat(e)),r=""),u&&(r=s.reduce((function(e,t){return o.format(e,t,i.lng,le(le({},i),{},{interpolationkey:n[1].trim()}))}),r.trim())),e=e.replace(n[0],r),this.regexp.lastIndex=0}return e}}]),e}();function ue(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,r)}return n}function ce(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?ue(Object(n),!0).forEach((function(t){w(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):ue(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}function de(e){var t={};return function(n,r,a){var o=r+JSON.stringify(a),i=t[o];return i||(i=e(r,a),t[o]=i),i(n)}}var fe=function(){function e(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};p(this,e),this.logger=_.create("formatter"),this.options=t,this.formats={number:de((function(e,t){var n=new Intl.NumberFormat(e,t);return function(e){return n.format(e)}})),currency:de((function(e,t){var n=new Intl.NumberFormat(e,ce(ce({},t),{},{style:"currency"}));return function(e){return n.format(e)}})),datetime:de((function(e,t){var n=new Intl.DateTimeFormat(e,ce({},t));return function(e){return n.format(e)}})),relativetime:de((function(e,t){var n=new Intl.RelativeTimeFormat(e,ce({},t));return function(e){return n.format(e,t.range||"day")}})),list:de((function(e,t){var n=new Intl.ListFormat(e,ce({},t));return function(e){return n.format(e)}}))},this.init(t)}return g(e,[{key:"init",value:function(e){var t=(arguments.length>1&&void 0!==arguments[1]?arguments[1]:{interpolation:{}}).interpolation;this.formatSeparator=t.formatSeparator?t.formatSeparator:t.formatSeparator||","}},{key:"add",value:function(e,t){this.formats[e.toLowerCase().trim()]=t}},{key:"addCached",value:function(e,t){this.formats[e.toLowerCase().trim()]=de(t)}},{key:"format",value:function(e,t,n,r){var a=this;return t.split(this.formatSeparator).reduce((function(e,t){var o=function(e){var t=e.toLowerCase().trim(),n={};if(e.indexOf("(")>-1){var r=e.split("(");t=r[0].toLowerCase().trim();var a=r[1].substring(0,r[1].length-1);"currency"===t&&a.indexOf(":")<0?n.currency||(n.currency=a.trim()):"relativetime"===t&&a.indexOf(":")<0?n.range||(n.range=a.trim()):a.split(";").forEach((function(e){if(e){var t=E(e.split(":")),r=t[0],a=t.slice(1).join(":").trim().replace(/^'+|'+$/g,"");n[r.trim()]||(n[r.trim()]=a),"false"===a&&(n[r.trim()]=!1),"true"===a&&(n[r.trim()]=!0),isNaN(a)||(n[r.trim()]=parseInt(a,10))}}))}return{formatName:t,formatOptions:n}}(t),i=o.formatName,l=o.formatOptions;if(a.formats[i]){var s=e;try{var u=r&&r.formatParams&&r.formatParams[r.interpolationkey]||{},c=u.locale||u.lng||r.locale||r.lng||n;s=a.formats[i](e,c,ce(ce(ce({},l),r),u))}catch(e){a.logger.warn(e)}return s}return a.logger.warn("there was no format function for ".concat(i)),e}),e)}}]),e}();function pe(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,r)}return n}function he(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?pe(Object(n),!0).forEach((function(t){w(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):pe(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}function me(e){var t=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}();return function(){var n,r=k(e);if(t){var a=k(this).constructor;n=Reflect.construct(r,arguments,a)}else n=r.apply(this,arguments);return C(this,n)}}var ge=function(e){y(n,e);var t=me(n);function n(e,r,a){var o,i=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};return p(this,n),o=t.call(this),H&&P.call(v(o)),o.backend=e,o.store=r,o.services=a,o.languageUtils=a.languageUtils,o.options=i,o.logger=_.create("backendConnector"),o.waitingReads=[],o.maxParallelReads=i.maxParallelReads||10,o.readingCalls=0,o.maxRetries=i.maxRetries>=0?i.maxRetries:5,o.retryTimeout=i.retryTimeout>=1?i.retryTimeout:350,o.state={},o.queue=[],o.backend&&o.backend.init&&o.backend.init(a,i.backend,i),o}return g(n,[{key:"queueLoad",value:function(e,t,n,r){var a=this,o={},i={},l={},s={};return e.forEach((function(e){var r=!0;t.forEach((function(t){var l="".concat(e,"|").concat(t);!n.reload&&a.store.hasResourceBundle(e,t)?a.state[l]=2:a.state[l]<0||(1===a.state[l]?void 0===i[l]&&(i[l]=!0):(a.state[l]=1,r=!1,void 0===i[l]&&(i[l]=!0),void 0===o[l]&&(o[l]=!0),void 0===s[t]&&(s[t]=!0)))})),r||(l[e]=!0)})),(Object.keys(o).length||Object.keys(i).length)&&this.queue.push({pending:i,pendingCount:Object.keys(i).length,loaded:{},errors:[],callback:r}),{toLoad:Object.keys(o),pending:Object.keys(i),toLoadLanguages:Object.keys(l),toLoadNamespaces:Object.keys(s)}}},{key:"loaded",value:function(e,t,n){var r=e.split("|"),a=r[0],o=r[1];t&&this.emit("failedLoading",a,o,t),n&&this.store.addResourceBundle(a,o,n),this.state[e]=t?-1:2;var i={};this.queue.forEach((function(n){!function(e,t,n,r){var a=A(e,t,Object),o=a.obj,i=a.k;o[i]=o[i]||[],r&&(o[i]=o[i].concat(n)),r||o[i].push(n)}(n.loaded,[a],o),function(e,t){void 0!==e.pending[t]&&(delete e.pending[t],e.pendingCount--)}(n,e),t&&n.errors.push(t),0!==n.pendingCount||n.done||(Object.keys(n.loaded).forEach((function(e){i[e]||(i[e]={});var t=n.loaded[e];t.length&&t.forEach((function(t){void 0===i[e][t]&&(i[e][t]=!0)}))})),n.done=!0,n.errors.length?n.callback(n.errors):n.callback())})),this.emit("loaded",i),this.queue=this.queue.filter((function(e){return!e.done}))}},{key:"read",value:function(e,t,n){var r=this,a=arguments.length>3&&void 0!==arguments[3]?arguments[3]:0,o=arguments.length>4&&void 0!==arguments[4]?arguments[4]:this.retryTimeout,i=arguments.length>5?arguments[5]:void 0;if(!e.length)return i(null,{});if(this.readingCalls>=this.maxParallelReads)this.waitingReads.push({lng:e,ns:t,fcName:n,tried:a,wait:o,callback:i});else{this.readingCalls++;var l=function(l,s){if(r.readingCalls--,r.waitingReads.length>0){var u=r.waitingReads.shift();r.read(u.lng,u.ns,u.fcName,u.tried,u.wait,u.callback)}l&&s&&a<r.maxRetries?setTimeout((function(){r.read.call(r,e,t,n,a+1,2*o,i)}),o):i(l,s)},s=this.backend[n].bind(this.backend);if(2!==s.length)return s(e,t,l);try{var u=s(e,t);u&&"function"==typeof u.then?u.then((function(e){return l(null,e)})).catch(l):l(null,u)}catch(e){l(e)}}}},{key:"prepareLoading",value:function(e,t){var n=this,r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},a=arguments.length>3?arguments[3]:void 0;if(!this.backend)return this.logger.warn("No backend was added via i18next.use. Will not load resources."),a&&a();"string"==typeof e&&(e=this.languageUtils.toResolveHierarchy(e)),"string"==typeof t&&(t=[t]);var o=this.queueLoad(e,t,r,a);if(!o.toLoad.length)return o.pending.length||a(),null;o.toLoad.forEach((function(e){n.loadOne(e)}))}},{key:"load",value:function(e,t,n){this.prepareLoading(e,t,{},n)}},{key:"reload",value:function(e,t,n){this.prepareLoading(e,t,{reload:!0},n)}},{key:"loadOne",value:function(e){var t=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"",r=e.split("|"),a=r[0],o=r[1];this.read(a,o,"read",void 0,void 0,(function(r,i){r&&t.logger.warn("".concat(n,"loading namespace ").concat(o," for language ").concat(a," failed"),r),!r&&i&&t.logger.log("".concat(n,"loaded namespace ").concat(o," for language ").concat(a),i),t.loaded(e,r,i)}))}},{key:"saveMissing",value:function(e,t,n,r,a){var o=arguments.length>5&&void 0!==arguments[5]?arguments[5]:{},i=arguments.length>6&&void 0!==arguments[6]?arguments[6]:function(){};if(this.services.utils&&this.services.utils.hasLoadedNamespace&&!this.services.utils.hasLoadedNamespace(t))this.logger.warn('did not save key "'.concat(n,'" as the namespace "').concat(t,'" was not yet loaded'),"This means something IS WRONG in your setup. You access the t function before i18next.init / i18next.loadNamespace / i18next.changeLanguage was done. Wait for the callback or Promise to resolve before accessing it!!!");else if(null!=n&&""!==n){if(this.backend&&this.backend.create){var l=he(he({},o),{},{isUpdate:a}),s=this.backend.create.bind(this.backend);if(s.length<6)try{var u;(u=5===s.length?s(e,t,n,r,l):s(e,t,n,r))&&"function"==typeof u.then?u.then((function(e){return i(null,e)})).catch(i):i(null,u)}catch(e){i(e)}else s(e,t,n,r,i,l)}e&&e[0]&&this.store.addResource(e[0],t,n,r)}}}]),n}(P);function ve(){return{debug:!1,initImmediate:!0,ns:["translation"],defaultNS:["translation"],fallbackLng:["dev"],fallbackNS:!1,supportedLngs:!1,nonExplicitSupportedLngs:!1,load:"all",preload:!1,simplifyPluralSuffix:!0,keySeparator:".",nsSeparator:":",pluralSeparator:"_",contextSeparator:"_",partialBundledLanguages:!1,saveMissing:!1,updateMissing:!1,saveMissingTo:"fallback",saveMissingPlurals:!0,missingKeyHandler:!1,missingInterpolationHandler:!1,postProcess:!1,postProcessPassResolved:!1,returnNull:!0,returnEmptyString:!0,returnObjects:!1,joinArrays:!1,returnedObjectHandler:!1,parseMissingKeyHandler:!1,appendNamespaceToMissingKey:!1,appendNamespaceToCIMode:!1,overloadTranslationOptionHandler:function(e){var t={};if("object"===f(e[1])&&(t=e[1]),"string"==typeof e[1]&&(t.defaultValue=e[1]),"string"==typeof e[2]&&(t.tDescription=e[2]),"object"===f(e[2])||"object"===f(e[3])){var n=e[3]||e[2];Object.keys(n).forEach((function(e){t[e]=n[e]}))}return t},interpolation:{escapeValue:!0,format:function(e,t,n,r){return e},prefix:"{{",suffix:"}}",formatSeparator:",",unescapePrefix:"-",nestingPrefix:"$t(",nestingSuffix:")",nestingOptionsSeparator:",",maxReplaces:1e3,skipOnVariables:!0}}}function be(e){return"string"==typeof e.ns&&(e.ns=[e.ns]),"string"==typeof e.fallbackLng&&(e.fallbackLng=[e.fallbackLng]),"string"==typeof e.fallbackNS&&(e.fallbackNS=[e.fallbackNS]),e.supportedLngs&&e.supportedLngs.indexOf("cimode")<0&&(e.supportedLngs=e.supportedLngs.concat(["cimode"])),e}function ye(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,r)}return n}function Ce(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?ye(Object(n),!0).forEach((function(t){w(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):ye(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}function ke(e){var t=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}();return function(){var n,r=k(e);if(t){var a=k(this).constructor;n=Reflect.construct(r,arguments,a)}else n=r.apply(this,arguments);return C(this,n)}}function we(){}var Ee=function(e){y(n,e);var t=ke(n);function n(){var e,r,a=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},o=arguments.length>1?arguments[1]:void 0;if(p(this,n),e=t.call(this),H&&P.call(v(e)),e.options=be(a),e.services={},e.logger=_,e.modules={external:[]},r=v(e),Object.getOwnPropertyNames(Object.getPrototypeOf(r)).forEach((function(e){"function"==typeof r[e]&&(r[e]=r[e].bind(r))})),o&&!e.isInitialized&&!a.isClone){if(!e.options.initImmediate)return e.init(a,o),C(e,v(e));setTimeout((function(){e.init(a,o)}),0)}return e}return g(n,[{key:"init",value:function(){var e=this,t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},n=arguments.length>1?arguments[1]:void 0;"function"==typeof t&&(n=t,t={}),!t.defaultNS&&!1!==t.defaultNS&&t.ns&&("string"==typeof t.ns?t.defaultNS=t.ns:t.ns.indexOf("translation")<0&&(t.defaultNS=t.ns[0]));var r=ve();function a(e){return e?"function"==typeof e?new e:e:null}if(this.options=Ce(Ce(Ce({},r),this.options),be(t)),"v1"!==this.options.compatibilityAPI&&(this.options.interpolation=Ce(Ce({},r.interpolation),this.options.interpolation)),void 0!==t.keySeparator&&(this.options.userDefinedKeySeparator=t.keySeparator),void 0!==t.nsSeparator&&(this.options.userDefinedNsSeparator=t.nsSeparator),!this.options.isClone){var o;this.modules.logger?_.init(a(this.modules.logger),this.options):_.init(null,this.options),this.modules.formatter?o=this.modules.formatter:"undefined"!=typeof Intl&&(o=fe);var i=new ee(this.options);this.store=new G(this.options.resources,this.options);var l=this.services;l.logger=_,l.resourceStore=this.store,l.languageUtils=i,l.pluralResolver=new oe(i,{prepend:this.options.pluralSeparator,compatibilityJSON:this.options.compatibilityJSON,simplifyPluralSuffix:this.options.simplifyPluralSuffix}),!o||this.options.interpolation.format&&this.options.interpolation.format!==r.interpolation.format||(l.formatter=a(o),l.formatter.init(l,this.options),this.options.interpolation.format=l.formatter.format.bind(l.formatter)),l.interpolator=new se(this.options),l.utils={hasLoadedNamespace:this.hasLoadedNamespace.bind(this)},l.backendConnector=new ge(a(this.modules.backend),l.resourceStore,l,this.options),l.backendConnector.on("*",(function(t){for(var n=arguments.length,r=new Array(n>1?n-1:0),a=1;a<n;a++)r[a-1]=arguments[a];e.emit.apply(e,[t].concat(r))})),this.modules.languageDetector&&(l.languageDetector=a(this.modules.languageDetector),l.languageDetector.init&&l.languageDetector.init(l,this.options.detection,this.options)),this.modules.i18nFormat&&(l.i18nFormat=a(this.modules.i18nFormat),l.i18nFormat.init&&l.i18nFormat.init(this)),this.translator=new Y(this.services,this.options),this.translator.on("*",(function(t){for(var n=arguments.length,r=new Array(n>1?n-1:0),a=1;a<n;a++)r[a-1]=arguments[a];e.emit.apply(e,[t].concat(r))})),this.modules.external.forEach((function(t){t.init&&t.init(e)}))}if(this.format=this.options.interpolation.format,n||(n=we),this.options.fallbackLng&&!this.services.languageDetector&&!this.options.lng){var s=this.services.languageUtils.getFallbackCodes(this.options.fallbackLng);s.length>0&&"dev"!==s[0]&&(this.options.lng=s[0])}this.services.languageDetector||this.options.lng||this.logger.warn("init: no languageDetector is used and no lng is defined");["getResource","hasResourceBundle","getResourceBundle","getDataByLanguage"].forEach((function(t){e[t]=function(){var n;return(n=e.store)[t].apply(n,arguments)}}));["addResource","addResources","addResourceBundle","removeResourceBundle"].forEach((function(t){e[t]=function(){var n;return(n=e.store)[t].apply(n,arguments),e}}));var u=N(),c=function(){var t=function(t,r){e.isInitialized&&!e.initializedStoreOnce&&e.logger.warn("init: i18next is already initialized. You should call init just once!"),e.isInitialized=!0,e.options.isClone||e.logger.log("initialized",e.options),e.emit("initialized",e.options),u.resolve(r),n(t,r)};if(e.languages&&"v1"!==e.options.compatibilityAPI&&!e.isInitialized)return t(null,e.t.bind(e));e.changeLanguage(e.options.lng,t)};return this.options.resources||!this.options.initImmediate?c():setTimeout(c,0),u}},{key:"loadResources",value:function(e){var t=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:we,r="string"==typeof e?e:this.language;if("function"==typeof e&&(n=e),!this.options.resources||this.options.partialBundledLanguages){if(r&&"cimode"===r.toLowerCase())return n();var a=[],o=function(e){e&&t.services.languageUtils.toResolveHierarchy(e).forEach((function(e){a.indexOf(e)<0&&a.push(e)}))};if(r)o(r);else this.services.languageUtils.getFallbackCodes(this.options.fallbackLng).forEach((function(e){return o(e)}));this.options.preload&&this.options.preload.forEach((function(e){return o(e)})),this.services.backendConnector.load(a,this.options.ns,(function(e){e||t.resolvedLanguage||!t.language||t.setResolvedLanguage(t.language),n(e)}))}else n(null)}},{key:"reloadResources",value:function(e,t,n){var r=N();return e||(e=this.languages),t||(t=this.options.ns),n||(n=we),this.services.backendConnector.reload(e,t,(function(e){r.resolve(),n(e)})),r}},{key:"use",value:function(e){if(!e)throw new Error("You are passing an undefined module! Please check the object you are passing to i18next.use()");if(!e.type)throw new Error("You are passing a wrong module! Please check the object you are passing to i18next.use()");return"backend"===e.type&&(this.modules.backend=e),("logger"===e.type||e.log&&e.warn&&e.error)&&(this.modules.logger=e),"languageDetector"===e.type&&(this.modules.languageDetector=e),"i18nFormat"===e.type&&(this.modules.i18nFormat=e),"postProcessor"===e.type&&K.addPostProcessor(e),"formatter"===e.type&&(this.modules.formatter=e),"3rdParty"===e.type&&this.modules.external.push(e),this}},{key:"setResolvedLanguage",value:function(e){if(e&&this.languages&&!(["cimode","dev"].indexOf(e)>-1))for(var t=0;t<this.languages.length;t++){var n=this.languages[t];if(!(["cimode","dev"].indexOf(n)>-1)&&this.store.hasLanguageSomeTranslations(n)){this.resolvedLanguage=n;break}}}},{key:"changeLanguage",value:function(e,t){var n=this;this.isLanguageChangingTo=e;var r=N();this.emit("languageChanging",e);var a=function(e){n.language=e,n.languages=n.services.languageUtils.toResolveHierarchy(e),n.resolvedLanguage=void 0,n.setResolvedLanguage(e)},o=function(o){e||o||!n.services.languageDetector||(o=[]);var i="string"==typeof o?o:n.services.languageUtils.getBestMatchFromCodes(o);i&&(n.language||a(i),n.translator.language||n.translator.changeLanguage(i),n.services.languageDetector&&n.services.languageDetector.cacheUserLanguage&&n.services.languageDetector.cacheUserLanguage(i)),n.loadResources(i,(function(e){!function(e,o){o?(a(o),n.translator.changeLanguage(o),n.isLanguageChangingTo=void 0,n.emit("languageChanged",o),n.logger.log("languageChanged",o)):n.isLanguageChangingTo=void 0,r.resolve((function(){return n.t.apply(n,arguments)})),t&&t(e,(function(){return n.t.apply(n,arguments)}))}(e,i)}))};return e||!this.services.languageDetector||this.services.languageDetector.async?!e&&this.services.languageDetector&&this.services.languageDetector.async?0===this.services.languageDetector.detect.length?this.services.languageDetector.detect().then(o):this.services.languageDetector.detect(o):o(e):o(this.services.languageDetector.detect()),r}},{key:"getFixedT",value:function(e,t,n){var r=this,a=function e(t,a){var o;if("object"!==f(a)){for(var i=arguments.length,l=new Array(i>2?i-2:0),s=2;s<i;s++)l[s-2]=arguments[s];o=r.options.overloadTranslationOptionHandler([t,a].concat(l))}else o=Ce({},a);o.lng=o.lng||e.lng,o.lngs=o.lngs||e.lngs,o.ns=o.ns||e.ns,o.keyPrefix=o.keyPrefix||n||e.keyPrefix;var u,c=r.options.keySeparator||".";return u=o.keyPrefix&&Array.isArray(t)?t.map((function(e){return"".concat(o.keyPrefix).concat(c).concat(e)})):o.keyPrefix?"".concat(o.keyPrefix).concat(c).concat(t):t,r.t(u,o)};return"string"==typeof e?a.lng=e:a.lngs=e,a.ns=t,a.keyPrefix=n,a}},{key:"t",value:function(){var e;return this.translator&&(e=this.translator).translate.apply(e,arguments)}},{key:"exists",value:function(){var e;return this.translator&&(e=this.translator).exists.apply(e,arguments)}},{key:"setDefaultNamespace",value:function(e){this.options.defaultNS=e}},{key:"hasLoadedNamespace",value:function(e){var t=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!this.isInitialized)return this.logger.warn("hasLoadedNamespace: i18next was not initialized",this.languages),!1;if(!this.languages||!this.languages.length)return this.logger.warn("hasLoadedNamespace: i18n.languages were undefined or empty",this.languages),!1;var r=this.resolvedLanguage||this.languages[0],a=!!this.options&&this.options.fallbackLng,o=this.languages[this.languages.length-1];if("cimode"===r.toLowerCase())return!0;var i=function(e,n){var r=t.services.backendConnector.state["".concat(e,"|").concat(n)];return-1===r||2===r};if(n.precheck){var l=n.precheck(this,i);if(void 0!==l)return l}return!!this.hasResourceBundle(r,e)||(!(this.services.backendConnector.backend&&(!this.options.resources||this.options.partialBundledLanguages))||!(!i(r,e)||a&&!i(o,e)))}},{key:"loadNamespaces",value:function(e,t){var n=this,r=N();return this.options.ns?("string"==typeof e&&(e=[e]),e.forEach((function(e){n.options.ns.indexOf(e)<0&&n.options.ns.push(e)})),this.loadResources((function(e){r.resolve(),t&&t(e)})),r):(t&&t(),Promise.resolve())}},{key:"loadLanguages",value:function(e,t){var n=N();"string"==typeof e&&(e=[e]);var r=this.options.preload||[],a=e.filter((function(e){return r.indexOf(e)<0}));return a.length?(this.options.preload=r.concat(a),this.loadResources((function(e){n.resolve(),t&&t(e)})),n):(t&&t(),Promise.resolve())}},{key:"dir",value:function(e){if(e||(e=this.resolvedLanguage||(this.languages&&this.languages.length>0?this.languages[0]:this.language)),!e)return"rtl";var t=this.services&&this.services.languageUtils||new ee(ve());return["ar","shu","sqr","ssh","xaa","yhd","yud","aao","abh","abv","acm","acq","acw","acx","acy","adf","ads","aeb","aec","afb","ajp","apc","apd","arb","arq","ars","ary","arz","auz","avl","ayh","ayl","ayn","ayp","bbz","pga","he","iw","ps","pbt","pbu","pst","prp","prd","ug","ur","ydd","yds","yih","ji","yi","hbo","men","xmn","fa","jpr","peo","pes","prs","dv","sam","ckb"].indexOf(t.getLanguagePartFromCode(e))>-1||e.toLowerCase().indexOf("-arab")>1?"rtl":"ltr"}},{key:"cloneInstance",value:function(){var e=this,t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:we,a=Ce(Ce(Ce({},this.options),t),{isClone:!0}),o=new n(a);void 0===t.debug&&void 0===t.prefix||(o.logger=o.logger.clone(t));return["store","services","language"].forEach((function(t){o[t]=e[t]})),o.services=Ce({},this.services),o.services.utils={hasLoadedNamespace:o.hasLoadedNamespace.bind(o)},o.translator=new Y(o.services,o.options),o.translator.on("*",(function(e){for(var t=arguments.length,n=new Array(t>1?t-1:0),r=1;r<t;r++)n[r-1]=arguments[r];o.emit.apply(o,[e].concat(n))})),o.init(a,r),o.translator.options=o.options,o.translator.backendConnector.services.utils={hasLoadedNamespace:o.hasLoadedNamespace.bind(o)},o}},{key:"toJSON",value:function(){return{options:this.options,store:this.store,language:this.language,languages:this.languages,resolvedLanguage:this.resolvedLanguage}}}]),n}(P);w(Ee,"createInstance",(function(){return new Ee(arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},arguments.length>1?arguments[1]:void 0)}));var xe=Ee.createInstance();xe.createInstance=Ee.createInstance;xe.createInstance,xe.dir,xe.init,xe.loadResources,xe.reloadResources,xe.use,xe.changeLanguage,xe.getFixedT;var Se=xe.t,Oe=(xe.exists,xe.setDefaultNamespace,xe.hasLoadedNamespace,xe.loadNamespaces,xe.loadLanguages,n(745));n(739);Object.create(null);var Le=/&(?:amp|#38|lt|#60|gt|#62|apos|#39|quot|#34|nbsp|#160|copy|#169|reg|#174|hellip|#8230|#x2F|#47);/g,_e={"&amp;":"&","&#38;":"&","&lt;":"<","&#60;":"<","&gt;":">","&#62;":">","&apos;":"'","&#39;":"'","&quot;":'"',"&#34;":'"',"&nbsp;":" ","&#160;":" ","&copy;":"©","&#169;":"©","&reg;":"®","&#174;":"®","&hellip;":"…","&#8230;":"…","&#x2F;":"/","&#47;":"/"},Pe=function(e){return _e[e]};function Ne(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,r)}return n}function Me(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?Ne(Object(n),!0).forEach((function(t){w(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):Ne(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}var Ae={bindI18n:"languageChanged",bindI18nStore:"",transEmptyNodeValue:"",transSupportBasicHtmlNodes:!0,transWrapTextNodes:"",transKeepBasicHtmlNodesFor:["br","strong","i","p"],useSuspense:!0,unescape:function(e){return e.replace(Le,Pe)}};var Ie={type:"3rdParty",init:function(e){!function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};Ae=Me(Me({},Ae),e)}(e.options.react),function(e){e}(e)}};(0,d.createContext)(),function(){function e(){p(this,e),this.usedNamespaces={}}g(e,[{key:"addUsedNamespaces",value:function(e){var t=this;e.forEach((function(e){t.usedNamespaces[e]||(t.usedNamespaces[e]=!0)}))}},{key:"getUsedNamespaces",value:function(){return Object.keys(this.usedNamespaces)}}])}();var Fe=[],Re=Fe.forEach,Ve=Fe.slice;var je=/^[\u0009\u0020-\u007e\u0080-\u00ff]+$/,ze=function(e,t,n){var r=n||{};r.path=r.path||"/";var a=encodeURIComponent(t),o="".concat(e,"=").concat(a);if(r.maxAge>0){var i=r.maxAge-0;if(Number.isNaN(i))throw new Error("maxAge should be a Number");o+="; Max-Age=".concat(Math.floor(i))}if(r.domain){if(!je.test(r.domain))throw new TypeError("option domain is invalid");o+="; Domain=".concat(r.domain)}if(r.path){if(!je.test(r.path))throw new TypeError("option path is invalid");o+="; Path=".concat(r.path)}if(r.expires){if("function"!=typeof r.expires.toUTCString)throw new TypeError("option expires is invalid");o+="; Expires=".concat(r.expires.toUTCString())}if(r.httpOnly&&(o+="; HttpOnly"),r.secure&&(o+="; Secure"),r.sameSite)switch("string"==typeof r.sameSite?r.sameSite.toLowerCase():r.sameSite){case!0:o+="; SameSite=Strict";break;case"lax":o+="; SameSite=Lax";break;case"strict":o+="; SameSite=Strict";break;case"none":o+="; SameSite=None";break;default:throw new TypeError("option sameSite is invalid")}return o},Te=function(e,t,n,r){var a=arguments.length>4&&void 0!==arguments[4]?arguments[4]:{path:"/",sameSite:"strict"};n&&(a.expires=new Date,a.expires.setTime(a.expires.getTime()+60*n*1e3)),r&&(a.domain=r),document.cookie=ze(e,encodeURIComponent(t),a)},He=function(e){for(var t="".concat(e,"="),n=document.cookie.split(";"),r=0;r<n.length;r++){for(var a=n[r];" "===a.charAt(0);)a=a.substring(1,a.length);if(0===a.indexOf(t))return a.substring(t.length,a.length)}return null},De={name:"cookie",lookup:function(e){var t;if(e.lookupCookie&&"undefined"!=typeof document){var n=He(e.lookupCookie);n&&(t=n)}return t},cacheUserLanguage:function(e,t){t.lookupCookie&&"undefined"!=typeof document&&Te(t.lookupCookie,e,t.cookieMinutes,t.cookieDomain,t.cookieOptions)}},Be={name:"querystring",lookup:function(e){var t;if("undefined"!=typeof window){var n=window.location.search;!window.location.search&&window.location.hash&&window.location.hash.indexOf("?")>-1&&(n=window.location.hash.substring(window.location.hash.indexOf("?")));for(var r=n.substring(1).split("&"),a=0;a<r.length;a++){var o=r[a].indexOf("=");if(o>0)r[a].substring(0,o)===e.lookupQuerystring&&(t=r[a].substring(o+1))}}return t}},Ue=null,Ze=function(){if(null!==Ue)return Ue;try{Ue="undefined"!==window&&null!==window.localStorage;var e="i18next.translate.boo";window.localStorage.setItem(e,"foo"),window.localStorage.removeItem(e)}catch(e){Ue=!1}return Ue},We={name:"localStorage",lookup:function(e){var t;if(e.lookupLocalStorage&&Ze()){var n=window.localStorage.getItem(e.lookupLocalStorage);n&&(t=n)}return t},cacheUserLanguage:function(e,t){t.lookupLocalStorage&&Ze()&&window.localStorage.setItem(t.lookupLocalStorage,e)}},Ge=null,Ke=function(){if(null!==Ge)return Ge;try{Ge="undefined"!==window&&null!==window.sessionStorage;var e="i18next.translate.boo";window.sessionStorage.setItem(e,"foo"),window.sessionStorage.removeItem(e)}catch(e){Ge=!1}return Ge},$e={name:"sessionStorage",lookup:function(e){var t;if(e.lookupSessionStorage&&Ke()){var n=window.sessionStorage.getItem(e.lookupSessionStorage);n&&(t=n)}return t},cacheUserLanguage:function(e,t){t.lookupSessionStorage&&Ke()&&window.sessionStorage.setItem(t.lookupSessionStorage,e)}},Je={name:"navigator",lookup:function(e){var t=[];if("undefined"!=typeof navigator){if(navigator.languages)for(var n=0;n<navigator.languages.length;n++)t.push(navigator.languages[n]);navigator.userLanguage&&t.push(navigator.userLanguage),navigator.language&&t.push(navigator.language)}return t.length>0?t:void 0}},Qe={name:"htmlTag",lookup:function(e){var t,n=e.htmlTag||("undefined"!=typeof document?document.documentElement:null);return n&&"function"==typeof n.getAttribute&&(t=n.getAttribute("lang")),t}},qe={name:"path",lookup:function(e){var t;if("undefined"!=typeof window){var n=window.location.pathname.match(/\/([a-zA-Z-]*)/g);if(n instanceof Array)if("number"==typeof e.lookupFromPathIndex){if("string"!=typeof n[e.lookupFromPathIndex])return;t=n[e.lookupFromPathIndex].replace("/","")}else t=n[0].replace("/","")}return t}},Ye={name:"subdomain",lookup:function(e){var t="number"==typeof e.lookupFromSubdomainIndex?e.lookupFromSubdomainIndex+1:1,n="undefined"!=typeof window&&window.location&&window.location.hostname&&window.location.hostname.match(/^(\w{2,5})\.(([a-z0-9-]{1,63}\.[a-z]{2,6})|localhost)/i);if(n)return n[t]}};var Xe=function(){function e(t){var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};p(this,e),this.type="languageDetector",this.detectors={},this.init(t,n)}return g(e,[{key:"init",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};this.services=e,this.options=function(e){return Re.call(Ve.call(arguments,1),(function(t){if(t)for(var n in t)void 0===e[n]&&(e[n]=t[n])})),e}(t,this.options||{},{order:["querystring","cookie","localStorage","sessionStorage","navigator","htmlTag"],lookupQuerystring:"lng",lookupCookie:"i18next",lookupLocalStorage:"i18nextLng",lookupSessionStorage:"i18nextLng",caches:["localStorage"],excludeCacheFor:["cimode"]}),this.options.lookupFromUrlIndex&&(this.options.lookupFromPathIndex=this.options.lookupFromUrlIndex),this.i18nOptions=n,this.addDetector(De),this.addDetector(Be),this.addDetector(We),this.addDetector($e),this.addDetector(Je),this.addDetector(Qe),this.addDetector(qe),this.addDetector(Ye)}},{key:"addDetector",value:function(e){this.detectors[e.name]=e}},{key:"detect",value:function(e){var t=this;e||(e=this.options.order);var n=[];return e.forEach((function(e){if(t.detectors[e]){var r=t.detectors[e].lookup(t.options);r&&"string"==typeof r&&(r=[r]),r&&(n=n.concat(r))}})),this.services.languageUtils.getBestMatchFromCodes?n:n.length>0?n[0]:null}},{key:"cacheUserLanguage",value:function(e,t){var n=this;t||(t=this.options.caches),t&&(this.options.excludeCacheFor&&this.options.excludeCacheFor.indexOf(e)>-1||t.forEach((function(t){n.detectors[t]&&n.detectors[t].cacheUserLanguage(e,n.options)})))}}]),e}();Xe.type="languageDetector";const et=JSON.parse('{"nav.later":"По-късно","nav.prev":"Предишна","nav.next":"Следваща","nav.done":"Готово","intro.header":"Opera One.","intro.subheader":"Настройване на новия ви браузър","intro.button":"Начало","themes.header":"В какво настроение сте?","themes.subheader":"Избор на тема на браузъра","themes.light":"Светло","themes.dark":"Тъмно","themes.system":"Система","wallpapers.header":"Какъв е вашият стил?","wallpapers.subheader":"Избор на тапет за Стартовата страница","adblocker.header":"По-бърза навигация без реклами","adblocker.subheader":"Включете блокирането на реклами,","adblocker.label":"Блокиране на реклами","adblocker.tooltip":"Включено!","messengers.header":"Бъдете в крак с всички","messengers.subheader":"Добавяне на любими приложения за социални медии","import.header":"Внасяне на вашите данни","import.subheader":"Изберете браузър по-долу","import.tooltip":"Внесени!","outro.header":"Вашият браузър Opera е готов.","outro.subheader":"И още нещо! Влезте в своя профил в Opera, за да имате достъп до Aria, AI на браузъра Opera.","outro.description":"Получете достъп до Aria, VPN Pro и Cashback със своя безплатен профил в Opera.","outro.button":"Започнете да сърфирате"}'),tt=JSON.parse('{"nav.later":"পরে","nav.prev":"পূর্ববর্তী","nav.next":"পরবর্তী","nav.done":"সম্পন্ন","intro.header":"Opera One","intro.subheader":"আপনার নতুন ব্রাউজার সেট আপ করুন","intro.button":"ব্যবহার করে দেখুন","themes.header":"আপনার মুড কেমন আছে?","themes.subheader":"ব্রাউজার থিম নির্বাচন করুন","themes.light":"হালকা","themes.dark":"ঘন","themes.system":"সিস্টেম","wallpapers.header":"আপনার স্টাইল কেমন?","wallpapers.subheader":"সূচনা পৃষ্ঠার ওয়ালপেপার নির্বাচন করুন","adblocker.header":"বিজ্ঞাপন মুক্ত ভাবে দ্রুত ব্রাউজ করুন","adblocker.subheader":"অ্যাড ব্লকার চালু করুন","adblocker.label":"বিজ্ঞাপনগুলি অবরোধ করুন","adblocker.tooltip":"সক্ষম!","messengers.header":"সবার সাথে তাল মিলিয়ে চলুন","messengers.subheader":"আপনার পছন্দের সোশ্যাল অ্যাপ যোগ করুন","import.header":"আপনার ডেটা ইম্পোর্ট করুন","import.subheader":"নীচে ব্রাউজার নির্বাচন করুন","import.tooltip":"ইম্পোর্ট করা হয়েছে!","outro.header":"আপনার Opera ব্রাউজার প্রস্তুত।","outro.subheader":"আরও একটি জিনিস! Opera-এর ব্রাউজার AI, Aria অ্যাক্সেস করতে আপনার Opera অ্যাকাউন্টে লগ ইন করুন।","outro.description":"আপনার ফ্রি Opera অ্যাকাউন্ট দিয়ে Aria, VPN Pro ও Cashback অ্যাক্সেস করুন।","outro.button":"ব্রাউজ করা শুরু করুন"}'),nt=JSON.parse('{"nav.later":"Més tard","nav.prev":"Anterior","nav.next":"Següent","nav.done":"Fet","intro.header":"Opera One","intro.subheader":"Configura el teu navegador nou","intro.button":"Primers passos","themes.header":"Indica el teu estat d’ànim","themes.subheader":"Selecciona un tema del navegador","themes.light":"Clar","themes.dark":"Fosc","themes.system":"Sistema","wallpapers.header":"Indica el teu estil","wallpapers.subheader":"Selecciona el fons de pantalla de la pàgina inicial","adblocker.header":"Navega més de pressa sense anuncis","adblocker.subheader":"Activa el bloqueig d\'anuncis","adblocker.label":"Bloqueja els anuncis","adblocker.tooltip":"Activat!","messengers.header":"Estigues al corrent de tothom","messengers.subheader":"Afegeix les teves xarxes socials preferides","import.header":"Importa les teves dades","import.subheader":"Selecciona un navegador tot seguit","import.tooltip":"Importat!","outro.header":"El teu navegador Opera ja és a punt.","outro.subheader":"Una altra cosa... Inicia sessió al teu compte d’Opera per accedir a Aria, la IA del navegador Opera.","outro.description":"Accedeix a Aria, VPN Pro i Cashback amb el teu compte gratuït d’Opera.","outro.button":"Comença a navegar"}'),rt=JSON.parse('{"nav.later":"Později","nav.prev":"Předch.","nav.next":"Další","nav.done":"Dokončeno","intro.header":"Opera One","intro.subheader":"Nastavte si svůj nový prohlížeč","intro.button":"Začínáme","themes.header":"Jakou máte náladu?","themes.subheader":"Výběr tématu prohlížeče","themes.light":"Světlé","themes.dark":"Tmavé","themes.system":"Systém","wallpapers.header":"Jaký máte styl?","wallpapers.subheader":"Výběr tapety úvodní stránky","adblocker.header":"Rychlejší prohlížení bez reklam","adblocker.subheader":"Zapněte blokování reklam","adblocker.label":"Blokování reklam","adblocker.tooltip":"Povoleno!","messengers.header":"Držte krok s ostatními","messengers.subheader":"Přidejte své oblíbené sociální aplikace","import.header":"Synchronizujte svá data","import.subheader":"Z následující nabídky vyberte prohlížeč","import.tooltip":"Importováno!","outro.header":"Prohlížeč Opera je připraven.","outro.subheader":"Ještě něco! Přihlaste se ke svému účtu Opera a získejte přístup k aplikaci Aria, umělé inteligenci prohlížeče Opera.","outro.description":"S bezplatným účtem Opera získáte přístup k aplikacím Aria, VPN Pro a Cashback.","outro.button":"Začít prohlížet web"}'),at=JSON.parse('{"nav.later":"Senere","nav.prev":"Forrige","nav.next":"Næste","nav.done":"Udfør","intro.header":"Opera One.","intro.subheader":"Konfigurer din nye browser","intro.button":"Kom godt i gang","themes.header":"Hvordan er dit humør?","themes.subheader":"Vælg et browsertema","themes.light":"Lys","themes.dark":"Mørk","themes.system":"System","wallpapers.header":"Hvad er din stil?","wallpapers.subheader":"Vælg en baggrund til startsiden","adblocker.header":"Surf hurtigere uden annoncer","adblocker.subheader":"Slå annonceblokering til","adblocker.label":"Bloker annoncer","adblocker.tooltip":"Aktiveret!","messengers.header":"Hold dig opdateret med alle","messengers.subheader":"Tilføj dine foretrukne sociale apps","import.header":"Importér dine data","import.subheader":"Vælg en browser nedenfor","import.tooltip":"Importeret!","outro.header":"Din Opera-browser er klar.","outro.subheader":"En ting til! Log ind på din Opera-konto for at få adgang til Aria, Operas browser-AI.","outro.description":"Få adgang til Aria, VPN Pro og Cashback med din gratis Opera-konto.","outro.button":"Begynd at browse"}'),ot=JSON.parse('{"nav.later":"Später","nav.prev":"Vorherige","nav.next":"Nächste","nav.done":"Fertig","intro.header":"Opera One.","intro.subheader":"Richte deinen neuen Browser ein","intro.button":"Erste Schritte","themes.header":"Wonach steht dir der Sinn?","themes.subheader":"Wähle ein Browserdesign aus","themes.light":"Hell","themes.dark":"Dunkel","themes.system":"System","wallpapers.header":"Welcher Stil gefällt dir?","wallpapers.subheader":"Wähle ein Hintergrundbild für die Startseite aus","adblocker.header":"Ohne Werbung schneller surfen","adblocker.subheader":"Aktiviere den Werbeblocker","adblocker.label":"Werbung blockieren","adblocker.tooltip":"Aktiviert!","messengers.header":"Kontakte pflegen","messengers.subheader":"Füge deine bevorzugten Social-Media-Apps hinzu","import.header":"Deine Daten importieren","import.subheader":"Wähle unten einen Browser","import.tooltip":"Importiert!","outro.header":"Dein Opera-Browser ist startbereit.","outro.subheader":"Noch eine Sache! Melde dich bei deinem Opera-Konto an, um auf Aria, die Browser-KI von Opera, zuzugreifen.","outro.description":"Mit deinem kostenlosen Opera-Konto erhältst du Zugriff auf Aria, VPN Pro und Cashback.","outro.button":"Browsen beginnen"}'),it=JSON.parse('{"nav.later":"Αργότερα","nav.prev":"Προηγούμενο","nav.next":"Επόμενο","nav.done":"Τέλος","intro.header":"Opera One.","intro.subheader":"Ρυθμίστε το νέο πρόγραμμα περιήγησης","intro.button":"Ξεκινήστε","themes.header":"Σε τι διάθεση βρίσκεστε;","themes.subheader":"Επιλέξτε θέμα προγράμματος περιήγησης","themes.light":"Φωτεινό","themes.dark":"Σκοτεινό","themes.system":"Σύστημα","wallpapers.header":"Ποιο είναι το στυλ σας;","wallpapers.subheader":"Επιλέξτε ταπετσαρία για την Αρχική Σελίδα","adblocker.header":"Ταχύτερη περιήγηση χωρίς διαφημίσεις","adblocker.subheader":"Ενεργοποιήστε τον αποκλεισμό διαφημίσεων","adblocker.label":"Αποκλεισμός διαφημίσεων","adblocker.tooltip":"Ενεργοποιήθηκε!","messengers.header":"Μάθετε τα νέα των φίλων σας","messengers.subheader":"Προσθέστε τις εφαρμογές των αγαπημένων σας μέσων κοινωνικής δικτύωσης","import.header":"Εισάγετε τα δεδομένα σας","import.subheader":"Επιλέξτε ένα από τα παρακάτω προγράμματα περιήγησης","import.tooltip":"Εισήχθη!","outro.header":"Το πρόγραμμα περιήγησης Opera είναι έτοιμο.","outro.subheader":"Και κάτι ακόμα! Μπείτε στον λογαριασμό σας και αποκτήστε πρόσβαση στο Aria, το Browser AI του Opera.","outro.description":"Αποκτήστε πρόσβαση στο Aria, το VPN Pro και το Cashback με τον δωρεάν λογαριασμό σας στο Opera.","outro.button":"Έναρξη περιήγησης"}'),lt=JSON.parse('{"browser.chrome":"Chrome","browser.edge":"Edge","browser.safari":"Safari","browser.firefox":"Firefox","nav.later":"Later","nav.prev":"Prev","nav.next":"Next","nav.done":"Done","intro.header":"Opera One.","intro.subheader":"Set up your new browser","intro.button":"Get started","themes.header":"What\'s your mood?","themes.subheader":"Select a browser theme","themes.light":"Light","themes.dark":"Dark","themes.system":"System","wallpapers.header":"What\'s your style?","wallpapers.subheader":"Select a Start Page wallpaper","adblocker.header":"Browse faster ad-free","adblocker.subheader":"Turn on ad blocker","adblocker.label":"Block ads","adblocker.tooltip":"Enabled!","messengers.header":"Keep up with everyone","messengers.subheader":"Add your favourite social apps","import.header":"Import your data","import.subheader":"Select a browser below","import.tooltip":"Imported!","outro.header":"Your Opera browser is ready.","outro.subheader":"One more thing! Log into your Opera account to access Aria, Opera\'s Browser AI.","outro.description":"Access Aria, VPN Pro and Cashback with your free Opera account.","outro.button":"Start browsing"}'),st=JSON.parse('{"nav.later":"Después","nav.prev":"Anterior","nav.next":"Siguiente","nav.done":"Listo","intro.header":"Opera One.","intro.subheader":"Configura tu nuevo navegador","intro.button":"Comenzar","themes.header":"¿Cuál es tu estado de ánimo?","themes.subheader":"Selecciona un tema para el navegador","themes.light":"Claro","themes.dark":"Oscuro","themes.system":"Sistema","wallpapers.header":"¿Cuál es tu estilo?","wallpapers.subheader":"Selecciona una imagen de fondo para la página de inicio","adblocker.header":"Navega más rápido sin anuncios","adblocker.subheader":"Activa el bloqueador de publicidad","adblocker.label":"Bloquear publicidad","adblocker.tooltip":"Activado.","messengers.header":"Mantente al día","messengers.subheader":"Añade tus aplicaciones de redes sociales preferidas","import.header":"Importa tus datos","import.subheader":"Selecciona un navegador abajo","import.tooltip":"¡Importado!","outro.header":"Tu Navegador Opera está listo.","outro.subheader":"Una cosa más... Inicia sesión en tu cuenta de Opera para acceder a Aria, la IA del Navegador Opera.","outro.description":"Accede a Aria, VPN Pro y Cashback con tu cuenta gratuita de Opera.","outro.button":"Comienza a navegar"}'),ut=JSON.parse('{"nav.later":"Más tarde","nav.prev":"Anterior","nav.next":"Siguiente","nav.done":"Hecho","intro.header":"Opera One","intro.subheader":"Configura tu nuevo navegador","intro.button":"Primeros pasos","themes.header":"Indica tu estado de ánimo","themes.subheader":"selecciona un tema del navegador","themes.light":"Claro","themes.dark":"Oscuro","themes.system":"Sistema","wallpapers.header":"Indica tu estilo","wallpapers.subheader":"Selecciona un fondo de pantalla para la página de inicio","adblocker.header":"Navega más rápido sin anuncios","adblocker.subheader":"Activa el bloqueo de publicidad","adblocker.label":"Bloquear publicidad","adblocker.tooltip":"¡Activado!","messengers.header":"Mantente al corriente de todos","messengers.subheader":"Añade tus redes sociales favoritas","import.header":"Importa tus datos","import.subheader":"Selecciona un navegador a continuación","import.tooltip":"¡Importado!","outro.header":"Tu navegador Opera ya está listo.","outro.subheader":"Una cosa más... Inicia sesión en tu cuenta de Opera para acceder a Aria, la IA del navegador Opera.","outro.description":"Accede a Aria, VPN Pro y Cashback con tu cuenta gratuita de Opera.","outro.button":"Empezar a navegar"}'),ct=JSON.parse('{"nav.later":"Myöhemmin","nav.prev":"Edellinen","nav.next":"Seuraava","nav.done":"Valmis","intro.header":"Opera One","intro.subheader":"Määritä uusi selaimesi","intro.button":"Aloita","themes.header":"Millä tuulella olet?","themes.subheader":"Valitse selaimen teema","themes.light":"Vaalea","themes.dark":"Tumma","themes.system":"Järjestelmä","wallpapers.header":"Mistä tyylistä pidät?","wallpapers.subheader":"Valitse aloitussivun taustakuva","adblocker.header":"Selaa nopeammin ilman mainoksia","adblocker.subheader":"Ota mainosten esto käyttöön","adblocker.label":"Mainosten esto","adblocker.tooltip":"Käytössä!","messengers.header":"Pysy ajan tasalla kuulumisista","messengers.subheader":"Lisää käyttämäsi sosiaalisen median sovellukset","import.header":"Tuo tietosi","import.subheader":"Valitse alta selain","import.tooltip":"Tuotu!","outro.header":"Opera-selaimesi on valmiina käytettäväksi.","outro.subheader":"Vielä yksi asia! Kirjaudu Opera-tilillesi, jotta voit käyttää Ariaa eli Opera-selaimen tekoälyä.","outro.description":"Käytä maksuttomalla Opera-tilillä Ariaa, VPN Prota ja Cashback-hyvityksiä.","outro.button":"Aloita selaaminen"}'),dt=JSON.parse('{"nav.later":"Plus tard","nav.prev":"Préc","nav.next":"Suivant","nav.done":"Fait","intro.header":"Opera One.","intro.subheader":"Configure ton nouveau navigateur","intro.button":"Commencer","themes.header":"Quelle est ton humeur ?","themes.subheader":"Sélectionne un thème de navigateur","themes.light":"Clair","themes.dark":"Sombre","themes.system":"Système","wallpapers.header":"Quel est ton style ?","wallpapers.subheader":"Sélectionne un fond d\'écran pour la page de démarrage","adblocker.header":"Navigue plus vite et sans pubs","adblocker.subheader":"Activer le blocage des pubs","adblocker.label":"Bloquer les pubs","adblocker.tooltip":"Activé !","messengers.header":"Reste en contact avec tout le monde","messengers.subheader":"Ajoute les applis de tes réseaux sociaux préférés","import.header":"Importe tes données","import.subheader":"Sélectionne un navigateur ci-dessous","import.tooltip":"Importé !","outro.header":"Ton navigateur Opera est prêt.","outro.subheader":"Encore une chose... Connecte-toi à ton compte Opera pour accéder à Aria, l’IA du navigateur Opera.","outro.description":"Accède à Aria, VPN Pro et Cashback avec ton compte Opera gratuit.","outro.button":"Commencer la navigation"}'),ft=JSON.parse('{"nav.later":"बाद में","nav.prev":"पिछला","nav.next":"अगला","nav.done":"पूरा हुआ","intro.header":"Opera One.","intro.subheader":"अपना नया ब्राउज़र सेट करें","intro.button":"शुरू करें","themes.header":"आपका मूड कैसा है?","themes.subheader":"एक ब्राउज़र थीम चुनें","themes.light":"हल्का","themes.dark":"गहरा","themes.system":"सिस्टम:","wallpapers.header":"आपका स्टाइल कैसा है?","wallpapers.subheader":"स्टार्ट पेज वॉलपेपर चुनें","adblocker.header":"बिना विज्ञापन के तेज़ गति से ब्राउज़ करें","adblocker.subheader":"विज्ञापन अवरोधक चालू करें","adblocker.label":"विज्ञापन अवरोधित करें","adblocker.tooltip":"सक्षम किया!","messengers.header":"सभी के साथ रहें","messengers.subheader":"अपनी पसंदीदा सोशल ऐप्स जोड़ें","import.header":"अपना डेटा इम्पोर्ट करें","import.subheader":"नीचे ब्राउज़र चुनें","import.tooltip":"इम्पोर्ट किया गया!","outro.header":"आपका Opera ब्राउज़र तैयार है।","outro.subheader":"एक और बात... Aria, Opera ब्राउज़र AI तक पहुँच पाने के लिए अपने Opera खाते में लॉग इन करें।","outro.description":"अपने मुफ़्त Opera खाते से Aria, VPN Pro और कैशबेक तक पहुँच पाएं।","outro.button":"ब्राउज़िंग प्रारंभ करें"}'),pt=JSON.parse('{"nav.later":"Kasnije","nav.prev":"Preth.","nav.next":"Sljedeće","nav.done":"Gotovo","intro.header":"Opera One.","intro.subheader":"Postavite svoj novi preglednik","intro.button":"Počnite","themes.header":"Kako ste raspoloženi?","themes.subheader":"Odaberite temu preglednika","themes.light":"Svijetla","themes.dark":"Tamna","themes.system":"Sustav","wallpapers.header":"Koji je vaš stil?","wallpapers.subheader":"Odaberite pozadinu početne stranice","adblocker.header":"Pregledavajte brže bez oglasa","adblocker.subheader":"Uključi blokiranje oglasa","adblocker.label":"Blokiranje oglasa","adblocker.tooltip":"Omogućeno!","messengers.header":"Budite u toku sa svima","messengers.subheader":"Dodajte omiljene društvene aplikacije","import.header":"Uvezite svoje podatke","import.subheader":"Odaberite preglednik u nastavku","import.tooltip":"Uvezeno!","outro.header":"Vaš preglednik Opera je spreman.","outro.subheader":"Još jedna stvar! Prijavite se u račun Opera da biste pristupili značajci Aria, AI-ju preglednika Opera.","outro.description":"Besplatno pristupite značajci Aria, VPN Pro i Cashback svojim računom Opera.","outro.button":"Započni pregledavanje"}'),ht=JSON.parse('{"nav.later":"Később","nav.prev":"Előző","nav.next":"Következő","nav.done":"Kész","intro.header":"Opera One.","intro.subheader":"Új böngészőjének beállítása","intro.button":"Kezdés","themes.header":"Milyen a hangulata?","themes.subheader":"Válasszon böngésző témát","themes.light":"Világos","themes.dark":"Sötét","themes.system":"Rendszer:","wallpapers.header":"Milyen a stílusa?","wallpapers.subheader":"Válasszon kezdőlap háttérképet","adblocker.header":"Böngésszen gyorsabban reklámmentesen","adblocker.subheader":"Reklámblokkolás bekapcsolása","adblocker.label":"Reklámok blokkolása","adblocker.tooltip":"Engedélyezve!","messengers.header":"Tartson lépést mindenkivel","messengers.subheader":"Kedvenc közösségi appok hozzáadása","import.header":"Adatok importálása","import.subheader":"Válasszon böngészőt alább","import.tooltip":"Importálva!","outro.header":"Opera böngészője készen van.","outro.subheader":"Még valami! Az Opera böngésző mesterséges intelligenciájához, az Ariához való hozzáféréshez jelentkezzen be az Opera fiókjába.","outro.description":"Érje el az Aria, a VPN Pro és a Cashback alkalmazást ingyenes Opera fiókjával.","outro.button":"Kezdje el a böngészést"}'),mt=JSON.parse('{"nav.later":"Nanti","nav.prev":"Sebelumnya","nav.next":"Selanjutnya","nav.done":"Selesai","intro.header":"Opera One.","intro.subheader":"Siapkan browser baru Anda","intro.button":"Mulai","themes.header":"Bagaimana suasana hati Anda?","themes.subheader":"Memilih tema browser","themes.light":"Biasa","themes.dark":"Gelap","themes.system":"Sistem","wallpapers.header":"Bagaimana gaya Anda?","wallpapers.subheader":"Pilih wallpaper Halaman Awal","adblocker.header":"Jelajahi lebih cepat bebas iklan","adblocker.subheader":"Nyalakan pemblokir iklan","adblocker.label":"Blokir iklan","adblocker.tooltip":"Diaktifkan!","messengers.header":"Tetap terhubung dengan semua orang","messengers.subheader":"Tambahkan aplikasi sosial favorit Anda","import.header":"Impor data Anda","import.subheader":"Pilih browser di bawah ini","import.tooltip":"Diimpor!","outro.header":"Browser Opera Anda telah siap.","outro.subheader":"Satu hal lagi! Masuk ke akun Opera Anda untuk mengakses Aria, AI Browser Opera.","outro.description":"Akses Aria, VPN Pro, dan Cashback dengan akun Opera gratis Anda.","outro.button":"Mulai menjelajah"}'),gt=JSON.parse('{"nav.later":"Dopo","nav.prev":"Precedente","nav.next":"Successivo","nav.done":"Fatto","intro.header":"Opera One.","intro.subheader":"Configura il tuo nuovo browser","intro.button":"Inizia","themes.header":"Di che umore sei?","themes.subheader":"Seleziona un tema del browser","themes.light":"Chiaro","themes.dark":"Scuro","themes.system":"Sistema","wallpapers.header":"Qual è il tuo stile?","wallpapers.subheader":"Seleziona uno sfondo per la pagina iniziale","adblocker.header":"Naviga più veloce e senza annunci","adblocker.subheader":"Attiva il blocco degli annunci pubblicitari","adblocker.label":"Blocco degli annunci","adblocker.tooltip":"Attivato!","messengers.header":"Resta in contatto con tutti","messengers.subheader":"Aggiungi i tuoi social preferiti","import.header":"Importa i tuoi dati","import.subheader":"Seleziona un browser qui sotto","import.tooltip":"Importato!","outro.header":"Il tuo browser Opera è pronto.","outro.subheader":"Un\'ultima cosa! Accedi al tuo account Opera per usare Aria, l’IA del browser Opera.","outro.description":"Accedi ad Aria, VPN Pro e Cashback con il tuo account Opera gratuito.","outro.button":"Inizia a navigare"}'),vt=JSON.parse('{"nav.later":"後で","nav.prev":"前へ","nav.next":"次へ","nav.done":"完了","intro.header":"Opera One","intro.subheader":"ご利用の新しいブラウザをセットアップ","intro.button":"始める","themes.header":"どうしますか？","themes.subheader":"ブラウザのテーマを選択","themes.light":"ライト","themes.dark":"ダーク","themes.system":"システム","wallpapers.header":"スタイルはどうしますか？","wallpapers.subheader":"スタートページの壁紙を選択","adblocker.header":"高速で無広告ブラウジング","adblocker.subheader":"広告ブロッカーを有効にする","adblocker.label":"広告のブロック","adblocker.tooltip":"有効になりました！","messengers.header":"みんなに合わせる","messengers.subheader":"お気に入りのソーシャルアプリを追加","import.header":"データのインポート","import.subheader":"以下のブラウザを選択","import.tooltip":"インポートしました！","outro.header":"ご利用の Opera ブラウザが利用できます。","outro.subheader":"さらに！Opera アカウントにログインして、Opera ブラウザの AI である Aria にアクセスします。","outro.description":"無料の Opera アカウントで、Aria、VPN Pro、キャッシュバックにアクセスしてください。","outro.button":"ブラウジングを開始"}'),bt=JSON.parse('{"nav.later":"나중에","nav.prev":"이전","nav.next":"다음","nav.done":"완료","intro.header":"Opera One.","intro.subheader":"새 브라우저 설정","intro.button":"시작하기","themes.header":"어떤 분위기를 원하세요?","themes.subheader":"브라우저 테마 선택","themes.light":"라이트","themes.dark":"다크","themes.system":"시스템","wallpapers.header":"어떤 스타일을 원하세요?","wallpapers.subheader":"시작 페이지 배경무늬 선택","adblocker.header":"더 빠르고 광고 없는 인터넷 탐색","adblocker.subheader":"광고 차단 기능 켜기","adblocker.label":"광고 차단","adblocker.tooltip":"활성화 완료!","messengers.header":"모두와 연결되기","messengers.subheader":"좋아하는 소셜 앱 추가","import.header":"내 데이터 가져오기","import.subheader":"아래에서 브라우저 선택","import.tooltip":"가져오기 완료!","outro.header":"Opera 브라우저 사용 준비 완료.","outro.subheader":"한 가지 더! Opera의 브라우저 AI인 Aria에 액세스하려면 Opera 계정으로 로그인하세요.","outro.description":"무료 Opera 계정으로 Aria, VPN Pro, 캐시백에 액세스해보세요.","outro.button":"브라우징 시작"}'),yt=JSON.parse('{"nav.later":"Vėliau","nav.prev":"Peržiūra","nav.next":"Toliau","nav.done":"Atlikta","intro.header":"Opera One.","intro.subheader":"Nustatykite naują naršyklę","intro.button":"Pradžia","themes.header":"Kokia jūsų nuotaika?","themes.subheader":"Pasirinkite naršyklės temą","themes.light":"Šviesi","themes.dark":"Tamsi","themes.system":"Sistema","wallpapers.header":"Koks jūsų stilius?","wallpapers.subheader":"Pasirinkite pradžios puslapio ekrano foną","adblocker.header":"Naršykite greičiau, nematydami reklamų","adblocker.subheader":"Įjungti reklamų blokavimą","adblocker.label":"Blokuoti reklamas","adblocker.tooltip":"Įjungta!","messengers.header":"Palaikykite ryšius","messengers.subheader":"Pridėkite mėgstamas socialinių tinklų programas","import.header":"Importuokite savo duomenis","import.subheader":"Toliau pasirinkite naršyklę","import.tooltip":"Importuota!","outro.header":"Jūsų naršyklė „Opera“ paruošta.","outro.subheader":"Dar kai kas! Prisijunkite prie savo „Opera“ paskyros ir pasiekite Aria – naršyklės „Opera“ DI.","outro.description":"Naudodamiesi nemokama „Opera“ paskyra pasiekite Aria, „VPN Pro“ ir „Cashback“.","outro.button":"Pradėkite naršyti"}'),Ct=JSON.parse('{"nav.later":"Vēlāk","nav.prev":"Iepr.","nav.next":"Nākamais","nav.done":"Gatavs","intro.header":"Opera One.","intro.subheader":"Iestatiet jauno pārlūkprogrammu","intro.button":"Darba sākšana","themes.header":"Kāds ir jūsu noskaņojums?","themes.subheader":"Atlasiet pārlūkprogrammas dizainu","themes.light":"Gaišs","themes.dark":"Tumšs","themes.system":"Sistēma","wallpapers.header":"Kāds ir jūsu stils?","wallpapers.subheader":"Atlasiet sākumlapas ekrāntapeti","adblocker.header":"Pārlūkojiet ātrāk bez reklāmām","adblocker.subheader":"Ieslēgt reklāmu bloķētāju","adblocker.label":"Reklāmu bloķēšana","adblocker.tooltip":"Iespējots.","messengers.header":"Sazinieties ar visiem","messengers.subheader":"Pievienojiet savas iecienītās sociālo tīklu lietotnes","import.header":"Importējiet savus datus","import.subheader":"Tālāk atlasiet pārlūkprogrammu","import.tooltip":"Importēta.","outro.header":"Pārlūkprogramma Opera ir gatava.","outro.subheader":"Izmantojiet arī citas iespējas... Piesakieties savā Opera kontā, lai piekļūtu pārlūkprogrammas Opera mākslīgā intelekta pakalpojumam Aria.","outro.description":"Piekļūstiet pakalpojumam Aria, VPN Pro un Naudas atmaksa, izmantojot bezmaksas Opera kontu.","outro.button":"Sākt pārlūkošanu"}'),kt=JSON.parse('{"nav.later":"Kemudian","nav.prev":"Sebelumnya","nav.next":"Seterusnya","nav.done":"Selesai","intro.header":"Opera One.","intro.subheader":"Tetapkan penyemak imbas baharu anda","intro.button":"Mulakan","themes.header":"Apakah perasaan anda?","themes.subheader":"Pilih tema penyemak imbas","themes.light":"Terang","themes.dark":"Gelap","themes.system":"Sistem","wallpapers.header":"Apakah gaya anda?","wallpapers.subheader":"Pilih kertas hias dinding Halaman Permulaan","adblocker.header":"Semak imbas dengan lebih pantas tanpa iklan","adblocker.subheader":"Hidupkan penyekat iklan","adblocker.label":"Sekat iklan","adblocker.tooltip":"Didayakan!","messengers.header":"Ikuti perkembangan semua orang","messengers.subheader":"Tambah aplikasi sosial kegemaran anda","import.header":"Import data anda","import.subheader":"Pilih penyemak imbas di bawah","import.tooltip":"Diimport!","outro.header":"Penyemak imbas Opera anda sudah sedia.","outro.subheader":"Satu perkara lagi! Log masuk ke akaun Opera anda untuk mengakses Aria, AI Penyemak imbas Opera.","outro.description":"Akses Aria, VPN Pro dan Rebat Tunai dengan akaun Opera percuma anda.","outro.button":"Mula melayar"}'),wt=JSON.parse('{"nav.later":"Senere","nav.prev":"Forrige","nav.next":"Neste","nav.done":"Fullført","intro.header":"Opera One.","intro.subheader":"Konfigurer din nye nettleser","intro.button":"Kom i gang","themes.header":"Hva med noe som passer til humøret?","themes.subheader":"Velg et nettlesertema","themes.light":"Lyst","themes.dark":"Mørkt","themes.system":"System","wallpapers.header":"Tilpass til din egen stil.","wallpapers.subheader":"Velg et bakgrunnsbilde for startsiden","adblocker.header":"Surf raskere, reklamefritt","adblocker.subheader":"Slå på annonseblokkering","adblocker.label":"Blokker annonser","adblocker.tooltip":"Slått på!","messengers.header":"Hold kontakten med folk","messengers.subheader":"Legg til apper for sosiale nettverk","import.header":"Importer dataene dine","import.subheader":"Velg en nettleser nedenfor","import.tooltip":"Importert!","outro.header":"Opera-nettleseren er klar.","outro.subheader":"Én ting til ... Logg på Opera-kontoen din for å få tilgang til Aria, Operas nettleser-AI.","outro.description":"Få tilgang til Aria, VPN Pro og tilbakebetaling med gratis Opera-konto.","outro.button":"Begynn å surfe"}'),Et=JSON.parse('{"nav.later":"Later","nav.prev":"Eerder","nav.next":"Volgende","nav.done":"Gereed","intro.header":"Opera One.","intro.subheader":"Stel je nieuwe browser in","intro.button":"Aan de slag","themes.header":"Hoe is je humeur?","themes.subheader":"Selecteer een browserthema","themes.light":"Licht","themes.dark":"Donker","themes.system":"Systeem","wallpapers.header":"Wat is je stijl?","wallpapers.subheader":"Selecteer een wallpaper voor de startpagina","adblocker.header":"Sneller browsen zonder advertenties","adblocker.subheader":"Schakel ad blocker in","adblocker.label":"Blokkeer advertenties","adblocker.tooltip":"Ingeschakeld!","messengers.header":"Blijf bij met iedereen","messengers.subheader":"Voeg je favoriete social apps toe","import.header":"Importeer je gegevens","import.subheader":"Selecteer hieronder een browser","import.tooltip":"Geïmporteerd!","outro.header":"Je Opera-browser is klaar.","outro.subheader":"Nog iets! Log in op je Opera-account om Aria, de AI-browser van Opera, te openen.","outro.description":"Open Aria, VPN Pro en Cashback met je gratis Opera-account.","outro.button":"Begin met browsen"}'),xt=JSON.parse('{"nav.later":"Później","nav.prev":"Wstecz","nav.next":"Dalej","nav.done":"Gotowe","intro.header":"Opera One.","intro.subheader":"Skonfiguruj swoją nową przeglądarkę.","intro.button":"Rozpocznij","themes.header":"W jakim jesteś nastroju?","themes.subheader":"Wybierz motyw przeglądarki","themes.light":"Jasny","themes.dark":"Ciemny","themes.system":"System","wallpapers.header":"Jaki masz styl?","wallpapers.subheader":"Wybierz tapetę strony startowej","adblocker.header":"Przeglądaj sieć szybciej i bez reklam","adblocker.subheader":"Włącz blokowanie reklam","adblocker.label":"Blokowanie reklam","adblocker.tooltip":"Włączone!","messengers.header":"Pozostań w kontakcie","messengers.subheader":"Dodaj swoje ulubione aplikacje społecznościowe","import.header":"Zaimportuj swoje dane","import.subheader":"Wybierz przeglądarkę poniżej","import.tooltip":"Zaimportowano!","outro.header":"Twoja przeglądarka Opera jest gotowa.","outro.subheader":"Jeszcze jedno! Zaloguj się na swoje konto Opery, aby korzystać z usługi Aria, rozwiązania AI dostępnego w przeglądarce Opera.","outro.description":"Korzystaj z usług Aria, VPN Pro i Cashback, dzięki bezpłatnemu kontu Opery.","outro.button":"Rozpocznij przeglądanie"}'),St=JSON.parse('{"nav.later":"Mais tarde","nav.prev":"Anterior","nav.next":"Próximo","nav.done":"Concluído","intro.header":"Opera One.","intro.subheader":"Definir o seu novo browser","intro.button":"Como começar","themes.header":"Qual é o seu estado de espírito?","themes.subheader":"Selecione um tema para o browser","themes.light":"Claro","themes.dark":"Escuro","themes.system":"Sistema","wallpapers.header":"Qual é o seu estilo?","wallpapers.subheader":"Selecione uma imagem de fundo para a Página inicial","adblocker.header":"Navegue mais rapidamente e sem anúncios","adblocker.subheader":"Ligar bloqueador de anúncios","adblocker.label":"Bloquear anúncios","adblocker.tooltip":"Ativado!","messengers.header":"Mantenha-se atualizado","messengers.subheader":"Adicione as aplicações das suas redes sociais favoritas","import.header":"Importe os seus dados","import.subheader":"Selecione um browser abaixo","import.tooltip":"Importado!","outro.header":"O seu browser Opera está pronto.","outro.subheader":"E mais uma coisa! Inicie sessão na sua conta Opera para aceder à Aria, a IA do Browser Opera.","outro.description":"Aceda à Aria, ao VPN Pro e Cashback com a sua conta Opera gratuita.","outro.button":"Iniciar navegação"}'),Ot=JSON.parse('{"nav.later":"Depois","nav.prev":"Anterior","nav.next":"Próximo","nav.done":"Concluído","intro.header":"Opera One.","intro.subheader":"Configure seu novo navegador","intro.button":"Comece agora","themes.header":"Como está seu astral?","themes.subheader":"Selecione um tema para o navegador","themes.light":"Claro","themes.dark":"Escuro","themes.system":"Sistema","wallpapers.header":"Qual é o seu estilo?","wallpapers.subheader":"Selecione um papel de parede para a Página Inicial","adblocker.header":"Navegue mais rapidamente sem anúncios","adblocker.subheader":"Ative o bloqueador de anúncios","adblocker.label":"Bloquear anúncios","adblocker.tooltip":"Habilitado!","messengers.header":"Acompanhe todo mundo","messengers.subheader":"Adicione seus aplicativos de redes sociais favoritos","import.header":"Importe seus dados","import.subheader":"Selecione um navegador abaixo","import.tooltip":"Importado!","outro.header":"Seu navegador Opera está pronto.","outro.subheader":"Mais uma coisa! Entre em sua conta do Opera para acessar a Aria, a IA do navegador Opera.","outro.description":"Acesse a Aria, o VPN Pro e o Cashback com sua conta gratuita do Opera.","outro.button":"Começar a navegar"}'),Lt=JSON.parse('{"nav.later":"Mai târziu","nav.prev":"Previzualizare","nav.next":"Următor","nav.done":"Gata","intro.header":"Opera One.","intro.subheader":"Stabilește noul tău browser","intro.button":"Începe","themes.header":"Cum te simți?","themes.subheader":"Selectează o temă pentru browser","themes.light":"Luminos","themes.dark":"Întunecat","themes.system":"Sistem","wallpapers.header":"Care este stilul tău?","wallpapers.subheader":"Selectează o imagine de fundal pentru Pagina de pornire","adblocker.header":"Navighează mai rapid și fără reclame","adblocker.subheader":"Activează blocatorul de reclame","adblocker.label":"Blocare reclame","adblocker.tooltip":"Activat!","messengers.header":"Ține pasul cu ceilalți","messengers.subheader":"Adaugă aplicațiile sociale favorite","import.header":"Importă datele tale","import.subheader":"Selectează un browser mai jos","import.tooltip":"Importate!","outro.header":"Browserul tău Opera este gata.","outro.subheader":"Încă ceva! Înregistrează-te în contul tău Opera pentru a accesa Aria, Browserul AI al Opera.","outro.description":"Accesează Aria, VPN Pro și Cashback cu contul tău Opera gratuit.","outro.button":"Începe navigarea"}'),_t=JSON.parse('{"nav.later":"Позже","nav.prev":"Предпросмотр","nav.next":"Далее","nav.done":"Готово","intro.header":"Opera One","intro.subheader":"Настройте свой новый браузер","intro.button":"Начать работу","themes.header":"Какое настроение у вас сегодня?","themes.subheader":"Выберите тему браузера","themes.light":"Светлая","themes.dark":"Темная","themes.system":"Система","wallpapers.header":"Какой стиль вам нравится?","wallpapers.subheader":"Выберите обои для начальной страницы","adblocker.header":"Открывайте сайты быстрее и без рекламы","adblocker.subheader":"Включите блокировку рекламы,","adblocker.label":"Блокировка рекламы","adblocker.tooltip":"Включено.","messengers.header":"Поддерживайте общение","messengers.subheader":"Добавьте любимые соцсети","import.header":"Импортируйте свои данные","import.subheader":"Выберите браузер ниже","import.tooltip":"Импортировано.","outro.header":"Ваш браузер Opera готов.","outro.subheader":"И еще кое-что. Войдите в учетную запись Opera, чтобы использовать Aria — ИИ браузера Opera","outro.description":"Получите доступ к Aria, VPN Pro и Cashback с бесплатной учетной записью Opera.","outro.button":"Начать просмотр"}'),Pt=JSON.parse('{"nav.later":"Neskôr","nav.prev":"Predch.","nav.next":"Nasledujúce","nav.done":"Hotovo","intro.header":"Opera One.","intro.subheader":"Nastavte svoj nový prehliadač","intro.button":"Začať","themes.header":"Akú máte náladu?","themes.subheader":"Vyberte tému prehliadača","themes.light":"Svetlá","themes.dark":"Tmavá","themes.system":"Systém","wallpapers.header":"Aký máte štýl?","wallpapers.subheader":"Vyberte tapetu hlavného okna","adblocker.header":"Prehľadávajte internet rýchlejšie bez reklám","adblocker.subheader":"Zapnite blokovanie reklám","adblocker.label":"Blokovanie reklám","adblocker.tooltip":"Povolené!","messengers.header":"Majte prehľad o každom","messengers.subheader":"Pridajte obľúbené sociálne aplikácie","import.header":"Importujte údaje","import.subheader":"Vyberte prehliadač nižšie","import.tooltip":"Importované!","outro.header":"Váš prehliadač Opera je pripravený.","outro.subheader":"Ešte jedna vec! Prihláste sa do svojho účtu Opera a získajte prístup k Arii, AI prehliadača Opery.","outro.description":"Získajte prístup k službám Aria, VPN Pro a Cashback pomocou bezplatného účtu Opera.","outro.button":"Začnite prehliadať"}'),Nt=JSON.parse('{"nav.later":"Касније","nav.prev":"Претх.","nav.next":"Даље","nav.done":"Готово","intro.header":"Opera One.","intro.subheader":"Подесите свој нови прегледач","intro.button":"Почните","themes.header":"Како сте расположени?","themes.subheader":"Изаберите тему прегледача","themes.light":"Светло","themes.dark":"Тамно","themes.system":"Систем","wallpapers.header":"Који је ваш стил?","wallpapers.subheader":"Изаберите позадину почетне стране","adblocker.header":"Прегледајте брже и без реклама","adblocker.subheader":"Укључите алатку за блокирање реклама","adblocker.label":"Блокирај рекламе","adblocker.tooltip":"Омогућен!","messengers.header":"Останите у контакту са свима","messengers.subheader":"Додајте своје омиљене друштвене апликације","import.header":"Увезите своје податке","import.subheader":"Изаберите преледач испод","import.tooltip":"Увезено!","outro.header":"Ваш прегледач Opera је спреман.","outro.subheader":"Још нешто! Пријавите се на свој Opera налог да бисте приступили функцији Aria, вештачкој интелигенцији прегледача Opera.","outro.description":"Приступите функцијама Aria, VPN Pro и Cashback уз ваш бесплатан Opera налог.","outro.button":"Почните са прегледањем"}'),Mt=JSON.parse('{"nav.later":"Senare","nav.prev":"Föreg.","nav.next":"Nästa","nav.done":"Klart","intro.header":"Opera One.","intro.subheader":"Konfigurera din nya webbläsare","intro.button":"Sätt igång","themes.header":"Vad känner du för?","themes.subheader":"Välj webbläsartema","themes.light":"Ljust","themes.dark":"Mörkt","themes.system":"System","wallpapers.header":"Vad är din stil?","wallpapers.subheader":"Välj en bakgrundsbild för startsidan","adblocker.header":"Surfa snabbare utan annonser","adblocker.subheader":"Slå på annonsblockeraren","adblocker.label":"Blockera annonser","adblocker.tooltip":"Aktiverat!","messengers.header":"Håll koll på alla","messengers.subheader":"Lägg till dina favoritappar för sociala nätverk","import.header":"Importera din data","import.subheader":"Välj en webbläsare nedan","import.tooltip":"Importerat!","outro.header":"Din Opera-webbläsare är redo.","outro.subheader":"En sak till! Logga in till ditt Opera-konto för att gå till Aria, Opera-webbläsarens AI.","outro.description":"Gå till Aria, VPN Pro och Cashback med ditt kostnadsfria Opera-konto.","outro.button":"Börja surfa"}'),At=JSON.parse('{"nav.later":"Baadaye","nav.prev":"Awali","nav.next":"Inayofuata","nav.done":"Imekamilisha","intro.header":"Opera One.","intro.subheader":"Weka kivinjari chako kipya","intro.button":"Anza","themes.header":"Hali yako ni ipi?","themes.subheader":"Chagua mandhari ya kivinjari","themes.light":"Angavu","themes.dark":"Kolevu","themes.system":"Mfumo","wallpapers.header":"Mtindo wako ni upi?","wallpapers.subheader":"Chagua mandhari nyuma ya Ukurasa wa Kuanza","adblocker.header":"Vinjari kwa haraka bila matangazo","adblocker.subheader":"Washa kizuia matangazo","adblocker.label":"Zuia matangazo","adblocker.tooltip":"Imewezeshwa!","messengers.header":"Endelea kushirikiana na kila mtu","messengers.subheader":"Weka programu unazozipenda za kijamii","import.header":"Ingiza data yako","import.subheader":"Chagua kivinjari hapa chini","import.tooltip":"Imeingizwa!","outro.header":"Kivinjari chako cha Opera kiko tayari.","outro.subheader":"Hatua moja zaidi! Ingia kwenye akaunti yako ya Opera ili ufikie Aria, Kivinjari cha Opera AI.","outro.description":"Fikia Aria, VPN Pro na Cashback kwenye akaunti yako ya bure ya Opera.","outro.button":"Anza kuvinjari"}'),It=JSON.parse('{"nav.later":"பின்னர்","nav.prev":"முந்தையது","nav.next":"அடுத்து","nav.done":"முடிந்தது","intro.header":"Opera One.","intro.subheader":"உங்கள் புதிய உலாவியை அமைத்திடுங்கள்","intro.button":"தொடங்கவும்","themes.header":"உங்கள் மனநிலை எப்படி இருக்கிறது?","themes.subheader":"உலாவி தீமினைத் தேர்ந்தெடுக்கவும்","themes.light":"வெளிர்நிற தீம்","themes.dark":"அடர்நிற தீம்","themes.system":"சிஸ்டம்","wallpapers.header":"உங்கள் ஸ்டைல் என்ன?","wallpapers.subheader":"துவக்கப் பக்க வால்பேப்பரைத் தேர்ந்தெடுக்கவும்","adblocker.header":"விளம்பரங்கள் இல்லாமலும் இன்னும் வேகமாகவும் இணையத்தை உலாவுங்கள்","adblocker.subheader":"விளம்பரத் தடுப்பானை இயக்கவும்","adblocker.label":"விளம்பரங்களைத் தடு","adblocker.tooltip":"இயக்கப்பட்டது!","messengers.header":"அனைவரிடமும் இணைப்பில் இருங்கள்","messengers.subheader":"உங்களுக்குப் பிடித்த சமூக ஊடகப் பயன்பாடுகளைச் சேருங்கள்","import.header":"உங்கள் தரவை இறக்குமதி செய்யுங்கள்","import.subheader":"கீழே ஒரு உலாவியைத் தேர்ந்தெடுக்கவும்","import.tooltip":"இறக்குமதி செய்யப்பட்டது!","outro.header":"உங்கள் Opera உலாவி தயார்!","outro.subheader":"இன்னும் ஒன்று! Opera-இன் உலாவி AI படைப்பான Aria-ஐ அணுக உங்கள் Opera கணக்கில் உள்நுழையுங்கள்.","outro.description":"உங்கள் இலவச Opera கணக்கைக் கொண்டு Aria, VPN Pro, Cashback ஆகியவற்றை அணுகுங்கள்.","outro.button":"உலாவத் தொடங்குங்கள்!"}'),Ft=JSON.parse('{"nav.later":"తరువాత","nav.prev":"మునుపటి","nav.next":"తదుపరి","nav.done":"పూర్తయ్యింది","intro.header":"Opera One.","intro.subheader":"మీ కొత్త బ్రౌజర్‌ను సెటప్ చేయండి","intro.button":"ప్రారంభించండి","themes.header":"మీ మానసిక స్థితి ఏమిటి?","themes.subheader":"బ్రౌజర్ థీమ్‌ను ఎంచుకోండి","themes.light":"లేత రంగు","themes.dark":"ముదురు రంగు","themes.system":"సిస్టమ్","wallpapers.header":"మీ స్టైల్ ఏమిటి?","wallpapers.subheader":"ప్రారంభ పేజీ వాల్‌పేపర్‌ను ఎంచుకోండి","adblocker.header":"యాడ్ రహితంగా వేగంగా బ్రౌజ్ చేయండి","adblocker.subheader":"యాడ్ బ్లాకర్ ఆన్ చేయి","adblocker.label":"యాడ్‌లను బ్లాక్ చేయి","adblocker.tooltip":"ప్రారంభించబడింది!","messengers.header":"అందరితో కలిసి ఉండండి","messengers.subheader":"మీకు ఇష్టమైన సామాజిక యాప్‌లను జోడించండి","import.header":"మీ డేటాను దిగుమతి చేయండి","import.subheader":"క్రింద ఒక బ్రౌజర్‌ను ఎంచుకోండి","import.tooltip":"దిగుమతి చేయబడింది!","outro.header":"మీ Opera బ్రౌజర్‌ సిద్ధంగా ఉంది.","outro.subheader":"మరొక విషయం! Aria, Opera బ్రౌజర్ AIను యాక్సెస్ చేయడానికి మీ Opera ఖాతాకు లాగిన్ చేయండి.","outro.description":"మీ ఉచిత Opera ఖాతాతో Aria, VPN ప్రొ మరియు క్యాష్‌బ్యాక్‌ను యాక్సెస్ చేయండి.","outro.button":"బ్రౌజింగ్‌ను ప్రారంభించండి"}'),Rt=JSON.parse('{"nav.later":"ภายหลัง","nav.prev":"ก่อนหน้า","nav.next":"ถัดไป","nav.done":"เสร็จสิ้น","intro.header":"Opera One","intro.subheader":"ตั้งค่าเบราว์เซอร์ใหม่ของคุณ","intro.button":"เริ่มต้น","themes.header":"อารมณ์ของคุณเป็นอย่างไร","themes.subheader":"ตั้งค่าธีมของเบราว์เซอร์","themes.light":"สว่าง","themes.dark":"มืด","themes.system":"ระบบ","wallpapers.header":"สไตล์ของคุณเป็นอย่างไร","wallpapers.subheader":"เลือกวอลล์เปเปอร์ของหน้าเริ่มต้น","adblocker.header":"ท่องเว็บได้เร็วขึ้นแบบไม่มีโฆษณา","adblocker.subheader":"เปิดตัวบล็อกโฆษณา","adblocker.label":"บล็อกโฆษณา","adblocker.tooltip":"เปิดใช้งานแล้ว!","messengers.header":"ทันข่าวสารกับทุกคน","messengers.subheader":"เพิ่มแอบโซเชียลแอปโปรดของคุณ","import.header":"นำเข้าข้อมูลของคุณ","import.subheader":"เลือกเบราว์เซอร์ด้านล่างนี้","import.tooltip":"นำเข้าแล้ว!","outro.header":"เบราว์เซอร์ Opera ของคุณพร้อมแล้ว","outro.subheader":"ยังมีอีกเรื่อง! เข้าสู่ระบบบัญชี Opera ของคุณเพื่อเข้าถึง AI ของเบราเซอร์ Opera ที่ชื่อว่า Aria","outro.description":"เข้าถึง Aria, VPN Pro และ Cashback ด้วยบัญชี Opera ฟรีของคุณ","outro.button":"เริ่มการเรียกดู"}'),Vt=JSON.parse('{"nav.later":"Saka na","nav.prev":"Nauna","nav.next":"Susunod","nav.done":"Tapos na","intro.header":"Opera One.","intro.subheader":"I-set up ang iyong bagong browser","intro.button":"Magsimula","themes.header":"Ano’ng mood mo?","themes.subheader":"Pumili ng tema ng browser","themes.light":"Maliwanag","themes.dark":"Madilim","themes.system":"System","wallpapers.header":"Ano’ng istilo mo?","wallpapers.subheader":"Pumili ng wallpaper ng Start Page","adblocker.header":"Mag-browse nang mas mabilis nang walang ad","adblocker.subheader":"I-on ang ad blocker","adblocker.label":"Ad blocker","adblocker.tooltip":"Naka-enable!","messengers.header":"Makasabay sa lahat","messengers.subheader":"Idagdag ang mga paborito mong social app","import.header":"I-import ang iyong data","import.subheader":"Pumili ng browser sa ibaba","import.tooltip":"Na-import!","outro.header":"Handa na ang iyong Opera browser.","outro.subheader":"Heto pa! Mag-log in sa iyong Opera account para ma-access ang Aria, ang Browser AI ng Opera.","outro.description":"I-access ang Aria, VPN Pro, at Cashback gamit ang iyong libreng Opera account.","outro.button":"Simulan ang pag-browse"}'),jt=JSON.parse('{"nav.later":"Daha sonra","nav.prev":"Önceki","nav.next":"Sonraki","nav.done":"Tamam","intro.header":"Opera One.","intro.subheader":"Yeni tarayıcını kur","intro.button":"Başlayın","themes.header":"Ruh halin nedir?","themes.subheader":"Bir tarayıcı teması seç","themes.light":"Aydınlık","themes.dark":"Karanlık","themes.system":"Sistem","wallpapers.header":"Stilin nedir?","wallpapers.subheader":"Bir Başlangıç Sayfası duvar kağıdı seç","adblocker.header":"Daha hızlı reklamsız gezin","adblocker.subheader":"Reklam engelleyiciyi aç","adblocker.label":"Reklamları engelle","adblocker.tooltip":"Etkin!","messengers.header":"Herkese ayak uydur","messengers.subheader":"Favori sosyal uygulamalarını ekle","import.header":"Verilerini al","import.subheader":"Aşağıdan bir tarayıcı seç","import.tooltip":"İçe aktarıldı!","outro.header":"Opera tarayıcın hazır.","outro.subheader":"Bir şey daha var! Aria, Opera Tarayıcı AI’ye erişim sağlamak için Opera hesabında oturum aç","outro.description":"Ücretsiz Opera hesabınla Aria, VPN Pro ve Cashback’e erişim sağla.","outro.button":"Gezinmeye başlayın"}'),zt=JSON.parse('{"nav.later":"Не зараз","nav.prev":"Назад","nav.next":"Далі","nav.done":"Готово","intro.header":"Opera One.","intro.subheader":"Налаштуйте свій новий браузер","intro.button":"Почати","themes.header":"Який у вас настрій?","themes.subheader":"Виберіть тему браузера","themes.light":"Світла","themes.dark":"Темна","themes.system":"Система","wallpapers.header":"Який у вас стиль?","wallpapers.subheader":"Виберіть шпалери для початкової сторінки","adblocker.header":"Переглядайте веб-сторінки швидше й без реклами","adblocker.subheader":"Увімкніть блокування реклами","adblocker.label":"Блокування реклами","adblocker.tooltip":"Увімкнено!","messengers.header":"Залишайтеся на зв’язку","messengers.subheader":"Додайте улюблені програми соцмереж","import.header":"Імпортуйте свої дані","import.subheader":"Виберіть браузер нижче","import.tooltip":"Імпортовано!","outro.header":"Ваш браузер Opera готовий.","outro.subheader":"Ще дещо… Увійдіть у свій обліковий запис Opera, щоб отримати доступ до Aria, штучного інтелекту в браузері Opera.","outro.description":"Отримайте доступ до Aria, VPN Pro і Cashback за допомогою безкоштовного облікового запису Opera.","outro.button":"Почати веб-перегляд"}'),Tt=JSON.parse('{"nav.later":"Sau","nav.prev":"Trước","nav.next":"Tiếp","nav.done":"Xong","intro.header":"Opera One.","intro.subheader":"Cài đặt trình duyệt mới của bạn","intro.button":"Bắt đầu","themes.header":"Tâm trạng của bạn là gì?","themes.subheader":"Chọn một chủ đề cho trình duyệt","themes.light":"Sáng","themes.dark":"Tối","themes.system":"Hệ thống","wallpapers.header":"Phong cách của bạn là gì?","wallpapers.subheader":"Chọn một hình nền cho Trang bắt đầu","adblocker.header":"Duyệt không quảng cáo nhanh hơn","adblocker.subheader":"Bật trình chặn quảng cáo lên","adblocker.label":"Chặn quảng cáo","adblocker.tooltip":"Đã bật!","messengers.header":"Theo kịp với mọi người","messengers.subheader":"Thêm các ứng dụng mạng xã hội yêu thích của bạn","import.header":"Nhập vệ dữ liệu của bạn","import.subheader":"Chọn một trình duyệt dưới đây","import.tooltip":"Đã nhập!","outro.header":"Trình duyệt Opera của bạn đã sẵn sàng!","outro.subheader":"Còn điều nữa! Hãy đăng nhập vào tài khoản Opera của bạn để truy cập Aria, AI Trình duyệt của Opera.","outro.description":"Truy cập Aria, VPN Pro và Hoàn tiền với tài khoản Opera miễn phí của bạn.","outro.button":"Bắt đầu duyệt"}'),Ht=JSON.parse('{"nav.later":"稍后","nav.prev":"上一步","nav.next":"下一步","nav.done":"完成","intro.header":"Opera One。","intro.subheader":"设置您的新浏览器","intro.button":"入门指南","themes.header":"您的心情如何？","themes.subheader":"选择浏览器主题","themes.light":"浅色","themes.dark":"深色","themes.system":"系统","wallpapers.header":"您的风格是什么？","wallpapers.subheader":"选择首页墙纸","adblocker.header":"浏览速度更快，无广告","adblocker.subheader":"开启广告拦截","adblocker.label":"拦截广告","adblocker.tooltip":"已启用！","messengers.header":"关注任何人","messengers.subheader":"添加您最喜欢的社交应用","import.header":"导入您的数据","import.subheader":"在下面选择一个浏览器","import.tooltip":"已导入！","outro.header":"您的 Opera 浏览器已就绪。","outro.subheader":"还有一件事！登录您的 Opera 帐户以访问 Aria，即 Opera 的浏览器 AI。","outro.description":"使用您的免费 Opera 帐户访问 Aria、VPN Pro 和返现。","outro.button":"开始浏览"}'),Dt=JSON.parse('{"nav.later":"稍後","nav.prev":"上一頁","nav.next":"下一頁","nav.done":"完成","intro.header":"Opera One。","intro.subheader":"設定您的新瀏覽器","intro.button":"開始使用","themes.header":"您的心情如何？","themes.subheader":"選取瀏覽器佈景主題","themes.light":"淺色","themes.dark":"暗色","themes.system":"系統","wallpapers.header":"您的風格是什麼？","wallpapers.subheader":"選取開始頁面桌布","adblocker.header":"瀏覽速度更快，無廣告","adblocker.subheader":"開啟廣告阻擋功能","adblocker.label":"阻擋廣告","adblocker.tooltip":"已啟用！","messengers.header":"追蹤任何人","messengers.subheader":"新增您最喜愛的社交應用程式","import.header":"匯入您的資料","import.subheader":"在下面選取一個瀏覽器","import.tooltip":"已匯入！","outro.header":"您的 Opera 瀏覽器已就緒。","outro.subheader":"還有一件事！登入您的 Opera 帳號以存取 Aria，也就是 Opera 的瀏覽器 AI。","outro.description":"使用您的免費 Opera 帳號存取 Aria、VPN Pro 和返利。","outro.button":"開始瀏覽"}');var Bt,Ut;xe.use(Xe).use(Ie).init({lng:null===(Bt=chrome)||void 0===Bt||null===(Ut=Bt.i18n)||void 0===Ut?void 0:Ut.getUILanguage(),fallbackLng:"en-GB",resources:{bg:{translation:et},bn:{translation:tt},ca:{translation:nt},cs:{translation:rt},da:{translation:at},de:{translation:ot},el:{translation:it},"en-GB":{translation:lt},"es-419":{translation:st},es:{translation:ut},fi:{translation:ct},fr:{translation:dt},hi:{translation:ft},hr:{translation:pt},hu:{translation:ht},id:{translation:mt},it:{translation:gt},ja:{translation:vt},ko:{translation:bt},lt:{translation:yt},lv:{translation:Ct},ms:{translation:kt},no:{translation:wt},nl:{translation:Et},pl:{translation:xt},"pt-PT":{translation:St},"pt-BR":{translation:Ot},ro:{translation:Lt},ru:{translation:_t},sk:{translation:Pt},sr:{translation:Nt},sv:{translation:Mt},sw:{translation:At},ta:{translation:It},te:{translation:Ft},th:{translation:Rt},tl:{translation:Vt},tr:{translation:jt},uk:{translation:zt},vi:{translation:Tt},"zh-CN":{translation:Ht},"zh-TW":{translation:Dt}},keySeparator:!1,nsSeparator:!1,react:{useSuspense:!1},detection:{order:["querystring","navigator","htmlTag","path","subdomain"],caches:[]}});var Zt=n(379),Wt=n.n(Zt),Gt=n(795),Kt=n.n(Gt),$t=n(569),Jt=n.n($t),Qt=n(575),qt=n.n(Qt),Yt=n(216),Xt=n.n(Yt),en=n(589),tn=n.n(en),nn=n(580),rn={attributes:{source:"opera-intro"}};rn.styleTagTransform=tn(),rn.setAttributes=qt(),rn.insert=Jt().bind(null,"head"),rn.domAPI=Kt(),rn.insertStyleElement=Xt();Wt()(nn.Z,rn);nn.Z&&nn.Z.locals&&nn.Z.locals;var an=n(963),on={attributes:{source:"opera-intro"}};on.styleTagTransform=tn(),on.setAttributes=qt(),on.insert=Jt().bind(null,"head"),on.domAPI=Kt(),on.insertStyleElement=Xt();Wt()(an.Z,on);an.Z&&an.Z.locals&&an.Z.locals;var ln,sn,un,cn="dt_wp_standard_8.0";!function(e){e.INTRO="intro_slide",e.THEME="theme_slide",e.WALLPAPERS="wallpapers_slide",e.ADBLOCK="adblock_slide",e.MESSENGERS="messengers_slide",e.IMPORT="import_slide",e.OUTRO="outro_slide"}(ln||(ln={})),function(e){e[e.NORMAL=opr.statsPrivate.Priority.NORMAL]="NORMAL",e[e.IMPORTANT=opr.statsPrivate.Priority.IMPORTANT]="IMPORTANT"}(sn||(sn={})),function(e){e.CLICK="click",e.VIEW="view"}(un||(un={}));var dn,fn,pn=function(e,t,n){var r={type:e,section:t,page:cn};n&&(r.str_value=n),opr.statsPrivate.recordSessionEvent("feature_events.event_welcome_and_upgrade_page_metric",JSON.stringify(r),sn.NORMAL)};function hn(e,t){var n="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(!n){if(Array.isArray(e)||(n=function(e,t){if(!e)return;if("string"==typeof e)return mn(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return mn(e,t)}(e))||t&&e&&"number"==typeof e.length){n&&(e=n);var r=0,a=function(){};return{s:a,n:function(){return r>=e.length?{done:!0}:{done:!1,value:e[r++]}},e:function(e){throw e},f:a}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var o,i=!0,l=!1;return{s:function(){n=n.call(e)},n:function(){var e=n.next();return i=e.done,e},e:function(e){l=!0,o=e},f:function(){try{i||null==n.return||n.return()}finally{if(l)throw o}}}}function mn(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}!function(e){e[e.SYSTEM=-1]="SYSTEM",e[e.LIGHT=0]="LIGHT",e[e.DARK=1]="DARK"}(dn||(dn={})),function(e){e.COLOR_THEME="ui.dark_skin_settings_proxy",e.AD_BLOCKER_ENABLED="adblocker.enabled"}(fn||(fn={}));var gn=new Set,vn=function(e){return new Promise((function(t){chrome.settingsPrivate.getPref(e,(function(e){t(e.value)}))}))},bn=function(e,t){chrome.settingsPrivate.setPref(e,t,cn)},yn=function(e,t){var n={name:e,listener:t};return gn.add(n),vn(e).then((function(e){t(e)})),function(){gn.delete(n)}},Cn=function(e){bn(fn.COLOR_THEME,e)},kn=function(e){return yn(fn.COLOR_THEME,e)},wn=function(e){bn(fn.AD_BLOCKER_ENABLED,e)},En=function(e){return yn(fn.AD_BLOCKER_ENABLED,e)};function xn(e){return d.createElement("div",{className:"controls"},e.children)}function Sn(e){if(!e)return"";if("string"==typeof e)return e;if(Array.isArray(e))return e.reduce((function(e,t){return t?"string"==typeof t?(e.push(t),e):(e.push(Sn(t)),e):e}),[]).filter((function(e){return e})).join(" ");if("object"===f(e))return 0===Object.keys(e).length?"":Object.keys(e).map((function(t){return e[t]&&t})).filter((function(e){return e})).join(" ");throw new Error("Invalid value: ".concat(JSON.stringify(e)))}function On(e){return d.createElement("span",{className:Sn([e.name,"popup"])},d.createElement("span",{className:"popup-top"},d.createElement("svg",{width:"32",height:"17",viewBox:"0 0 32 17",fill:"none",xmlns:"http://www.w3.org/2000/svg"},d.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M24.2357 5C22.0159 5 19.9277 3.94716 18.6078 2.16248L17.608 0.810719C16.8085 -0.27024 15.1915 -0.27024 14.392 0.810719L13.3922 2.16248C12.0723 3.94716 9.98407 5 7.7643 5H6C3.17157 5 1.75736 5 0.87868 5.87868C0 6.75736 0 8.17157 0 11C0 13.8284 0 15.2426 0.87868 16.1213C1.75736 17 3.17157 17 6 17H26C28.8284 17 30.2426 17 31.1213 16.1213C32 15.2426 32 13.8284 32 11C32 8.17157 32 6.75736 31.1213 5.87868C30.2426 5 28.8284 5 26 5H24.2357Z",fill:"var(--light-font-color)"}))),d.createElement("span",{className:"popup-content"},e.children))}function Ln(){return d.createElement(On,{name:"adblocker-enabled"},Se("adblocker.tooltip"))}function _n(){return d.createElement("svg",{className:"logo",width:"46",height:"46",viewBox:"0 0 46 46",fill:"none",xmlns:"http://www.w3.org/2000/svg"},d.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M21.9322 5.84938C22.6487 5.71687 23.3512 5.71687 24.0677 5.84938C26.9392 6.37943 34.7425 7.86825 36.7804 8.79064C37.7395 9.22455 38.3333 10.1262 38.3333 11.1213V25.9315C38.3333 29.486 36.3874 32.7936 33.1701 34.7007L24.497 39.8427C23.5826 40.3858 22.4173 40.3858 21.5029 39.8427L12.8326 34.7007C9.61257 32.7936 7.66663 29.486 7.66663 25.9315V11.1213C7.66663 10.1262 8.26044 9.22455 9.22226 8.79064C11.2574 7.86825 19.0607 6.37943 21.9322 5.84938ZM31.236 15.7056C30.5915 15.3838 29.7712 15.5804 29.4037 16.1446L21.8478 27.7437L16.7573 22.4951L16.6177 22.3709C16.1253 21.993 15.378 21.9777 14.864 22.36C14.2985 22.7804 14.2294 23.5226 14.7096 24.0178L21.0422 30.5469L21.1791 30.6693C21.803 31.1527 22.8042 31.0265 23.2329 30.3682L31.7374 17.3099L31.817 17.1659C32.0646 16.6287 31.8267 16.0005 31.236 15.7056Z",fill:"var(--icon-background-color)"}))}function Pn(){var e=s((0,d.useState)(!1),2),t=e[0],n=e[1];(0,d.useEffect)((function(){return En(n)}),[]);return d.createElement(xn,null,d.createElement(_n,null),d.createElement("span",{className:"label"},Se("adblocker.label")),d.createElement("input",{type:"checkbox",onChange:function(e){var t=e.target;wn(t.checked),pn(un.CLICK,ln.ADBLOCK,"enable_adblock_button:".concat(t.checked?1:0))},checked:t}))}chrome.settingsPrivate.onPrefsChanged.addListener((function(e){var t,n=hn(e);try{for(n.s();!(t=n.n()).done;){var r,a=t.value,o=hn(gn);try{for(o.s();!(r=o.n()).done;){var i=r.value;a.key===i.name&&i.listener(a.value)}}catch(e){o.e(e)}finally{o.f()}}}catch(e){n.e(e)}finally{n.f()}}));var Nn,Mn=function(e){opr.introductionPrivate.closeIntroduction(e)};!function(e){e.FORWARD="forward",e.BACKWARD="backward"}(Nn||(Nn={}));var An,In=d.createContext({direction:Nn.FORWARD});function Fn(e){var t=s((0,d.useState)(0),2),n=t[0],r=t[1],a=s((0,d.useState)(0),2),o=a[0],i=a[1],l=s((0,d.useState)(Nn.FORWARD),2),u=l[0],c=l[1];(0,d.useEffect)((function(){e.isInitialized&&r(1)}),[e.isInitialized]);var f=function(){i(n),r(n-1),c(Nn.BACKWARD)},p=function(){i(n),r(n+1),c(Nn.FORWARD)},h=function(){i(n),r(e.children.length),c(Nn.FORWARD),e.markAsReady()};return d.createElement(In.Provider,{value:{direction:u,actions:e.isOverlay?{later:function(){e.isOverlay&&Mn(!0)},prev:f,next:p,done:h}:{prev:f,next:p,done:h}}},d.createElement("div",{className:Sn(["gallery",u])},e.children.map((function(t,r){var a=r+1,i=1===a,l=a===e.children.length-1,s=a===e.children.length,u=a===o,c=a===n,f=d.cloneElement(t,{number:a,isFirst:i,isLast:l,isSummary:s,isDismissed:u,isActive:c});return d.createElement("div",{key:r,className:Sn(["screen",{dismissed:u,active:c}])},f)}))))}function Rn(e,t){var n="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(!n){if(Array.isArray(e)||(n=function(e,t){if(!e)return;if("string"==typeof e)return Vn(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return Vn(e,t)}(e))||t&&e&&"number"==typeof e.length){n&&(e=n);var r=0,a=function(){};return{s:a,n:function(){return r>=e.length?{done:!0}:{done:!1,value:e[r++]}},e:function(e){throw e},f:a}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var o,i=!0,l=!1;return{s:function(){n=n.call(e)},n:function(){var e=n.next();return i=e.done,e},e:function(e){l=!0,o=e},f:function(){try{i||null==n.return||n.return()}finally{if(l)throw o}}}}function Vn(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}function jn(){return new Promise((function(e){opr.browserSidebarPrivate.getItemsInfo((function(t){var n=Object.values(An),r=t.filter((function(e){return n.includes(e.id)&&e.enabled})).map((function(e){return{id:e.id,enabled:!0,visible:e.visible,name:e.name,pref_id:e.pref_id}}));e(r)}))}))}!function(e){e.Messenger="messenger",e.TikTok="tiktok",e.Twitter="twitter",e.Instagram="instagram",e.Telegram="telegram",e.WhatsApp="whatsapp"}(An||(An={}));var zn,Tn,Hn,Dn,Bn,Un,Zn,Wn,Gn,Kn,$n,Jn,Qn=new Set,qn=function(e){return Qn.add(e),jn().then(e),function(){Qn.delete(e)}};function Yn(){return d.createElement(d.Fragment,null,d.createElement("g",{filter:"url(#filter0_d_1135_41354)"},d.createElement("circle",{cx:"42.0006",cy:"9.00058",r:"5.75056",fill:"white",stroke:"#E6EEF5",strokeWidth:"0.500049"}),d.createElement("path",{d:"M41.6009 11.5008H42.4006V9.40657H44.501V8.60521H42.4006V6.50031H41.6009V8.60521H39.5005V9.40657H41.6009V11.5008Z",fill:"#6D7F90"}),d.createElement("g",{filter:"url(#filter1_d_1135_41354)"},d.createElement("circle",{cx:"42.0013",cy:"9.00058",r:"5.75056",fill:"white",stroke:"#E6EEF5",strokeWidth:"0.500049"}),d.createElement("path",{d:"M41.6011 11.5008H42.4008V9.40657H44.5012V8.60521H42.4008V6.50031H41.6011V8.60521H39.5007V9.40657H41.6011V11.5008Z",fill:"#6D7F90"}),d.createElement("circle",{cx:"42.0028",cy:"9.00058",r:"6.00058",fill:"#5021FF"})),d.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M40.125 11.5L39.5 10.875L41.375 8.99995L39.5001 7.12501L40.1251 6.5L42 8.37494L43.8749 6.5L44.4999 7.12501L42.625 8.99995L44.5 10.875L43.875 11.5L42 9.62495L40.125 11.5Z",fill:"white"})),d.createElement("filter",{id:"filter0_d_1135_41354",x:"34",y:"3",width:"16.0034",height:"16.0012",filterUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},d.createElement("feFlood",{floodOpacity:"0",result:"BackgroundImageFix"}),d.createElement("feColorMatrix",{in:"SourceAlpha",type:"matrix",values:"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0",result:"hardAlpha"}),d.createElement("feMorphology",{radius:"1",operator:"erode",in:"SourceAlpha",result:"effect1_dropShadow_1135_41354"}),d.createElement("feOffset",{dy:"2"}),d.createElement("feGaussianBlur",{stdDeviation:"1.5"}),d.createElement("feComposite",{in2:"hardAlpha",operator:"out"}),d.createElement("feColorMatrix",{type:"matrix",values:"0 0 0 0 0.110908 0 0 0 0 0.0363021 0 0 0 0 0.388698 0 0 0 0.2 0"}),d.createElement("feBlend",{mode:"normal",in2:"BackgroundImageFix",result:"effect1_dropShadow_1135_41354"}),d.createElement("feBlend",{mode:"normal",in:"SourceGraphic",in2:"effect1_dropShadow_1135_41354",result:"shape"})),d.createElement("filter",{id:"filter1_d_1135_41354",x:"30.2859",y:"-0.428904",width:"23.4324",height:"23.4308",filterUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},d.createElement("feFlood",{floodOpacity:"0",result:"BackgroundImageFix"}),d.createElement("feColorMatrix",{in:"SourceAlpha",type:"matrix",values:"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0",result:"hardAlpha"}),d.createElement("feOffset",{dy:"2.28594"}),d.createElement("feGaussianBlur",{stdDeviation:"2.85742"}),d.createElement("feComposite",{in2:"hardAlpha",operator:"out"}),d.createElement("feColorMatrix",{type:"matrix",values:"0 0 0 0 0.438924 0 0 0 0 0.536296 0 0 0 0 0.61941 0 0 0 0.2 0"}),d.createElement("feBlend",{mode:"normal",in2:"BackgroundImageFix",result:"effect1_dropShadow_1135_41354"}),d.createElement("feBlend",{mode:"normal",in:"SourceGraphic",in2:"effect1_dropShadow_1135_41354",result:"shape"})))}function Xn(){return d.createElement(d.Fragment,null,d.createElement("g",{filter:"url(#filter0_d_1135_41073)"},d.createElement("circle",{cx:"42.0006",cy:"9.00058",r:"5.75056",fill:"white",stroke:"#E6EEF5",strokeWidth:"0.500049"}),d.createElement("path",{d:"M41.6009 11.5008H42.4006V9.40657H44.501V8.60521H42.4006V6.50031H41.6009V8.60521H39.5005V9.40657H41.6009V11.5008Z",fill:"#6D7F90"}),d.createElement("g",{filter:"url(#filter1_d_1135_41073)"},d.createElement("circle",{cx:"42.0013",cy:"9.00058",r:"5.75056",fill:"white",stroke:"#E6EEF5",strokeWidth:"0.500049"}),d.createElement("path",{d:"M41.6011 11.5008H42.4008V9.40657H44.5012V8.60521H42.4008V6.50031H41.6011V8.60521H39.5007V9.40657H41.6011V11.5008Z",fill:"#6D7F90"}),d.createElement("circle",{cx:"42.0028",cy:"9.00058",r:"6.00058",fill:"#5021FF"}),d.createElement("path",{d:"M41.0432 11.4245L38.7725 9.15383L39.4128 8.51349L41.0432 10.1393L44.4901 6.69238L45.1304 7.33726L41.0432 11.4245Z",fill:"white"}))),d.createElement("defs",null,d.createElement("filter",{id:"filter0_d_1135_41073",x:"34",y:"3",width:"16.0034",height:"16.0012",filterUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},d.createElement("feFlood",{floodOpacity:"0",result:"BackgroundImageFix"}),d.createElement("feColorMatrix",{in:"SourceAlpha",type:"matrix",values:"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0",result:"hardAlpha"}),d.createElement("feMorphology",{radius:"1",operator:"erode",in:"SourceAlpha",result:"effect1_dropShadow_1135_41073"}),d.createElement("feOffset",{dy:"2"}),d.createElement("feGaussianBlur",{stdDeviation:"1.5"}),d.createElement("feComposite",{in2:"hardAlpha",operator:"out"}),d.createElement("feColorMatrix",{type:"matrix",values:"0 0 0 0 0.110908 0 0 0 0 0.0363021 0 0 0 0 0.388698 0 0 0 0.2 0"}),d.createElement("feBlend",{mode:"normal",in2:"BackgroundImageFix",result:"effect1_dropShadow_1135_41073"}),d.createElement("feBlend",{mode:"normal",in:"SourceGraphic",in2:"effect1_dropShadow_1135_41073",result:"shape"})),d.createElement("filter",{id:"filter1_d_1135_41073",x:"30.2859",y:"-0.428904",width:"23.4324",height:"23.4308",filterUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},d.createElement("feFlood",{floodOpacity:"0",result:"BackgroundImageFix"}),d.createElement("feColorMatrix",{in:"SourceAlpha",type:"matrix",values:"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0",result:"hardAlpha"}),d.createElement("feOffset",{dy:"2.28594"}),d.createElement("feGaussianBlur",{stdDeviation:"2.85742"}),d.createElement("feComposite",{in2:"hardAlpha",operator:"out"}),d.createElement("feColorMatrix",{type:"matrix",values:"0 0 0 0 0.438924 0 0 0 0 0.536296 0 0 0 0 0.61941 0 0 0 0.2 0"}),d.createElement("feBlend",{mode:"normal",in2:"BackgroundImageFix",result:"effect1_dropShadow_1135_41073"}),d.createElement("feBlend",{mode:"normal",in:"SourceGraphic",in2:"effect1_dropShadow_1135_41073",result:"shape"}))))}function er(e){var t=s(e.children,3),n=t[0],r=t[1],a=t[2];return d.createElement("svg",{width:"62",height:"62",viewBox:"0 0 62 62",fill:"none"},d.createElement("g",{className:"inactive"},n),d.createElement("g",{className:"active"},r),d.createElement("g",{className:"label"},a),d.createElement("g",{className:"inactive hover"},d.createElement(Xn,null)),d.createElement("g",{className:"active hover"},d.createElement(Yn,null)))}function tr(e){var t=e.item;return d.createElement("div",{className:"messenger"+(t.visible?" active":"")},d.createElement("span",{className:"icon",onClick:function(){var e,n;e=t.id,n=!t.visible,opr.browserSidebarPrivate.setItemVisible(e,n);var r=t.name.toLowerCase().replace(" ","_");pn(un.CLICK,ln.MESSENGERS,"enable_button:".concat(r,":").concat(t.visible?0:1))}},function(e){switch(e){case An.Instagram:return d.createElement(er,null,d.createElement(zn.Inactive,null),d.createElement(zn.Active,null),d.createElement(zn.Label,null));case An.Messenger:return d.createElement(er,null,d.createElement(Hn.Inactive,null),d.createElement(Hn.Active,null),d.createElement(Hn.Label,null));case An.Telegram:return d.createElement(er,null,d.createElement(Bn.Inactive,null),d.createElement(Bn.Active,null),d.createElement(Bn.Label,null));case An.TikTok:return d.createElement(er,null,d.createElement(Zn.Inactive,null),d.createElement(Zn.Active,null),d.createElement(Zn.Label,null));case An.Twitter:return d.createElement(er,null,d.createElement(Gn.Inactive,null),d.createElement(Gn.Active,null),d.createElement(Gn.Label,null));case An.WhatsApp:return d.createElement(er,null,d.createElement($n.Inactive,null),d.createElement($n.Active,null),d.createElement($n.Label,null))}}(t.id)))}function nr(){var e=s((0,d.useState)([]),2),t=e[0],n=e[1];return(0,d.useEffect)((function(){return qn((function(e){n(e)}))}),[]),d.createElement(xn,null,d.createElement("div",{className:"messengers"},t.map((function(e){return d.createElement(tr,{item:e,key:e.id})}))))}function rr(e){var t=(0,d.useContext)(In).actions,n=function(t){pn(un.CLICK,e.section,"".concat(t,"_button"))};return(0,d.useEffect)((function(){e.isActive&&pn(un.VIEW,e.section)}),[e.isActive,e.section]),d.createElement("section",{id:e.name,className:"page"},d.createElement("div",{className:"content"},d.createElement("div",{className:"header"},d.createElement("span",{className:Sn(["title",{wide:e.title.length>=25&&e.title.length<40,widest:e.title.length>=40}])},e.title),d.createElement("span",{className:"subtitle"},e.subtitle)),d.createElement("div",{className:"feature"},e.children),!e.isSummary&&d.createElement("div",{className:"buttons"},d.createElement("div",{className:"left"},!!t.later&&d.createElement("button",{className:"transparent later",onClick:function(){n("later"),t.later()}},Se("nav.later"))),d.createElement("div",{className:"right"},d.createElement("button",{className:"secondary prev",disabled:e.isFirst,onClick:function(){n("back"),t.prev()}},Se("nav.prev")),d.createElement("button",{className:"primary next",disabled:e.isLast,onClick:function(){n("next"),t.next()}},Se("nav.next")),d.createElement("button",{className:"primary done",disabled:!e.isLast,onClick:function(){n("next"),t.done()}},Se("nav.done"))))))}function ar(){return ar=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},ar.apply(this,arguments)}function or(e){return d.createElement("svg",{x:e.x,y:e.y,width:"13",height:"13",viewBox:"0 0 13 13",fill:"none",xmlns:"http://www.w3.org/2000/svg"},d.createElement("g",{clipPath:"url(#clip0_1378_4968)"},d.createElement("mask",{id:"mask0_1378_4968",style:{maskType:"luminance"},maskUnits:"userSpaceOnUse",x:"3",y:"3",width:"7",height:"7"},d.createElement("path",{d:"M8.24474 3H4.75529C3.78587 3 3 3.78587 3 4.75529V8.24474C3 9.21416 3.78587 10 4.75529 10H8.24474C9.21416 10 10 9.21416 10 8.24474V4.75529C10 3.78587 9.21416 3 8.24474 3Z",fill:"white"})),d.createElement("g",{mask:"url(#mask0_1378_4968)"},d.createElement("path",{d:"M8.24474 3H4.75529C3.78587 3 3 3.78587 3 4.75529V8.24474C3 9.21416 3.78587 10 4.75529 10H8.24474C9.21416 10 10 9.21416 10 8.24474V4.75529C10 3.78587 9.21416 3 8.24474 3Z",fill:"black"}),d.createElement("g",{filter:"url(#filter0_f_1378_4968)"},d.createElement("path",{d:"M1.63176 9.78151C1.21965 9.37695 1.27011 8.48348 1.16919 6.98313C1.05985 5.4912 0.79072 3.40082 1.53924 2.79394C2.28776 2.19548 4.05394 3.08052 4.85292 4.16786C5.65191 5.24676 5.47529 6.52796 5.34072 7.38772C5.20616 8.24747 5.10523 8.67735 4.86133 9.04822C4.60902 9.41909 4.21373 9.71411 3.56614 9.90801C2.92695 10.1018 2.04386 10.1861 1.63176 9.78151Z",fill:"#82F8FF"})),d.createElement("g",{filter:"url(#filter1_f_1378_4968)"},d.createElement("path",{d:"M13.2116 14.0692C12.2042 14.9459 10.9063 15.7835 10.1888 15.3222C9.4712 14.8609 9.31837 13.0938 8.50857 11.8575C7.69503 10.6295 6.21675 9.9289 5.8419 8.84666C5.45554 7.76936 6.16887 6.31888 7.19213 4.92645C8.21539 3.53402 9.53707 2.20455 11.0997 1.77681C12.6585 1.35745 14.4542 1.82798 15.1753 3.07492C15.9001 4.31349 15.5425 6.325 15.4522 7.84273C15.3542 9.35699 15.5118 10.3824 15.232 11.343C14.9521 12.3035 14.2231 13.2042 13.2116 14.0692Z",fill:"#4865FF"})),d.createElement("g",{filter:"url(#filter2_f_1378_4968)"},d.createElement("path",{d:"M7.34874 9.41669C7.51998 9.78892 7.22119 10.2765 6.80461 10.3548C6.39038 10.4317 5.85701 10.097 5.51083 9.87562C5.16329 9.65202 5.00195 9.54544 4.90919 9.4118C4.81643 9.27815 4.79225 9.11739 4.60917 8.87053C4.42977 8.62466 4.09246 8.28901 4.10175 8.04029C4.10869 7.79292 4.46456 7.63114 4.80544 7.56225C5.14865 7.49202 5.47686 7.51469 5.65695 7.69151C5.83803 7.86465 5.87 8.19563 6.20477 8.48907C6.5409 8.78485 7.17848 9.04074 7.34874 9.41669Z",fill:"#9712FF"})),d.createElement("g",{filter:"url(#filter3_f_1378_4968)"},d.createElement("path",{d:"M8.1062 2.67462C8.78965 3.0443 9.51703 3.96501 9.45357 4.79504C9.39499 5.63204 8.54556 6.37837 7.86211 6.48299C7.17379 6.58762 6.65144 6.05752 6.30972 5.79944C5.96799 5.54137 5.80689 5.56229 5.14786 5.45766C4.4937 5.34606 3.34649 5.11589 2.86319 4.19518C2.3799 3.2675 2.55564 1.65627 3.21468 1.28659C3.86884 0.909943 4.99652 1.7888 5.885 2.13755C6.77348 2.4863 7.41787 2.30495 8.1062 2.67462Z",fill:"#FF8051"})),d.createElement("path",{d:"M7.04862 5.35217L6.6879 4.73119C6.61416 4.60427 6.43087 4.6042 6.35706 4.73108L4.81148 7.38761C4.77678 7.44725 4.77688 7.52097 4.81175 7.58052L5.17189 8.19554C5.24586 8.32187 5.42851 8.32171 5.50228 8.19526L7.04845 5.54469C7.08314 5.48522 7.0832 5.4117 7.04862 5.35217Z",fill:"white"}),d.createElement("path",{d:"M6.92141 6.47162H6.85324C6.70611 6.47162 6.61403 6.63076 6.68736 6.75832L7.51202 8.19294C7.58515 8.32015 7.76834 8.32111 7.84279 8.19467L8.20879 7.57313C8.24403 7.51328 8.24408 7.43903 8.2089 7.37914L8.05802 7.12223C7.8213 6.71917 7.38883 6.47162 6.92141 6.47162Z",fill:"white"}))),d.createElement("defs",null,d.createElement("filter",{id:"filter0_f_1378_4968",x:"-1.83569",y:"-0.266382",width:"10.16",height:"13.2029",filterUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},d.createElement("feFlood",{floodOpacity:"0",result:"BackgroundImageFix"}),d.createElement("feBlend",{mode:"normal",in:"SourceGraphic",in2:"BackgroundImageFix",result:"shape"}),d.createElement("feGaussianBlur",{stdDeviation:"1.43353",result:"effect1_foregroundBlur_1378_4968"})),d.createElement("filter",{id:"filter1_f_1378_4968",x:"2.86829",y:"-1.23998",width:"15.6189",height:"19.5603",filterUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},d.createElement("feFlood",{floodOpacity:"0",result:"BackgroundImageFix"}),d.createElement("feBlend",{mode:"normal",in:"SourceGraphic",in2:"BackgroundImageFix",result:"shape"}),d.createElement("feGaussianBlur",{stdDeviation:"1.43353",result:"effect1_foregroundBlur_1378_4968"})),d.createElement("filter",{id:"filter2_f_1378_4968",x:"1.2345",y:"4.65818",width:"9.03051",height:"8.57494",filterUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},d.createElement("feFlood",{floodOpacity:"0",result:"BackgroundImageFix"}),d.createElement("feBlend",{mode:"normal",in:"SourceGraphic",in2:"BackgroundImageFix",result:"shape"}),d.createElement("feGaussianBlur",{stdDeviation:"1.43353",result:"effect1_foregroundBlur_1378_4968"})),d.createElement("filter",{id:"filter3_f_1378_4968",x:"-0.279047",y:"-1.67248",width:"12.6035",height:"11.036",filterUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},d.createElement("feFlood",{floodOpacity:"0",result:"BackgroundImageFix"}),d.createElement("feBlend",{mode:"normal",in:"SourceGraphic",in2:"BackgroundImageFix",result:"shape"}),d.createElement("feGaussianBlur",{stdDeviation:"1.43353",result:"effect1_foregroundBlur_1378_4968"})),d.createElement("clipPath",{id:"clip0_1378_4968"},d.createElement("rect",{width:"13",height:"13",fill:"white"}))))}function ir(e){return d.createElement("svg",{x:e.x,y:e.y,width:"13",height:"13",viewBox:"0 0 13 13",fill:"none",xmlns:"http://www.w3.org/2000/svg"},d.createElement("rect",{x:"2.92432",y:"2.92432",width:"7.15139",height:"7.15139",rx:"1.78785",fill:"#24A381"}),d.createElement("path",{d:"M6.24732 4.11622C5.71871 4.11622 5.24908 4.45203 5.08538 4.94768C4.91739 4.98184 4.7587 5.05091 4.61988 5.15029C4.48105 5.24968 4.36527 5.37709 4.28024 5.52405C4.01512 5.9761 4.07566 6.5444 4.43083 6.93187C4.32118 7.25641 4.35881 7.61156 4.53393 7.90543C4.79742 8.35909 5.32759 8.59158 5.8464 8.4834C5.95999 8.60988 6.09961 8.71101 6.25594 8.78005C6.41228 8.8491 6.58174 8.88446 6.75302 8.8838C7.28163 8.8838 7.75126 8.54799 7.91495 8.05234C8.25534 7.98289 8.54828 7.773 8.71847 7.47597C8.98521 7.02392 8.92467 6.45562 8.56957 6.06815V6.06655C8.62373 5.90613 8.64256 5.73615 8.62478 5.56798C8.607 5.39981 8.55302 5.23732 8.46646 5.09139C8.20292 4.63933 7.67269 4.40678 7.15556 4.51496C7.04145 4.38881 6.90146 4.28803 6.74488 4.21929C6.5883 4.15055 6.4187 4.11542 6.24732 4.11622ZM6.24732 4.42623L6.24569 4.42783C6.45845 4.42783 6.66302 4.50049 6.82666 4.63453C6.82011 4.63773 6.807 4.6458 6.79721 4.65066L5.83498 5.19796C5.78586 5.22542 5.7564 5.27708 5.7564 5.3336V6.61872L5.34238 6.38302V5.32068C5.34229 5.08371 5.43754 4.8564 5.60722 4.68867C5.7769 4.52095 6.00713 4.4266 6.24732 4.42623ZM7.40647 4.80037C7.56593 4.80007 7.72264 4.8413 7.86077 4.91991C7.99889 4.99851 8.11354 5.11169 8.19312 5.24802C8.29784 5.42885 8.3371 5.64035 8.30109 5.84538C8.29453 5.84052 8.28149 5.83411 8.27325 5.82925L7.31102 5.28029C7.28682 5.26678 7.25948 5.25968 7.23167 5.25968C7.20386 5.25968 7.17652 5.26678 7.15231 5.28029L6.02477 5.92284V5.45139L6.95591 4.92022C7.09282 4.84191 7.24822 4.80056 7.40647 4.80031V4.80037ZM5.02653 5.28835V6.41689C5.02653 6.47341 5.05598 6.52347 5.1051 6.55253L6.23097 7.19348L5.81526 7.43078L4.88574 6.90121C4.67801 6.78244 4.52653 6.58721 4.46457 6.35837C4.4026 6.12953 4.4352 5.88578 4.55521 5.68063C4.66108 5.49958 4.82782 5.36084 5.02653 5.28835ZM7.1834 5.56764L8.11454 6.09721C8.54823 6.34423 8.69545 6.88994 8.44507 7.3178L8.44669 7.3194C8.34034 7.50023 8.1734 7.63907 7.97538 7.71013V6.58153C7.97538 6.52501 7.94592 6.47335 7.8968 6.44595L6.76931 5.80334L7.1834 5.56764ZM6.49933 5.95677L6.97395 6.22799V6.76883L6.49933 7.04005L6.02477 6.76883V6.22799L6.49933 5.95677ZM7.24556 6.38302L7.65958 6.61872V7.67946C7.65958 8.17351 7.25373 8.5739 6.75464 8.5739V8.5723C6.54351 8.5723 6.33731 8.49965 6.1753 8.36567C6.18185 8.36246 6.19658 8.35434 6.20476 8.34948L7.16699 7.80217C7.2161 7.77471 7.24718 7.72305 7.2455 7.66653L7.24556 6.38302ZM6.97551 7.07724V7.54863L6.04437 8.0782C5.61068 8.32362 5.05755 8.17831 4.80716 7.75206H4.80879C4.70244 7.57283 4.66475 7.35973 4.70076 7.1547C4.70731 7.15956 4.72042 7.16597 4.72859 7.17083L5.69082 7.71979C5.71503 7.7333 5.74237 7.7404 5.77018 7.7404C5.79799 7.7404 5.82532 7.7333 5.84953 7.71979L6.97551 7.07724Z",fill:"white"}))}function lr(e){return d.createElement("svg",{x:e.x,y:e.y,width:"13",height:"13",viewBox:"0 0 13 13",fill:"none",xmlns:"http://www.w3.org/2000/svg"},d.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M6.50074 3.31464C4.70636 3.31464 3.31543 4.62903 3.31543 6.4044C3.31543 7.33304 3.69601 8.13548 4.3158 8.68974C4.36782 8.73631 4.39923 8.80155 4.40137 8.87137L4.41871 9.43797C4.42426 9.61871 4.61094 9.73631 4.77632 9.6633L5.40856 9.3842C5.46216 9.36057 5.52221 9.35617 5.57869 9.37172C5.86922 9.45161 6.17844 9.49416 6.50074 9.49416C8.29512 9.49416 9.68605 8.17977 9.68605 6.4044C9.68605 4.62903 8.29512 3.31464 6.50074 3.31464Z",fill:"url(#paint0_radial_1378_4988)"}),d.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M4.58782 7.30781L5.52351 5.82332C5.67234 5.58716 5.99107 5.52836 6.21439 5.69584L6.95859 6.25399C7.02687 6.30521 7.12081 6.30494 7.18881 6.25334L8.19388 5.49055C8.32803 5.38875 8.50314 5.54929 8.41337 5.69175L7.47768 7.17625C7.32883 7.4124 7.01011 7.47121 6.7868 7.30372L6.04259 6.74555C5.97431 6.69435 5.88036 6.69462 5.81237 6.74622L4.80729 7.50901C4.67315 7.61081 4.49803 7.45027 4.58782 7.30781Z",fill:"white"}),d.createElement("defs",null,d.createElement("radialGradient",{id:"paint0_radial_1378_4988",cx:"0",cy:"0",r:"1",gradientUnits:"userSpaceOnUse",gradientTransform:"translate(4.54161 9.6512) scale(6.9414 6.94142)"},d.createElement("stop",{stopColor:"#0099FF"}),d.createElement("stop",{offset:"0.609754",stopColor:"#A033FF"}),d.createElement("stop",{offset:"0.934823",stopColor:"#FF5280"}),d.createElement("stop",{offset:"1",stopColor:"#FF7061"}))))}function sr(e){return d.createElement("svg",{x:e.x,y:e.y,width:"13",height:"13",viewBox:"0 0 13 13",fill:"none",xmlns:"http://www.w3.org/2000/svg"},d.createElement("circle",{cx:"6.5",cy:"6.29218",r:"3.5",fill:"#25D366"}),d.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M7.87829 4.91277C7.51276 4.54853 7.02662 4.34784 6.50864 4.34766C5.4413 4.34766 4.57265 5.21205 4.57228 6.27454C4.57209 6.6142 4.66132 6.94573 4.83076 7.2379L4.55603 8.23655L5.58252 7.96859C5.86532 8.12216 6.18378 8.203 6.50781 8.2031H6.50864C7.5758 8.2031 8.44455 7.33861 8.44492 6.27611C8.4451 5.76118 8.24391 5.2771 7.87829 4.91286V4.91277ZM6.50864 7.87767H6.50799C6.21924 7.87758 5.93598 7.80033 5.68883 7.65443L5.63006 7.6197L5.0209 7.77871L5.18347 7.18763L5.14522 7.12702C4.98414 6.872 4.899 6.57724 4.89918 6.27464C4.89956 5.39158 5.62151 4.67309 6.5093 4.67309C6.93916 4.67327 7.34323 4.84005 7.6471 5.14284C7.95099 5.44554 8.1182 5.84804 8.11802 6.27593C8.11764 7.15909 7.39569 7.87758 6.50864 7.87758V7.87767ZM7.39141 6.67814C7.34303 6.65403 7.10518 6.5376 7.06079 6.52153C7.01641 6.50545 6.9842 6.49742 6.95197 6.54564C6.91976 6.59388 6.82701 6.70236 6.79878 6.73441C6.77056 6.76657 6.74233 6.77055 6.69396 6.74642C6.6456 6.72231 6.4897 6.67149 6.30485 6.50748C6.16104 6.37978 6.06391 6.22216 6.0357 6.17392C6.00747 6.12569 6.03273 6.09963 6.05686 6.0757C6.07858 6.05408 6.10523 6.01943 6.12946 5.99134C6.1537 5.96325 6.16169 5.94311 6.17784 5.91104C6.194 5.87889 6.18592 5.85081 6.17385 5.82668C6.16177 5.80257 6.06504 5.56556 6.02465 5.46919C5.98537 5.37532 5.94545 5.38807 5.91583 5.3865C5.88761 5.38511 5.85539 5.38484 5.82308 5.38484C5.79077 5.38484 5.7384 5.39685 5.69403 5.44508C5.64965 5.49331 5.52468 5.60982 5.52468 5.84673C5.52468 6.08365 5.69802 6.31271 5.72225 6.34486C5.74648 6.37702 6.06345 6.86331 6.54875 7.07195C6.66416 7.12157 6.75431 7.15123 6.82459 7.1734C6.94047 7.21009 7.04593 7.20491 7.12931 7.19253C7.22225 7.17867 7.41555 7.07601 7.45585 6.96356C7.49614 6.85111 7.49614 6.75465 7.48407 6.7346C7.47201 6.71455 7.4397 6.70244 7.39132 6.67833L7.39141 6.67814Z",fill:"white"}))}function ur(e){return d.createElement("svg",{x:e.x,y:e.y,width:"13",height:"13",viewBox:"0 0 13 13",fill:"none",xmlns:"http://www.w3.org/2000/svg"},d.createElement("circle",{cx:"6.50011",cy:"6.50002",r:"2.86364",fill:"white"}),d.createElement("path",{d:"M6.5 3.00003C8.43346 3.00003 10 4.56657 10 6.50003C10 8.43349 8.43346 10 6.5 10C4.56654 10 3 8.43349 3 6.50003C3 4.56657 4.56654 3.00003 6.5 3.00003ZM8.32202 5.37074C8.35554 5.10629 8.17523 4.94777 7.94309 5.03163L4.56657 6.33348L4.52114 6.35322C4.26261 6.47772 4.25735 6.70754 4.53247 6.79483L5.31795 7.03989L5.42579 6.97166L7.42983 5.70991C7.52287 5.64807 7.60921 5.68307 7.53862 5.7452L5.91696 7.21024L5.81301 7.30044L5.75785 8.09393L5.75903 8.11739C5.76689 8.16283 5.80653 8.19792 5.85483 8.19792L5.89803 8.19592L5.93612 8.18971C5.98414 8.17846 6.02236 8.15505 6.06603 8.11583L6.46189 7.73514L7.27065 8.33121L7.31302 8.35319C7.52202 8.45065 7.68686 8.36268 7.73941 8.12584L8.31386 5.41848L8.32202 5.37074Z",fill:"url(#paint0_linear_1356_4965)"}),d.createElement("defs",null,d.createElement("linearGradient",{id:"paint0_linear_1356_4965",x1:"6.5",y1:"3.00003",x2:"6.5",y2:"10",gradientUnits:"userSpaceOnUse"},d.createElement("stop",{stopColor:"#4BB6E5"}),d.createElement("stop",{offset:"1",stopColor:"#35A1CE"}))))}function cr(e){return d.createElement("svg",{x:e.x,y:e.y,width:"13",height:"13",viewBox:"0 0 13 13",fill:"none",xmlns:"http://www.w3.org/2000/svg"},d.createElement("g",{clipPath:"url(#clip0_1356_4951)"},d.createElement("path",{d:"M6.49838 10.0001C8.43142 10.0001 9.99847 8.43301 9.99847 6.49997C9.99847 4.56692 8.43142 2.99988 6.49838 2.99988C4.56533 2.99988 2.99829 4.56692 2.99829 6.49997C2.99829 8.43301 4.56533 10.0001 6.49838 10.0001Z",fill:"black"}),d.createElement("path",{d:"M6.011 5.91015V5.71912C5.9455 5.71016 5.87896 5.70454 5.81101 5.70454C4.99279 5.70454 4.32715 6.37018 4.32715 7.1884C4.32715 7.6904 4.57806 8.13463 4.96065 8.40327C4.71361 8.13814 4.56208 7.78293 4.56208 7.39296C4.56208 6.5865 5.20893 5.92876 6.011 5.90998V5.91015Z",fill:"#25F4EE"}),d.createElement("path",{d:"M6.04642 8.07085C6.41146 8.07085 6.70925 7.78044 6.72277 7.41874L6.724 4.18782H7.31431C7.30202 4.12145 7.29535 4.05314 7.29535 3.98326H6.48907L6.48784 7.21418C6.47432 7.57606 6.17653 7.8663 5.81149 7.8663C5.69806 7.8663 5.59113 7.83785 5.49719 7.78851C5.62045 7.95918 5.82044 8.07103 6.04659 8.07103L6.04642 8.07085Z",fill:"#25F4EE"}),d.createElement("path",{d:"M8.41652 5.28438V5.10476C8.19142 5.10476 7.9816 5.03786 7.80566 4.9232C7.96228 5.103 8.17509 5.23276 8.41652 5.28438Z",fill:"#25F4EE"}),d.createElement("path",{d:"M7.80578 4.92289C7.63423 4.72589 7.52993 4.46866 7.52993 4.18755H7.31396C7.37085 4.49464 7.55311 4.75819 7.80578 4.92289Z",fill:"#FE2C55"}),d.createElement("path",{d:"M5.81105 6.5108C5.43741 6.5108 5.1333 6.81473 5.1333 7.18855C5.1333 7.44877 5.28097 7.67492 5.49658 7.78835C5.41617 7.67703 5.36823 7.5406 5.36823 7.39311C5.36823 7.01947 5.67234 6.71535 6.04599 6.71535C6.11569 6.71535 6.18259 6.72694 6.24598 6.74661V5.92365C6.18048 5.91469 6.11394 5.90907 6.04599 5.90907C6.03422 5.90907 6.02263 5.90978 6.01087 5.90995V6.54205C5.94766 6.52221 5.88059 6.5108 5.81088 6.5108H5.81105Z",fill:"#FE2C55"}),d.createElement("path",{d:"M8.41653 5.28416V5.91082C7.99847 5.91082 7.61113 5.77703 7.2949 5.55017V7.18855C7.2949 8.00677 6.62927 8.67241 5.81105 8.67241C5.49482 8.67241 5.20159 8.57267 4.96069 8.40341C5.23179 8.69435 5.6179 8.87696 6.04615 8.87696C6.86437 8.87696 7.53001 8.21132 7.53001 7.3931V5.75473C7.84624 5.98176 8.23358 6.11538 8.65164 6.11538V5.3091C8.57105 5.3091 8.49239 5.30032 8.41671 5.28416H8.41653Z",fill:"#FE2C55"}),d.createElement("path",{d:"M7.29516 7.18845V5.55008C7.61139 5.77711 7.99873 5.91073 8.41679 5.91073V5.28407C8.17537 5.23245 7.96256 5.10269 7.80594 4.92289C7.55327 4.75819 7.37102 4.49464 7.31413 4.18755H6.72381L6.72259 7.41846C6.70907 7.78034 6.41128 8.07058 6.04624 8.07058C5.82008 8.07058 5.62009 7.95891 5.49683 7.78807C5.28104 7.67446 5.13355 7.44849 5.13355 7.18827C5.13355 6.81463 5.43766 6.51052 5.81131 6.51052C5.88101 6.51052 5.94791 6.52211 6.0113 6.54177V5.90967C5.20923 5.92846 4.56238 6.5862 4.56238 7.39265C4.56238 7.7828 4.71391 8.13783 4.96095 8.40296C5.20203 8.57222 5.49508 8.67196 5.81131 8.67196C6.62953 8.67196 7.29516 8.00632 7.29516 7.1881V7.18845Z",fill:"white"})),d.createElement("defs",null,d.createElement("clipPath",{id:"clip0_1356_4951"},d.createElement("rect",{width:"7",height:"7",fill:"white",transform:"translate(3 3.00003)"}))))}function dr(e){return d.createElement("svg",{x:e.x,y:e.y,width:"13",height:"13",viewBox:"0 0 13 13",fill:"none",xmlns:"http://www.w3.org/2000/svg"},d.createElement("rect",{x:"3",y:"3",width:"7",height:"7",rx:"3.5",fill:"url(#paint0_radial_1356_4969)"}),d.createElement("rect",{x:"3",y:"3",width:"7",height:"7",rx:"3.5",fill:"url(#paint1_radial_1356_4969)"}),d.createElement("path",{d:"M5.53385 4.18302C5.28558 4.19473 5.11604 4.23435 4.96782 4.29259C4.81443 4.35238 4.68441 4.4326 4.55505 4.56242C4.42569 4.69225 4.34603 4.82236 4.28667 4.97598C4.22922 5.12452 4.1903 5.2942 4.17933 5.54261C4.16837 5.79102 4.16594 5.87087 4.16715 6.50451C4.16837 7.13815 4.17117 7.21758 4.18321 7.4665C4.19506 7.71472 4.23454 7.88421 4.29278 8.03247C4.35266 8.18587 4.43278 8.31584 4.56266 8.44524C4.69253 8.57465 4.82255 8.65412 4.97655 8.71358C5.12495 8.77093 5.29468 8.81004 5.54304 8.82091C5.7914 8.83178 5.87134 8.8343 6.5048 8.83309C7.13826 8.83188 7.21802 8.82908 7.46689 8.81727C7.71577 8.80546 7.88438 8.7657 8.03269 8.70774C8.18608 8.64773 8.31614 8.56774 8.44546 8.43782C8.57477 8.3079 8.65439 8.1777 8.7137 8.02398C8.77119 7.87558 8.81025 7.70585 8.82103 7.45768C8.83191 7.20862 8.83447 7.1291 8.83326 6.49555C8.83205 5.862 8.8292 5.78257 8.81739 5.53375C8.80559 5.28492 8.76606 5.11594 8.70787 4.96758C8.6479 4.81419 8.56786 4.68432 8.43804 4.55482C8.30821 4.42532 8.17791 4.34575 8.02424 4.28657C7.87574 4.22913 7.70611 4.18997 7.45775 4.17924C7.20938 4.16851 7.12944 4.16575 6.49575 4.16697C5.86206 4.16818 5.78272 4.17089 5.53385 4.18302ZM5.5611 8.40114C5.3336 8.39125 5.21007 8.35345 5.12775 8.32181C5.01874 8.27981 4.94108 8.22903 4.85904 8.14779C4.777 8.06654 4.7266 7.98861 4.68404 7.87983C4.65207 7.79751 4.61357 7.67412 4.60293 7.44662C4.59136 7.20073 4.58893 7.1269 4.58758 6.50395C4.58622 5.88099 4.5886 5.80726 4.59938 5.56128C4.60909 5.33396 4.64713 5.2103 4.67872 5.12802C4.72072 5.01887 4.77131 4.94136 4.85274 4.85936C4.93417 4.77737 5.01188 4.72688 5.12075 4.68432C5.20298 4.65221 5.32637 4.61404 5.55377 4.60321C5.79985 4.59154 5.87358 4.58921 6.49645 4.58786C7.11932 4.5865 7.19324 4.58884 7.43941 4.59966C7.66672 4.60956 7.79044 4.64722 7.87262 4.679C7.98168 4.721 8.05929 4.77144 8.14128 4.85302C8.22327 4.93459 8.27382 5.01201 8.31638 5.12112C8.34853 5.20311 8.3867 5.32645 8.39744 5.554C8.40915 5.80007 8.41181 5.87385 8.41293 6.49667C8.41405 7.11948 8.41186 7.19345 8.40108 7.43934C8.39114 7.66684 8.35343 7.79041 8.32174 7.87283C8.27974 7.98179 8.22911 8.05949 8.14763 8.14144C8.06615 8.22339 7.98854 8.27388 7.87962 8.31644C7.79748 8.3485 7.67396 8.38677 7.44673 8.3976C7.20066 8.40917 7.12692 8.4116 6.50382 8.41295C5.88072 8.4143 5.80718 8.41178 5.5611 8.40114ZM7.4633 5.25295C7.46339 5.30833 7.47991 5.36245 7.51076 5.40844C7.5416 5.45444 7.5854 5.49025 7.6366 5.51136C7.68781 5.53246 7.74412 5.53791 7.79842 5.52701C7.85272 5.5161 7.90257 5.48934 7.94166 5.45011C7.98075 5.41088 8.00732 5.36093 8.01803 5.30659C8.02873 5.25226 8.02308 5.19596 8.00179 5.14484C7.98049 5.09371 7.94452 5.05005 7.89841 5.01937C7.8523 4.98869 7.79813 4.97237 7.74274 4.97248C7.6685 4.97263 7.59735 5.00226 7.54495 5.05486C7.49255 5.10745 7.46318 5.17871 7.4633 5.25295ZM5.30215 6.50236C5.30345 7.1641 5.84087 7.69932 6.50247 7.69806C7.16407 7.6968 7.69967 7.15943 7.69841 6.4977C7.69715 5.83596 7.15959 5.3006 6.4979 5.3019C5.8362 5.30321 5.30089 5.84072 5.30215 6.50236ZM5.72243 6.50152C5.72213 6.34769 5.76745 6.19722 5.85266 6.06914C5.93787 5.94107 6.05915 5.84114 6.20116 5.78198C6.34316 5.72283 6.49952 5.70712 6.65046 5.73683C6.8014 5.76655 6.94014 5.84035 7.04913 5.94891C7.15812 6.05747 7.23247 6.19591 7.26278 6.34673C7.29309 6.49755 7.278 6.65397 7.21941 6.79621C7.16082 6.93845 7.06137 7.06012 6.93363 7.14584C6.80589 7.23156 6.6556 7.27747 6.50177 7.27778C6.39963 7.27799 6.29844 7.25808 6.20399 7.21919C6.10954 7.18029 6.02367 7.12317 5.9513 7.05108C5.87893 6.979 5.82147 6.89336 5.7822 6.79907C5.74293 6.70477 5.72262 6.60367 5.72243 6.50152Z",fill:"white"}),d.createElement("defs",null,d.createElement("radialGradient",{id:"paint0_radial_1356_4969",cx:"0",cy:"0",r:"1",gradientUnits:"userSpaceOnUse",gradientTransform:"translate(8.915 10.945) rotate(-115.776) scale(9.54578 14.1983)"},d.createElement("stop",{offset:"0.24392",stopColor:"#FF1B90"}),d.createElement("stop",{offset:"0.436673",stopColor:"#F80261"}),d.createElement("stop",{offset:"0.688476",stopColor:"#ED00C0"}),d.createElement("stop",{offset:"0.776787",stopColor:"#C500E9"}),d.createElement("stop",{offset:"0.893155",stopColor:"#7017FF"})),d.createElement("radialGradient",{id:"paint1_radial_1356_4969",cx:"0",cy:"0",r:"1",gradientUnits:"userSpaceOnUse",gradientTransform:"translate(5.5375 9.75853) rotate(-57.4396) scale(4.13609 4.30213)"},d.createElement("stop",{stopColor:"#FFD600"}),d.createElement("stop",{offset:"0.484375",stopColor:"#FF6930"}),d.createElement("stop",{offset:"0.734375",stopColor:"#FE3B36"}),d.createElement("stop",{offset:"1",stopColor:"#FE3B36",stopOpacity:"0"}))))}function fr(e){return d.createElement("svg",{x:e.x,y:e.y,width:"13",height:"13",viewBox:"0 0 13 13",fill:"none",xmlns:"http://www.w3.org/2000/svg"},d.createElement("circle",{cx:"6.5",cy:"6.50003",r:"3.5",fill:"#1DA1F2"}),d.createElement("path",{d:"M8.55462 5.45345C8.40817 5.51325 8.25093 5.55378 8.08565 5.57202C8.25424 5.47877 8.38366 5.33101 8.44466 5.15505C8.28692 5.24139 8.11222 5.30425 7.92617 5.33786C7.77729 5.19154 7.56516 5.09996 7.33027 5.09996C6.87939 5.09996 6.51371 5.43733 6.51371 5.85361C6.51371 5.91267 6.52107 5.96995 6.53479 6.0252C5.85588 5.99366 5.25443 5.69382 4.85158 5.23782C4.78135 5.34926 4.74112 5.47866 4.74112 5.61663C4.74112 5.87808 4.88532 6.10884 5.10437 6.24394C4.97052 6.23997 4.84459 6.20612 4.7345 6.14965C4.73438 6.15282 4.73438 6.15598 4.73438 6.15898C4.73438 6.52421 5.01586 6.82888 5.38953 6.89807C5.32086 6.91522 5.24882 6.92437 5.17441 6.92437C5.12164 6.92437 5.07044 6.91988 5.02066 6.91108C5.12464 7.2104 5.42602 7.42832 5.78346 7.43431C5.50392 7.63647 5.15171 7.757 4.76931 7.757C4.70351 7.757 4.63858 7.75349 4.57458 7.74641C4.93596 7.96037 5.3652 8.08499 5.82619 8.08499C7.32828 8.08499 8.14958 6.93669 8.14958 5.94088C8.14958 5.9083 8.14871 5.8756 8.14715 5.84337C8.30676 5.73705 8.44522 5.60449 8.55462 5.45345Z",fill:"white"}))}opr.browserSidebarPrivate.onItemVisibilityChanged.addListener((function(){jn().then((function(e){var t,n=Rn(Qn);try{for(n.s();!(t=n.n()).done;){(0,t.value)(e)}}catch(e){n.e(e)}finally{n.f()}}))})),(Tn=zn||(zn={})).Inactive=function(){return d.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M31 32C37.6274 32 43 26.6274 43 20C43 13.3726 37.6274 8 31 8C24.3726 8 19 13.3726 19 20C19 26.6274 24.3726 32 31 32ZM25.7461 12.4316C26.2543 12.232 26.8356 12.0961 27.6868 12.056C28.5401 12.0143 28.8121 12.0051 30.9847 12.0009C33.1574 11.9968 33.4315 12.0062 34.283 12.043C35.1345 12.0798 35.7161 12.214 36.2253 12.411C36.7522 12.6139 37.1989 12.8867 37.644 13.3307C38.0891 13.7747 38.3635 14.22 38.5691 14.7459C38.7687 15.2545 38.9042 15.8339 38.9447 16.687C38.9851 17.5401 38.9949 17.8125 38.9991 19.9846C39.0032 22.1568 38.9944 22.4294 38.9571 23.2833C38.9202 24.1342 38.7863 24.7162 38.5891 25.225C38.3858 25.752 38.1128 26.1984 37.6694 26.6438C37.2261 27.0893 36.7802 27.3635 36.2542 27.5693C35.7457 27.768 35.1677 27.9043 34.3144 27.9448C33.4611 27.9853 33.1876 27.9949 31.0158 27.999C28.8439 28.0032 28.5698 27.9946 27.7183 27.9573C26.8668 27.92 26.2848 27.7859 25.776 27.5893C25.248 27.3854 24.8023 27.113 24.357 26.6693C23.9117 26.2256 23.637 25.78 23.4317 25.2541C23.232 24.7458 23.0967 24.1646 23.056 23.3136C23.0147 22.4601 23.0051 22.1878 23.001 20.0153C22.9968 17.8428 23.0051 17.5691 23.0427 16.7174C23.0803 15.8657 23.2138 15.284 23.4107 14.7747C23.6143 14.248 23.8874 13.8019 24.3309 13.3568C24.7744 12.9116 25.2202 12.6366 25.7461 12.4316ZM26.2944 26.2461C26.5767 26.3546 27.0002 26.4842 27.7802 26.5181C28.6239 26.5546 28.8761 26.5632 31.0124 26.5586C33.1488 26.5539 33.4016 26.5456 34.2452 26.5059C35.0243 26.4688 35.4478 26.3376 35.7294 26.2277C36.1029 26.0818 36.3689 25.9086 36.6483 25.6277C36.9277 25.3467 37.1013 25.0803 37.2453 24.7067C37.3539 24.4242 37.4832 24.0005 37.5173 23.2205C37.5542 22.3774 37.5618 22.1238 37.5579 19.9885C37.5541 17.8531 37.545 17.6001 37.5048 16.7564C37.468 15.9763 37.3371 15.5534 37.2269 15.2723C37.081 14.8982 36.9077 14.6328 36.6266 14.3531C36.3454 14.0734 36.0793 13.9004 35.7054 13.7564C35.4237 13.6475 34.9995 13.5184 34.2201 13.4844C33.3761 13.4473 33.1227 13.4393 30.9871 13.444C28.8516 13.4486 28.5988 13.4566 27.7551 13.4966C26.9754 13.5337 26.5524 13.6646 26.2704 13.7747C25.8972 13.9206 25.6308 14.0937 25.3516 14.3748C25.0724 14.656 24.8989 14.9217 24.7549 15.296C24.6466 15.578 24.5162 16.002 24.4829 16.7814C24.4459 17.6248 24.4378 17.8776 24.4424 20.0134C24.4471 22.1493 24.4554 22.4024 24.4951 23.2454C24.5315 24.0254 24.6635 24.4485 24.7732 24.7307C24.9191 25.1037 25.0919 25.3709 25.3732 25.6494C25.6544 25.928 25.9207 26.1021 26.2944 26.2461ZM34.4648 16.2574C34.359 16.0997 34.3024 15.9142 34.302 15.7243C34.3016 15.4697 34.4023 15.2254 34.582 15.0451C34.7617 14.8648 35.0056 14.7632 35.2601 14.7627C35.45 14.7623 35.6358 14.8182 35.7938 14.9234C35.9519 15.0286 36.0753 15.1783 36.1483 15.3536C36.2213 15.5289 36.2407 15.7219 36.204 15.9082C36.1673 16.0945 36.0762 16.2657 35.9421 16.4003C35.8081 16.5348 35.6372 16.6265 35.451 16.6639C35.2649 16.7013 35.0718 16.6826 34.8962 16.6103C34.7207 16.5379 34.5705 16.4151 34.4648 16.2574ZM31.0078 24.1075C28.7394 24.1118 26.8969 22.2768 26.8924 20.008C26.8881 17.7395 28.7234 15.8966 30.9921 15.8921C33.2608 15.8876 35.1038 17.7232 35.1081 19.992C35.1125 22.2608 33.2761 24.1032 31.0078 24.1075ZM28.7798 18.5227C28.4877 18.9618 28.3323 19.4777 28.3333 20.0051C28.334 20.3553 28.4036 20.702 28.5383 21.0253C28.6729 21.3486 28.8699 21.6422 29.1181 21.8893C29.3662 22.1365 29.6606 22.3323 29.9844 22.4657C30.3082 22.599 30.6552 22.6673 31.0054 22.6665C31.5328 22.6655 32.0481 22.5081 32.486 22.2142C32.924 21.9203 33.265 21.5031 33.4659 21.0155C33.6667 20.5278 33.7185 19.9915 33.6146 19.4744C33.5106 18.9573 33.2557 18.4826 32.882 18.1104C32.5083 17.7382 32.0327 17.4852 31.5152 17.3833C30.9977 17.2814 30.4616 17.3353 29.9747 17.5381C29.4878 17.7409 29.072 18.0835 28.7798 18.5227Z",fill:"black",fillOpacity:"0.5"})},Tn.Active=function(){return d.createElement("g",{clipPath:"url(#clip0_1135_41073)"},d.createElement("rect",{x:"18.9993",y:"8",width:"24",height:"24",rx:"12",fill:"url(#paint0_radial_1135_41073)"}),d.createElement("rect",{x:"18.9993",y:"8",width:"24",height:"24",rx:"12",fill:"url(#paint1_radial_1135_41073)"}),d.createElement("path",{d:"M27.6868 12.056C26.8356 12.0961 26.2543 12.232 25.7461 12.4316C25.2202 12.6366 24.7744 12.9116 24.3309 13.3568C23.8874 13.8019 23.6143 14.248 23.4107 14.7747C23.2138 15.284 23.0803 15.8657 23.0427 16.7174C23.0051 17.5691 22.9968 17.8428 23.001 20.0153C23.0051 22.1878 23.0147 22.4601 23.056 23.3136C23.0967 24.1646 23.232 24.7458 23.4317 25.2541C23.637 25.78 23.9117 26.2256 24.357 26.6693C24.8023 27.113 25.248 27.3854 25.776 27.5893C26.2848 27.7859 26.8668 27.92 27.7183 27.9573C28.5698 27.9946 28.8439 28.0032 31.0158 27.999C33.1876 27.9949 33.4611 27.9853 34.3144 27.9448C35.1677 27.9043 35.7457 27.768 36.2542 27.5693C36.7802 27.3635 37.2261 27.0893 37.6694 26.6438C38.1128 26.1984 38.3858 25.752 38.5891 25.225C38.7863 24.7162 38.9202 24.1342 38.9571 23.2833C38.9944 22.4294 39.0032 22.1568 38.9991 19.9846C38.9949 17.8125 38.9851 17.5401 38.9447 16.687C38.9042 15.8339 38.7687 15.2545 38.5691 14.7459C38.3635 14.22 38.0891 13.7747 37.644 13.3307C37.1989 12.8867 36.7522 12.6139 36.2253 12.411C35.7161 12.214 35.1345 12.0798 34.283 12.043C33.4315 12.0062 33.1574 11.9968 30.9847 12.0009C28.8121 12.0051 28.5401 12.0144 27.6868 12.056ZM27.7802 26.5181C27.0002 26.4842 26.5767 26.3546 26.2944 26.2461C25.9207 26.1021 25.6544 25.928 25.3732 25.6494C25.0919 25.3709 24.9191 25.1037 24.7732 24.7307C24.6635 24.4485 24.5315 24.0254 24.4951 23.2454C24.4554 22.4024 24.4471 22.1493 24.4424 20.0134C24.4378 17.8776 24.4459 17.6248 24.4829 16.7814C24.5162 16.002 24.6466 15.578 24.7549 15.296C24.8989 14.9217 25.0724 14.656 25.3516 14.3748C25.6308 14.0937 25.8972 13.9206 26.2704 13.7747C26.5524 13.6646 26.9754 13.5337 27.7551 13.4966C28.5988 13.4566 28.8516 13.4486 30.9871 13.444C33.1227 13.4393 33.3761 13.4473 34.2201 13.4844C34.9995 13.5184 35.4237 13.6475 35.7054 13.7564C36.0793 13.9004 36.3454 14.0734 36.6266 14.3531C36.9077 14.6328 37.081 14.8982 37.2269 15.2723C37.3371 15.5534 37.468 15.9763 37.5048 16.7564C37.545 17.6001 37.5541 17.8531 37.5579 19.9885C37.5618 22.1238 37.5542 22.3774 37.5173 23.2205C37.4832 24.0005 37.3539 24.4242 37.2453 24.7067C37.1013 25.0803 36.9277 25.3467 36.6483 25.6277C36.3689 25.9086 36.1029 26.0818 35.7294 26.2277C35.4478 26.3376 35.0243 26.4688 34.2452 26.5059C33.4016 26.5456 33.1488 26.5539 31.0124 26.5586C28.8761 26.5632 28.6239 26.5546 27.7802 26.5181ZM34.302 15.7243C34.3024 15.9142 34.359 16.0997 34.4648 16.2574C34.5705 16.4151 34.7207 16.5379 34.8962 16.6102C35.0718 16.6826 35.2649 16.7013 35.451 16.6639C35.6372 16.6265 35.8081 16.5348 35.9421 16.4003C36.0762 16.2657 36.1673 16.0945 36.204 15.9082C36.2407 15.7219 36.2213 15.5289 36.1483 15.3536C36.0753 15.1783 35.9519 15.0286 35.7938 14.9234C35.6358 14.8182 35.45 14.7623 35.2601 14.7627C35.0056 14.7632 34.7617 14.8648 34.582 15.0451C34.4023 15.2254 34.3016 15.4697 34.302 15.7243ZM26.8924 20.008C26.8969 22.2768 28.7394 24.1118 31.0078 24.1075C33.2761 24.1032 35.1125 22.2608 35.1081 19.992C35.1038 17.7232 33.2608 15.8876 30.9921 15.8921C28.7234 15.8966 26.8881 17.7395 26.8924 20.008ZM28.3333 20.0051C28.3323 19.4777 28.4877 18.9618 28.7798 18.5227C29.072 18.0835 29.4878 17.7409 29.9747 17.5381C30.4616 17.3353 30.9977 17.2814 31.5152 17.3833C32.0327 17.4852 32.5083 17.7382 32.882 18.1104C33.2557 18.4826 33.5106 18.9573 33.6146 19.4744C33.7185 19.9915 33.6667 20.5278 33.4659 21.0155C33.265 21.5031 32.924 21.9203 32.486 22.2142C32.0481 22.5081 31.5328 22.6655 31.0054 22.6665C30.6552 22.6673 30.3082 22.599 29.9844 22.4657C29.6606 22.3323 29.3662 22.1365 29.1181 21.8893C28.8699 21.6422 28.6729 21.3486 28.5383 21.0253C28.4036 20.702 28.334 20.3553 28.3333 20.0051Z",fill:"white"}),d.createElement("defs",null,d.createElement("radialGradient",{id:"paint0_radial_1135_41073",cx:"0",cy:"0",r:"1",gradientUnits:"userSpaceOnUse",gradientTransform:"translate(39.2793 35.24) rotate(-115.776) scale(32.7284 48.6798)"},d.createElement("stop",{offset:"0.24392",stopColor:"#FF1B90"}),d.createElement("stop",{offset:"0.436673",stopColor:"#F80261"}),d.createElement("stop",{offset:"0.688476",stopColor:"#ED00C0"}),d.createElement("stop",{offset:"0.776787",stopColor:"#C500E9"}),d.createElement("stop",{offset:"0.893155",stopColor:"#7017FF"})),d.createElement("radialGradient",{id:"paint1_radial_1135_41073",cx:"0",cy:"0",r:"1",gradientUnits:"userSpaceOnUse",gradientTransform:"translate(27.6993 31.172) rotate(-57.4396) scale(14.1809 14.7502)"},d.createElement("stop",{stopColor:"#FFD600"}),d.createElement("stop",{offset:"0.484375",stopColor:"#FF6930"}),d.createElement("stop",{offset:"0.734375",stopColor:"#FE3B36"}),d.createElement("stop",{offset:"1",stopColor:"#FE3B36",stopOpacity:"0"})),d.createElement("clipPath",{id:"clip0_1135_41073"},d.createElement("rect",{width:"62",height:"62",fill:"white"}))))},Tn.Label=function(){return d.createElement("path",{d:"M3.092 54V45.48H4.544V54H3.092ZM6.52053 54V48.144H7.86453V48.948H7.88853C8.36853 48.372 9.07653 48.06 9.84453 48.06C11.1285 48.06 11.9925 48.792 11.9925 50.556V54H10.6485V50.904C10.6485 49.668 10.1805 49.272 9.37653 49.272C8.46453 49.272 7.86453 49.908 7.86453 51.06V54H6.52053ZM15.5058 54.096C14.5578 54.096 13.7538 53.784 13.1418 53.244L13.8138 52.236C14.2818 52.692 14.7858 52.92 15.5058 52.92C16.0218 52.92 16.3218 52.692 16.3218 52.344C16.3218 52.044 15.9378 51.9 15.1698 51.636C14.2098 51.3 13.3818 50.868 13.3818 49.716C13.3818 48.756 14.2458 48.06 15.4458 48.06C16.1898 48.06 16.8618 48.264 17.5098 48.792L16.8378 49.848C16.3698 49.404 15.8298 49.224 15.3738 49.224C15.1098 49.224 14.7378 49.368 14.7378 49.728C14.7378 50.016 15.0978 50.22 15.6618 50.436C16.9098 50.928 17.6898 51.156 17.6898 52.32C17.6898 53.304 16.9938 54.096 15.5058 54.096ZM20.7644 54.096C19.7564 54.096 19.1324 53.46 19.1324 52.152V49.284H18.4124V48.144H19.1324V46.2L20.4764 46.056V48.144H22.1924V49.284H20.4764V52.02C20.4764 52.62 20.6564 52.836 21.0404 52.836C21.2684 52.836 21.5924 52.752 21.9044 52.584L22.2524 53.748C21.9044 53.94 21.5324 54.096 20.7644 54.096ZM25.6214 54.096C24.0014 54.096 22.7894 52.908 22.7894 51.096C22.7894 49.332 24.0014 48.06 25.6094 48.06C26.3534 48.06 27.0014 48.336 27.4214 48.864L27.4454 48.852V48.144H28.7894V54H27.5054V53.232L27.4814 53.22C27.0614 53.784 26.4374 54.096 25.6214 54.096ZM25.8374 52.872C26.7494 52.872 27.5054 52.164 27.5054 51.108C27.5054 50.064 26.7974 49.272 25.8374 49.272C24.9014 49.272 24.1574 49.98 24.1574 51.108C24.1574 52.14 24.8414 52.872 25.8374 52.872ZM33.1014 56.46C32.2254 56.46 31.3734 56.244 30.7134 55.848L31.0374 54.672C31.6734 55.008 32.1894 55.248 33.0294 55.248C34.1814 55.248 34.7694 54.588 34.7694 53.808V53.196H34.7454C34.3014 53.64 33.6894 53.904 32.9694 53.904C31.3374 53.904 30.1134 52.752 30.1134 51.012C30.1134 49.296 31.2774 48.06 32.8974 48.06C33.5694 48.06 34.2294 48.3 34.7214 48.768H34.7454V48.144H36.0894V53.4C36.0894 55.176 35.2734 56.46 33.1014 56.46ZM33.1494 52.668C34.1214 52.668 34.8054 51.948 34.8054 50.952C34.8054 49.956 34.0854 49.284 33.1494 49.284C32.1534 49.284 31.4814 49.98 31.4814 50.976C31.4814 52.02 32.2014 52.668 33.1494 52.668ZM37.7744 54V48.144H39.1184V49.02H39.1424C39.5984 48.408 40.2464 48.06 40.9544 48.06H41.1224V49.56C40.9664 49.548 40.8104 49.536 40.7144 49.536C39.6944 49.536 39.1184 50.268 39.1184 51.228V54H37.7744ZM44.5472 54.096C42.9272 54.096 41.7152 52.908 41.7152 51.096C41.7152 49.332 42.9272 48.06 44.5352 48.06C45.2792 48.06 45.9272 48.336 46.3472 48.864L46.3712 48.852V48.144H47.7152V54H46.4312V53.232L46.4072 53.22C45.9872 53.784 45.3632 54.096 44.5472 54.096ZM44.7632 52.872C45.6752 52.872 46.4312 52.164 46.4312 51.108C46.4312 50.064 45.7232 49.272 44.7632 49.272C43.8272 49.272 43.0832 49.98 43.0832 51.108C43.0832 52.14 43.7672 52.872 44.7632 52.872ZM49.4112 54V48.144H50.7552V48.948H50.7672C51.2472 48.372 51.9192 48.06 52.5912 48.06C53.3832 48.06 53.9952 48.372 54.3432 49.032H54.3672C54.8592 48.396 55.6032 48.06 56.4672 48.06C57.7512 48.06 58.5192 48.864 58.5192 50.616V54H57.1752V50.952C57.1752 49.896 56.8272 49.272 56.0352 49.272C55.2792 49.272 54.6672 49.932 54.6672 51.084V54H53.3232V50.952C53.3232 49.896 52.9512 49.272 52.1592 49.272C51.3552 49.272 50.7552 49.932 50.7552 51.084V54H49.4112Z",fill:"var(--icon-color)"})},(Dn=Hn||(Hn={})).Inactive=function(){return d.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M19.0021 19.6398C19.0021 12.9515 24.2421 7.99979 31.0021 7.99979C37.762 7.99979 43.0021 12.9515 43.0021 19.6398C43.0021 26.3281 37.762 31.2798 31.0021 31.2798C29.7879 31.2798 28.623 31.1195 27.5284 30.8185C27.3157 30.7599 27.0894 30.7765 26.8875 30.8655L24.5057 31.917C23.8826 32.192 23.1793 31.749 23.1585 31.0681L23.0931 28.9335C23.0851 28.6705 22.9668 28.4247 22.7707 28.2493C20.4358 26.1613 19.0021 23.1382 19.0021 19.6398ZM27.3209 17.4514L23.7959 23.0438C23.4576 23.5805 24.1173 24.1853 24.6227 23.8018L28.4091 20.9282C28.6652 20.7338 29.0192 20.7328 29.2764 20.9257L32.0801 23.0284C32.9214 23.6594 34.1221 23.4379 34.6828 22.5482L38.2078 16.9557C38.546 16.419 37.8864 15.8142 37.381 16.1977L33.5946 19.0714C33.3384 19.2658 32.9845 19.2668 32.7272 19.0738L29.9236 16.9711C29.0823 16.3402 27.8816 16.5617 27.3209 17.4514Z",fill:"black",fillOpacity:"0.5"})},Dn.Active=function(){return d.createElement(d.Fragment,null,d.createElement("g",{clipPath:"url(#clip0_1135_41203)"},d.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M19.0022 19.6398C19.0022 12.9515 24.2422 7.99979 31.0022 7.99979C37.7622 7.99979 43.0022 12.9515 43.0022 19.6398C43.0022 26.3281 37.7622 31.2798 31.0022 31.2798C29.788 31.2798 28.6231 31.1195 27.5286 30.8185C27.3158 30.7599 27.0895 30.7765 26.8876 30.8655L24.5058 31.917C23.8828 32.192 23.1795 31.749 23.1586 31.0681L23.0932 28.9335C23.0852 28.6705 22.9669 28.4247 22.7709 28.2493C20.436 26.1613 19.0022 23.1382 19.0022 19.6398ZM27.321 17.4514L23.796 23.0438C23.4577 23.5805 24.1174 24.1853 24.6228 23.8018L28.4092 20.9282C28.6654 20.7338 29.0193 20.7328 29.2765 20.9257L32.0802 23.0284C32.9215 23.6594 34.1222 23.4379 34.683 22.5482L38.208 16.9557C38.5462 16.419 37.8865 15.8142 37.3811 16.1977L33.5947 19.0714C33.3385 19.2658 32.9846 19.2668 32.7274 19.0738L29.9238 16.9711C29.0824 16.3402 27.8817 16.5617 27.321 17.4514Z",fill:"black",fillOpacity:"0.5"}),d.createElement("path",{d:"M1.056 54V45.48H2.508L5.316 50.58H5.34L8.148 45.48H9.6V54H8.148V48.3H8.124L5.796 52.356H4.848L2.52 48.3H2.508V54H1.056ZM16.8686 51C16.8686 51.216 16.8446 51.42 16.8326 51.516H12.5606C12.7286 52.368 13.3646 52.872 14.2766 52.872C14.9726 52.872 15.4526 52.56 15.7526 52.188L16.6886 52.992C16.1966 53.628 15.4646 54.096 14.2046 54.096C12.4286 54.096 11.1686 52.908 11.1686 51.072C11.1686 49.272 12.3926 48.06 14.1086 48.06C15.7526 48.06 16.8686 49.296 16.8686 51ZM14.0966 49.272C13.3526 49.272 12.7766 49.692 12.5846 50.46H15.5126C15.3446 49.752 14.8646 49.272 14.0966 49.272ZM20.1269 54.096C19.1789 54.096 18.3749 53.784 17.7629 53.244L18.4349 52.236C18.9029 52.692 19.4069 52.92 20.1269 52.92C20.6429 52.92 20.9429 52.692 20.9429 52.344C20.9429 52.044 20.5589 51.9 19.7909 51.636C18.8309 51.3 18.0029 50.868 18.0029 49.716C18.0029 48.756 18.8669 48.06 20.0669 48.06C20.8109 48.06 21.4829 48.264 22.1309 48.792L21.4589 49.848C20.9909 49.404 20.4509 49.224 19.9949 49.224C19.7309 49.224 19.3589 49.368 19.3589 49.728C19.3589 50.016 19.7189 50.22 20.2829 50.436C21.5309 50.928 22.3109 51.156 22.3109 52.32C22.3109 53.304 21.6149 54.096 20.1269 54.096ZM25.5175 54.096C24.5695 54.096 23.7655 53.784 23.1535 53.244L23.8255 52.236C24.2935 52.692 24.7975 52.92 25.5175 52.92C26.0335 52.92 26.3335 52.692 26.3335 52.344C26.3335 52.044 25.9495 51.9 25.1815 51.636C24.2215 51.3 23.3935 50.868 23.3935 49.716C23.3935 48.756 24.2575 48.06 25.4575 48.06C26.2015 48.06 26.8735 48.264 27.5215 48.792L26.8495 49.848C26.3815 49.404 25.8415 49.224 25.3855 49.224C25.1215 49.224 24.7495 49.368 24.7495 49.728C24.7495 50.016 25.1095 50.22 25.6735 50.436C26.9215 50.928 27.7015 51.156 27.7015 52.32C27.7015 53.304 27.0055 54.096 25.5175 54.096ZM34.3882 51C34.3882 51.216 34.3642 51.42 34.3522 51.516H30.0802C30.2482 52.368 30.8842 52.872 31.7962 52.872C32.4922 52.872 32.9722 52.56 33.2722 52.188L34.2082 52.992C33.7162 53.628 32.9842 54.096 31.7242 54.096C29.9482 54.096 28.6882 52.908 28.6882 51.072C28.6882 49.272 29.9122 48.06 31.6282 48.06C33.2722 48.06 34.3882 49.296 34.3882 51ZM31.6162 49.272C30.8722 49.272 30.2962 49.692 30.1042 50.46H33.0322C32.8642 49.752 32.3842 49.272 31.6162 49.272ZM35.7744 54V48.144H37.1184V48.948H37.1424C37.6224 48.372 38.3304 48.06 39.0984 48.06C40.3824 48.06 41.2464 48.792 41.2464 50.556V54H39.9024V50.904C39.9024 49.668 39.4344 49.272 38.6304 49.272C37.7184 49.272 37.1184 49.908 37.1184 51.06V54H35.7744ZM45.5037 56.46C44.6277 56.46 43.7757 56.244 43.1157 55.848L43.4397 54.672C44.0757 55.008 44.5917 55.248 45.4317 55.248C46.5837 55.248 47.1717 54.588 47.1717 53.808V53.196H47.1477C46.7037 53.64 46.0917 53.904 45.3717 53.904C43.7397 53.904 42.5157 52.752 42.5157 51.012C42.5157 49.296 43.6797 48.06 45.2997 48.06C45.9717 48.06 46.6317 48.3 47.1237 48.768H47.1477V48.144H48.4917V53.4C48.4917 55.176 47.6757 56.46 45.5037 56.46ZM45.5517 52.668C46.5237 52.668 47.2077 51.948 47.2077 50.952C47.2077 49.956 46.4877 49.284 45.5517 49.284C44.5557 49.284 43.8837 49.98 43.8837 50.976C43.8837 52.02 44.6037 52.668 45.5517 52.668ZM55.5288 51C55.5288 51.216 55.5048 51.42 55.4928 51.516H51.2208C51.3888 52.368 52.0248 52.872 52.9368 52.872C53.6328 52.872 54.1128 52.56 54.4128 52.188L55.3488 52.992C54.8568 53.628 54.1248 54.096 52.8648 54.096C51.0888 54.096 49.8288 52.908 49.8288 51.072C49.8288 49.272 51.0528 48.06 52.7688 48.06C54.4128 48.06 55.5288 49.296 55.5288 51ZM52.7568 49.272C52.0128 49.272 51.4368 49.692 51.2448 50.46H54.1728C54.0048 49.752 53.5248 49.272 52.7568 49.272ZM56.9151 54V48.144H58.2591V49.02H58.2831C58.7391 48.408 59.3871 48.06 60.0951 48.06H60.2631V49.56C60.1071 49.548 59.9511 49.536 59.8551 49.536C58.8351 49.536 58.2591 50.268 58.2591 51.228V54H56.9151Z",fill:"white"}),d.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M31.0022 7.99979C24.2422 7.99979 19.0022 12.9515 19.0022 19.6398C19.0022 23.1382 20.436 26.1613 22.7709 28.2493C22.9669 28.4247 23.0852 28.6705 23.0932 28.9335L23.1586 31.0681C23.1795 31.749 23.8828 32.192 24.5058 31.917L26.8876 30.8655C27.0895 30.7765 27.3158 30.7599 27.5286 30.8185C28.6231 31.1195 29.788 31.2798 31.0022 31.2798C37.7622 31.2798 43.0022 26.3281 43.0022 19.6398C43.0022 12.9515 37.7622 7.99979 31.0022 7.99979Z",fill:"url(#paint0_radial_1135_41203)"}),d.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M23.796 23.0439L27.321 17.4514C27.8817 16.5617 29.0824 16.3402 29.9238 16.9711L32.7274 19.0739C32.9846 19.2668 33.3385 19.2658 33.5947 19.0714L37.3811 16.1977C37.8865 15.8142 38.5462 16.419 38.208 16.9557L34.683 22.5483C34.1222 23.4379 32.9215 23.6595 32.0802 23.0285L29.2765 20.9257C29.0193 20.7328 28.6654 20.7338 28.4092 20.9282L24.6228 23.8019C24.1174 24.1854 23.4577 23.5806 23.796 23.0439Z",fill:"white"})),d.createElement("defs",null,d.createElement("radialGradient",{id:"paint0_radial_1135_41203",cx:"0",cy:"0",r:"1",gradientUnits:"userSpaceOnUse",gradientTransform:"translate(23.6216 31.8714) scale(26.1503 26.1502)"},d.createElement("stop",{stopColor:"#0099FF"}),d.createElement("stop",{offset:"0.609754",stopColor:"#A033FF"}),d.createElement("stop",{offset:"0.934823",stopColor:"#FF5280"}),d.createElement("stop",{offset:"1",stopColor:"#FF7061"})),d.createElement("clipPath",{id:"clip0_1135_41203"},d.createElement("rect",{width:"62",height:"62",fill:"white"}))))},Dn.Label=function(){return d.createElement("path",{d:"M1.056 54V45.48H2.508L5.316 50.58H5.34L8.148 45.48H9.6V54H8.148V48.3H8.124L5.796 52.356H4.848L2.52 48.3H2.508V54H1.056ZM16.8686 51C16.8686 51.216 16.8446 51.42 16.8326 51.516H12.5606C12.7286 52.368 13.3646 52.872 14.2766 52.872C14.9726 52.872 15.4526 52.56 15.7526 52.188L16.6886 52.992C16.1966 53.628 15.4646 54.096 14.2046 54.096C12.4286 54.096 11.1686 52.908 11.1686 51.072C11.1686 49.272 12.3926 48.06 14.1086 48.06C15.7526 48.06 16.8686 49.296 16.8686 51ZM14.0966 49.272C13.3526 49.272 12.7766 49.692 12.5846 50.46H15.5126C15.3446 49.752 14.8646 49.272 14.0966 49.272ZM20.1269 54.096C19.1789 54.096 18.3749 53.784 17.7629 53.244L18.4349 52.236C18.9029 52.692 19.4069 52.92 20.1269 52.92C20.6429 52.92 20.9429 52.692 20.9429 52.344C20.9429 52.044 20.5589 51.9 19.7909 51.636C18.8309 51.3 18.0029 50.868 18.0029 49.716C18.0029 48.756 18.8669 48.06 20.0669 48.06C20.8109 48.06 21.4829 48.264 22.1309 48.792L21.4589 49.848C20.9909 49.404 20.4509 49.224 19.9949 49.224C19.7309 49.224 19.3589 49.368 19.3589 49.728C19.3589 50.016 19.7189 50.22 20.2829 50.436C21.5309 50.928 22.3109 51.156 22.3109 52.32C22.3109 53.304 21.6149 54.096 20.1269 54.096ZM25.5175 54.096C24.5695 54.096 23.7655 53.784 23.1535 53.244L23.8255 52.236C24.2935 52.692 24.7975 52.92 25.5175 52.92C26.0335 52.92 26.3335 52.692 26.3335 52.344C26.3335 52.044 25.9495 51.9 25.1815 51.636C24.2215 51.3 23.3935 50.868 23.3935 49.716C23.3935 48.756 24.2575 48.06 25.4575 48.06C26.2015 48.06 26.8735 48.264 27.5215 48.792L26.8495 49.848C26.3815 49.404 25.8415 49.224 25.3855 49.224C25.1215 49.224 24.7495 49.368 24.7495 49.728C24.7495 50.016 25.1095 50.22 25.6735 50.436C26.9215 50.928 27.7015 51.156 27.7015 52.32C27.7015 53.304 27.0055 54.096 25.5175 54.096ZM34.3882 51C34.3882 51.216 34.3642 51.42 34.3522 51.516H30.0802C30.2482 52.368 30.8842 52.872 31.7962 52.872C32.4922 52.872 32.9722 52.56 33.2722 52.188L34.2082 52.992C33.7162 53.628 32.9842 54.096 31.7242 54.096C29.9482 54.096 28.6882 52.908 28.6882 51.072C28.6882 49.272 29.9122 48.06 31.6282 48.06C33.2722 48.06 34.3882 49.296 34.3882 51ZM31.6162 49.272C30.8722 49.272 30.2962 49.692 30.1042 50.46H33.0322C32.8642 49.752 32.3842 49.272 31.6162 49.272ZM35.7744 54V48.144H37.1184V48.948H37.1424C37.6224 48.372 38.3304 48.06 39.0984 48.06C40.3824 48.06 41.2464 48.792 41.2464 50.556V54H39.9024V50.904C39.9024 49.668 39.4344 49.272 38.6304 49.272C37.7184 49.272 37.1184 49.908 37.1184 51.06V54H35.7744ZM45.5037 56.46C44.6277 56.46 43.7757 56.244 43.1157 55.848L43.4397 54.672C44.0757 55.008 44.5917 55.248 45.4317 55.248C46.5837 55.248 47.1717 54.588 47.1717 53.808V53.196H47.1477C46.7037 53.64 46.0917 53.904 45.3717 53.904C43.7397 53.904 42.5157 52.752 42.5157 51.012C42.5157 49.296 43.6797 48.06 45.2997 48.06C45.9717 48.06 46.6317 48.3 47.1237 48.768H47.1477V48.144H48.4917V53.4C48.4917 55.176 47.6757 56.46 45.5037 56.46ZM45.5517 52.668C46.5237 52.668 47.2077 51.948 47.2077 50.952C47.2077 49.956 46.4877 49.284 45.5517 49.284C44.5557 49.284 43.8837 49.98 43.8837 50.976C43.8837 52.02 44.6037 52.668 45.5517 52.668ZM55.5288 51C55.5288 51.216 55.5048 51.42 55.4928 51.516H51.2208C51.3888 52.368 52.0248 52.872 52.9368 52.872C53.6328 52.872 54.1128 52.56 54.4128 52.188L55.3488 52.992C54.8568 53.628 54.1248 54.096 52.8648 54.096C51.0888 54.096 49.8288 52.908 49.8288 51.072C49.8288 49.272 51.0528 48.06 52.7688 48.06C54.4128 48.06 55.5288 49.296 55.5288 51ZM52.7568 49.272C52.0128 49.272 51.4368 49.692 51.2448 50.46H54.1728C54.0048 49.752 53.5248 49.272 52.7568 49.272ZM56.9151 54V48.144H58.2591V49.02H58.2831C58.7391 48.408 59.3871 48.06 60.0951 48.06H60.2631V49.56C60.1071 49.548 59.9511 49.536 59.8551 49.536C58.8351 49.536 58.2591 50.268 58.2591 51.228V54H56.9151Z",fill:"var(--icon-color)"})},(Un=Bn||(Bn={})).Inactive=function(){return d.createElement("path",{d:"M31 8C37.629 8 43 13.371 43 20C43 26.629 37.629 32 31 32C24.371 32 19 26.629 19 20C19 13.371 24.371 8 31 8ZM37.2469 16.1282C37.3619 15.2215 36.7436 14.678 35.9477 14.9655L24.3711 19.429L24.2153 19.4966C23.3289 19.9235 23.3109 20.7115 24.2542 21.0107L26.9473 21.8509L27.317 21.617L34.188 17.291C34.507 17.079 34.803 17.199 34.561 17.412L29.001 22.435L28.6446 22.7443L28.4555 25.4648L28.4595 25.5452C28.4865 25.701 28.6224 25.8213 28.788 25.8213L28.9361 25.8145L29.0667 25.7932C29.2313 25.7546 29.3624 25.6744 29.5121 25.5399L30.8693 24.2347L33.6422 26.2783L33.7875 26.3537C34.5041 26.6879 35.0692 26.3862 35.2494 25.5742L37.2189 16.2918L37.2469 16.1282Z",fill:"black",fillOpacity:"0.5"})},Un.Active=function(){return d.createElement(d.Fragment,null,d.createElement("g",{clipPath:"url(#clip0_1135_41293)"},d.createElement("circle",{cx:"31.0006",cy:"19.9999",r:"9.81818",fill:"white"}),d.createElement("path",{d:"M31 8C37.629 8 43 13.371 43 20C43 26.629 37.629 32 31 32C24.371 32 19 26.629 19 20C19 13.371 24.371 8 31 8ZM37.2469 16.1282C37.3619 15.2215 36.7436 14.678 35.9477 14.9655L24.3711 19.429L24.2153 19.4966C23.3289 19.9235 23.3109 20.7115 24.2542 21.0107L26.9473 21.8509L27.317 21.617L34.188 17.291C34.507 17.079 34.803 17.199 34.561 17.412L29.001 22.435L28.6446 22.7443L28.4555 25.4648L28.4595 25.5452C28.4865 25.701 28.6224 25.8213 28.788 25.8213L28.9361 25.8145L29.0667 25.7932C29.2313 25.7546 29.3624 25.6744 29.5121 25.5399L30.8693 24.2347L33.6422 26.2783L33.7875 26.3537C34.5041 26.6879 35.0692 26.3862 35.2494 25.5742L37.2189 16.2918L37.2469 16.1282Z",fill:"url(#paint0_linear_1135_41293)"})),d.createElement("defs",null,d.createElement("linearGradient",{id:"paint0_linear_1135_41293",x1:"31",y1:"8",x2:"31",y2:"32",gradientUnits:"userSpaceOnUse"},d.createElement("stop",{stopColor:"#4BB6E5"}),d.createElement("stop",{offset:"1",stopColor:"#35A1CE"})),d.createElement("clipPath",{id:"clip0_1135_41293"},d.createElement("rect",{width:"62",height:"62",fill:"white"}))))},Un.Label=function(){return d.createElement("path",{d:"M7.796 54V46.776H5.384V45.48H11.696V46.776H9.248V54H7.796ZM17.2046 51C17.2046 51.216 17.1806 51.42 17.1686 51.516H12.8966C13.0646 52.368 13.7006 52.872 14.6126 52.872C15.3086 52.872 15.7886 52.56 16.0886 52.188L17.0246 52.992C16.5326 53.628 15.8006 54.096 14.5406 54.096C12.7646 54.096 11.5046 52.908 11.5046 51.072C11.5046 49.272 12.7286 48.06 14.4446 48.06C16.0886 48.06 17.2046 49.296 17.2046 51ZM14.4326 49.272C13.6886 49.272 13.1126 49.692 12.9206 50.46H15.8486C15.6806 49.752 15.2006 49.272 14.4326 49.272ZM18.6748 54V45.168H20.0188V54H18.6748ZM27.2124 51C27.2124 51.216 27.1884 51.42 27.1764 51.516H22.9044C23.0724 52.368 23.7084 52.872 24.6204 52.872C25.3164 52.872 25.7964 52.56 26.0964 52.188L27.0324 52.992C26.5404 53.628 25.8084 54.096 24.5484 54.096C22.7724 54.096 21.5124 52.908 21.5124 51.072C21.5124 49.272 22.7364 48.06 24.4524 48.06C26.0964 48.06 27.2124 49.296 27.2124 51ZM24.4404 49.272C23.6964 49.272 23.1204 49.692 22.9284 50.46H25.8564C25.6884 49.752 25.2084 49.272 24.4404 49.272ZM31.2147 56.46C30.3387 56.46 29.4867 56.244 28.8267 55.848L29.1507 54.672C29.7867 55.008 30.3027 55.248 31.1427 55.248C32.2947 55.248 32.8827 54.588 32.8827 53.808V53.196H32.8587C32.4147 53.64 31.8027 53.904 31.0827 53.904C29.4507 53.904 28.2267 52.752 28.2267 51.012C28.2267 49.296 29.3907 48.06 31.0107 48.06C31.6827 48.06 32.3427 48.3 32.8347 48.768H32.8587V48.144H34.2027V53.4C34.2027 55.176 33.3867 56.46 31.2147 56.46ZM31.2627 52.668C32.2347 52.668 32.9187 51.948 32.9187 50.952C32.9187 49.956 32.1987 49.284 31.2627 49.284C30.2667 49.284 29.5947 49.98 29.5947 50.976C29.5947 52.02 30.3147 52.668 31.2627 52.668ZM35.8877 54V48.144H37.2317V49.02H37.2557C37.7117 48.408 38.3597 48.06 39.0677 48.06H39.2357V49.56C39.0797 49.548 38.9237 49.536 38.8277 49.536C37.8077 49.536 37.2317 50.268 37.2317 51.228V54H35.8877ZM42.6605 54.096C41.0405 54.096 39.8285 52.908 39.8285 51.096C39.8285 49.332 41.0405 48.06 42.6485 48.06C43.3925 48.06 44.0405 48.336 44.4605 48.864L44.4845 48.852V48.144H45.8285V54H44.5445V53.232L44.5205 53.22C44.1005 53.784 43.4765 54.096 42.6605 54.096ZM42.8765 52.872C43.7885 52.872 44.5445 52.164 44.5445 51.108C44.5445 50.064 43.8365 49.272 42.8765 49.272C41.9405 49.272 41.1965 49.98 41.1965 51.108C41.1965 52.14 41.8805 52.872 42.8765 52.872ZM47.5244 54V48.144H48.8684V48.948H48.8804C49.3604 48.372 50.0324 48.06 50.7044 48.06C51.4964 48.06 52.1084 48.372 52.4564 49.032H52.4804C52.9724 48.396 53.7164 48.06 54.5804 48.06C55.8644 48.06 56.6324 48.864 56.6324 50.616V54H55.2884V50.952C55.2884 49.896 54.9404 49.272 54.1484 49.272C53.3924 49.272 52.7804 49.932 52.7804 51.084V54H51.4364V50.952C51.4364 49.896 51.0644 49.272 50.2724 49.272C49.4684 49.272 48.8684 49.932 48.8684 51.084V54H47.5244Z",fill:"var(--icon-color)"})},(Wn=Zn||(Zn={})).Inactive=function(){return d.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M43.0006 20.0003C43.0006 26.6279 37.6279 32.0006 31.0003 32.0006C24.3727 32.0006 19 26.6279 19 20.0003C19 13.3727 24.3727 8 31.0003 8C37.6279 8 43.0006 13.3727 43.0006 20.0003ZM34.3414 12.1026C34.5449 13.2019 35.1974 14.1446 36.101 14.734L36.1016 14.7334C36.7307 15.144 37.4814 15.3836 38.2869 15.3836V18.2683C36.7909 18.2683 35.4045 17.7898 34.2734 16.9777V22.8399C34.2734 25.7681 31.8912 28.1496 28.9637 28.1496C27.8319 28.1496 26.7833 27.7932 25.9206 27.1876C24.5516 26.2268 23.6541 24.6369 23.6541 22.8405C23.6541 19.913 26.0362 17.5309 28.9637 17.5309C29.2069 17.5309 29.4453 17.5508 29.6795 17.5827V20.5277C29.4525 20.4566 29.2135 20.4157 28.9637 20.4157C27.6267 20.4157 26.5388 21.5035 26.5388 22.8405C26.5388 23.7712 27.0674 24.5803 27.8392 24.9867C28.1757 25.1637 28.558 25.2654 28.9637 25.2654C30.2701 25.2654 31.335 24.2264 31.3838 22.9314L31.3886 11.3706H34.2734C34.2734 11.6204 34.2974 11.8649 34.3414 12.1026Z",fill:"black",fillOpacity:"0.5"})},Wn.Active=function(){return d.createElement(d.Fragment,null,d.createElement("g",{clipPath:"url(#clip0_1135_41240)"},d.createElement("g",{clipPath:"url(#clip1_1135_41240)"},d.createElement("path",{d:"M30.9944 32.0001C37.622 32.0001 42.9947 26.6274 42.9947 19.9998C42.9947 13.3722 37.622 7.99948 30.9944 7.99948C24.3669 7.99948 18.9941 13.3722 18.9941 19.9998C18.9941 26.6274 24.3669 32.0001 30.9944 32.0001Z",fill:"black"}),d.createElement("path",{d:"M29.3232 17.9776V17.3226C29.0987 17.2919 28.8705 17.2726 28.6376 17.2726C25.8322 17.2726 23.55 19.5548 23.55 22.3601C23.55 24.0813 24.4103 25.6043 25.7221 26.5254C24.8751 25.6164 24.3555 24.3985 24.3555 23.0615C24.3555 20.2965 26.5733 18.0414 29.3232 17.977V17.9776Z",fill:"#25F4EE"}),d.createElement("path",{d:"M29.4448 25.3857C30.6964 25.3857 31.7174 24.39 31.7637 23.1499L31.768 12.0724H33.7919C33.7497 11.8449 33.7269 11.6107 33.7269 11.3711H30.9625L30.9583 22.4485C30.9119 23.6893 29.8909 24.6844 28.6394 24.6844C28.2505 24.6844 27.8838 24.5868 27.5618 24.4177C27.9844 25.0028 28.6701 25.3863 29.4454 25.3863L29.4448 25.3857Z",fill:"#25F4EE"}),d.createElement("path",{d:"M37.5707 15.832V15.2162C36.7989 15.2162 36.0795 14.9868 35.4763 14.5937C36.0133 15.2102 36.7429 15.655 37.5707 15.832Z",fill:"#25F4EE"}),d.createElement("path",{d:"M35.4767 14.5927C34.8886 13.9172 34.531 13.0353 34.531 12.0715H33.7905C33.9856 13.1244 34.6105 14.028 35.4767 14.5927V14.5927Z",fill:"#FE2C55"}),d.createElement("path",{d:"M28.6377 20.0369C27.3566 20.0369 26.314 21.079 26.314 22.3607C26.314 23.2528 26.8202 24.0282 27.5595 24.4171C27.2838 24.0354 27.1194 23.5677 27.1194 23.062C27.1194 21.7809 28.1621 20.7383 29.4432 20.7383C29.6822 20.7383 29.9115 20.778 30.1288 20.8454V18.0238C29.9043 17.9931 29.6761 17.9739 29.4432 17.9739C29.4028 17.9739 29.3631 17.9763 29.3228 17.9769V20.1441C29.106 20.0761 28.8761 20.0369 28.6371 20.0369H28.6377Z",fill:"#FE2C55"}),d.createElement("path",{d:"M37.5708 15.8313V17.9799C36.1374 17.9799 34.8094 17.5211 33.7252 16.7434V22.3606C33.7252 25.166 31.443 27.4482 28.6377 27.4482C27.5535 27.4482 26.5481 27.1062 25.7222 26.5259C26.6517 27.5234 27.9755 28.1495 29.4437 28.1495C32.2491 28.1495 34.5313 25.8673 34.5313 23.062V17.4447C35.6155 18.2231 36.9435 18.6812 38.3768 18.6812V15.9168C38.1005 15.9168 37.8308 15.8867 37.5714 15.8313H37.5708Z",fill:"#FE2C55"}),d.createElement("path",{d:"M33.7262 22.3603V16.743C34.8104 17.5214 36.1385 17.9795 37.5718 17.9795V15.831C36.7441 15.654 36.0145 15.2091 35.4775 14.5927C34.6112 14.028 33.9863 13.1244 33.7913 12.0715H31.7673L31.7631 23.1489C31.7168 24.3896 30.6958 25.3847 29.4442 25.3847C28.6688 25.3847 27.9831 25.0019 27.5605 24.4161C26.8207 24.0266 26.315 23.2518 26.315 22.3597C26.315 21.0786 27.3577 20.036 28.6387 20.036C28.8777 20.036 29.1071 20.0757 29.3244 20.1431V17.9759C26.5745 18.0403 24.3567 20.2954 24.3567 23.0604C24.3567 24.3981 24.8762 25.6153 25.7232 26.5243C26.5498 27.1047 27.5545 27.4466 28.6387 27.4466C31.4441 27.4466 33.7262 25.1644 33.7262 22.3591V22.3603Z",fill:"white"}))),d.createElement("defs",null,d.createElement("clipPath",{id:"clip0_1135_41240"},d.createElement("rect",{width:"62",height:"62",fill:"white"})),d.createElement("clipPath",{id:"clip1_1135_41240"},d.createElement("rect",{width:"24",height:"24",fill:"white",transform:"translate(19 8)"}))))},Wn.Label=function(){return d.createElement("path",{d:"M15.796 54V46.776H13.384V45.48H19.696V46.776H17.248V54H15.796ZM21.5343 47.28C21.0303 47.28 20.6343 46.872 20.6343 46.38C20.6343 45.9 21.0303 45.492 21.5343 45.492C22.0383 45.492 22.4463 45.9 22.4463 46.38C22.4463 46.872 22.0383 47.28 21.5343 47.28ZM20.8623 54V48.144H22.2063V54H20.8623ZM24.0479 54V45.168H25.3919V50.844L25.4159 50.856L27.7919 48.144H29.3879L27.2759 50.496L29.4239 54H27.9119L26.3399 51.42L25.3919 52.452V54H24.0479ZM32.0616 54V46.776H29.6496V45.48H35.9616V46.776H33.5136V54H32.0616ZM38.8422 54.096C36.9942 54.096 35.7702 52.8 35.7702 51.084C35.7702 49.356 36.9942 48.06 38.8422 48.06C40.6422 48.06 41.9142 49.284 41.9142 51.084C41.9142 52.86 40.6422 54.096 38.8422 54.096ZM38.8422 52.872C39.7902 52.872 40.5462 52.14 40.5462 51.084C40.5462 50.004 39.8022 49.272 38.8422 49.272C37.8222 49.272 37.1382 50.064 37.1382 51.084C37.1382 52.08 37.8342 52.872 38.8422 52.872ZM43.3135 54V45.168H44.6575V50.844L44.6815 50.856L47.0575 48.144H48.6535L46.5415 50.496L48.6895 54H47.1775L45.6055 51.42L44.6575 52.452V54H43.3135Z",fill:"var(--icon-color)"})},(Kn=Gn||(Gn={})).Inactive=function(){return d.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M30.7677 32.0001C37.3951 32.0001 42.7677 26.6275 42.7677 20.0001C42.7677 13.3727 37.3951 8.00012 30.7677 8.00012C24.1403 8.00012 18.7677 13.3727 18.7677 20.0001C18.7677 26.6275 24.1403 32.0001 30.7677 32.0001ZM36.2051 16.8185C36.7717 16.7559 37.3108 16.617 37.8129 16.412C37.4379 16.9298 36.9631 17.3843 36.4159 17.7488C36.4212 17.8593 36.4242 17.9714 36.4242 18.0831C36.4242 21.4974 33.6083 25.4344 28.4583 25.4344C26.8778 25.4344 25.4061 25.0071 24.1671 24.2735C24.3865 24.2978 24.6091 24.3099 24.8347 24.3099C26.1458 24.3099 27.3534 23.8966 28.3118 23.2035C27.0863 23.183 26.053 22.4358 25.6965 21.4095C25.8672 21.4397 26.0427 21.4551 26.2237 21.4551C26.4788 21.4551 26.7258 21.4238 26.9612 21.3649C25.6801 21.1277 24.715 20.0831 24.715 18.8309C24.715 18.8207 24.715 18.8098 24.7154 18.7989C25.0928 18.9925 25.5246 19.1086 25.9835 19.1222C25.2325 18.659 24.7381 17.8678 24.7381 16.9714C24.7381 16.4984 24.876 16.0547 25.1168 15.6727C26.498 17.2361 28.5601 18.2641 30.8878 18.3723C30.8408 18.1828 30.8155 17.9864 30.8155 17.784C30.8155 16.3567 32.0693 15.2 33.6152 15.2C34.4205 15.2 35.1478 15.514 35.6583 16.0157C36.2962 15.9004 36.8951 15.6849 37.4359 15.3889C37.2268 15.9922 36.7831 16.4988 36.2051 16.8185Z",fill:"black",fillOpacity:"0.5"})},Kn.Active=function(){return d.createElement(d.Fragment,null,d.createElement("g",{clipPath:"url(#clip0_1135_41376)"},d.createElement("circle",{cx:"31.0012",cy:"20.0002",r:"12",fill:"#1DA1F2"}),d.createElement("path",{d:"M38.0457 16.412C37.5436 16.617 37.0045 16.756 36.4378 16.8185C37.0159 16.4988 37.4596 15.9922 37.6687 15.3889C37.1279 15.6849 36.5289 15.9004 35.891 16.0157C35.3806 15.514 34.6533 15.2 33.848 15.2C32.3021 15.2 31.0483 16.3567 31.0483 17.784C31.0483 17.9865 31.0736 18.1828 31.1206 18.3723C28.7929 18.2641 26.7308 17.2361 25.3496 15.6727C25.1088 16.0548 24.9709 16.4984 24.9709 16.9715C24.9709 17.8678 25.4653 18.659 26.2163 19.1222C25.7574 19.1086 25.3256 18.9926 24.9482 18.799C24.9478 18.8098 24.9478 18.8207 24.9478 18.8309C24.9478 20.0831 25.9129 21.1277 27.194 21.365C26.9585 21.4238 26.7116 21.4551 26.4564 21.4551C26.2755 21.4551 26.1 21.4397 25.9293 21.4096C26.2858 22.4358 27.3191 23.183 28.5446 23.2035C27.5862 23.8966 26.3786 24.3099 25.0675 24.3099C24.8419 24.3099 24.6193 24.2978 24.3999 24.2736C25.6389 25.0071 27.1106 25.4344 28.6911 25.4344C33.8411 25.4344 36.657 21.4974 36.657 18.0832C36.657 17.9715 36.654 17.8594 36.6487 17.7488C37.1959 17.3843 37.6707 16.9298 38.0457 16.412Z",fill:"white"})),d.createElement("defs",null,d.createElement("clipPath",{id:"clip0_1135_41376"},d.createElement("rect",{width:"62",height:"62",fill:"white"}))))},Kn.Label=function(){return d.createElement("path",{d:"M13.796 54V46.776H11.384V45.48H17.696V46.776H15.248V54H13.796ZM19.268 54L17.276 48.144H18.656L19.892 52.032H19.916L21.068 48.144H22.184L23.36 52.032H23.384L24.62 48.144H25.976L23.984 54H22.748L21.62 50.316H21.608L20.48 54H19.268ZM27.8898 47.28C27.3858 47.28 26.9898 46.872 26.9898 46.38C26.9898 45.9 27.3858 45.492 27.8898 45.492C28.3938 45.492 28.8018 45.9 28.8018 46.38C28.8018 46.872 28.3938 47.28 27.8898 47.28ZM27.2178 54V48.144H28.5618V54H27.2178ZM32.1433 54.096C31.1353 54.096 30.5113 53.46 30.5113 52.152V49.284H29.7913V48.144H30.5113V46.2L31.8553 46.056V48.144H33.5713V49.284H31.8553V52.02C31.8553 52.62 32.0353 52.836 32.4193 52.836C32.6473 52.836 32.9713 52.752 33.2833 52.584L33.6313 53.748C33.2833 53.94 32.9113 54.096 32.1433 54.096ZM36.6082 54.096C35.6002 54.096 34.9762 53.46 34.9762 52.152V49.284H34.2562V48.144H34.9762V46.2L36.3202 46.056V48.144H38.0362V49.284H36.3202V52.02C36.3202 52.62 36.5002 52.836 36.8842 52.836C37.1122 52.836 37.4362 52.752 37.7482 52.584L38.0962 53.748C37.7482 53.94 37.3762 54.096 36.6082 54.096ZM44.3218 51C44.3218 51.216 44.2978 51.42 44.2858 51.516H40.0138C40.1818 52.368 40.8178 52.872 41.7298 52.872C42.4258 52.872 42.9058 52.56 43.2058 52.188L44.1418 52.992C43.6498 53.628 42.9178 54.096 41.6578 54.096C39.8818 54.096 38.6218 52.908 38.6218 51.072C38.6218 49.272 39.8458 48.06 41.5618 48.06C43.2058 48.06 44.3218 49.296 44.3218 51ZM41.5498 49.272C40.8058 49.272 40.2298 49.692 40.0378 50.46H42.9658C42.7978 49.752 42.3178 49.272 41.5498 49.272ZM45.708 54V48.144H47.052V49.02H47.076C47.532 48.408 48.18 48.06 48.888 48.06H49.056V49.56C48.9 49.548 48.744 49.536 48.648 49.536C47.628 49.536 47.052 50.268 47.052 51.228V54H45.708Z",fill:"var(--icon-color)"})},(Jn=$n||($n={})).Inactive=function(){return d.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M31 32C37.6274 32 43 26.6274 43 20C43 13.3726 37.6274 8 31 8C24.3726 8 19 13.3726 19 20C19 26.6274 24.3726 32 31 32ZM31.0247 13.33C32.8007 13.3306 34.4674 14.0187 35.7207 15.2675C36.9742 16.5163 37.664 18.1764 37.6634 19.9419C37.6622 23.5847 34.6836 26.5487 31.0247 26.5487H31.0219C29.9109 26.5483 28.8191 26.2712 27.8495 25.7446L24.3301 26.6633L25.272 23.2394C24.6911 22.2377 24.3851 21.101 24.3858 19.9365C24.3871 16.2936 27.3653 13.33 31.0247 13.33ZM31.0225 25.4329H31.0247C34.066 25.4329 36.5413 22.9692 36.5426 19.9412C36.5432 18.4742 35.9699 17.0942 34.928 16.0564C33.8862 15.0182 32.5008 14.4464 31.027 14.4458C27.9832 14.4458 25.5079 16.9092 25.5066 19.9368C25.506 20.9743 25.7979 21.9849 26.3502 22.8592L26.4813 23.067L25.9239 25.0936L28.0125 24.5484L28.214 24.6675C29.0613 25.1677 30.0325 25.4326 31.0225 25.4329ZM32.9178 20.7833C33.07 20.8384 33.8855 21.2376 34.0514 21.3202C34.0824 21.3357 34.1115 21.3498 34.1386 21.3628C34.2561 21.4196 34.3354 21.4579 34.3691 21.5138C34.4104 21.5825 34.4104 21.9133 34.2723 22.2988C34.1342 22.6844 33.4714 23.0363 33.1527 23.0839C32.8669 23.1263 32.5053 23.144 32.108 23.0183C31.867 22.9422 31.558 22.8405 31.1623 22.6704C29.6081 22.0023 28.5574 20.5035 28.358 20.219C28.3439 20.1989 28.334 20.1848 28.3286 20.1776L28.3275 20.1762C28.2407 20.061 27.6512 19.2787 27.6512 18.4697C27.6512 17.7094 28.0266 17.3107 28.1994 17.1272C28.2112 17.1147 28.2221 17.1032 28.2318 17.0926C28.3839 16.9272 28.5635 16.886 28.6743 16.886C28.785 16.886 28.8955 16.887 28.9923 16.8917C29.0043 16.8924 29.0167 16.8923 29.0297 16.8923C29.1261 16.8919 29.2466 16.8914 29.3653 17.1753C29.4134 17.2899 29.4847 17.4627 29.5591 17.6428C29.6991 17.9818 29.8499 18.347 29.8769 18.401C29.9183 18.4837 29.946 18.5799 29.8906 18.6902C29.8819 18.7074 29.8739 18.7236 29.8663 18.7391C29.8253 18.8224 29.7948 18.8843 29.7247 18.9655C29.6965 18.9982 29.6674 19.0334 29.6383 19.0687C29.5816 19.1373 29.525 19.2058 29.4758 19.2547C29.393 19.3368 29.3064 19.4261 29.4032 19.5915C29.5 19.7569 29.833 20.2973 30.326 20.7351C30.856 21.2053 31.3165 21.4042 31.5501 21.505C31.5959 21.5248 31.633 21.5408 31.6601 21.5543C31.826 21.6371 31.9227 21.6234 32.0195 21.5132C32.1163 21.4033 32.4343 21.0313 32.5447 20.866C32.6552 20.7006 32.7657 20.7281 32.9178 20.7833Z",fill:"black",fillOpacity:"0.5"})},Jn.Active=function(){return d.createElement(d.Fragment,null,d.createElement("g",{clipPath:"url(#clip0_1135_41323)"},d.createElement("circle",{cx:"31",cy:"20",r:"12",fill:"#25D366"}),d.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M35.7207 15.2675C34.4674 14.0187 32.8007 13.3306 31.0247 13.33C27.3653 13.33 24.3871 16.2936 24.3858 19.9365C24.3851 21.101 24.6911 22.2377 25.272 23.2394L24.3301 26.6633L27.8495 25.7446C28.8191 26.2711 29.9109 26.5483 31.0219 26.5487H31.0247C34.6836 26.5487 37.6622 23.5847 37.6634 19.9418C37.664 18.1764 36.9742 16.5163 35.7207 15.2675ZM31.0247 25.4329H31.0225C30.0325 25.4326 29.0613 25.1677 28.214 24.6675L28.0125 24.5484L25.9239 25.0936L26.4813 23.067L26.3502 22.8592C25.7979 21.9849 25.506 20.9743 25.5066 19.9368C25.5079 16.9092 27.9832 14.4457 31.027 14.4457C32.5008 14.4464 33.8862 15.0182 34.928 16.0563C35.9699 17.0942 36.5432 18.4741 36.5426 19.9412C36.5413 22.9692 34.066 25.4329 31.0247 25.4329ZM34.0514 21.3202C33.8855 21.2376 33.07 20.8384 32.9178 20.7833C32.7657 20.7281 32.6552 20.7006 32.5447 20.8659C32.4343 21.0313 32.1163 21.4032 32.0195 21.5132C31.9227 21.6234 31.826 21.637 31.6601 21.5543C31.4943 21.4717 30.9598 21.2974 30.326 20.7351C29.833 20.2973 29.5 19.7568 29.4032 19.5915C29.3064 19.4261 29.393 19.3368 29.4758 19.2547C29.5503 19.1806 29.6416 19.0618 29.7247 18.9655C29.8078 18.8692 29.8352 18.8001 29.8906 18.6902C29.946 18.5799 29.9183 18.4837 29.8769 18.4009C29.8355 18.3183 29.5038 17.5057 29.3653 17.1753C29.2307 16.8534 29.0938 16.8971 28.9923 16.8917C28.8955 16.887 28.785 16.886 28.6743 16.886C28.5635 16.886 28.3839 16.9272 28.2318 17.0926C28.0796 17.2579 27.6512 17.6574 27.6512 18.4697C27.6512 19.282 28.2455 20.0673 28.3286 20.1776C28.4116 20.2878 29.4984 21.9551 31.1623 22.6704C31.558 22.8405 31.867 22.9422 32.108 23.0183C32.5053 23.144 32.8669 23.1263 33.1527 23.0838C33.4714 23.0363 34.1342 22.6844 34.2723 22.2988C34.4104 21.9133 34.4104 21.5825 34.3691 21.5138C34.3277 21.445 34.2172 21.4029 34.0514 21.3202Z",fill:"white"})),d.createElement("defs",null,d.createElement("filter",{id:"filter1_d_1135_41323",x:"30.2859",y:"-0.428904",width:"23.4324",height:"23.4308",filterUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},d.createElement("feFlood",{floodOpacity:"0",result:"BackgroundImageFix"}),d.createElement("feColorMatrix",{in:"SourceAlpha",type:"matrix",values:"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0",result:"hardAlpha"}),d.createElement("feOffset",{dy:"2.28594"}),d.createElement("feGaussianBlur",{stdDeviation:"2.85742"}),d.createElement("feComposite",{in2:"hardAlpha",operator:"out"}),d.createElement("feColorMatrix",{type:"matrix",values:"0 0 0 0 0.438924 0 0 0 0 0.536296 0 0 0 0 0.61941 0 0 0 0.2 0"}),d.createElement("feBlend",{mode:"normal",in2:"BackgroundImageFix",result:"effect1_dropShadow_1135_41323"}),d.createElement("feBlend",{mode:"normal",in:"SourceGraphic",in2:"effect1_dropShadow_1135_41323",result:"shape"})),d.createElement("clipPath",{id:"clip0_1135_41323"},d.createElement("rect",{width:"62",height:"62",fill:"white"}))))},Jn.Label=function(){return d.createElement("path",{d:"M4.084 54L1.384 45.48H2.932L4.756 51.624H4.78L6.448 45.48H7.984L9.64 51.612H9.664L11.5 45.48H13.036L10.336 54H8.98L7.24 47.592H7.216L5.44 54H4.084ZM14.2979 54V45.168H15.6419V48.876H15.6539C16.1459 48.336 16.8539 48.06 17.6459 48.06C18.9299 48.06 19.8299 48.744 19.8299 50.496V54H18.4859V50.844C18.4859 49.68 18.0179 49.272 17.2139 49.272C16.2419 49.272 15.6419 49.872 15.6419 51.024V54H14.2979ZM23.9418 54.096C22.3218 54.096 21.1098 52.908 21.1098 51.096C21.1098 49.332 22.3218 48.06 23.9298 48.06C24.6738 48.06 25.3218 48.336 25.7418 48.864L25.7658 48.852V48.144H27.1098V54H25.8258V53.232L25.8018 53.22C25.3818 53.784 24.7578 54.096 23.9418 54.096ZM24.1578 52.872C25.0698 52.872 25.8258 52.164 25.8258 51.108C25.8258 50.064 25.1178 49.272 24.1578 49.272C23.2218 49.272 22.4778 49.98 22.4778 51.108C22.4778 52.14 23.1618 52.872 24.1578 52.872ZM30.5457 54.096C29.5377 54.096 28.9137 53.46 28.9137 52.152V49.284H28.1937V48.144H28.9137V46.2L30.2577 46.056V48.144H31.9737V49.284H30.2577V52.02C30.2577 52.62 30.4377 52.836 30.8217 52.836C31.0497 52.836 31.3737 52.752 31.6857 52.584L32.0337 53.748C31.6857 53.94 31.3137 54.096 30.5457 54.096ZM35.0605 54.096C34.1125 54.096 33.3085 53.784 32.6965 53.244L33.3685 52.236C33.8365 52.692 34.3405 52.92 35.0605 52.92C35.5765 52.92 35.8765 52.692 35.8765 52.344C35.8765 52.044 35.4925 51.9 34.7245 51.636C33.7645 51.3 32.9365 50.868 32.9365 49.716C32.9365 48.756 33.8005 48.06 35.0005 48.06C35.7445 48.06 36.4165 48.264 37.0645 48.792L36.3925 49.848C35.9245 49.404 35.3845 49.224 34.9285 49.224C34.6645 49.224 34.2925 49.368 34.2925 49.728C34.2925 50.016 34.6525 50.22 35.2165 50.436C36.4645 50.928 37.2445 51.156 37.2445 52.32C37.2445 53.304 36.5485 54.096 35.0605 54.096ZM37.9791 54L41.1591 45.48H42.5751L45.7671 54H44.2551L43.6071 52.164H40.1271L39.4911 54H37.9791ZM40.5711 50.916H43.1751L41.8791 47.22H41.8551L40.5711 50.916ZM46.9229 56.376V48.144H48.2669V48.84H48.2909C48.7229 48.336 49.3709 48.06 50.1389 48.06C51.7589 48.06 52.9709 49.332 52.9709 51.096C52.9709 52.908 51.7589 54.096 50.1269 54.096C49.3349 54.096 48.7229 53.808 48.2909 53.28L48.2669 53.292V56.376H46.9229ZM49.9229 52.872C50.9069 52.872 51.6029 52.14 51.6029 51.108C51.6029 49.98 50.8469 49.272 49.9109 49.272C48.9029 49.272 48.2069 50.064 48.2069 51.108C48.2069 52.164 48.9629 52.872 49.9229 52.872ZM54.376 56.376V48.144H55.72V48.84H55.744C56.176 48.336 56.824 48.06 57.592 48.06C59.212 48.06 60.424 49.332 60.424 51.096C60.424 52.908 59.212 54.096 57.58 54.096C56.788 54.096 56.176 53.808 55.744 53.28L55.72 53.292V56.376H54.376ZM57.376 52.872C58.36 52.872 59.056 52.14 59.056 51.108C59.056 49.98 58.3 49.272 57.364 49.272C56.356 49.272 55.66 50.064 55.66 51.108C55.66 52.164 56.416 52.872 57.376 52.872Z",fill:"var(--icon-color)"})};const pr=n.p+"88a9d8b720fa47faa0f7.png",hr=n.p+"a9a94f26040d1d617ba5.png",mr=n.p+"5481ba37652e144d94d4.png",gr=n.p+"cda076c0b79d73963c46.png";function vr(e,t){var n="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(!n){if(Array.isArray(e)||(n=function(e,t){if(!e)return;if("string"==typeof e)return br(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return br(e,t)}(e))||t&&e&&"number"==typeof e.length){n&&(e=n);var r=0,a=function(){};return{s:a,n:function(){return r>=e.length?{done:!0}:{done:!1,value:e[r++]}},e:function(e){throw e},f:a}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var o,i=!0,l=!1;return{s:function(){n=n.call(e)},n:function(){var e=n.next();return i=e.done,e},e:function(e){l=!0,o=e},f:function(){try{i||null==n.return||n.return()}finally{if(l)throw o}}}}function br(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}var yr,Cr;!function(e){e.CHROME="chrome",e.EDGE="edge",e.FIREFOX="firefox",e.SAFARI="safari"}(yr||(yr={})),function(e){e.CHROME="Chrome",e.EDGE="Microsoft Edge",e.FIREFOX="Mozilla Firefox",e.SAFARI="Safari"}(Cr||(Cr={}));var kr,wr=function(e){switch(e){case Cr.CHROME:return pr;case Cr.EDGE:return hr;case Cr.SAFARI:return gr;case Cr.FIREFOX:return mr}};!function(e){e.COOKIES="cookies",e.HISTORY="history",e.FAVORITES="favorites",e.PASSWORDS="passwords",e.SEARCH_ENGINES="search_engines",e.AUTOFILL_FORM_DATA="autofill_form_data"}(kr||(kr={}));var Er=function(){var e=t(c().mark((function e(){return c().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.abrupt("return",new Promise((function(e){opr.importPrivate.detectImporters((function(t){var n=t.filter((function(e){return Object.values(Cr).includes(e.name)}));e(n)}))})));case 1:case"end":return e.stop()}}),e)})));return function(){return e.apply(this,arguments)}}(),xr="imported",Sr=function(e){return localStorage.getItem(e)===xr},Or=function(e){return new Promise((function(t){opr.importPrivate.importData(e.id,e.supportedServices,(function(){var n,r,a=null===(n=chrome.runtime.lastError)||void 0===n?void 0:n.message;a?console.error(a):(r=e.name,localStorage.setItem(r,xr),Nr()),t(!a)}))}))},Lr=function(){var e=t(c().mark((function e(){var t,n;return c().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,Er();case 2:return t=e.sent,n=function(e,n,r){var a;return{key:e,name:n,label:r,icon:wr(n),importer:null!==(a=t.find((function(e){return e.name===n})))&&void 0!==a?a:null,imported:Sr(n)}},e.abrupt("return",[n(yr.CHROME,Cr.CHROME,Se("browser.chrome")),n(yr.EDGE,Cr.EDGE,Se("browser.edge")),n(yr.SAFARI,Cr.SAFARI,Se("browser.safari")),n(yr.FIREFOX,Cr.FIREFOX,Se("browser.firefox"))]);case 5:case"end":return e.stop()}}),e)})));return function(){return e.apply(this,arguments)}}(),_r=function(){for(var e=[],t=0,n=Object.values(Cr);t<n.length;t++){var r=n[t];Sr(r)&&e.push(r)}return e},Pr=new Set,Nr=function(){var e,t=_r(),n=vr(Pr);try{for(n.s();!(e=n.n()).done;){(0,e.value)(t)}}catch(e){n.e(e)}finally{n.f()}};function Mr(e,t){return{x:5,y:132-Math.round(15*t/2)+15*e}}function Ar(e){return d.createElement("g",{id:e.id},d.createElement("rect",{x:e.x,y:e.y,width:"13",height:"13",rx:"3.25",fill:"var(--sidebar-icon-color)"}),e.icon&&d.createElement(e.icon,{x:e.x,y:e.y}))}function Ir(){return d.createElement("g",{className:"sidebar-apps"},d.createElement(Ar,ar({id:"aria-icon"},Mr(0,5),{icon:or})),d.createElement(Ar,ar({id:"chat-gpt-icon"},Mr(1,5),{icon:ir})),d.createElement(Ar,Mr(2,5)),d.createElement(Ar,Mr(3,5)),d.createElement(Ar,Mr(4,5)))}function Fr(){var e=s((0,d.useState)([]),2),t=e[0],n=e[1];(0,d.useEffect)((function(){return qn(n)}),[]);var r=function(e){switch(e){case An.Messenger:return lr;case An.WhatsApp:return sr;case An.Telegram:return ur;case An.Instagram:return dr;case An.TikTok:return cr;case An.Twitter:return fr}},a=t.filter((function(e){return e.visible})),o=a.length+2;return d.createElement("g",{className:"sidebar-apps"},d.createElement(Ar,ar({id:"aria-icon"},Mr(0,o),{icon:or})),d.createElement(Ar,ar({id:"chat-gpt-icon"},Mr(1,o),{icon:ir})),a.map((function(e,t){return e.visible&&d.createElement(Ar,ar({id:"".concat(e.id,"-icon")},Mr(t+2,o),{key:e.id,icon:r(e.id)}))})))}function Rr(e){var t=e.from,n=e.to,r=e.enabled;return d.createElement("animate",{attributeType:"CSS",attributeName:"opacity",values:r?"".concat(n,";").concat(t):"".concat(t,";").concat(n),dur:"0.15s",fill:"freeze"})}function Vr(e){return d.createElement(d.Fragment,null,d.createElement("g",{clipPath:"url(#clip0_888_40226)"},d.createElement("rect",{width:"360",height:"234",rx:"3",fill:"var(--tabs-background-color)"}),e.children),d.createElement("defs",null,d.createElement("clipPath",{id:"clip0_888_40226"},d.createElement("rect",{width:"360",height:"234",rx:"3",fill:"white"}))))}function jr(){return d.createElement("g",{className:"tabs"},d.createElement(zr,null),d.createElement(Tr,null))}function zr(){return d.createElement(d.Fragment,null,d.createElement("g",{className:"active-tab",filter:"url(#filter0_d_888_40226)"},d.createElement("rect",{x:"23",y:"2",width:"58",height:"14",rx:"3",fill:"var(--tab-background-color)",fillOpacity:"1",shapeRendering:"crispEdges"}),d.createElement("rect",{x:"25",y:"4.4",width:"2.2",height:"9.4",rx:"1.1",fill:"var(--accent-color)"}),d.createElement("g",{filter:"url(#filter1_d_888_40226)"},d.createElement("rect",{x:"29",y:"3.5",width:"50",height:"11",rx:"1.5",fill:"var(--panel-background-color)"}),d.createElement("mask",{id:"mask0_888_40226",style:{maskType:"luminance"},maskUnits:"userSpaceOnUse",x:"31",y:"6.5",width:"6",height:"5"},d.createElement("rect",{x:"31.1",y:"6.5",fill:"white",width:"2.4",height:"2.1",rx:"0.6"}),d.createElement("rect",{x:"34.2",y:"6.5",fill:"white",width:"2.4",height:"2.1",rx:"0.6"}),d.createElement("rect",{x:"31.1",y:"9.3",fill:"white",width:"2.4",height:"2.1",rx:"0.6"}),d.createElement("rect",{x:"34.2",y:"9.3",fill:"white",width:"2.4",height:"2.1",rx:"0.6"})),d.createElement("g",{mask:"url(#mask0_888_40226)"},d.createElement("rect",{x:"30.7155",y:"6.37622",width:"6.28379",height:"6.28379",fill:"var(--favicon-background-color)"})))),d.createElement("defs",null,d.createElement("filter",{id:"filter0_d_888_40226",x:"16.5769",y:"-3.83506",width:"70.6927",height:"26.706",filterUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},d.createElement("feFlood",{floodOpacity:"0",result:"BackgroundImageFix"}),d.createElement("feColorMatrix",{in:"SourceAlpha",type:"matrix",values:"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0",result:"hardAlpha"}),d.createElement("feOffset",null),d.createElement("feGaussianBlur",{stdDeviation:"3.1419"}),d.createElement("feComposite",{in2:"hardAlpha",operator:"out"}),d.createElement("feColorMatrix",{type:"matrix",values:"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.08 0"}),d.createElement("feBlend",{mode:"normal",in2:"BackgroundImageFix",result:"effect1_dropShadow_888_40226"}),d.createElement("feBlend",{mode:"normal",in:"SourceGraphic",in2:"effect1_dropShadow_888_40226",result:"shape"})),d.createElement("filter",{id:"filter1_d_888_40226",x:"26.0026",y:"1.66335",width:"56.5542",height:"17.2804",filterUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},d.createElement("feFlood",{floodOpacity:"0",result:"BackgroundImageFix"}),d.createElement("feColorMatrix",{in:"SourceAlpha",type:"matrix",values:"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0",result:"hardAlpha"}),d.createElement("feOffset",{dy:"0.785474"}),d.createElement("feGaussianBlur",{stdDeviation:"1.57095"}),d.createElement("feComposite",{in2:"hardAlpha",operator:"out"}),d.createElement("feColorMatrix",{type:"matrix",values:"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.16 0"}),d.createElement("feBlend",{mode:"normal",in2:"BackgroundImageFix",result:"effect1_dropShadow_888_40226"}),d.createElement("feBlend",{mode:"normal",in:"SourceGraphic",in2:"effect1_dropShadow_888_40226",result:"shape"}))))}function Tr(){return d.createElement(d.Fragment,null,d.createElement("g",{className:"plus-icon",clipPath:"url(#clip1_888_40226)"},d.createElement("rect",{x:"82.5568",y:"6.37622",width:"6.28379",height:"6.28379",rx:"3.1419",fill:"var(--plus-background-color)"}),d.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M85.6986 11.0889C85.9155 11.0889 86.0914 10.9131 86.0914 10.6962L86.0914 9.91074H86.8768C87.0937 9.91074 87.2696 9.7349 87.2696 9.518C87.2696 9.3011 87.0937 9.12526 86.8768 9.12526H86.0914L86.0914 8.33979C86.0914 8.12288 85.9155 7.94705 85.6986 7.94705C85.4817 7.94705 85.3059 8.12288 85.3059 8.33979L85.3059 9.12526H84.5204C84.3035 9.12526 84.1277 9.3011 84.1277 9.518C84.1277 9.7349 84.3035 9.91074 84.5204 9.91074H85.3059L85.3059 10.6962C85.3059 10.9131 85.4817 11.0889 85.6986 11.0889Z",fill:"var(--plus-icon-color)"})),d.createElement("defs",null,d.createElement("clipPath",{id:"clip1_888_40226"},d.createElement("rect",{width:"6.28379",height:"6.28379",fill:"white",transform:"translate(82.5568 6.37622)"}))))}function Hr(e){var t=e.feature,n=e.adblocker,r=e.imports,a=function(e){return r.includes(e)?wr(e):null};return d.createElement("g",{className:"address-bar"},d.createElement("rect",{x:"23",y:"18",width:"335",height:"14",rx:"3",fill:"var(--panel-background-color)"}),d.createElement("path",{d:"M31.5009 23.4572L30.0082 24.9498C29.8548 25.1032 29.8548 25.3519 30.0082 25.5052L31.5009 26.9979",stroke:"#2A343D",strokeWidth:"0.392737",strokeLinecap:"round",strokeLinejoin:"round"}),d.createElement("path",{d:"M42.4974 26.9979L43.9901 25.5052C44.1435 25.3519 44.1435 25.1032 43.9901 24.9498L42.4974 23.4572",stroke:"#BFC2C5",strokeWidth:"0.392737",strokeLinecap:"round",strokeLinejoin:"round"}),d.createElement("path",{d:"M53.4022 23.2331C52.3007 23.2331 51.4078 24.126 51.4078 25.2275C51.4078 26.3289 52.3007 27.2219 53.4022 27.2219C54.2562 27.2219 54.985 26.685 55.2692 25.9301C55.274 25.9175 55.2882 25.911 55.3009 25.9158C55.3136 25.9206 55.32 25.9347 55.3152 25.9474C55.024 26.7208 54.2773 27.2709 53.4022 27.2709C52.2736 27.2709 51.3587 26.3561 51.3587 25.2275C51.3587 24.0989 52.2736 23.184 53.4022 23.184C54.0305 23.184 54.5925 23.4676 54.9674 23.9137C55.0051 23.9586 55.0581 23.9881 55.1142 23.9975C55.172 24.0071 55.2491 23.9966 55.3092 23.9366L55.5878 23.6579C55.5934 23.6524 55.5975 23.6511 55.6002 23.6506C55.6039 23.65 55.609 23.6503 55.6146 23.6526C55.6201 23.6549 55.624 23.6583 55.6261 23.6614C55.6277 23.6636 55.6297 23.6674 55.6297 23.6753V24.5758C55.6297 24.5894 55.6187 24.6003 55.6052 24.6003H54.7047C54.6968 24.6003 54.693 24.5983 54.6908 24.5967C54.6877 24.5946 54.6843 24.5908 54.682 24.5852C54.6797 24.5796 54.6794 24.5745 54.68 24.5708C54.6805 24.5681 54.6817 24.564 54.6873 24.5584L54.9316 24.3141C54.9986 24.2472 55.0077 24.1622 54.9997 24.1023C54.9917 24.0431 54.9654 23.9877 54.9298 23.9453C54.5639 23.5098 54.0153 23.2331 53.4022 23.2331Z",fill:"#2A343D",stroke:"#2A343D",strokeWidth:"0.343645"}),t===Wa.ADBLOCKER&&n&&d.createElement(Dr,null),t===Wa.IMPORT&&d.createElement(d.Fragment,null,d.createElement(Br,{x:288,icon:a(Cr.CHROME)}),d.createElement(Br,{x:304,icon:a(Cr.EDGE)}),d.createElement(Br,{x:320,icon:a(Cr.SAFARI)}),d.createElement(Br,{x:336,icon:a(Cr.FIREFOX)})))}function Dr(){return d.createElement("g",{className:"adblocker-badge"},d.createElement("rect",{width:"7",height:"6",x:"339.5",y:"22",fill:"white",rx:"2"}),d.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M342.698 20.6531C342.901 20.6156 343.099 20.6156 343.302 20.6531C344.113 20.8029 346.319 21.2236 346.894 21.4843C347.165 21.6069 347.333 21.8617 347.333 22.143V26.3285C347.333 27.333 346.783 28.2677 345.874 28.8067L343.423 30.2599C343.165 30.4134 342.835 30.4134 342.577 30.2599L340.127 28.8067C339.217 28.2677 338.667 27.333 338.667 26.3285V22.143C338.667 21.8617 338.834 21.6069 339.106 21.4843C339.681 21.2236 341.887 20.8029 342.698 20.6531ZM345.328 23.4385C345.145 23.3476 344.914 23.4032 344.81 23.5626L342.674 26.8406L341.236 25.3573L341.196 25.3222C341.057 25.2154 340.846 25.2111 340.701 25.3191C340.541 25.4379 340.521 25.6477 340.657 25.7876L342.447 27.6328L342.485 27.6674C342.662 27.804 342.945 27.7684 343.066 27.5823L345.469 23.8919L345.492 23.8512C345.562 23.6994 345.494 23.5219 345.328 23.4385Z",fill:"var(--accent-color)"}))}function Br(e){return d.createElement("g",{className:"icon-placeholder"},!e.icon&&d.createElement("rect",{width:"10",height:"10",x:e.x,y:"20",rx:"2.8",fill:"var(--sidebar-icon-color)"}),e.icon&&d.createElement("image",{x:e.x,y:"20",width:"10",height:"10",href:e.icon}))}function Ur(e){var t=e.feature;return d.createElement(d.Fragment,null,d.createElement("g",{className:"sidebar",clipPath:"url(#clip4_888_40226)"},d.createElement("path",{d:"M13.7871 11.4285C13.7871 12.127 13.4816 12.7549 12.9998 13.1893C12.3947 13.4827 11.8307 13.2773 11.6427 13.1482C12.2361 13.0191 12.6884 12.2972 12.6884 11.4285C12.6884 10.5599 12.2361 9.83803 11.6427 9.70891C11.8307 9.57979 12.3947 9.37437 12.9998 9.66783C13.4816 10.1021 13.7871 10.7301 13.7871 11.4285Z",fill:"black"}),d.createElement("path",{d:"M10.6501 10.0962C10.3916 10.4014 10.2212 10.8592 10.2095 11.3698V11.4813C10.2212 11.9919 10.3916 12.4497 10.6501 12.7549C10.9908 13.195 11.4902 13.4709 12.0542 13.4709C12.4008 13.4709 12.7239 13.3652 13.0001 13.1833C12.5829 13.5589 12.0307 13.7819 11.4256 13.7819C11.3903 13.7819 11.3492 13.7819 11.3139 13.7819C10.0626 13.7291 9.06384 12.6962 9.06384 11.4284C9.06384 10.1255 10.1213 9.06909 11.4256 9.06909C11.4314 9.06909 11.4314 9.06909 11.4373 9.06909C12.0366 9.06909 12.5829 9.29798 13.0001 9.66773C12.7239 9.48579 12.4008 9.38015 12.0542 9.38015C11.4902 9.38015 10.9849 9.66187 10.6501 10.0962Z",fill:"black"}),d.createElement("path",{d:"M11.6142 22.9972L11.8811 23.9207C11.9372 24.115 12.0892 24.267 12.2835 24.3231L13.207 24.59C13.3962 24.6446 13.3962 24.9126 13.207 24.9673L12.2835 25.2341C12.0892 25.2902 11.9372 25.4422 11.8811 25.6365L11.6142 26.5601C11.5596 26.7492 11.2916 26.7492 11.2369 26.5601L10.9701 25.6365C10.914 25.4422 10.762 25.2902 10.5677 25.2341L9.64414 24.9673C9.45499 24.9126 9.45499 24.6446 9.64414 24.59L10.5677 24.3231C10.762 24.267 10.914 24.115 10.9701 23.9207L11.2369 22.9972C11.2916 22.808 11.5596 22.808 11.6142 22.9972Z",stroke:"white",strokeWidth:"0.392737"}),d.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M11.5557 39.8345C11.4715 39.805 11.3798 39.805 11.2956 39.8345L10.3456 40.1678C10.0865 40.2587 9.81655 40.0626 9.82294 39.7881L9.84636 38.7816C9.84844 38.6924 9.8201 38.6052 9.76601 38.5343L9.15543 37.7337C8.98894 37.5154 9.09207 37.1981 9.35507 37.1193L10.3196 36.8306C10.405 36.805 10.4792 36.7511 10.53 36.6777L11.1026 35.8496C11.2588 35.6238 11.5925 35.6238 11.7487 35.8496L12.3213 36.6777C12.3721 36.7511 12.4463 36.805 12.5317 36.8306L13.4962 37.1193C13.7592 37.1981 13.8623 37.5154 13.6959 37.7337L13.0853 38.5343C13.0312 38.6052 13.0028 38.6924 13.0049 38.7816L13.0283 39.7881C13.0347 40.0626 12.7647 40.2587 12.5057 40.1678L11.5557 39.8345Z",stroke:"#2A343D",strokeWidth:"0.392737"}),d.createElement("rect",{x:"5.14185",y:"111.507",width:"12.5676",height:"12.5676",rx:"3.1419",fill:"#E7EDF1"}),d.createElement("rect",{x:"5.14185",y:"127.216",width:"12.5676",height:"12.5676",rx:"3.1419",fill:"#E7EDF1"}),d.createElement("rect",{x:"5.14185",y:"142.926",width:"12.5676",height:"12.5676",rx:"3.1419",fill:"#E7EDF1"}),d.createElement("path",{d:"M11.426 227.698C11.6304 227.309 11.9615 227.036 12.4075 227.036C13.0506 227.036 13.5202 227.559 13.5202 228.234C13.5202 229.13 12.7348 229.916 11.4257 230.701C10.1165 229.916 9.33105 229.13 9.33105 228.234C9.33105 227.559 9.80063 227.036 10.4438 227.036C10.8899 227.036 11.2209 227.309 11.4253 227.698C11.4255 227.698 11.4259 227.698 11.426 227.698Z",stroke:"white",strokeWidth:"0.392737"}),d.createElement("g",{clipPath:"url(#clip5_888_40226)"},d.createElement("path",{d:"M13.7871 11.4285C13.7871 12.127 13.4816 12.7549 12.9998 13.1893C12.3947 13.4827 11.8307 13.2773 11.6427 13.1482C12.2361 13.0191 12.6884 12.2972 12.6884 11.4285C12.6884 10.5599 12.2361 9.83803 11.6427 9.70891C11.8307 9.57979 12.3947 9.37437 12.9998 9.66783C13.4816 10.1021 13.7871 10.7301 13.7871 11.4285Z",fill:"black"}),d.createElement("path",{d:"M10.6501 10.0962C10.3916 10.4014 10.2212 10.8592 10.2095 11.3698V11.4813C10.2212 11.9919 10.3916 12.4497 10.6501 12.7549C10.9908 13.195 11.4902 13.4709 12.0542 13.4709C12.4008 13.4709 12.7239 13.3652 13.0001 13.1833C12.5829 13.5589 12.0307 13.7819 11.4256 13.7819C11.3903 13.7819 11.3492 13.7819 11.3139 13.7819C10.0626 13.7291 9.06384 12.6962 9.06384 11.4284C9.06384 10.1255 10.1213 9.06909 11.4256 9.06909C11.4314 9.06909 11.4314 9.06909 11.4373 9.06909C12.0366 9.06909 12.5829 9.29798 13.0001 9.66773C12.7239 9.48579 12.4008 9.38015 12.0542 9.38015C11.4902 9.38015 10.9849 9.66187 10.6501 10.0962Z",fill:"black"}),d.createElement("rect",{x:"5.14185",y:"18.4949",width:"12.5676",height:"12.5676",rx:"3.1419",fill:"var(--accent-color)"}),d.createElement("path",{d:"M11.6142 22.9972L11.8811 23.9207C11.9372 24.115 12.0892 24.267 12.2835 24.3231L13.207 24.59C13.3962 24.6446 13.3962 24.9126 13.207 24.9673L12.2835 25.2341C12.0892 25.2902 11.9372 25.4422 11.8811 25.6365L11.6142 26.5601C11.5596 26.7492 11.2916 26.7492 11.2369 26.5601L10.9701 25.6365C10.914 25.4422 10.762 25.2902 10.5677 25.2341L9.64414 24.9673C9.45499 24.9126 9.45499 24.6446 9.64414 24.59L10.5677 24.3231C10.762 24.267 10.914 24.115 10.9701 23.9207L11.2369 22.9972C11.2916 22.808 11.5596 22.808 11.6142 22.9972Z",stroke:"white",strokeWidth:"0.392737"}),d.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M11.5557 39.8345C11.4715 39.805 11.3798 39.805 11.2956 39.8345L10.3456 40.1678C10.0865 40.2587 9.81655 40.0626 9.82294 39.7881L9.84636 38.7816C9.84844 38.6924 9.8201 38.6052 9.76601 38.5343L9.15543 37.7337C8.98894 37.5154 9.09207 37.1981 9.35507 37.1193L10.3196 36.8306C10.405 36.805 10.4792 36.7511 10.53 36.6777L11.1026 35.8496C11.2588 35.6238 11.5925 35.6238 11.7487 35.8496L12.3213 36.6777C12.3721 36.7511 12.4463 36.805 12.5317 36.8306L13.4962 37.1193C13.7592 37.1981 13.8623 37.5154 13.6959 37.7337L13.0853 38.5343C13.0312 38.6052 13.0028 38.6924 13.0049 38.7816L13.0283 39.7881C13.0347 40.0626 12.7647 40.2587 12.5057 40.1678L11.5557 39.8345Z",stroke:"#2A343D",strokeWidth:"0.392737"}),d.createElement("rect",{x:"4.92566",y:"79.8096",width:"13.0001",height:"13.0001",rx:"3.25001",fill:"#BBCBD7",fillOpacity:"0.6"}),d.createElement("g",{clipPath:"url(#clip6_888_40226)"},d.createElement("rect",{x:"7.92566",y:"82.8096",width:"7.00003",height:"7.00003",rx:"1.75529",fill:"black"}),d.createElement("g",{filter:"url(#filter20_f_888_40226)"},d.createElement("path",{d:"M6.55738 89.591C6.14527 89.1864 6.19573 88.2929 6.09481 86.7926C5.98547 85.3007 5.71634 83.2103 6.46486 82.6034C7.21338 82.0049 8.97956 82.89 9.77854 83.9773C10.5775 85.0562 10.4009 86.3374 10.2663 87.1972C10.1318 88.0569 10.0309 88.4868 9.78695 88.8577C9.53464 89.2285 9.13935 89.5236 8.49176 89.7174C7.85257 89.9113 6.96948 89.9956 6.55738 89.591Z",fill:"#82F8FF"})),d.createElement("g",{filter:"url(#filter21_f_888_40226)"},d.createElement("path",{d:"M18.1372 93.8788C17.1297 94.7556 15.8319 95.5931 15.1144 95.1318C14.3968 94.6705 14.244 92.9034 13.4342 91.6671C12.6206 90.4392 11.1424 89.7385 10.7675 88.6563C10.3811 87.579 11.0945 86.1285 12.1177 84.7361C13.141 83.3437 14.4627 82.0142 16.0252 81.5865C17.5841 81.1671 19.3797 81.6376 20.1008 82.8846C20.8257 84.1231 20.4681 86.1346 20.3778 87.6524C20.2797 89.1666 20.4374 90.192 20.1575 91.1526C19.8776 92.1132 19.1487 93.0139 18.1372 93.8788Z",fill:"#4865FF"})),d.createElement("g",{filter:"url(#filter22_f_888_40226)"},d.createElement("path",{d:"M12.2744 89.2262C12.4456 89.5984 12.1468 90.086 11.7303 90.1643C11.316 90.2412 10.7827 89.9064 10.4365 89.6851C10.089 89.4614 9.92761 89.3549 9.83485 89.2213C9.74209 89.0876 9.71791 88.9269 9.53483 88.68C9.35543 88.4341 9.01812 88.0985 9.02741 87.8498C9.03435 87.6024 9.39022 87.4406 9.73109 87.3717C10.0743 87.3015 10.4025 87.3242 10.5826 87.501C10.7637 87.6741 10.7957 88.0051 11.1304 88.2985C11.4666 88.5943 12.1041 88.8502 12.2744 89.2262Z",fill:"#9712FF"})),d.createElement("g",{filter:"url(#filter23_f_888_40226)"},d.createElement("path",{d:"M13.0319 82.4842C13.7153 82.8539 14.4427 83.7746 14.3792 84.6046C14.3206 85.4416 13.4712 86.1879 12.7878 86.2926C12.0994 86.3972 11.5771 85.8671 11.2354 85.609C10.8937 85.3509 10.7326 85.3719 10.0735 85.2672C9.41936 85.1556 8.27215 84.9255 7.78885 84.0048C7.30556 83.0771 7.4813 81.4658 8.14034 81.0962C8.7945 80.7195 9.92218 81.5984 10.8107 81.9471C11.6991 82.2959 12.3435 82.1145 13.0319 82.4842Z",fill:"#FF8051"})),d.createElement("path",{d:"M11.9742 85.1617L11.6135 84.5407C11.5398 84.4138 11.3565 84.4137 11.2826 84.5406L9.73707 87.1971C9.70237 87.2568 9.70247 87.3305 9.73734 87.39L10.0975 88.005C10.1714 88.1314 10.3541 88.1312 10.4279 88.0048L11.974 85.3542C12.0087 85.2947 12.0088 85.2212 11.9742 85.1617Z",fill:"white"}),d.createElement("path",{d:"M11.847 86.2811H11.7789C11.6317 86.2811 11.5396 86.4403 11.613 86.5678L12.4376 88.0025C12.5108 88.1297 12.6939 88.1306 12.7684 88.0042L13.1344 87.3826C13.1696 87.3228 13.1697 87.2485 13.1345 87.1887L12.9836 86.9317C12.7469 86.5287 12.3144 86.2811 11.847 86.2811Z",fill:"white"})),d.createElement("rect",{x:"4.92566",y:"94.8096",width:"13.0001",height:"13.0001",rx:"3.25001",fill:"#BBCBD7",fillOpacity:"0.6"}),d.createElement("rect",{x:"7.84998",y:"97.7339",width:"7.15139",height:"7.15139",rx:"1.78785",fill:"#24A381"}),d.createElement("path",{d:"M11.173 98.9258C10.6444 98.9258 10.1747 99.2616 10.011 99.7573C9.84305 99.7914 9.68436 99.8605 9.54554 99.9599C9.40671 100.059 9.29093 100.187 9.2059 100.334C8.94078 100.786 9.00132 101.354 9.35649 101.741C9.24684 102.066 9.28447 102.421 9.45959 102.715C9.72308 103.169 10.2533 103.401 10.7721 103.293C10.8856 103.419 11.0253 103.521 11.1816 103.59C11.3379 103.659 11.5074 103.694 11.6787 103.693C12.2073 103.693 12.6769 103.358 12.8406 102.862C13.181 102.792 13.4739 102.583 13.6441 102.286C13.9109 101.833 13.8503 101.265 13.4952 100.878V100.876C13.5494 100.716 13.5682 100.546 13.5504 100.378C13.5327 100.209 13.4787 100.047 13.3921 99.901C13.1286 99.4489 12.5983 99.2164 12.0812 99.3245C11.9671 99.1984 11.8271 99.0976 11.6705 99.0289C11.514 98.9601 11.3444 98.925 11.173 98.9258ZM11.173 99.2358L11.1714 99.2374C11.3841 99.2374 11.5887 99.3101 11.7523 99.4441C11.7458 99.4473 11.7327 99.4554 11.7229 99.4602L10.7606 100.008C10.7115 100.035 10.6821 100.087 10.6821 100.143V101.428L10.268 101.193V100.13C10.2679 99.8933 10.3632 99.666 10.5329 99.4982C10.7026 99.3305 10.9328 99.2362 11.173 99.2358ZM12.3321 99.6099C12.4916 99.6096 12.6483 99.6509 12.7864 99.7295C12.9246 99.8081 13.0392 99.9213 13.1188 100.058C13.2235 100.238 13.2628 100.45 13.2267 100.655C13.2202 100.65 13.2071 100.644 13.1989 100.639L12.2367 100.09C12.2125 100.076 12.1851 100.069 12.1573 100.069C12.1295 100.069 12.1022 100.076 12.078 100.09L10.9504 100.732V100.261L11.8816 99.7298C12.0185 99.6515 12.1739 99.6101 12.3321 99.6099V99.6099ZM9.95219 100.098V101.226C9.95219 101.283 9.98164 101.333 10.0308 101.362L11.1566 102.003L10.7409 102.24L9.81139 101.711C9.60367 101.592 9.45219 101.397 9.39023 101.168C9.32826 100.939 9.36086 100.695 9.48087 100.49C9.58674 100.309 9.75348 100.17 9.95219 100.098ZM12.1091 100.377L13.0402 100.907C13.4739 101.154 13.6211 101.7 13.3707 102.127L13.3724 102.129C13.266 102.31 13.0991 102.449 12.901 102.52V101.391C12.901 101.335 12.8716 101.283 12.8225 101.256L11.695 100.613L12.1091 100.377ZM11.425 100.766L11.8996 101.038V101.578L11.425 101.85L10.9504 101.578V101.038L11.425 100.766ZM12.1712 101.193L12.5852 101.428V102.489C12.5852 102.983 12.1794 103.383 11.6803 103.383V103.382C11.4692 103.382 11.263 103.309 11.101 103.175C11.1075 103.172 11.1222 103.164 11.1304 103.159L12.0926 102.612C12.1418 102.584 12.1728 102.533 12.1712 102.476L12.1712 101.193ZM11.9012 101.887V102.358L10.97 102.888C10.5363 103.133 9.98321 102.988 9.73282 102.562H9.73445C9.6281 102.382 9.59041 102.169 9.62642 101.964C9.63297 101.969 9.64607 101.976 9.65425 101.98L10.6165 102.529C10.6407 102.543 10.668 102.55 10.6958 102.55C10.7236 102.55 10.751 102.543 10.7752 102.529L11.9012 101.887Z",fill:"white"}),d.createElement("rect",{x:"5.14185",y:"143.204",width:"12.5676",height:"12.5676",rx:"3.1419",fill:"#E7EDF1"}),d.createElement("rect",{x:"5.14185",y:"158.913",width:"12.5676",height:"12.5676",rx:"3.1419",fill:"#E7EDF1"}),d.createElement("rect",{x:"5.14185",y:"174.623",width:"12.5676",height:"12.5676",rx:"3.1419",fill:"#E7EDF1"}),d.createElement("path",{d:"M11.426 227.698C11.6304 227.309 11.9615 227.036 12.4075 227.036C13.0506 227.036 13.5202 227.559 13.5202 228.234C13.5202 229.13 12.7348 229.916 11.4257 230.701C10.1165 229.916 9.33105 229.13 9.33105 228.234C9.33105 227.559 9.80063 227.036 10.4438 227.036C10.8899 227.036 11.2209 227.309 11.4253 227.698C11.4255 227.698 11.4259 227.698 11.426 227.698Z",stroke:"white",strokeWidth:"0.392737"}),d.createElement("g",{clipPath:"url(#clip7_888_40226)"},d.createElement("rect",{x:"2",y:"2",width:"19",height:"230",rx:"3",fill:"var(--panel-background-color)"}),d.createElement("path",{d:"M13.8614 11.4285C13.8614 12.127 13.5559 12.7549 13.0742 13.1893C12.469 13.4827 11.905 13.2773 11.717 13.1482C12.3104 13.0191 12.7628 12.2972 12.7628 11.4285C12.7628 10.5599 12.3104 9.83803 11.717 9.70891C11.905 9.57979 12.469 9.37437 13.0742 9.66783C13.5559 10.1021 13.8614 10.7301 13.8614 11.4285Z",fill:"var(--icon-color)"}),d.createElement("path",{d:"M10.7244 10.0962C10.4659 10.4014 10.2955 10.8592 10.2838 11.3698V11.4813C10.2955 11.9919 10.4659 12.4497 10.7244 12.7549C11.0652 13.195 11.5645 13.4709 12.1285 13.4709C12.4752 13.4709 12.7983 13.3652 13.0744 13.1833C12.6573 13.5589 12.105 13.7819 11.4999 13.7819C11.4647 13.7819 11.4235 13.7819 11.3883 13.7819C10.1369 13.7291 9.13818 12.6962 9.13818 11.4284C9.13818 10.1255 10.1957 9.06909 11.4999 9.06909C11.5058 9.06909 11.5058 9.06909 11.5117 9.06909C12.1109 9.06909 12.6573 9.29798 13.0744 9.66773C12.7983 9.48579 12.4752 9.38015 12.1285 9.38015C11.5645 9.38015 11.0593 9.66187 10.7244 10.0962Z",fill:"var(--icon-color)"}),d.createElement("rect",{x:"5.21619",y:"18.4949",width:"12.5676",height:"12.5676",rx:"3.1419",fill:"var(--accent-color)"}),d.createElement("path",{d:"M11.6886 22.9972L11.9554 23.9207C12.0116 24.115 12.1635 24.267 12.3578 24.3231L13.2814 24.59C13.4705 24.6446 13.4705 24.9126 13.2814 24.9673L12.3578 25.2341C12.1635 25.2902 12.0116 25.4422 11.9554 25.6365L11.6886 26.5601C11.6339 26.7492 11.3659 26.7492 11.3113 26.5601L11.0445 25.6365C10.9883 25.4422 10.8364 25.2902 10.642 25.2341L9.71848 24.9673C9.52933 24.9126 9.52933 24.6446 9.71848 24.59L10.642 24.3231C10.8364 24.267 10.9883 24.115 11.0445 23.9207L11.3113 22.9972C11.3659 22.808 11.6339 22.808 11.6886 22.9972Z",stroke:"white",strokeWidth:"0.392737"}),d.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M11.63 39.8345C11.5458 39.805 11.4541 39.805 11.37 39.8345L10.4199 40.1678C10.1609 40.2587 9.89089 40.0626 9.89728 39.7881L9.92071 38.7816C9.92278 38.6924 9.89444 38.6052 9.84035 38.5343L9.22977 37.7337C9.06328 37.5154 9.16641 37.1981 9.42941 37.1193L10.3939 36.8306C10.4794 36.805 10.5536 36.7511 10.6043 36.6777L11.177 35.8496C11.3331 35.6238 11.6668 35.6238 11.823 35.8496L12.3957 36.6777C12.4464 36.7511 12.5206 36.805 12.606 36.8306L13.5706 37.1193C13.8336 37.1981 13.9367 37.5154 13.7702 37.7337L13.1596 38.5343C13.1055 38.6052 13.0772 38.6924 13.0793 38.7816L13.1027 39.7881C13.1091 40.0626 12.8391 40.2587 12.58 40.1678L11.63 39.8345Z",stroke:"var(--icon-color)",strokeWidth:"0.392737"}),![Wa.MESSENGERS,Wa.NONE].includes(t)&&d.createElement(Ir,null),t===Wa.MESSENGERS&&d.createElement(Fr,null),d.createElement("g",{className:"sidebar-pages"},t===Wa.NONE&&d.createElement(d.Fragment,null,d.createElement("path",{d:"M11.5003 180.529C11.7048 180.141 12.0358 179.867 12.4818 179.867C13.1249 179.867 13.5946 180.391 13.5946 181.066C13.5946 181.962 12.8091 182.747 11.5 183.532C10.1909 182.747 9.4054 181.962 9.4054 181.066C9.4054 180.391 9.87497 179.867 10.5182 179.867C10.9642 179.867 11.2952 180.141 11.4996 180.529C11.4998 180.529 11.5002 180.529 11.5003 180.529Z",stroke:"var(--icon-color)",strokeWidth:"0.392737"}),d.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M9.07812 195.053C9.07812 193.715 10.1624 192.631 11.5 192.631C12.8376 192.631 13.9219 193.715 13.9219 195.053C13.9219 196.39 12.8376 197.475 11.5 197.475C10.1624 197.475 9.07812 196.39 9.07812 195.053ZM11.5 193.024C10.3793 193.024 9.47086 193.932 9.47086 195.053C9.47086 196.173 10.3793 197.082 11.5 197.082C12.6207 197.082 13.5291 196.173 13.5291 195.053C13.5291 193.932 12.6207 193.024 11.5 193.024Z",fill:"var(--icon-color)"}),d.createElement("path",{d:"M11.3036 193.94C11.3036 193.831 11.3915 193.744 11.5 193.744V193.744C11.6084 193.744 11.6963 193.831 11.6963 193.94V194.809C11.6963 194.913 11.7377 195.013 11.8114 195.086L12.4257 195.701C12.5023 195.777 12.5023 195.902 12.4257 195.978V195.978C12.349 196.055 12.2246 196.055 12.148 195.978L11.4186 195.249C11.345 195.175 11.3036 195.075 11.3036 194.971V173.94Z",fill:"var(--icon-color)"})),d.createElement("g",{clipPath:"url(#clip8_888_40226)"},d.createElement("circle",{cx:"9.3",cy:"208.4",r:"0.5",fill:"var(--icon-color)",fillOpacity:"0.9"}),d.createElement("circle",{cx:"11.5",cy:"208.4",r:"0.5",fill:"var(--icon-color)",fillOpacity:"0.9"}),d.createElement("circle",{cx:"13.7",cy:"208.4",r:"0.5",fill:"var(--icon-color)",fillOpacity:"0.9"})))))),d.createElement("defs",null,d.createElement("clipPath",{id:"clip4_888_40226"},d.createElement("rect",{width:"19",height:"263",fill:"white",transform:"translate(2 2)"})),d.createElement("clipPath",{id:"clip5_888_40226"},d.createElement("rect",{width:"19",height:"263",fill:"white",transform:"translate(2 2)"})),d.createElement("clipPath",{id:"clip6_888_40226"},d.createElement("rect",{x:"7.92566",y:"82.8096",width:"7.00003",height:"7.00003",rx:"1.75529",fill:"white"})),d.createElement("clipPath",{id:"clip7_888_40226"},d.createElement("rect",{width:"19",height:"263",fill:"white",transform:"translate(2 2)"})),d.createElement("clipPath",{id:"clip8_888_40226"},d.createElement("rect",{width:"6.28379",height:"6.28379",fill:"white",transform:"translate(8.35803 205.264)"})),d.createElement("filter",{id:"filter20_f_888_40226",x:"3.08997",y:"79.5431",width:"10.16",height:"13.2029",filterUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},d.createElement("feFlood",{floodOpacity:"0",result:"BackgroundImageFix"}),d.createElement("feBlend",{mode:"normal",in:"SourceGraphic",in2:"BackgroundImageFix",result:"shape"}),d.createElement("feGaussianBlur",{stdDeviation:"1.43353",result:"effect1_foregroundBlur_888_40226"})),d.createElement("filter",{id:"filter21_f_888_40226",x:"7.79395",y:"78.5697",width:"15.6188",height:"19.5603",filterUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},d.createElement("feFlood",{floodOpacity:"0",result:"BackgroundImageFix"}),d.createElement("feBlend",{mode:"normal",in:"SourceGraphic",in2:"BackgroundImageFix",result:"shape"}),d.createElement("feGaussianBlur",{stdDeviation:"1.43353",result:"effect1_foregroundBlur_888_40226"})),d.createElement("filter",{id:"filter22_f_888_40226",x:"6.16016",y:"84.4677",width:"9.0305",height:"8.57493",filterUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},d.createElement("feFlood",{floodOpacity:"0",result:"BackgroundImageFix"}),d.createElement("feBlend",{mode:"normal",in:"SourceGraphic",in2:"BackgroundImageFix",result:"shape"}),d.createElement("feGaussianBlur",{stdDeviation:"1.43353",result:"effect1_foregroundBlur_888_40226"})),d.createElement("filter",{id:"filter23_f_888_40226",x:"4.64661",y:"78.1371",width:"12.6035",height:"11.0361",filterUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},d.createElement("feFlood",{floodOpacity:"0",result:"BackgroundImageFix"}),d.createElement("feBlend",{mode:"normal",in:"SourceGraphic",in2:"BackgroundImageFix",result:"shape"}),d.createElement("feGaussianBlur",{stdDeviation:"1.43353",result:"effect1_foregroundBlur_888_40226"}))))}function Zr(e){var t=e.feature,n=e.wallpaper,r=e.adblocker;return d.createElement(d.Fragment,null,d.createElement("g",{className:"start-page",clipPath:"url(#clip2_888_40226)"},d.createElement("g",{clipPath:"url(#clip3_888_40226)"},d.createElement("rect",{x:"23",y:"32",width:"335",height:"200",rx:"3",fill:"var(--start-page-background-color)"}),t===Wa.WALLPAPER&&n&&d.createElement("image",{x:"23",y:"32",width:"335",height:"200",href:n}),t!==Wa.ADBLOCKER&&d.createElement(Wr,null),t!==Wa.ADBLOCKER&&d.createElement(Gr,null),t===Wa.ADBLOCKER&&d.createElement(Kr,{adblocker:r}))),d.createElement("defs",null,d.createElement("clipPath",{id:"clip2_888_40226"},d.createElement("rect",{x:"22.8607",y:"33.8677",width:"479.139",height:"292.196",rx:"3.1419",fill:"white"})),d.createElement("clipPath",{id:"clip3_888_40226"},d.createElement("rect",{x:"23",y:"32",width:"335",height:"200",rx:"3",fill:"white"}))))}function Wr(){return d.createElement(d.Fragment,null,d.createElement("g",{filter:"url(#filter2_bd_888_40226)",id:"search-box-preview"},d.createElement("rect",{x:"99.8601",y:"62",width:"184.168",height:"20.4277",rx:"10.2138",fill:"var(--tile-background-color)",shapeRendering:"crispEdges"}),d.createElement("circle",{cx:"273.814",cy:"72.2138",r:"7.66038",fill:"var(--accent-color)"}),d.createElement("circle",{cx:"273.655",cy:"72.0543",r:"1.43632",stroke:"white",strokeWidth:"0.638365"}),d.createElement("rect",{x:"274.679",y:"73.3035",width:"0.319182",height:"1.60407",rx:"0.159591",transform:"rotate(-45 274.679 73.3035)",fill:"black",stroke:"white",strokeWidth:"0.319182"})),d.createElement("defs",null,d.createElement("filter",{id:"filter2_bd_888_40226",x:"79.4324",y:"41.5723",width:"225.024",height:"61.2831",filterUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},d.createElement("feFlood",{floodOpacity:"0",result:"BackgroundImageFix"}),d.createElement("feGaussianBlur",{in:"BackgroundImageFix",stdDeviation:"10.2138"}),d.createElement("feComposite",{in2:"SourceAlpha",operator:"in",result:"effect1_backgroundBlur_888_40226"}),d.createElement("feColorMatrix",{in:"SourceAlpha",type:"matrix",values:"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0",result:"hardAlpha"}),d.createElement("feOffset",{dy:"2.55346"}),d.createElement("feGaussianBlur",{stdDeviation:"6.38365"}),d.createElement("feComposite",{in2:"hardAlpha",operator:"out"}),d.createElement("feColorMatrix",{type:"matrix",values:"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.09 0"}),d.createElement("feBlend",{mode:"normal",in2:"effect1_backgroundBlur_888_40226",result:"effect2_dropShadow_888_40226"}),d.createElement("feBlend",{mode:"normal",in:"SourceGraphic",in2:"effect2_dropShadow_888_40226",result:"shape"}))))}function Gr(){return d.createElement("g",{id:"speed-dial-preview"},d.createElement("rect",{x:"90",y:"108.012",width:"45.9623",height:"28.0881",rx:"6.38365",fill:"var(--tile-background-color)",fillOpacity:"1"}),d.createElement("rect",{x:"142.346",y:"108.012",width:"45.9623",height:"28.0881",rx:"6.38365",fill:"var(--tile-background-color)",fillOpacity:"1"}),d.createElement("rect",{x:"194.692",y:"108.012",width:"45.9623",height:"28.0881",rx:"6.38365",fill:"var(--tile-background-color)",fillOpacity:"1"}),d.createElement("rect",{x:"247.038",y:"108.012",width:"45.9623",height:"28.0881",rx:"6.38365",fill:"var(--tile-background-color)",fillOpacity:"1"}),d.createElement("rect",{x:"90",y:"142.484",width:"45.9623",height:"28.0881",rx:"6.38365",fill:"var(--tile-background-color)",fillOpacity:"1"}),d.createElement("rect",{x:"142.346",y:"142.484",width:"45.9623",height:"28.0881",rx:"6.38365",fill:"var(--tile-background-color)",fillOpacity:"1"}),d.createElement("rect",{x:"194.692",y:"142.484",width:"45.9623",height:"28.0881",rx:"6.38365",fill:"var(--tile-background-color)",fillOpacity:"1"}),d.createElement("rect",{x:"247.038",y:"142.484",width:"45.9623",height:"28.0881",rx:"6.38365",fill:"var(--tile-background-color)",fillOpacity:"1"}))}function Kr(e){var t=e.adblocker;return d.createElement("g",{id:"adblocker-preview"},d.createElement("g",{className:"section"},d.createElement("rect",{width:"212",height:"36",fill:"white",x:"85",y:"57",rx:"11"},d.createElement("animate",{attributeName:"y",values:t?"57;70":"70;57",dur:"0.25s",fill:"freeze"}))),d.createElement("g",{className:"section"},d.createElement("rect",{width:"212",height:"80",fill:"white ",x:"85",y:"118",rx:"11"},d.createElement("animate",{attributeName:"x",values:t?"125;85":"85;125",dur:"0.25s",fill:"freeze"}),d.createElement("animate",{attributeName:"y",values:t?"131;118":"118;131",dur:"0.25s",fill:"freeze"}),d.createElement("animate",{attributeName:"width",values:t?"172;212":"212;172",dur:"0.25s",fill:"freeze"}))),d.createElement("g",{className:"banner"},d.createElement("g",{opacity:"0.5"},d.createElement("path",{d:"M49 69C49 63.3431 49 60.5147 50.7574 58.7574C52.5147 57 55.3431 57 61 57H67C72.6569 57 75.4853 57 77.2426 58.7574C79 60.5147 79 63.3431 79 69V159C79 164.657 79 167.485 77.2426 169.243C75.4853 171 72.6569 171 67 171H61C55.3431 171 52.5147 171 50.7574 169.243C49 167.485 49 164.657 49 159V69Z",fill:"var(--banner-background-color)"})),d.createElement("path",{d:"M69.1619 67.8284L74.8187 62.1715",stroke:"white",strokeWidth:"1.2"}),d.createElement("path",{d:"M74.8187 67.8284L69.1619 62.1715",stroke:"white",strokeWidth:"1.2"}),d.createElement(Rr,{from:0,to:1,enabled:t})),d.createElement("g",{className:"banner"},d.createElement("g",{opacity:"0.5"},d.createElement("path",{d:"M49 199C49 204.657 49 207.485 50.7574 209.243C52.5147 211 55.3431 211 61 211H67C72.6569 211 75.4853 211 77.2426 209.243C79 207.485 79 204.657 79 199V189C79 183.343 79 180.515 77.2426 178.757C75.4853 177 72.6569 177 67 177H61C55.3431 177 52.5147 177 50.7574 178.757C49 180.515 49 183.343 49 189V199Z",fill:"var(--banner-background-color)"})),d.createElement("path",{d:"M69.1617 187.828L74.8186 182.172",stroke:"white",strokeWidth:"1.2"}),d.createElement("path",{d:"M74.8187 187.828L69.1619 182.172",stroke:"white",strokeWidth:"1.2"}),d.createElement(Rr,{from:0,to:1,enabled:t})),d.createElement("g",{className:"banner"},d.createElement("g",{opacity:"0.5"},d.createElement("path",{d:"M303 68.5C303 63.3278 303 60.7418 304.489 59.0439C304.662 58.847 304.847 58.6616 305.044 58.489C306.742 57 309.328 57 314.5 57H321.5C326.672 57 329.258 57 330.956 58.489C331.153 58.6616 331.338 58.847 331.511 59.0439C333 60.7418 333 63.3278 333 68.5V68.5C333 73.6722 333 76.2582 331.511 77.9561C331.338 78.153 331.153 78.3384 330.956 78.511C329.258 80 326.672 80 321.5 80H314.5C309.328 80 306.742 80 305.044 78.511C304.847 78.3384 304.662 78.153 304.489 77.9561C303 76.2582 303 73.6722 303 68.5V68.5Z",fill:"var(--banner-background-color)"})),d.createElement("path",{d:"M323.162 67.8284L328.819 62.1715",stroke:"white",strokeWidth:"1.2"}),d.createElement("path",{d:"M328.819 67.8284L323.162 62.1715",stroke:"white",strokeWidth:"1.2"}),d.createElement(Rr,{from:0,to:1,enabled:t})),d.createElement("g",{className:"banner"},d.createElement("g",{opacity:"0.5"},d.createElement("path",{d:"M303 98C303 92.3431 303 89.5147 304.757 87.7574C306.515 86 309.343 86 315 86H321C326.657 86 329.485 86 331.243 87.7574C333 89.5147 333 92.3431 333 98V113C333 118.657 333 121.485 331.243 123.243C329.485 125 326.657 125 321 125H315C309.343 125 306.515 125 304.757 123.243C303 121.485 303 118.657 303 113V98Z",fill:"var(--banner-background-color)"})),d.createElement("path",{d:"M323.162 96.8284L328.819 91.1715",stroke:"white",strokeWidth:"1.2"}),d.createElement("path",{d:"M328.819 96.8284L323.162 91.1715",stroke:"white",strokeWidth:"1.2"}),d.createElement(Rr,{from:0,to:1,enabled:t})),d.createElement("g",{className:"banner"},d.createElement("g",{opacity:"0.5"},d.createElement("path",{d:"M303 143C303 137.343 303 134.515 304.757 132.757C306.515 131 309.343 131 315 131H321C326.657 131 329.485 131 331.243 132.757C333 134.515 333 137.343 333 143V199C333 204.657 333 207.485 331.243 209.243C329.485 211 326.657 211 321 211H315C309.343 211 306.515 211 304.757 209.243C303 207.485 303 204.657 303 199V143Z",fill:"var(--banner-background-color)"})),d.createElement("path",{d:"M323.162 141.828L328.819 136.172",stroke:"white",strokeWidth:"1.2"}),d.createElement("path",{d:"M328.819 141.828L323.162 136.172",stroke:"white",strokeWidth:"1.2"}),d.createElement(Rr,{from:0,to:1,enabled:t})),d.createElement("g",{className:"banner"},d.createElement("g",{opacity:"0.5"},d.createElement("path",{d:"M85 143C85 137.343 85 134.515 86.7574 132.757C88.5147 131 91.3431 131 97 131H107C112.657 131 115.485 131 117.243 132.757C119 134.515 119 137.343 119 143V199C119 204.657 119 207.485 117.243 209.243C115.485 211 112.657 211 107 211H97C91.3431 211 88.5147 211 86.7574 209.243C85 207.485 85 204.657 85 199V143Z",fill:"var(--banner-background-color)"})),d.createElement("path",{d:"M109.162 141.828L114.819 136.172",stroke:"white",strokeWidth:"1.2"}),d.createElement("path",{d:"M114.819 141.828L109.162 136.172",stroke:"white",strokeWidth:"1.2"}),d.createElement(Rr,{from:0,to:1,enabled:t})),d.createElement("g",{className:"banner"},d.createElement("g",{opacity:"0.5"},d.createElement("path",{d:"M85 111C85 105.343 85 102.515 86.7574 100.757C88.5147 99 91.3431 99 97 99H285C290.657 99 293.485 99 295.243 100.757C297 102.515 297 105.343 297 111V113C297 118.657 297 121.485 295.243 123.243C293.485 125 290.657 125 285 125H97C91.3431 125 88.5147 125 86.7574 123.243C85 121.485 85 118.657 85 113V111Z",fill:"var(--banner-background-color)"})),d.createElement("path",{d:"M287.162 109.828L292.819 104.172",stroke:"white",strokeWidth:"1.2"}),d.createElement("path",{d:"M292.819 109.828L287.162 104.172",stroke:"white",strokeWidth:"1.2"}),d.createElement(Rr,{from:0,to:1,enabled:t})))}function $r(e){var t=e.config,n=t.feature,r=t.wallpaper,a=void 0===r?null:r,o=t.adblocker,i=void 0!==o&&o,l=t.imports,s=void 0===l?[]:l,u=t.width,c=void 0===u?360:u,f=t.height,p=void 0===f?234:f;return d.createElement("div",{className:"preview",style:{width:"".concat(c,"px"),height:"".concat(p,"px")}},d.createElement("svg",{key:i?"with-adblocker":"no-adblocker",width:c,height:p,viewBox:"0 0 360 234",fill:"none",xmlns:"http://www.w3.org/2000/svg"},d.createElement(Vr,null,d.createElement(jr,null),d.createElement(Hr,{feature:n,adblocker:i,imports:s}),d.createElement(Ur,{feature:n}),d.createElement(Zr,{feature:n,wallpaper:a,adblocker:i}))),e.children)}function Jr(e){switch(e){case dn.LIGHT:return"light";case dn.DARK:return"dark";case dn.SYSTEM:return"system"}}function Qr(e){return d.createElement("span",{className:Sn([{selected:e.selected},Jr(e.theme),"theme"]),onClick:function(){Cn(e.theme),pn(un.CLICK,ln.THEME,"".concat(Jr(e.theme),"_button"))}},e.children)}function qr(){var e=s((0,d.useState)(null),2),t=e[0],n=e[1];return(0,d.useEffect)((function(){return kn(n)}),[]),d.createElement(xn,null,d.createElement(Qr,{theme:dn.LIGHT,selected:t===dn.LIGHT},Se("themes.light")),d.createElement(Qr,{theme:dn.DARK,selected:t===dn.DARK},Se("themes.dark")),d.createElement(Qr,{theme:dn.SYSTEM,selected:t===dn.SYSTEM},Se("themes.system")))}window.addEventListener("storage",Nr);var Yr=function(){return Math.max(window.innerWidth,1e3)},Xr=function(){return Math.max(window.innerHeight,440)},ea=function(e){var t=Yr()/2,n=Xr()/2,r=1.5*e,a=t-e,o=t-e/2,i=t,l=t+e/2,s=t+e,u=n-r/2-e,c=n-r/2-e/2,d=n-r/2,f=n+r/2,p=n+r/2+e/2,h=n+r/2+e;return"path('M".concat(i,",").concat(u," C").concat(l,",").concat(u," ").concat(s,",").concat(c," ").concat(s,",").concat(d," L").concat(s,",").concat(f," C").concat(s,",").concat(p," ").concat(l,",").concat(h," ").concat(i,",").concat(h," C").concat(o,",").concat(h," ").concat(a,",").concat(p," ").concat(a,",").concat(f," L").concat(a,",").concat(d," C").concat(a,",").concat(c," ").concat(o,",").concat(u," ").concat(i,",").concat(u,"')")};function ta(e){var t=s(d.useState(Yr()),2),n=t[0],r=t[1],a=s(d.useState(Xr()),2),o=a[0],i=a[1],l=(0,d.useRef)();return(0,d.useEffect)((function(){var e=function(){r(Yr()),i(Xr())};return window.addEventListener("resize",e),pn(un.VIEW,ln.INTRO),function(){window.removeEventListener("resize",e)}}),[]),(0,d.useEffect)((function(){document.body.style.setProperty("--from-clip-path",ea(64)),document.body.style.setProperty("--to-clip-path",ea(Math.max(.7*n,.4*o)))}),[n,o]),d.createElement("section",{className:"overlay",ref:l},e.route!==Za.READY&&d.createElement("div",{className:"container"},d.createElement("div",{className:"masthead"},d.createElement("h1",null,Se("intro.header")),d.createElement("h2",null,Se("intro.subheader"))),d.createElement("button",{className:"singular get-started",onClick:e.start},Se("intro.button"))))}const na=n.p+"7d53fec23372c39c9d12.jpg",ra=n.p+"11bbdce584eb010669fd.jpg",aa=n.p+"b2a202d6774b9d9503f9.jpg",oa=n.p+"3df11e64133f9949a6b2.jpg",ia=n.p+"9b08ddabfa1c4baac551.jpg",la=n.p+"313dd08924b1b4a517bb.jpg";function sa(e,t){var n="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(!n){if(Array.isArray(e)||(n=function(e,t){if(!e)return;if("string"==typeof e)return ua(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return ua(e,t)}(e))||t&&e&&"number"==typeof e.length){n&&(e=n);var r=0,a=function(){};return{s:a,n:function(){return r>=e.length?{done:!0}:{done:!1,value:e[r++]}},e:function(e){throw e},f:a}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var o,i=!0,l=!1;return{s:function(){n=n.call(e)},n:function(){var e=n.next();return i=e.done,e},e:function(e){l=!0,o=e},f:function(){try{i||null==n.return||n.return()}finally{if(l)throw o}}}}function ua(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}var ca;!function(e){e.ARIEL="bundled%2Fdefault_theme",e.ATMOSPHERE="bundled%2Fdefault_dark_theme",e.ETERNITY="opera-one-eternity",e.SHOW_TIME="opera-one-showtime",e.LOW_GLOW="opera-one-lowglow",e.DARK_LIGHT="opera-one-darklight"}(ca||(ca={}));var da=[{id:ca.ARIEL,src:na},{id:ca.ATMOSPHERE,src:ra},{id:ca.ETERNITY,src:oa},{id:ca.SHOW_TIME,src:la},{id:ca.LOW_GLOW,src:ia},{id:ca.DARK_LIGHT,src:aa}],fa=function(){return new Promise((function(e){opr.wallpapersPrivate.getSelected((function(t){e(t)}))}))},pa=function(){var e=t(c().mark((function e(t){return c().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,ha(t);case 2:if(!e.sent){e.next=6;break}va(t),e.next=8;break;case 6:return e.next=8,ga(t);case 8:case"end":return e.stop()}}),e)})));return function(t){return e.apply(this,arguments)}}(),ha=function(){var e=t(c().mark((function e(t){var n;return c().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,ma();case 2:return n=e.sent,e.abrupt("return",n.map((function(e){return e.id})).includes(t));case 4:case"end":return e.stop()}}),e)})));return function(t){return e.apply(this,arguments)}}(),ma=function(){return new Promise((function(e){opr.wallpapersPrivate.getInstalled((function(t){e(t)}))}))},ga=function(e){return new Promise((function(t){chrome.addonsPrivate.installTheme(e,t)}))},va=function(e){return new Promise((function(t){opr.wallpapersPrivate.select(e,t)}))},ba=new Set,ya=function(e){return ba.add(e),fa().then((function(t){e(t)})),function(){ba.delete(e)}},Ca=function(){var e=t(c().mark((function e(){var t,n,r;return c().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,fa();case 2:t=e.sent,n=sa(ba);try{for(n.s();!(r=n.n()).done;)(0,r.value)(t)}catch(e){n.e(e)}finally{n.f()}case 5:case"end":return e.stop()}}),e)})));return function(){return e.apply(this,arguments)}}();function ka(){return d.createElement("span",{className:"spinner"},d.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",xmlnsXlink:"http://www.w3.org/1999/xlink",viewBox:"0 0 32 32"},d.createElement("defs",null,d.createElement("linearGradient",{id:"a",x1:"-102.13",y1:"91.03",x2:"-103.54",y2:"92.08",gradientTransform:"matrix(10.5 0 0 -8.75 1092.5 822)",gradientUnits:"userSpaceOnUse"},d.createElement("stop",{offset:"0",stopColor:"#fff",stopOpacity:"0"}),d.createElement("stop",{offset:"1",stopColor:"#c8c9d0"})),d.createElement("linearGradient",{id:"b",x1:"-103.1",y1:"92.71",x2:"-101.98",y2:"91.27",gradientTransform:"matrix(10.5 0 0 -8.75 1096 816.75)",xlinkHref:"#a"})),d.createElement("rect",{width:"32",height:"32",rx:"16",ry:"16",opacity:".6"}),d.createElement("g",null,d.createElement("path",{d:"M8 13.5a2 2 0 0 1 2 2.08 6.08 6.08 0 0 0 5.86 6.25 5.48 5.48 0 0 0 2.54-.62 1.88 1.88 0 0 1 2.54 1.09 2.1 2.1 0 0 1-.94 2.61A8.46 8.46 0 0 1 15.77 26C10.4 26 6 21.31 6 15.58a2 2 0 0 1 2-2.08z",fill:"url(#a)"}),d.createElement("path",{d:"M24.07 18.5a2 2 0 0 1-1.93-2.08 6.05 6.05 0 0 0-5.79-6.25 5.36 5.36 0 0 0-2.51.62 1.81 1.81 0 0 1-2.61-.79A2.14 2.14 0 0 1 12 7.15c.05-.06.15-.06.19-.11a8.82 8.82 0 0 1 4.16-1C21.66 6 26 10.69 26 16.42a2 2 0 0 1-1.93 2.08z",fill:"url(#b)"}))))}function wa(e){var n=s((0,d.useState)(!1),2),r=n[0],a=n[1],o=function(){var n=t(c().mark((function t(){return c().wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return a(!0),pn(un.CLICK,ln.WALLPAPERS,"choose_wallpaper"),t.next=4,pa(e.id);case 4:a(!1);case 5:case"end":return t.stop()}}),t)})));return function(){return n.apply(this,arguments)}}();return d.createElement("span",{onClick:r?void 0:o,className:Sn(["thumbnail",{selected:e.selected}])},d.createElement("span",{className:"image",style:{backgroundImage:"url(".concat(e.src,")")}}),r&&d.createElement(ka,null))}function Ea(){var e=s((0,d.useState)(null),2),t=e[0],n=e[1];return(0,d.useEffect)((function(){return ya((function(e){n(e.id)}))}),[]),d.createElement(xn,null,d.createElement("div",{className:"thumbnails"},da.map((function(e){return d.createElement(wa,{key:e.id,id:e.id,src:e.src,selected:t===e.id})}))))}function xa(){return d.createElement(On,{name:"chrome-data-imported"},d.createElement("span",null,Se("import.tooltip")),d.createElement("i",{style:{backgroundImage:"url(".concat(wr(Cr.CHROME),")")}}))}function Sa(){return d.createElement(On,{name:"edge-data-imported"},d.createElement("span",null,Se("import.tooltip")),d.createElement("i",{style:{backgroundImage:"url(".concat(wr(Cr.EDGE),")")}}))}function Oa(){return d.createElement(On,{name:"safari-data-imported"},d.createElement("span",null,Se("import.tooltip")),d.createElement("i",{style:{backgroundImage:"url(".concat(wr(Cr.SAFARI),")")}}))}function La(){return d.createElement(On,{name:"firefox-data-imported"},d.createElement("span",null,Se("import.tooltip")),d.createElement("i",{style:{backgroundImage:"url(".concat(wr(Cr.FIREFOX),")")}}))}function _a(){return d.createElement("svg",{style:{display:"none"},id:"svgfilters",xmlns:"http://www.w3.org/2000/svg"},d.createElement("defs",null,d.createElement("filter",{id:"cobalt-blue",x:"-10%",y:"-10%",width:"120%",height:"120%",filterUnits:"objectBoundingBox",primitiveUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},d.createElement("feColorMatrix",{type:"matrix",values:"1 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0",in:"SourceGraphic",result:"colormatrix"}),d.createElement("feComponentTransfer",{in:"colormatrix",result:"componentTransfer"},d.createElement("feFuncR",{type:"table",tableValues:"0.31"}),d.createElement("feFuncG",{type:"table",tableValues:"0.2"}),d.createElement("feFuncB",{type:"table",tableValues:"0.8"}),d.createElement("feFuncA",{type:"table",tableValues:"0 1"})),d.createElement("feBlend",{mode:"color",in:"componentTransfer",in2:"SourceGraphic",result:"blend"}))))}function Pa(){return d.createElement("span",{className:"tick"},d.createElement("svg",{width:"24",height:"25",viewBox:"0 0 24 25",fill:"none",xmlns:"http://www.w3.org/2000/svg"},d.createElement("g",{filter:"url(#filter0_d_1031_4121)"},d.createElement("circle",{cx:"12.0013",cy:"10.0006",r:"5.75056",fill:"white",stroke:"#E6EEF5",strokeWidth:"0.500049"}),d.createElement("path",{d:"M11.6014 12.5008H12.401V10.4066H14.5015V9.60521H12.401V7.50031H11.6014V9.60521H9.50098V10.4066H11.6014V12.5008Z",fill:"#6D7F90"}),d.createElement("circle",{cx:"12.0028",cy:"10.0006",r:"6.00058",fill:"#5021FF"}),d.createElement("path",{d:"M11.0432 12.4245L8.77246 10.1538L9.4128 9.51343L11.0432 11.1393L14.4901 7.69232L15.1304 8.3372L11.0432 12.4245Z",fill:"white"})),d.createElement("defs",null,d.createElement("filter",{id:"filter0_d_1031_4121",x:"0.285893",y:"0.571096",width:"23.4324",height:"23.4308",filterUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},d.createElement("feFlood",{floodOpacity:"0",result:"BackgroundImageFix"}),d.createElement("feColorMatrix",{in:"SourceAlpha",type:"matrix",values:"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0",result:"hardAlpha"}),d.createElement("feOffset",{dy:"2.28594"}),d.createElement("feGaussianBlur",{stdDeviation:"2.85742"}),d.createElement("feComposite",{in2:"hardAlpha",operator:"out"}),d.createElement("feColorMatrix",{type:"matrix",values:"0 0 0 0 0.438924 0 0 0 0 0.536296 0 0 0 0 0.61941 0 0 0 0.2 0"}),d.createElement("feBlend",{mode:"normal",in2:"BackgroundImageFix",result:"effect1_dropShadow_1031_4121"}),d.createElement("feBlend",{mode:"normal",in:"SourceGraphic",in2:"effect1_dropShadow_1031_4121",result:"shape"})))))}function Na(e){var n=e.browser,r=n.icon,a=n.importer,o=n.imported,i=n.label,l=s((0,d.useState)(!1),2),u=l[0],f=l[1],p=function(){var n=t(c().mark((function t(){return c().wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return f(!0),t.next=3,e.onImport(e.browser);case 3:f(!1);case 4:case"end":return t.stop()}}),t)})));return function(){return n.apply(this,arguments)}}();return d.createElement("span",{onClick:o||!a||u?void 0:p,className:Sn(["browser",{disabled:!a,available:a&&!o,imported:o}])},d.createElement("i",{className:"browser-icon",style:{backgroundImage:"url(".concat(r,")")}}),d.createElement("span",{className:"browser-name"},i),u&&d.createElement(ka,null),d.createElement(Pa,null))}function Ma(e){var t=document.documentElement.dataset;t.lastImport=e.name,setTimeout((function(){t.lastImport===e.name&&delete t.lastImport}),5e3)}function Aa(){var e=s((0,d.useState)([]),2),n=e[0],r=e[1];(0,d.useEffect)((function(){Lr().then(r)}),[]);var a=function(){var e=t(c().mark((function e(t){return c().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return pn(un.CLICK,ln.IMPORT,"import_button:".concat(t.key)),e.next=3,Or(t.importer);case 3:e.sent&&(Ma(t),Lr().then(r));case 5:case"end":return e.stop()}}),e)})));return function(t){return e.apply(this,arguments)}}();return d.createElement(xn,null,d.createElement(_a,null),d.createElement("div",{className:"browsers"},n.map((function(e){return d.createElement(Na,{key:e.name,onImport:a,browser:e})}))))}opr.wallpapersPrivate.onSelectionChanged.addListener(Ca);var Ia=["#5021ff","#e24c5e","#ef8d4b","#eec574","#58c095","#7bc6d7","#2e78f6","#aa78df"],Fa=function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:500,t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;return Math.floor(Math.random()*e+t)},Ra=function(){return Math.floor(Math.random()*window.innerWidth)},Va=function(){return Math.floor(Math.random()*window.innerHeight)};function ja(e){var t=s((0,d.useState)(Ra()),2),n=t[0],r=t[1],a=s((0,d.useState)(Va()),2),o=a[0],i=a[1],l=s((0,d.useState)(Fa(2e3,3e3)),2),u=l[0],c=l[1],f=(0,d.useRef)();return(0,d.useEffect)((function(){var e=new KeyframeEffect(f.current,[{transform:"translateY(0)",opacity:1},{transform:"translateY(-120px)",opacity:0}],{easing:"cubic-bezier(0.4, 1, 0.4, 1)",duration:1e3,delay:u,fill:"forwards"}),t=new Animation(e,document.timeline);t.play(),t.onfinish=function(){r(Ra()),i(Va()),c(Fa(1e3,200))}}),[n,o,u]),d.createElement("span",{key:e.id,className:"tab",style:{left:"".concat(n,"px"),top:"".concat(o,"px")}},d.createElement("span",{ref:f,className:"handle",style:{backgroundColor:e.color}}))}function za(e){var t=d.useState([].concat(Ia,Ia).map((function(e,t){return{color:e,id:"h".concat(t+1)}}))),n=s(t,1)[0];return d.createElement("div",{className:"fireworks",onClick:e.onBackgroundClick},n.map((function(e){return d.createElement(ja,{key:e.id,id:e.id,color:e.color})})))}function Ta(){return d.createElement("span",{className:"aria-icon"},d.createElement("svg",{width:"129",height:"130",viewBox:"0 0 129 130",fill:"none",xmlns:"http://www.w3.org/2000/svg"},d.createElement("g",{filter:"url(#filter0_d_723_44105)"},d.createElement("rect",{x:"29",y:"19",width:"70.7967",height:"70.7967",rx:"17.6992",fill:"var(--popup-background-color)"}),d.createElement("g",{clipPath:"url(#clip0_723_44105)"},d.createElement("rect",{x:"46.6992",y:"36.6992",width:"35.3983",height:"35.3983",rx:"8.87632",fill:"black"}),d.createElement("g",{filter:"url(#filter1_f_723_44105)"},d.createElement("path",{d:"M39.7791 70.9927C37.6951 68.9467 37.9503 64.4285 37.4399 56.8414C36.887 49.2969 35.5261 38.7261 39.3113 35.6572C43.0965 32.6308 52.0278 37.1064 56.0682 42.6049C60.1085 48.0608 59.2154 54.5397 58.5349 58.8874C57.8544 63.235 57.3441 65.4089 56.1107 67.2843C54.8348 69.1598 52.8359 70.6517 49.561 71.632C46.3287 72.6124 41.8631 73.0386 39.7791 70.9927Z",fill:"#82F8FF"})),d.createElement("g",{filter:"url(#filter2_f_723_44105)"},d.createElement("path",{d:"M98.3368 92.6744C93.2422 97.1081 86.6793 101.343 83.0507 99.0107C79.4221 96.6779 78.6493 87.742 74.5542 81.49C70.4402 75.2805 62.9647 71.7374 61.0692 66.2648C59.1154 60.817 62.7226 53.4821 67.8971 46.4408C73.0717 39.3994 79.7552 32.6764 87.657 30.5134C95.5397 28.3927 104.62 30.7721 108.267 37.0778C111.932 43.3411 110.124 53.513 109.667 61.1881C109.171 68.8455 109.969 74.0307 108.553 78.8883C107.138 83.7459 103.452 88.3006 98.3368 92.6744Z",fill:"#4865FF"})),d.createElement("g",{filter:"url(#filter3_f_723_44105)"},d.createElement("path",{d:"M68.6905 69.1471C69.5564 71.0295 68.0455 73.4954 65.9389 73.8912C63.8442 74.2802 61.147 72.5872 59.3964 71.468C57.639 70.3369 56.8231 69.7982 56.354 69.1223C55.8849 68.4465 55.7626 67.6336 54.8368 66.3852C53.9296 65.1419 52.2239 63.4445 52.2708 62.1868C52.3059 60.9359 54.1056 60.1177 55.8293 59.7694C57.5649 59.4143 59.2246 59.5289 60.1353 60.4231C61.051 61.2986 61.2127 62.9723 62.9056 64.4562C64.6054 65.9519 67.8295 67.246 68.6905 69.1471Z",fill:"#9712FF"})),d.createElement("g",{filter:"url(#filter4_f_723_44105)"},d.createElement("path",{d:"M72.5201 35.0537C75.9762 36.9231 79.6545 41.579 79.3336 45.7764C79.0373 50.009 74.7419 53.7831 71.2858 54.3122C67.805 54.8413 65.1635 52.1606 63.4355 50.8556C61.7074 49.5505 60.8927 49.6563 57.5601 49.1272C54.2521 48.5629 48.4508 47.3989 46.0068 42.743C43.5628 38.0518 44.4515 29.904 47.7842 28.0346C51.0922 26.1299 56.7948 30.5742 61.2877 32.3378C65.7807 34.1014 69.0393 33.1843 72.5201 35.0537Z",fill:"#FF8051"})),d.createElement("path",{d:"M67.1726 48.594L65.3485 45.4538C64.9757 44.812 64.0488 44.8117 63.6755 45.4533L55.8597 58.887C55.6842 59.1887 55.6847 59.5614 55.8611 59.8625L57.6822 62.9726C58.0563 63.6115 58.98 63.6107 59.353 62.9712L67.1718 49.5676C67.3472 49.2669 67.3475 48.8951 67.1726 48.594Z",fill:"white"}),d.createElement("path",{d:"M66.5295 54.255H66.1847C65.4407 54.255 64.9751 55.0597 65.3459 55.7048L69.5161 62.9595C69.8859 63.6028 70.8123 63.6076 71.1888 62.9683L73.0396 59.8252C73.2178 59.5225 73.218 59.1471 73.0402 58.8442L72.2771 57.545C71.0801 55.5068 68.8932 54.255 66.5295 54.255Z",fill:"white"}))),d.createElement("defs",null,d.createElement("filter",{id:"filter0_d_723_44105",x:"0.156917",y:"0.645312",width:"128.483",height:"128.483",filterUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},d.createElement("feFlood",{floodOpacity:"0",result:"BackgroundImageFix"}),d.createElement("feColorMatrix",{in:"SourceAlpha",type:"matrix",values:"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0",result:"hardAlpha"}),d.createElement("feMorphology",{radius:"2.6221",operator:"erode",in:"SourceAlpha",result:"effect1_dropShadow_723_44105"}),d.createElement("feOffset",{dy:"10.4884"}),d.createElement("feGaussianBlur",{stdDeviation:"15.7326"}),d.createElement("feComposite",{in2:"hardAlpha",operator:"out"}),d.createElement("feColorMatrix",{type:"matrix",values:"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.45 0"}),d.createElement("feBlend",{mode:"normal",in2:"BackgroundImageFix",result:"effect1_dropShadow_723_44105"}),d.createElement("feBlend",{mode:"normal",in:"SourceGraphic",in2:"effect1_dropShadow_723_44105",result:"shape"})),d.createElement("filter",{id:"filter1_f_723_44105",x:"22.2448",y:"20.1815",width:"51.3781",height:"66.7655",filterUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},d.createElement("feFlood",{floodOpacity:"0",result:"BackgroundImageFix"}),d.createElement("feBlend",{mode:"normal",in:"SourceGraphic",in2:"BackgroundImageFix",result:"shape"}),d.createElement("feGaussianBlur",{stdDeviation:"7.24919",result:"effect1_foregroundBlur_723_44105"})),d.createElement("filter",{id:"filter2_f_723_44105",x:"46.0319",y:"15.2578",width:"78.9831",height:"98.9139",filterUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},d.createElement("feFlood",{floodOpacity:"0",result:"BackgroundImageFix"}),d.createElement("feBlend",{mode:"normal",in:"SourceGraphic",in2:"BackgroundImageFix",result:"shape"}),d.createElement("feGaussianBlur",{stdDeviation:"7.24919",result:"effect1_foregroundBlur_723_44105"})),d.createElement("filter",{id:"filter3_f_723_44105",x:"37.7716",y:"45.0839",width:"45.6657",height:"43.3626",filterUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},d.createElement("feFlood",{floodOpacity:"0",result:"BackgroundImageFix"}),d.createElement("feBlend",{mode:"normal",in:"SourceGraphic",in2:"BackgroundImageFix",result:"shape"}),d.createElement("feGaussianBlur",{stdDeviation:"7.24919",result:"effect1_foregroundBlur_723_44105"})),d.createElement("filter",{id:"filter4_f_723_44105",x:"30.1169",y:"13.0709",width:"63.7345",height:"55.8079",filterUnits:"userSpaceOnUse",colorInterpolationFilters:"sRGB"},d.createElement("feFlood",{floodOpacity:"0",result:"BackgroundImageFix"}),d.createElement("feBlend",{mode:"normal",in:"SourceGraphic",in2:"BackgroundImageFix",result:"shape"}),d.createElement("feGaussianBlur",{stdDeviation:"7.24919",result:"effect1_foregroundBlur_723_44105"})),d.createElement("clipPath",{id:"clip0_723_44105"},d.createElement("rect",{x:"46.6992",y:"36.6992",width:"35.3983",height:"35.3983",rx:"8.87632",fill:"white"})))))}function Ha(e){return d.createElement("button",{className:"singular start-browsing",onClick:e.onClick},Se("outro.button"))}function Da(e){return d.createElement(d.Fragment,null,d.createElement(za,{onBackgroundClick:e.browse}),d.createElement("section",{className:"browser-preview"},d.createElement($r,{config:{feature:Wa.NONE,width:680,height:442}},d.createElement(Ta,null),d.createElement(Ha,{onClick:e.browse}))))}function Ba(e,t){var n="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(!n){if(Array.isArray(e)||(n=function(e,t){if(!e)return;if("string"==typeof e)return Ua(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return Ua(e,t)}(e))||t&&e&&"number"==typeof e.length){n&&(e=n);var r=0,a=function(){};return{s:a,n:function(){return r>=e.length?{done:!0}:{done:!1,value:e[r++]}},e:function(e){throw e},f:a}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var o,i=!0,l=!1;return{s:function(){n=n.call(e)},n:function(){var e=n.next();return i=e.done,e},e:function(e){l=!0,o=e},f:function(){try{i||null==n.return||n.return()}finally{if(l)throw o}}}}function Ua(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}var Za,Wa,Ga,Ka=new Set,$a=function(){var e=t(c().mark((function e(){return c().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,new Promise((function(e){chrome.tabs.getCurrent(e)}));case 2:return e.abrupt("return",!e.sent);case 3:case"end":return e.stop()}}),e)})));return function(){return e.apply(this,arguments)}}(),Ja=function(e){return Ka.add(e),$a().then((function(t){e(t)})),function(){Ka.delete(e)}},Qa=function(){var e=t(c().mark((function e(){var t,n,r;return c().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,$a();case 2:t=e.sent,n=Ba(Ka);try{for(n.s();!(r=n.n()).done;)(0,r.value)(t)}catch(e){n.e(e)}finally{n.f()}case 5:case"end":return e.stop()}}),e)})));return function(){return e.apply(this,arguments)}}();chrome.tabs.onActivated.addListener(Qa),function(e){e.WELCOME="welcome",e.SETUP="setup",e.READY="ready"}(Za||(Za={})),function(e){e.NONE="none",e.WALLPAPER="wallpaper",e.THEME="theme",e.ADBLOCKER="adblocker",e.IMPORT="import",e.MESSENGERS="messengers"}(Wa||(Wa={})),function(e){e.INTRO="intro_slide",e.THEME="theme_slide",e.SECURITY="security_slide",e.SD="sd_slide",e.MESSENGERS="messengers_slide",e.IMPORT="import_slide",e.OUTRO="outro_slide"}(Ga||(Ga={}));var qa=function(){var e=s((0,d.useState)([]),2),n=e[0],r=e[1],a=s((0,d.useState)(!1),2),o=a[0],i=a[1],l=s((0,d.useState)(null),2),u=l[0],f=l[1],p=s((0,d.useState)(Za.WELCOME),2),h=p[0],m=p[1],g=s((0,d.useState)(!0),2),v=g[0],b=g[1],y=s(d.useState(!1),2),C=y[0],k=y[1],w=s((0,d.useState)(!1),2),E=w[0],x=w[1];d.useEffect((function(){var e=Ja(b),t=En(i),n=ya((function(e){if(Object.values(ca).includes(e.id)){var t=da.find((function(t){return t.id===e.id}));f(t.src)}else f(null)})),a=function(e){Pr.add(e);var t=_r();return e(t),function(){Pr.delete(e)}}(r);return function(){e(),t(),n(),a()}}),[]);return document.fonts.addEventListener("loading",t(c().mark((function e(){return c().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,document.fonts.load("16px 'Space Mono'");case 2:return e.next=4,document.fonts.load("16px 'Averta'");case 4:k(!0);case 5:case"end":return e.stop()}}),e)})))),d.createElement("main",{className:Sn(["opera-intro",h,{"with-ad-blocker":o,"with-wallpaper":!!u,hidden:!C}]),onContextMenuCapture:function(e){e.preventDefault(),e.stopPropagation()}},d.createElement(ta,{route:h,start:function(){m(Za.SETUP),pn(un.CLICK,ln.INTRO,"launch_button")}}),d.createElement("section",{className:"contents",onAnimationEnd:function(e){"enter-portal"===e.animationName&&x(!0)}},d.createElement("div",{className:"background"}),d.createElement("div",{className:"wallpaper"}),d.createElement("i",{className:"opera-logo"}),d.createElement(Fn,{route:h,isOverlay:v,isInitialized:E,markAsReady:function(){m(Za.READY)}},d.createElement(rr,{name:Wa.THEME,section:ln.THEME,title:Se("themes.header"),subtitle:Se("themes.subheader")},d.createElement($r,{config:{feature:Wa.THEME}}),d.createElement(qr,null)),d.createElement(rr,{name:Wa.WALLPAPER,section:ln.WALLPAPERS,title:Se("wallpapers.header"),subtitle:Se("wallpapers.subheader")},d.createElement($r,{config:{feature:Wa.WALLPAPER,wallpaper:u}}),d.createElement(Ea,null)),d.createElement(rr,{name:Wa.ADBLOCKER,section:ln.ADBLOCK,title:Se("adblocker.header"),subtitle:Se("adblocker.subheader")},d.createElement($r,{config:{feature:Wa.ADBLOCKER,adblocker:o}},d.createElement(Ln,null)),d.createElement(Pn,null)),d.createElement(rr,{name:Wa.MESSENGERS,section:ln.MESSENGERS,title:Se("messengers.header"),subtitle:Se("messengers.subheader")},d.createElement($r,{config:{feature:Wa.MESSENGERS}}),d.createElement(nr,null)),d.createElement(rr,{name:Wa.IMPORT,section:ln.IMPORT,title:Se("import.header"),subtitle:Se("import.subheader")},d.createElement($r,{config:{feature:Wa.IMPORT,imports:n}},d.createElement(xa,null),d.createElement(Sa,null),d.createElement(Oa,null),d.createElement(La,null)),d.createElement(Aa,null)),d.createElement(rr,{name:"summary",section:ln.OUTRO,title:Se("outro.header"),subtitle:Se("outro.subheader")},d.createElement(Da,{browse:function(){pn(un.CLICK,ln.OUTRO,"start_browsing"),v?Mn(!1):chrome.tabs.update(void 0,{url:"chrome://startpageshared"})}})))))},Ya=document.getElementById("root");document.body.parentNode&&Ya&&(0,Oe.s)(Ya).render(d.createElement(qa,null))})()})();