#!/bin/bash
#
# Runs FrostWire.  This script must be executed in your FrostWire
# install directory.

cd "`dirname "$0"`"

export HOSTNAME=`hostname`
echo HOSTNAME IS ${HOSTNAME}

# verify our java distribution is there
export JAVA_PROGRAM_DIR=/usr/lib/frostwire/jre/bin

if [ ! -d ${JAVA_PROGRAM_DIR} ]; then
   if [ -d "./jre/bin" ]; then
     export JAVA_PROGRAM_DIR=`pwd`/jre/bin
   fi
fi

MSG_LOADING_FROSTWIRE="Loading FrostWire:"
MSG_STARTING_FROSTWIRE="Starting FrostWire..."
MSG_JAVA_EXEC_FOUND_IN="Java exec found in "
MSG_JAVA_VERSION_TOO_OLD="OOPS, your java version is too old "
MSG_YOU_NEED_TO_UPGRADE_TO_JRE_OR_NEWER="You need to upgrade to JRE 14 or newer from http://www.java.com"
MSG_SUITABLE_JAVA_VERSION_FOUND="Suitable java version found "
MSG_CONFIGURING_ENVIRONMENT="Configuring environment..."
MSG_OOPS_INVALID_JRE="OOPS, for some reason the built-in Java Runtime Environment is not here. It should be either in /usr/lib/frostwire/jre for .deb installs or in a jre folder along with this script"
MSG_UNABLE_TO_LOCATE_JAVA_EXEC_IN="OOPS, unable to locate java exec in "
MSG_HIERARCHY=" hierarchy"
MSG_JAVA_EXEC_NOT_FOUND_IN_PATH_STARTING_SEARCH="Java exec not found in PATH, starting auto-search..."
MSG_JAVA_EXEC_FOUND_IN_PATH_VERIFYING="Java exec found in PATH. Verifying..."
MSG_I_CANT_FIND_YOUR_JAVA_RUNTIME_ENVIRONMENT="I can't find your Java Runtime Environment..."
MSG_DO_YOU_WANT_ME_TO_INSTALL_JAVA="Do you want me to install the Java Runtime Environment 14 for you (openjdk-14-jre-headless) [y/n]?"

CLASSPATH=
PS=":"

command_exists() {
  command -v "$1" > /dev/null
}

check_version()
{
  # short-circuit gcj
  JAVA_CMD=${JAVA_PROGRAM_DIR}/java

  VALID_JAVA_VERSION_FOUND=$(${JAVA_CMD} -version 2>&1 | egrep 'java|openjdk')
  if [ -z "$VALID_JAVA_VERSION_FOUND" ]; then
      echo $MSG_OOPS_INVALID_JRE BOOM
      return 1
  fi

  VERSION=$(${JAVA_CMD} -version 2>&1 | awk -F '"' '/version/ {print $2}')

  if echo $VERSION | grep "^1.[0-6]" ; then
      echo $MSG_JAVA_VERSION_TOO_OLD "[${JAVA_CMD} = ${VERSION}]" ; echo $MSG_YOU_NEED_TO_UPGRADE_TO_JRE_OR_NEWER
      return 1
  else
      echo $MSG_SUITABLE_JAVA_VERSION_FOUND "[${JAVA_CMD} = ${VERSION}]" ; echo $MSG_CONFIGURING_ENVIRONMENT
      return 0	      
  fi
}

echo $MSG_STARTING_FROSTWIRE
echo $MSG_LOADING_FROSTWIRE

export J2SE_PREEMPTCLOSE=1

# if the invoking script provided us with an executable, pass it along
if echo "$1" | grep -q "\-Dunix.executable="
then
  EXECUTABLE=$1
  ARGUMENTS="$2 $3 $4 $5"
else
  # there was no executable, so just pass whatever arguments there were along
  EXECUTABLE=""
  ARGUMENTS=$*
fi

export LD_LIBRARY_PATH=`pwd`

${JAVA_PROGRAM_DIR}/java -Xms64m -Xmx512m -Xss256k -Djava.library.path=. --add-opens=java.desktop/java.awt=ALL-UNNAMED --add-opens=java.desktop/javax.swing=ALL-UNNAMED --add-exports=java.desktop/javax.swing=ALL-UNNAMED -jar frostwire.jar $1

if [ $? -ne 0 ]; then
    echo 
    echo ${JAVA_PROGRAM_DIR}
    echo "******************************************************************"
    echo "Something went wrong with FrostWire."
    echo "Maybe you're using the wrong version of Java?"
    echo "(FrostWire is tested against and works best with with OpenJDK 11+)"
    echo "The version of Java in your PATH is:"
    java -version
    echo 
fi
