/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.StatsMetric;
import com.frostwire.jlibtorrent.alerts.SessionStatsAlert;

public final class SessionStats {
    private static final int UPLOAD_PAYLOAD = 0;
    private static final int UPLOAD_PROTOCOL = 1;
    private static final int UPLOAD_IP_PROTOCOL = 2;
    private static final int DOWNLOAD_PAYLOAD = 3;
    private static final int DOWNLOAD_PROTOCOL = 4;
    private static final int DOWNLOAD_IP_PROTOCOL = 5;
    private static final int NUM_AVERAGES = 6;
    private final Average[] stat = new Average[6];
    private long lastTickTime;
    private long dhtNodes;

    SessionStats() {
        for (int i = 0; i < this.stat.length; ++i) {
            this.stat[i] = new Average();
        }
    }

    public long totalDownload() {
        return this.stat[3].total() + this.stat[4].total() + this.stat[5].total();
    }

    public long totalUpload() {
        return this.stat[0].total() + this.stat[1].total() + this.stat[2].total();
    }

    public long downloadRate() {
        return this.stat[3].rate() + this.stat[4].rate() + this.stat[5].rate();
    }

    public long uploadRate() {
        return this.stat[0].rate() + this.stat[1].rate() + this.stat[2].rate();
    }

    public long dhtNodes() {
        return this.dhtNodes;
    }

    void update(SessionStatsAlert alert2) {
        long now = System.currentTimeMillis();
        long tickIntervalMs = now - this.lastTickTime;
        this.lastTickTime = now;
        long received = alert2.value(StatsMetric.NET_RECV_BYTES_COUNTER_INDEX);
        long payload = alert2.value(StatsMetric.NET_RECV_PAYLOAD_BYTES_COUNTER_INDEX);
        long protocol = received - payload;
        long ip = alert2.value(StatsMetric.NET_RECV_IP_OVERHEAD_BYTES_COUNTER_INDEX);
        this.stat[3].add(payload -= this.stat[3].total());
        this.stat[4].add(protocol -= this.stat[4].total());
        this.stat[5].add(ip -= this.stat[5].total());
        long sent = alert2.value(StatsMetric.NET_SENT_BYTES_COUNTER_INDEX);
        payload = alert2.value(StatsMetric.NET_SENT_PAYLOAD_BYTES_COUNTER_INDEX);
        protocol = sent - payload;
        ip = alert2.value(StatsMetric.NET_SENT_IP_OVERHEAD_BYTES_COUNTER_INDEX);
        this.stat[0].add(payload -= this.stat[0].total());
        this.stat[1].add(protocol -= this.stat[1].total());
        this.stat[2].add(ip -= this.stat[2].total());
        this.tick(tickIntervalMs);
        this.dhtNodes = alert2.value(StatsMetric.DHT_NODES_GAUGE_INDEX);
    }

    void clear() {
        for (int i = 0; i < 6; ++i) {
            this.stat[i].clear();
        }
        this.dhtNodes = 0L;
    }

    private void tick(long tickIntervalMs) {
        for (int i = 0; i < 6; ++i) {
            this.stat[i].tick(tickIntervalMs);
        }
    }

    private static final class Average {
        private long totalCounter;
        private long counter;
        private long averageSec5;

        public void add(long count) {
            this.counter += count;
            this.totalCounter += count;
        }

        public void tick(long tickIntervalMs) {
            if (tickIntervalMs >= 1L) {
                long sample = this.counter * 1000L / tickIntervalMs;
                this.averageSec5 = this.averageSec5 * 4L / 5L + sample / 5L;
                this.counter = 0L;
            }
        }

        public long rate() {
            return this.averageSec5;
        }

        public long total() {
            return this.totalCounter;
        }

        public void clear() {
            this.counter = 0L;
            this.averageSec5 = 0L;
            this.totalCounter = 0L;
        }
    }
}

