/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import com.frostwire.util.Logger;
import com.frostwire.util.OSUtils;
import java.awt.Component;
import java.io.File;
import java.io.IOException;

public class SystemUtils {
    private static final Logger LOG = Logger.getLogger(SystemUtils.class);
    private static final boolean isLoaded;

    private SystemUtils() {
    }

    static void setWriteable(String fileName) {
        if (isLoaded && (OSUtils.isWindows() || OSUtils.isMacOSX())) {
            SystemUtils.setFileWriteable(fileName);
        }
    }

    public static String getRunningPath() {
        try {
            if (OSUtils.isWindows() && isLoaded) {
                String path = SystemUtils.getRunningPathNative();
                return path.equals("") ? null : path;
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static String getSpecialPath(SpecialLocations location) {
        if (OSUtils.isWindows() && isLoaded) {
            try {
                String path = SystemUtils.getSpecialPathNative(location.getName());
                if (!path.equals("")) {
                    return path;
                }
            }
            catch (UnsatisfiedLinkError error) {
                LOG.error("Unable to use getSpecialPath!", error);
            }
        }
        return null;
    }

    public static void setWindowIcon(Component frame, File icon) {
        if (OSUtils.isWindows() && isLoaded) {
            SystemUtils.setWindowIconNative(frame, System.getProperty("sun.boot.library.path"), icon.getPath());
        }
    }

    public static long getWindowHandle(Component frame) {
        if ((OSUtils.isWindows() || OSUtils.isLinux()) && isLoaded) {
            return SystemUtils.getWindowHandleNative(frame, System.getProperty("sun.boot.library.path"));
        }
        return 0L;
    }

    public static boolean toggleFullScreen(long hwnd) {
        return isLoaded && (OSUtils.isWindows() || OSUtils.isLinux()) && SystemUtils.toggleFullScreenNative(hwnd);
    }

    public static void flushIconCache() {
        if (isLoaded && OSUtils.isWindows()) {
            SystemUtils.flushIconCacheNative();
        }
    }

    public static String registryReadText(String root, String path, String name) throws IOException {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.registryReadTextNative(root, path, name);
        }
        throw new IOException(" not supported ");
    }

    public static void registryWriteNumber(String root, String path, String name, int value) {
        if (OSUtils.isWindows() && isLoaded) {
            SystemUtils.registryWriteNumberNative(root, path, name, value);
        }
    }

    public static void registryWriteText(String root, String path, String name, String value) {
        if (OSUtils.isWindows() && isLoaded) {
            SystemUtils.registryWriteTextNative(root, path, name, value);
        }
    }

    public static void registryDelete(String root, String path) {
        if (OSUtils.isWindows() && isLoaded) {
            SystemUtils.registryDeleteNative(root, path);
        }
    }

    public static boolean isProgramListedOnFirewall(String path) {
        return OSUtils.isWindows() && isLoaded && SystemUtils.firewallIsProgramListedNative(path);
    }

    public static boolean addProgramToFirewall(String path, String name) {
        return OSUtils.isWindows() && isLoaded && SystemUtils.firewallAddNative(path, name);
    }

    public static void removeProgramFromFirewall(String path) {
        if (OSUtils.isWindows() && isLoaded) {
            SystemUtils.firewallRemoveNative(path);
        }
    }

    public static int openURL(String url) throws IOException {
        if (OSUtils.isWindows() && isLoaded) {
            SystemUtils.openURLNative(url);
            return 0;
        }
        throw new IOException("native code not linked");
    }

    public static int openFile(String path) throws IOException {
        if (OSUtils.isWindows() && isLoaded) {
            SystemUtils.openFileNative(path);
            return 0;
        }
        throw new IOException("native code not linked");
    }

    public static void openFile(String path, String params) throws IOException {
        if (OSUtils.isWindows() && isLoaded) {
            SystemUtils.openFileParamsNative(path, params);
            return;
        }
        throw new IOException("native code not linked");
    }

    public static String getShortFileName(String fileName) {
        return OSUtils.isWindows() && isLoaded ? SystemUtils.getShortFileNameNative(fileName) : fileName;
    }

    static boolean recycle(File file) {
        if (OSUtils.isWindows() && isLoaded) {
            String path;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException err) {
                LOG.error("IOException", err);
                path = file.getAbsolutePath();
            }
            return SystemUtils.recycleNative(path);
        }
        return false;
    }

    public static String getDefaultExtensionHandler(String extension) {
        if (!OSUtils.isWindows() || !isLoaded) {
            return null;
        }
        if (!((String)extension).startsWith(".")) {
            extension = "." + (String)extension;
        }
        try {
            String progId = SystemUtils.registryReadText("HKEY_CLASSES_ROOT", (String)extension, "");
            return "".equals(progId) ? "" : SystemUtils.registryReadText("HKEY_CLASSES_ROOT", progId + "\\shell\\open\\command", "");
        }
        catch (IOException iox) {
            return null;
        }
    }

    public static String getDefaultMimeHandler(String mimeType) {
        String extension;
        if (!OSUtils.isWindows() || !isLoaded) {
            return null;
        }
        try {
            extension = SystemUtils.registryReadText("HKEY_CLASSES_ROOT", "MIME\\Database\\Content Type\\" + mimeType, "Extension");
        }
        catch (IOException iox) {
            return null;
        }
        return "".equals(extension) ? "" : SystemUtils.getDefaultExtensionHandler(extension);
    }

    private static native String getRunningPathNative();

    private static native String getSpecialPathNative(String var0);

    private static native String getShortFileNameNative(String var0);

    private static native void openURLNative(String var0);

    private static native void openFileNative(String var0);

    private static native void openFileParamsNative(String var0, String var1);

    private static native boolean recycleNative(String var0);

    private static native int setFileWriteable(String var0);

    private static native String setWindowIconNative(Component var0, String var1, String var2);

    private static native long getWindowHandleNative(Component var0, String var1);

    private static native boolean flushIconCacheNative();

    private static native boolean toggleFullScreenNative(long var0);

    private static native String registryReadTextNative(String var0, String var1, String var2) throws IOException;

    private static native boolean registryWriteNumberNative(String var0, String var1, String var2, int var3);

    private static native boolean registryWriteTextNative(String var0, String var1, String var2, String var3);

    private static native boolean registryDeleteNative(String var0, String var1);

    private static native boolean firewallIsProgramListedNative(String var0);

    private static native boolean firewallAddNative(String var0, String var1);

    private static native boolean firewallRemoveNative(String var0);

    static {
        boolean canLoad = false;
        try {
            if (OSUtils.isWindows() && OSUtils.isGoodWindows()) {
                System.loadLibrary("SystemUtilities");
                canLoad = true;
            }
            if (OSUtils.isMacOSX()) {
                System.loadLibrary("SystemUtilities");
                canLoad = true;
            }
            if (OSUtils.isLinux()) {
                System.loadLibrary("SystemUtilities");
                canLoad = true;
            }
        }
        catch (Throwable noGo) {
            System.out.println("ERROR: " + noGo.getMessage());
            canLoad = false;
        }
        isLoaded = canLoad;
        LOG.info("SystemUtilities dynamic library loaded? " + isLoaded);
    }

    public static enum SpecialLocations {
        DOCUMENTS("Documents"),
        DOWNLOADS("Downloads");

        private final String name;

        private SpecialLocations(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

