/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.text.Normalizer;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.limewire.util.AbstractI18NConverter;
import org.limewire.util.CommonUtils;
import org.limewire.util.ConverterObjectInputStream;

final class I18NConvertICU
extends AbstractI18NConverter {
    private BitSet _excluded;
    private Map<?, ?> _cMap;

    I18NConvertICU() throws IOException, ClassNotFoundException {
        BitSet bs = null;
        HashMap hm = null;
        InputStream fi = CommonUtils.getResourceStream("com/frostwire/util/excluded.dat");
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(fi));
        bs = (BitSet)ois.readObject();
        ois.close();
        fi = CommonUtils.getResourceStream("com/frostwire/util/caseMap.dat");
        ois = new ConverterObjectInputStream(new BufferedInputStream(fi));
        hm = (HashMap)ois.readObject();
        ois.close();
        this._excluded = bs;
        this._cMap = hm;
    }

    @Override
    public String getNorm(String s) {
        return this.convert(s);
    }

    @Override
    public String compose(String s) {
        return Normalizer.normalize(s, Normalizer.Form.NFC);
    }

    private String convert(String s) {
        String nfkd = Normalizer.normalize(s, Normalizer.Form.NFKD);
        StringBuilder buf = new StringBuilder();
        int len = nfkd.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c = nfkd.charAt(i2);
            if (this._excluded.get(c)) continue;
            String lower = (String)this._cMap.get(String.valueOf(c));
            if (lower != null) {
                buf.append(lower);
                continue;
            }
            buf.append(c);
        }
        return this.blockSplit(Normalizer.normalize(buf.toString(), Normalizer.Form.NFC));
    }
}

